/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001\u0002\u0013&\u0001JB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000bq\u0003A\u0011A/\t\u0011\t\u0004\u0001R1A\u0005\u0006\rDQa\u001a\u0001\u0005B!DQa\u001c\u0001\u0005BADQa\u001e\u0001\u0005BMCQ\u0001\u001f\u0001\u0005BMCQ!\u001f\u0001\u0005BMCQA\u001f\u0001\u0005BmDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005u\u0002\u0001\"\u0015\u0002@!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033B\u0011\"a\u001c\u0001#\u0003%\t!!\u0017\t\u0013\u0005E\u0004!%A\u0005\u0002\u0005e\u0003\"CA:\u0001\u0005\u0005I\u0011IA;\u0011!\t)\tAA\u0001\n\u0003\u0019\u0007\"CAD\u0001\u0005\u0005I\u0011AAE\u0011%\ty\tAA\u0001\n\u0003\n\t\nC\u0005\u0002 \u0002\t\t\u0011\"\u0001\u0002\"\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003c\u0003\u0011\u0011!C!\u0003g;\u0011\"a6&\u0003\u0003E\t!!7\u0007\u0011\u0011*\u0013\u0011!E\u0001\u00037Da\u0001\u0018\u0010\u0005\u0002\u0005M\b\"CA{=\u0005\u0005IQIA|\u0011%\tIPHA\u0001\n\u0003\u000bY\u0010C\u0005\u0003\u0004y\t\t\u0011\"!\u0003\u0006!I!q\u0003\u0010\u0002\u0002\u0013%!\u0011\u0004\u0002\u000f'V\u00147\u000f\u001e:j]\u001eLe\u000eZ3y\u0015\t1s%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0015*\u0003!\u0019\u0017\r^1msN$(B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011C\u0002\u00014oi\nu\t\u0005\u00025k5\tQ%\u0003\u00027K\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005QB\u0014BA\u001d&\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001e?\u001d\t!D(\u0003\u0002>K\u00059\u0001/Y2lC\u001e,\u0017BA A\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!!P\u0013\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001j\u0014\b\u0003\u0013:s!AS'\u000e\u0003-S!\u0001T\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0015BA\u001fD\u0013\t\u0001\u0016K\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002>\u0007\u000691\u000f\u001e:FqB\u0014X#\u0001+\u0011\u0005Q*\u0016B\u0001,&\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\tgR\u0014X\t\u001f9sA\u0005IA-\u001a7j[\u0016C\bO]\u0001\u000bI\u0016d\u0017.\\#yaJ\u0004\u0013!C2pk:$X\t\u001f9s\u0003)\u0019w.\u001e8u\u000bb\u0004(\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\ty{\u0006-\u0019\t\u0003i\u0001AQAU\u0004A\u0002QCQ\u0001W\u0004A\u0002QCQAW\u0004A\u0002Q\u000b1bY8mY\u0006$\u0018n\u001c8JIV\tA\r\u0005\u0002CK&\u0011am\u0011\u0002\u0004\u0013:$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\\\u0015\u0002\u000bQL\b/Z:\n\u00059\\'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001r!\rA%\u000f^\u0005\u0003gF\u00131aU3r!\tQW/\u0003\u0002wW\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001}!\ri\u00181\u0001\b\u0003}~\u0004\"AS\"\n\u0007\u0005\u00051)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\t9A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0003\u0019\u0015\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\u0007\u0003'\t9\"a\u0007\u0011\u0007\t\u000by!C\u0002\u0002\u0012\r\u00131!\u00118z\u0011\u001d\t)b\u0004a\u0001\u0003\u001b\t1a\u001d;s\u0011\u001d\tIb\u0004a\u0001\u0003\u001b\tQ\u0001Z3mS6Dq!!\b\u0010\u0001\u0004\ti!A\u0003d_VtG/A\u0005e_\u001e+gnQ8eKR1\u00111EA\u0018\u0003s\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003S)\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003[\t9C\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\t\u0004\u0005a\u0001\u0003g\t1a\u0019;y!\u0011\t)#!\u000e\n\t\u0005]\u0012q\u0005\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tY\u0004\u0005a\u0001\u0003G\t!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u00020\u0002B\u0005\u0015\u0013\u0011\n\u0005\u0007\u0003\u0007\n\u0002\u0019\u0001+\u0002\u00119,wOR5sgRDa!a\u0012\u0012\u0001\u0004!\u0016!\u00038foN+7m\u001c8e\u0011\u0019\tY%\u0005a\u0001)\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLHc\u00020\u0002R\u0005M\u0013Q\u000b\u0005\b%J\u0001\n\u00111\u0001U\u0011\u001dA&\u0003%AA\u0002QCqA\u0017\n\u0011\u0002\u0003\u0007A+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005m#f\u0001+\u0002^-\u0012\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003%)hn\u00195fG.,GMC\u0002\u0002j\r\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti'a\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005!A.\u00198h\u0015\t\t\t)\u0001\u0003kCZ\f\u0017\u0002BA\u0003\u0003w\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u000e\u0005-\u0005\u0002CAG1\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\n\u0005\u0004\u0002\u0016\u0006m\u0015QB\u0007\u0003\u0003/S1!!'D\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\u000b9J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAR\u0003S\u00032AQAS\u0013\r\t9k\u0011\u0002\b\u0005>|G.Z1o\u0011%\tiIGA\u0001\u0002\u0004\ti!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA<\u0003_C\u0001\"!$\u001c\u0003\u0003\u0005\r\u0001Z\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\u0016Q\u0017\u0005\n\u0003\u001bc\u0012\u0011!a\u0001\u0003\u001bA3\u0003AA]\u0003\u007f\u000b\t-!2\u0002H\u0006-\u0017QZAi\u0003'\u00042\u0001NA^\u0013\r\ti,\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019-ABE\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue2\u0002C-\u001a7j[2\u00023m\\;oi&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001e2tiJLgn\u001a\u0011ge>l\u0007\u0005Y:ue\u0002\u0004#-\u001a4pe\u0016\u0004\u0003mY8v]R\u0004\u0007e\\2dkJ\u0014XM\\2fg\u0002zg\r\t;iK\u0002\"W\r\\5nSR,'\u000f\t1eK2LW\u000e\u0019\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011JM\u0002\u00027m\\;oi\u0002\u0004\u0013n\u001d\u0011q_NLG/\u001b<fY\u0001*g/\u001a:zi\"Lgn\u001a\u0011u_\u0002\"\b.\u001a\u0011mK\u001a$\be\u001c4!i\",\u0007EZ5oC2\u0004C-\u001a7j[&$XM\u001d\u0011)G>,h\u000e^5oO\u00022'o\\7!i\",'\u0002\t\u0011!A\u0001\u0002C.\u001a4uS\u0001J7\u000f\t:fiV\u0014h.\u001a3/A%3\u0007\u0005Y2pk:$\b\rI5tA9,w-\u0019;jm\u0016d\u0003%\u001a<fef$\b.\u001b8hAQ|\u0007\u0005\u001e5fAILw\r\u001b;!_\u001a\u0004C\u000f[3!M&t\u0017\r\u001c\u0011eK2LW.\u001b;fe*\u0001\u0003\u0005\t\u0011!A!\u001aw.\u001e8uS:<\u0007E\u001a:p[\u0002\"\b.\u001a\u0011sS\u001eDG/\u000b\u0011jg\u0002\u0012X\r^;s]\u0016$g\u0006\t+iK\u00022WO\\2uS>t\u0007e];cgR\u0014\u0018N\\4`S:$W\r\u001f\u0011qKJ4wN]7tA\u0005\u00043-Y:f[M,gn]5uSZ,\u0007%\\1uG\"T\u0001\u0005\t\u0011!A\u0001:\b.\u001a8!g\u0016\f'o\u00195j]\u001e\u0004cm\u001c:!A\u0012,G.[7a])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI-\u0001+\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d:xo\u001e\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e<C\u0006I\u0014/O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!o^<h&\u00199bG\",'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005=\u0017!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAAk\u00031\u0019HO]5oO~3WO\\2t\u00039\u0019VOY:ue&tw-\u00138eKb\u0004\"\u0001\u000e\u0010\u0014\u000by\ti.!;\u0011\u0011\u0005}\u0017Q\u001d+U)zk!!!9\u000b\u0007\u0005\r8)A\u0004sk:$\u0018.\\3\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003BAv\u0003cl!!!<\u000b\t\u0005=\u0018qP\u0001\u0003S>L1\u0001UAw)\t\tI.\u0001\u0005u_N#(/\u001b8h)\t\t9(A\u0003baBd\u0017\u0010F\u0004_\u0003{\fyP!\u0001\t\u000bI\u000b\u0003\u0019\u0001+\t\u000ba\u000b\u0003\u0019\u0001+\t\u000bi\u000b\u0003\u0019\u0001+\u0002\u000fUt\u0017\r\u001d9msR!!q\u0001B\n!\u0015\u0011%\u0011\u0002B\u0007\u0013\r\u0011Ya\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\t\u0013y\u0001\u0016+U\u0013\r\u0011\tb\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tU!%!AA\u0002y\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\u0002\u0005\u0003\u0002z\tu\u0011\u0002\u0002B\u0010\u0003w\u0012aa\u00142kK\u000e$\b")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private int collationId;
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex x$0) {
        return SubstringIndex$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    private int collationId$lzycompute() {
        SubstringIndex substringIndex = this;
        synchronized (substringIndex) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.first().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public DataType dataType() {
        return this.strExpr().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.strExpr();
    }

    @Override
    public Expression second() {
        return this.delimExpr();
    }

    @Override
    public Expression third() {
        return this.countExpr();
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return CollationSupport.SubstringIndex.exec((UTF8String)((UTF8String)str), (UTF8String)((UTF8String)delim), (int)BoxesRunTime.unboxToInt((Object)count), (int)this.collationId());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(str, delim, count) -> CollationSupport.SubstringIndex.genCode((String)str, (String)delim, (String)count, (int)this.collationId()));
    }

    @Override
    public SubstringIndex withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.strExpr();
            }
            case 1: {
                return this.delimExpr();
            }
            case 2: {
                return this.countExpr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "strExpr";
            }
            case 1: {
                return "delimExpr";
            }
            case 2: {
                return "countExpr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes.$init$(this);
    }
}

