/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$;
import org.apache.spark.sql.catalyst.expressions.TimestampAdd$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(unit, quantity, timestamp) - Adds the specified number of units to the given timestamp.", arguments="\n    Arguments:\n      * unit - this indicates the units of datetime that you want to add.\n        Supported string values of `unit` are (case insensitive):\n          - \"YEAR\"\n          - \"QUARTER\" - 3 months\n          - \"MONTH\"\n          - \"WEEK\" - 7 days\n          - \"DAY\", \"DAYOFYEAR\"\n          - \"HOUR\"\n          - \"MINUTE\"\n          - \"SECOND\"\n          - \"MILLISECOND\"\n          - \"MICROSECOND\"\n      * quantity - this is the number of units of time that you want to add.\n      * timestamp - this is a timestamp (w/ or w/o timezone) to which you want to add.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(HOUR, 8, timestamp_ntz'2022-02-11 20:30:00');\n       2022-02-12 04:30:00\n      > SELECT _FUNC_(MONTH, 1, timestamp_ltz'2022-01-31 00:00:00');\n       2022-02-28 00:00:00\n      > SELECT _FUNC_(SECOND, -10, date'2022-01-01');\n       2021-12-31 23:59:50\n      > SELECT _FUNC_(YEAR, 10, timestamp'2000-01-01 01:02:03.123456');\n       2010-01-01 01:02:03.123456\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\tmd\u0001\u0002\u0017.\u0001jB\u0001\"\u0018\u0001\u0003\u0016\u0004%\tA\u0018\u0005\tO\u0002\u0011\t\u0012)A\u0005?\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\tE\t\u0015!\u0003k\u0011!q\u0007A!f\u0001\n\u0003I\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00026\t\u0011A\u0004!Q3A\u0005\u0002ED\u0001\"\u001e\u0001\u0003\u0012\u0003\u0006IA\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\u0006m\u0002!\t! \u0005\u0007m\u0002!\t!a\u0001\t\r\u0005-\u0001\u0001\"\u0011j\u0011\u0019\ti\u0001\u0001C!S\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011)\t)\u0004\u0001EC\u0002\u0013%\u0011q\u0007\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBa!!!\u0001\t\u0003r\u0006\"\u0002\u001a\u0001\t\u0003r\u0006bBAB\u0001\u0011E\u0013Q\u0011\u0005\n\u0003\u001f\u0003\u0011\u0011!C\u0001\u0003#C\u0011\"a'\u0001#\u0003%\t!!(\t\u0013\u0005M\u0006!%A\u0005\u0002\u0005U\u0006\"CA]\u0001E\u0005I\u0011AA[\u0011%\tY\fAI\u0001\n\u0003\ti\fC\u0005\u0002B\u0002\t\t\u0011\"\u0011\u0002D\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u00033\u0004\u0011\u0011!C\u0001\u00037D\u0011\"!9\u0001\u0003\u0003%\t%a9\t\u0013\u0005E\b!!A\u0005\u0002\u0005M\b\"CA\u007f\u0001\u0005\u0005I\u0011IA\u0000\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0012)aB\u0005\u000305\n\t\u0011#\u0001\u00032\u0019AA&LA\u0001\u0012\u0003\u0011\u0019\u0004\u0003\u0004wI\u0011\u0005!1\n\u0005\n\u0005\u001b\"\u0013\u0011!C#\u0005\u001fB\u0011B!\u0015%\u0003\u0003%\tIa\u0015\t\u0013\tuC%%A\u0005\u0002\u0005u\u0006\"\u0003B0I\u0005\u0005I\u0011\u0011B1\u0011%\u0011y\u0007JI\u0001\n\u0003\ti\fC\u0005\u0003r\u0011\n\t\u0011\"\u0003\u0003t\taA+[7fgR\fW\u000e]!eI*\u0011afL\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00021c\u0005A1-\u0019;bYf\u001cHO\u0003\u00023g\u0005\u00191/\u001d7\u000b\u0005Q*\u0014!B:qCJ\\'B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001e\u001c\u0001aE\u0004\u0001w}\u0012\u0015\n\u0014*\u0011\u0005qjT\"A\u0017\n\u0005yj#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ta\u0004)\u0003\u0002B[\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002D\r:\u0011A\bR\u0005\u0003\u000b6\nq\u0001]1dW\u0006<W-\u0003\u0002H\u0011\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA#.!\ta$*\u0003\u0002L[\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\b!J|G-^2u!\t\u0019&L\u0004\u0002U3:\u0011Q\u000bW\u0007\u0002-*\u0011q+O\u0001\u0007yI|w\u000e\u001e \n\u0003=K!!\u0012(\n\u0005mc&\u0001D*fe&\fG.\u001b>bE2,'BA#O\u0003\u0011)h.\u001b;\u0016\u0003}\u0003\"\u0001\u00193\u000f\u0005\u0005\u0014\u0007CA+O\u0013\t\u0019g*\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2O\u0003\u0015)h.\u001b;!\u0003!\tX/\u00198uSRLX#\u00016\u0011\u0005qZ\u0017B\u00017.\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\ncV\fg\u000e^5us\u0002\n\u0011\u0002^5nKN$\u0018-\u001c9\u0002\u0015QLW.Z:uC6\u0004\b%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012A\u001d\t\u0004\u001bN|\u0016B\u0001;O\u0005\u0019y\u0005\u000f^5p]\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}Q)\u00010\u001f>|yB\u0011A\b\u0001\u0005\u0006;&\u0001\ra\u0018\u0005\u0006Q&\u0001\rA\u001b\u0005\u0006]&\u0001\rA\u001b\u0005\ba&\u0001\n\u00111\u0001s)\u0015Ahp`A\u0001\u0011\u0015i&\u00021\u0001`\u0011\u0015A'\u00021\u0001k\u0011\u0015q'\u00021\u0001k)\u001dA\u0018QAA\u0004\u0003\u0013AQ!X\u0006A\u0002)DQ\u0001[\u0006A\u0002)DQA\\\u0006A\u0002)\fA\u0001\\3gi\u0006)!/[4ii\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005M\u0001#B*\u0002\u0016\u0005e\u0011bAA\f9\n\u00191+Z9\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b2\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019#!\b\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005%\u0002\u0003BA\u000e\u0003WIA!!\f\u0002\u001e\tAA)\u0019;b)f\u0004X-\u0001\u0007xSRDG+[7f5>tW\rF\u0002J\u0003gAQ\u0001\u001d\tA\u0002}\u000bAB_8oK&#\u0017J\\#wC2,\"!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005!A/[7f\u0015\t\t\u0019%\u0001\u0003kCZ\f\u0017\u0002BA$\u0003{\u0011aAW8oK&#\u0007fA\t\u0002LA\u0019Q*!\u0014\n\u0007\u0005=cJA\u0005ue\u0006t7/[3oi\u0006aa.\u001e7m'\u00064W-\u0012<bYR1\u0011QKA.\u0003?\u00022!TA,\u0013\r\tIF\u0014\u0002\u0004\u0003:L\bbBA/%\u0001\u0007\u0011QK\u0001\u0002c\"9\u0011\u0011\r\nA\u0002\u0005U\u0013AB7jGJ|7/A\u0005e_\u001e+gnQ8eKR1\u0011qMA:\u0003{\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[j\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003c\nYG\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t)h\u0005a\u0001\u0003o\n1a\u0019;y!\u0011\tI'!\u001f\n\t\u0005m\u00141\u000e\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tyh\u0005a\u0001\u0003O\n!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)\u00010a\"\u0002\f\"1\u0011\u0011\u0012\fA\u0002)\fqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u000eZ\u0001\rA[\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)%A\u00181SAK\u0003/\u000bI\nC\u0004^/A\u0005\t\u0019A0\t\u000f!<\u0002\u0013!a\u0001U\"9an\u0006I\u0001\u0002\u0004Q\u0007b\u00029\u0018!\u0003\u0005\rA]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyJK\u0002`\u0003C[#!a)\u0011\t\u0005\u0015\u0016qV\u0007\u0003\u0003OSA!!+\u0002,\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[s\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011WAT\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9LK\u0002k\u0003C\u000babY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005}&f\u0001:\u0002\"\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!2\u0011\t\u0005\u001d\u0017QZ\u0007\u0003\u0003\u0013TA!a3\u0002B\u0005!A.\u00198h\u0013\r)\u0017\u0011Z\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003'\u00042!TAk\u0013\r\t9N\u0014\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003+\ni\u000eC\u0005\u0002`z\t\t\u00111\u0001\u0002T\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!:\u0011\r\u0005\u001d\u0018Q^A+\u001b\t\tIOC\u0002\u0002l:\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty/!;\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003k\fY\u0010E\u0002N\u0003oL1!!?O\u0005\u001d\u0011un\u001c7fC:D\u0011\"a8!\u0003\u0003\u0005\r!!\u0016\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u000b\u0014\t\u0001C\u0005\u0002`\u0006\n\t\u00111\u0001\u0002T\u00061Q-];bYN$B!!>\u0003\b!I\u0011q\u001c\u0012\u0002\u0002\u0003\u0007\u0011Q\u000b\u0015\u0018\u0001\t-!\u0011\u0003B\n\u0005/\u0011IB!\b\u0003 \t\r\"Q\u0005B\u0015\u0005W\u00012\u0001\u0010B\u0007\u0013\r\u0011y!\f\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011)\"\u00010`\rVs5i\u0018\u0015v]&$H\u0006I9vC:$\u0018\u000e^=-AQLW.Z:uC6\u0004\u0018\u0006I\u0017!\u0003\u0012$7\u000f\t;iK\u0002\u001a\b/Z2jM&,G\r\t8v[\n,'\u000fI8gAUt\u0017\u000e^:!i>\u0004C\u000f[3!O&4XM\u001c\u0011uS6,7\u000f^1na:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\tm\u0011\u0001\"\u001c\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*h.\u001b;![\u0001\"\b.[:!S:$\u0017nY1uKN\u0004C\u000f[3!k:LGo\u001d\u0011pM\u0002\"\u0017\r^3uS6,\u0007\u0005\u001e5bi\u0002Jx.\u001e\u0011xC:$\b\u0005^8!C\u0012$gF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011TkB\u0004xN\u001d;fI\u0002\u001aHO]5oO\u00022\u0018\r\\;fg\u0002zg\r\t1v]&$\b\rI1sK\u0002B3-Y:fA%t7/\u001a8tSRLg/Z\u0015;\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#3\u0016\u000b%K\t\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI)V\u0003J#VI\u0015\u0012![\u0001\u001a\u0004%\\8oi\"\u001c(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012Sj\u0014(U\u0011\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t:V)R&#A5\u0002s\u0007\t3bsNT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\"\u0015)\u0017\u0012-A\t\"\u0015)W(G3\u0016\u000b%K\t\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t%P+J\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012S*\u0013(V)\u0016\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u00123+R\"P\u001d\u0012\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012S*\u0013'M\u0013N+5i\u0014(EE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5K5IU(T\u000b\u000e{e\n\u0012\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011+AE,\u0018M\u001c;jif\u0004S\u0006\t;iSN\u0004\u0013n\u001d\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011v]&$8\u000fI8gAQLW.\u001a\u0011uQ\u0006$\b%_8vA]\fg\u000e\u001e\u0011u_\u0002\nG\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQLW.Z:uC6\u0004\b%\f\u0011uQ&\u001c\b%[:!C\u0002\"\u0018.\\3ti\u0006l\u0007\u000f\t\u0015x_\u0001z'\u000fI<0_\u0002\"\u0018.\\3{_:,\u0017\u0006\t;pA]D\u0017n\u00195!s>,\be^1oi\u0002\"x\u000eI1eI:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!\u0011E\u0001\u0004\u0018)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003jT+SY\u0001BD\u0006\t;j[\u0016\u001cH/Y7q?:$(p\n\u001a1eIj\u0003GM\u00172c\u0001\u0012\u0004GO\u001a1uA\u0002t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\u0012$'\f\u00193[E\u0012\u0004\u0005\r\u001b;gAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\u001b>sE\u000b\u0013\u0017!c1\u0002C/[7fgR\fW\u000e]0mij<#\u0007\r\u001a3[A\nTfM\u0019!aAR\u0004\u0007\r\u001e1a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1eIj\u0003GM\u00173q\u0001\u0002\u0004G\u000f\u00191uA\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK*F\u0007>sE\t\f\u0011.cAb\u0003\u0005Z1uK\u001e\u0012\u0004G\r\u001a.aEj\u0003'M\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004GM\u0019.cIj3'\r\u00113gi*\u0014HO\u001b1\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"JV)\u0011*-AE\u0002D\u0006\t;j[\u0016\u001cH/Y7qOI\u0002\u0004\u0007M\u00171c5\u0002\u0014\u0007\t\u00192uA\u0012$\bM\u001a/cI\u001aD'\u000e\u001c(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00191[A\nT\u0006M\u0019!aER\u0004G\r\u001e1g9\n$g\r\u001b6m)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003(\u0005qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\u0017\u0003\u0015\u0019df\r\u00181\u00031!\u0016.\\3ti\u0006l\u0007/\u00113e!\taDeE\u0003%\u0005k\u0011\t\u0005E\u0005\u00038\turL\u001b6sq6\u0011!\u0011\b\u0006\u0004\u0005wq\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005\u007f\u0011IDA\tBEN$(/Y2u\rVt7\r^5p]R\u0002BAa\u0011\u0003J5\u0011!Q\t\u0006\u0005\u0005\u000f\n\t%\u0001\u0002j_&\u00191L!\u0012\u0015\u0005\tE\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0017!B1qa2LH#\u0003=\u0003V\t]#\u0011\fB.\u0011\u0015iv\u00051\u0001`\u0011\u0015Aw\u00051\u0001k\u0011\u0015qw\u00051\u0001k\u0011\u001d\u0001x\u0005%AA\u0002I\fq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ga\u001b\u0011\t5\u001b(Q\r\t\b\u001b\n\u001dtL\u001b6s\u0013\r\u0011IG\u0014\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\t5\u0014&!AA\u0002a\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!Q\u000f\t\u0005\u0003\u000f\u00149(\u0003\u0003\u0003z\u0005%'AB(cU\u0016\u001cG\u000f")
public class TimestampAdd
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
TimeZoneAwareExpression,
Serializable {
    private transient ZoneId zoneIdInEval;
    private final String unit;
    private final Expression quantity;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return TimestampAdd$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<String, Expression, Expression, Option<String>>> unapply(TimestampAdd x$0) {
        return TimestampAdd$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return TimestampAdd$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<String, Expression, Expression, Option<String>>, TimestampAdd> tupled() {
        return TimestampAdd$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Expression, Function1<Expression, Function1<Option<String>, TimestampAdd>>>> curried() {
        return TimestampAdd$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public String unit() {
        return this.unit;
    }

    public Expression quantity() {
        return this.quantity;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.quantity();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)AnyTimestampType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return this.timestamp().dataType();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        String x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    private ZoneId zoneIdInEval$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.zoneIdInEval = this.zoneIdForType(this.timestamp().dataType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.zoneIdInEval;
    }

    private ZoneId zoneIdInEval() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.zoneIdInEval$lzycompute();
        }
        return this.zoneIdInEval;
    }

    @Override
    public Object nullSafeEval(Object q, Object micros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd(this.unit(), BoxesRunTime.unboxToInt((Object)q), BoxesRunTime.unboxToLong((Object)micros), this.zoneIdInEval()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneIdInEval(), ZoneId.class.getName());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(q, micros) -> dtu + ".timestampAdd(\"" + this.unit() + "\", " + q + ", " + micros + ", " + zid + ")");
    }

    @Override
    public String prettyName() {
        return "timestampadd";
    }

    @Override
    public String sql() {
        String string = this.unit();
        String childrenSQL = ((IterableOnceOps)((SeqOps)this.children().map((Function1 & Serializable)x$12 -> x$12.sql())).$plus$colon((Object)string)).mkString(", ");
        return this.prettyName() + "(" + childrenSQL + ")";
    }

    @Override
    public TimestampAdd withNewChildrenInternal(Expression newLeft, Expression newRight) {
        Expression x$1 = newLeft;
        Expression x$2 = newRight;
        String x$3 = this.copy$default$1();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$3, x$1, x$2, x$4);
    }

    public TimestampAdd copy(String unit, Expression quantity, Expression timestamp, Option<String> timeZoneId) {
        return new TimestampAdd(unit, quantity, timestamp, timeZoneId);
    }

    public String copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.quantity();
    }

    public Expression copy$default$3() {
        return this.timestamp();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TimestampAdd";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.quantity();
            }
            case 2: {
                return this.timestamp();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimestampAdd;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "unit";
            }
            case 1: {
                return "quantity";
            }
            case 2: {
                return "timestamp";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimestampAdd)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimestampAdd timestampAdd = (TimestampAdd)x$1;
        String string = this.unit();
        String string2 = timestampAdd.unit();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Expression expression = this.quantity();
        Expression expression2 = timestampAdd.quantity();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = timestampAdd.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = timestampAdd.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!timestampAdd.canEqual(this)) return false;
        return true;
    }

    public TimestampAdd(String unit, Expression quantity, Expression timestamp, Option<String> timeZoneId) {
        this.unit = unit;
        this.quantity = quantity;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public TimestampAdd(String unit, Expression quantity, Expression timestamp) {
        this(unit, quantity, timestamp, (Option<String>)None$.MODULE$);
    }

    public TimestampAdd(Expression unit, Expression quantity, Expression timestamp) {
        this(TimeZoneAwareExpression$.MODULE$.convertExpressionToUnit(unit, "timestamp_add"), quantity, timestamp);
    }
}

