/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$;
import org.apache.spark.sql.catalyst.expressions.TimestampDiff$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(unit, startTimestamp, endTimestamp) - Gets the difference between the timestamps `endTimestamp` and `startTimestamp` in the specified units by truncating the fraction part.", arguments="\n    Arguments:\n      * unit - this indicates the units of the difference between the given timestamps.\n        Supported string values of `unit` are (case insensitive):\n          - \"YEAR\"\n          - \"QUARTER\" - 3 months\n          - \"MONTH\"\n          - \"WEEK\" - 7 days\n          - \"DAY\"\n          - \"HOUR\"\n          - \"MINUTE\"\n          - \"SECOND\"\n          - \"MILLISECOND\"\n          - \"MICROSECOND\"\n      * startTimestamp - A timestamp which the expression subtracts from `endTimestamp`.\n      * endTimestamp - A timestamp from which the expression subtracts `startTimestamp`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(HOUR, timestamp_ntz'2022-02-11 20:30:00', timestamp_ntz'2022-02-12 04:30:00');\n       8\n      > SELECT _FUNC_(MONTH, timestamp_ltz'2022-01-01 00:00:00', timestamp_ltz'2022-02-28 00:00:00');\n       1\n      > SELECT _FUNC_(SECOND, date'2022-01-01', timestamp'2021-12-31 23:59:50');\n       -10\n      > SELECT _FUNC_(YEAR, timestamp'2000-01-01 01:02:03.123456', timestamp'2010-01-01 01:02:03.123456');\n       10\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\tmd\u0001\u0002\u0017.\u0001jB\u0001\"\u0018\u0001\u0003\u0016\u0004%\tA\u0018\u0005\tO\u0002\u0011\t\u0012)A\u0005?\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\tE\t\u0015!\u0003k\u0011!q\u0007A!f\u0001\n\u0003I\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00026\t\u0011A\u0004!Q3A\u0005\u0002ED\u0001\"\u001e\u0001\u0003\u0012\u0003\u0006IA\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\u0006m\u0002!\t! \u0005\u0007m\u0002!\t!a\u0001\t\r\u0005-\u0001\u0001\"\u0011j\u0011\u0019\ti\u0001\u0001C!S\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011)\t)\u0004\u0001EC\u0002\u0013%\u0011q\u0007\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBa!!!\u0001\t\u0003r\u0006\"\u0002\u001a\u0001\t\u0003r\u0006bBAB\u0001\u0011E\u0013Q\u0011\u0005\n\u0003\u001f\u0003\u0011\u0011!C\u0001\u0003#C\u0011\"a'\u0001#\u0003%\t!!(\t\u0013\u0005M\u0006!%A\u0005\u0002\u0005U\u0006\"CA]\u0001E\u0005I\u0011AA[\u0011%\tY\fAI\u0001\n\u0003\ti\fC\u0005\u0002B\u0002\t\t\u0011\"\u0011\u0002D\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u00033\u0004\u0011\u0011!C\u0001\u00037D\u0011\"!9\u0001\u0003\u0003%\t%a9\t\u0013\u0005E\b!!A\u0005\u0002\u0005M\b\"CA\u007f\u0001\u0005\u0005I\u0011IA\u0000\u0011%\u0011\u0019\u0001AA\u0001\n\u0003\u0012)aB\u0005\u000305\n\t\u0011#\u0001\u00032\u0019AA&LA\u0001\u0012\u0003\u0011\u0019\u0004\u0003\u0004wI\u0011\u0005!1\n\u0005\n\u0005\u001b\"\u0013\u0011!C#\u0005\u001fB\u0011B!\u0015%\u0003\u0003%\tIa\u0015\t\u0013\tuC%%A\u0005\u0002\u0005u\u0006\"\u0003B0I\u0005\u0005I\u0011\u0011B1\u0011%\u0011y\u0007JI\u0001\n\u0003\ti\fC\u0005\u0003r\u0011\n\t\u0011\"\u0003\u0003t\tiA+[7fgR\fW\u000e\u001d#jM\u001aT!AL\u0018\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003aE\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003eM\n1a]9m\u0015\t!T'A\u0003ta\u0006\u00148N\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<7\u0001A\n\b\u0001mz$)\u0013'S!\taT(D\u0001.\u0013\tqTF\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011A\bQ\u0005\u0003\u00036\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0007\u001as!\u0001\u0010#\n\u0005\u0015k\u0013a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002F[A\u0011AHS\u0005\u0003\u00176\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00055\u0003V\"\u0001(\u000b\u0003=\u000bQa]2bY\u0006L!!\u0015(\u0003\u000fA\u0013x\u000eZ;diB\u00111K\u0017\b\u0003)fs!!\u0016-\u000e\u0003YS!aV\u001d\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0015BA#O\u0013\tYFL\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002F\u001d\u0006!QO\\5u+\u0005y\u0006C\u00011e\u001d\t\t'\r\u0005\u0002V\u001d&\u00111MT\u0001\u0007!J,G-\u001a4\n\u0005\u00154'AB*ue&twM\u0003\u0002d\u001d\u0006)QO\\5uA\u0005q1\u000f^1siRKW.Z:uC6\u0004X#\u00016\u0011\u0005qZ\u0017B\u00017.\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0010gR\f'\u000f\u001e+j[\u0016\u001cH/Y7qA\u0005aQM\u001c3US6,7\u000f^1na\u0006iQM\u001c3US6,7\u000f^1na\u0002\n!\u0002^5nKj{g.Z%e+\u0005\u0011\bcA't?&\u0011AO\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000baL(p\u001f?\u0011\u0005q\u0002\u0001\"B/\n\u0001\u0004y\u0006\"\u00025\n\u0001\u0004Q\u0007\"\u00028\n\u0001\u0004Q\u0007b\u00029\n!\u0003\u0005\rA\u001d\u000b\u0006qz|\u0018\u0011\u0001\u0005\u0006;*\u0001\ra\u0018\u0005\u0006Q*\u0001\rA\u001b\u0005\u0006]*\u0001\rA\u001b\u000b\bq\u0006\u0015\u0011qAA\u0005\u0011\u0015i6\u00021\u0001k\u0011\u0015A7\u00021\u0001k\u0011\u0015q7\u00021\u0001k\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002\u0014A)1+!\u0006\u0002\u001a%\u0019\u0011q\u0003/\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\"M\u0001\u0006if\u0004Xm]\u0005\u0005\u0003G\tiB\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002*A!\u00111DA\u0016\u0013\u0011\ti#!\b\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAb^5uQRKW.\u001a.p]\u0016$2!SA\u001a\u0011\u0015\u0001\b\u00031\u0001`\u00031QxN\\3JI&sWI^1m+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\tQLW.\u001a\u0006\u0003\u0003\u0007\nAA[1wC&!\u0011qIA\u001f\u0005\u0019QvN\\3JI\"\u001a\u0011#a\u0013\u0011\u00075\u000bi%C\u0002\u0002P9\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u0005U\u00131LA0!\ri\u0015qK\u0005\u0004\u00033r%aA!os\"9\u0011Q\f\nA\u0002\u0005U\u0013aC:uCJ$X*[2s_NDq!!\u0019\u0013\u0001\u0004\t)&A\u0005f]\u0012l\u0015n\u0019:pg\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003O\n\u0019(! \u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001c.\u0003\u001d\u0019w\u000eZ3hK:LA!!\u001d\u0002l\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002vM\u0001\r!a\u001e\u0002\u0007\r$\b\u0010\u0005\u0003\u0002j\u0005e\u0014\u0002BA>\u0003W\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002\u0000M\u0001\r!a\u001a\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nK\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006q\u0006\u001d\u00151\u0012\u0005\u0007\u0003\u00133\u0002\u0019\u00016\u0002\u000f9,w\u000fT3gi\"1\u0011Q\u0012\fA\u0002)\f\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0005y\u0003'\u000b)*a&\u0002\u001a\"9Ql\u0006I\u0001\u0002\u0004y\u0006b\u00025\u0018!\u0003\u0005\rA\u001b\u0005\b]^\u0001\n\u00111\u0001k\u0011\u001d\u0001x\u0003%AA\u0002I\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002 *\u001aq,!),\u0005\u0005\r\u0006\u0003BAS\u0003_k!!a*\u000b\t\u0005%\u00161V\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!,O\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\u000b9KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00028*\u001a!.!)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA`U\r\u0011\u0018\u0011U\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0007\u0003BAd\u0003\u001bl!!!3\u000b\t\u0005-\u0017\u0011I\u0001\u0005Y\u0006tw-C\u0002f\u0003\u0013\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a5\u0011\u00075\u000b).C\u0002\u0002X:\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0016\u0002^\"I\u0011q\u001c\u0010\u0002\u0002\u0003\u0007\u00111[\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0015\bCBAt\u0003[\f)&\u0004\u0002\u0002j*\u0019\u00111\u001e(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002p\u0006%(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!>\u0002|B\u0019Q*a>\n\u0007\u0005ehJA\u0004C_>dW-\u00198\t\u0013\u0005}\u0007%!AA\u0002\u0005U\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!2\u0003\u0002!I\u0011q\\\u0011\u0002\u0002\u0003\u0007\u00111[\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U(q\u0001\u0005\n\u0003?\u0014\u0013\u0011!a\u0001\u0003+Bs\u0003\u0001B\u0006\u0005#\u0011\u0019Ba\u0006\u0003\u001a\tu!q\u0004B\u0012\u0005K\u0011ICa\u000b\u0011\u0007q\u0012i!C\u0002\u0003\u00105\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u0016\u0005\t9g\u0018$V\u001d\u000e{\u0006&\u001e8ji2\u00023\u000f^1siRKW.Z:uC6\u0004H\u0006I3oIRKW.Z:uC6\u0004\u0018\u0006I\u0017!\u000f\u0016$8\u000f\t;iK\u0002\"\u0017N\u001a4fe\u0016t7-\u001a\u0011cKR<X-\u001a8!i\",\u0007\u0005^5nKN$\u0018-\u001c9tA\u0001,g\u000e\u001a+j[\u0016\u001cH/Y7qA\u0002\ng\u000e\u001a\u0011agR\f'\u000f\u001e+j[\u0016\u001cH/Y7qA\u0002Jg\u000e\t;iK\u0002\u001a\b/Z2jM&,G\rI;oSR\u001c\bEY=!iJ,hnY1uS:<\u0007\u0005\u001e5fA\u0019\u0014\u0018m\u0019;j_:\u0004\u0003/\u0019:u]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u00057\tA1\u0012\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AUt\u0017\u000e\u001e\u0011.AQD\u0017n\u001d\u0011j]\u0012L7-\u0019;fg\u0002\"\b.\u001a\u0011v]&$8\u000fI8gAQDW\r\t3jM\u001a,'/\u001a8dK\u0002\u0012W\r^<fK:\u0004C\u000f[3!O&4XM\u001c\u0011uS6,7\u000f^1naNt#\u0002\t\u0011!A\u0001\u0002\u0003\u0005I*vaB|'\u000f^3eAM$(/\u001b8hAY\fG.^3tA=4\u0007\u0005Y;oSR\u0004\u0007%\u0019:fA!\u001a\u0017m]3!S:\u001cXM\\:ji&4X-\u000b\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012Z\u000b\u0006\u0013&E\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%U+B%R+%K\t\u0011.AM\u0002Sn\u001c8uQNT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tjuJ\u0014+IE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E]+Ui\u0013\u0012![\u0001:\u0004\u0005Z1zg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E\u0011\u000b\u0015L\t\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t%P+J\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012S*\u0013(V)\u0016\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u00123+R\"P\u001d\u0012\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012S*\u0013'M\u0013N+5i\u0014(EE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5K5IU(T\u000b\u000e{e\n\u0012\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$\u0018M\u001d;US6,7\u000f^1na\u0002j\u0003%\u0011\u0011uS6,7\u000f^1na\u0002:\b.[2iAQDW\rI3yaJ,7o]5p]\u0002\u001aXO\u0019;sC\u000e$8\u000f\t4s_6\u0004\u0003-\u001a8e)&lWm\u001d;b[B\u0004gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011f]\u0012$\u0016.\\3ti\u0006l\u0007\u000fI\u0017!\u0003\u0002\"\u0018.\\3ti\u0006l\u0007\u000f\t4s_6\u0004s\u000f[5dQ\u0002\"\b.\u001a\u0011fqB\u0014Xm]:j_:\u00043/\u001e2ue\u0006\u001cGo\u001d\u0011agR\f'\u000f\u001e+j[\u0016\u001cH/Y7qA:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!\u0011E\u0001\u0004\u0000)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003jT+SY\u0001\"\u0018.\\3ti\u0006l\u0007o\u00188uu\u001e\u0012\u0004G\r\u001a.aIj\u0013'\r\u00113ai\u001a\u0004G\u000f\u00191O1\u0002C/[7fgR\fW\u000e]0oij<#\u0007\r\u001a3[A\u0012T&\r\u001a!aQR4\u0007\r\u001e1a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001d\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5{e\n\u0016%-AQLW.Z:uC6\u0004x\f\u001c;{OI\u0002$GM\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019(Y\u0001\"\u0018.\\3ti\u0006l\u0007o\u00187uu\u001e\u0012\u0004G\r\u001a.aIj#\u0007\u000f\u00111ai\u0002\u0004G\u000f\u00191O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)'\u0016\u001buJ\u0014#-A\u0011\fG/Z\u00143aI\u0012T\u0006M\u0019.aE:C\u0006\t;j[\u0016\u001cH/Y7qOI\u0002$'M\u00172e5\u001a\u0014\u0007\t\u001a4uUJ$(\u000e\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002S&\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Qe+\u0015I\u0015\u0017!i&lWm\u001d;b[B<#\u0007\r\u00191[A\nT\u0006M\u0019!aER\u0004G\r\u001e1g9\n$g\r\u001b6m\u001db\u0003\u0005^5nKN$\u0018-\u001c9(eA\n\u0004'\f\u00192[A\n\u0004\u0005M\u0019;aIR\u0004g\r\u00182eM\"TGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0004G\u0003\u0011!\u0003\u00159'o\\;qC\t\u00119#\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t5\u0012!B\u001a/g9\u0002\u0014!\u0004+j[\u0016\u001cH/Y7q\t&4g\r\u0005\u0002=IM)AE!\u000e\u0003BAI!q\u0007B\u001f?*T'\u000f_\u0007\u0003\u0005sQ1Aa\u000fO\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0010\u0003:\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\t\r#\u0011J\u0007\u0003\u0005\u000bRAAa\u0012\u0002B\u0005\u0011\u0011n\\\u0005\u00047\n\u0015CC\u0001B\u0019\u0003!!xn\u0015;sS:<GCAAc\u0003\u0015\t\u0007\u000f\u001d7z)%A(Q\u000bB,\u00053\u0012Y\u0006C\u0003^O\u0001\u0007q\fC\u0003iO\u0001\u0007!\u000eC\u0003oO\u0001\u0007!\u000eC\u0004qOA\u0005\t\u0019\u0001:\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003d\t-\u0004\u0003B't\u0005K\u0002r!\u0014B4?*T'/C\u0002\u0003j9\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003B7S\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005k\u0002B!a2\u0003x%!!\u0011PAe\u0005\u0019y%M[3di\u0002")
public class TimestampDiff
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
TimeZoneAwareExpression,
Serializable {
    private transient ZoneId zoneIdInEval;
    private final String unit;
    private final Expression startTimestamp;
    private final Expression endTimestamp;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return TimestampDiff$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<String, Expression, Expression, Option<String>>> unapply(TimestampDiff x$0) {
        return TimestampDiff$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return TimestampDiff$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<String, Expression, Expression, Option<String>>, TimestampDiff> tupled() {
        return TimestampDiff$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Expression, Function1<Expression, Function1<Option<String>, TimestampDiff>>>> curried() {
        return TimestampDiff$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public String unit() {
        return this.unit;
    }

    public Expression startTimestamp() {
        return this.startTimestamp;
    }

    public Expression endTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.startTimestamp();
    }

    @Override
    public Expression right() {
        return this.endTimestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        String x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    private ZoneId zoneIdInEval$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.zoneIdInEval = this.zoneIdForType(this.endTimestamp().dataType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.zoneIdInEval;
    }

    private ZoneId zoneIdInEval() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.zoneIdInEval$lzycompute();
        }
        return this.zoneIdInEval;
    }

    @Override
    public Object nullSafeEval(Object startMicros, Object endMicros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff(this.unit(), BoxesRunTime.unboxToLong((Object)startMicros), BoxesRunTime.unboxToLong((Object)endMicros), this.zoneIdInEval()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneIdInEval(), ZoneId.class.getName());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(s, e) -> dtu + ".timestampDiff(\"" + this.unit() + "\", " + s + ", " + e + ", " + zid + ")");
    }

    @Override
    public String prettyName() {
        return "timestampdiff";
    }

    @Override
    public String sql() {
        String string = this.unit();
        String childrenSQL = ((IterableOnceOps)((SeqOps)this.children().map((Function1 & Serializable)x$13 -> x$13.sql())).$plus$colon((Object)string)).mkString(", ");
        return this.prettyName() + "(" + childrenSQL + ")";
    }

    @Override
    public TimestampDiff withNewChildrenInternal(Expression newLeft, Expression newRight) {
        Expression x$1 = newLeft;
        Expression x$2 = newRight;
        String x$3 = this.copy$default$1();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$3, x$1, x$2, x$4);
    }

    public TimestampDiff copy(String unit, Expression startTimestamp, Expression endTimestamp, Option<String> timeZoneId) {
        return new TimestampDiff(unit, startTimestamp, endTimestamp, timeZoneId);
    }

    public String copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.startTimestamp();
    }

    public Expression copy$default$3() {
        return this.endTimestamp();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TimestampDiff";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.startTimestamp();
            }
            case 2: {
                return this.endTimestamp();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimestampDiff;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "unit";
            }
            case 1: {
                return "startTimestamp";
            }
            case 2: {
                return "endTimestamp";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimestampDiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimestampDiff timestampDiff = (TimestampDiff)x$1;
        String string = this.unit();
        String string2 = timestampDiff.unit();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Expression expression = this.startTimestamp();
        Expression expression2 = timestampDiff.startTimestamp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.endTimestamp();
        Expression expression4 = timestampDiff.endTimestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = timestampDiff.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!timestampDiff.canEqual(this)) return false;
        return true;
    }

    public TimestampDiff(String unit, Expression startTimestamp, Expression endTimestamp, Option<String> timeZoneId) {
        this.unit = unit;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public TimestampDiff(String unit, Expression startTimestamp, Expression endTimestamp) {
        this(unit, startTimestamp, endTimestamp, (Option<String>)None$.MODULE$);
    }

    public TimestampDiff(Expression unit, Expression startTimestamp, Expression endTimestamp) {
        this(TimeZoneAwareExpression$.MODULE$.convertExpressionToUnit(unit, "timestamp_diff"), startTimestamp, endTimestamp);
    }
}

