/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Base64;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnBase64$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str) - Converts the argument from a base 64 string `str` to a binary.", examples="\n    Examples:\n      > SELECT _FUNC_('U3BhcmsgU1FM');\n       Spark SQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\u0010!\u00016B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003V\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015I\u0006\u0001\"\u0001o\u0011\u0015\t\b\u0001\"\u0015s\u0011\u0015A\b\u0001\"\u0011z\u0011\u001d\ty\u0001\u0001C)\u0003#A\u0011\"a\u0006\u0001\u0003\u0003%\t!!\u0007\t\u0013\u0005}\u0001!%A\u0005\u0002\u0005\u0005\u0002\"CA\u001c\u0001E\u0005I\u0011AA\u001d\u0011%\ti\u0004AA\u0001\n\u0003\ny\u0004C\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T!I\u00111\f\u0001\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003G\u0002\u0011\u0011!C!\u0003KB\u0011\"a\u001d\u0001\u0003\u0003%\t!!\u001e\t\u0013\u0005e\u0004!!A\u0005B\u0005m\u0004\"CA@\u0001\u0005\u0005I\u0011IAA\u000f\u001d\t)\u000b\tE\u0001\u0003O3aa\b\u0011\t\u0002\u0005%\u0006BB-\u0018\t\u0003\tY\fC\u0004\u0002>^!\t!a0\t\u0013\u0005Mw#!A\u0005\u0002\u0006U\u0007\"CAn/E\u0005I\u0011AA\u001d\u0011%\tinFA\u0001\n\u0003\u000by\u000eC\u0005\u0002r^\t\n\u0011\"\u0001\u0002:!I\u00111_\f\u0002\u0002\u0013%\u0011Q\u001f\u0002\t+:\u0014\u0015m]37i)\u0011\u0011EI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002$I\u0005A1-\u0019;bYf\u001cHO\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001]I*DH\u0011\t\u0003_Aj\u0011\u0001I\u0005\u0003c\u0001\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003_MJ!\u0001\u000e\u0011\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AN\u001d\u000f\u0005=:\u0014B\u0001\u001d!\u0003\u001d\u0001\u0018mY6bO\u0016L!AO\u001e\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011\u0001\b\t\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\b!J|G-^2u!\t\u0019%J\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011q\tL\u0001\u0007yI|w\u000e\u001e \n\u0003}J!\u0001\u000f \n\u0005-c%\u0001D*fe&\fG.\u001b>bE2,'B\u0001\u001d?\u0003\u0015\u0019\u0007.\u001b7e+\u0005y\u0005CA\u0018Q\u0013\t\t\u0006E\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012!\u0016\t\u0003{YK!a\u0016 \u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"2a\u0017/^!\ty\u0003\u0001C\u0003N\u000b\u0001\u0007q\nC\u0004T\u000bA\u0005\t\u0019A+\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u0012\nQ\u0001^=qKNL!!\u001a2\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005A\u0007cA\"jW&\u0011!\u000e\u0014\u0002\u0004'\u0016\f\bCA1m\u0013\ti'M\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qKR\u00111l\u001c\u0005\u0006a\"\u0001\raT\u0001\u0005Kb\u0004(/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002tmB\u0011Q\b^\u0005\u0003kz\u00121!\u00118z\u0011\u00159\u0018\u00021\u0001t\u0003\u0019\u0019HO]5oO\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0006u\u0006\u0005\u00111\u0002\t\u0003wzl\u0011\u0001 \u0006\u0003{\u0002\nqaY8eK\u001e,g.\u0003\u0002\u0000y\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u0004)\u0001\r!!\u0002\u0002\u0007\r$\b\u0010E\u0002|\u0003\u000fI1!!\u0003}\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!!\u0004\u000b\u0001\u0004Q\u0018AA3w\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u00191,a\u0005\t\r\u0005U1\u00021\u0001P\u0003!qWm^\"iS2$\u0017\u0001B2paf$RaWA\u000e\u0003;Aq!\u0014\u0007\u0011\u0002\u0003\u0007q\nC\u0004T\u0019A\u0005\t\u0019A+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0005\u0016\u0004\u001f\u0006\u00152FAA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Eb(\u0001\u0006b]:|G/\u0019;j_:LA!!\u000e\u0002,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\b\u0016\u0004+\u0006\u0015\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u00027b]\u001eT!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n)E\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\u00022!PA,\u0013\r\tIF\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004g\u0006}\u0003\"CA1#\u0005\u0005\t\u0019AA+\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\r\t\u0006\u0003S\nyg]\u0007\u0003\u0003WR1!!\u001c?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\nYG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA+\u0002x!A\u0011\u0011M\n\u0002\u0002\u0003\u00071/\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA!\u0003{B\u0011\"!\u0019\u0015\u0003\u0003\u0005\r!!\u0016\u0002\r\u0015\fX/\u00197t)\r)\u00161\u0011\u0005\t\u0003C*\u0012\u0011!a\u0001g\"\u001a\u0002!a\"\u0002\u000e\u0006=\u00151SAK\u00033\u000bY*a(\u0002\"B\u0019q&!#\n\u0007\u0005-\u0005EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005E\u0015\u0001T0G+:\u001bu\fK:ue&\u0002S\u0006I\"p]Z,'\u000f^:!i\",\u0007%\u0019:hk6,g\u000e\u001e\u0011ge>l\u0007%\u0019\u0011cCN,\u0007E\u000e\u001b!gR\u0014\u0018N\\4!AN$(\u000f\u0019\u0011u_\u0002\n\u0007EY5oCJLh&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9*A%\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d*6G\u00115d[N<W+\r$NO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u00043+\u0015'\u000bA\u0001\nQa]5oG\u0016\f#!!(\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\r\u0016\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001C+o\u0005\u0006\u001cXM\u000e\u001b\u0011\u0005=:2#B\f\u0002,\u0006E\u0006cA\u001f\u0002.&\u0019\u0011q\u0016 \u0003\r\u0005s\u0017PU3g!\u0011\t\u0019,!/\u000e\u0005\u0005U&\u0002BA\\\u0003\u0013\n!![8\n\u0007-\u000b)\f\u0006\u0002\u0002(\u0006i\u0011n\u001d,bY&$')Y:fmQ\"2!VAa\u0011\u001d\t\u0019-\u0007a\u0001\u0003\u000b\f\u0011b\u001d:d'R\u0014\u0018N\\4\u0011\t\u0005\u001d\u0017qZ\u0007\u0003\u0003\u0013T1aYAf\u0015\r\tiMJ\u0001\u0007k:\u001c\u0018MZ3\n\t\u0005E\u0017\u0011\u001a\u0002\u000b+R3\u0005h\u0015;sS:<\u0017!B1qa2LH#B.\u0002X\u0006e\u0007\"B'\u001b\u0001\u0004y\u0005bB*\u001b!\u0003\u0005\r!V\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BAq\u0003[\u0004R!PAr\u0003OL1!!:?\u0005\u0019y\u0005\u000f^5p]B)Q(!;P+&\u0019\u00111\u001e \u0003\rQ+\b\u000f\\33\u0011!\ty\u000fHA\u0001\u0002\u0004Y\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a>\u0011\t\u0005\r\u0013\u0011`\u0005\u0005\u0003w\f)E\u0001\u0004PE*,7\r\u001e")
public class UnBase64
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$2() {
        return UnBase64$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnBase64 x$0) {
        return UnBase64$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return UnBase64$.MODULE$.apply$default$2();
    }

    public static boolean isValidBase64(UTF8String srcString) {
        return UnBase64$.MODULE$.isValidBase64(srcString);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object string) {
        if (this.failOnError() && !UnBase64$.MODULE$.isValidBase64((UTF8String)string)) {
            throw QueryExecutionErrors$.MODULE$.invalidInputInConversionError((DataType)BinaryType$.MODULE$, (UTF8String)string, UTF8String.fromString((String)"BASE64"), "try_to_binary");
        }
        return Base64.getMimeDecoder().decode(((UTF8String)string).toString());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)child -> {
            String string;
            if (this.failOnError()) {
                String unbase64 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(UnBase64$.MODULE$.getClass().getName()), "$");
                String binaryType = ctx.addReferenceObj("to", BinaryType$.MODULE$, BinaryType$.MODULE$.getClass().getName());
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (!" + unbase64 + ".isValidBase64(" + child + ")) {\n           |  throw QueryExecutionErrors.invalidInputInConversionError(\n           |    " + binaryType + ",\n           |    " + child + ",\n           |    UTF8String.fromString(\"BASE64\"),\n           |    \"try_to_binary\");\n           |}\n       "));
            } else {
                string = "";
            }
            String maybeValidateInputCode = string;
            return "\n         " + maybeValidateInputCode + "\n         " + ev.value() + " = " + Base64.class.getName() + ".getMimeDecoder().decode(" + child + ".toString());\n       ";
        });
    }

    @Override
    public UnBase64 withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.failOnError());
    }

    public UnBase64 copy(Expression child, boolean failOnError) {
        return new UnBase64(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnBase64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnBase64;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnBase64)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnBase64 unBase64 = (UnBase64)x$1;
        if (this.failOnError() != unBase64.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = unBase64.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!unBase64.canEqual(this)) return false;
        return true;
    }

    public UnBase64(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnBase64(Expression expr) {
        this(expr, false);
    }
}

