/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed$;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Uuid$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_() - Returns an universally unique identifier (UUID) string. The value is returned as a canonical UUID 36-character string.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       46707d92-02f4-4817-8116-a4c3b23e6266\n  ", note="\n    The function is non-deterministic.\n  ", since="2.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u0012$\u0001BB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t+\u0002\u0011\t\u0012)A\u0005\u001f\")a\u000b\u0001C\u0001/\")a\u000b\u0001C\u00015\")a\u000b\u0001C\u00017\")\u0011\r\u0001C!E\")1\r\u0001C!I\"Aa\r\u0001EC\u0002\u0013\u0005s\rC\u0003l\u0001\u0011\u0005s\rC\u0003m\u0001\u0011\u0005S\u000eC\u0003u\u0001\u0011\u0005s\rC\u0005v\u0001\u0001\u0007\t\u0011)Q\u0005m\"9\u0011\u0011\u0001\u0001\u0005R\u0005\r\u0001bBA\u000b\u0001\u0011E\u0013q\u0003\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011%\tI\u0005AA\u0001\n\u0003\tY\u0005C\u0005\u0002P\u0001\t\n\u0011\"\u0001\u0002R!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000e\u0005\n\u0003w\u0002\u0011\u0011!C\u0001\u0003{B\u0011\"a \u0001\u0003\u0003%\t!!!\t\u0013\u0005\u001d\u0005!!A\u0005B\u0005%\u0005\"CAL\u0001\u0005\u0005I\u0011AAM\u0011%\ti\nAA\u0001\n\u0003\ny\nC\u0005\u0002$\u0002\t\t\u0011\"\u0011\u0002&\u001eI\u0011qZ\u0012\u0002\u0002#\u0005\u0011\u0011\u001b\u0004\tE\r\n\t\u0011#\u0001\u0002T\"1aK\u0007C\u0001\u0003WD\u0011\"!<\u001b\u0003\u0003%)%a<\t\u0013\u0005E($!A\u0005\u0002\u0006M\b\"CA|5E\u0005I\u0011AA)\u0011%\tIPGA\u0001\n\u0003\u000bY\u0010C\u0005\u0003\u0004i\t\n\u0011\"\u0001\u0002R!I!Q\u0001\u000e\u0002\u0002\u0013%!q\u0001\u0002\u0005+VLGM\u0003\u0002%K\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1s%\u0001\u0005dCR\fG._:u\u0015\tA\u0013&A\u0002tc2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0011'\u000e\u001d<\u0003B\u0011!gM\u0007\u0002G%\u0011Ag\t\u0002\u000f\u0019\u0016\fg-\u0012=qe\u0016\u001c8/[8o!\t\u0011d'\u0003\u00028G\t\u0001bj\u001c8eKR,'/\\5oSN$\u0018n\u0019\t\u0003eeJ!AO\u0012\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UHA\u0004Qe>$Wo\u0019;\u0011\u0005\tSeBA\"I\u001d\t!u)D\u0001F\u0015\t1u&\u0001\u0004=e>|GOP\u0005\u0002}%\u0011\u0011*P\u0001\ba\u0006\u001c7.Y4f\u0013\tYEJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002J{\u0005Q!/\u00198e_6\u001cV-\u001a3\u0016\u0003=\u00032\u0001\u0010)S\u0013\t\tVH\u0001\u0004PaRLwN\u001c\t\u0003yMK!\u0001V\u001f\u0003\t1{gnZ\u0001\fe\u0006tGm\\7TK\u0016$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00031f\u0003\"A\r\u0001\t\u000f5\u001b\u0001\u0013!a\u0001\u001fR\t\u0001\f\u0006\u0002Y9\")Q,\u0002a\u0001=\u0006!1/Z3e!\t\u0011t,\u0003\u0002aG\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001dM,W\rZ#yaJ,7o]5p]V\ta,A\u0006xSRDg*Z<TK\u0016$GC\u0001-f\u0011\u0015iv\u00011\u0001S\u0003!\u0011Xm]8mm\u0016$W#\u00015\u0011\u0005qJ\u0017B\u00016>\u0005\u001d\u0011un\u001c7fC:\f\u0001B\\;mY\u0006\u0014G.Z\u0001\tI\u0006$\u0018\rV=qKV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002rO\u0005)A/\u001f9fg&\u00111\u000f\u001d\u0002\t\t\u0006$\u0018\rV=qK\u0006A1\u000f^1uK\u001a,H.A\bsC:$w.\\$f]\u0016\u0014\u0018\r^8s!\t9(0D\u0001y\u0015\tIX%\u0001\u0003vi&d\u0017BA>y\u0005M\u0011\u0016M\u001c3p[V+\u0016\nR$f]\u0016\u0014\u0018\r^8sQ\taQ\u0010\u0005\u0002=}&\u0011q0\u0010\u0002\niJ\fgn]5f]R\f!#\u001b8ji&\fG.\u001b>f\u0013:$XM\u001d8bYR!\u0011QAA\u0006!\ra\u0014qA\u0005\u0004\u0003\u0013i$\u0001B+oSRDq!!\u0004\u000e\u0001\u0004\ty!\u0001\bqCJ$\u0018\u000e^5p]&sG-\u001a=\u0011\u0007q\n\t\"C\u0002\u0002\u0014u\u00121!\u00138u\u00031)g/\u00197J]R,'O\\1m)\u0011\tI\"a\b\u0011\u0007q\nY\"C\u0002\u0002\u001eu\u00121!\u00118z\u0011\u001d\t\tC\u0004a\u0001\u0003G\tQ!\u001b8qkR\u0004B!!\n\u0002(5\tQ%C\u0002\u0002*\u0015\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003_\tY$!\u0012\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e$\u0003\u001d\u0019w\u000eZ3hK:LA!!\u000f\u00024\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002>=\u0001\r!a\u0010\u0002\u0007\r$\b\u0010\u0005\u0003\u00022\u0005\u0005\u0013\u0002BA\"\u0003g\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002H=\u0001\r!a\f\u0002\u0005\u00154\u0018\u0001B2paf$2\u0001WA'\u0011\u001di\u0005\u0003%AA\u0002=\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002T)\u001aq*!\u0016,\u0005\u0005]\u0003\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0019>\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\nYFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\nA\u0001\\1oO*\u0011\u0011QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002z\u0005=$AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0010\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\r\u0003\u0007C\u0011\"!\"\u0015\u0003\u0003\u0005\r!a\u0004\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\t\u0005\u0004\u0002\u000e\u0006M\u0015\u0011D\u0007\u0003\u0003\u001fS1!!%>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003+\u000byI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00015\u0002\u001c\"I\u0011Q\u0011\f\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002l\u0005\u0005\u0006\"CAC/\u0005\u0005\t\u0019AA\b\u0003\u0019)\u0017/^1mgR\u0019\u0001.a*\t\u0013\u0005\u0015\u0005$!AA\u0002\u0005e\u0001f\u0006\u0001\u0002,\u0006E\u00161WA\\\u0003s\u000bi,a0\u0002D\u0006\u0015\u0017\u0011ZAf!\r\u0011\u0014QV\u0005\u0004\u0003_\u001b#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003k\u000b\u00111A0G+:\u001bu\fK\u0015![\u0001\u0012V\r^;s]N\u0004\u0013M\u001c\u0011v]&4XM]:bY2L\b%\u001e8jcV,\u0007%\u001b3f]RLg-[3sA!*V+\u0013#*AM$(/\u001b8h]\u0001\"\u0006.\u001a\u0011wC2,X\rI5tAI,G/\u001e:oK\u0012\u0004\u0013m\u001d\u0011bA\r\fgn\u001c8jG\u0006d\u0007%V+J\t\u0002\u001ad'L2iCJ\f7\r^3sAM$(/\u001b8h]\u0005AQ\r_1na2,7/\t\u0002\u0002<\u00061&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ2t\u0007M\u001cesIj\u0003G\r45[QB\u0014gN\u00179cE2T&\u0019\u001bdg\t\u00144'\u001a\u001c3mYR\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002B\u0006Q#\u0002\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!SN\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2/\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAd\u0003\u0015\u0011df\r\u00181\u0003\u00159'o\\;qC\t\ti-\u0001\u0006nSN\u001cwLZ;oGN\fA!V;jIB\u0011!GG\n\u00065\u0005U\u0017\u0011\u001d\t\u0007\u0003/\fin\u0014-\u000e\u0005\u0005e'bAAn{\u00059!/\u001e8uS6,\u0017\u0002BAp\u00033\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\t\u0019/!;\u000e\u0005\u0005\u0015(\u0002BAt\u0003g\n!![8\n\u0007-\u000b)\u000f\u0006\u0002\u0002R\u0006AAo\\*ue&tw\r\u0006\u0002\u0002l\u0005)\u0011\r\u001d9msR\u0019\u0001,!>\t\u000f5k\u0002\u0013!a\u0001\u001f\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0018q \t\u0004yA{\u0005\u0002\u0003B\u0001?\u0005\u0005\t\u0019\u0001-\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0013\u0001B!!\u001c\u0003\f%!!QBA8\u0005\u0019y%M[3di\u0002")
public class Uuid
extends LeafExpression
implements Nondeterministic,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private final Option<Object> randomSeed;
    private transient RandomUUIDGenerator randomGenerator;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$1() {
        return Uuid$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<Object>> unapply(Uuid x$0) {
        return Uuid$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$1() {
        return Uuid$.MODULE$.apply$default$1();
    }

    public static <A> Function1<Option<Object>, A> andThen(Function1<Uuid, A> g) {
        return Uuid$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Uuid> compose(Function1<A$, Option<Object>> g) {
        return Uuid$.MODULE$.compose(g);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Uuid withNewSeed(long seed) {
        return new Uuid((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)seed)));
    }

    private boolean resolved$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.randomGenerator = new RandomUUIDGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        return this.randomGenerator.getNextUUIDUTF8String();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String randomGen = ctx.freshName("randomGen");
        String x$1 = "org.apache.spark.sql.catalyst.util.RandomUUIDGenerator";
        String x$2 = randomGen;
        boolean x$3 = true;
        boolean x$4 = false;
        Function1<String, String> x$5 = ctx.addMutableState$default$3();
        ctx.addMutableState("org.apache.spark.sql.catalyst.util.RandomUUIDGenerator", x$2, x$5, true, false);
        ctx.addPartitionInitializationStatement(randomGen + " = new org.apache.spark.sql.catalyst.util.RandomUUIDGenerator(" + this.randomSeed().get() + "L + partitionIndex);");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"final UTF8String ", " = ", ".getNextUUIDUTF8String();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), randomGen})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public Uuid copy(Option<Object> randomSeed) {
        return new Uuid(randomSeed);
    }

    public Option<Object> copy$default$1() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Uuid";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.randomSeed();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uuid;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "randomSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uuid)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uuid uuid = (Uuid)x$1;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = uuid.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!uuid.canEqual(this)) return false;
        return true;
    }

    public Uuid(Option<Object> randomSeed) {
        this.randomSeed = randomSeed;
        Nondeterministic.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        Statics.releaseFence();
    }

    public Uuid() {
        this((Option<Object>)None$.MODULE$);
    }

    public Uuid(Expression seed) {
        this(ExpressionWithRandomSeed$.MODULE$.expressionToSeed(seed, "UUID"));
    }
}

