/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FoldableUnevaluable;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.WindowTime$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(window_column) - Extract the time value from time/session window column which can be used for event time value of window.\n      The extracted time is (window.end - 1) which reflects the fact that the aggregating\n      windows have exclusive upper bound - [start, end)\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#window-operations-on-event-time\">'Window Operations on Event Time'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * window_column - The column representing time/session window.\n  ", examples="\n    Examples:\n      > SELECT a, window.start as start, window.end as end, _FUNC_(window), cnt FROM (SELECT a, window, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:06:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, window(b, '5 minutes') ORDER BY a, window.start);\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t2021-01-01 00:04:59.999999\t2\n        A1\t2021-01-01 00:05:00\t2021-01-01 00:10:00\t2021-01-01 00:09:59.999999\t1\n        A2\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t2021-01-01 00:04:59.999999\t1\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001\u0002\u000f\u001e\u0001*B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\")\u0001\u000b\u0001C\u0001#\")A\u000b\u0001C!\u0017\")Q\u000b\u0001C!-\")\u0001\r\u0001C!C\"9Q\r\u0001b\u0001\n\u000b2\u0007BB?\u0001A\u00035q\rC\u0003\u007f\u0001\u0011\u0005s\u0010\u0003\u0006\u0002\u0012\u0001A)\u0019!C!\u0003'Aq!a\u0007\u0001\t#\ni\u0002C\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&!I\u0011\u0011\u0006\u0001\u0012\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003\u0003\u0002\u0011\u0011!C!\u0003\u0007B\u0011\"a\u0015\u0001\u0003\u0003%\t!!\u0016\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0003\"CA6\u0001\u0005\u0005I\u0011IA7\u0011%\tY\bAA\u0001\n\u0003\ti\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\"I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0013\u0011R\u0004\n\u0003gk\u0012\u0011!E\u0001\u0003k3\u0001\u0002H\u000f\u0002\u0002#\u0005\u0011q\u0017\u0005\u0007!Z!\t!a4\t\u0013\u0005Eg#!A\u0005F\u0005M\u0007\"CAk-\u0005\u0005I\u0011QAl\u0011%\tYNFA\u0001\n\u0003\u000bi\u000eC\u0005\u0002jZ\t\t\u0011\"\u0003\u0002l\nQq+\u001b8e_^$\u0016.\\3\u000b\u0005yy\u0012aC3yaJ,7o]5p]NT!\u0001I\u0011\u0002\u0011\r\fG/\u00197zgRT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019r\u0001A\u00160eUBd\b\u0005\u0002-[5\tQ$\u0003\u0002/;\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002-a%\u0011\u0011'\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011AfM\u0005\u0003iu\u00111\"\u00168fm\u0006dW/\u00192mKB\u0011AFN\u0005\u0003ou\u0011\u0001CT8o'FcU\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011qh\u0012\b\u0003\u0001\u0016s!!\u0011#\u000e\u0003\tS!aQ\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014B\u0001$;\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001S%\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0019S\u0014\u0001D<j]\u0012|woQ8mk6tW#\u0001'\u0011\u00051j\u0015B\u0001(\u001e\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u000eo&tGm\\<D_2,XN\u001c\u0011\u0002\rqJg.\u001b;?)\t\u00116\u000b\u0005\u0002-\u0001!)!j\u0001a\u0001\u0019\u0006)1\r[5mI\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003]\u00032a\u0010-[\u0013\tI\u0016JA\u0002TKF\u0004\"a\u00170\u000e\u0003qS!!X\u0011\u0002\u000bQL\b/Z:\n\u0005}c&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u00012\u0011\u0005m\u001b\u0017B\u00013]\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001cX#A4\u0011\u0007}B\u0006\u000e\u0005\u0002ju:\u0011!n\u001e\b\u0003WVt!\u0001\u001c;\u000f\u00055\u001chB\u00018s\u001d\ty\u0017O\u0004\u0002Ba&\t\u0001&\u0003\u0002'O%\u0011A%J\u0005\u0003E\rJ!\u0001I\u0011\n\u0005Y|\u0012!\u0002;sK\u0016\u001c\u0018B\u0001=z\u0003-!&/Z3QCR$XM\u001d8\u000b\u0005Y|\u0012BA>}\u0005-!&/Z3QCR$XM\u001d8\u000b\u0005aL\u0018!\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001c\b%\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0001\u0011\t\u0005\r\u00111\u0002\b\u0005\u0003\u000b\t9\u0001\u0005\u0002Bu%\u0019\u0011\u0011\u0002\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!a\u0004\u0003\rM#(/\u001b8h\u0015\r\tIAO\u0001\te\u0016\u001cx\u000e\u001c<fIV\u0011\u0011Q\u0003\t\u0004s\u0005]\u0011bAA\ru\t9!i\\8mK\u0006t\u0017\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002S\u0003?Aa!!\t\f\u0001\u0004a\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0004%\u0006\u001d\u0002b\u0002&\r!\u0003\u0005\r\u0001T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiCK\u0002M\u0003_Y#!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wQ\u0014AC1o]>$\u0018\r^5p]&!\u0011qHA\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003#j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0005Y\u0006twM\u0003\u0002\u0002P\u0005!!.\u0019<b\u0013\u0011\ti!!\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0003cA\u001d\u0002Z%\u0019\u00111\f\u001e\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0014q\r\t\u0004s\u0005\r\u0014bAA3u\t\u0019\u0011I\\=\t\u0013\u0005%\u0004#!AA\u0002\u0005]\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002pA1\u0011\u0011OA<\u0003Cj!!a\u001d\u000b\u0007\u0005U$(\u0001\u0006d_2dWm\u0019;j_:LA!!\u001f\u0002t\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)\"a \t\u0013\u0005%$#!AA\u0002\u0005\u0005\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0012\u0002\u0006\"I\u0011\u0011N\n\u0002\u0002\u0003\u0007\u0011qK\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\u00111\u0012\u0005\n\u0003S\"\u0012\u0011!a\u0001\u0003CBs\u0003AAH\u0003+\u000b9*a'\u0002\u001e\u0006\u0005\u00161UAT\u0003S\u000bi+a,\u0011\u00071\n\t*C\u0002\u0002\u0014v\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u001a\u0006!iB\u0003\u0011!A\u0001zf)\u0016(D?\":\u0018N\u001c3po~\u001bw\u000e\\;n]&\u0002S\u0006I#yiJ\f7\r\u001e\u0011uQ\u0016\u0004C/[7fAY\fG.^3!MJ|W\u000e\t;j[\u0016|3/Z:tS>t\u0007e^5oI><\beY8mk6t\u0007e\u001e5jG\"\u00043-\u00198!E\u0016\u0004So]3eA\u0019|'\u000fI3wK:$\b\u0005^5nK\u00022\u0018\r\\;fA=4\u0007e^5oI><hF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0015DHO]1di\u0016$\u0007\u0005^5nK\u0002J7\u000f\t\u0015xS:$wn\u001e\u0018f]\u0012\u0004S\u0006I\u0019*A]D\u0017n\u00195!e\u00164G.Z2ug\u0002\"\b.\u001a\u0011gC\u000e$\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011bO\u001e\u0014XmZ1uS:<'\u0002\t\u0011!A\u0001\u0002s/\u001b8e_^\u001c\b\u0005[1wK\u0002*\u0007p\u00197vg&4X\rI;qa\u0016\u0014\bEY8v]\u0012\u0004S\u0006I.ti\u0006\u0014H\u000f\f\u0011f]\u0012L#\u0002\t\u0011!A\u0001\u00023+Z3!y\u0005\u0004\u0003N]3g{\tBG\u000f\u001e9tu=z3\u000f]1sW:\n\u0007/Y2iK:z'oZ\u0018e_\u000e\u001cx\u0006\\1uKN$xf\u001d;sk\u000e$XO]3e[M$(/Z1nS:<W\u0006\u001d:pOJ\fW.\\5oO6:W/\u001b3f]!$X\u000e\\\u0012xS:$wn^\u0017pa\u0016\u0014\u0018\r^5p]NlsN\\\u0017fm\u0016tG/\f;j[\u0016\u0014chJ,j]\u0012|w\u000fI(qKJ\fG/[8og\u0002zg\u000eI#wK:$\b\u0005V5nK\u001ebt&\u0019 !S:\u00043\u000b\u001e:vGR,(/\u001a3!'R\u0014X-Y7j]\u001e\u0004s-^5eK\u0002\"wn\u0019\u0011g_J\u0004C-\u001a;bS2,G\rI3ya2\fg.\u0019;j_:\u0004\u0013M\u001c3!Kb\fW\u000e\u001d7fg:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a(\u0002/*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e^5oI><xlY8mk6t\u0007%\f\u0011UQ\u0016\u00043m\u001c7v[:\u0004#/\u001a9sKN,g\u000e^5oO\u0002\"\u0018.\\30g\u0016\u001c8/[8oA]Lg\u000eZ8x])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t)+\u0001CL\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\nG\u0006I<j]\u0012|wOL:uCJ$\b%Y:!gR\f'\u000f\u001e\u0017!o&tGm\\</K:$\u0007%Y:!K:$G\u0006I0G+:\u001bu\fK<j]\u0012|w/\u000b\u0017!G:$\bE\u0012*P\u001b\u0002B3+\u0012'F\u0007R\u0003\u0013\r\f\u0011xS:$wn\u001e\u0017!G>,h\u000e\u001e\u0015+S\u0001\n7\u000fI2oi\u00022%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001b;gA:\u0013\u0006\f\u0011)O\u0005\u000bt\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aYR\u0004\u0007M\u0014*Y\u0001Bs%\u0011\u001a(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a\u001dJ\u0003%Q*!i\u0006\u0014\u0007&\u0019\u0017!E&\u0002sIU(V!\u0002\u0012\u0017\u0010I1-A]Lg\u000eZ8xQ\td\u0003eJ\u001b![&tW\u000f^3tO%\u0002sJ\u0015#F%\u0002\u0012\u0015\fI1-A]Lg\u000eZ8x]M$\u0018M\u001d;*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00196uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001b;ker\u0013(O\u001d:seJ!G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002TG\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uE\u0002$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aeRT'\u000f\u0018:seJ\u0014(O\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n%'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u001b;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004\u0007\u000e\u001e6s9J\u0014(O\u001d:s%\t$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005-\u0016A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003c\u000bQa\r\u00185]A\n!bV5oI><H+[7f!\taccE\u0003\u0017\u0003s\u000b)\r\u0005\u0004\u0002<\u0006\u0005GJU\u0007\u0003\u0003{S1!a0;\u0003\u001d\u0011XO\u001c;j[\u0016LA!a1\u0002>\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005\u001d\u0017QZ\u0007\u0003\u0003\u0013TA!a3\u0002N\u0005\u0011\u0011n\\\u0005\u0004\u0011\u0006%GCAA[\u0003!!xn\u0015;sS:<GCAA#\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0011\u0016\u0011\u001c\u0005\u0006\u0015f\u0001\r\u0001T\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ty.!:\u0011\te\n\t\u000fT\u0005\u0004\u0003GT$AB(qi&|g\u000e\u0003\u0005\u0002hj\t\t\u00111\u0001S\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003[\u0004B!a\u0012\u0002p&!\u0011\u0011_A%\u0005\u0019y%M[3di\u0002")
public class WindowTime
extends UnaryExpression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression windowColumn;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Expression> unapply(WindowTime x$0) {
        return WindowTime$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<WindowTime, A> g) {
        return WindowTime$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, WindowTime> compose(Function1<A$, Expression> g) {
        return WindowTime$.MODULE$.compose(g);
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return FoldableUnevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return FoldableUnevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return FoldableUnevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression windowColumn() {
        return this.windowColumn;
    }

    @Override
    public Expression child() {
        return this.windowColumn();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StructType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return ((StructField)((StructType)this.child().dataType()).head()).dataType();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public String prettyName() {
        return "window_time";
    }

    private boolean resolved$lzycompute() {
        WindowTime windowTime = this;
        synchronized (windowTime) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public WindowTime withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public WindowTime copy(Expression windowColumn) {
        return new WindowTime(windowColumn);
    }

    public Expression copy$default$1() {
        return this.windowColumn();
    }

    @Override
    public String productPrefix() {
        return "WindowTime";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.windowColumn();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WindowTime;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "windowColumn";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WindowTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        WindowTime windowTime = (WindowTime)x$1;
        Expression expression = this.windowColumn();
        Expression expression2 = windowTime.windowColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!windowTime.canEqual(this)) return false;
        return true;
    }

    public WindowTime(Expression windowColumn) {
        this.windowColumn = windowColumn;
        ExpectsInputTypes.$init$(this);
        FoldableUnevaluable.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.WINDOW_TIME(), (List)Nil$.MODULE$);
    }
}

