/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import javax.xml.validation.Schema;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.XmlToStructs$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser;
import org.apache.spark.sql.catalyst.xml.ValidatorUtil$;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.catalyst.xml.XmlOptions$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(xmlStr, schema[, options]) - Returns a struct value with the given `xmlStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('<p><a>1</a><b>0.8</b></p>', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('<p><time>26/08/2015</time></p>', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n      > SELECT _FUNC_('<p><teacher>Alice</teacher><student><name>Bob</name><rank>1</rank></student><student><name>Charlie</name><rank>2</rank></student></p>', 'STRUCT<teacher: STRING, student: ARRAY<STRUCT<name: STRING, rank: INT>>>');\n       {\"teacher\":\"Alice\",\"student\":[{\"name\":\"Bob\",\"rank\":1},{\"name\":\"Charlie\",\"rank\":2}]}\n  ", group="xml_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0005\tmf\u0001\u0002\u00192\u0001zB\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005S\"A\u0001\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005~\u0001\tE\t\u0015!\u0003s\u0011!q\bA!f\u0001\n\u0003y\bBCA\u0004\u0001\tE\t\u0015!\u0003\u0002\u0002!Q\u0011\u0011\u0002\u0001\u0003\u0016\u0004%\t!a\u0003\t\u0015\u0005M\u0001A!E!\u0002\u0013\ti\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005U\u0001\u0001\"\u0001\u0002$!9\u00111\u0006\u0001\u0005B\u00055\u0002\u0002CA\u001b\u0001\t\u0007I\u0011\u00025\t\u000f\u0005]\u0002\u0001)A\u0005S\"9\u0011Q\u0003\u0001\u0005\u0002\u0005e\u0002bBA\u000b\u0001\u0011\u0005\u0011q\b\u0005\u000b\u0003\u000f\u0002\u0001R1A\u0005\n\u0005%\u0003\"CA4\u0001\t\u0007I\u0011BA5\u0011\u001d\tY\u0007\u0001Q\u0001\niD!\"!\u001c\u0001\u0011\u000b\u0007I\u0011BA8\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!!#\u0001\t\u0003\nY\tC\u0004\u0002\u0010\u0002!\t%!%\t\u000f\u0005u\u0005\u0001\"\u0015\u0002 \"9\u00111\u0018\u0001\u0005B\u0005u\u0006bBAf\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003\u001b\u0004A\u0011CAh\u0011%\t)\u000eAA\u0001\n\u0003\t9\u000eC\u0005\u0002b\u0002\t\n\u0011\"\u0001\u0002d\"I\u0011\u0011 \u0001\u0012\u0002\u0013\u0005\u00111 \u0005\n\u0003\u007f\u0004\u0011\u0013!C\u0001\u0005\u0003A\u0011B!\u0002\u0001#\u0003%\tAa\u0002\t\u0013\t-\u0001!!A\u0005B\t5\u0001\"\u0003B\u000f\u0001\u0005\u0005I\u0011\u0001B\u0010\u0011%\u00119\u0003AA\u0001\n\u0003\u0011I\u0003C\u0005\u00030\u0001\t\t\u0011\"\u0011\u00032!I!Q\b\u0001\u0002\u0002\u0013\u0005!q\b\u0005\n\u0005\u0007\u0002\u0011\u0011!C!\u0005\u000bB\u0011B!\u0013\u0001\u0003\u0003%\tEa\u0013\b\u0013\t=\u0014'!A\t\u0002\tEd\u0001\u0003\u00192\u0003\u0003E\tAa\u001d\t\u000f\u0005U\u0001\u0006\"\u0001\u0003\f\"I!Q\u0012\u0015\u0002\u0002\u0013\u0015#q\u0012\u0005\n\u0005#C\u0013\u0011!CA\u0005'C\u0011B!()#\u0003%\tAa\u0002\t\u0013\t}\u0005&!A\u0005\u0002\n\u0005\u0006\"\u0003BXQE\u0005I\u0011\u0001B\u0004\u0011%\u0011\t\fKA\u0001\n\u0013\u0011\u0019L\u0001\u0007Y[2$vn\u0015;sk\u000e$8O\u0003\u00023g\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t!T'\u0001\u0005dCR\fG._:u\u0015\t1t'A\u0002tc2T!\u0001O\u001d\u0002\u000bM\u0004\u0018M]6\u000b\u0005iZ\u0014AB1qC\u000eDWMC\u0001=\u0003\ry'oZ\u0002\u0001'!\u0001qh\u0011$J!Zc\u0006C\u0001!B\u001b\u0005\t\u0014B\u0001\"2\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001!E\u0013\t)\u0015GA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0001iR\u0005\u0003\u0011F\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tQUJ\u0004\u0002A\u0017&\u0011A*M\u0001\ba\u0006\u001c7.Y4f\u0013\tquJ\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u00051\u000b\u0004CA)U\u001b\u0005\u0011&BA*6\u0003\u0019)'O]8sg&\u0011QK\u0015\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011qKW\u0007\u00021*\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\n9\u0001K]8ek\u000e$\bCA/e\u001d\tq6M\u0004\u0002`E6\t\u0001M\u0003\u0002b{\u00051AH]8pizJ\u0011!W\u0005\u0003\u0019bK!!\u001a4\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00051C\u0016AB:dQ\u0016l\u0017-F\u0001j!\tQW.D\u0001l\u0015\taW'A\u0003usB,7/\u0003\u0002oW\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u00059q\u000e\u001d;j_:\u001cX#\u0001:\u0011\tM<(P\u001f\b\u0003iV\u0004\"a\u0018-\n\u0005YD\u0016A\u0002)sK\u0012,g-\u0003\u0002ys\n\u0019Q*\u00199\u000b\u0005YD\u0006CA:|\u0013\ta\u0018P\u0001\u0004TiJLgnZ\u0001\t_B$\u0018n\u001c8tA\u0005)1\r[5mIV\u0011\u0011\u0011\u0001\t\u0004\u0001\u0006\r\u0011bAA\u0003c\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0003\u0003\u001b\u0001BaVA\bu&\u0019\u0011\u0011\u0003-\u0003\r=\u0003H/[8o\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\rqJg.\u001b;?))\tI\"a\u0007\u0002\u001e\u0005}\u0011\u0011\u0005\t\u0003\u0001\u0002AQaZ\u0005A\u0002%DQ\u0001]\u0005A\u0002IDaA`\u0005A\u0002\u0005\u0005\u0001\"CA\u0005\u0013A\u0005\t\u0019AA\u0007)!\tI\"!\n\u0002(\u0005%\u0002B\u0002@\u000b\u0001\u0004\t\t\u0001\u0003\u0004h\u0015\u0001\u0007\u0011\u0011\u0001\u0005\u0006a*\u0001\rA]\u0001\t]VdG.\u00192mKV\u0011\u0011q\u0006\t\u0004/\u0006E\u0012bAA\u001a1\n9!i\\8mK\u0006t\u0017A\u00048vY2\f'\r\\3TG\",W.Y\u0001\u0010]VdG.\u00192mKN\u001b\u0007.Z7bAQ1\u0011\u0011DA\u001e\u0003{AaA \bA\u0002\u0005\u0005\u0001BB4\u000f\u0001\u0004\t\t\u0001\u0006\u0005\u0002\u001a\u0005\u0005\u00131IA#\u0011\u0019qx\u00021\u0001\u0002\u0002!1qm\u0004a\u0001\u0003\u0003Aa\u0001]\bA\u0002\u0005\u0005\u0011!C2p]Z,'\u000f^3s+\t\tY\u0005E\u0004X\u0003\u001b\n\t&a\u0016\n\u0007\u0005=\u0003LA\u0005Gk:\u001cG/[8ocA)Q,a\u0015\u0002X%\u0019\u0011Q\u000b4\u0003\u0011%#XM]1u_J\u0004B!!\u0017\u0002\\5\t1'C\u0002\u0002^M\u00121\"\u00138uKJt\u0017\r\u001c*po\"\u001a\u0001#!\u0019\u0011\u0007]\u000b\u0019'C\u0002\u0002fa\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002'9\fW.Z(g\u0007>\u0014(/\u001e9u%\u0016\u001cwN\u001d3\u0016\u0003i\fAC\\1nK>37i\u001c:skB$(+Z2pe\u0012\u0004\u0013A\u00029beN,'/\u0006\u0002\u0002rA)\u00111OA=u6\u0011\u0011Q\u000f\u0006\u0004\u0003o\u001a\u0014\u0001B;uS2LA!a\u001f\u0002v\t\tb)Y5mkJ,7+\u00194f!\u0006\u00148/\u001a:)\u0007M\t\t'\u0001\u0005eCR\fG+\u001f9f+\t\t\u0019\tE\u0002k\u0003\u000bK1!a\"l\u0005!!\u0015\r^1UsB,\u0017\u0001D<ji\"$\u0016.\\3[_:,GcA\"\u0002\u000e\"1\u0011\u0011B\u000bA\u0002i\fAB\\;mYN\u000bg-Z#wC2$B!a%\u0002\u001aB\u0019q+!&\n\u0007\u0005]\u0005LA\u0002B]fDq!a'\u0017\u0001\u0004\t\u0019*A\u0002y[2\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\u0005\u0016QVA\\!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATc\u000591m\u001c3fO\u0016t\u0017\u0002BAV\u0003K\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003_;\u0002\u0019AAY\u0003\r\u0019G\u000f\u001f\t\u0005\u0003G\u000b\u0019,\u0003\u0003\u00026\u0006\u0015&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003s;\u0002\u0019AAQ\u0003\t)g/\u0001\u0006j]B,H\u000fV=qKN,\"!a0\u0011\u000bu\u000b\t-!2\n\u0007\u0005\rgMA\u0002TKF\u00042A[Ad\u0013\r\tIm\u001b\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR!\u0011\u0011DAi\u0011\u001d\t\u0019N\u0007a\u0001\u0003\u0003\t\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002\u001a\u0005e\u00171\\Ao\u0003?DqaZ\u000e\u0011\u0002\u0003\u0007\u0011\u000eC\u0004q7A\u0005\t\u0019\u0001:\t\u0011y\\\u0002\u0013!a\u0001\u0003\u0003A\u0011\"!\u0003\u001c!\u0003\u0005\r!!\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001d\u0016\u0004S\u0006\u001d8FAAu!\u0011\tY/!>\u000e\u0005\u00055(\u0002BAx\u0003c\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M\b,\u0001\u0006b]:|G/\u0019;j_:LA!a>\u0002n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q \u0016\u0004e\u0006\u001d\u0018AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005\u0007QC!!\u0001\u0002h\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B\u0005U\u0011\ti!a:\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011y\u0001\u0005\u0003\u0003\u0012\tmQB\u0001B\n\u0015\u0011\u0011)Ba\u0006\u0002\t1\fgn\u001a\u0006\u0003\u00053\tAA[1wC&\u0019APa\u0005\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t\u0005\u0002cA,\u0003$%\u0019!Q\u0005-\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005M%1\u0006\u0005\n\u0005[\u0011\u0013\u0011!a\u0001\u0005C\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u001a!\u0019\u0011)Da\u000f\u0002\u00146\u0011!q\u0007\u0006\u0004\u0005sA\u0016AC2pY2,7\r^5p]&!\u0011Q\u000bB\u001c\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0018\u0005\u0003B\u0011B!\f%\u0003\u0003\u0005\r!a%\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0005\u001f\u00119\u0005C\u0005\u0003.\u0015\n\t\u00111\u0001\u0003\"\u00051Q-];bYN$B!a\f\u0003N!I!Q\u0006\u0014\u0002\u0002\u0003\u0007\u00111\u0013\u0015\u0014\u0001\tE#q\u000bB-\u0005;\u0012yFa\u0019\u0003f\t%$1\u000e\t\u0004\u0001\nM\u0013b\u0001B+c\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B.\u0003\u0001|f)\u0016(D?\"BX\u000e\\*ue2\u00023o\u00195f[\u0006\\F\u0006I8qi&|gn]/*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011tiJ,8\r\u001e\u0011wC2,X\rI<ji\"\u0004C\u000f[3!O&4XM\u001c\u0011aq6d7\u000b\u001e:aA\u0005tG\r\t1tG\",W.\u00191/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B1\u0003\u0011]%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014=azb\u0014MP\u0019=_\u0005tDH\u0019 1]abtF\u0019 =_Att\u0005\f\u0011(C\u0002Je\n\u0016\u0017!E\u0002\"u*\u0016\"M\u000b\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014\u0007\f\u0012cEi\u0002d\u0006O?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001db\u0004O\u0010\u001fuS6,gH\r\u001c0aaz#\u0007M\u00196y=\"\u0018.\\3?y=\u0002hh\n\u0017!OQLW.\u001a\u0011US6,7\u000f^1na\u001eb\u0003%\\1qQ\u001d\"\u0018.\\3ti\u0006l\u0007OR8s[\u0006$x\u0005\f\u0011(I\u0012|S*T\u0018zsfLx%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014C/[7fEi\u0012\u0004'M\u001b.aaj#G\u000e\u00111ai\u0002\u0004G\u000f\u00191{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\u00109?yQ,\u0017m\u00195fez\nE.[2fy=\"X-Y2iKJtDh\u001d;vI\u0016tGO\u0010\u001foC6,gHQ8cy=r\u0017-\\3?yI\fgn\u001b 2y=\u0012\u0018M\\6?y=\u001aH/\u001e3f]RtDh\u001d;vI\u0016tGO\u0010\u001foC6,gh\u00115be2LW\rP\u0018oC6,g\b\u0010:b].t$\u0007P\u0018sC:\\g\bP\u0018tiV$WM\u001c;?y=\u0002hh\n\u0017!OM#&+V\"UyQ,\u0017m\u00195fej\u00023\u000b\u0016*J\u001d\u001ec\u0003e\u001d;vI\u0016tGO\u000f\u0011B%J\u000b\u0015\fP*U%V\u001bE\u000b\u00108b[\u0016T\u0004e\u0015+S\u0013:;E\u0006\t:b].T\u0004%\u0013(U}yrt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\"X-Y2iKJ\u0014#HI!mS\u000e,'\u0005\f\u0012tiV$WM\u001c;#um[(E\\1nK\nR$EQ8cE1\u0012#/\u00198lEi\nT\u0010L>#]\u0006lWM\t\u001e#\u0007\"\f'\u000f\\5fE1\u0012#/\u00198lEi\u0012T0X?\u000bA\u0001\nQa\u001a:pkB\f#Aa\u001a\u0002\u0013alGn\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B7\u0003\u0015!d\u0006\r\u00181\u00031AV\u000e\u001c+p'R\u0014Xo\u0019;t!\t\u0001\u0005fE\u0003)\u0005k\u0012\t\t\u0005\u0007\u0003x\tu\u0014N]A\u0001\u0003\u001b\tI\"\u0004\u0002\u0003z)\u0019!1\u0010-\u0002\u000fI,h\u000e^5nK&!!q\u0010B=\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005\u0007\u0013I)\u0004\u0002\u0003\u0006*!!q\u0011B\f\u0003\tIw.C\u0002f\u0005\u000b#\"A!\u001d\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0004\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u0005e!Q\u0013BL\u00053\u0013Y\nC\u0003hW\u0001\u0007\u0011\u000eC\u0003qW\u0001\u0007!\u000f\u0003\u0004\u007fW\u0001\u0007\u0011\u0011\u0001\u0005\n\u0003\u0013Y\u0003\u0013!a\u0001\u0003\u001b\tq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ka+\u0011\u000b]\u000byA!*\u0011\u0013]\u00139+\u001b:\u0002\u0002\u00055\u0011b\u0001BU1\n1A+\u001e9mKRB\u0011B!,.\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005k\u0003BA!\u0005\u00038&!!\u0011\u0018B\n\u0005\u0019y%M[3di\u0002")
public class XmlToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
ExpectsInputTypes,
package.NullIntolerant,
QueryErrorsBase,
Serializable {
    private transient Function1<Iterator<InternalRow>, InternalRow> converter;
    private transient FailureSafeParser<String> parser;
    private final StructType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final StructType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return XmlToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<StructType, Map<String, String>, Expression, Option<String>>> unapply(XmlToStructs x$0) {
        return XmlToStructs$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return XmlToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<StructType, Map<String, String>, Expression, Option<String>>, XmlToStructs> tupled() {
        return XmlToStructs$.MODULE$.tupled();
    }

    public static Function1<StructType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, XmlToStructs>>>> curried() {
        return XmlToStructs$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private StructType nullableSchema() {
        return this.nullableSchema;
    }

    private Function1<Iterator<InternalRow>, InternalRow> converter$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.converter = (Function1 & Serializable)rows -> {
                    if (rows.hasNext()) {
                        return (InternalRow)rows.next();
                    }
                    return null;
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    private Function1<Iterator<InternalRow>, InternalRow> converter() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    private String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<String> parser$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ParseMode mode;
                XmlOptions parsedOptions = new XmlOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord(), XmlOptions$.MODULE$.$lessinit$greater$default$4());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_xml", mode);
                    }
                }
                ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                StaxXmlParser rawParser = new StaxXmlParser(this.schema(), parsedOptions);
                Option xsdSchema = Option$.MODULE$.apply((Object)parsedOptions.rowValidationXSDPath()).map((Function1 & Serializable)path -> ValidatorUtil$.MODULE$.getSchema((String)path));
                this.parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable(rawParser.doParseColumn((String)input, mode, (Option<Schema>)xsdSchema)), mode, this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    private FailureSafeParser<String> parser() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object xml) {
        return this.converter().apply(this.parser().parse(((UTF8String)xml).toString()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String expr = ctx.addReferenceObj("this", this, ctx.addReferenceObj$default$3());
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)input -> "(InternalRow) " + expr + ".nullSafeEval(" + input + ")");
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringTypeAnyCollation$ stringTypeAnyCollation$ = StringTypeAnyCollation$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringTypeAnyCollation$);
    }

    @Override
    public String prettyName() {
        return "from_xml";
    }

    @Override
    public XmlToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public XmlToStructs copy(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new XmlToStructs(schema, options, child, timeZoneId);
    }

    public StructType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "XmlToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.schema();
            }
            case 1: {
                return this.options();
            }
            case 2: {
                return this.child();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XmlToStructs;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "schema";
            }
            case 1: {
                return "options";
            }
            case 2: {
                return "child";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XmlToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        XmlToStructs xmlToStructs = (XmlToStructs)x$1;
        StructType structType = this.schema();
        StructType structType2 = xmlToStructs.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = xmlToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = xmlToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = xmlToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!xmlToStructs.canEqual(this)) return false;
        return true;
    }

    public XmlToStructs(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
        Statics.releaseFence();
    }

    public XmlToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public XmlToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public XmlToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

