/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.aggregate.HistogramNumeric$;
import org.apache.spark.sql.catalyst.expressions.aggregate.NumericHistogramSerializer$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.util.NumericHistogram;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(expr, nb) - Computes a histogram on numeric 'expr' using nb bins.\n      The return value is an array of (x,y) pairs representing the centers of the\n      histogram's bins. As the value of 'nb' is increased, the histogram approximation\n      gets finer-grained, but may yield artifacts around outliers. In practice, 20-40\n      histogram bins appear to work well, with more bins being required for skewed or\n      smaller datasets. Note that this function creates a histogram with non-uniform\n      bin widths. It offers no guarantees in terms of the mean-squared-error of the\n      histogram, but in practice is comparable to the histograms produced by the R/S-Plus\n      statistical computing packages. Note: the output type of the 'x' field in the return value is\n      propagated from the input value consumed in the aggregate function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(col, 5) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [{\"x\":0,\"y\":1.0},{\"x\":1,\"y\":1.0},{\"x\":2,\"y\":1.0},{\"x\":10,\"y\":1.0}]\n  ", group="agg_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\t\rf\u0001\u0002\u00192\u0001\u0002C\u0001\u0002\u001d\u0001\u0003\u0016\u0004%\t!\u001d\u0005\te\u0002\u0011\t\u0012)A\u0005+\"A1\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005u\u0001\tE\t\u0015!\u0003V\u0011!)\bA!f\u0001\n\u00032\b\u0002\u0003>\u0001\u0005#\u0005\u000b\u0011B<\t\u0011m\u0004!Q3A\u0005BYD\u0001\u0002 \u0001\u0003\u0012\u0003\u0006Ia\u001e\u0005\u0006{\u0002!\tA \u0005\u0007{\u0002!\t!!\u0003\t\u0015\u0005=\u0001\u0001#b\u0001\n\u0013\t\t\u0002\u0003\u0006\u0002\u001a\u0001A)\u0019!C\u0005\u00037Aq!a\t\u0001\t\u0003\n)\u0003C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBA1\u0001\u0011\u0005\u00131\r\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\t\t\b\u0001C!\u0003gBq!!\"\u0001\t\u0003\n9\t\u0003\u0004\u0002\u000e\u0002!\t%\u001d\u0005\u0007\u0003\u001f\u0003A\u0011I9\t\u000f\u0005E\u0005\u0001\"\u0015\u0002\u0014\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003W\u0003A\u0011IA\u000e\u0011\u001d\ti\u000b\u0001C!\u0003_Cq!a.\u0001\t\u0003\nI\fC\u0005\u0002L\u0002\t\t\u0011\"\u0001\u0002N\"I\u0011q\u001b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0003_\u0004\u0011\u0013!C\u0001\u00033D\u0011\"!=\u0001#\u0003%\t!a=\t\u0013\u0005]\b!%A\u0005\u0002\u0005M\b\"CA}\u0001\u0005\u0005I\u0011IA~\u0011!\u0011Y\u0001AA\u0001\n\u00031\b\"\u0003B\u0007\u0001\u0005\u0005I\u0011\u0001B\b\u0011%\u0011)\u0002AA\u0001\n\u0003\u00129\u0002C\u0005\u0003&\u0001\t\t\u0011\"\u0001\u0003(!I!1\u0006\u0001\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005c\u0001\u0011\u0011!C!\u0005g9\u0011Ba\u00162\u0003\u0003E\tA!\u0017\u0007\u0011A\n\u0014\u0011!E\u0001\u00057Ba! \u0016\u0005\u0002\tM\u0004\"\u0003B;U\u0005\u0005IQ\tB<\u0011%\u0011IHKA\u0001\n\u0003\u0013Y\bC\u0005\u0003\u0006*\n\t\u0011\"!\u0003\b\"I!\u0011\u0014\u0016\u0002\u0002\u0013%!1\u0014\u0002\u0011\u0011&\u001cHo\\4sC6tU/\\3sS\u000eT!AM\u001a\u0002\u0013\u0005<wM]3hCR,'B\u0001\u001b6\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005Y:\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005aJ\u0014aA:rY*\u0011!hO\u0001\u0006gB\f'o\u001b\u0006\u0003yu\na!\u00199bG\",'\"\u0001 \u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\t5j\u0014-_IB\u0019!iQ#\u000e\u0003EJ!\u0001R\u0019\u00031QK\b/\u001a3J[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002G\u00136\tqI\u0003\u0002Io\u0005!Q\u000f^5m\u0013\tQuI\u0001\tOk6,'/[2ISN$xn\u001a:b[B\u0011A*T\u0007\u0002g%\u0011aj\r\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0019\u0001kU+\u000e\u0003ES!AU\u001b\u0002\u000bQ\u0014X-Z:\n\u0005Q\u000b&A\u0003\"j]\u0006\u0014\u0018\u0010T5lKB\u0011AJV\u0005\u0003/N\u0012!\"\u0012=qe\u0016\u001c8/[8o!\tIF,D\u0001[\u0015\tYv'\u0001\u0004feJ|'o]\u0005\u0003;j\u0013q\"U;fef,%O]8sg\n\u000b7/\u001a\t\u0003?\nl\u0011\u0001\u0019\u0006\u0002C\u0006)1oY1mC&\u00111\r\u0019\u0002\b!J|G-^2u!\t)WN\u0004\u0002gW:\u0011qM[\u0007\u0002Q*\u0011\u0011nP\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005L!\u0001\u001c1\u0002\u000fA\f7m[1hK&\u0011an\u001c\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003Y\u0002\fQa\u00195jY\u0012,\u0012!V\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\u000b9\u0014\u0015N\\:\u0002\r9\u0014\u0015N\\:!\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A<\u0011\u0005}C\u0018BA=a\u0005\rIe\u000e^\u0001\u0018[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\nA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018!F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013}\f\t!a\u0001\u0002\u0006\u0005\u001d\u0001C\u0001\"\u0001\u0011\u0015\u0001\u0018\u00021\u0001V\u0011\u0015\u0019\u0018\u00021\u0001V\u0011\u0015)\u0018\u00021\u0001x\u0011\u0015Y\u0018\u00021\u0001x)\u0015y\u00181BA\u0007\u0011\u0015\u0001(\u00021\u0001V\u0011\u0015\u0019(\u00021\u0001V\u0003\tq'-\u0006\u0002\u0002\u0014A\u0019q,!\u0006\n\u0007\u0005]\u0001MA\u0002B]f\f!\u0003\u001d:pa\u0006<\u0017\r^3J]B,H\u000fV=qKV\u0011\u0011Q\u0004\t\u0004?\u0006}\u0011bAA\u0011A\n9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\u0011\u0011q\u0005\t\u0006K\u0006%\u0012QF\u0005\u0004\u0003Wy'aA*fcB!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024]\nQ\u0001^=qKNLA!a\u000e\u00022\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003{\u0001B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007*\u0014\u0001C1oC2L8/[:\n\t\u0005\u001d\u0013\u0011\t\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u000692M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002\u000b\u00061Q\u000f\u001d3bi\u0016$R!RA)\u0003+Ba!a\u0015\u0011\u0001\u0004)\u0015A\u00022vM\u001a,'\u000fC\u0004\u0002XA\u0001\r!!\u0017\u0002\u0011%t\u0007/\u001e;S_^\u0004B!a\u0017\u0002^5\tQ'C\u0002\u0002`U\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006)Q.\u001a:hKR)Q)!\u001a\u0002h!1\u00111K\tA\u0002\u0015Ca!!\u001b\u0012\u0001\u0004)\u0015!B8uQ\u0016\u0014\u0018\u0001B3wC2$B!a\u0005\u0002p!1\u00111\u000b\nA\u0002\u0015\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005U\u0014\u0011\u0011\t\u0006?\u0006]\u00141P\u0005\u0004\u0003s\u0002'!B!se\u0006L\bcA0\u0002~%\u0019\u0011q\u00101\u0003\t\tKH/\u001a\u0005\u0007\u0003\u0007\u001b\u0002\u0019A#\u0002\u0007=\u0014'.A\u0006eKN,'/[1mSj,GcA#\u0002\n\"9\u00111\u0012\u000bA\u0002\u0005U\u0014!\u00022zi\u0016\u001c\u0018\u0001\u00027fMR\fQA]5hQR\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b}\f)*!'\t\r\u0005]u\u00031\u0001V\u0003\u001dqWm\u001e'fMRDa!a'\u0018\u0001\u0004)\u0016\u0001\u00038foJKw\r\u001b;\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2a`AQ\u0011\u0019\t\u0019\u000b\u0007a\u0001o\u0006Ia.Z<PM\u001a\u001cX\r^\u0001\u001co&$\bNT3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\u0007}\fI\u000b\u0003\u0004\u0002$f\u0001\ra^\u0001\t]VdG.\u00192mK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u00022B!\u0011qFAZ\u0013\u0011\t),!\r\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\t\tY\f\u0005\u0003\u0002>\u0006\u0015g\u0002BA`\u0003\u0003\u0004\"a\u001a1\n\u0007\u0005\r\u0007-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\fIM\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007\u0004\u0017\u0001B2paf$\u0012b`Ah\u0003#\f\u0019.!6\t\u000fAl\u0002\u0013!a\u0001+\"91/\bI\u0001\u0002\u0004)\u0006bB;\u001e!\u0003\u0005\ra\u001e\u0005\bwv\u0001\n\u00111\u0001x\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a7+\u0007U\u000bin\u000b\u0002\u0002`B!\u0011\u0011]Av\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018!C;oG\",7m[3e\u0015\r\tI\u000fY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAw\u0003G\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002v*\u001aq/!8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!@\u0011\t\u0005}(\u0011B\u0007\u0003\u0005\u0003QAAa\u0001\u0003\u0006\u0005!A.\u00198h\u0015\t\u00119!\u0001\u0003kCZ\f\u0017\u0002BAd\u0005\u0003\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\tE\u0001\u0002\u0003B\nI\u0005\u0005\t\u0019A<\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u0002\u0005\u0004\u0003\u001c\t\u0005\u00121C\u0007\u0003\u0005;Q1Aa\ba\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005G\u0011iB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u000f\u0005SA\u0011Ba\u0005'\u0003\u0003\u0005\r!a\u0005\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003{\u0014y\u0003\u0003\u0005\u0003\u0014\u001d\n\t\u00111\u0001x\u0003\u0019)\u0017/^1mgR!\u0011Q\u0004B\u001b\u0011%\u0011\u0019\u0002KA\u0001\u0002\u0004\t\u0019\u0002K\n\u0001\u0005s\u0011yD!\u0011\u0003F\t\u001d#1\nB'\u0005#\u0012\u0019\u0006E\u0002M\u0005wI1A!\u00104\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u0011\u0002\rcS\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(\u000f\f\u0011oE&\u0002S\u0006I\"p[B,H/Z:!C\u0002B\u0017n\u001d;pOJ\fW\u000eI8oA9,X.\u001a:jG\u0002:S\r\u001f9sO\u0001*8/\u001b8hA9\u0014\u0007EY5og:R\u0001\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011sKR,(O\u001c\u0011wC2,X\rI5tA\u0005t\u0007%\u0019:sCf\u0004sN\u001a\u0011)q2J\u0018\u0006\t9bSJ\u001c\bE]3qe\u0016\u001cXM\u001c;j]\u001e\u0004C\u000f[3!G\u0016tG/\u001a:tA=4\u0007\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005\t\u0011!Q&\u001cHo\\4sC6<3\u000f\t2j]Nt\u0003%Q:!i\",\u0007E^1mk\u0016\u0004sN\u001a\u0011(]\n<\u0003%[:!S:\u001c'/Z1tK\u0012d\u0003\u0005\u001e5fA!L7\u000f^8he\u0006l\u0007%\u00199qe>D\u0018.\\1uS>t'\u0002\t\u0011!A\u0001\u0002s-\u001a;tA\u0019Lg.\u001a:.OJ\f\u0017N\\3eY\u0001\u0012W\u000f\u001e\u0011nCf\u0004\u00130[3mI\u0002\n'\u000f^5gC\u000e$8\u000fI1s_VtG\rI8vi2LWM]:/A%s\u0007\u0005\u001d:bGRL7-\u001a\u0017!eAjC\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t5jgR|wM]1nA\tLgn\u001d\u0011baB,\u0017M\u001d\u0011u_\u0002:xN]6!o\u0016dG\u000e\f\u0011xSRD\u0007%\\8sK\u0002\u0012\u0017N\\:!E\u0016Lgn\u001a\u0011sKF,\u0018N]3eA\u0019|'\u000fI:lK^,G\rI8s\u0015\u0001\u0002\u0003\u0005\t\u0011!g6\fG\u000e\\3sA\u0011\fG/Y:fiNt\u0003ET8uK\u0002\"\b.\u0019;!i\"L7\u000f\t4v]\u000e$\u0018n\u001c8!GJ,\u0017\r^3tA\u0005\u0004\u0003.[:u_\u001e\u0014\u0018-\u001c\u0011xSRD\u0007E\\8o[Ut\u0017NZ8s[*\u0001\u0003\u0005\t\u0011!A\tLg\u000eI<jIRD7O\f\u0011Ji\u0002zgMZ3sg\u0002rw\u000eI4vCJ\fg\u000e^3fg\u0002Jg\u000e\t;fe6\u001c\be\u001c4!i\",\u0007%\\3b]6\u001a\u0018/^1sK\u0012lSM\u001d:pe\u0002zg\r\t;iK*\u0001\u0003\u0005\t\u0011!A!L7\u000f^8he\u0006lG\u0006\t2vi\u0002Jg\u000e\t9sC\u000e$\u0018nY3!SN\u00043m\\7qCJ\f'\r\\3!i>\u0004C\u000f[3!Q&\u001cHo\\4sC6\u001c\b\u0005\u001d:pIV\u001cW\r\u001a\u0011cs\u0002\"\b.\u001a\u0011S_Mk\u0003\u000b\\;t\u0015\u0001\u0002\u0003\u0005\t\u0011!gR\fG/[:uS\u000e\fG\u000eI2p[B,H/\u001b8hAA\f7m[1hKNt\u0003ET8uKj\u0002C\u000f[3!_V$\b/\u001e;!if\u0004X\rI8gAQDW\rI\u0014yO\u00012\u0017.\u001a7eA%t\u0007\u0005\u001e5fAI,G/\u001e:oAY\fG.^3!SNT\u0001\u0005\t\u0011!A\u0001\u0002(o\u001c9bO\u0006$X\r\u001a\u0011ge>l\u0007\u0005\u001e5fA%t\u0007/\u001e;!m\u0006dW/\u001a\u0011d_:\u001cX/\\3eA%t\u0007\u0005\u001e5fA\u0005<wM]3hCR,\u0007EZ;oGRLwN\u001c\u0018\u000bA\u0001\u0002\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011I%AA'\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!k%\u0002cIU(NAY\u000bE*V#TA!\u0002\u0014\u0006\f\u0011)c%b\u0003\u0005\u000b\u001a*Y\u0001B\u0013\u0007M\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\w\nB(E\u000f\u0019-Ee\u0014#(\r\u00181{2Z(\u0005\u001f\u0012;c1\u0012\u0013P\t\u001e2]AjHf\u001f\u0012yEi\u0012DFI=#uEr\u0003' \u0017|Ea\u0014#(\r\u0019-Ee\u0014#(\r\u00181{vS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005\u001f\n\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\tU\u0013!B\u001a/g9\u0002\u0014\u0001\u0005%jgR|wM]1n\u001dVlWM]5d!\t\u0011%fE\u0003+\u0005;\u0012I\u0007E\u0005\u0003`\t\u0015T+V<x\u007f6\u0011!\u0011\r\u0006\u0004\u0005G\u0002\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005O\u0012\tGA\tBEN$(/Y2u\rVt7\r^5p]R\u0002BAa\u001b\u0003r5\u0011!Q\u000e\u0006\u0005\u0005_\u0012)!\u0001\u0002j_&\u0019aN!\u001c\u0015\u0005\te\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0018!B1qa2LH#C@\u0003~\t}$\u0011\u0011BB\u0011\u0015\u0001X\u00061\u0001V\u0011\u0015\u0019X\u00061\u0001V\u0011\u0015)X\u00061\u0001x\u0011\u0015YX\u00061\u0001x\u0003\u001d)h.\u00199qYf$BA!#\u0003\u0016B)qLa#\u0003\u0010&\u0019!Q\u00121\u0003\r=\u0003H/[8o!\u001dy&\u0011S+Vo^L1Aa%a\u0005\u0019!V\u000f\u001d7fi!A!q\u0013\u0018\u0002\u0002\u0003\u0007q0A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!(\u0011\t\u0005}(qT\u0005\u0005\u0005C\u0013\tA\u0001\u0004PE*,7\r\u001e")
public class HistogramNumeric
extends TypedImperativeAggregate<NumericHistogram>
implements ImplicitCastInputTypes,
BinaryLike<Expression>,
QueryErrorsBase,
Serializable {
    private Object nb;
    private boolean propagateInputType;
    private final Expression child;
    private final Expression nBins;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(HistogramNumeric x$0) {
        return HistogramNumeric$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, HistogramNumeric> tupled() {
        return HistogramNumeric$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, HistogramNumeric>>>> curried() {
        return HistogramNumeric$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression nBins() {
        return this.nBins;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private Object nb$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Integer n;
                Object object = this.nBins().eval(this.nBins().eval$default$1());
                if (object == null) {
                    n = null;
                } else if (object instanceof Integer) {
                    int n2 = BoxesRunTime.unboxToInt((Object)object);
                    n = BoxesRunTime.boxToInteger((int)n2);
                } else {
                    throw new MatchError(object);
                }
                this.nb = n;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.nb;
    }

    private Object nb() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.nb$lzycompute();
        }
        return this.nb;
    }

    private boolean propagateInputType$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.propagateInputType = SQLConf$.MODULE$.get().histogramNumericPropagateInputType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.propagateInputType;
    }

    private boolean propagateInputType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.propagateInputType$lzycompute();
        }
        return this.propagateInputType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!this.nBins().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.toSQLId("nb")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.nBins().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.nBins()))}))));
        }
        if (this.nb() == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"nb")}))));
        }
        if (BoxesRunTime.unboxToInt((Object)this.nb()) < 2) {
            return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"nb"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)("[2, " + Integer.MAX_VALUE + "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)this.toSQLValue(this.nb(), (DataType)IntegerType$.MODULE$))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public NumericHistogram createAggregationBuffer() {
        NumericHistogram buffer = new NumericHistogram();
        buffer.allocate(BoxesRunTime.unboxToInt((Object)this.nb()));
        return buffer;
    }

    @Override
    public NumericHistogram update(NumericHistogram buffer, InternalRow inputRow) {
        block0: {
            Object value = this.child().eval(inputRow);
            if (value == null) break block0;
            double doubleValue = ((Number)value).doubleValue();
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public NumericHistogram merge(NumericHistogram buffer, NumericHistogram other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(NumericHistogram buffer) {
        if (buffer.getUsedBins() < 1) {
            return null;
        }
        Object[] array = new Object[buffer.getUsedBins()];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), buffer.getUsedBins()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            NumericHistogram.Coord coord = buffer.getBin(index);
            if (this.propagateInputType()) {
                DataType dataType = this.left().dataType();
                Byte result = ByteType$.MODULE$.equals(dataType) ? (Number)BoxesRunTime.boxToByte((byte)((byte)coord.x)) : (Number)((IntegerType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType)) ? (Number)BoxesRunTime.boxToInteger((int)((int)coord.x)) : (Number)(FloatType$.MODULE$.equals(dataType) ? (Number)BoxesRunTime.boxToFloat((float)((float)coord.x)) : (Number)(ShortType$.MODULE$.equals(dataType) ? (Number)BoxesRunTime.boxToShort((short)((short)coord.x)) : (Number)((dataType instanceof DayTimeIntervalType ? true : (LongType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)))) ? (Number)BoxesRunTime.boxToLong((long)((long)coord.x)) : (Number)BoxesRunTime.boxToDouble((double)coord.x)))));
                array$1[index] = InternalRow$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{result, BoxesRunTime.boxToDouble((double)coord.y)}));
                return;
            }
            array$1[index] = InternalRow$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)coord.x), BoxesRunTime.boxToDouble((double)coord.y)}));
        });
        return new GenericArrayData((Object)array);
    }

    @Override
    public byte[] serialize(NumericHistogram obj) {
        return NumericHistogramSerializer$.MODULE$.serialize(obj);
    }

    @Override
    public NumericHistogram deserialize(byte[] bytes) {
        return NumericHistogramSerializer$.MODULE$.deserialize(bytes);
    }

    @Override
    public Expression left() {
        return this.child();
    }

    @Override
    public Expression right() {
        return this.nBins();
    }

    @Override
    public HistogramNumeric withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public HistogramNumeric withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public HistogramNumeric withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType((DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("x", (DataType)(this.propagateInputType() ? this.left().dataType() : DoubleType$.MODULE$), true, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})), true);
    }

    @Override
    public String prettyName() {
        return "histogram_numeric";
    }

    public HistogramNumeric copy(Expression child, Expression nBins, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HistogramNumeric(child, nBins, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.nBins();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HistogramNumeric";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.nBins();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HistogramNumeric;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "nBins";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HistogramNumeric)) return false;
        boolean bl = true;
        if (!bl) return false;
        HistogramNumeric histogramNumeric = (HistogramNumeric)x$1;
        if (this.mutableAggBufferOffset() != histogramNumeric.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != histogramNumeric.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = histogramNumeric.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.nBins();
        Expression expression4 = histogramNumeric.nBins();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!histogramNumeric.canEqual(this)) return false;
        return true;
    }

    public HistogramNumeric(Expression child, Expression nBins, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.nBins = nBins;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public HistogramNumeric(Expression child, Expression nBins) {
        this(child, nBins, 0, 0);
    }
}

