/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskKilledException;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.metrics.source.CodegenMetrics$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.HashableWeakReference;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEquals;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.ByteCodeStats;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.EmptyBlock$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.SubExprEliminationState;
import org.apache.spark.sql.catalyst.expressions.codegen.VariableValue;
import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType$;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType$;
import org.apache.spark.sql.catalyst.types.PhysicalByteType$;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType$;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType$;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType$;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalNullType$;
import org.apache.spark.sql.catalyst.types.PhysicalShortType$;
import org.apache.spark.sql.catalyst.types.PhysicalStringType;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.catalyst.types.PhysicalVariantType;
import org.apache.spark.sql.catalyst.types.PhysicalVariantType$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.CollationAwareUTF8String;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.NonFateSharingCache$;
import org.apache.spark.util.NonFateSharingLoadingCache;
import org.apache.spark.util.ParentClassLoader;
import org.apache.spark.util.Utils$;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.InternalCompilerException;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.sparkproject.guava.util.concurrent.ExecutionError;
import org.sparkproject.guava.util.concurrent.UncheckedExecutionException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class CodeGenerator$
implements Logging {
    public static final CodeGenerator$ MODULE$ = new CodeGenerator$();
    private static final LongAccumulator _compileTime;
    private static final NonFateSharingLoadingCache<Tuple2<HashableWeakReference, CodeAndComment>, Tuple2<GeneratedClass, ByteCodeStats>> cache;
    private static final Seq<String> primitiveTypes;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        _compileTime = new LongAccumulator();
        Function1 & Serializable loadFunc = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                CodeAndComment code = (CodeAndComment)tuple2._2();
                long startTime = System.nanoTime();
                Tuple2<GeneratedClass, ByteCodeStats> result = MODULE$.doCompile(code);
                long endTime = System.nanoTime();
                long duration = endTime - startTime;
                double timeMs = (double)duration / (double)1000000L;
                CodegenMetrics$.MODULE$.METRIC_SOURCE_CODE_SIZE().update(code.body().length());
                CodegenMetrics$.MODULE$.METRIC_COMPILATION_TIME().update((long)timeMs);
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Code generated in ", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TOTAL_TIME$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)timeMs))}))));
                MODULE$._compileTime().add(duration);
                return result;
            }
            throw new MatchError((Object)tuple2);
        };
        cache = NonFateSharingCache$.MODULE$.apply((Function1)loadFunc, (long)SQLConf$.MODULE$.get().codegenCacheMaxEntries());
        primitiveTypes = new .colon.colon((Object)"boolean", (List)new .colon.colon((Object)"byte", (List)new .colon.colon((Object)"short", (List)new .colon.colon((Object)"int", (List)new .colon.colon((Object)"long", (List)new .colon.colon((Object)"float", (List)new .colon.colon((Object)"double", (List)Nil$.MODULE$)))))));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public final int DEFAULT_JVM_HUGE_METHOD_LIMIT() {
        return 8000;
    }

    public final int MAX_JVM_METHOD_PARAMS_LENGTH() {
        return 255;
    }

    public final int MAX_JVM_CONSTANT_POOL_SIZE() {
        return 65535;
    }

    public final int MERGE_SPLIT_METHODS_THRESHOLD() {
        return 3;
    }

    public final int GENERATED_CLASS_SIZE_THRESHOLD() {
        return 1000000;
    }

    public final int OUTER_CLASS_VARIABLES_THRESHOLD() {
        return 10000;
    }

    public final int MUTABLESTATEARRAY_SIZE_LIMIT() {
        return 32768;
    }

    private LongAccumulator _compileTime() {
        return _compileTime;
    }

    public long compileTime() {
        return this._compileTime().sum();
    }

    public void resetCompileTime() {
        this._compileTime().reset();
    }

    public Tuple2<GeneratedClass, ByteCodeStats> compile(CodeAndComment code) {
        Tuple2 tuple2;
        try {
            HashableWeakReference classLoaderRef = new HashableWeakReference((Object)Utils$.MODULE$.getContextOrSparkClassLoader());
            tuple2 = (Tuple2)this.cache().get((Object)new Tuple2((Object)classLoaderRef, (Object)code));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
        return tuple2;
    }

    private Tuple2<GeneratedClass, ByteCodeStats> doCompile(CodeAndComment code) {
        ByteCodeStats byteCodeStats;
        ClassBodyEvaluator evaluator = new ClassBodyEvaluator();
        ParentClassLoader parentClassLoader = new ParentClassLoader(Utils$.MODULE$.getContextOrSparkClassLoader());
        evaluator.setParentClassLoader((ClassLoader)parentClassLoader);
        evaluator.setClassName("org.apache.spark.sql.catalyst.expressions.GeneratedClass");
        evaluator.setDefaultImports(new String[]{Platform.class.getName(), InternalRow.class.getName(), UnsafeRow.class.getName(), UTF8String.class.getName(), Decimal.class.getName(), CalendarInterval.class.getName(), VariantVal.class.getName(), ArrayData.class.getName(), UnsafeArrayData.class.getName(), MapData.class.getName(), UnsafeMapData.class.getName(), Expression.class.getName(), TaskContext.class.getName(), TaskKilledException.class.getName(), InputMetrics.class.getName(), CollationAwareUTF8String.class.getName(), CollationFactory.class.getName(), CollationSupport.class.getName(), StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(QueryExecutionErrors$.MODULE$.getClass().getName()), "$")});
        evaluator.setExtendedClass(GeneratedClass.class);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> {
            evaluator.setDebuggingInformation(true, true, false);
            return "\n" + CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2());
        });
        try {
            evaluator.cook("generated.java", code.body());
            byteCodeStats = this.updateAndGetCompilationStats(evaluator);
        }
        catch (InternalCompilerException e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to compile the generated Java code.", (Throwable)e);
            this.logGeneratedCode(code);
            throw QueryExecutionErrors$.MODULE$.internalCompilerError(e);
        }
        catch (CompileException e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to compile the generated Java code.", (Throwable)e);
            this.logGeneratedCode(code);
            throw QueryExecutionErrors$.MODULE$.compilerError(e);
        }
        ByteCodeStats codeStats = byteCodeStats;
        return new Tuple2((Object)((GeneratedClass)evaluator.getClazz().getConstructor(new Class[0]).newInstance(new Object[0])), (Object)codeStats);
    }

    private void logGeneratedCode(CodeAndComment code) {
        int maxLines = SQLConf$.MODULE$.get().loggingMaxLinesForCodegen();
        if (Utils$.MODULE$.isTesting()) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "\n" + CodeFormatter$.MODULE$.format(code, maxLines));
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "\n" + CodeFormatter$.MODULE$.format(code, maxLines));
    }

    private ByteCodeStats updateAndGetCompilationStats(ClassBodyEvaluator evaluator) {
        Map classes = CollectionConverters$.MODULE$.MapHasAsScala(evaluator.getBytecodes()).asScala();
        Class codeAttr = Utils$.MODULE$.classForName("org.codehaus.janino.util.ClassFile$CodeAttribute", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        Field codeAttrField = codeAttr.getDeclaredField("code");
        codeAttrField.setAccessible(true);
        Map codeStats = (Map)classes.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2.mcII.sp sp2;
                byte[] classBytes = (byte[])tuple2._2();
                int classCodeSize = classBytes.length;
                CodegenMetrics$.MODULE$.METRIC_GENERATED_CLASS_BYTECODE_SIZE().update(classCodeSize);
                try {
                    ClassFile cf = new ClassFile((InputStream)new ByteArrayInputStream(classBytes));
                    int constPoolSize = cf.getConstantPoolSize();
                    Buffer methodCodeSizes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(cf.methodInfos).asScala().flatMap((Function1 & Serializable)method -> Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])method.getAttributes()), (Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)CodeGenerator$.$anonfun$updateAndGetCompilationStats$3(codeAttr, x$22)))), (Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)CodeGenerator$.$anonfun$updateAndGetCompilationStats$4(codeAttrField, cf, method, a)), (ClassTag)ClassTag$.MODULE$.Int())));
                    sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)methodCodeSizes.max((Ordering)Ordering.Int$.MODULE$)), constPoolSize);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable2)) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error calculating stats of compiled class.", throwable2);
                        sp2 = new Tuple2.mcII.sp(-1, -1);
                    }
                    throw throwable;
                }
                return sp2;
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple2 tuple2 = codeStats.unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable maxMethodSizes = (Iterable)tuple2._1();
        Iterable constPoolSize = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)maxMethodSizes, (Object)constPoolSize);
        Iterable maxMethodSizes2 = (Iterable)tuple22._1();
        Iterable constPoolSize2 = (Iterable)tuple22._2();
        return new ByteCodeStats(BoxesRunTime.unboxToInt((Object)maxMethodSizes2.max((Ordering)Ordering.Int$.MODULE$)), BoxesRunTime.unboxToInt((Object)constPoolSize2.max((Ordering)Ordering.Int$.MODULE$)), classes.size() - 2);
    }

    private NonFateSharingLoadingCache<Tuple2<HashableWeakReference, CodeAndComment>, Tuple2<GeneratedClass, ByteCodeStats>> cache() {
        return cache;
    }

    public final String JAVA_BOOLEAN() {
        return "boolean";
    }

    public final String JAVA_BYTE() {
        return "byte";
    }

    public final String JAVA_SHORT() {
        return "short";
    }

    public final String JAVA_INT() {
        return "int";
    }

    public final String JAVA_LONG() {
        return "long";
    }

    public final String JAVA_FLOAT() {
        return "float";
    }

    public final String JAVA_DOUBLE() {
        return "double";
    }

    public Seq<String> primitiveTypes() {
        return primitiveTypes;
    }

    public boolean isPrimitiveType(String jt) {
        return this.primitiveTypes().contains((Object)jt);
    }

    public boolean isPrimitiveType(DataType dt) {
        return this.isPrimitiveType(this.javaType(dt));
    }

    public String getValue(String input, DataType dataType, String ordinal) {
        String jt;
        while (true) {
            jt = this.javaType(dataType);
            DataType dataType2 = dataType;
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        if (this.isPrimitiveType(jt)) {
            return input + ".get" + this.primitiveTypeName(jt) + "(" + ordinal + ")";
        }
        PhysicalDataType physicalDataType = PhysicalDataType$.MODULE$.apply(dataType);
        if (physicalDataType instanceof PhysicalArrayType) {
            return input + ".getArray(" + ordinal + ")";
        }
        if (PhysicalBinaryType$.MODULE$.equals(physicalDataType)) {
            return input + ".getBinary(" + ordinal + ")";
        }
        if (PhysicalCalendarIntervalType$.MODULE$.equals(physicalDataType)) {
            return input + ".getInterval(" + ordinal + ")";
        }
        if (physicalDataType instanceof PhysicalDecimalType) {
            PhysicalDecimalType physicalDecimalType = (PhysicalDecimalType)physicalDataType;
            return input + ".getDecimal(" + ordinal + ", " + physicalDecimalType.precision() + ", " + physicalDecimalType.scale() + ")";
        }
        if (physicalDataType instanceof PhysicalMapType) {
            return input + ".getMap(" + ordinal + ")";
        }
        if (PhysicalNullType$.MODULE$.equals(physicalDataType)) {
            return "null";
        }
        if (physicalDataType instanceof PhysicalStringType) {
            return input + ".getUTF8String(" + ordinal + ")";
        }
        if (physicalDataType instanceof PhysicalStructType) {
            PhysicalStructType physicalStructType = (PhysicalStructType)physicalDataType;
            return input + ".getStruct(" + ordinal + ", " + physicalStructType.fields().length + ")";
        }
        if (PhysicalVariantType$.MODULE$.equals(physicalDataType)) {
            return input + ".getVariant(" + ordinal + ")";
        }
        return "(" + jt + ")" + input + ".get(" + ordinal + ", null)";
    }

    public String createArrayData(String arrayName, DataType elementType, String numElements, String additionalErrorMessage) {
        int elementSize = this.isPrimitiveType(elementType) ? elementType.defaultSize() : -1;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |ArrayData " + arrayName + " = ArrayData.allocateArrayData(\n       |  " + elementSize + ", " + numElements + ", \"" + additionalErrorMessage + "\");\n     "));
    }

    public String createArrayAssignment(String dstArray, DataType elementType, String srcArray, String dstArrayIndex, String srcArrayIndex, boolean needNullCheck) {
        return this.setArrayElement(dstArray, elementType, dstArrayIndex, this.getValue(srcArray, elementType, srcArrayIndex), (Option<String>)(needNullCheck ? new Some((Object)(srcArray + ".isNullAt(" + srcArrayIndex + ")")) : None$.MODULE$));
    }

    public String setColumn(String row, DataType dataType, int ordinal, String value) {
        DataType dataType2;
        while (true) {
            String jt = this.javaType(dataType);
            dataType2 = dataType;
            if (this.isPrimitiveType(jt)) {
                return row + ".set" + this.primitiveTypeName(jt) + "(" + ordinal + ", " + value + ")";
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
                return row + ".setInterval(" + ordinal + ", " + value + ")";
            }
            if (dataType2 instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType2;
                return row + ".setDecimal(" + ordinal + ", " + value + ", " + decimalType.precision() + ")";
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        if (dataType2 instanceof StringType ? true : (dataType2 instanceof StructType ? true : (dataType2 instanceof ArrayType ? true : dataType2 instanceof MapType))) {
            return row + ".update(" + ordinal + ", " + value + ".copy())";
        }
        return row + ".update(" + ordinal + ", " + value + ")";
    }

    public String updateColumn(String row, DataType dataType, int ordinal, ExprCode ev, boolean nullable, boolean isVectorized) {
        if (nullable) {
            if (!isVectorized && UnsafeRowUtils$.MODULE$.avoidSetNullAt(dataType)) {
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (!" + ev.isNull() + ") {\n           |  " + this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value())) + ";\n           |} else {\n           |  " + this.setColumn(row, dataType, ordinal, "null") + ";\n           |}\n         "));
            }
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (!" + ev.isNull() + ") {\n           |  " + this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value())) + ";\n           |} else {\n           |  " + row + ".setNullAt(" + ordinal + ");\n           |}\n         "));
        }
        return this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value())) + ";";
    }

    public String setValue(String vector, String rowId, DataType dataType, String value) {
        String jt = this.javaType(dataType);
        DataType dataType2 = dataType;
        if (this.isPrimitiveType(jt)) {
            return vector + ".put" + this.primitiveTypeName(jt) + "(" + rowId + ", " + value + ");";
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return vector + ".putDecimal(" + rowId + ", " + value + ", " + decimalType.precision() + ");";
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            return vector + ".putInterval(" + rowId + ", " + value + ");";
        }
        if (dataType2 instanceof StringType) {
            return vector + ".putByteArray(" + rowId + ", " + value + ".getBytes());";
        }
        throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3233", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})));
    }

    public String setArrayElement(String array, DataType elementType, String i, String value, Option<String> isNull) {
        String setFunc;
        boolean isPrimitiveType = this.isPrimitiveType(elementType);
        String string = setFunc = isPrimitiveType ? "set" + this.primitiveTypeName(elementType) : "update";
        if (isNull.isDefined() && isPrimitiveType) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + isNull.get() + ") {\n         |  " + array + ".setNullAt(" + i + ");\n         |} else {\n         |  " + array + "." + setFunc + "(" + i + ", " + value + ");\n         |}\n       "));
        }
        return array + "." + setFunc + "(" + i + ", " + value + ");";
    }

    public Option<String> setArrayElement$default$5() {
        return None$.MODULE$;
    }

    public String updateColumn(String vector, String rowId, DataType dataType, ExprCode ev, boolean nullable) {
        if (nullable) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (!" + ev.isNull() + ") {\n         |  " + this.setValue(vector, rowId, dataType, ExprValue$.MODULE$.exprValueToString(ev.value())) + "\n         |} else {\n         |  " + vector + ".putNull(" + rowId + ");\n         |}\n       "));
        }
        return this.setValue(vector, rowId, dataType, ExprValue$.MODULE$.exprValueToString(ev.value())) + ";";
    }

    public boolean updateColumn$default$6() {
        return false;
    }

    public String getValueFromVector(String vector, DataType dataType, String rowId) {
        DataType sqlDataType;
        DataType dataType2 = dataType;
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            v0 = userDefinedType.sqlType();
        } else {
            v0 = sqlDataType = dataType;
        }
        if (sqlDataType instanceof StructType) {
            return vector + ".getStruct(" + rowId + ")";
        }
        return this.getValue(vector, sqlDataType, rowId);
    }

    public Tuple2<scala.collection.immutable.Set<VariableValue>, scala.collection.immutable.Set<ExprCode>> getLocalInputVariableValues(CodegenContext ctx, Expression expr, scala.collection.immutable.Map<ExpressionEquals, SubExprEliminationState> subExprs) {
        Set argSet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set exprCodesNeedEvaluate = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = ctx.INPUT_ROW() != null ? argSet.$plus$eq((Object)JavaCode$.MODULE$.variable(ctx.INPUT_ROW(), InternalRow.class)) : BoxedUnit.UNIT;
        Function1 & Serializable collectLocalVariable = (Function1 & Serializable)ev -> {
            ExprValue exprValue = ev;
            if (exprValue instanceof VariableValue) {
                VariableValue variableValue = (VariableValue)exprValue;
                return argSet.$plus$eq((Object)variableValue);
            }
            return BoxedUnit.UNIT;
        };
        Stack stack = (Stack)Stack$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{expr}));
        while (stack.nonEmpty()) {
            Option option;
            Expression expression = (Expression)stack.pop();
            if (expression instanceof BoundReference) {
                BoundReference boundReference = (BoundReference)expression;
                if (ctx.currentVars() != null && ctx.currentVars().apply(boundReference.ordinal()) != null) {
                    ExprCode exprCode = (ExprCode)ctx.currentVars().apply(boundReference.ordinal());
                    Block block = exprCode.code();
                    EmptyBlock$ emptyBlock$ = EmptyBlock$.MODULE$;
                    if (block == null ? emptyBlock$ != null : !block.equals(emptyBlock$)) {
                        exprCodesNeedEvaluate.$plus$eq((Object)exprCode.copy(exprCode.copy$default$1(), exprCode.copy$default$2(), exprCode.copy$default$3()));
                        exprCode.code_$eq(EmptyBlock$.MODULE$);
                    }
                    collectLocalVariable.apply((Object)exprCode.value());
                    collectLocalVariable.apply((Object)exprCode.isNull());
                    continue;
                }
            }
            if ((option = subExprs.get((Object)new ExpressionEquals(expression))) instanceof Some) {
                Some some = (Some)option;
                SubExprEliminationState state = (SubExprEliminationState)some.value();
                collectLocalVariable.apply((Object)state.eval().value());
                collectLocalVariable.apply((Object)state.eval().isNull());
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                stack.pushAll(expression.children());
                continue;
            }
            throw new MatchError((Object)option);
        }
        return new Tuple2((Object)argSet.toSet(), (Object)exprCodesNeedEvaluate.toSet());
    }

    public scala.collection.immutable.Map<ExpressionEquals, SubExprEliminationState> getLocalInputVariableValues$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public String primitiveTypeName(String jt) {
        String string = jt;
        switch (string == null ? 0 : string.hashCode()) {
            case 104431: {
                if (!"int".equals(string)) break;
                return "Int";
            }
        }
        return this.boxedType(jt);
    }

    public String primitiveTypeName(DataType dt) {
        return this.primitiveTypeName(this.javaType(dt));
    }

    public String javaType(DataType dt) {
        DataType dataType;
        ObjectType objectType;
        boolean bl;
        while (true) {
            bl = false;
            objectType = null;
            dataType = dt;
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof ObjectType) {
            bl = true;
            objectType = (ObjectType)dataType;
            Class cls = objectType.cls();
            if (cls.isArray()) {
                return this.javaType((DataType)new ObjectType(cls.getComponentType())) + "[]";
            }
        }
        if (bl) {
            Class cls = objectType.cls();
            return cls.getName();
        }
        PhysicalDataType physicalDataType = PhysicalDataType$.MODULE$.apply(dt);
        if (physicalDataType instanceof PhysicalArrayType) {
            return "ArrayData";
        }
        if (PhysicalBinaryType$.MODULE$.equals(physicalDataType)) {
            return "byte[]";
        }
        if (PhysicalBooleanType$.MODULE$.equals(physicalDataType)) {
            return "boolean";
        }
        if (PhysicalByteType$.MODULE$.equals(physicalDataType)) {
            return "byte";
        }
        if (PhysicalCalendarIntervalType$.MODULE$.equals(physicalDataType)) {
            return "CalendarInterval";
        }
        if (PhysicalIntegerType$.MODULE$.equals(physicalDataType)) {
            return "int";
        }
        if (physicalDataType instanceof PhysicalDecimalType) {
            return "Decimal";
        }
        if (PhysicalDoubleType$.MODULE$.equals(physicalDataType)) {
            return "double";
        }
        if (PhysicalFloatType$.MODULE$.equals(physicalDataType)) {
            return "float";
        }
        if (PhysicalLongType$.MODULE$.equals(physicalDataType)) {
            return "long";
        }
        if (physicalDataType instanceof PhysicalMapType) {
            return "MapData";
        }
        if (PhysicalShortType$.MODULE$.equals(physicalDataType)) {
            return "short";
        }
        if (physicalDataType instanceof PhysicalStringType) {
            return "UTF8String";
        }
        if (physicalDataType instanceof PhysicalStructType) {
            return "InternalRow";
        }
        if (physicalDataType instanceof PhysicalVariantType) {
            return "VariantVal";
        }
        return "Object";
    }

    public Class<?> javaClass(DataType dt) {
        DataType dataType;
        while (true) {
            if (BooleanType$.MODULE$.equals(dataType = dt)) {
                return Boolean.TYPE;
            }
            if (ByteType$.MODULE$.equals(dataType)) {
                return Byte.TYPE;
            }
            if (ShortType$.MODULE$.equals(dataType)) {
                return Short.TYPE;
            }
            if (IntegerType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType)) {
                return Integer.TYPE;
            }
            if (LongType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType))) {
                return Long.TYPE;
            }
            if (FloatType$.MODULE$.equals(dataType)) {
                return Float.TYPE;
            }
            if (DoubleType$.MODULE$.equals(dataType)) {
                return Double.TYPE;
            }
            if (dataType instanceof DecimalType) {
                return Decimal.class;
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                return byte[].class;
            }
            if (dataType instanceof StringType) {
                return UTF8String.class;
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                return CalendarInterval.class;
            }
            if (dataType instanceof StructType) {
                return InternalRow.class;
            }
            if (dataType instanceof ArrayType) {
                return ArrayData.class;
            }
            if (dataType instanceof MapType) {
                return MapData.class;
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dataType;
            Class cls = objectType.cls();
            return cls;
        }
        if (VariantType$.MODULE$.equals(dataType)) {
            return VariantVal.class;
        }
        return Object.class;
    }

    public String boxedType(String jt) {
        String string = jt;
        switch (string == null ? 0 : string.hashCode()) {
            case -1325958191: {
                if (!"double".equals(string)) break;
                return "Double";
            }
            case 104431: {
                if (!"int".equals(string)) break;
                return "Integer";
            }
            case 3039496: {
                if (!"byte".equals(string)) break;
                return "Byte";
            }
            case 3327612: {
                if (!"long".equals(string)) break;
                return "Long";
            }
            case 64711720: {
                if (!"boolean".equals(string)) break;
                return "Boolean";
            }
            case 97526364: {
                if (!"float".equals(string)) break;
                return "Float";
            }
            case 109413500: {
                if (!"short".equals(string)) break;
                return "Short";
            }
        }
        return string;
    }

    public String boxedType(DataType dt) {
        return this.boxedType(this.javaType(dt));
    }

    public String typeName(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.typeName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public String defaultValue(String jt, boolean typedNull) {
        String string = jt;
        switch (string == null ? 0 : string.hashCode()) {
            case -1325958191: {
                if (!"double".equals(string)) break;
                return "-1.0";
            }
            case 104431: {
                if (!"int".equals(string)) break;
                return "-1";
            }
            case 3039496: {
                if (!"byte".equals(string)) break;
                return "(byte)-1";
            }
            case 3327612: {
                if (!"long".equals(string)) break;
                return "-1L";
            }
            case 64711720: {
                if (!"boolean".equals(string)) break;
                return "false";
            }
            case 97526364: {
                if (!"float".equals(string)) break;
                return "-1.0f";
            }
            case 109413500: {
                if (!"short".equals(string)) break;
                return "(short)-1";
            }
        }
        if (typedNull) {
            return "((" + jt + ")null)";
        }
        return "null";
    }

    public String defaultValue(DataType dt, boolean typedNull) {
        return this.defaultValue(this.javaType(dt), typedNull);
    }

    public boolean defaultValue$default$2() {
        return false;
    }

    public int calculateParamLength(Seq<Expression> params) {
        return 1 + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)params.map((Function1 & Serializable)input -> BoxesRunTime.boxToInteger((int)this.paramLengthForExpr$1(input)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public int calculateParamLengthFromExprValues(Seq<ExprValue> params) {
        return 1 + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)params.map((Function1 & Serializable)input -> BoxesRunTime.boxToInteger((int)CodeGenerator$.paramLengthForExpr$2(input)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public boolean isValidParamLength(int paramLength) {
        String string;
        block4: {
            string = SQLConf$.MODULE$.get().getConfString("spark.sql.CodeGenerator.validParamLength", null);
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (string == null || "".equals(string)) {
                        break;
                    }
                    break block4;
                }
                default: {
                    break block4;
                }
            }
            return paramLength <= 255;
        }
        return paramLength <= StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(string));
    }

    public static final /* synthetic */ boolean $anonfun$updateAndGetCompilationStats$3(Class codeAttr$1, ClassFile.AttributeInfo x$22) {
        return x$22.getClass() == codeAttr$1;
    }

    public static final /* synthetic */ int $anonfun$updateAndGetCompilationStats$4(Field codeAttrField$1, ClassFile cf$1, ClassFile.MethodInfo method$1, ClassFile.AttributeInfo a) {
        int byteCodeSize;
        block0: {
            byteCodeSize = ((byte[])codeAttrField$1.get(a)).length;
            CodegenMetrics$.MODULE$.METRIC_GENERATED_METHOD_BYTECODE_SIZE().update(byteCodeSize);
            if (byteCodeSize <= 8000) break block0;
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Generated method too long to be JIT compiled: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CLASS_NAME$.MODULE$, (Object)cf$1.getThisClassName())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.METHOD_NAME$.MODULE$, (Object)method$1.getName())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BYTECODE_SIZE$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)byteCodeSize))})))));
        }
        return byteCodeSize;
    }

    private final int paramLengthForExpr$1(Expression input) {
        int n;
        block7: {
            block6: {
                String string = this.javaType(input.dataType());
                switch (string == null ? 0 : string.hashCode()) {
                    case -1325958191: {
                        if ("double".equals(string)) {
                            break;
                        }
                        break block6;
                    }
                    case 3327612: {
                        if ("long".equals(string)) {
                            break;
                        }
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
                n = 2;
                break block7;
            }
            n = 1;
        }
        int javaParamLength = n;
        return (input.nullable() ? 1 : 0) + javaParamLength;
    }

    private static final int paramLengthForExpr$2(ExprValue input) {
        boolean bl;
        Class<?> clazz = input.javaType();
        Class<Long> clazz2 = Long.TYPE;
        Class<?> clazz3 = clazz;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            bl = true;
        } else {
            Class<Double> clazz4 = Double.TYPE;
            Class<?> clazz5 = clazz;
            bl = !(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null);
        }
        if (bl) {
            return 2;
        }
        return 1;
    }

    private CodeGenerator$() {
    }
}

