/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import java.io.Serializable;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.variant.SchemaOfVariant;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.QuotingUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantUtil;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class SchemaOfVariant$
implements Serializable {
    public static final SchemaOfVariant$ MODULE$ = new SchemaOfVariant$();

    public UTF8String schemaOfVariant(VariantVal input) {
        Variant v = new Variant(input.getValue(), input.getMetadata());
        return UTF8String.fromString((String)this.printSchema(this.schemaOf(v)));
    }

    public String printSchema(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            return "OBJECT<" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)f -> this.printField$1((StructField)f), ClassTag$.MODULE$.apply(String.class))).mkString(", ") + ">";
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return "ARRAY<" + this.printSchema(elementType) + ">";
        }
        return dataType.sql();
    }

    public DataType schemaOf(Variant v) {
        VariantUtil.Type type = v.getType();
        if (VariantUtil.Type.OBJECT.equals(type)) {
            int size = v.objectSize();
            StructField[] fields = new StructField[size];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Variant.ObjectField field = v.getFieldAtIndex(i);
                fields$2[i] = new StructField(field.key, MODULE$.schemaOf(field.value), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            });
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (StringOps$.MODULE$.$greater$eq$extension(Predef$.MODULE$.augmentString(fields[i - 1].name()), fields[i].name())) {
                    throw new SparkRuntimeException("MALFORMED_VARIANT", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
                }
            });
            return new StructType(fields);
        }
        if (VariantUtil.Type.ARRAY.equals(type)) {
            ObjectRef elementType = ObjectRef.create((Object)NullType$.MODULE$);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), v.arraySize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                elementType$2.elem = MODULE$.mergeSchema((DataType)elementType$2.elem, MODULE$.schemaOf(v.getElementAtIndex(i)));
            });
            return ArrayType$.MODULE$.apply((DataType)elementType.elem);
        }
        if (VariantUtil.Type.NULL.equals(type)) {
            return NullType$.MODULE$;
        }
        if (VariantUtil.Type.BOOLEAN.equals(type)) {
            return BooleanType$.MODULE$;
        }
        if (VariantUtil.Type.LONG.equals(type)) {
            return LongType$.MODULE$;
        }
        if (VariantUtil.Type.STRING.equals(type)) {
            return SQLConf$.MODULE$.get().defaultStringType();
        }
        if (VariantUtil.Type.DOUBLE.equals(type)) {
            return DoubleType$.MODULE$;
        }
        if (VariantUtil.Type.DECIMAL.equals(type)) {
            Decimal d = Decimal$.MODULE$.apply(v.getDecimal());
            return new DecimalType(d.precision(), d.scale());
        }
        if (VariantUtil.Type.DATE.equals(type)) {
            return DateType$.MODULE$;
        }
        if (VariantUtil.Type.TIMESTAMP.equals(type)) {
            return TimestampType$.MODULE$;
        }
        if (VariantUtil.Type.TIMESTAMP_NTZ.equals(type)) {
            return TimestampNTZType$.MODULE$;
        }
        if (VariantUtil.Type.FLOAT.equals(type)) {
            return FloatType$.MODULE$;
        }
        if (VariantUtil.Type.BINARY.equals(type)) {
            return BinaryType$.MODULE$;
        }
        if (VariantUtil.Type.YEAR_MONTH_INTERVAL.equals(type)) {
            VariantUtil.IntervalFields fields = v.getYearMonthIntervalFields();
            return new YearMonthIntervalType(fields.startField, fields.endField);
        }
        if (VariantUtil.Type.DAY_TIME_INTERVAL.equals(type)) {
            VariantUtil.IntervalFields fields = v.getDayTimeIntervalFields();
            return new DayTimeIntervalType(fields.startField, fields.endField);
        }
        throw new MatchError((Object)type);
    }

    public DataType mergeSchema(DataType t1, DataType t2) {
        return JsonInferSchema$.MODULE$.compatibleType(t1, t2, (DataType)VariantType$.MODULE$);
    }

    public SchemaOfVariant apply(Expression child) {
        return new SchemaOfVariant(child);
    }

    public Option<Expression> unapply(SchemaOfVariant x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.child());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SchemaOfVariant$.class);
    }

    private final String printField$1(StructField f) {
        return QuotingUtils$.MODULE$.quoteIfNeeded(f.name()) + ": " + this.printSchema(f.dataType());
    }

    private SchemaOfVariant$() {
    }
}

