/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathList$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import org.w3c.dom.NodeList;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a string array of values within the nodes of xml that match the XPath expression.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>','a/b/text()');\n       [\"b1\",\"b2\",\"b3\"]\n      > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>','a/b');\n       [null,null,null]\n  ", since="2.0.0", group="xml_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u000e\u001d\u0001.B\u0001\"\b\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\n\u0001BK\u0002\u0013\u0005!\t\u0003\u0005J\u0001\tE\t\u0015!\u0003D\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0011\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013qI\u0004\n\u0003Wb\u0012\u0011!E\u0001\u0003[2\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0015V!\t!a\"\t\u0013\u0005%U#!A\u0005F\u0005-\u0005\"CAG+\u0005\u0005I\u0011QAH\u0011%\t)*FA\u0001\n\u0003\u000b9\nC\u0005\u0002*V\t\t\u0011\"\u0003\u0002,\nI\u0001\fU1uQ2K7\u000f\u001e\u0006\u0003;y\t1\u0001_7m\u0015\ty\u0002%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0011#\u0003!\u0019\u0017\r^1msN$(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011\u0003\u0002\u0001-aY\u0002\"!\f\u0018\u000e\u0003qI!a\f\u000f\u0003\u0019a\u0003\u0016\r\u001e5FqR\u0014\u0018m\u0019;\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\u000fA\u0013x\u000eZ;diB\u0011qg\u0010\b\u0003qur!!\u000f\u001f\u000e\u0003iR!a\u000f\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0014B\u0001 3\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Q!\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005y\u0012T#A\"\u0011\u0005\u0011+U\"\u0001\u0010\n\u0005\u0019s\"AC#yaJ,7o]5p]\u0006!\u00010\u001c7!\u0003\u0011\u0001\u0018\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\rqJg.\u001b;?)\raUJ\u0014\t\u0003[\u0001AQ!H\u0003A\u0002\rCQ\u0001S\u0003A\u0002\r\u000b!\u0002\u001d:fiRLh*Y7f+\u0005\t\u0006C\u0001*W\u001d\t\u0019F\u000b\u0005\u0002:e%\u0011QKM\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002Ve\u0005AA-\u0019;b)f\u0004X-F\u0001\\!\tav,D\u0001^\u0015\tq&%A\u0003usB,7/\u0003\u0002a;\nAA)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002dM\u001e\u0004\"!\r3\n\u0005\u0015\u0014$aA!os\")Q\u0004\u0003a\u0001G\")\u0001\n\u0003a\u0001G\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004\u0019*d\u0007\"B6\n\u0001\u0004\u0019\u0015a\u00028fo2+g\r\u001e\u0005\u0006[&\u0001\raQ\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\ra\u0005/\u001d\u0005\b;)\u0001\n\u00111\u0001D\u0011\u001dA%\u0002%AA\u0002\r\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001uU\t\u0019UoK\u0001w!\t9H0D\u0001y\u0015\tI(0A\u0005v]\u000eDWmY6fI*\u00111PM\u0001\u000bC:tw\u000e^1uS>t\u0017BA?y\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0011\u0001\u00026bm\u0006L1aVA\u0004\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0002E\u00022\u0003/I1!!\u00073\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0019\u0017q\u0004\u0005\n\u0003Cy\u0011\u0011!a\u0001\u0003+\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0014!\u0015\tI#a\fd\u001b\t\tYCC\u0002\u0002.I\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t$a\u000b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003o\ti\u0004E\u00022\u0003sI1!a\u000f3\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\t\u0012\u0003\u0003\u0005\raY\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0004\u0005\r\u0003\"CA\u0011%\u0005\u0005\t\u0019AA\u000b\u0003\u0019)\u0017/^1mgR!\u0011qGA%\u0011!\t\tcEA\u0001\u0002\u0004\u0019\u0007f\u0005\u0001\u0002N\u0005M\u0013QKA-\u00037\ny&!\u0019\u0002f\u0005\u001d\u0004c\u0001#\u0002P%\u0019\u0011\u0011\u000b\u0010\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qK\u0001o?\u001a+fjQ0)q6dG\u0006\t=qCRD\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\u000f\u001e:j]\u001e\u0004\u0013M\u001d:bs\u0002zg\r\t<bYV,7\u000fI<ji\"Lg\u000e\t;iK\u0002rw\u000eZ3tA=4\u0007\u0005_7mAQD\u0017\r\u001e\u0011nCR\u001c\u0007\u000e\t;iK\u0002B\u0006+\u0019;iA\u0015D\bO]3tg&|gNL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QL\u0001\u0002f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005P1?y\tt$-\r\u001f0Ezb$M\u001023y=\u0012g\b\u00102?ENbtF\u0019 =Gz\u001a\u0017\u0007P\u0018d}q\u001agh\u0019\u001a=_\rtDhL1?O1:\u0013m\f20i\u0016DH\u000fK\u0015(SmR\u0001\u0005\t\u0011!A\u0001\u00023L\t22E1\u0012#M\r\u0012-E\t\u001c$%\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Oq\ng\b\u00102?EFbtF\u0019 =Ez\u0012'\u0007P\u0018c}q\u0012gHY\u001a=_\ttDh\u0019 dcqz3M\u0010\u001fd}\r\u0014DhL2?y=\ngh\n\u0017(C>\u0012w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7:,H\u000e\u001c\u0017ok2dGF\\;mYvS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003G\nQA\r\u00181]A\nQa\u001a:pkB\f#!!\u001b\u0002\u0013alGn\u00184v]\u000e\u001c\u0018!\u0003-QCRDG*[:u!\tiScE\u0003\u0016\u0003c\ni\bE\u0004\u0002t\u0005e4i\u0011'\u000e\u0005\u0005U$bAA<e\u00059!/\u001e8uS6,\u0017\u0002BA>\u0003k\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\ty(!\"\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u0017\t!![8\n\u0007\u0001\u000b\t\t\u0006\u0002\u0002n\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0004\u0005)\u0011\r\u001d9msR)A*!%\u0002\u0014\")Q\u0004\u0007a\u0001\u0007\")\u0001\n\u0007a\u0001\u0007\u00069QO\\1qa2LH\u0003BAM\u0003K\u0003R!MAN\u0003?K1!!(3\u0005\u0019y\u0005\u000f^5p]B)\u0011'!)D\u0007&\u0019\u00111\u0015\u001a\u0003\rQ+\b\u000f\\33\u0011!\t9+GA\u0001\u0002\u0004a\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u0016\t\u0005\u0003\u000b\ty+\u0003\u0003\u00022\u0006\u001d!AB(cU\u0016\u001cG\u000f")
public class XPathList
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathList x$0) {
        return XPathList$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathList> tupled() {
        return XPathList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathList>> curried() {
        return XPathList$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath";
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply((DataType)SQLConf$.MODULE$.get().defaultStringType());
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        NodeList nodeList = this.xpathUtil().evalNodeList(((UTF8String)xml).toString(), this.pathString());
        if (nodeList != null) {
            Object[] ret = new Object[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ret[i] = UTF8String.fromString((String)nodeList.item(i).getNodeValue());
            }
            return new GenericArrayData((Object)ret);
        }
        return null;
    }

    @Override
    public XPathList withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public XPathList copy(Expression xml, Expression path) {
        return new XPathList(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathList";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.xml();
            }
            case 1: {
                return this.path();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathList;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "xml";
            }
            case 1: {
                return "path";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathList)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathList xPathList = (XPathList)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathList.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathList.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathList.canEqual(this)) return false;
        return true;
    }

    public XPathList(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

