/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\t%b\u0001B\u0011#\u0001=B\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\u0006\u001b\u0002!\tA\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u00191\u0007\u0001)A\u0005'\"9q\r\u0001b\u0001\n\u0013A\u0007BB8\u0001A\u0003%\u0011\u000eC\u0004q\u0001\t\u0007I\u0011\u00025\t\rE\u0004\u0001\u0015!\u0003j\u0011\u001d\u0011\bA1A\u0005\nMDaa\u001e\u0001!\u0002\u0013!\bb\u0002=\u0001\u0005\u0004%Ia\u001d\u0005\u0007s\u0002\u0001\u000b\u0011\u0002;\t\u000fi\u0004!\u0019!C\u0005g\"11\u0010\u0001Q\u0001\nQDq\u0001 \u0001C\u0002\u0013%1\u000f\u0003\u0004~\u0001\u0001\u0006I\u0001\u001e\u0005\u0006}\u0002!Ia \u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fB\u0001\"a#\u0001\t\u0003!\u0013QR\u0004\b\u0003/\u0013\u0003\u0012AAM\r\u0019\t#\u0005#\u0001\u0002\u001c\"1QJ\u0006C\u0001\u0003OC\u0011\"!+\u0017\u0005\u0004%\t!a+\t\u0011\u0005Mf\u0003)A\u0005\u0003[Cq!!5\u0017\t\u0003\t\u0019\u000eC\u0004\u0002`Z!\t!!9\t\u000f\u0005Eh\u0003\"\u0001\u0002t\"A\u00111 \f!\u0002\u0013\tI\u000eC\u0004\u0002~Z!\t!a@\t\u0013\t5a#%A\u0005\u0002\t=\u0001\"\u0003B\u0013-\u0005\u0005I\u0011\u0002B\u0014\u0005=Q5o\u001c8J]\u001a,'oU2iK6\f'BA\u0012%\u0003\u0011Q7o\u001c8\u000b\u0005\u00152\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001dG\u0011\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]zdB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYd&\u0001\u0004=e>|GOP\u0005\u0002g%\u0011aHM\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0015I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002?eA\u00111IR\u0007\u0002\t*\u0011Q\tK\u0001\tS:$XM\u001d8bY&\u0011q\t\u0012\u0002\b\u0019><w-\u001b8h\u0003\u001dy\u0007\u000f^5p]N\u0004\"AS&\u000e\u0003\tJ!\u0001\u0014\u0012\u0003\u0017)\u001bvJT(qi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\u0003\u0006C\u0001&\u0001\u0011\u0015A%\u00011\u0001J\u00035!WmY5nC2\u0004\u0016M]:feV\t1\u000b\u0005\u00032)Zs\u0016BA+3\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002X7:\u0011\u0001,\u0017\t\u0003sIJ!A\u0017\u001a\u0002\rA\u0013X\rZ3g\u0013\taVL\u0001\u0004TiJLgn\u001a\u0006\u00035J\u0002\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\t5\fG\u000f\u001b\u0006\u0002G\u0006!!.\u0019<b\u0013\t)\u0007M\u0001\u0006CS\u001e$UmY5nC2\fa\u0002Z3dS6\fG\u000eU1sg\u0016\u0014\b%\u0001\nuS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014X#A5\u0011\u0005)lW\"A6\u000b\u00051$\u0013\u0001B;uS2L!A\\6\u0003%QKW.Z:uC6\u0004hi\u001c:nCR$XM]\u0001\u0014i&lWm\u001d;b[B4uN]7biR,'\u000fI\u0001\u0016i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3s\u0003Y!\u0018.\\3ti\u0006l\u0007O\u0014+[\r>\u0014X.\u0019;uKJ\u0004\u0013AE5h]>\u0014XmQ8seV\u0004HOR5mKN,\u0012\u0001\u001e\t\u0003cUL!A\u001e\u001a\u0003\u000f\t{w\u000e\\3b]\u0006\u0019\u0012n\u001a8pe\u0016\u001cuN\u001d:vaR4\u0015\u000e\\3tA\u0005\u0011\u0012n\u001a8pe\u0016l\u0015n]:j]\u001e4\u0015\u000e\\3t\u0003MIwM\\8sK6K7o]5oO\u001aKG.Z:!\u00031I7\u000fR3gCVdGO\u0014+[\u00035I7\u000fR3gCVdGO\u0014+[A\u0005QA.Z4bGflu\u000eZ3\u0002\u00171,w-Y2z\u001b>$W\rI\u0001\u001cQ\u0006tG\r\\3Kg>tWI\u001d:peN\u0014\u0015\u0010U1sg\u0016lu\u000eZ3\u0015\u0011\u0005\u0005\u00111CA\u000f\u0003C\u0001R!MA\u0002\u0003\u000fI1!!\u00023\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\u0019\nQ\u0001^=qKNLA!!\u0005\u0002\f\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005U\u0011\u00031\u0001\u0002\u0018\u0005I\u0001/\u0019:tK6{G-\u001a\t\u0004U\u0006e\u0011bAA\u000eW\nI\u0001+\u0019:tK6{G-\u001a\u0005\u0007\u0003?\t\u0002\u0019\u0001,\u00023\r|G.^7o\u001d\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000f\u001a\u0005\b\u0003G\t\u0002\u0019AA\u0013\u0003\u0005)\u0007cA\u001c\u0002(%\u0019\u0011\u0011F!\u0003\u0013QC'o\\<bE2,\u0017!B5oM\u0016\u0014X\u0003BA\u0018\u0003\u0007\"b!a\u0002\u00022\u0005U\u0003BB\u0012\u0013\u0001\u0004\t\u0019\u0004\u0005\u0004\u00026\u0005m\u0012qH\u0007\u0003\u0003oQ1!!\u000f)\u0003\r\u0011H\rZ\u0005\u0005\u0003{\t9DA\u0002S\t\u0012\u0003B!!\u0011\u0002D1\u0001AaBA#%\t\u0007\u0011q\t\u0002\u0002)F!\u0011\u0011JA(!\r\t\u00141J\u0005\u0004\u0003\u001b\u0012$a\u0002(pi\"Lgn\u001a\t\u0004c\u0005E\u0013bAA*e\t\u0019\u0011I\\=\t\u000f\u0005]#\u00031\u0001\u0002Z\u0005a1M]3bi\u0016\u0004\u0016M]:feBI\u0011'a\u0017\u0002`\u0005}\u0012qO\u0005\u0004\u0003;\u0012$!\u0003$v]\u000e$\u0018n\u001c83!\u0011\t\t'a\u001d\u000e\u0005\u0005\r$\u0002BA3\u0003O\nAaY8sK*!\u0011\u0011NA6\u0003\u001dQ\u0017mY6t_:TA!!\u001c\u0002p\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003c\n1aY8n\u0013\u0011\t)(a\u0019\u0003\u0017)\u001bxN\u001c$bGR|'/\u001f\t\u0005\u0003C\nI(\u0003\u0003\u0002|\u0005\r$A\u0003&t_:\u0004\u0016M]:fe\u0006Q\u0011N\u001c4fe\u001aKW\r\u001c3\u0015\t\u0005\u0005\u0015q\u0011\t\u0005\u0003\u0013\t\u0019)\u0003\u0003\u0002\u0006\u0006-!\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005%5\u00031\u0001\u0002x\u00051\u0001/\u0019:tKJ\f\u0001cY1o_:L7-\u00197ju\u0016$\u0016\u0010]3\u0015\r\u0005=\u0015\u0011SAK!\u0015\t\u00141AAA\u0011\u001d\t\u0019\n\u0006a\u0001\u0003\u0003\u000b1\u0001\u001e9f\u0011\u0015AE\u00031\u0001J\u0003=Q5o\u001c8J]\u001a,'oU2iK6\f\u0007C\u0001&\u0017'\u00111\u0002'!(\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CS1!a)c\u0003\tIw.C\u0002A\u0003C#\"!!'\u0002+M$(/^2u\r&,G\u000eZ\"p[B\f'/\u0019;peV\u0011\u0011Q\u0016\n\u0007\u0003_\u000b),!1\u0007\r\u0005E\u0016\u0004AAW\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003Y\u0019HO];di\u001aKW\r\u001c3D_6\u0004\u0018M]1u_J\u0004\u0003\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005m&-\u0001\u0003mC:<\u0017\u0002BA`\u0003s\u0013aa\u00142kK\u000e$\bCBAb\u0003\u000f\fY-\u0004\u0002\u0002F*\u0011ANY\u0005\u0005\u0003\u0013\f)M\u0001\u0006D_6\u0004\u0018M]1u_J\u0004B!!\u0003\u0002N&!\u0011qZA\u0006\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002\u0011%\u001c8k\u001c:uK\u0012$2\u0001^Ak\u0011\u001d\t9N\u0007a\u0001\u00033\f1!\u0019:s!\u0015\t\u00141\\Af\u0013\r\tiN\r\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0011o&$\bnQ8seV\u0004HOR5fY\u0012$\"\"a\u0002\u0002d\u0006\u001d\u00181^Ax\u0011\u001d\t)o\u0007a\u0001\u0003\u000f\taa\u001d;sk\u000e$\bbBAu7\u0001\u0007\u0011\u0011Q\u0001\u0006_RDWM\u001d\u0005\u0007\u0003[\\\u0002\u0019\u0001,\u00025\r|G.^7o\u001d\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000fZ:\t\u000f\u0005U1\u00041\u0001\u0002\u0018\u0005\u00112m\\7qCRL'\r\\3S_>$H+\u001f9f)\u0019\t)0a>\u0002zBI\u0011'a\u0017\u0002\u0002\u0006\u0005\u0015\u0011\u0011\u0005\u0007\u0003[d\u0002\u0019\u0001,\t\u000f\u0005UA\u00041\u0001\u0002\u0018\u0005)R-\u001c9usN#(/^2u\r&,G\u000eZ!se\u0006L\u0018AD2p[B\fG/\u001b2mKRK\b/\u001a\u000b\t\u0003\u0003\u0013\tA!\u0002\u0003\n!9!1\u0001\u0010A\u0002\u0005\u0005\u0015A\u0001;2\u0011\u001d\u00119A\ba\u0001\u0003\u0003\u000b!\u0001\u001e\u001a\t\u0013\t-a\u0004%AA\u0002\u0005\u0005\u0015a\u00043fM\u0006,H\u000e\u001e#bi\u0006$\u0016\u0010]3\u00021\r|W\u000e]1uS\ndW\rV=qK\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0012)\"\u0011\u0011\u0011B\nW\t\u0011)\u0002\u0005\u0003\u0003\u0018\t\u0005RB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0010e\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\"\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001D<sSR,'+\u001a9mC\u000e,GCAA[\u0001")
public class JsonInferSchema
implements Serializable,
Logging {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final boolean ignoreCorruptFiles;
    private final boolean ignoreMissingFiles;
    private final boolean isDefaultNTZ;
    private final boolean legacyMode;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static DataType compatibleType$default$3() {
        return JsonInferSchema$.MODULE$.compatibleType$default$3();
    }

    public static DataType compatibleType(DataType t1, DataType t2, DataType defaultDataType) {
        return JsonInferSchema$.MODULE$.compatibleType(t1, t2, defaultDataType);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecords, parseMode);
    }

    public static StructType withCorruptField(StructType struct, DataType other, String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(struct, other, columnNameOfCorruptRecords, parseMode);
    }

    public static boolean isSorted(StructField[] arr) {
        return JsonInferSchema$.MODULE$.isSorted(arr);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private boolean ignoreCorruptFiles() {
        return this.ignoreCorruptFiles;
    }

    private boolean ignoreMissingFiles() {
        return this.ignoreMissingFiles;
    }

    private boolean isDefaultNTZ() {
        return this.isDefaultNTZ;
    }

    private boolean legacyMode() {
        return this.legacyMode;
    }

    private Option<StructType> handleJsonErrorsByParseMode(ParseMode parseMode, String columnNameOfCorruptRecord, Throwable e) {
        ParseMode parseMode2 = parseMode;
        if (PermissiveMode$.MODULE$.equals(parseMode2)) {
            return new Some((Object)new StructType((StructField[])((Object[])new StructField[]{new StructField(columnNameOfCorruptRecord, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        }
        if (DropMalformedMode$.MODULE$.equals(parseMode2)) {
            return None$.MODULE$;
        }
        if (FailFastMode$.MODULE$.equals(parseMode2)) {
            throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(e);
        }
        throw new MatchError((Object)parseMode2);
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser) {
        ParseMode parseMode = this.options.parseMode();
        String columnNameOfCorruptRecord = this.options.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable)iter -> {
            JsonFactory factory = $this.options.buildJsonFactory();
            return iter.flatMap((Function1 & Serializable)row -> {
                Option<StructType> option;
                try {
                    option = (Option<StructType>)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    });
                }
                catch (Throwable throwable) {
                    boolean bl = false;
                    FileNotFoundException fileNotFoundException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException) {
                        option = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, throwable2);
                    }
                    if (throwable2 instanceof CharConversionException) {
                        CharConversionException charConversionException = (CharConversionException)throwable2;
                        if ($this.options.encoding().isEmpty()) {
                            String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n                |Specifying encoding as an input option explicitly might help to resolve the issue.\n                |")) + charConversionException.getMessage();
                            CharConversionException wrappedCharException = new CharConversionException(msg);
                            wrappedCharException.initCause(charConversionException);
                            option = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, wrappedCharException);
                        }
                    }
                    if (throwable2 instanceof FileNotFoundException) {
                        bl = true;
                        fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.ignoreMissingFiles()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped missing file", (Throwable)fileNotFoundException);
                            option = new Option<StructType>((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
                        }
                    }
                    if (bl && !this.ignoreMissingFiles()) {
                        throw fileNotFoundException;
                    }
                    if ((throwable2 instanceof IOException ? true : throwable2 instanceof RuntimeException) && this.ignoreCorruptFiles()) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped the rest of the content in the corrupted file", throwable2);
                        option = new Some((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
                    }
                    throw throwable;
                }
                return option;
            }).reduceOption(typeMerger).iterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        Function1 & Serializable foldPartition = (Function1 & Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$), typeMerger);
        Function2 & Serializable mergeResult = (Function2 & Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options)).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$10(x$1))).getOrElse((Function0 & Serializable)() -> StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public DataType inferField(JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        if (jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2)) {
            return NullType$.MODULE$;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            return this.inferField(parser);
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                return NullType$.MODULE$;
            }
        }
        if (bl) {
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            if (this.options.prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined()) {
                return (DataType)this.decimalTry$1(decimalTry$lzy, field).get();
            }
            if (this.options.inferTimestamp()) {
                if (this.isDefaultNTZ() && this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined()) {
                    return TimestampNTZType$.MODULE$;
                }
                if (this.timestampFormatter().parseOptional(field).isDefined()) {
                    return TimestampType$.MODULE$;
                }
                if (this.legacyMode()) {
                    UTF8String utf8Value = UTF8String.fromString((String)field);
                    if (SparkDateTimeUtils$.MODULE$.stringToTimestampWithoutTimeZone(utf8Value, false).isDefined()) {
                        return TimestampType$.MODULE$;
                    }
                    return StringType$.MODULE$;
                }
                return StringType$.MODULE$;
            }
            return StringType$.MODULE$;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                builder.$plus$eq((Object)new StructField(parser.currentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
            StructField[] fields = (StructField[])builder.result();
            Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
            return new StructType(fields);
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            NullType$ elementType = NullType$.MODULE$;
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                elementType = JsonInferSchema$.MODULE$.compatibleType((DataType)elementType, this.inferField(parser), JsonInferSchema$.MODULE$.compatibleType$default$3());
            }
            return ArrayType$.MODULE$.apply((DataType)elementType);
        }
        if ((JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if ((JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) {
            JsonParser.NumberType numberType = parser.getNumberType();
            if (JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType)) {
                return LongType$.MODULE$;
            }
            if (JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if ((JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) && this.options.prefersDecimal()) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if (JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) {
                return DoubleType$.MODULE$;
            }
            throw new MatchError((Object)numberType);
        }
        if (JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) {
            return BooleanType$.MODULE$;
        }
        throw QueryExecutionErrors$.MODULE$.malformedJSONError();
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable)t -> arrayType.copy(t, arrayType.copy$default$2()));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            StructField[] canonicalFields = (StructField[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.name()))))), (Function1 & Serializable)f -> this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            }), ClassTag$.MODULE$.apply(StructField.class));
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])canonicalFields))) {
                return None$.MODULE$;
            }
            return new Some((Object)new StructType(canonicalFields));
        }
        if (NullType$.MODULE$.equals(dataType)) {
            if (options.dropFieldIfAllNull()) {
                return None$.MODULE$;
            }
            return new Some((Object)StringType$.MODULE$);
        }
        return new Some((Object)dataType);
    }

    public static final /* synthetic */ boolean $anonfun$infer$10(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        if (decimalTry$lzy$1.initialized()) {
            return (Option)decimalTry$lzy$1.value();
        }
        return this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        Logging.$init$((Logging)this);
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        this.ignoreCorruptFiles = options.ignoreCorruptFiles();
        this.ignoreMissingFiles = options.ignoreMissingFiles();
        AtomicType atomicType = SQLConf$.MODULE$.get().timestampType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        this.isDefaultNTZ = !(atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null);
        Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        this.legacyMode = !(value != null ? !value.equals(value2) : value2 != null);
    }
}

