/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.TableWritePrivilege;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors;
import org.apache.spark.sql.errors.QueryExecutionErrors;
import org.apache.spark.sql.types.StructType;

@Evolving
public interface TableCatalog
extends CatalogPlugin {
    public static final String PROP_LOCATION = "location";
    public static final String PROP_IS_MANAGED_LOCATION = "is_managed_location";
    public static final String PROP_EXTERNAL = "external";
    public static final String PROP_COMMENT = "comment";
    public static final String PROP_PROVIDER = "provider";
    public static final String PROP_OWNER = "owner";
    public static final String OPTION_PREFIX = "option.";

    default public Set<TableCatalogCapability> capabilities() {
        return Collections.emptySet();
    }

    public Identifier[] listTables(String[] var1) throws NoSuchNamespaceException;

    public Table loadTable(Identifier var1) throws NoSuchTableException;

    default public Table loadTable(Identifier ident, Set<TableWritePrivilege> writePrivileges) throws NoSuchTableException {
        return this.loadTable(ident);
    }

    default public Table loadTable(Identifier ident, String version) throws NoSuchTableException {
        throw QueryCompilationErrors.noSuchTableError(ident);
    }

    default public Table loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        throw QueryCompilationErrors.noSuchTableError(ident);
    }

    default public void invalidateTable(Identifier ident) {
    }

    default public boolean tableExists(Identifier ident) {
        try {
            return this.loadTable(ident) != null;
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    @Deprecated(since="3.4.0")
    default public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        throw QueryCompilationErrors.mustOverrideOneMethodError("createTable");
    }

    default public Table createTable(Identifier ident, Column[] columns, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        return this.createTable(ident, CatalogV2Util.v2ColumnsToStructType(columns), partitions, properties);
    }

    default public boolean useNullableQuerySchema() {
        return true;
    }

    public Table alterTable(Identifier var1, TableChange ... var2) throws NoSuchTableException;

    public boolean dropTable(Identifier var1);

    default public boolean purgeTable(Identifier ident) throws UnsupportedOperationException {
        throw QueryExecutionErrors.unsupportedPurgeTableError();
    }

    public void renameTable(Identifier var1, Identifier var2) throws NoSuchTableException, TableAlreadyExistsException;
}

