/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog.procedures;

import javax.annotation.Nullable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.internal.connector.ProcedureParameterImpl;
import org.apache.spark.sql.types.DataType;

@Evolving
public interface ProcedureParameter {
    public static Builder in(String name, DataType dataType) {
        return new Builder(Mode.IN, name, dataType);
    }

    public Mode mode();

    public String name();

    public DataType dataType();

    @Nullable
    public String defaultValueExpression();

    @Nullable
    public String comment();

    public static class Builder {
        private final Mode mode;
        private final String name;
        private final DataType dataType;
        private String defaultValueExpression;
        private String comment;

        private Builder(Mode mode, String name, DataType dataType) {
            this.mode = mode;
            this.name = name;
            this.dataType = dataType;
        }

        public Builder defaultValue(String defaultValueExpression) {
            this.defaultValueExpression = defaultValueExpression;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ProcedureParameter build() {
            return new ProcedureParameterImpl(this.mode, this.name, this.dataType, this.defaultValueExpression, this.comment);
        }
    }

    public static enum Mode {
        IN,
        INOUT,
        OUT;

    }
}

