/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.encoders.ExamplePoint;
import org.apache.spark.sql.catalyst.encoders.ExamplePointUDT;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.json4s.JArray;
import org.json4s.JDecimal;
import org.json4s.JDouble;
import org.json4s.JLong;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.JsonAST$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005e3Aa\u0002\u0005\u0001#!)a\u0003\u0001C\u0001/!9!\u0004\u0001b\u0001\n\u0013Y\u0002B\u0002\u0012\u0001A\u0003%A\u0004C\u0003$\u0001\u0011%A\u0005C\u0003$\u0001\u0011%\u0011\u000bC\u0003V\u0001\u0011%aK\u0001\u0007S_^T5o\u001c8Tk&$XM\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005A\u0002CA\r\u0001\u001b\u0005A\u0011AB:dQ\u0016l\u0017-F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\ty\u0002\"A\u0003usB,7/\u0003\u0002\"=\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u0005AA/Z:u\u0015N|g\u000eF\u0003&Waj$\t\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\b\"\u0002\u0017\u0005\u0001\u0004i\u0013\u0001\u00028b[\u0016\u0004\"AL\u001b\u000f\u0005=\u001a\u0004C\u0001\u0019(\u001b\u0005\t$B\u0001\u001a\u0011\u0003\u0019a$o\\8u}%\u0011AgJ\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u00025O!)\u0011\b\u0002a\u0001u\u0005)a/\u00197vKB\u0011aeO\u0005\u0003y\u001d\u00121!\u00118z\u0011\u0015qD\u00011\u0001@\u0003\t!G\u000f\u0005\u0002\u001e\u0001&\u0011\u0011I\b\u0002\t\t\u0006$\u0018\rV=qK\")1\t\u0002a\u0001\t\u0006AQ\r\u001f9fGR,G\r\u0005\u0002F\u001d:\u0011ai\u0013\b\u0003\u000f&s!\u0001\r%\n\u0003=I!A\u0013\b\u0002\r)\u001cxN\u001c\u001bt\u0013\taU*A\u0004Kg>t\u0017i\u0015+\u000b\u0005)s\u0011BA(Q\u0005\u0019Qe+\u00197vK*\u0011A*\u0014\u000b\u0005KI\u001bF\u000bC\u0003:\u000b\u0001\u0007!\bC\u0003?\u000b\u0001\u0007q\bC\u0003D\u000b\u0001\u0007A)\u0001\u0007uKN$(j]8o\u001dVdG\u000eF\u0002&/bCQA\u0010\u0004A\u0002}BQa\u0011\u0004A\u0002\u0011\u0003")
public class RowJsonSuite
extends SparkFunSuite {
    private final StructType schema = new StructType().add("c1", "string").add("c2", (DataType)IntegerType$.MODULE$);

    private StructType schema() {
        return this.schema;
    }

    private void testJson(String name, Object value, DataType dt, JValue expected) {
        this.test(name, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GenericRowWithSchema row = new GenericRowWithSchema(new Object[]{value}, new StructType().add("a", dt));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(row.jsonValue());
            JObject $org_scalatest_assert_macro_right = JsonAST$.MODULE$.JObject().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)expected)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        }, new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
    }

    private void testJson(Object value, DataType dt, JValue expected) {
        this.testJson(dt + " " + value, value, dt, expected);
    }

    private void testJsonNull(DataType dt, JValue expected) {
        this.testJson(null, dt, (JValue)JsonAST$.MODULE$.JNull());
    }

    public RowJsonSuite() {
        this.testJsonNull((DataType)IntegerType$.MODULE$, (JValue)JsonAST$.MODULE$.JNull());
        this.testJsonNull((DataType)FloatType$.MODULE$, (JValue)JsonAST$.MODULE$.JNull());
        this.testJsonNull((DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), (JValue)JsonAST$.MODULE$.JNull());
        this.testJson(BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$, (JValue)JsonAST$.MODULE$.JBool().apply(true));
        this.testJson(BoxesRunTime.boxToBoolean((boolean)false), (DataType)BooleanType$.MODULE$, (JValue)JsonAST$.MODULE$.JBool().apply(false));
        this.testJson(BoxesRunTime.boxToByte((byte)((byte)23)), (DataType)ByteType$.MODULE$, (JValue)new JLong(23L));
        this.testJson(BoxesRunTime.boxToByte((byte)((byte)-126)), (DataType)ByteType$.MODULE$, (JValue)new JLong(-126L));
        this.testJson(BoxesRunTime.boxToShort((short)((short)20281)), (DataType)ShortType$.MODULE$, (JValue)new JLong(20281L));
        this.testJson(BoxesRunTime.boxToShort((short)((short)-8752)), (DataType)ShortType$.MODULE$, (JValue)new JLong(-8752L));
        this.testJson(BoxesRunTime.boxToInteger((int)1078231987), (DataType)IntegerType$.MODULE$, (JValue)new JLong(1078231987L));
        this.testJson(BoxesRunTime.boxToInteger((int)-10), (DataType)IntegerType$.MODULE$, (JValue)new JLong(-10L));
        this.testJson(BoxesRunTime.boxToLong((long)139289832109874199L), (DataType)LongType$.MODULE$, (JValue)new JLong(139289832109874199L));
        this.testJson(BoxesRunTime.boxToLong((long)-7873748239973488L), (DataType)LongType$.MODULE$, (JValue)new JLong(-7873748239973488L));
        this.testJson(BoxesRunTime.boxToFloat((float)1.0232E11f), (DataType)FloatType$.MODULE$, (JValue)new JDouble(1.02319996928E11));
        this.testJson(BoxesRunTime.boxToFloat((float)9.7E-13f), (DataType)FloatType$.MODULE$, (JValue)new JDouble((double)9.7E-13f));
        this.testJson(BoxesRunTime.boxToDouble((double)3.891E98), (DataType)DoubleType$.MODULE$, (JValue)new JDouble(3.891E98));
        this.testJson(BoxesRunTime.boxToDouble((double)-780000.0), (DataType)DoubleType$.MODULE$, (JValue)new JDouble(-780000.0));
        this.testJson(package$.MODULE$.BigDecimal().apply("1092.88"), (DataType)new DecimalType(10, 2), (JValue)new JDecimal(package$.MODULE$.BigDecimal().apply("1092.88")));
        this.testJson(Decimal$.MODULE$.apply("782.0003"), (DataType)new DecimalType(7, 4), (JValue)new JDecimal(package$.MODULE$.BigDecimal().apply("782.0003")));
        this.testJson(new BigDecimal("-77.89"), (DataType)new DecimalType(4, 2), (JValue)new JDecimal(package$.MODULE$.BigDecimal().apply("-77.89")));
        this.testJson("hello world", (DataType)StringType$.MODULE$, (JValue)new JString("hello world"));
        this.testJson("BinaryType", new byte[]{(byte)97, (byte)98}, (DataType)BinaryType$.MODULE$, (JValue)new JString("YWI="));
        this.testJson(Date.valueOf("2019-04-22"), (DataType)DateType$.MODULE$, (JValue)new JString("2019-04-22"));
        this.testJson(LocalDate.of(2018, 5, 14), (DataType)DateType$.MODULE$, (JValue)new JString("2018-05-14"));
        this.testJson(Timestamp.valueOf("2017-01-06 10:22:03.00"), (DataType)TimestampType$.MODULE$, (JValue)new JString("2017-01-06 10:22:03"));
        this.testJson(Timestamp.valueOf("2017-05-30 10:22:03.00").toInstant(), (DataType)TimestampType$.MODULE$, (JValue)new JString("2017-05-30 10:22:03"));
        this.testJson(LocalDateTime.of(2018, 5, 14, 12, 13), (DataType)TimestampNTZType$.MODULE$, (JValue)new JString("2018-05-14 12:13:00"));
        JLong jLong = new JLong(1L);
        JNull$ jNull$ = JsonAST$.MODULE$.JNull();
        JLong jLong2 = new JLong(77L);
        this.testJson("ArrayType(LongType,true)", new Object[]{BoxesRunTime.boxToLong((long)1L), null, BoxesRunTime.boxToLong((long)77L)}, (DataType)new ArrayType((DataType)LongType$.MODULE$, true), (JValue)new JArray(Nil$.MODULE$.$colon$colon((Object)jLong2).$colon$colon((Object)jNull$).$colon$colon((Object)jLong)));
        JLong jLong3 = new JLong(1L);
        JLong jLong4 = new JLong(-2L);
        JLong jLong5 = new JLong(3L);
        this.testJson(package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, -2, 3})), (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), (JValue)new JArray(Nil$.MODULE$.$colon$colon((Object)jLong5).$colon$colon((Object)jLong4).$colon$colon((Object)jLong3)));
        this.testJson(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), null)})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true), (JValue)JsonAST$.MODULE$.JObject().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new JString("b")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)new JString("d")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)JsonAST$.MODULE$.JNull())})));
        JObject jObject = JsonAST$.MODULE$.JObject().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new JLong(1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)new JString("b"))}));
        JObject jObject2 = JsonAST$.MODULE$.JObject().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new JLong(2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)new JString("d"))}));
        JObject jObject3 = JsonAST$.MODULE$.JObject().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)new JLong(3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)JsonAST$.MODULE$.JNull())}));
        this.testJson(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"d"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), null)})), (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), (JValue)new JArray(Nil$.MODULE$.$colon$colon((Object)jObject3).$colon$colon((Object)jObject2).$colon$colon((Object)jObject)));
        this.testJson(new GenericRowWithSchema(new Object[]{"1", BoxesRunTime.boxToInteger((int)2)}, this.schema()), (DataType)this.schema(), (JValue)JsonAST$.MODULE$.JObject().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c1"), (Object)new JString("1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c2"), (Object)new JLong(2L))})));
        JDouble jDouble = new JDouble(3.4);
        JDouble jDouble2 = new JDouble(8.98);
        this.testJson("UDT", new ExamplePoint(3.4, 8.98), (DataType)new ExamplePointUDT(), (JValue)new JArray(Nil$.MODULE$.$colon$colon((Object)jDouble2).$colon$colon((Object)jDouble)));
        this.test("no schema", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"a"})).jsonValue(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "requires a non-null schema";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("unsupported type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> {
                GenericRowWithSchema row = new GenericRowWithSchema(new Object[]{new Tuple2.mcII.sp(1, 2)}, new StructType().add("a", (DataType)new ObjectType(Tuple2.class)));
                return row.jsonValue();
            }, ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134))));
            String x$2 = "FAILED_ROW_TO_JSON";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)DataTypeErrors$.MODULE$.toSQLValue("(1,2)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)"class scala.Tuple2$mcII$sp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlType"), (Object)DataTypeErrors$.MODULE$.toSQLType("ObjectType(class scala.Tuple2)"))}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "FAILED_ROW_TO_JSON", x$4, x$3, x$5, x$6);
        }, new Position("RowJsonSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }
}

