/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005Y2A\u0001B\u0003\u0001!!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u001b\u0001A\u0003%\u0011EA\u000eDCR\fG._:u)f\u0004XmQ8om\u0016\u0014H/\u001a:t'VLG/\u001a\u0006\u0003\r\u001d\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0011%\t1a]9m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0004\u0001E)\u0002C\u0001\n\u0014\u001b\u0005I\u0011B\u0001\u000b\n\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011a#G\u0007\u0002/)\u0011\u0001$B\u0001\u0006a2\fgn]\u0005\u00035]\u0011\u0011bU)M\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005)\u0011aC:j[BdW\rV=qKN,\u0012!\t\t\u0004E1zcBA\u0012*\u001d\t!s%D\u0001&\u0015\t1s\"\u0001\u0004=e>|GOP\u0005\u0002Q\u0005)1oY1mC&\u0011!fK\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0013BA\u0017/\u0005\r\u0019V-\u001d\u0006\u0003U-\u0002\"\u0001M\u001a\u000e\u0003ER!AM\u0004\u0002\u000bQL\b/Z:\n\u0005Q\n$\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0019MLW\u000e\u001d7f)f\u0004Xm\u001d\u0011")
public class CatalystTypeConvertersSuite
extends SparkFunSuite
implements SQLHelper {
    private final Seq<DataType> simpleTypes;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        CatalystTypeConvertersSuite catalystTypeConvertersSuite = this;
        synchronized (catalystTypeConvertersSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private Seq<DataType> simpleTypes() {
        return this.simpleTypes;
    }

    public static final /* synthetic */ Assertion $anonfun$new$27(CatalystTypeConvertersSuite $this, long us) {
        Instant instant = DateTimeUtils$.MODULE$.microsToInstant(us);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)TimestampType$.MODULE$).apply((Object)BoxesRunTime.boxToLong((long)us)));
        Instant $org_scalatest_assert_macro_right = instant;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
    }

    public static final /* synthetic */ Assertion $anonfun$new$31(CatalystTypeConvertersSuite $this, long us) {
        LocalDateTime localDateTime = DateTimeUtils$.MODULE$.microsToLocalDateTime(us);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)TimestampNTZType$.MODULE$).apply((Object)BoxesRunTime.boxToLong((long)us)));
        LocalDateTime $org_scalatest_assert_macro_right = localDateTime;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
    }

    public static final /* synthetic */ Assertion $anonfun$new$36(CatalystTypeConvertersSuite $this, int days) {
        LocalDate localDate = DateTimeUtils$.MODULE$.daysToLocalDate(days);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)DateType$.MODULE$).apply((Object)BoxesRunTime.boxToInteger((int)days)));
        LocalDate $org_scalatest_assert_macro_right = localDate;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
    }

    public static final /* synthetic */ Assertion $anonfun$new$44(CatalystTypeConvertersSuite $this, long input$1, long sign) {
        long us = sign * input$1;
        Duration duration = IntervalUtils$.MODULE$.microsToDuration(us);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)DayTimeIntervalType$.MODULE$.apply()).apply((Object)BoxesRunTime.boxToLong((long)us)));
        Duration $org_scalatest_assert_macro_right = duration;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
    }

    public static final /* synthetic */ Assertion $anonfun$new$52(CatalystTypeConvertersSuite $this, int input$2, int sign) {
        int months = sign * input$2;
        Period period = IntervalUtils$.MODULE$.monthsToPeriod(months);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)YearMonthIntervalType$.MODULE$.apply()).apply((Object)BoxesRunTime.boxToInteger((int)months)));
        Period $org_scalatest_assert_macro_right = period;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
    }

    public static final /* synthetic */ Assertion $anonfun$new$56(CatalystTypeConvertersSuite $this, int days) {
        Function1 converter = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)DateType$.MODULE$);
        LocalDate ld = LocalDate.ofEpochDay(days);
        Object result1 = converter.apply((Object)ld);
        Date d = Date.valueOf(ld);
        Object result2 = converter.apply((Object)d);
        int expected = DateTimeUtils$.MODULE$.localDateToDays(ld);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(result1);
        int $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(result2);
        int $org_scalatest_assert_macro_right2 = expected;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
    }

    public static final /* synthetic */ Assertion $anonfun$new$60(CatalystTypeConvertersSuite $this, int seconds) {
        Function1 converter = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)TimestampType$.MODULE$);
        Instant i = Instant.ofEpochSecond(seconds);
        Object result1 = converter.apply((Object)i);
        Timestamp t = new Timestamp((long)seconds * 1000L);
        Object result2 = converter.apply((Object)t);
        long expected = (long)seconds * 1000000L;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(result1);
        long $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(result2);
        long $org_scalatest_assert_macro_right2 = expected;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
    }

    public CatalystTypeConvertersSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.simpleTypes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, DateType$.MODULE$, BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, DecimalType$.MODULE$.SYSTEM_DEFAULT(), DecimalType$.MODULE$.USER_DEFAULT()}));
        this.test("null handling in rows", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType schema = StructType$.MODULE$.apply((Seq)this.simpleTypes().map((Function1 & Serializable)t -> new StructField(t.getClass().getName(), t, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())));
            Function1 convertToCatalyst = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)schema);
            Function1 convertToScala = CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)schema);
            Row scalaRow = Row$.MODULE$.fromSeq((Seq)package$.MODULE$.Seq().fill(this.simpleTypes().length(), (Function0 & Serializable)() -> null));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(convertToScala.apply(convertToCatalyst.apply((Object)scalaRow)));
            Row $org_scalatest_assert_macro_right = scalaRow;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("null handling for individual values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.simpleTypes().foreach((Function1 & Serializable)dataType -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter(dataType).apply(null));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("option handling in convertToCatalyst", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)new Some((Object)BoxesRunTime.boxToInteger((int)123))));
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)123));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("option handling in createToCatalystConverter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)IntegerType$.MODULE$).apply((Object)new Some((Object)BoxesRunTime.boxToInteger((int)123))));
            int $org_scalatest_assert_macro_right = 123;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("primitive array handling", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int[] intArray = new int[]{1, 100, 10000};
            UnsafeArrayData intUnsafeArray = UnsafeArrayData.fromPrimitiveArray((int[])intArray);
            ArrayType intArrayType = new ArrayType((DataType)IntegerType$.MODULE$, false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)intArrayType).apply((Object)intUnsafeArray));
            int[] $org_scalatest_assert_macro_right = intArray;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            double[] doubleArray = new double[]{1.1, 111.1, 11111.1};
            UnsafeArrayData doubleUnsafeArray = UnsafeArrayData.fromPrimitiveArray((double[])doubleArray);
            ArrayType doubleArrayType = new ArrayType((DataType)DoubleType$.MODULE$, false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)doubleArrayType).apply((Object)doubleUnsafeArray));
            double[] $org_scalatest_assert_macro_right2 = doubleArray;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("An array with null handling", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object[] intArray = new Object[]{BoxesRunTime.boxToInteger((int)1), null, BoxesRunTime.boxToInteger((int)100), null, BoxesRunTime.boxToInteger((int)10000)};
            GenericArrayData intGenericArray = new GenericArrayData(intArray);
            ArrayType intArrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)intArrayType).apply((Object)intGenericArray));
            Object[] $org_scalatest_assert_macro_right = intArray;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            Object $org_scalatest_assert_macro_left2 = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)intArrayType).apply((Object)intArray);
            GenericArrayData $org_scalatest_assert_macro_right2 = intGenericArray;
            Object object = $org_scalatest_assert_macro_left2;
            GenericArrayData genericArrayData = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(object != null ? !object.equals(genericArrayData) : genericArrayData != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            Object[] doubleArray = new Object[]{BoxesRunTime.boxToDouble((double)1.1), null, BoxesRunTime.boxToDouble((double)111.1), null, BoxesRunTime.boxToDouble((double)11111.1)};
            GenericArrayData doubleGenericArray = new GenericArrayData(doubleArray);
            ArrayType doubleArrayType = new ArrayType((DataType)DoubleType$.MODULE$, true);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)doubleArrayType).apply((Object)doubleGenericArray));
            Object[] $org_scalatest_assert_macro_right3 = doubleArray;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            Object $org_scalatest_assert_macro_left4 = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)doubleArrayType).apply((Object)doubleArray);
            GenericArrayData $org_scalatest_assert_macro_right4 = doubleGenericArray;
            Object object2 = $org_scalatest_assert_macro_left4;
            GenericArrayData genericArrayData2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(object2 != null ? !object2.equals(genericArrayData2) : genericArrayData2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("converting a wrong value to the struct type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType structType = new StructType().add("f1", (DataType)IntegerType$.MODULE$);
            SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)structType).apply((Object)"test"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109))));
            String x$2 = "_LEGACY_ERROR_TEMP_3219";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"otherClass"), (Object)"java.lang.String"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"struct<f1:int>")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "_LEGACY_ERROR_TEMP_3219", x$4, x$3, x$5, x$6);
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("converting a wrong value to the map type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MapType mapType = new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
            SparkIllegalArgumentException x$7 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)mapType).apply((Object)"test"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122))));
            String x$8 = "_LEGACY_ERROR_TEMP_3221";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"otherClass"), (Object)"java.lang.String"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keyType"), (Object)"string"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)"int")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "_LEGACY_ERROR_TEMP_3221", x$10, x$9, x$11, x$12);
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("converting a wrong value to the array type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ArrayType arrayType = new ArrayType((DataType)IntegerType$.MODULE$, true);
            SparkIllegalArgumentException x$13 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)arrayType).apply((Object)"test"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136))));
            String x$14 = "_LEGACY_ERROR_TEMP_3220";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"otherClass"), (Object)"java.lang.String"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"elementType"), (Object)"int")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "_LEGACY_ERROR_TEMP_3220", x$16, x$15, x$17, x$18);
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("converting a wrong value to the decimal type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DecimalType decimalType = new DecimalType(10, 0);
            SparkIllegalArgumentException x$19 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)decimalType).apply((Object)"test"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149))));
            String x$20 = "_LEGACY_ERROR_TEMP_3219";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"test"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"otherClass"), (Object)"java.lang.String"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"decimal(10,0)")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "_LEGACY_ERROR_TEMP_3219", x$22, x$21, x$23, x$24);
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("SPARK-51941: convert BigDecimal to Decimal", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Decimal expected = Decimal$.MODULE$.apply("0.01");
            scala.math.BigDecimal bigDecimal = package$.MODULE$.BigDecimal().apply("0.01");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)bigDecimal));
            Decimal $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            BigDecimal javaBigDecimal = new BigDecimal("0.01");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)javaBigDecimal));
            Decimal $org_scalatest_assert_macro_right2 = expected;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("converting a wrong value to the string type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkIllegalArgumentException x$25 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)StringType$.MODULE$).apply((Object)BoxesRunTime.boxToDouble((double)0.1)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169))));
            String x$26 = "_LEGACY_ERROR_TEMP_3219";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"0.1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"otherClass"), (Object)"java.lang.Double"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)"STRING")}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, "_LEGACY_ERROR_TEMP_3219", x$28, x$27, x$29, x$30);
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("SPARK-24571: convert Char to String", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            char chr = 'X';
            Function1 converter = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)StringType$.MODULE$);
            UTF8String expected = UTF8String.fromString((String)"X");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(converter.apply((Object)BoxesRunTime.boxToCharacter((char)chr)));
            UTF8String $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)BoxesRunTime.boxToCharacter((char)'a')));
            UTF8String $org_scalatest_assert_macro_right2 = UTF8String.fromString((String)"a");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("SPARK-33390: Make Literal support char array", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            char[] ac = new char[]{'a', 'c'};
            Function1 converter = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)StringType$.MODULE$);
            UTF8String expected = UTF8String.fromString((String)String.valueOf(ac));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(converter.apply((Object)ac));
            UTF8String $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("converting java.time.Instant to TimestampType", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"0101-02-16T10:11:32Z", (List)new .colon.colon((Object)"1582-10-02T01:02:03.04Z", (List)new .colon.colon((Object)"1582-12-31T23:59:59.999999Z", (List)new .colon.colon((Object)"1970-01-01T00:00:01.123Z", (List)new .colon.colon((Object)"1972-12-31T23:59:59.123456Z", (List)new .colon.colon((Object)"2019-02-16T18:12:30Z", (List)new .colon.colon((Object)"2119-03-16T19:13:31Z", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)timestamp -> {
            Instant input = Instant.parse(timestamp);
            Object result = CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)input);
            long expected = DateTimeUtils$.MODULE$.instantToMicros(input);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            long $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("converting TimestampType to java.time.Instant", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-9463427405253013L, -244000001L, 0L, 99628200102030L, 1543749753123456L})).foreach((Function1 & Serializable)us -> CatalystTypeConvertersSuite.$anonfun$new$27(this, BoxesRunTime.unboxToLong((Object)us)))), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("SPARK-35664: converting java.time.LocalDateTime to TimestampNTZType", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"0101-02-16T10:11:32", (List)new .colon.colon((Object)"1582-10-02T01:02:03.04", (List)new .colon.colon((Object)"1582-12-31T23:59:59.999999", (List)new .colon.colon((Object)"1970-01-01T00:00:01.123", (List)new .colon.colon((Object)"1972-12-31T23:59:59.123456", (List)new .colon.colon((Object)"2019-02-16T18:12:30", (List)new .colon.colon((Object)"2119-03-16T19:13:31", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)text -> {
            LocalDateTime input = LocalDateTime.parse(text);
            Object result = CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)input);
            long expected = DateTimeUtils$.MODULE$.localDateTimeToMicros(input);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            long $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("SPARK-35664: converting TimestampNTZType to java.time.LocalDateTime", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-9463427405253013L, -244000001L, 0L, 99628200102030L, 1543749753123456L})).foreach((Function1 & Serializable)us -> CatalystTypeConvertersSuite.$anonfun$new$31(this, BoxesRunTime.unboxToLong((Object)us))), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("converting java.time.LocalDate to DateType", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"0101-02-16", (List)new .colon.colon((Object)"1582-10-02", (List)new .colon.colon((Object)"1582-12-31", (List)new .colon.colon((Object)"1970-01-01", (List)new .colon.colon((Object)"1972-12-31", (List)new .colon.colon((Object)"2019-02-16", (List)new .colon.colon((Object)"2119-03-16", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)date -> {
            LocalDate input = LocalDate.parse(date);
            Object result = CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)input);
            int expected = DateTimeUtils$.MODULE$.localDateToDays(input);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            int $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        this.test("converting DateType to java.time.LocalDate", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-701265, -371419, -199722, -1, 0, 967, 2094, 17877, 24837, 1110657})).foreach((Function1 & Serializable)days -> CatalystTypeConvertersSuite.$anonfun$new$36(this, BoxesRunTime.unboxToInt((Object)days)))), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        this.test("SPARK-34605: converting java.time.Duration to DayTimeIntervalType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String errMsg;
            new .colon.colon((Object)Duration.ZERO, (List)new .colon.colon((Object)Duration.ofNanos(1L), (List)new .colon.colon((Object)Duration.ofNanos(-1L), (List)new .colon.colon((Object)Duration.ofSeconds(0L, Long.MAX_VALUE), (List)new .colon.colon((Object)Duration.ofSeconds(0L, Long.MIN_VALUE), (List)new .colon.colon((Object)Duration.ofDays(106751991L), (List)new .colon.colon((Object)Duration.ofDays(-106751991L), (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)input -> {
                Object result = CatalystTypeConverters$.MODULE$.convertToCatalyst(input);
                long expected = IntervalUtils$.MODULE$.durationToMicros(input);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
                long $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            });
            String $org_scalatest_assert_macro_left = errMsg = ((Throwable)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> IntervalUtils$.MODULE$.durationToMicros(Duration.ofSeconds(Long.MAX_VALUE, Long.MAX_VALUE)), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302))).getMessage();
            String $org_scalatest_assert_macro_right = "long overflow";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        this.test("SPARK-35726: Truncate java.time.Duration by fields of day-time interval type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Duration duration = Duration.ofSeconds(90061L, 1000000023L);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToLong((long)86400000000L), (Object)BoxesRunTime.boxToLong((long)-86400000000L)), new Tuple3((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToLong((long)90000000000L), (Object)BoxesRunTime.boxToLong((long)-90000000000L)), new Tuple3((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToLong((long)90060000000L), (Object)BoxesRunTime.boxToLong((long)-90060000000L)), new Tuple3((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()), (Object)BoxesRunTime.boxToLong((long)90062000000L), (Object)BoxesRunTime.boxToLong((long)-90062000001L)), new Tuple3((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToLong((long)90000000000L), (Object)BoxesRunTime.boxToLong((long)-90000000000L)), new Tuple3((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToLong((long)90060000000L), (Object)BoxesRunTime.boxToLong((long)-90060000000L)), new Tuple3((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()), (Object)BoxesRunTime.boxToLong((long)90062000000L), (Object)BoxesRunTime.boxToLong((long)-90062000001L)), new Tuple3((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToLong((long)90060000000L), (Object)BoxesRunTime.boxToLong((long)-90060000000L)), new Tuple3((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND()), (Object)BoxesRunTime.boxToLong((long)90062000000L), (Object)BoxesRunTime.boxToLong((long)-90062000001L)), new Tuple3((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()), (Object)BoxesRunTime.boxToLong((long)90062000000L), (Object)BoxesRunTime.boxToLong((long)-90062000001L))})).foreach((Function1 & Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 != null) {
                    DayTimeIntervalType dt = (DayTimeIntervalType)tuple3._1();
                    long positive = BoxesRunTime.unboxToLong((Object)tuple3._2());
                    long negative = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    Object $org_scalatest_assert_macro_left = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)dt).apply((Object)duration);
                    long $org_scalatest_assert_macro_right = positive;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
                    Object $org_scalatest_assert_macro_left2 = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)dt).apply((Object)duration.negated());
                    long $org_scalatest_assert_macro_right2 = negative;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
                }
                throw new MatchError((Object)tuple3);
            });
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
        this.test("SPARK-34605: converting DayTimeIntervalType to java.time.Duration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 999999L, -1000000L, Long.MAX_VALUE})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)input -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, -1L})).foreach((Function1 & Serializable)sign -> CatalystTypeConvertersSuite.$anonfun$new$44(this, input, BoxesRunTime.unboxToLong((Object)sign)))), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        this.test("SPARK-34615: converting java.time.Period to YearMonthIntervalType", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String errMsg;
            new .colon.colon((Object)Period.ZERO, (List)new .colon.colon((Object)Period.ofMonths(1), (List)new .colon.colon((Object)Period.ofMonths(-1), (List)new .colon.colon((Object)Period.ofMonths(Integer.MAX_VALUE).normalized(), (List)new .colon.colon((Object)Period.ofMonths(Integer.MIN_VALUE).normalized(), (List)new .colon.colon((Object)Period.ofYears(106751991), (List)new .colon.colon((Object)Period.ofYears(-106751991), (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)input -> {
                Object result = CatalystTypeConverters$.MODULE$.convertToCatalyst(input);
                int expected = IntervalUtils$.MODULE$.periodToMonths(input);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
                int $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            });
            String $org_scalatest_assert_macro_left = errMsg = ((Throwable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> IntervalUtils$.MODULE$.periodToMonths(Period.of(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357))).getMessage();
            String $org_scalatest_assert_macro_right = "integer overflow";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        }, new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        this.test("SPARK-35769: Truncate java.time.Period by fields of year-month interval type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR())), (Object)BoxesRunTime.boxToInteger((int)12)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH())), (Object)BoxesRunTime.boxToInteger((int)13)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH())), (Object)BoxesRunTime.boxToInteger((int)13)), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                YearMonthIntervalType ym = (YearMonthIntervalType)tuple2._1();
                int value = tuple2._2$mcI$sp();
                Object $org_scalatest_assert_macro_left = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)ym).apply((Object)Period.of(1, 1, 0));
                int $org_scalatest_assert_macro_right = value;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            }
            throw new MatchError((Object)tuple2);
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.test("SPARK-34615: converting YearMonthIntervalType to java.time.Period", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 999999, 1000000, Integer.MAX_VALUE})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)input -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, -1})).foreach((Function1 & Serializable)sign -> CatalystTypeConvertersSuite.$anonfun$new$52(this, input, BoxesRunTime.unboxToInt((Object)sign)))), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        this.test("SPARK-35204: createToCatalystConverter for date", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)enable -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)enable)))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1234, 0, 1234})).foreach((Function1 & Serializable)days -> CatalystTypeConvertersSuite.$anonfun$new$56($this, BoxesRunTime.unboxToInt((Object)days))));
            return BoxedUnit.UNIT;
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("SPARK-35204: createToCatalystConverter for timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)enable -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)enable)))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-1234, 0, 1234})).foreach((Function1 & Serializable)seconds -> CatalystTypeConvertersSuite.$anonfun$new$60($this, BoxesRunTime.unboxToInt((Object)seconds))));
            return BoxedUnit.UNIT;
        }), new Position("CatalystTypeConvertersSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
    }
}

