/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class EscapePathBenchmark$
extends BenchmarkBase {
    public static final EscapePathBenchmark$ MODULE$ = new EscapePathBenchmark$();

    public void runBenchmarkSuite(String[] mainArgs) {
        int N = 1000000;
        this.runBenchmark("Escape", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "Escape Tests";
            long x$2 = N;
            int x$3 = 10;
            Option x$4 = MODULE$.output();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark("Escape Tests", x$2, 10, x$5, x$6, x$7, x$4);
            .colon.colon paths = new .colon.colon((Object)"https://issues.apache.org/jira/browse/SPARK-48551", (List)new .colon.colon((Object)"https...issues.apache.org/jira/browse/SPARK-48551", (List)new .colon.colon((Object)"https...issues.apache.org.jira/browse/SPARK-48551", (List)new .colon.colon((Object)"https...issues.apache.org.jira.browse/SPARK-48551", (List)new .colon.colon((Object)"https...issues.apache.org.jira.browse.SPARK-48551", (List)Nil$.MODULE$)))));
            benchmark.addCase("Legacy", benchmark.addCase$default$2(), (Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> EscapePathBenchmark$.$anonfun$runBenchmarkSuite$2(N, (Seq)paths, arg_0)));
            benchmark.addCase("New", benchmark.addCase$default$2(), (Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> EscapePathBenchmark$.$anonfun$runBenchmarkSuite$5(N, (Seq)paths, arg_0)));
            benchmark.run(benchmark.run$default$1());
        });
        this.runBenchmark("Unescape", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$8 = "Unescape Tests";
            long x$9 = N;
            int x$10 = 10;
            Option x$11 = MODULE$.output();
            FiniteDuration x$12 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$13 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$14 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark("Unescape Tests", x$9, 10, x$12, x$13, x$14, x$11);
            Seq paths = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"https%3A%2F%2Fissues.apache.org%2Fjira%2Fbrowse%2FSPARK-48551", "https:%2F%2Fissues.apache.org%2Fjira%2Fbrowse%2FSPARK-48551", "https:/%2Fissues.apache.org%2Fjira%2Fbrowse%2FSPARK-48551", "https://issues.apache.org%2Fjira%2Fbrowse%2FSPARK-48551", "https://issues.apache.org/jira%2Fbrowse%2FSPARK-48551", "https://issues.apache.org/jira%2Fbrowse%2FSPARK-48551", "https://issues.apache.org/jira/browse%2FSPARK-48551", "https://issues.apache.org/jira/browse%2SPARK-48551", "https://issues.apache.org/jira/browse/SPARK-48551"}));
            benchmark.addCase("Legacy", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), N).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> paths.foreach((Function1 & Serializable)path -> MODULE$.unescapePathNameLegacy((String)path))));
            benchmark.addCase("New", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), N).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> paths.foreach((Function1 & Serializable)path -> ExternalCatalogUtils$.MODULE$.unescapePathName(path))));
            benchmark.run(benchmark.run$default$1());
        });
    }

    public String escapePathNameLegacy(String path) {
        StringBuilder builder = new StringBuilder();
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(path), (Function1 & Serializable)c -> EscapePathBenchmark$.$anonfun$escapePathNameLegacy$1(builder, BoxesRunTime.unboxToChar((Object)c)));
        return builder.toString();
    }

    public String unescapePathNameLegacy(String path) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code;
                int n;
                try {
                    n = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception exception) {
                    n = code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 3;
                    continue;
                }
                sb.append(c);
                ++i;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$2(int N$1, Seq paths$1, int x$1) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), N$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> paths$1.foreach((Function1 & Serializable)path -> MODULE$.escapePathNameLegacy((String)path)));
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$5(int N$1, Seq paths$1, int x$3) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), N$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> paths$1.foreach((Function1 & Serializable)path -> ExternalCatalogUtils$.MODULE$.escapePathName(path)));
    }

    public static final /* synthetic */ StringBuilder $anonfun$escapePathNameLegacy$1(StringBuilder builder$1, char c) {
        if (ExternalCatalogUtils$.MODULE$.needsEscaping(c)) {
            builder$1.append('%');
            return builder$1.append(StringOps$.MODULE$.format$extension("%02X", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
        }
        return builder$1.append(c);
    }

    private EscapePathBenchmark$() {
    }
}

