/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZoneId;
import java.util.Locale;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.csv.CSVInferSchema;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005}1AAA\u0002\u0001!!)1\u0004\u0001C\u00019\t\u00192i\u0015,J]\u001a,'oU2iK6\f7+^5uK*\u0011A!B\u0001\u0004GN4(B\u0001\u0004\b\u0003!\u0019\u0017\r^1msN$(B\u0001\u0005\n\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0015-\tQa\u001d9be.T!\u0001D\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0011aA8sO\u000e\u00011c\u0001\u0001\u0012+A\u0011!cE\u0007\u0002\u0013%\u0011A#\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005YIR\"A\f\u000b\u0005a)\u0011!\u00029mC:\u001c\u0018B\u0001\u000e\u0018\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0007\u0001")
public class CSVInferSchemaSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        CSVInferSchemaSuite cSVInferSchemaSuite = this;
        synchronized (cSVInferSchemaSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private static final void checkDecimalInfer$1(String langTag, DataType expectedType) {
        CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"locale"), (Object)langTag), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inferSchema"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sep"), (Object)"|")})), false, "UTC");
        CSVInferSchema inferSchema = new CSVInferSchema(options);
        DecimalFormat df = new DecimalFormat("", new DecimalFormatSymbols(Locale.forLanguageTag(langTag)));
        String input = df.format(Decimal$.MODULE$.apply(1000001).toBigDecimal());
        DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)NullType$.MODULE$, input);
        DataType $org_scalatest_assert_macro_right = expectedType;
        DataType dataType = $org_scalatest_assert_macro_left;
        DataType dataType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
    }

    public CSVInferSchemaSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.test("String fields types are inferred correctly from null types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd HH:mm:ss")})), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)NullType$.MODULE$, "");
            NullType$ $org_scalatest_assert_macro_right = NullType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            NullType$ nullType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            DataType $org_scalatest_assert_macro_left2 = inferSchema.inferField((DataType)NullType$.MODULE$, null);
            NullType$ $org_scalatest_assert_macro_right2 = NullType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            NullType$ nullType$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(nullType$2) : nullType$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
            DataType $org_scalatest_assert_macro_left3 = inferSchema.inferField((DataType)NullType$.MODULE$, "100000000000");
            LongType$ $org_scalatest_assert_macro_right3 = LongType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left3;
            LongType$ longType$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(longType$) : longType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
            DataType $org_scalatest_assert_macro_left4 = inferSchema.inferField((DataType)NullType$.MODULE$, "60");
            IntegerType$ $org_scalatest_assert_macro_right4 = IntegerType$.MODULE$;
            DataType dataType4 = $org_scalatest_assert_macro_left4;
            IntegerType$ integerType$ = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType4 != null ? !dataType4.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            DataType $org_scalatest_assert_macro_left5 = inferSchema.inferField((DataType)NullType$.MODULE$, "3.5");
            DoubleType$ $org_scalatest_assert_macro_right5 = DoubleType$.MODULE$;
            DataType dataType5 = $org_scalatest_assert_macro_left5;
            DoubleType$ doubleType$ = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(dataType5 != null ? !dataType5.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            DataType $org_scalatest_assert_macro_left6 = inferSchema.inferField((DataType)NullType$.MODULE$, "test");
            StringType$ $org_scalatest_assert_macro_right6 = StringType$.MODULE$;
            DataType dataType6 = $org_scalatest_assert_macro_left6;
            StringType$ stringType$ = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(dataType6 != null ? !dataType6.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            DataType $org_scalatest_assert_macro_left7 = inferSchema.inferField((DataType)NullType$.MODULE$, "2015-08-20 15:57:00");
            TimestampType$ $org_scalatest_assert_macro_right7 = TimestampType$.MODULE$;
            DataType dataType7 = $org_scalatest_assert_macro_left7;
            TimestampType$ timestampType$ = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(dataType7 != null ? !dataType7.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            DataType $org_scalatest_assert_macro_left8 = inferSchema.inferField((DataType)NullType$.MODULE$, "True");
            BooleanType$ $org_scalatest_assert_macro_right8 = BooleanType$.MODULE$;
            DataType dataType8 = $org_scalatest_assert_macro_left8;
            BooleanType$ booleanType$ = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(dataType8 != null ? !dataType8.equals(booleanType$) : booleanType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            DataType $org_scalatest_assert_macro_left9 = inferSchema.inferField((DataType)NullType$.MODULE$, "FAlSE");
            BooleanType$ $org_scalatest_assert_macro_right9 = BooleanType$.MODULE$;
            DataType dataType9 = $org_scalatest_assert_macro_left9;
            BooleanType$ booleanType$2 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(dataType9 != null ? !dataType9.equals(booleanType$2) : booleanType$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            String textValueOne = Long.toString(Long.MAX_VALUE) + "0";
            BigDecimal decimalValueOne = new BigDecimal(textValueOne);
            DecimalType expectedTypeOne = new DecimalType(decimalValueOne.precision(), decimalValueOne.scale());
            DataType $org_scalatest_assert_macro_left10 = inferSchema.inferField((DataType)NullType$.MODULE$, textValueOne);
            DecimalType $org_scalatest_assert_macro_right10 = expectedTypeOne;
            DataType dataType10 = $org_scalatest_assert_macro_left10;
            DecimalType decimalType = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(dataType10 != null ? !dataType10.equals(decimalType) : decimalType != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("String fields types are inferred correctly from other types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd HH:mm:ss")})), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)LongType$.MODULE$, "1.0");
            DoubleType$ $org_scalatest_assert_macro_right = DoubleType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            DoubleType$ doubleType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            DataType $org_scalatest_assert_macro_left2 = inferSchema.inferField((DataType)LongType$.MODULE$, "test");
            StringType$ $org_scalatest_assert_macro_right2 = StringType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            StringType$ stringType$ = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            DataType $org_scalatest_assert_macro_left3 = inferSchema.inferField((DataType)IntegerType$.MODULE$, "1.0");
            DoubleType$ $org_scalatest_assert_macro_right3 = DoubleType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left3;
            DoubleType$ doubleType$2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(doubleType$2) : doubleType$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            DataType $org_scalatest_assert_macro_left4 = inferSchema.inferField((DataType)DoubleType$.MODULE$, null);
            DoubleType$ $org_scalatest_assert_macro_right4 = DoubleType$.MODULE$;
            DataType dataType4 = $org_scalatest_assert_macro_left4;
            DoubleType$ doubleType$3 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType4 != null ? !dataType4.equals(doubleType$3) : doubleType$3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            DataType $org_scalatest_assert_macro_left5 = inferSchema.inferField((DataType)DoubleType$.MODULE$, "test");
            StringType$ $org_scalatest_assert_macro_right5 = StringType$.MODULE$;
            DataType dataType5 = $org_scalatest_assert_macro_left5;
            StringType$ stringType$2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(dataType5 != null ? !dataType5.equals(stringType$2) : stringType$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            DataType $org_scalatest_assert_macro_left6 = inferSchema.inferField((DataType)LongType$.MODULE$, "2015-08-20 14:57:00");
            StringType$ $org_scalatest_assert_macro_right6 = StringType$.MODULE$;
            DataType dataType6 = $org_scalatest_assert_macro_left6;
            StringType$ stringType$3 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(dataType6 != null ? !dataType6.equals(stringType$3) : stringType$3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            DataType $org_scalatest_assert_macro_left7 = inferSchema.inferField((DataType)DoubleType$.MODULE$, "2015-08-20 15:57:00");
            StringType$ $org_scalatest_assert_macro_right7 = StringType$.MODULE$;
            DataType dataType7 = $org_scalatest_assert_macro_left7;
            StringType$ stringType$4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(dataType7 != null ? !dataType7.equals(stringType$4) : stringType$4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            DataType $org_scalatest_assert_macro_left8 = inferSchema.inferField((DataType)LongType$.MODULE$, "True");
            StringType$ $org_scalatest_assert_macro_right8 = StringType$.MODULE$;
            DataType dataType8 = $org_scalatest_assert_macro_left8;
            StringType$ stringType$5 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(dataType8 != null ? !dataType8.equals(stringType$5) : stringType$5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            DataType $org_scalatest_assert_macro_left9 = inferSchema.inferField((DataType)IntegerType$.MODULE$, "FALSE");
            StringType$ $org_scalatest_assert_macro_right9 = StringType$.MODULE$;
            DataType dataType9 = $org_scalatest_assert_macro_left9;
            StringType$ stringType$6 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(dataType9 != null ? !dataType9.equals(stringType$6) : stringType$6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            DataType $org_scalatest_assert_macro_left10 = inferSchema.inferField((DataType)TimestampType$.MODULE$, "FALSE");
            StringType$ $org_scalatest_assert_macro_right10 = StringType$.MODULE$;
            DataType dataType10 = $org_scalatest_assert_macro_left10;
            StringType$ stringType$7 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(dataType10 != null ? !dataType10.equals(stringType$7) : stringType$7 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            String textValueOne = Long.toString(Long.MAX_VALUE) + "0";
            BigDecimal decimalValueOne = new BigDecimal(textValueOne);
            DecimalType expectedTypeOne = new DecimalType(decimalValueOne.precision(), decimalValueOne.scale());
            DataType $org_scalatest_assert_macro_left11 = inferSchema.inferField((DataType)IntegerType$.MODULE$, textValueOne);
            DecimalType $org_scalatest_assert_macro_right11 = expectedTypeOne;
            DataType dataType11 = $org_scalatest_assert_macro_left11;
            DecimalType decimalType = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(dataType11 != null ? !dataType11.equals(decimalType) : decimalType != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("Timestamp field types are inferred correctly via custom data format", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-mm")})), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)TimestampType$.MODULE$, "2015-08");
            TimestampType$ $org_scalatest_assert_macro_right = TimestampType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            TimestampType$ timestampType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy")})), false, "UTC");
            inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left2 = inferSchema.inferField((DataType)TimestampType$.MODULE$, "2015");
            TimestampType$ $org_scalatest_assert_macro_right2 = TimestampType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            TimestampType$ timestampType$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(timestampType$2) : timestampType$2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("Timestamp field types are inferred correctly from other types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)IntegerType$.MODULE$, "2015-08-20 14");
            StringType$ $org_scalatest_assert_macro_right = StringType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            StringType$ stringType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            DataType $org_scalatest_assert_macro_left2 = inferSchema.inferField((DataType)DoubleType$.MODULE$, "2015-08-20 14:10");
            StringType$ $org_scalatest_assert_macro_right2 = StringType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            StringType$ stringType$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(stringType$2) : stringType$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            DataType $org_scalatest_assert_macro_left3 = inferSchema.inferField((DataType)LongType$.MODULE$, "2015-08 14:49:00");
            StringType$ $org_scalatest_assert_macro_right3 = StringType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left3;
            StringType$ stringType$3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(stringType$3) : stringType$3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("Boolean fields types are inferred correctly from other types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)LongType$.MODULE$, "Fale");
            StringType$ $org_scalatest_assert_macro_right = StringType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            StringType$ stringType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            DataType $org_scalatest_assert_macro_left2 = inferSchema.inferField((DataType)DoubleType$.MODULE$, "TRUEe");
            StringType$ $org_scalatest_assert_macro_right2 = StringType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            StringType$ stringType$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(stringType$2) : stringType$2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("Type arrays are merged to highest common type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])inferSchema.mergeRowTypes((DataType[])((Object[])new DataType[]{StringType$.MODULE$}), (DataType[])((Object[])new DataType[]{DoubleType$.MODULE$}))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$})), "scala.Predef.wrapRefArray[org.apache.spark.sql.types.DataType](inferSchema.mergeRowTypes(scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.StringType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])), scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.DoubleType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])))).sameElements[org.apache.spark.sql.types.DataType](scala.Predef.wrapRefArray[org.apache.spark.sql.types.StringType.type](scala.Array.apply[org.apache.spark.sql.types.StringType.type](org.apache.spark.sql.types.StringType)((ClassTag.apply[org.apache.spark.sql.types.StringType.type](classOf[org.apache.spark.sql.types.StringType$]): scala.reflect.ClassTag[org.apache.spark.sql.types.StringType.type]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])inferSchema.mergeRowTypes((DataType[])((Object[])new DataType[]{IntegerType$.MODULE$}), (DataType[])((Object[])new DataType[]{LongType$.MODULE$}))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new LongType$[]{LongType$.MODULE$})), "scala.Predef.wrapRefArray[org.apache.spark.sql.types.DataType](inferSchema.mergeRowTypes(scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.IntegerType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])), scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.LongType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])))).sameElements[org.apache.spark.sql.types.DataType](scala.Predef.wrapRefArray[org.apache.spark.sql.types.LongType.type](scala.Array.apply[org.apache.spark.sql.types.LongType.type](org.apache.spark.sql.types.LongType)((ClassTag.apply[org.apache.spark.sql.types.LongType.type](classOf[org.apache.spark.sql.types.LongType$]): scala.reflect.ClassTag[org.apache.spark.sql.types.LongType.type]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])inferSchema.mergeRowTypes((DataType[])((Object[])new DataType[]{DoubleType$.MODULE$}), (DataType[])((Object[])new DataType[]{LongType$.MODULE$}))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new DoubleType$[]{DoubleType$.MODULE$})), "scala.Predef.wrapRefArray[org.apache.spark.sql.types.DataType](inferSchema.mergeRowTypes(scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.DoubleType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])), scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.LongType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])))).sameElements[org.apache.spark.sql.types.DataType](scala.Predef.wrapRefArray[org.apache.spark.sql.types.DoubleType.type](scala.Array.apply[org.apache.spark.sql.types.DoubleType.type](org.apache.spark.sql.types.DoubleType)((ClassTag.apply[org.apache.spark.sql.types.DoubleType.type](classOf[org.apache.spark.sql.types.DoubleType$]): scala.reflect.ClassTag[org.apache.spark.sql.types.DoubleType.type]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])inferSchema.mergeRowTypes((DataType[])((Object[])new DataType[]{DateType$.MODULE$}), (DataType[])((Object[])new DataType[]{TimestampNTZType$.MODULE$}))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new TimestampNTZType$[]{TimestampNTZType$.MODULE$})), "scala.Predef.wrapRefArray[org.apache.spark.sql.types.DataType](inferSchema.mergeRowTypes(scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.DateType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])), scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.TimestampNTZType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])))).sameElements[org.apache.spark.sql.types.DataType](scala.Predef.wrapRefArray[org.apache.spark.sql.types.TimestampNTZType.type](scala.Array.apply[org.apache.spark.sql.types.TimestampNTZType.type](org.apache.spark.sql.types.TimestampNTZType)((ClassTag.apply[org.apache.spark.sql.types.TimestampNTZType.type](classOf[org.apache.spark.sql.types.TimestampNTZType$]): scala.reflect.ClassTag[org.apache.spark.sql.types.TimestampNTZType.type]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])inferSchema.mergeRowTypes((DataType[])((Object[])new DataType[]{DateType$.MODULE$}), (DataType[])((Object[])new DataType[]{TimestampType$.MODULE$}))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType$[]{TimestampType$.MODULE$})), "scala.Predef.wrapRefArray[org.apache.spark.sql.types.DataType](inferSchema.mergeRowTypes(scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.DateType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])), scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.TimestampType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])))).sameElements[org.apache.spark.sql.types.DataType](scala.Predef.wrapRefArray[org.apache.spark.sql.types.TimestampType.type](scala.Array.apply[org.apache.spark.sql.types.TimestampType.type](org.apache.spark.sql.types.TimestampType)((ClassTag.apply[org.apache.spark.sql.types.TimestampType.type](classOf[org.apache.spark.sql.types.TimestampType$]): scala.reflect.ClassTag[org.apache.spark.sql.types.TimestampType.type]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd HH:mm:ss"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampNTZFormat"), (Object)"yyyy/MM/dd HH:mm:ss")})), false, "UTC");
            inferSchema = new CSVInferSchema(options);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])inferSchema.mergeRowTypes((DataType[])((Object[])new DataType[]{DateType$.MODULE$}), (DataType[])((Object[])new DataType[]{TimestampNTZType$.MODULE$}))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$})), "scala.Predef.wrapRefArray[org.apache.spark.sql.types.DataType](inferSchema.mergeRowTypes(scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.DateType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])), scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.TimestampNTZType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])))).sameElements[org.apache.spark.sql.types.DataType](scala.Predef.wrapRefArray[org.apache.spark.sql.types.StringType.type](scala.Array.apply[org.apache.spark.sql.types.StringType.type](org.apache.spark.sql.types.StringType)((ClassTag.apply[org.apache.spark.sql.types.StringType.type](classOf[org.apache.spark.sql.types.StringType$]): scala.reflect.ClassTag[org.apache.spark.sql.types.StringType.type]))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])inferSchema.mergeRowTypes((DataType[])((Object[])new DataType[]{DateType$.MODULE$}), (DataType[])((Object[])new DataType[]{TimestampType$.MODULE$}))).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$})), "scala.Predef.wrapRefArray[org.apache.spark.sql.types.DataType](inferSchema.mergeRowTypes(scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.DateType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])), scala.Array.apply[org.apache.spark.sql.types.DataType](org.apache.spark.sql.types.TimestampType)((ClassTag.apply[org.apache.spark.sql.types.DataType](classOf[org.apache.spark.sql.types.DataType]): scala.reflect.ClassTag[org.apache.spark.sql.types.DataType])))).sameElements[org.apache.spark.sql.types.DataType](scala.Predef.wrapRefArray[org.apache.spark.sql.types.StringType.type](scala.Array.apply[org.apache.spark.sql.types.StringType.type](org.apache.spark.sql.types.StringType)((ClassTag.apply[org.apache.spark.sql.types.StringType.type](classOf[org.apache.spark.sql.types.StringType$]): scala.reflect.ClassTag[org.apache.spark.sql.types.StringType.type]))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("Null fields are handled properly when a nullValue is specified", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)"null")})), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)NullType$.MODULE$, "null");
            NullType$ $org_scalatest_assert_macro_right = NullType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            NullType$ nullType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            DataType $org_scalatest_assert_macro_left2 = inferSchema.inferField((DataType)StringType$.MODULE$, "null");
            StringType$ $org_scalatest_assert_macro_right2 = StringType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            StringType$ stringType$ = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            DataType $org_scalatest_assert_macro_left3 = inferSchema.inferField((DataType)LongType$.MODULE$, "null");
            LongType$ $org_scalatest_assert_macro_right3 = LongType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left3;
            LongType$ longType$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(longType$) : longType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)"\\N")})), false, "UTC");
            inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left4 = inferSchema.inferField((DataType)IntegerType$.MODULE$, "\\N");
            IntegerType$ $org_scalatest_assert_macro_right4 = IntegerType$.MODULE$;
            DataType dataType4 = $org_scalatest_assert_macro_left4;
            IntegerType$ integerType$ = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType4 != null ? !dataType4.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            DataType $org_scalatest_assert_macro_left5 = inferSchema.inferField((DataType)DoubleType$.MODULE$, "\\N");
            DoubleType$ $org_scalatest_assert_macro_right5 = DoubleType$.MODULE$;
            DataType dataType5 = $org_scalatest_assert_macro_left5;
            DoubleType$ doubleType$ = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(dataType5 != null ? !dataType5.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            DataType $org_scalatest_assert_macro_left6 = inferSchema.inferField((DataType)TimestampType$.MODULE$, "\\N");
            TimestampType$ $org_scalatest_assert_macro_right6 = TimestampType$.MODULE$;
            DataType dataType6 = $org_scalatest_assert_macro_left6;
            TimestampType$ timestampType$ = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(dataType6 != null ? !dataType6.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            DataType $org_scalatest_assert_macro_left7 = inferSchema.inferField((DataType)BooleanType$.MODULE$, "\\N");
            BooleanType$ $org_scalatest_assert_macro_right7 = BooleanType$.MODULE$;
            DataType dataType7 = $org_scalatest_assert_macro_left7;
            BooleanType$ booleanType$ = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(dataType7 != null ? !dataType7.equals(booleanType$) : booleanType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            DataType $org_scalatest_assert_macro_left8 = inferSchema.inferField((DataType)new DecimalType(1, 1), "\\N");
            DecimalType $org_scalatest_assert_macro_right8 = new DecimalType(1, 1);
            DataType dataType8 = $org_scalatest_assert_macro_left8;
            DecimalType decimalType = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(dataType8 != null ? !dataType8.equals(decimalType) : decimalType != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("Merging Nulltypes should yield Nulltype.", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType[] mergedNullTypes = inferSchema.mergeRowTypes((DataType[])((Object[])new DataType[]{NullType$.MODULE$}), (DataType[])((Object[])new DataType[]{NullType$.MODULE$}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapRefArray((Object[])mergedNullTypes).sameElements((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])new NullType$[]{NullType$.MODULE$})), "scala.Predef.wrapRefArray[org.apache.spark.sql.types.DataType](mergedNullTypes).sameElements[org.apache.spark.sql.types.DataType](scala.Predef.wrapRefArray[org.apache.spark.sql.types.NullType.type](scala.Array.apply[org.apache.spark.sql.types.NullType.type](org.apache.spark.sql.types.NullType)((ClassTag.apply[org.apache.spark.sql.types.NullType.type](classOf[org.apache.spark.sql.types.NullType$]): scala.reflect.ClassTag[org.apache.spark.sql.types.NullType.type]))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("SPARK-18433: Improve DataSource option keys to be more case-insensitive", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TiMeStampFormat"), (Object)"yyyy-mm")})), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)TimestampType$.MODULE$, "2015-08");
            TimestampType$ $org_scalatest_assert_macro_right = TimestampType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            TimestampType$ timestampType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("SPARK-18877: `inferField` on DecimalType should find a common type with `typeSoFar`", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_ALLOW_NEGATIVE_SCALE_OF_DECIMAL_ENABLED().key()), (Object)"true")}), (Function0 & Serializable)() -> {
                DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)new DecimalType(3, -10), "1.19E11");
                DecimalType $org_scalatest_assert_macro_right = new DecimalType(4, -9);
                DataType dataType = $org_scalatest_assert_macro_left;
                DecimalType decimalType = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(decimalType) : decimalType != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            });
            String value = "12345678901234567890.01234567890123456789";
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)new DecimalType(3, 0), value);
            DoubleType$ $org_scalatest_assert_macro_right = DoubleType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            DoubleType$ doubleType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            DataType $org_scalatest_assert_macro_left2 = inferSchema.inferField((DataType)NullType$.MODULE$, Long.MAX_VALUE + "1");
            DecimalType $org_scalatest_assert_macro_right2 = new DecimalType(20, 0);
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            DecimalType decimalType = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(decimalType) : decimalType != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            DataType $org_scalatest_assert_macro_left3 = inferSchema.inferField((DataType)new DecimalType(20, 0), "2015-12-01 00:00:00");
            StringType$ $org_scalatest_assert_macro_right3 = StringType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left3;
            StringType$ stringType$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.test("DoubleType should be inferred when user defined nan/inf are provided", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nanValue"), (Object)"nan"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"negativeInf"), (Object)"-inf"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"positiveInf"), (Object)"inf")})), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)NullType$.MODULE$, "nan");
            DoubleType$ $org_scalatest_assert_macro_right = DoubleType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            DoubleType$ doubleType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            DataType $org_scalatest_assert_macro_left2 = inferSchema.inferField((DataType)NullType$.MODULE$, "inf");
            DoubleType$ $org_scalatest_assert_macro_right2 = DoubleType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            DoubleType$ doubleType$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(doubleType$2) : doubleType$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            DataType $org_scalatest_assert_macro_left3 = inferSchema.inferField((DataType)NullType$.MODULE$, "-inf");
            DoubleType$ $org_scalatest_assert_macro_right3 = DoubleType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left3;
            DoubleType$ doubleType$3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(doubleType$3) : doubleType$3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("inferring the decimal type using locale", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            new .colon.colon((Object)"en-US", (List)Nil$.MODULE$).foreach((Function1 & Serializable)x$1 -> {
                CSVInferSchemaSuite.checkDecimalInfer$1(x$1, (DataType)StringType$.MODULE$);
                return BoxedUnit.UNIT;
            });
            new .colon.colon((Object)"ko-KR", (List)new .colon.colon((Object)"ru-RU", (List)new .colon.colon((Object)"de-DE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)x$2 -> {
                CSVInferSchemaSuite.checkDecimalInfer$1(x$2, (DataType)new DecimalType(7, 0));
                return BoxedUnit.UNIT;
            });
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        this.test("SPARK-39469: inferring date type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy/MM/dd")})), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)NullType$.MODULE$, "2018/12/02");
            DateType$ $org_scalatest_assert_macro_right = DateType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            DateType$ dateType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dateType$) : dateType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"MMM yyyy")})), false, "GMT");
            inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left2 = inferSchema.inferField((DataType)NullType$.MODULE$, "Dec 2018");
            DateType$ $org_scalatest_assert_macro_right2 = DateType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            DateType$ dateType$2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(dateType$2) : dateType$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd'T'HH:mm:ss")})), false, "GMT");
            inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left3 = inferSchema.inferField((DataType)NullType$.MODULE$, "2018-12-03T11:00:00");
            TimestampType$ $org_scalatest_assert_macro_right3 = TimestampType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left3;
            TimestampType$ timestampType$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(timestampType$) : timestampType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            DataType $org_scalatest_assert_macro_left4 = inferSchema.inferField((DataType)NullType$.MODULE$, "2018-12-03");
            DateType$ $org_scalatest_assert_macro_right4 = DateType$.MODULE$;
            DataType dataType4 = $org_scalatest_assert_macro_left4;
            DateType$ dateType$3 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType4 != null ? !dataType4.equals(dateType$3) : dateType$3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("SPARK-39469: inferring the schema of columns with mixing dates and timestamps properly", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy_MM_dd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy|MM|dd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampNTZFormat"), (Object)"yyyy/MM/dd")})), false, "UTC");
            ObjectRef inferSchema = ObjectRef.create((Object)new CSVInferSchema(options));
            DataType $org_scalatest_assert_macro_left = ((CSVInferSchema)inferSchema.elem).inferField((DataType)DateType$.MODULE$, "2012_12_12");
            DateType$ $org_scalatest_assert_macro_right = DateType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            DateType$ dateType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dateType$) : dateType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            DataType $org_scalatest_assert_macro_left2 = ((CSVInferSchema)inferSchema.elem).inferField((DataType)DateType$.MODULE$, "2003|01|01");
            StringType$ $org_scalatest_assert_macro_right2 = StringType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left2;
            StringType$ stringType$ = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.TIMESTAMP_TYPE().key()), (Object)SQLConf.TimestampTypes$.MODULE$.TIMESTAMP_NTZ().toString())}), (Function0 & Serializable)() -> {
                DataType $org_scalatest_assert_macro_left = ((CSVInferSchema)inferSchema$2.elem).inferField((DataType)DateType$.MODULE$, "2003/02/05");
                StringType$ $org_scalatest_assert_macro_right = StringType$.MODULE$;
                DataType dataType = $org_scalatest_assert_macro_left;
                StringType$ stringType$ = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            });
            DataType $org_scalatest_assert_macro_left3 = ((CSVInferSchema)inferSchema.elem).inferField((DataType)TimestampNTZType$.MODULE$, "2012_12_12");
            StringType$ $org_scalatest_assert_macro_right3 = StringType$.MODULE$;
            DataType dataType3 = $org_scalatest_assert_macro_left3;
            StringType$ stringType$2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(stringType$2) : stringType$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            DataType $org_scalatest_assert_macro_left4 = ((CSVInferSchema)inferSchema.elem).inferField((DataType)TimestampType$.MODULE$, "2018_12_03");
            StringType$ $org_scalatest_assert_macro_right4 = StringType$.MODULE$;
            DataType dataType4 = $org_scalatest_assert_macro_left4;
            StringType$ stringType$3 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType4 != null ? !dataType4.equals(stringType$3) : stringType$3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy_MM_dd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy_MM_dd")})), false, "UTC");
            inferSchema.elem = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left5 = ((CSVInferSchema)inferSchema.elem).inferField((DataType)DateType$.MODULE$, "2012_12_12");
            DateType$ $org_scalatest_assert_macro_right5 = DateType$.MODULE$;
            DataType dataType5 = $org_scalatest_assert_macro_left5;
            DateType$ dateType$2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(dataType5 != null ? !dataType5.equals(dateType$2) : dateType$2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("SPARK-45433: inferring the schema when timestamps do not match specified timestampFormat with only one row", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd'T'HH:mm:ss")})), false, "UTC");
            CSVInferSchema inferSchema = new CSVInferSchema(options);
            DataType $org_scalatest_assert_macro_left = inferSchema.inferField((DataType)NullType$.MODULE$, "2884-06-24T02:45:51.138");
            StringType$ $org_scalatest_assert_macro_right = StringType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left;
            StringType$ stringType$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        }, new Position("CSVInferSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
    }
}

