/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.ArrayDistinct;
import org.apache.spark.sql.catalyst.expressions.ArrayExcept;
import org.apache.spark.sql.catalyst.expressions.ArrayIntersect;
import org.apache.spark.sql.catalyst.expressions.ArrayUnion;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Collate;
import org.apache.spark.sql.catalyst.expressions.Collation;
import org.apache.spark.sql.catalyst.expressions.CollationKey;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.ResolvedCollation;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Shrink;
import org.scalacheck.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.enablers.WheneverAsserting;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatest.prop.Whenever;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckDrivenPropertyChecks;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005U2A\u0001C\u0005\u0001-!)q\u0004\u0001C\u0001A!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003B\u0002\u0017\u0001A\u0003%A\u0005C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\rI\u0002\u0001\u0015!\u00030\u0011\u001d\u0019\u0004A1A\u0005\n9Ba\u0001\u000e\u0001!\u0002\u0013y#\u0001G\"pY2\fG/[8o\u000bb\u0004(/Z:tS>t7+^5uK*\u0011!bC\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\r\u001b\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u000f\u001f\u0005\u00191/\u001d7\u000b\u0005A\t\u0012!B:qCJ\\'B\u0001\n\u0014\u0003\u0019\t\u0007/Y2iK*\tA#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001/m\u0001\"\u0001G\r\u000e\u0003=I!AG\b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\taR$D\u0001\n\u0013\tq\u0012B\u0001\u000bFqB\u0014Xm]:j_:,e/\u00197IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"\u0001\b\u0001\u0002)\u0019,H\u000e\\=Rk\u0006d\u0017NZ5fIB\u0013XMZ5y+\u0005!\u0003CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0011a\u0017M\\4\u000b\u0003%\nAA[1wC&\u00111F\n\u0002\u0007'R\u0014\u0018N\\4\u0002+\u0019,H\u000e\\=Rk\u0006d\u0017NZ5fIB\u0013XMZ5yA\u0005QR\u000b\u0016$9?\nKe*\u0011*Z?\u000e{E\nT!U\u0013>suLT!N\u000bV\tq\u0006\u0005\u0002\u001da%\u0011\u0011'\u0003\u0002\u0012%\u0016\u001cx\u000e\u001c<fI\u000e{G\u000e\\1uS>t\u0017aG+U\rbz&)\u0013(B%f{6i\u0014'M\u0003RKuJT0O\u00036+\u0005%A\rV)\u001aCt\fT\"B'\u0016{6i\u0014'M\u0003RKuJT0O\u00036+\u0015AG+U\rbzFjQ!T\u000b~\u001bu\n\u0014'B)&{ej\u0018(B\u001b\u0016\u0003\u0003")
public class CollationExpressionSuite
extends SparkFunSuite
implements ExpressionEvalHelper {
    private final String fullyQualifiedPrefix;
    private final ResolvedCollation UTF8_BINARY_COLLATION_NAME;
    private final ResolvedCollation UTF8_LCASE_COLLATION_NAME;
    private String sparkHome;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;
    private Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private volatile boolean bitmap$0;

    @Override
    public InternalRow create_row(Seq<Object> values) {
        return ExpressionEvalHelper.create_row$(this, values);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Tuple2<?, ?>> entries) {
        return ExpressionEvalHelper.create_map$(this, entries);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Object> keys, Seq<Object> values) {
        return ExpressionEvalHelper.create_map$(this, keys, values);
    }

    @Override
    public Expression replace(Expression expr) {
        return ExpressionEvalHelper.replace$(this, expr);
    }

    @Override
    public void checkEvaluation(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluation$default$3() {
        return ExpressionEvalHelper.checkEvaluation$default$3$(this);
    }

    @Override
    public boolean checkResult(Object result, Object expected, Expression expression) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, expression);
    }

    @Override
    public boolean checkResult(Object result, Object expected, DataType exprDataType, boolean exprNullable) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, exprDataType, exprNullable);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, String condition, Map<String, String> parameters, ClassTag<T> evidence$1) {
        ExpressionEvalHelper.checkErrorInExpression$((ExpressionEvalHelper)this, expression, condition, parameters, evidence$1);
    }

    @Override
    public <T extends SparkThrowable> Map<String, String> checkErrorInExpression$default$3() {
        return ExpressionEvalHelper.checkErrorInExpression$default$3$(this);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, InternalRow inputRow, String condition, ClassTag<T> evidence$2) {
        ExpressionEvalHelper.checkErrorInExpression$((ExpressionEvalHelper)this, expression, inputRow, condition, evidence$2);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, InternalRow inputRow, String condition, Map<String, String> parameters, ClassTag<T> evidence$3) {
        ExpressionEvalHelper.checkErrorInExpression$(this, expression, inputRow, condition, parameters, evidence$3);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, String expectedErrMsg, ClassTag<T> evidence$4) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, expectedErrMsg, evidence$4);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, InternalRow inputRow, String expectedErrMsg, ClassTag<T> evidence$5) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, inputRow, expectedErrMsg, evidence$5);
    }

    @Override
    public Object evaluateWithoutCodegen(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithoutCodegen$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithoutCodegen$default$2() {
        return ExpressionEvalHelper.evaluateWithoutCodegen$default$2$(this);
    }

    @Override
    public void checkEvaluationWithoutCodegen(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithoutCodegen$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithoutCodegen$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithoutCodegen$default$3$(this);
    }

    @Override
    public void checkEvaluationWithMutableProjection(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithMutableProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithMutableProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithMutableProjection$default$3$(this);
    }

    @Override
    public Object evaluateWithMutableProjection(Function0<Expression> expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithMutableProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithMutableProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithMutableProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithUnsafeProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithUnsafeProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$default$3$(this);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithOptimization(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithOptimization$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithOptimization$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithOptimization$default$3$(this);
    }

    @Override
    public void checkDoubleEvaluation(Function0<Expression> expression, TripleEqualsSupport.Spread<Object> expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkDoubleEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkDoubleEvaluation$default$3() {
        return ExpressionEvalHelper.checkDoubleEvaluation$default$3$(this);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function3<Expression, Expression, Expression, Expression> c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType1, dataType2, dataType3);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Seq<Expression>, Expression> c, DataType dataType, int minNumElements) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType, minNumElements);
    }

    @Override
    public int checkConsistencyBetweenInterpretedAndCodegen$default$3() {
        return ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$default$3$(this);
    }

    @Override
    public void cmpInterpretWithCodegen(InternalRow inputRow, Expression expr, boolean exceptionAllowed) {
        ExpressionEvalHelper.cmpInterpretWithCodegen$(this, inputRow, expr, exceptionAllowed);
    }

    @Override
    public boolean cmpInterpretWithCodegen$default$3() {
        return ExpressionEvalHelper.cmpInterpretWithCodegen$default$3$(this);
    }

    @Override
    public void testBothCodegenAndInterpreted(String name, Function0<BoxedUnit> f) {
        ExpressionEvalHelper.testBothCodegenAndInterpreted$(this, name, f);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public ScalaCheckDrivenPropertyChecks.ConfiguredPropertyCheck forAll(Seq<Configuration.PropertyCheckConfigParam> configParams) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, configParams);
    }

    public <A, ASSERTION> Object forAll(Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(String nameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Gen<A> genA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(String nameA, String nameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(String nameA, String nameB, String nameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, String nameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, (String)nameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Gen<F> genF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, genF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Tuple2<Gen<F>, String> genAndNameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, genAndNameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Test.Parameters getScalaCheckParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return ScalaCheckConfiguration.getScalaCheckParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public Configuration.Parameter getParameter(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return Configuration.getParameter$((Configuration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public <T> Object whenever(boolean condition, Function0<T> fun, WheneverAsserting<T> wa) {
        return Whenever.whenever$((Whenever)this, (boolean)condition, fun, wa);
    }

    private String sparkHome$lzycompute() {
        CollationExpressionSuite collationExpressionSuite = this;
        synchronized (collationExpressionSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
        this.generatorDrivenConfig = x$1;
    }

    private String fullyQualifiedPrefix() {
        return this.fullyQualifiedPrefix;
    }

    private ResolvedCollation UTF8_BINARY_COLLATION_NAME() {
        return this.UTF8_BINARY_COLLATION_NAME;
    }

    private ResolvedCollation UTF8_LCASE_COLLATION_NAME() {
        return this.UTF8_LCASE_COLLATION_NAME;
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        CollationExpressionSuite collationExpressionSuite = this;
        synchronized (collationExpressionSuite) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        CollationExpressionSuite collationExpressionSuite = this;
        synchronized (collationExpressionSuite) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        CollationExpressionSuite collationExpressionSuite = this;
        synchronized (collationExpressionSuite) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
        }
    }

    private final void MinSize$lzycompute$1() {
        CollationExpressionSuite collationExpressionSuite = this;
        synchronized (collationExpressionSuite) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
        }
    }

    private final void SizeRange$lzycompute$1() {
        CollationExpressionSuite collationExpressionSuite = this;
        synchronized (collationExpressionSuite) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
        }
    }

    private final void Workers$lzycompute$1() {
        CollationExpressionSuite collationExpressionSuite = this;
        synchronized (collationExpressionSuite) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$13(Tuple4 check$ifrefutable$1) {
        Tuple4 tuple4 = check$ifrefutable$1;
        return tuple4 != null;
    }

    public static final /* synthetic */ void $anonfun$new$14(CollationExpressionSuite $this, Function2 arrayLiteral$1, Tuple4 x$1) {
        Tuple4 tuple4 = x$1;
        if (tuple4 != null) {
            Seq inLeft = (Seq)tuple4._1();
            Seq inRight = (Seq)tuple4._2();
            boolean out = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
            String collName = (String)tuple4._4();
            Literal left = (Literal)arrayLiteral$1.apply((Object)inLeft, (Object)collName);
            Literal right = (Literal)arrayLiteral$1.apply((Object)inRight, (Object)collName);
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ArraysOverlap((Expression)left, (Expression)right), BoxesRunTime.boxToBoolean((boolean)out), $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$new$16(Tuple3 check$ifrefutable$2) {
        Tuple3 tuple3 = check$ifrefutable$2;
        return tuple3 != null;
    }

    public static final /* synthetic */ void $anonfun$new$17(CollationExpressionSuite $this, Function2 arrayLiteral$1, Tuple3 x$2) {
        Tuple3 tuple3 = x$2;
        if (tuple3 != null) {
            Seq in = (Seq)tuple3._1();
            Seq out = (Seq)tuple3._2();
            String collName = (String)tuple3._3();
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ArrayDistinct((Expression)arrayLiteral$1.apply((Object)in, (Object)collName)), out, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$new$19(Tuple4 check$ifrefutable$3) {
        Tuple4 tuple4 = check$ifrefutable$3;
        return tuple4 != null;
    }

    public static final /* synthetic */ void $anonfun$new$20(CollationExpressionSuite $this, Function2 arrayLiteral$1, Tuple4 x$3) {
        Tuple4 tuple4 = x$3;
        if (tuple4 != null) {
            Seq inLeft = (Seq)tuple4._1();
            Seq inRight = (Seq)tuple4._2();
            Seq out = (Seq)tuple4._3();
            String collName = (String)tuple4._4();
            Literal left = (Literal)arrayLiteral$1.apply((Object)inLeft, (Object)collName);
            Literal right = (Literal)arrayLiteral$1.apply((Object)inRight, (Object)collName);
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ArrayUnion((Expression)left, (Expression)right), out, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$new$22(Tuple4 check$ifrefutable$4) {
        Tuple4 tuple4 = check$ifrefutable$4;
        return tuple4 != null;
    }

    public static final /* synthetic */ void $anonfun$new$23(CollationExpressionSuite $this, Function2 arrayLiteral$1, Tuple4 x$4) {
        Tuple4 tuple4 = x$4;
        if (tuple4 != null) {
            Seq inLeft = (Seq)tuple4._1();
            Seq inRight = (Seq)tuple4._2();
            Seq out = (Seq)tuple4._3();
            String collName = (String)tuple4._4();
            Literal left = (Literal)arrayLiteral$1.apply((Object)inLeft, (Object)collName);
            Literal right = (Literal)arrayLiteral$1.apply((Object)inRight, (Object)collName);
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ArrayIntersect((Expression)left, (Expression)right), out, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$new$25(Tuple4 check$ifrefutable$5) {
        Tuple4 tuple4 = check$ifrefutable$5;
        return tuple4 != null;
    }

    public static final /* synthetic */ void $anonfun$new$26(CollationExpressionSuite $this, Function2 arrayLiteral$1, Tuple4 x$5) {
        Tuple4 tuple4 = x$5;
        if (tuple4 != null) {
            Seq inLeft = (Seq)tuple4._1();
            Seq inRight = (Seq)tuple4._2();
            Seq out = (Seq)tuple4._3();
            String collName = (String)tuple4._4();
            Literal left = (Literal)arrayLiteral$1.apply((Object)inLeft, (Object)collName);
            Literal right = (Literal)arrayLiteral$1.apply((Object)inRight, (Object)collName);
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ArrayExcept((Expression)left, (Expression)right), out, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$new$29(Tuple3 check$ifrefutable$6) {
        Tuple3 tuple3 = check$ifrefutable$6;
        return tuple3 != null;
    }

    public static final /* synthetic */ void $anonfun$new$30(CollationExpressionSuite $this, Tuple3 x$6) {
        Tuple3 tuple3 = x$6;
        if (tuple3 != null) {
            String input = (String)tuple3._1();
            String collation = (String)tuple3._2();
            byte[] expected = (byte[])tuple3._3();
            Literal str = Literal$.MODULE$.create((Object)input, (DataType)StringType$.MODULE$.apply(collation));
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new CollationKey((Expression)str), expected, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$new$33(CollationExpressionSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String collation = (String)tuple2._1();
            String normalized = (String)tuple2._2();
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new Collation((Expression)Literal$.MODULE$.create((Object)"abc", (DataType)StringType$.MODULE$.apply(collation))), $this.fullyQualifiedPrefix() + normalized, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final GenericArrayData arr$1(String s) {
        return new GenericArrayData((Object)new UTF8String[]{UTF8String.fromString((String)s)});
    }

    public static final /* synthetic */ void $anonfun$new$36(CollationExpressionSuite $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            Object result = tuple2._2();
            if (tuple3 != null) {
                String elem = (String)tuple3._1();
                String collation = (String)tuple3._2();
                Set inputSet = (Set)tuple3._3();
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new InSet((Expression)Literal$.MODULE$.create((Object)elem, (DataType)StringType$.MODULE$.apply(collation)), (Set)inputSet.map((Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1))), result, $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new InSet((Expression)Literal$.MODULE$.create((Object)(elem == null ? null : CollationExpressionSuite.arr$1(elem)), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(collation))), (Set)inputSet.map((Function1 & Serializable)s -> CollationExpressionSuite.arr$1(s))), result, $this.checkEvaluation$default$3());
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new InSet((Expression)Literal$.MODULE$.create((Object)(elem == null ? null : new ArrayBasedMapData((ArrayData)CollationExpressionSuite.arr$1(elem), (ArrayData)CollationExpressionSuite.arr$1("aBc"))), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(collation), (DataType)StringType$.MODULE$.apply("UTF8_BINARY"))), (Set)inputSet.map((Function1 & Serializable)s -> new ArrayBasedMapData((ArrayData)CollationExpressionSuite.arr$1(s), (ArrayData)CollationExpressionSuite.arr$1("aBc")))), result, $this.checkEvaluation$default$3());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public CollationExpressionSuite() {
        Whenever.$init$((Whenever)this);
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        ScalaCheckDrivenPropertyChecks.$init$((ScalaCheckDrivenPropertyChecks)this);
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        PlanTestBase.$init$(this);
        ExpressionEvalHelper.$init$(this);
        this.fullyQualifiedPrefix = "SYSTEM.BUILTIN.";
        this.UTF8_BINARY_COLLATION_NAME = new ResolvedCollation("UTF8_BINARY");
        this.UTF8_LCASE_COLLATION_NAME = new ResolvedCollation("UTF8_LCASE");
        this.test("validate default collation", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int collationId;
            int $org_scalatest_assert_macro_left = collationId = CollationFactory.collationNameToId((String)"UTF8_BINARY");
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
            Collate collateExpr = new Collate((Expression)Literal$.MODULE$.apply((Object)"abc"), (Expression)this.UTF8_BINARY_COLLATION_NAME());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(collateExpr.dataType());
            StringType $org_scalatest_assert_macro_right2 = StringType$.MODULE$.apply(collationId);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            int $org_scalatest_assert_macro_left3 = ((StringType)collateExpr.dataType()).collationId();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> collateExpr, "abc", this.checkEvaluation$default$3());
        }, new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("collate against literal", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Collate collateExpr = new Collate((Expression)Literal$.MODULE$.apply((Object)"abc"), (Expression)this.UTF8_LCASE_COLLATION_NAME());
            int collationId = CollationFactory.collationNameToId((String)"UTF8_LCASE");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(collateExpr.dataType());
            StringType $org_scalatest_assert_macro_right = StringType$.MODULE$.apply(collationId);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> collateExpr, "abc", this.checkEvaluation$default$3());
        }, new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("check input types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Collate collateExpr = new Collate((Expression)Literal$.MODULE$.apply((Object)"abc"), (Expression)this.UTF8_BINARY_COLLATION_NAME());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(collateExpr.checkInputDataTypes().isSuccess(), "collateExpr.checkInputDataTypes().isSuccess", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            Collate collateExprExplicitDefault = new Collate((Expression)Literal$.MODULE$.create((Object)"abc", (DataType)StringType$.MODULE$.apply(0)), (Expression)this.UTF8_BINARY_COLLATION_NAME());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(collateExprExplicitDefault.checkInputDataTypes().isSuccess(), "collateExprExplicitDefault.checkInputDataTypes().isSuccess", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            Collate collateExprExplicitNonDefault = new Collate((Expression)Literal$.MODULE$.create((Object)"abc", (DataType)StringType$.MODULE$.apply(1)), (Expression)this.UTF8_BINARY_COLLATION_NAME());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(collateExprExplicitNonDefault.checkInputDataTypes().isSuccess(), "collateExprExplicitNonDefault.checkInputDataTypes().isSuccess", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            Collate collateOnNull = new Collate((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$.apply(1)), (Expression)this.UTF8_BINARY_COLLATION_NAME());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(collateOnNull.checkInputDataTypes().isSuccess(), "collateOnNull.checkInputDataTypes().isSuccess", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            Collate collateOnInt = new Collate((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)this.UTF8_BINARY_COLLATION_NAME());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(collateOnInt.checkInputDataTypes().isFailure(), "collateOnInt.checkInputDataTypes().isFailure", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("collation on non-explicit default collation", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new Collation((Expression)Literal$.MODULE$.apply((Object)"abc")), this.fullyQualifiedPrefix() + "UTF8_BINARY", this.checkEvaluation$default$3()), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("collation on explicitly collated string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new Collation((Expression)Literal$.MODULE$.create((Object)"abc", (DataType)StringType$.MODULE$.apply(CollationFactory.UTF8_LCASE_COLLATION_ID))), this.fullyQualifiedPrefix() + "UTF8_LCASE", this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new Collation((Expression)new Collate((Expression)Literal$.MODULE$.apply((Object)"abc"), (Expression)this.UTF8_LCASE_COLLATION_NAME())), this.fullyQualifiedPrefix() + "UTF8_LCASE", this.checkEvaluation$default$3());
        }, new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("Array operations on arrays of collated strings", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Function2 & Serializable arrayLiteral = (Function2 & Serializable)(arr, collName) -> Literal$.MODULE$.create(arr, (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(CollationFactory.collationNameToId((String)collName))));
            Seq overlap = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$), (Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"UTF8_BINARY"), new Tuple4((Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$), (Object)new .colon.colon((Object)"b", (List)Nil$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"UTF8_BINARY"), new Tuple4((Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$), (Object)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"UTF8_BINARY"), new Tuple4((Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$), (Object)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"UTF8_LCASE"), new Tuple4((Object)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$)), (Object)new .colon.colon((Object)"A", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"UTF8_LCASE"), new Tuple4((Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$), (Object)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"UNICODE"), new Tuple4((Object)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$)), (Object)new .colon.colon((Object)"A", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"UNICODE_CI"), new Tuple4((Object)new .colon.colon((Object)"c", (List)Nil$.MODULE$), (Object)new .colon.colon((Object)"C", (List)Nil$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"SR"), new Tuple4((Object)new .colon.colon((Object)"c", (List)Nil$.MODULE$), (Object)new .colon.colon((Object)"C", (List)Nil$.MODULE$), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"SR_CI"), new Tuple4((Object)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$)), (Object)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"C", (List)Nil$.MODULE$)), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"SR_CI_AI")}));
            overlap.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CollationExpressionSuite.$anonfun$new$13(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                CollationExpressionSuite.$anonfun$new$14(this, arrayLiteral, x$1);
                return BoxedUnit.UNIT;
            });
            .colon.colon distinct = new .colon.colon((Object)new Tuple3((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple3((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "a"})), (Object)new .colon.colon((Object)"a", (List)Nil$.MODULE$), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple3((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aaa", "AAA", "Aaa", "aAa"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aaa", "AAA", "Aaa", "aAa"})), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple3((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aaa", "AAA", "Aaa", "aAa"})), (Object)new .colon.colon((Object)"aaa", (List)Nil$.MODULE$), (Object)"UTF8_LCASE"), (List)new .colon.colon((Object)new Tuple3((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aaa", "AAA", "Aaa", "aAa", "b"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aaa", "b"})), (Object)"UTF8_LCASE"), (List)new .colon.colon((Object)new Tuple3((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aaa", "AAA", "Aaa", "aAa"})), (Object)new .colon.colon((Object)"aaa", (List)Nil$.MODULE$), (Object)"UNICODE_CI"), (List)Nil$.MODULE$))))));
            distinct.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)CollationExpressionSuite.$anonfun$new$16(check$ifrefutable$2))).foreach((Function1 & Serializable)x$2 -> {
                CollationExpressionSuite.$anonfun$new$17(this, arrayLiteral, x$2);
                return BoxedUnit.UNIT;
            });
            .colon.colon union = new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "A"})), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)"UTF8_LCASE"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)"UTF8_LCASE"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "A"})), (Object)"UNICODE"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)"UNICODE_CI"), (List)Nil$.MODULE$)))))));
            union.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)CollationExpressionSuite.$anonfun$new$19(check$ifrefutable$3))).foreach((Function1 & Serializable)x$3 -> {
                CollationExpressionSuite.$anonfun$new$20(this, arrayLiteral, x$3);
                return BoxedUnit.UNIT;
            });
            .colon.colon intersect = new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Object)package$.MODULE$.Seq().empty(), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Object)package$.MODULE$.Seq().empty(), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)"UTF8_LCASE"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)"UTF8_LCASE"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Object)package$.MODULE$.Seq().empty(), (Object)"UNICODE"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)"UNICODE_CI"), (List)Nil$.MODULE$)))))));
            intersect.withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)CollationExpressionSuite.$anonfun$new$22(check$ifrefutable$4))).foreach((Function1 & Serializable)x$4 -> {
                CollationExpressionSuite.$anonfun$new$23(this, arrayLiteral, x$4);
                return BoxedUnit.UNIT;
            });
            .colon.colon except = new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().empty(), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)"UTF8_BINARY"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Object)package$.MODULE$.Seq().empty(), (Object)"UTF8_LCASE"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Object)package$.MODULE$.Seq().empty(), (Object)"UTF8_LCASE"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Object)"UNICODE"), (List)new .colon.colon((Object)new Tuple4((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "B"})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Object)package$.MODULE$.Seq().empty(), (Object)"UNICODE_CI"), (List)Nil$.MODULE$)))))));
            except.withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)CollationExpressionSuite.$anonfun$new$25(check$ifrefutable$5))).foreach((Function1 & Serializable)x$5 -> {
                CollationExpressionSuite.$anonfun$new$26(this, arrayLiteral, x$5);
                return BoxedUnit.UNIT;
            });
        }, new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("CollationKey generates correct collation key for collated string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            byte b = 43;
            Seq testCases = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"", (Object)"UTF8_BINARY", (Object)UTF8String.fromString((String)"").getBytes()), new Tuple3((Object)"aa", (Object)"UTF8_BINARY", (Object)UTF8String.fromString((String)"aa").getBytes()), new Tuple3((Object)"AA", (Object)"UTF8_BINARY", (Object)UTF8String.fromString((String)"AA").getBytes()), new Tuple3((Object)" AA ", (Object)"UTF8_BINARY_RTRIM", (Object)UTF8String.fromString((String)" AA").getBytes()), new Tuple3((Object)"aA", (Object)"UTF8_BINARY", (Object)UTF8String.fromString((String)"aA").getBytes()), new Tuple3((Object)"", (Object)"UTF8_LCASE", (Object)UTF8String.fromString((String)"").getBytes()), new Tuple3((Object)"aa", (Object)"UTF8_LCASE", (Object)UTF8String.fromString((String)"aa").getBytes()), new Tuple3((Object)"AA", (Object)"UTF8_LCASE", (Object)UTF8String.fromString((String)"aa").getBytes()), new Tuple3((Object)" AA ", (Object)"UTF8_LCASE_RTRIM", (Object)UTF8String.fromString((String)" aa").getBytes()), new Tuple3((Object)"aA", (Object)"UTF8_LCASE", (Object)UTF8String.fromString((String)"aa").getBytes()), new Tuple3((Object)"", (Object)"UNICODE", (Object)new byte[]{1, 1, 0}), new Tuple3((Object)"aa", (Object)"UNICODE", (Object)new byte[]{b, b, 1, 6, 1, 6, 0}), new Tuple3((Object)"AA", (Object)"UNICODE", (Object)new byte[]{b, b, 1, 6, 1, -36, -36, 0}), new Tuple3((Object)"aA", (Object)"UNICODE", (Object)new byte[]{b, b, 1, 6, 1, -59, -36, 0}), new Tuple3((Object)"aa ", (Object)"UNICODE_RTRIM", (Object)new byte[]{b, b, 1, 6, 1, 6, 0}), new Tuple3((Object)"", (Object)"UNICODE_CI", (Object)new byte[]{1, 0}), new Tuple3((Object)"aa", (Object)"UNICODE_CI", (Object)new byte[]{b, b, 1, 6, 0}), new Tuple3((Object)"aa ", (Object)"UNICODE_CI_RTRIM", (Object)new byte[]{b, b, 1, 6, 0}), new Tuple3((Object)"AA", (Object)"UNICODE_CI", (Object)new byte[]{b, b, 1, 6, 0}), new Tuple3((Object)"aA", (Object)"UNICODE_CI", (Object)new byte[]{b, b, 1, 6, 0})}));
            testCases.withFilter((Function1 & Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)CollationExpressionSuite.$anonfun$new$29(check$ifrefutable$6))).foreach((Function1 & Serializable)x$6 -> {
                CollationExpressionSuite.$anonfun$new$30(this, x$6);
                return BoxedUnit.UNIT;
            });
        }, new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("collation name normalization in collation expression", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"en_USA", (Object)"en_USA"), new Tuple2((Object)"en_CS", (Object)"en"), new Tuple2((Object)"en_AS", (Object)"en"), new Tuple2((Object)"en_CS_AS", (Object)"en"), new Tuple2((Object)"en_AS_CS", (Object)"en"), new Tuple2((Object)"en_CI", (Object)"en_CI"), new Tuple2((Object)"en_AI", (Object)"en_AI"), new Tuple2((Object)"en_AI_CI", (Object)"en_CI_AI"), new Tuple2((Object)"en_CI_AI", (Object)"en_CI_AI"), new Tuple2((Object)"en_CS_AI", (Object)"en_AI"), new Tuple2((Object)"en_AI_CS", (Object)"en_AI"), new Tuple2((Object)"en_CI_AS", (Object)"en_CI"), new Tuple2((Object)"en_AS_CI", (Object)"en_CI"), new Tuple2((Object)"en_USA_AI_CI", (Object)"en_USA_CI_AI"), new Tuple2((Object)"EN_USA", (Object)"en_USA"), new Tuple2((Object)"SR_CYRL", (Object)"sr_Cyrl"), new Tuple2((Object)"sr_cyrl_srb", (Object)"sr_Cyrl_SRB"), new Tuple2((Object)"sR_cYRl_sRb", (Object)"sr_Cyrl_SRB")})).foreach((Function1 & Serializable)x0$1 -> {
            CollationExpressionSuite.$anonfun$new$33(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("InSet", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"1", (Object)"UTF8_BINARY", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})))), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"aaa", (Object)"UTF8_BINARY", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c", "Aaa"})))), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"a", (Object)"UTF8_LCASE", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})))), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"a", (Object)"UTF8_LCASE", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})))), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"Belgrade", (Object)"UTF8_LCASE", Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"aBc", (Object)"UTF8_LCASE", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "aa", "xyz"})))), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"aBc", (Object)"UTF8_LCASE", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "AbC", null})))), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3(null, (Object)"UTF8_LCASE", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", "AbC", null})))), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)" aa", (Object)"UTF8_BINARY_RTRIM", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" aa"})))), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)" aa ", (Object)"UTF8_BINARY_RTRIM", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" aa"})))), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"a  ", (Object)"UTF8_BINARY_RTRIM", Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)"a  ", (Object)"UTF8_BINARY_RTRIM", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", null})))), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3(null, (Object)"UTF8_BINARY_RTRIM", Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})))), null)})).foreach((Function1 & Serializable)x0$2 -> {
            CollationExpressionSuite.$anonfun$new$36(this, x0$2);
            return BoxedUnit.UNIT;
        }), new Position("CollationExpressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        Statics.releaseFence();
    }
}

