/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Base64;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtilsSuite$TestCase$;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r=a\u0001B,Y\u0001\u0015DQA\u001b\u0001\u0005\u0002-DqA\u001c\u0001C\u0002\u0013%q\u000eC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u00029\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\u0007\r\u0005M\u0001\u0001QA\u000b\u0011)\tYD\u0002BK\u0002\u0013\u0005\u0011Q\b\u0005\u000b\u0003\u001f2!\u0011#Q\u0001\n\u0005}\u0002BCA)\r\tU\r\u0011\"\u0001\u0002>!Q\u00111\u000b\u0004\u0003\u0012\u0003\u0006I!a\u0010\t\u0015\u0005UcA!f\u0001\n\u0003\ti\u0004\u0003\u0006\u0002X\u0019\u0011\t\u0012)A\u0005\u0003\u007fA!\"!\u0017\u0007\u0005+\u0007I\u0011AA\u001f\u0011)\tYF\u0002B\tB\u0003%\u0011q\b\u0005\u000b\u0003;2!Q3A\u0005\u0002\u0005u\u0002BCA0\r\tE\t\u0015!\u0003\u0002@!Q\u0011\u0011\r\u0004\u0003\u0016\u0004%\t!a\u0019\t\u0015\u0005-dA!E!\u0002\u0013\t)\u0007\u0003\u0006\u0002n\u0019\u0011)\u001a!C\u0001\u0003GB!\"a\u001c\u0007\u0005#\u0005\u000b\u0011BA3\u0011)\t\tH\u0002BK\u0002\u0013\u0005\u00111\r\u0005\u000b\u0003g2!\u0011#Q\u0001\n\u0005\u0015\u0004BCA;\r\tU\r\u0011\"\u0001\u0002x!Q\u0011q\u0010\u0004\u0003\u0012\u0003\u0006I!!\u001f\t\r)4A\u0011AAA\u0011\u001d\tIJ\u0002C\u0001\u00037C\u0011\"a)\u0007\u0005\u0004%\t!!*\t\u0011\u0005Mf\u0001)A\u0005\u0003OC\u0011\"!.\u0007\u0005\u0004%\t!!*\t\u0011\u0005]f\u0001)A\u0005\u0003OC\u0011\"!/\u0007\u0005\u0004%\t!a/\t\u0011\u00055g\u0001)A\u0005\u0003{C\u0011\"a4\u0007\u0005\u0004%\t!a/\t\u0011\u0005Eg\u0001)A\u0005\u0003{C\u0011\"a5\u0007\u0005\u0004%\t!a'\t\u0011\u0005Ug\u0001)A\u0005\u0003;C\u0011\"a6\u0007\u0005\u0004%\t!!*\t\u0011\u0005eg\u0001)A\u0005\u0003OC\u0011\"a7\u0007\u0005\u0004%\t!!*\t\u0011\u0005ug\u0001)A\u0005\u0003OC\u0011\"a8\u0007\u0003\u0003%\t!!9\t\u0013\u0005Uh!%A\u0005\u0002\u0005]\b\"\u0003B\u0007\rE\u0005I\u0011AA|\u0011%\u0011yABI\u0001\n\u0003\t9\u0010C\u0005\u0003\u0012\u0019\t\n\u0011\"\u0001\u0002x\"I!1\u0003\u0004\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0005+1\u0011\u0013!C\u0001\u0005/A\u0011Ba\u0007\u0007#\u0003%\tAa\u0006\t\u0013\tua!%A\u0005\u0002\t]\u0001\"\u0003B\u0010\rE\u0005I\u0011\u0001B\u0011\u0011%\u0011)CBA\u0001\n\u0003\u00129\u0003C\u0005\u00034\u0019\t\t\u0011\"\u0001\u00036!I!Q\b\u0004\u0002\u0002\u0013\u0005!q\b\u0005\n\u0005\u00172\u0011\u0011!C!\u0005\u001bB\u0011Ba\u0017\u0007\u0003\u0003%\tA!\u0018\t\u0013\t\u0005d!!A\u0005B\t\r\u0004\"\u0003B4\r\u0005\u0005I\u0011\tB5\u0011%\u0011YGBA\u0001\n\u0003\u0012i\u0007C\u0005\u0003p\u0019\t\t\u0011\"\u0011\u0003r\u001dI!Q\u000f\u0001\u0002\u0002#\u0005!q\u000f\u0004\n\u0003'\u0001\u0011\u0011!E\u0001\u0005sBaA[\u001f\u0005\u0002\tE\u0005\"\u0003B6{\u0005\u0005IQ\tB7\u0011%\u0011\u0019*PA\u0001\n\u0003\u0013)\nC\u0005\u0003*v\n\n\u0011\"\u0001\u0002x\"I!1V\u001f\u0012\u0002\u0013\u0005!q\u0003\u0005\n\u0005[k\u0014\u0013!C\u0001\u0005/A\u0011Ba,>#\u0003%\tAa\u0006\t\u0013\tEV(%A\u0005\u0002\t\u0005\u0002\"\u0003BZ{\u0005\u0005I\u0011\u0011B[\u0011%\u0011\u0019-PI\u0001\n\u0003\t9\u0010C\u0005\u0003Fv\n\n\u0011\"\u0001\u0003\u0018!I!qY\u001f\u0012\u0002\u0013\u0005!q\u0003\u0005\n\u0005\u0013l\u0014\u0013!C\u0001\u0005/A\u0011Ba3>#\u0003%\tA!\t\t\u0013\t5\u0007A1A\u0005\u0002\t=\u0007\u0002\u0003Bo\u0001\u0001\u0006IA!5\t\u0013\t}\u0007A1A\u0005\u0002\t=\u0007\u0002\u0003Bq\u0001\u0001\u0006IA!5\t\u000f\t\r\b\u0001\"\u0001\u0003f\"9!\u0011\u001f\u0001\u0005\u0002\tM\b\"\u0003B|\u0001\t\u0007I\u0011\u0001Bh\u0011!\u0011I\u0010\u0001Q\u0001\n\tE\u0007\"\u0003B~\u0001\t\u0007I\u0011\u0001Bh\u0011!\u0011i\u0010\u0001Q\u0001\n\tE\u0007b\u0002B\u0000\u0001\u0011%1\u0011\u0001\u0002\u0019\u000bb\u0004(/Z:tS>t\u0017*\u001c9m+RLGn]*vSR,'BA-[\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005mc\u0016\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005us\u0016aA:rY*\u0011q\fY\u0001\u0006gB\f'o\u001b\u0006\u0003C\n\fa!\u00199bG\",'\"A2\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0007CA4i\u001b\u0005q\u0016BA5_\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012\u0001\u001c\t\u0003[\u0002i\u0011\u0001W\u0001\u000bEZ\"D-Z2pI\u0016\u0014X#\u00019\u0011\u0005E|hB\u0001:}\u001d\t\u0019\u0018P\u0004\u0002uo6\tQO\u0003\u0002wI\u00061AH]8pizJ\u0011\u0001_\u0001\u0005U\u00064\u0018-\u0003\u0002{w\u0006!Q\u000f^5m\u0015\u0005A\u0018BA?\u007f\u0003\u0019\u0011\u0015m]37i)\u0011!p_\u0005\u0005\u0003\u0003\t\u0019AA\u0004EK\u000e|G-\u001a:\u000b\u0005ut\u0018a\u000327i\u0011,7m\u001c3fe\u0002\n!B\u0019\u001c5K:\u001cw\u000eZ3s+\t\tY\u0001E\u0002r\u0003\u001bIA!a\u0004\u0002\u0004\t9QI\\2pI\u0016\u0014\u0018a\u000327i\u0015t7m\u001c3fe\u0002\u0012\u0001\u0002V3ti\u000e\u000b7/Z\n\b\r\u0005]\u00111EA\u0015!\u0011\tI\"a\b\u000e\u0005\u0005m!BAA\u000f\u0003\u0015\u00198-\u00197b\u0013\u0011\t\t#a\u0007\u0003\r\u0005s\u0017PU3g!\u0011\tI\"!\n\n\t\u0005\u001d\u00121\u0004\u0002\b!J|G-^2u!\u0011\tY#!\u000e\u000f\t\u00055\u0012\u0011\u0007\b\u0004i\u0006=\u0012BAA\u000f\u0013\u0011\t\u0019$a\u0007\u0002\u000fA\f7m[1hK&!\u0011qGA\u001d\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\u0011\t\u0019$a\u0007\u0002\u0013Ad\u0017-\u001b8uKb$XCAA !\u0011\t\t%!\u0013\u000f\t\u0005\r\u0013Q\t\t\u0004i\u0006m\u0011\u0002BA$\u00037\ta\u0001\u0015:fI\u00164\u0017\u0002BA&\u0003\u001b\u0012aa\u0015;sS:<'\u0002BA$\u00037\t!\u0002\u001d7bS:$X\r\u001f;!\u0003\rYW-_\u0001\u0005W\u0016L\b%\u0001\rcCN,g\u0007N\"ja\",'\u000f^3yi\u0016C\b/Z2uK\u0012\f\u0011DY1tKZ\"4)\u001b9iKJ$X\r\u001f;FqB,7\r^3eA\u0005!Qn\u001c3f\u0003\u0015iw\u000eZ3!\u0003\u001d\u0001\u0018\r\u001a3j]\u001e\f\u0001\u0002]1eI&tw\rI\u0001\tSZDU\r_(qiV\u0011\u0011Q\r\t\u0007\u00033\t9'a\u0010\n\t\u0005%\u00141\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0013%4\b*\u001a=PaR\u0004\u0013AB1bI>\u0003H/A\u0004bC\u0012|\u0005\u000f\u001e\u0011\u0002+\u0015D\b/Z2uK\u0012,%O]8s\u00072\f7o](qi\u00061R\r\u001f9fGR,G-\u0012:s_J\u001cE.Y:t\u001fB$\b%\u0001\bfeJ|'\u000fU1sC6\u001cX*\u00199\u0016\u0005\u0005e\u0004\u0003CA!\u0003w\ny$a\u0010\n\t\u0005u\u0014Q\n\u0002\u0004\u001b\u0006\u0004\u0018aD3se>\u0014\b+\u0019:b[Nl\u0015\r\u001d\u0011\u0015)\u0005\r\u0015qQAE\u0003\u0017\u000bi)a$\u0002\u0012\u0006M\u0015QSAL!\r\t)IB\u0007\u0002\u0001!9\u00111H\rA\u0002\u0005}\u0002bBA)3\u0001\u0007\u0011q\b\u0005\b\u0003+J\u0002\u0019AA \u0011\u001d\tI&\u0007a\u0001\u0003\u007fA\u0011\"!\u0018\u001a!\u0003\u0005\r!a\u0010\t\u0013\u0005\u0005\u0014\u0004%AA\u0002\u0005\u0015\u0004\"CA73A\u0005\t\u0019AA3\u0011%\t\t(\u0007I\u0001\u0002\u0004\t)\u0007C\u0005\u0002ve\u0001\n\u00111\u0001\u0002z\u0005Y\u0011n]%w\t\u00164\u0017N\\3e+\t\ti\n\u0005\u0003\u0002\u001a\u0005}\u0015\u0002BAQ\u00037\u0011qAQ8pY\u0016\fg.\u0001\bqY\u0006Lg\u000e^3yi\nKH/Z:\u0016\u0005\u0005\u001d\u0006CBA\r\u0003S\u000bi+\u0003\u0003\u0002,\u0006m!!B!se\u0006L\b\u0003BA\r\u0003_KA!!-\u0002\u001c\t!!)\u001f;f\u0003=\u0001H.Y5oi\u0016DHOQ=uKN\u0004\u0013\u0001C6fs\nKH/Z:\u0002\u0013-,\u0017PQ=uKN\u0004\u0013\u0001C;uMbjw\u000eZ3\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u0013l!!!1\u000b\t\u0005\r\u0017QY\u0001\u0006if\u0004Xm\u001d\u0006\u0004\u0003\u000ft\u0016AB;og\u00064W-\u0003\u0003\u0002L\u0006\u0005'AC+U\rb\u001aFO]5oO\u0006IQ\u000f\u001e49[>$W\rI\u0001\fkR4\u0007\bU1eI&tw-\u0001\u0007vi\u001aD\u0004+\u00193eS:<\u0007%A\u0007eKR,'/\\5oSN$\u0018nY\u0001\u000fI\u0016$XM]7j]&\u001cH/[2!\u0003\u001dIgOQ=uKN\f\u0001\"\u001b<CsR,7\u000fI\u0001\tC\u0006$')\u001f;fg\u0006I\u0011-\u00193CsR,7\u000fI\u0001\u0005G>\u0004\u0018\u0010\u0006\u000b\u0002\u0004\u0006\r\u0018Q]At\u0003S\fY/!<\u0002p\u0006E\u00181\u001f\u0005\n\u0003wI\u0003\u0013!a\u0001\u0003\u007fA\u0011\"!\u0015*!\u0003\u0005\r!a\u0010\t\u0013\u0005U\u0013\u0006%AA\u0002\u0005}\u0002\"CA-SA\u0005\t\u0019AA \u0011%\ti&\u000bI\u0001\u0002\u0004\ty\u0004C\u0005\u0002b%\u0002\n\u00111\u0001\u0002f!I\u0011QN\u0015\u0011\u0002\u0003\u0007\u0011Q\r\u0005\n\u0003cJ\u0003\u0013!a\u0001\u0003KB\u0011\"!\u001e*!\u0003\u0005\r!!\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011 \u0016\u0005\u0003\u007f\tYp\u000b\u0002\u0002~B!\u0011q B\u0005\u001b\t\u0011\tA\u0003\u0003\u0003\u0004\t\u0015\u0011!C;oG\",7m[3e\u0015\u0011\u00119!a\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\f\t\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\u001a)\"\u0011QMA~\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]\nabY8qs\u0012\"WMZ1vYR$\u0003(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\t\r\"\u0006BA=\u0003w\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0015!\u0011\u0011YC!\r\u000e\u0005\t5\"b\u0001B\u0018w\u0006!A.\u00198h\u0013\u0011\tYE!\f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t]\u0002\u0003BA\r\u0005sIAAa\u000f\u0002\u001c\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\tB$!\u0011\tIBa\u0011\n\t\t\u0015\u00131\u0004\u0002\u0004\u0003:L\b\"\u0003B%k\u0005\u0005\t\u0019\u0001B\u001c\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\n\t\u0007\u0005#\u00129F!\u0011\u000e\u0005\tM#\u0002\u0002B+\u00037\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IFa\u0015\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003;\u0013y\u0006C\u0005\u0003J]\n\t\u00111\u0001\u0003B\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011IC!\u001a\t\u0013\t%\u0003(!AA\u0002\t]\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t]\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t%\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002\u001e\nM\u0004\"\u0003B%w\u0005\u0005\t\u0019\u0001B!\u0003!!Vm\u001d;DCN,\u0007cAAC{M)QHa\u001f\u0003\bBA\"Q\u0010BB\u0003\u007f\ty$a\u0010\u0002@\u0005}\u0012QMA3\u0003K\nI(a!\u000e\u0005\t}$\u0002\u0002BA\u00037\tqA];oi&lW-\u0003\u0003\u0003\u0006\n}$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8osA!!\u0011\u0012BH\u001b\t\u0011YIC\u0002\u0003\u000en\f!![8\n\t\u0005]\"1\u0012\u000b\u0003\u0005o\nQ!\u00199qYf$B#a!\u0003\u0018\ne%1\u0014BO\u0005?\u0013\tKa)\u0003&\n\u001d\u0006bBA\u001e\u0001\u0002\u0007\u0011q\b\u0005\b\u0003#\u0002\u0005\u0019AA \u0011\u001d\t)\u0006\u0011a\u0001\u0003\u007fAq!!\u0017A\u0001\u0004\ty\u0004C\u0005\u0002^\u0001\u0003\n\u00111\u0001\u0002@!I\u0011\u0011\r!\u0011\u0002\u0003\u0007\u0011Q\r\u0005\n\u0003[\u0002\u0005\u0013!a\u0001\u0003KB\u0011\"!\u001dA!\u0003\u0005\r!!\u001a\t\u0013\u0005U\u0004\t%AA\u0002\u0005e\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIY\nq\"\u00199qYf$C-\u001a4bk2$HeN\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t]&q\u0018\t\u0007\u00033\t9G!/\u0011-\u0005e!1XA \u0003\u007f\ty$a\u0010\u0002@\u0005\u0015\u0014QMA3\u0003sJAA!0\u0002\u001c\t1A+\u001e9mKfB\u0011B!1G\u0003\u0003\u0005\r!a!\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe\n\u0011\u0002^3ti\u000e\u000b7/Z:\u0016\u0005\tE\u0007C\u0002Bj\u00053\f\u0019)\u0004\u0002\u0003V*!!q\u001bB*\u0003%IW.\\;uC\ndW-\u0003\u0003\u0003\\\nU'aA*fc\u0006QA/Z:u\u0007\u0006\u001cXm\u001d\u0011\u0002\u001d%4\u0018)\u00193UKN$8)Y:fg\u0006y\u0011N^!bIR+7\u000f^\"bg\u0016\u001c\b%A\u0006eK\u000e|e\u000e\\=DCN,G\u0003\u0002Bt\u0005[\u0004B!!\u0007\u0003j&!!1^A\u000e\u0005\u0011)f.\u001b;\t\u000f\t=\b\u000b1\u0001\u0002\u0004\u0006\tA/\u0001\u0006f]\u000e$UmY\"bg\u0016$BAa:\u0003v\"9!q^)A\u0002\u0005\r\u0015!F;ogV\u0004\bo\u001c:uK\u0012,%O]8s\u0007\u0006\u001cXm]\u0001\u0017k:\u001cX\u000f\u001d9peR,G-\u0012:s_J\u001c\u0015m]3tA\u0005!2m\u001c:skB$X\rZ\"ja\",'\u000f^3yiN\fQcY8seV\u0004H/\u001a3DSBDWM\u001d;fqR\u001c\b%\u0001\ndQ\u0016\u001c7.\u0012=qK\u000e$X\rZ#se>\u0014HC\u0002Bt\u0007\u0007\u0019)\u0001C\u0004\u0003pZ\u0003\r!a!\t\u000f\r\u001da\u000b1\u0001\u0004\n\u0005\ta\r\u0005\u0005\u0002\u001a\r-\u00111\u0011Bt\u0013\u0011\u0019i!a\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004")
public class ExpressionImplUtilsSuite
extends SparkFunSuite {
    private volatile ExpressionImplUtilsSuite$TestCase$ TestCase$module;
    private final Base64.Decoder b64decoder = Base64.getDecoder();
    private final Base64.Encoder b64encoder = Base64.getEncoder();
    private final Seq<TestCase> testCases;
    private final Seq<TestCase> ivAadTestCases;
    private final Seq<TestCase> unsupportedErrorCases;
    private final Seq<TestCase> corruptedCiphertexts;

    public ExpressionImplUtilsSuite$TestCase$ TestCase() {
        if (this.TestCase$module == null) {
            this.TestCase$lzycompute$1();
        }
        return this.TestCase$module;
    }

    private Base64.Decoder b64decoder() {
        return this.b64decoder;
    }

    private Base64.Encoder b64encoder() {
        return this.b64encoder;
    }

    public Seq<TestCase> testCases() {
        return this.testCases;
    }

    public Seq<TestCase> ivAadTestCases() {
        return this.ivAadTestCases;
    }

    public void decOnlyCase(TestCase t) {
        String decryptedString;
        byte[] expectedBytes = this.b64decoder().decode(t.base64CiphertextExpected());
        byte[] decryptedBytes = ExpressionImplUtils.aesDecrypt((byte[])expectedBytes, (byte[])t.keyBytes(), (UTF8String)t.utf8mode(), (UTF8String)t.utf8Padding(), (byte[])t.aadBytes());
        String $org_scalatest_assert_macro_left = decryptedString = new String(decryptedBytes);
        String $org_scalatest_assert_macro_right = t.plaintext();
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
    }

    public void encDecCase(TestCase t) {
        String decryptedString;
        byte[] ciphertextBytes = ExpressionImplUtils.aesEncrypt((byte[])t.plaintextBytes(), (byte[])t.keyBytes(), (UTF8String)t.utf8mode(), (UTF8String)t.utf8Padding(), (byte[])t.ivBytes(), (byte[])t.aadBytes());
        String ciphertextBase64 = this.b64encoder().encodeToString(ciphertextBytes);
        byte[] decryptedBytes = ExpressionImplUtils.aesDecrypt((byte[])ciphertextBytes, (byte[])t.keyBytes(), (UTF8String)t.utf8mode(), (UTF8String)t.utf8Padding(), (byte[])t.aadBytes());
        String $org_scalatest_assert_macro_left = decryptedString = new String(decryptedBytes);
        String $org_scalatest_assert_macro_right = t.plaintext();
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        if (t.deterministic()) {
            String $org_scalatest_assert_macro_left2 = t.base64CiphertextExpected();
            String $org_scalatest_assert_macro_right2 = ciphertextBase64;
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
            return;
        }
    }

    public Seq<TestCase> unsupportedErrorCases() {
        return this.unsupportedErrorCases;
    }

    public Seq<TestCase> corruptedCiphertexts() {
        return this.corruptedCiphertexts;
    }

    private void checkExpectedError(TestCase t, Function1<TestCase, BoxedUnit> f) {
        SparkRuntimeException x$1 = (SparkRuntimeException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)t), ClassTag$.MODULE$.apply(SparkRuntimeException.class), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        String x$2 = (String)t.expectedErrorClassOpt().get();
        Map<String, String> x$3 = t.errorParamsMap();
        boolean x$4 = true;
        Option x$5 = this.checkError$default$3();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$5, x$3, true, x$6);
    }

    private final void TestCase$lzycompute$1() {
        ExpressionImplUtilsSuite expressionImplUtilsSuite = this;
        synchronized (expressionImplUtilsSuite) {
            if (this.TestCase$module == null) {
                this.TestCase$module = new ExpressionImplUtilsSuite$TestCase$(this);
            }
        }
    }

    private final void validateUTF8$1(UTF8String str, UTF8String expected, boolean except) {
        if (except) {
            SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)this.intercept((Function0 & Serializable)() -> ExpressionImplUtils.validateUTF8String((UTF8String)str), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            String x$2 = "INVALID_UTF8_STRING";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"str"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(str.getBytes()), (Function1 & Serializable)object -> StringOps$.MODULE$.format$extension("\\x%02X", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)object))})), ClassTag$.MODULE$.apply(String.class))).mkString())}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "INVALID_UTF8_STRING", x$4, x$3, x$5, x$6);
            return;
        }
        UTF8String $org_scalatest_assert_macro_left = ExpressionImplUtils.validateUTF8String((UTF8String)str);
        UTF8String $org_scalatest_assert_macro_right = expected;
        UTF8String uTF8String = $org_scalatest_assert_macro_left;
        UTF8String uTF8String2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uTF8String != null ? !uTF8String.equals(uTF8String2) : uTF8String2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
    }

    private static final void tryValidateUTF8$1(UTF8String str, UTF8String expected) {
        UTF8String $org_scalatest_assert_macro_left = ExpressionImplUtils.tryValidateUTF8String((UTF8String)str);
        UTF8String $org_scalatest_assert_macro_right = expected;
        UTF8String uTF8String = $org_scalatest_assert_macro_left;
        UTF8String uTF8String2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uTF8String != null ? !uTF8String.equals(uTF8String2) : uTF8String2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
    }

    public ExpressionImplUtilsSuite() {
        TestCase[] testCaseArray = new TestCase[11];
        testCaseArray[0] = new TestCase(this, "Spark", "abcdefghijklmnop", "4Hv0UKCx6nfUeAoPZo1z+w==", "ECB", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[1] = new TestCase(this, "Spark", "abcdefghijklmnop12345678", "NeTYNgA+PCQBN50DA//O2w==", "ECB", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[2] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "9J3iZbIxnmaG+OIA9Amd+A==", "ECB", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        String x$1 = "Spark";
        String x$2 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$3 = "9J3iZbIxnmaG+OIA9Amd+A==";
        String x$4 = "ECB";
        Some x$5 = new Some((Object)"");
        Some x$6 = new Some((Object)"");
        String x$7 = this.TestCase().apply$default$5();
        Option<String> x$8 = this.TestCase().apply$default$8();
        Map<String, String> x$9 = this.TestCase().apply$default$9();
        testCaseArray[3] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "9J3iZbIxnmaG+OIA9Amd+A==", "ECB", x$7, (Option<String>)x$5, (Option<String>)x$6, x$8, x$9);
        testCaseArray[4] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93KvhY=", "CBC", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        String x$10 = "Spark";
        String x$11 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$12 = "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93KvhY=";
        String x$13 = "CBC";
        Some x$14 = new Some((Object)"");
        Some x$15 = new Some((Object)"");
        String x$16 = this.TestCase().apply$default$5();
        Option<String> x$17 = this.TestCase().apply$default$8();
        Map<String, String> x$18 = this.TestCase().apply$default$9();
        testCaseArray[5] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93KvhY=", "CBC", x$16, (Option<String>)x$14, (Option<String>)x$15, x$17, x$18);
        testCaseArray[6] = new TestCase(this, "Apache Spark", "1234567890abcdef", "2NYmDCjgXTbbxGA3/SnJEfFC/JQ7olk2VQWReIAAFKo=", "CBC", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[7] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "y5la3muiuxN2suj6VsYXB+0XUFjtrUD0/zv5eDafsA3U", "GCM", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[8] = new TestCase(this, "This message is longer than a single AES block and should work fine.", "abcdefghijklmnop12345678ABCDEFGH", "agUfTbLT8KPsqbAmQn/YdpohvxqX5bBsfFjtxE5UwqvO6EWSUVyjeDA6r30XyS0ARebsBgXKSExaAVZ40NMgDLQa6/o9pieYwLT5YXI7flU=", "ECB", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[9] = new TestCase(this, "This message is longer than a single AES block and should work fine.", "abcdefghijklmnop12345678ABCDEFGH", "cxUKNdlZa/6hT6gdhp46OThPcdNONdBwJj/Ctl6z4gWVKfcA6DElJg84LbkueIifjNOTloduKgidk9G9a4BDsn0NjlGLUeG8GH1moPWb/+knBC7oT/OOA06W6rJXudDo", "CBC", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[10] = new TestCase(this, "This message is longer than a single AES block and should work fine.", "abcdefghijklmnop12345678ABCDEFGH", "73B0tHM3F7bvmG7yIZB9vMKnzHyuCYjD9PzAI7NJ+kDBWtaFO22n2cKlkNcCzr45a4Uol+sNtQwQAV7iRhBdt6YmXoviemyXJWOZ89G279SgxabaomEIyN/HZwenxeN4", "GCM", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        this.testCases = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])testCaseArray));
        this.test("AesDecrypt Only", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Seq)this.testCases().map((Function1 & Serializable)t -> {
            this.decOnlyCase(t);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("AesEncrypt and AesDecrypt", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Seq)this.testCases().map((Function1 & Serializable)t -> {
            this.encDecCase(t);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        String x$19 = "Spark";
        String x$20 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$21 = "AAAAAAAAAAAAAAAAAAAAAPSd4mWyMZ5mhvjiAPQJnfg=";
        String x$22 = "CBC";
        Some x$23 = new Some((Object)"00000000000000000000000000000000");
        String x$24 = this.TestCase().apply$default$5();
        Option<String> x$25 = this.TestCase().apply$default$7();
        Option<String> x$26 = this.TestCase().apply$default$8();
        Map<String, String> x$27 = this.TestCase().apply$default$9();
        String x$28 = "Spark";
        String x$29 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$30 = "AAAAAAAAAAAAAAAAQiYi+sRNYDAOTjdSEcYBFsAWPL1f";
        String x$31 = "GCM";
        Some x$32 = new Some((Object)"000000000000000000000000");
        String x$33 = this.TestCase().apply$default$5();
        Option<String> x$34 = this.TestCase().apply$default$7();
        Option<String> x$35 = this.TestCase().apply$default$8();
        Map<String, String> x$36 = this.TestCase().apply$default$9();
        String x$37 = "Spark";
        String x$38 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$39 = "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4";
        String x$40 = "GCM";
        Some x$41 = new Some((Object)"000000000000000000000000");
        Some x$42 = new Some((Object)"This is an AAD mixed into the input");
        String x$43 = this.TestCase().apply$default$5();
        Option<String> x$44 = this.TestCase().apply$default$8();
        Map<String, String> x$45 = this.TestCase().apply$default$9();
        String x$46 = "Spark";
        String x$47 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$48 = "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4";
        String x$49 = "GCM";
        Some x$50 = new Some((Object)"This is an AAD mixed into the input");
        String x$51 = this.TestCase().apply$default$5();
        Option<String> x$52 = this.TestCase().apply$default$6();
        Option<String> x$53 = this.TestCase().apply$default$8();
        Map<String, String> x$54 = this.TestCase().apply$default$9();
        this.ivAadTestCases = new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAAAAAAPSd4mWyMZ5mhvjiAPQJnfg=", "CBC", x$24, (Option<String>)x$23, x$25, x$26, x$27), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAQiYi+sRNYDAOTjdSEcYBFsAWPL1f", "GCM", x$33, (Option<String>)x$32, x$34, x$35, x$36), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4", "GCM", x$43, (Option<String>)x$41, (Option<String>)x$42, x$44, x$45), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4", "GCM", x$51, x$52, (Option<String>)x$50, x$53, x$54), (List)Nil$.MODULE$))));
        this.test("AesDecrypt only with IVs or AADs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Seq)this.ivAadTestCases().map((Function1 & Serializable)t -> {
            this.decOnlyCase(t);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("AesEncrypt and AesDecrypt with IVs or AADs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Seq)this.ivAadTestCases().map((Function1 & Serializable)t -> {
            this.encDecCase(t);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        String x$55 = "Spark";
        String x$56 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$57 = "unused";
        String x$58 = "ECB";
        Some x$59 = new Some((Object)"0000000000000000");
        Some x$60 = new Some((Object)"UNSUPPORTED_FEATURE.AES_MODE_IV");
        Map x$61 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"ECB"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`")}));
        String x$62 = this.TestCase().apply$default$5();
        Option<String> x$63 = this.TestCase().apply$default$7();
        String x$64 = "Spark";
        String x$65 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$66 = "unused";
        String x$67 = "ECB";
        Some x$68 = new Some((Object)"ECB does not support AAD mode");
        Some x$69 = new Some((Object)"UNSUPPORTED_FEATURE.AES_MODE_AAD");
        Map x$70 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"ECB"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`")}));
        String x$71 = this.TestCase().apply$default$5();
        Option<String> x$72 = this.TestCase().apply$default$6();
        String x$73 = "Spark";
        String x$74 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$75 = "unused";
        String x$76 = "CBC";
        Some x$77 = new Some((Object)"0000000000");
        Some x$78 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_IV_LENGTH");
        Map x$79 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"CBC"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`iv`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualLength"), (Object)"5")}));
        String x$80 = this.TestCase().apply$default$5();
        Option<String> x$81 = this.TestCase().apply$default$7();
        String x$82 = "Spark";
        String x$83 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$84 = "unused";
        String x$85 = "GCM";
        Some x$86 = new Some((Object)"0000000000");
        Some x$87 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_IV_LENGTH");
        Map x$88 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"GCM"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`iv`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualLength"), (Object)"5")}));
        String x$89 = this.TestCase().apply$default$5();
        Option<String> x$90 = this.TestCase().apply$default$7();
        String x$91 = "Spark";
        String x$92 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$93 = "unused";
        String x$94 = "GCM";
        String x$95 = "PKCS";
        Some x$96 = new Some((Object)"UNSUPPORTED_FEATURE.AES_MODE");
        Map x$97 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"GCM"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"padding"), (Object)"PKCS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`")}));
        Option<String> x$98 = this.TestCase().apply$default$6();
        Option<String> x$99 = this.TestCase().apply$default$7();
        String x$100 = "Spark";
        String x$101 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$102 = "unused";
        String x$103 = "CBC";
        Some x$104 = new Some((Object)"CBC doesn't support AADs");
        Some x$105 = new Some((Object)"UNSUPPORTED_FEATURE.AES_MODE_AAD");
        Map x$106 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"CBC"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`")}));
        String x$107 = this.TestCase().apply$default$5();
        Option<String> x$108 = this.TestCase().apply$default$6();
        this.unsupportedErrorCases = new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "ECB", x$62, (Option<String>)x$59, x$63, (Option<String>)x$60, (Map<String, String>)x$61), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "ECB", x$71, x$72, (Option<String>)x$68, (Option<String>)x$69, (Map<String, String>)x$70), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "CBC", x$80, (Option<String>)x$77, x$81, (Option<String>)x$78, (Map<String, String>)x$79), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "GCM", x$89, (Option<String>)x$86, x$90, (Option<String>)x$87, (Map<String, String>)x$88), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "GCM", "PKCS", x$98, x$99, (Option<String>)x$96, (Map<String, String>)x$97), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "CBC", x$107, x$108, (Option<String>)x$104, (Option<String>)x$105, (Map<String, String>)x$106), (List)Nil$.MODULE$))))));
        this.test("AesEncrypt unsupported errors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.unsupportedErrorCases().foreach((Function1 & Serializable)t -> {
            this.checkExpectedError(t, (Function1<TestCase, BoxedUnit>)(Function1 & Serializable)t -> {
                $this.encDecCase(t);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        String x$109 = "Spark";
        String x$110 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$111 = "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93=";
        String x$112 = "CBC";
        Some x$113 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_CRYPTO_ERROR");
        Map x$114 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`expr`, `key`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"detailMessage"), (Object)"Input length .*")}));
        String x$115 = this.TestCase().apply$default$5();
        Option<String> x$116 = this.TestCase().apply$default$6();
        Option<String> x$117 = this.TestCase().apply$default$7();
        String x$118 = "Spark";
        String x$119 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$120 = "y5la3muiuxN2suj6VsYXB+1XUFjtrUD0/zv5eDafsA3U";
        String x$121 = "GCM";
        Some x$122 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_CRYPTO_ERROR");
        Map x$123 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`expr`, `key`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"detailMessage"), (Object)"Tag mismatch[!]?")}));
        String x$124 = this.TestCase().apply$default$5();
        Option<String> x$125 = this.TestCase().apply$default$6();
        Option<String> x$126 = this.TestCase().apply$default$7();
        String x$127 = "Spark";
        String x$128 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$129 = "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4";
        String x$130 = "GCM";
        Some x$131 = new Some((Object)"The ciphertext is valid, but the AAD is wrong");
        Some x$132 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_CRYPTO_ERROR");
        Map x$133 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`expr`, `key`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"detailMessage"), (Object)"Tag mismatch[!]?")}));
        String x$134 = this.TestCase().apply$default$5();
        Option<String> x$135 = this.TestCase().apply$default$6();
        this.corruptedCiphertexts = new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93=", "CBC", x$115, x$116, x$117, (Option<String>)x$113, (Map<String, String>)x$114), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "y5la3muiuxN2suj6VsYXB+1XUFjtrUD0/zv5eDafsA3U", "GCM", x$124, x$125, x$126, (Option<String>)x$122, (Map<String, String>)x$123), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4", "GCM", x$134, x$135, (Option<String>)x$131, (Option<String>)x$132, (Map<String, String>)x$133), (List)Nil$.MODULE$)));
        this.test("AesEncrypt Expected Errors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.corruptedCiphertexts().foreach((Function1 & Serializable)t -> {
            this.checkExpectedError(t, (Function1<TestCase, BoxedUnit>)(Function1 & Serializable)t -> {
                $this.decOnlyCase(t);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        this.test("Validate UTF8 string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.validateUTF8$1(UTF8String.EMPTY_UTF8, UTF8String.fromString((String)""), false);
            this.validateUTF8$1(UTF8String.fromString((String)""), UTF8String.fromString((String)""), false);
            this.validateUTF8$1(UTF8String.fromString((String)"aa"), UTF8String.fromString((String)"aa"), false);
            this.validateUTF8$1(UTF8String.fromString((String)"a"), UTF8String.fromString((String)"a"), false);
            this.validateUTF8$1(UTF8String.fromString((String)""), UTF8String.fromString((String)""), false);
            this.validateUTF8$1(UTF8String.fromString((String)"abc"), UTF8String.fromString((String)"abc"), false);
            this.validateUTF8$1(UTF8String.fromString((String)"hello"), UTF8String.fromString((String)"hello"), false);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))), UTF8String.fromString((String)""), false);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{65}), UTF8String.fromString((String)"A"), false);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{97}), UTF8String.fromString((String)"a"), false);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{(byte)128}), UTF8String.fromString((String)"\ufffd"), true);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{(byte)255}), UTF8String.fromString((String)"\ufffd"), true);
        }, new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        this.test("TryValidate UTF8 string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)""), UTF8String.fromString((String)""));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)"aa"), UTF8String.fromString((String)"aa"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)"a"), UTF8String.fromString((String)"a"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.EMPTY_UTF8, UTF8String.fromString((String)""));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)""), UTF8String.fromString((String)""));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)"abc"), UTF8String.fromString((String)"abc"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)"hello"), UTF8String.fromString((String)"hello"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))), UTF8String.fromString((String)""));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{65}), UTF8String.fromString((String)"A"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{97}), UTF8String.fromString((String)"a"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{(byte)128}), null);
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{(byte)255}), null);
        }, new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
    }

    public class TestCase
    implements Product,
    Serializable {
        private final String plaintext;
        private final String key;
        private final String base64CiphertextExpected;
        private final String mode;
        private final String padding;
        private final Option<String> ivHexOpt;
        private final Option<String> aadOpt;
        private final Option<String> expectedErrorClassOpt;
        private final Map<String, String> errorParamsMap;
        private final byte[] plaintextBytes;
        private final byte[] keyBytes;
        private final UTF8String utf8mode;
        private final UTF8String utf8Padding;
        private final boolean deterministic;
        private final byte[] ivBytes;
        private final byte[] aadBytes;
        public final /* synthetic */ ExpressionImplUtilsSuite $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String plaintext() {
            return this.plaintext;
        }

        public String key() {
            return this.key;
        }

        public String base64CiphertextExpected() {
            return this.base64CiphertextExpected;
        }

        public String mode() {
            return this.mode;
        }

        public String padding() {
            return this.padding;
        }

        public Option<String> ivHexOpt() {
            return this.ivHexOpt;
        }

        public Option<String> aadOpt() {
            return this.aadOpt;
        }

        public Option<String> expectedErrorClassOpt() {
            return this.expectedErrorClassOpt;
        }

        public Map<String, String> errorParamsMap() {
            return this.errorParamsMap;
        }

        public boolean isIvDefined() {
            return this.ivHexOpt().isDefined() && this.ivHexOpt().get() != null && ((String)this.ivHexOpt().get()).length() > 0;
        }

        public byte[] plaintextBytes() {
            return this.plaintextBytes;
        }

        public byte[] keyBytes() {
            return this.keyBytes;
        }

        public UTF8String utf8mode() {
            return this.utf8mode;
        }

        public UTF8String utf8Padding() {
            return this.utf8Padding;
        }

        public boolean deterministic() {
            return this.deterministic;
        }

        public byte[] ivBytes() {
            return this.ivBytes;
        }

        public byte[] aadBytes() {
            return this.aadBytes;
        }

        public TestCase copy(String plaintext, String key, String base64CiphertextExpected, String mode, String padding, Option<String> ivHexOpt, Option<String> aadOpt, Option<String> expectedErrorClassOpt, Map<String, String> errorParamsMap) {
            return new TestCase(this.org$apache$spark$sql$catalyst$expressions$ExpressionImplUtilsSuite$TestCase$$$outer(), plaintext, key, base64CiphertextExpected, mode, padding, ivHexOpt, aadOpt, expectedErrorClassOpt, errorParamsMap);
        }

        public String copy$default$1() {
            return this.plaintext();
        }

        public String copy$default$2() {
            return this.key();
        }

        public String copy$default$3() {
            return this.base64CiphertextExpected();
        }

        public String copy$default$4() {
            return this.mode();
        }

        public String copy$default$5() {
            return this.padding();
        }

        public Option<String> copy$default$6() {
            return this.ivHexOpt();
        }

        public Option<String> copy$default$7() {
            return this.aadOpt();
        }

        public Option<String> copy$default$8() {
            return this.expectedErrorClassOpt();
        }

        public Map<String, String> copy$default$9() {
            return this.errorParamsMap();
        }

        public String productPrefix() {
            return "TestCase";
        }

        public int productArity() {
            return 9;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.plaintext();
                }
                case 1: {
                    return this.key();
                }
                case 2: {
                    return this.base64CiphertextExpected();
                }
                case 3: {
                    return this.mode();
                }
                case 4: {
                    return this.padding();
                }
                case 5: {
                    return this.ivHexOpt();
                }
                case 6: {
                    return this.aadOpt();
                }
                case 7: {
                    return this.expectedErrorClassOpt();
                }
                case 8: {
                    return this.errorParamsMap();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestCase;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "plaintext";
                }
                case 1: {
                    return "key";
                }
                case 2: {
                    return "base64CiphertextExpected";
                }
                case 3: {
                    return "mode";
                }
                case 4: {
                    return "padding";
                }
                case 5: {
                    return "ivHexOpt";
                }
                case 6: {
                    return "aadOpt";
                }
                case 7: {
                    return "expectedErrorClassOpt";
                }
                case 8: {
                    return "errorParamsMap";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestCase)) return false;
            if (((TestCase)object).org$apache$spark$sql$catalyst$expressions$ExpressionImplUtilsSuite$TestCase$$$outer() != this.org$apache$spark$sql$catalyst$expressions$ExpressionImplUtilsSuite$TestCase$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestCase testCase = (TestCase)x$1;
            String string = this.plaintext();
            String string2 = testCase.plaintext();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.key();
            String string4 = testCase.key();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.base64CiphertextExpected();
            String string6 = testCase.base64CiphertextExpected();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.mode();
            String string8 = testCase.mode();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.padding();
            String string10 = testCase.padding();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            Option<String> option = this.ivHexOpt();
            Option<String> option2 = testCase.ivHexOpt();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.aadOpt();
            Option<String> option4 = testCase.aadOpt();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<String> option5 = this.expectedErrorClassOpt();
            Option<String> option6 = testCase.expectedErrorClassOpt();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Map<String, String> map = this.errorParamsMap();
            Map<String, String> map2 = testCase.errorParamsMap();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!testCase.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ExpressionImplUtilsSuite org$apache$spark$sql$catalyst$expressions$ExpressionImplUtilsSuite$TestCase$$$outer() {
            return this.$outer;
        }

        public TestCase(ExpressionImplUtilsSuite $outer, String plaintext, String key, String base64CiphertextExpected, String mode, String padding, Option<String> ivHexOpt, Option<String> aadOpt, Option<String> expectedErrorClassOpt, Map<String, String> errorParamsMap) {
            this.plaintext = plaintext;
            this.key = key;
            this.base64CiphertextExpected = base64CiphertextExpected;
            this.mode = mode;
            this.padding = padding;
            this.ivHexOpt = ivHexOpt;
            this.aadOpt = aadOpt;
            this.expectedErrorClassOpt = expectedErrorClassOpt;
            this.errorParamsMap = errorParamsMap;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.plaintextBytes = plaintext.getBytes("UTF-8");
            this.keyBytes = key.getBytes("UTF-8");
            this.utf8mode = UTF8String.fromString((String)mode);
            this.utf8Padding = UTF8String.fromString((String)padding);
            this.deterministic = mode.equalsIgnoreCase("ECB") || this.isIvDefined();
            this.ivBytes = (byte[])ivHexOpt.map((Function1 & Serializable)ivHex -> Hex$.MODULE$.unhex(ivHex.getBytes("UTF-8"))).getOrElse((Function0 & Serializable)() -> null);
            this.aadBytes = (byte[])aadOpt.map((Function1 & Serializable)aad -> aad.getBytes("UTF-8")).getOrElse((Function0 & Serializable)() -> null);
        }
    }
}

