/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LiteralGenerator$ {
    public static final LiteralGenerator$ MODULE$ = new LiteralGenerator$();
    private static Gen<Literal> byteLiteralGen;
    private static Gen<Literal> shortLiteralGen;
    private static Gen<Literal> integerLiteralGen;
    private static Gen<Literal> longLiteralGen;
    private static Gen<Literal> floatLiteralGen;
    private static Gen<Literal> doubleLiteralGen;
    private static Gen<Literal> stringLiteralGen;
    private static Gen<Literal> binaryLiteralGen;
    private static Gen<Literal> booleanLiteralGen;
    private static Gen<Literal> dateLiteralGen;
    private static Gen<Literal> timestampLiteralGen;
    private static Gen<Literal> timestampNTZLiteralGen;
    private static Gen<Literal> monthIntervalLiterGen;
    private static Gen<Literal> calendarIntervalLiterGen;
    private static Gen<Literal> limitedIntegerLiteralGen;
    private static Gen<Literal> dayTimeIntervalLiteralGen;
    private static Gen<Literal> yearMonthIntervalLiteralGen;
    private static final int maxIntervalInMonths;
    private static volatile int bitmap$0;

    static {
        maxIntervalInMonths = 120000;
    }

    private Gen<Literal> byteLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 1) == 0) {
                byteLiteralGen = Arbitrary$.MODULE$.arbByte().arbitrary().map((Function1 & Serializable)b -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)b)), (DataType)ByteType$.MODULE$));
                bitmap$0 |= 1;
            }
        }
        return byteLiteralGen;
    }

    public Gen<Literal> byteLiteralGen() {
        if ((bitmap$0 & 1) == 0) {
            return this.byteLiteralGen$lzycompute();
        }
        return byteLiteralGen;
    }

    private Gen<Literal> shortLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 2) == 0) {
                shortLiteralGen = Arbitrary$.MODULE$.arbShort().arbitrary().map((Function1 & Serializable)s -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)s)), (DataType)ShortType$.MODULE$));
                bitmap$0 |= 2;
            }
        }
        return shortLiteralGen;
    }

    public Gen<Literal> shortLiteralGen() {
        if ((bitmap$0 & 2) == 0) {
            return this.shortLiteralGen$lzycompute();
        }
        return shortLiteralGen;
    }

    private Gen<Literal> integerLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 4) == 0) {
                integerLiteralGen = Arbitrary$.MODULE$.arbInt().arbitrary().map((Function1 & Serializable)i -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), (DataType)IntegerType$.MODULE$));
                bitmap$0 |= 4;
            }
        }
        return integerLiteralGen;
    }

    public Gen<Literal> integerLiteralGen() {
        if ((bitmap$0 & 4) == 0) {
            return this.integerLiteralGen$lzycompute();
        }
        return integerLiteralGen;
    }

    private Gen<Literal> longLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 8) == 0) {
                longLiteralGen = Arbitrary$.MODULE$.arbLong().arbitrary().map((Function1 & Serializable)l -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)l)), (DataType)LongType$.MODULE$));
                bitmap$0 |= 8;
            }
        }
        return longLiteralGen;
    }

    public Gen<Literal> longLiteralGen() {
        if ((bitmap$0 & 8) == 0) {
            return this.longLiteralGen$lzycompute();
        }
        return longLiteralGen;
    }

    private Gen<Literal> floatLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x10) == 0) {
                floatLiteralGen = Gen$.MODULE$.oneOf(Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToFloat((float)Float.NaN), (Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY), (Seq)ScalaRunTime$.MODULE$.wrapFloatArray(new float[]{Float.NEGATIVE_INFINITY, Float.MIN_VALUE, Float.MAX_VALUE, -3.4028235E38f, 0.0f, -0.0f, 1.0f, -1.0f})), Arbitrary$.MODULE$.arbFloat().arbitrary(), (Seq)Nil$.MODULE$).map((Function1 & Serializable)f -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)f)), (DataType)FloatType$.MODULE$));
                bitmap$0 |= 0x10;
            }
        }
        return floatLiteralGen;
    }

    public Gen<Literal> floatLiteralGen() {
        if ((bitmap$0 & 0x10) == 0) {
            return this.floatLiteralGen$lzycompute();
        }
        return floatLiteralGen;
    }

    private Gen<Literal> doubleLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x20) == 0) {
                doubleLiteralGen = Gen$.MODULE$.oneOf(Gen$.MODULE$.oneOf((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{Double.NEGATIVE_INFINITY, Double.MIN_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, 0.0, -0.0, 1.0, -1.0})), Arbitrary$.MODULE$.arbDouble().arbitrary(), (Seq)Nil$.MODULE$).map((Function1 & Serializable)f -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)f)), (DataType)DoubleType$.MODULE$));
                bitmap$0 |= 0x20;
            }
        }
        return doubleLiteralGen;
    }

    public Gen<Literal> doubleLiteralGen() {
        if ((bitmap$0 & 0x20) == 0) {
            return this.doubleLiteralGen$lzycompute();
        }
        return doubleLiteralGen;
    }

    public Gen<Literal> decimalLiteralGen(int precision, int scale) {
        int $org_scalatest_assert_macro_left = scale;
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        int $org_scalatest_assert_macro_left2 = precision;
        int $org_scalatest_assert_macro_right2 = scale;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 >= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralGenerator.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        return Arbitrary$.MODULE$.arbBigInt().arbitrary().map((Function1 & Serializable)s -> {
            String a = s.$percent(package$.MODULE$.BigInt().apply(10).pow(precision - scale)).toString();
            String b = s.$percent(package$.MODULE$.BigInt().apply(10).pow(scale)).abs().toString();
            return Literal$.MODULE$.create((Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(a + "." + b), precision, scale), (DataType)new DecimalType(precision, scale));
        });
    }

    private Gen<Literal> stringLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x40) == 0) {
                stringLiteralGen = Arbitrary$.MODULE$.arbString().arbitrary().map((Function1 & Serializable)s -> Literal$.MODULE$.create(s, (DataType)StringType$.MODULE$));
                bitmap$0 |= 0x40;
            }
        }
        return stringLiteralGen;
    }

    public Gen<Literal> stringLiteralGen() {
        if ((bitmap$0 & 0x40) == 0) {
            return this.stringLiteralGen$lzycompute();
        }
        return stringLiteralGen;
    }

    private Gen<Literal> binaryLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x80) == 0) {
                binaryLiteralGen = Gen$.MODULE$.listOf((Function0 & Serializable)() -> Arbitrary$.MODULE$.arbByte().arbitrary()).map((Function1 & Serializable)ab -> Literal$.MODULE$.create(ab.toArray((ClassTag)ClassTag$.MODULE$.Byte()), (DataType)BinaryType$.MODULE$));
                bitmap$0 |= 0x80;
            }
        }
        return binaryLiteralGen;
    }

    public Gen<Literal> binaryLiteralGen() {
        if ((bitmap$0 & 0x80) == 0) {
            return this.binaryLiteralGen$lzycompute();
        }
        return binaryLiteralGen;
    }

    private Gen<Literal> booleanLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x100) == 0) {
                booleanLiteralGen = Arbitrary$.MODULE$.arbBool().arbitrary().map((Function1 & Serializable)b -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)b)), (DataType)BooleanType$.MODULE$));
                bitmap$0 |= 0x100;
            }
        }
        return booleanLiteralGen;
    }

    public Gen<Literal> booleanLiteralGen() {
        if ((bitmap$0 & 0x100) == 0) {
            return this.booleanLiteralGen$lzycompute();
        }
        return booleanLiteralGen;
    }

    private Gen<Literal> dateLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x200) == 0) {
                long minDay = LocalDate.of(1, 1, 1).toEpochDay();
                long maxDay = LocalDate.of(9999, 12, 31).toEpochDay();
                dateLiteralGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToLong((long)minDay), (Object)BoxesRunTime.boxToLong((long)maxDay), Gen.Choose$.MODULE$.chooseLong()).map((Function1 & Serializable)day -> Literal$.MODULE$.create((Object)new Date(BoxesRunTime.unboxToLong((Object)day) * 86400000L), (DataType)DateType$.MODULE$));
                bitmap$0 |= 0x200;
            }
        }
        return dateLiteralGen;
    }

    public Gen<Literal> dateLiteralGen() {
        if ((bitmap$0 & 0x200) == 0) {
            return this.dateLiteralGen$lzycompute();
        }
        return dateLiteralGen;
    }

    private Gen<Object> millisGen() {
        long minMillis = Instant.parse("0001-01-01T00:00:00.000000Z").toEpochMilli();
        long maxMillis = Instant.parse("9999-12-31T23:59:59.999999Z").toEpochMilli();
        return Gen$.MODULE$.choose((Object)BoxesRunTime.boxToLong((long)minMillis), (Object)BoxesRunTime.boxToLong((long)maxMillis), Gen.Choose$.MODULE$.chooseLong());
    }

    private Gen<Literal> timestampLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x400) == 0) {
                timestampLiteralGen = this.millisGen().map((Function1 & Serializable)millis -> Literal$.MODULE$.create((Object)new Timestamp(BoxesRunTime.unboxToLong((Object)millis)), (DataType)TimestampType$.MODULE$));
                bitmap$0 |= 0x400;
            }
        }
        return timestampLiteralGen;
    }

    public Gen<Literal> timestampLiteralGen() {
        if ((bitmap$0 & 0x400) == 0) {
            return this.timestampLiteralGen$lzycompute();
        }
        return timestampLiteralGen;
    }

    private Gen<Literal> timestampNTZLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x800) == 0) {
                timestampNTZLiteralGen = this.millisGen().map((Function1 & Serializable)millis -> Literal$.MODULE$.create((Object)DateTimeUtils$.MODULE$.microsToLocalDateTime(BoxesRunTime.unboxToLong((Object)millis) * 1000L), (DataType)TimestampNTZType$.MODULE$));
                bitmap$0 |= 0x800;
            }
        }
        return timestampNTZLiteralGen;
    }

    public Gen<Literal> timestampNTZLiteralGen() {
        if ((bitmap$0 & 0x800) == 0) {
            return this.timestampNTZLiteralGen$lzycompute();
        }
        return timestampNTZLiteralGen;
    }

    private int maxIntervalInMonths() {
        return maxIntervalInMonths;
    }

    private Gen<Literal> monthIntervalLiterGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x1000) == 0) {
                monthIntervalLiterGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)(-1 * this.maxIntervalInMonths())), (Object)BoxesRunTime.boxToInteger((int)this.maxIntervalInMonths()), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)months -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)months)), (DataType)IntegerType$.MODULE$));
                bitmap$0 |= 0x1000;
            }
        }
        return monthIntervalLiterGen;
    }

    public Gen<Literal> monthIntervalLiterGen() {
        if ((bitmap$0 & 0x1000) == 0) {
            return this.monthIntervalLiterGen$lzycompute();
        }
        return monthIntervalLiterGen;
    }

    private Gen<Literal> calendarIntervalLiterGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x2000) == 0) {
                long maxDurationInSec = Duration.between(Instant.parse("0001-01-01T00:00:00.000000Z"), Instant.parse("9999-12-31T23:59:59.999999Z")).getSeconds();
                long maxMicros = TimeUnit.SECONDS.toMicros(maxDurationInSec);
                int maxDays = (int)TimeUnit.SECONDS.toDays(maxDurationInSec);
                calendarIntervalLiterGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)(-1 * this.maxIntervalInMonths())), (Object)BoxesRunTime.boxToInteger((int)this.maxIntervalInMonths()), Gen.Choose$.MODULE$.chooseInt()).flatMap((Function1 & Serializable)months -> LiteralGenerator$.$anonfun$calendarIntervalLiterGen$1(maxMicros, maxDays, BoxesRunTime.unboxToInt((Object)months)));
                bitmap$0 |= 0x2000;
            }
        }
        return calendarIntervalLiterGen;
    }

    public Gen<Literal> calendarIntervalLiterGen() {
        if ((bitmap$0 & 0x2000) == 0) {
            return this.calendarIntervalLiterGen$lzycompute();
        }
        return calendarIntervalLiterGen;
    }

    private Gen<Literal> limitedIntegerLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x4000) == 0) {
                limitedIntegerLiteralGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)-100), (Object)BoxesRunTime.boxToInteger((int)100), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)i -> Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), (DataType)IntegerType$.MODULE$));
                bitmap$0 |= 0x4000;
            }
        }
        return limitedIntegerLiteralGen;
    }

    public Gen<Literal> limitedIntegerLiteralGen() {
        if ((bitmap$0 & 0x4000) == 0) {
            return this.limitedIntegerLiteralGen$lzycompute();
        }
        return limitedIntegerLiteralGen;
    }

    private Gen<Literal> dayTimeIntervalLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x8000) == 0) {
                dayTimeIntervalLiteralGen = this.calendarIntervalLiterGen().map((Function1 & Serializable)calendarIntervalLiteral -> Literal$.MODULE$.create((Object)((CalendarInterval)calendarIntervalLiteral.value()).extractAsDuration(), (DataType)DayTimeIntervalType$.MODULE$.apply()));
                bitmap$0 |= 0x8000;
            }
        }
        return dayTimeIntervalLiteralGen;
    }

    public Gen<Literal> dayTimeIntervalLiteralGen() {
        if ((bitmap$0 & 0x8000) == 0) {
            return this.dayTimeIntervalLiteralGen$lzycompute();
        }
        return dayTimeIntervalLiteralGen;
    }

    private Gen<Literal> yearMonthIntervalLiteralGen$lzycompute() {
        LiteralGenerator$ literalGenerator$ = this;
        synchronized (literalGenerator$) {
            if ((bitmap$0 & 0x10000) == 0) {
                yearMonthIntervalLiteralGen = Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)(-1 * this.maxIntervalInMonths())), (Object)BoxesRunTime.boxToInteger((int)this.maxIntervalInMonths()), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)months -> Literal$.MODULE$.create((Object)Period.ofMonths(BoxesRunTime.unboxToInt((Object)months)), (DataType)YearMonthIntervalType$.MODULE$.apply()));
                bitmap$0 |= 0x10000;
            }
        }
        return yearMonthIntervalLiteralGen;
    }

    public Gen<Literal> yearMonthIntervalLiteralGen() {
        if ((bitmap$0 & 0x10000) == 0) {
            return this.yearMonthIntervalLiteralGen$lzycompute();
        }
        return yearMonthIntervalLiteralGen;
    }

    public Gen<Literal> randomGen(DataType dt) {
        DecimalType decimalType;
        Option option;
        DataType dataType = dt;
        if (ByteType$.MODULE$.equals(dataType)) {
            return this.byteLiteralGen();
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return this.shortLiteralGen();
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return this.integerLiteralGen();
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return this.longLiteralGen();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return this.doubleLiteralGen();
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return this.floatLiteralGen();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return this.dateLiteralGen();
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return this.timestampLiteralGen();
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return this.timestampNTZLiteralGen();
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return this.booleanLiteralGen();
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return this.stringLiteralGen();
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return this.binaryLiteralGen();
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            return this.calendarIntervalLiterGen();
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return this.decimalLiteralGen(precision, scale);
        }
        if (dataType instanceof DayTimeIntervalType) {
            return this.dayTimeIntervalLiteralGen();
        }
        if (dataType instanceof YearMonthIntervalType) {
            return this.yearMonthIntervalLiteralGen();
        }
        throw new IllegalArgumentException("not supported type " + dataType);
    }

    public static final /* synthetic */ Gen $anonfun$calendarIntervalLiterGen$2(int maxDays$1, int months$1, long micros) {
        return Gen$.MODULE$.choose((Object)BoxesRunTime.boxToInteger((int)(-1 * maxDays$1)), (Object)BoxesRunTime.boxToInteger((int)maxDays$1), Gen.Choose$.MODULE$.chooseInt()).map((Function1 & Serializable)days -> Literal$.MODULE$.create((Object)new CalendarInterval(months$1, BoxesRunTime.unboxToInt((Object)days), micros), (DataType)CalendarIntervalType$.MODULE$));
    }

    public static final /* synthetic */ Gen $anonfun$calendarIntervalLiterGen$1(long maxMicros$1, int maxDays$1, int months) {
        return Gen$.MODULE$.choose((Object)BoxesRunTime.boxToLong((long)(-1L * maxMicros$1)), (Object)BoxesRunTime.boxToLong((long)maxMicros$1), Gen.Choose$.MODULE$.chooseLong()).flatMap((Function1 & Serializable)micros -> LiteralGenerator$.$anonfun$calendarIntervalLiterGen$2(maxDays$1, months, BoxesRunTime.unboxToLong((Object)micros)));
    }

    private LiteralGenerator$() {
    }
}

