/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005M4Aa\u0002\u0005\u0001/!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C!9A\bAI\u0001\n\u0003i\u0004\"\u0002%\u0001\t\u0003I\u0005\"\u0002'\u0001\t\u0003i\u0005\"B-\u0001\t\u0003Q&\u0001\u0007%za\u0016\u0014Hj\\4M_\u001e\u0004F.^:QYV\u001c8+^5uK*\u0011\u0011BC\u0001\nC\u001e<'/Z4bi\u0016T!a\u0003\u0007\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u001b9\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u001fA\t1a]9m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000e\u000e\u0003AI!a\u0007\t\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t\u0001\"A\bde\u0016\fG/Z#ti&l\u0017\r^8s)\r\u0011s\u0006\u000e\t\u0006G\u0019B3fK\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1A+\u001e9mKN\u0002\"aH\u0015\n\u0005)B!a\u0005%za\u0016\u0014Hj\\4M_\u001e\u0004F.^:QYV\u001c\bC\u0001\u0017.\u001b\u0005a\u0011B\u0001\u0018\r\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000bA\u0012\u0001\u0019A\u0019\u0002\u0007I\u001cH\r\u0005\u0002$e%\u00111\u0007\n\u0002\u0007\t>,(\r\\3\t\u000fU\u0012\u0001\u0013!a\u0001m\u0005\u0011A\r\u001e\t\u0003oij\u0011\u0001\u000f\u0006\u0003s9\tQ\u0001^=qKNL!a\u000f\u001d\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0011d\u0019:fCR,Wi\u001d;j[\u0006$xN\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\taH\u000b\u00027\u007f-\n\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u000b\u0012\n!\"\u00198o_R\fG/[8o\u0013\t9%IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAb\u0019:fCR,')\u001e4gKJ$\"a\u000b&\t\u000b-#\u0001\u0019\u0001\u0015\u0002\u0007!dG.\u0001\tfm\u0006dW/\u0019;f\u000bN$\u0018.\\1uKR!a*\u0015*U!\t\u0019s*\u0003\u0002QI\t!QK\\5u\u0011\u0015YU\u00011\u0001)\u0011\u0015\u0019V\u00011\u0001,\u0003\u0019\u0011WO\u001a4fe\")Q+\u0002a\u0001-\u0006Y1-\u0019:eS:\fG.\u001b;z!\t\u0019s+\u0003\u0002YI\t\u0019\u0011J\u001c;\u00021Q,7\u000f^\"be\u0012Lg.\u00197jif,5\u000f^5nCR,7\u000fF\u0003O7&d\u0017\u000fC\u0003]\r\u0001\u0007Q,\u0001\u0003sg\u0012\u001c\bc\u00010gc9\u0011q\f\u001a\b\u0003A\u000el\u0011!\u0019\u0006\u0003EZ\ta\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005\u0015$\u0013a\u00029bG.\fw-Z\u0005\u0003O\"\u00141aU3r\u0015\t)G\u0005C\u0003k\r\u0001\u00071.\u0001\u0002ogB\u0019aL\u001a,\t\u000b54\u0001\u0019\u00018\u0002\u0003\u0019\u0004BaI8W-&\u0011\u0001\u000f\n\u0002\n\rVt7\r^5p]FBQA\u001d\u0004A\u00029\f\u0011a\u0019")
public class HyperLogLogPlusPlusSuite
extends SparkFunSuite {
    public Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> createEstimator(double rsd, DataType dt) {
        SpecificInternalRow input = new SpecificInternalRow((Seq)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
        HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus((Expression)new BoundReference(0, dt, true), rsd, HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3(), HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4());
        InternalRow buffer = this.createBuffer(hll);
        return new Tuple3((Object)hll, (Object)input, (Object)buffer);
    }

    public DataType createEstimator$default$2() {
        return IntegerType$.MODULE$;
    }

    public InternalRow createBuffer(HyperLogLogPlusPlus hll) {
        SpecificInternalRow buffer = new SpecificInternalRow((Seq)hll.aggBufferAttributes().map((Function1 & Serializable)x$1 -> x$1.dataType()));
        hll.initialize((InternalRow)buffer);
        return buffer;
    }

    public void evaluateEstimate(HyperLogLogPlusPlus hll, InternalRow buffer, int cardinality) {
        double error;
        double estimate = BoxesRunTime.unboxToLong((Object)hll.eval(buffer));
        double $org_scalatest_assert_macro_left = error = package$.MODULE$.abs(estimate / (double)cardinality - 1.0);
        double $org_scalatest_assert_macro_right = hll.hllppHelper().trueRsd() * 3.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Error should be within 3 std. errors.", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    public void testCardinalityEstimates(Seq<Object> rsds, Seq<Object> ns, Function1<Object, Object> f, Function1<Object, Object> c) {
        ((IterableOnceOps)rsds.flatMap((Function1 & Serializable)rsd -> HyperLogLogPlusPlusSuite.$anonfun$testCardinalityEstimates$1(ns, BoxesRunTime.unboxToDouble((Object)rsd)))).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                double error;
                double rsd = tuple2._1$mcD$sp();
                int n = tuple2._2$mcI$sp();
                Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> tuple3 = this.createEstimator(rsd, this.createEstimator$default$2());
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
                InternalRow input = (InternalRow)tuple3._2();
                InternalRow buffer = (InternalRow)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer);
                HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple32._1();
                InternalRow input2 = (InternalRow)tuple32._2();
                InternalRow buffer2 = (InternalRow)tuple32._3();
                for (int i = 0; i < n; ++i) {
                    input2.setInt(0, f.apply$mcII$sp(i));
                    hll2.update(buffer2, input2);
                }
                double estimate = BoxesRunTime.unboxToLong((Object)hll2.eval(buffer2));
                int cardinality = c.apply$mcII$sp(n);
                double $org_scalatest_assert_macro_left = error = package$.MODULE$.abs(estimate / (double)cardinality - 1.0);
                double $org_scalatest_assert_macro_right = hll2.hllppHelper().trueRsd() * 3.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Error should be within 3 std. errors.", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ Tuple2 $anonfun$testCardinalityEstimates$2(double rsd$1, int n) {
        return new Tuple2.mcDI.sp(rsd$1, n);
    }

    public static final /* synthetic */ Seq $anonfun$testCardinalityEstimates$1(Seq ns$1, double rsd) {
        return (Seq)ns$1.map((Function1 & Serializable)n -> HyperLogLogPlusPlusSuite.$anonfun$testCardinalityEstimates$2(rsd, BoxesRunTime.unboxToInt((Object)n)));
    }

    public HyperLogLogPlusPlusSuite() {
        this.test("test invalid parameter relativeSD", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> new HyperLogLogPlusPlus((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), 0.4, HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3(), HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56)), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("add nulls", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long estimate;
            Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> tuple3 = this.createEstimator(0.05, this.createEstimator$default$2());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
            InternalRow input = (InternalRow)tuple3._2();
            InternalRow buffer = (InternalRow)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer);
            HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple32._1();
            InternalRow input2 = (InternalRow)tuple32._2();
            InternalRow buffer2 = (InternalRow)tuple32._3();
            input2.setNullAt(0);
            hll2.update(buffer2, input2);
            hll2.update(buffer2, input2);
            long $org_scalatest_assert_macro_left = estimate = BoxesRunTime.unboxToLong((Object)hll2.eval(buffer2));
            long $org_scalatest_assert_macro_right = 0L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Nothing meaningful added; estimate should be 0.", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("deterministic cardinality estimation", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int repeats = 10;
            this.testCardinalityEstimates((Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.1, 0.05, 0.025, 0.01, 0.001}))), (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 500, 1000, 5000, 10000, 50000, 100000, 500000, 1000000})).map((Function1)(JFunction1.mcII.sp & Serializable)x$4 -> x$4 * repeats)), (Function1<Object, Object>)(JFunction1.mcII.sp & Serializable)i -> i / repeats, (Function1<Object, Object>)(JFunction1.mcII.sp & Serializable)i -> i / repeats);
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("random cardinality estimation", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Random srng = new Random(323981238L);
            HashSet seen = HashSet$.MODULE$.empty();
            JFunction1.mcII.sp & Serializable update = (JFunction1.mcII.sp & Serializable)i -> {
                int value = srng.nextInt();
                seen.$plus$eq((Object)BoxesRunTime.boxToInteger((int)value));
                return value;
            };
            JFunction1.mcII.sp & Serializable eval = (JFunction1.mcII.sp & Serializable)n -> {
                int cardinality = seen.size();
                seen.clear();
                return cardinality;
            };
            this.testCardinalityEstimates((Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.05, 0.01}))), (Seq<Object>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 10000, 500000}))), (Function1<Object, Object>)update, (Function1<Object, Object>)eval);
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("merging HLL instances", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int i;
            Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> tuple3 = this.createEstimator(0.05, this.createEstimator$default$2());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
            InternalRow input = (InternalRow)tuple3._2();
            InternalRow buffer1a = (InternalRow)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer1a);
            HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple32._1();
            InternalRow input2 = (InternalRow)tuple32._2();
            InternalRow buffer1a2 = (InternalRow)tuple32._3();
            InternalRow buffer1b = this.createBuffer(hll2);
            InternalRow buffer2 = this.createBuffer(hll2);
            for (i = 0; i < 500000; ++i) {
                input2.setInt(0, i);
                hll2.update(buffer1a2, input2);
            }
            for (i = 500000; i < 1000000; ++i) {
                input2.setInt(0, i);
                hll2.update(buffer1b, input2);
            }
            hll2.merge(buffer1a2, buffer1b);
            for (i = 999999; i >= 0; --i) {
                input2.setInt(0, i);
                hll2.update(buffer2, input2);
            }
            InternalRow $org_scalatest_assert_macro_left = buffer2;
            InternalRow $org_scalatest_assert_macro_right = buffer1a2;
            InternalRow internalRow = $org_scalatest_assert_macro_left;
            InternalRow internalRow2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(internalRow != null ? !internalRow.equals(internalRow2) : internalRow2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Buffers should be equal", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("SPARK-32110: add 0.0 and -0.0", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> tuple3 = this.createEstimator(0.05, (DataType)DoubleType$.MODULE$);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
            InternalRow input = (InternalRow)tuple3._2();
            InternalRow buffer = (InternalRow)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer);
            HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple32._1();
            InternalRow input2 = (InternalRow)tuple32._2();
            InternalRow buffer2 = (InternalRow)tuple32._3();
            input2.setDouble(0, 0.0);
            hll2.update(buffer2, input2);
            input2.setDouble(0, -0.0);
            hll2.update(buffer2, input2);
            this.evaluateEstimate(hll2, buffer2, 1);
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("SPARK-32110: add NaN", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> tuple3 = this.createEstimator(0.05, (DataType)DoubleType$.MODULE$);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
            InternalRow input = (InternalRow)tuple3._2();
            InternalRow buffer = (InternalRow)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer);
            HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple32._1();
            InternalRow input2 = (InternalRow)tuple32._2();
            InternalRow buffer2 = (InternalRow)tuple32._3();
            input2.setDouble(0, Double.NaN);
            hll2.update(buffer2, input2);
            double specialNaN = Double.longBitsToDouble(9219188691769251448L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Double.isNaN(specialNaN), "java.lang.Double.isNaN(specialNaN)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            long $org_scalatest_assert_macro_left = Double.doubleToRawLongBits(Double.NaN);
            long $org_scalatest_assert_macro_right = Double.doubleToRawLongBits(specialNaN);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            input2.setDouble(0, specialNaN);
            hll2.update(buffer2, input2);
            this.evaluateEstimate(hll2, buffer2, 1);
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
    }
}

