/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.expressions.variant.VariantExpressionEvalUtils$;
import org.apache.spark.types.variant.VariantUtil;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005m1AAA\u0002\u0001%!)q\u0003\u0001C\u00011\tyb+\u0019:jC:$X\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW\u000b^5mgN+\u0018\u000e^3\u000b\u0005\u0011)\u0011a\u0002<be&\fg\u000e\u001e\u0006\u0003\r\u001d\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001\"C\u0001\tG\u0006$\u0018\r\\=ti*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0005\t\u0003)Ui\u0011aC\u0005\u0003--\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0004\u0001")
public class VariantExpressionEvalUtilsSuite
extends SparkFunSuite {
    private final void check$1(String json, byte[] expectedValue, byte[] expectedMetadata, boolean allowDuplicateKeys) {
        Bool bool;
        VariantVal $org_scalatest_assert_macro_right;
        VariantVal actual = VariantExpressionEvalUtils$.MODULE$.parseJson(UTF8String.fromString((String)json), allowDuplicateKeys, VariantExpressionEvalUtils$.MODULE$.parseJson$default$3());
        VariantVal tryActual = VariantExpressionEvalUtils$.MODULE$.parseJson(UTF8String.fromString((String)json), allowDuplicateKeys, false);
        VariantVal expected = new VariantVal(expectedValue, expectedMetadata);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)($org_scalatest_assert_macro_right = expected), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left2.value()) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(tryActual);
            VariantVal $org_scalatest_assert_macro_right2 = expected;
            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        } else {
            bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right3 = bool;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VariantExpressionEvalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
    }

    private static final boolean check$default$4$1() {
        return false;
    }

    private final void checkException$1(String json, String condition, Map parameters) {
        VariantVal try_parse_json_output = VariantExpressionEvalUtils$.MODULE$.parseJson(UTF8String.fromString((String)json), false, false);
        SparkThrowable x$1 = (SparkThrowable)this.intercept((Function0 & Serializable)() -> VariantExpressionEvalUtils$.MODULE$.parseJson(UTF8String.fromString((String)json), false, VariantExpressionEvalUtils$.MODULE$.parseJson$default$3()), ClassTag$.MODULE$.apply(SparkThrowable.class), new Position("VariantExpressionEvalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        String x$2 = condition;
        Map x$3 = parameters;
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError(x$1, x$2, x$4, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(try_parse_json_output);
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VariantExpressionEvalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }

    private static final void check$2(String json, boolean expected) {
        boolean actual;
        if (json != null) {
            boolean actual2;
            VariantVal parsedVariant = VariantExpressionEvalUtils$.MODULE$.parseJson(UTF8String.fromString((String)json), VariantExpressionEvalUtils$.MODULE$.parseJson$default$2(), VariantExpressionEvalUtils$.MODULE$.parseJson$default$3());
            boolean $org_scalatest_assert_macro_left = actual2 = VariantExpressionEvalUtils$.MODULE$.isVariantNull(parsedVariant);
            boolean $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VariantExpressionEvalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            return;
        }
        boolean $org_scalatest_assert_macro_left = actual = VariantExpressionEvalUtils$.MODULE$.isVariantNull(null);
        boolean $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("VariantExpressionEvalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
    }

    public VariantExpressionEvalUtilsSuite() {
        this.test("parseJson type coercion", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            byte[] emptyMetadata = new byte[]{1, 0, 0};
            this.check$1("null", new byte[]{VariantUtil.primitiveHeader((int)0)}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("true", new byte[]{VariantUtil.primitiveHeader((int)1)}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("false", new byte[]{VariantUtil.primitiveHeader((int)2)}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("1", new byte[]{VariantUtil.primitiveHeader((int)3), 1}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("-1", new byte[]{VariantUtil.primitiveHeader((int)3), -1}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("127", new byte[]{VariantUtil.primitiveHeader((int)3), 127}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("128", new byte[]{VariantUtil.primitiveHeader((int)4), -128, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("-32768", new byte[]{VariantUtil.primitiveHeader((int)4), 0, -128}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("-32769", new byte[]{VariantUtil.primitiveHeader((int)5), -1, 127, -1, -1}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("2147483647", new byte[]{VariantUtil.primitiveHeader((int)5), -1, -1, -1, 127}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("2147483648", new byte[]{VariantUtil.primitiveHeader((int)6), 0, 0, 0, -128, 0, 0, 0, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("9223372036854775807", new byte[]{VariantUtil.primitiveHeader((int)6), -1, -1, -1, -1, -1, -1, -1, 127}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("-9223372036854775808", new byte[]{VariantUtil.primitiveHeader((int)6), 0, 0, 0, 0, 0, 0, 0, -128}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("9223372036854775808", new byte[]{VariantUtil.primitiveHeader((int)10), 0, 0, 0, 0, 0, 0, 0, 0, -128, 0, 0, 0, 0, 0, 0, 0, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("1.0", new byte[]{VariantUtil.primitiveHeader((int)8), 1, 10, 0, 0, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("1.01", new byte[]{VariantUtil.primitiveHeader((int)8), 2, 101, 0, 0, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("99999.9999", new byte[]{VariantUtil.primitiveHeader((int)8), 4, -1, -55, -102, 59}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("99999.99999", new byte[]{VariantUtil.primitiveHeader((int)9), 5, -1, -29, 11, 84, 2, 0, 0, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("0.000000001", new byte[]{VariantUtil.primitiveHeader((int)8), 9, 1, 0, 0, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("0.0000000001", new byte[]{VariantUtil.primitiveHeader((int)9), 10, 1, 0, 0, 0, 0, 0, 0, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("9"), 38), (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(new byte[]{VariantUtil.primitiveHeader((int)10), 0}), ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.byteArrayOps(package$.MODULE$.BigInt().apply(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("9"), 38)).toByteArray())), (ClassTag)ClassTag$.MODULE$.Byte()), emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("1" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 38), (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(new byte[]{VariantUtil.primitiveHeader((int)7)}), ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.byteArrayOps(package$.MODULE$.BigInt().apply(Double.doubleToLongBits(1.0E38)).toByteArray())), (ClassTag)ClassTag$.MODULE$.Byte()), emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("\"\"", new byte[]{VariantUtil.shortStrHeader((int)0)}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("\"abcd\"", new byte[]{VariantUtil.shortStrHeader((int)4), 97, 98, 99, 100}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("\"" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("x"), 63) + "\"", (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(new byte[]{VariantUtil.shortStrHeader((int)63)}), Array$.MODULE$.fill(63, (Function0)(JFunction0.mcB.sp & Serializable)() -> (byte)120, (ClassTag)ClassTag$.MODULE$.Byte()), (ClassTag)ClassTag$.MODULE$.Byte()), emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("\"" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("y"), 64) + "\"", (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(new byte[]{VariantUtil.primitiveHeader((int)16), 64, 0, 0, 0}), Array$.MODULE$.fill(64, (Function0)(JFunction0.mcB.sp & Serializable)() -> (byte)121, (ClassTag)ClassTag$.MODULE$.Byte()), (ClassTag)ClassTag$.MODULE$.Byte()), emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("{}", new byte[]{VariantUtil.objectHeader((boolean)false, (int)1, (int)1), 0, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("[]", new byte[]{VariantUtil.arrayHeader((boolean)false, (int)1), 0, 0}, emptyMetadata, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("{\"a\": 1, \"b\": 2, \"c\": \"3\"}", new byte[]{VariantUtil.objectHeader((boolean)false, (int)1, (int)1), 3, 0, 1, 2, 0, 2, 4, 6, VariantUtil.primitiveHeader((int)3), 1, VariantUtil.primitiveHeader((int)3), 2, VariantUtil.shortStrHeader((int)1), 51}, new byte[]{1, 3, 0, 1, 2, 3, 97, 98, 99}, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("{\"a\": 1, \"b\": 2, \"c\": \"3\", \"a\": 4}", new byte[]{VariantUtil.objectHeader((boolean)false, (int)1, (int)1), 3, 0, 1, 2, 4, 0, 2, 6, VariantUtil.primitiveHeader((int)3), 2, VariantUtil.shortStrHeader((int)1), 51, VariantUtil.primitiveHeader((int)3), 4}, new byte[]{1, 3, 0, 1, 2, 3, 97, 98, 99}, true);
            this.check$1("{\"z\": 1, \"y\": 2, \"x\": \"3\"}", new byte[]{VariantUtil.objectHeader((boolean)false, (int)1, (int)1), 3, 2, 1, 0, 4, 2, 0, 6, VariantUtil.primitiveHeader((int)3), 1, VariantUtil.primitiveHeader((int)3), 2, VariantUtil.shortStrHeader((int)1), 51}, new byte[]{1, 3, 0, 1, 2, 3, 122, 121, 120}, VariantExpressionEvalUtilsSuite.check$default$4$1());
            this.check$1("[null, true, {\"false\" : 0}]", new byte[]{VariantUtil.arrayHeader((boolean)false, (int)1), 3, 0, 1, 2, 9, VariantUtil.primitiveHeader((int)0), VariantUtil.primitiveHeader((int)1), VariantUtil.objectHeader((boolean)false, (int)1, (int)1), 1, 0, 0, 2, VariantUtil.primitiveHeader((int)3), 0}, new byte[]{1, 1, 0, 5, 102, 97, 108, 115, 101}, VariantExpressionEvalUtilsSuite.check$default$4$1());
        }, new Position("VariantExpressionEvalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("parseJson negative", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            new .colon.colon((Object)"", (List)new .colon.colon((Object)"[", (List)new .colon.colon((Object)"+1", (List)new .colon.colon((Object)"1a", (List)new .colon.colon((Object)"{\"a\": 1, \"b\": 2, \"a\": \"3\"}", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)json -> {
                this.checkException$1(json, "MALFORMED_RECORD_IN_PARSING.WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"badRecord"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failFastMode"), (Object)"FAILFAST")})));
                return BoxedUnit.UNIT;
            });
            new .colon.colon((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 0x2000000).mkString("[", ",", "]"), (List)Nil$.MODULE$).foreach((Function1 & Serializable)json -> {
                this.checkException$1(json, "VARIANT_SIZE_LIMIT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sizeLimit"), (Object)"128.0 MiB"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`parse_json`")})));
                return BoxedUnit.UNIT;
            });
        }, new Position("VariantExpressionEvalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        this.test("isVariantNull", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            VariantExpressionEvalUtilsSuite.check$2("null", true);
            VariantExpressionEvalUtilsSuite.check$2(null, false);
            VariantExpressionEvalUtilsSuite.check$2("0", false);
            VariantExpressionEvalUtilsSuite.check$2("13", false);
            VariantExpressionEvalUtilsSuite.check$2("-54", false);
            VariantExpressionEvalUtilsSuite.check$2("2147483647", false);
            VariantExpressionEvalUtilsSuite.check$2("2147483648", false);
            VariantExpressionEvalUtilsSuite.check$2("238457328534848", false);
            VariantExpressionEvalUtilsSuite.check$2("342.769", false);
            VariantExpressionEvalUtilsSuite.check$2("true", false);
            VariantExpressionEvalUtilsSuite.check$2("false", false);
            VariantExpressionEvalUtilsSuite.check$2("false", false);
            VariantExpressionEvalUtilsSuite.check$2("65.43", false);
            VariantExpressionEvalUtilsSuite.check$2("\"" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("spark"), 100) + "\"", false);
            VariantExpressionEvalUtilsSuite.check$2("\"\"", false);
            VariantExpressionEvalUtilsSuite.check$2("\"null\"", false);
            VariantExpressionEvalUtilsSuite.check$2("[]", false);
            VariantExpressionEvalUtilsSuite.check$2("[null, null]", false);
            VariantExpressionEvalUtilsSuite.check$2("[{\"a\" : 13}, \"spark\"]", false);
            VariantExpressionEvalUtilsSuite.check$2("[{\"a\" : 13, \"b\" : null}]", false);
        }, new Position("VariantExpressionEvalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }
}

