/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CsvToStructs;
import org.apache.spark.sql.catalyst.expressions.CsvToStructs$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.optimizer.OptimizeCsvExprsSuite$Optimizer$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005m4AAE\n\u0001A!)1\u0006\u0001C\u0001Y!Iq\u0006\u0001a\u0001\u0002\u0004%I\u0001\r\u0005\no\u0001\u0001\r\u00111A\u0005\naB\u0011B\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u0019\t\u000b}\u0002A\u0011\u000b!\t\u000b\u0005\u0003A\u0011\u000b!\b\u000b\t\u0003\u0001\u0012A\"\u0007\u000b\u0015\u0003\u0001\u0012\u0001$\t\u000b-BA\u0011A*\t\u000fQC!\u0019!C\u0001+\"1!\r\u0003Q\u0001\nYCqa\u0019\u0001C\u0002\u0013\u0005A\r\u0003\u0004l\u0001\u0001\u0006I!\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019!\b\u0001)A\u0005]\"9Q\u000f\u0001b\u0001\n\u00131\bB\u0002>\u0001A\u0003%qOA\u000bPaRLW.\u001b>f\u0007N4X\t\u001f9sgN+\u0018\u000e^3\u000b\u0005Q)\u0012!C8qi&l\u0017N_3s\u0015\t1r#\u0001\u0005dCR\fG._:u\u0015\tA\u0012$A\u0002tc2T!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011%\n\t\u0003E\rj\u0011!G\u0005\u0003Ie\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0016\u0003\u0015\u0001H.\u00198t\u0013\tQsE\u0001\u0005QY\u0006tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tQ\u0006\u0005\u0002/\u00015\t1#\u0001\u000fdgZ,\u0005\u0010\u001d:fgNLwN\\(qi&l\u0017N_3F]\u0006\u0014G.\u001a3\u0016\u0003E\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012qAQ8pY\u0016\fg.\u0001\u0011dgZ,\u0005\u0010\u001d:fgNLwN\\(qi&l\u0017N_3F]\u0006\u0014G.\u001a3`I\u0015\fHCA\u001d=!\t\u0011$(\u0003\u0002<g\t!QK\\5u\u0011\u001di4!!AA\u0002E\n1\u0001\u001f\u00132\u0003u\u00197O^#yaJ,7o]5p]>\u0003H/[7ju\u0016,e.\u00192mK\u0012\u0004\u0013!\u00032fM>\u0014X-\u00117m)\u0005I\u0014\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0002\u0013=\u0003H/[7ju\u0016\u0014\bC\u0001#\t\u001b\u0005\u0001!!C(qi&l\u0017N_3s'\tAq\tE\u0002I\u00176k\u0011!\u0013\u0006\u0003\u0015V\tQA];mKNL!\u0001T%\u0003\u0019I+H.Z#yK\u000e,Ho\u001c:\u0011\u00059\u000bV\"A(\u000b\u0005A;\u0013a\u00027pO&\u001c\u0017\r\\\u0005\u0003%>\u00131\u0002T8hS\u000e\fG\u000e\u00157b]R\t1)A\u0004cCR\u001c\u0007.Z:\u0016\u0003Y\u00032a\u0016/_\u001b\u0005A&BA-[\u0003%IW.\\;uC\ndWM\u0003\u0002\\g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uC&\u0001\u0002'jgR\u0004\"a\u00181\u000e\u0003!I!!Y&\u0003\u000b\t\u000bGo\u00195\u0002\u0011\t\fGo\u00195fg\u0002\naa]2iK6\fW#A3\u0011\u0005\u0019LW\"A4\u000b\u0005!<\u0012!\u0002;za\u0016\u001c\u0018B\u00016h\u0005)\u0019FO];diRK\b/Z\u0001\bg\u000eDW-\\1!\u0003\u001d\u00197O^!uiJ,\u0012A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cV\t1\"\u001a=qe\u0016\u001c8/[8og&\u00111\u000f\u001d\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW-\u0001\u0005dgZ\fE\u000f\u001e:!\u00031!Xm\u001d;SK2\fG/[8o+\u00059\bC\u0001(y\u0013\tIxJA\u0007M_\u000e\fGNU3mCRLwN\\\u0001\u000ei\u0016\u001cHOU3mCRLwN\u001c\u0011")
public class OptimizeCsvExprsSuite
extends SparkFunSuite
implements PlanTest {
    private volatile OptimizeCsvExprsSuite$Optimizer$ Optimizer$module;
    private boolean csvExpressionOptimizeEnabled;
    private final StructType schema;
    private final AttributeReference csvAttr;
    private final LocalRelation testRelation;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public OptimizeCsvExprsSuite$Optimizer$ Optimizer() {
        if (this.Optimizer$module == null) {
            this.Optimizer$lzycompute$1();
        }
        return this.Optimizer$module;
    }

    private String sparkHome$lzycompute() {
        OptimizeCsvExprsSuite optimizeCsvExprsSuite = this;
        synchronized (optimizeCsvExprsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private boolean csvExpressionOptimizeEnabled() {
        return this.csvExpressionOptimizeEnabled;
    }

    private void csvExpressionOptimizeEnabled_$eq(boolean x$1) {
        this.csvExpressionOptimizeEnabled = x$1;
    }

    public void beforeAll() {
        this.csvExpressionOptimizeEnabled_$eq(SQLConf$.MODULE$.get().csvExpressionOptimization());
    }

    public void afterAll() {
        SQLConf$.MODULE$.get().setConf(SQLConf$.MODULE$.CSV_EXPRESSION_OPTIMIZATION(), (Object)BoxesRunTime.boxToBoolean((boolean)this.csvExpressionOptimizeEnabled()));
    }

    public StructType schema() {
        return this.schema;
    }

    private AttributeReference csvAttr() {
        return this.csvAttr;
    }

    private LocalRelation testRelation() {
        return this.testRelation;
    }

    private final void Optimizer$lzycompute$1() {
        OptimizeCsvExprsSuite optimizeCsvExprsSuite = this;
        synchronized (optimizeCsvExprsSuite) {
            if (this.Optimizer$module == null) {
                this.Optimizer$module = new OptimizeCsvExprsSuite$Optimizer$(this);
            }
        }
    }

    public OptimizeCsvExprsSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        PlanTestBase.$init$(this);
        this.schema = StructType$.MODULE$.fromDDL("a int, b int");
        this.csvAttr = package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"csv"}))).$((Seq)Nil$.MODULE$)).string();
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{this.csvAttr()}));
        this.test("SPARK-32968: prune unnecessary columns from GetStructField + from_csv", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Map options = Predef$.MODULE$.Map().empty();
            LogicalPlan query1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new GetStructField((Expression)new CsvToStructs(this.schema(), options, (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"csv"}))).$((Seq)Nil$.MODULE$), CsvToStructs$.MODULE$.apply$default$4(), CsvToStructs$.MODULE$.apply$default$5()), 0, GetStructField$.MODULE$.apply$default$3())}));
            LogicalPlan optimized1 = (LogicalPlan)this.Optimizer().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query1).analyze());
            StructType prunedSchema1 = StructType$.MODULE$.fromDDL("a int");
            LogicalPlan expected1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new GetStructField((Expression)new CsvToStructs(this.schema(), options, (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"csv"}))).$((Seq)Nil$.MODULE$), (Option)None$.MODULE$, (Option)new Some((Object)prunedSchema1)), 0, GetStructField$.MODULE$.apply$default$3())}))).analyze();
            this.comparePlans(optimized1, expected1, this.comparePlans$default$3());
            LogicalPlan query2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new GetStructField((Expression)new CsvToStructs(this.schema(), options, (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"csv"}))).$((Seq)Nil$.MODULE$), CsvToStructs$.MODULE$.apply$default$4(), CsvToStructs$.MODULE$.apply$default$5()), 1, GetStructField$.MODULE$.apply$default$3())}));
            LogicalPlan optimized2 = (LogicalPlan)this.Optimizer().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query2).analyze());
            StructType prunedSchema2 = StructType$.MODULE$.fromDDL("b int");
            LogicalPlan expected2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new GetStructField((Expression)new CsvToStructs(this.schema(), options, (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"csv"}))).$((Seq)Nil$.MODULE$), (Option)None$.MODULE$, (Option)new Some((Object)prunedSchema2)), 0, GetStructField$.MODULE$.apply$default$3())}))).analyze();
            this.comparePlans(optimized2, expected2, this.comparePlans$default$3());
        }, new Position("OptimizeCsvExprsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("SPARK-32968: don't prune columns if options is not empty", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Map options = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"failfast")}));
            LogicalPlan query = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{new GetStructField((Expression)new CsvToStructs(this.schema(), options, (Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"csv"}))).$((Seq)Nil$.MODULE$), CsvToStructs$.MODULE$.apply$default$4(), CsvToStructs$.MODULE$.apply$default$5()), 0, GetStructField$.MODULE$.apply$default$3())}));
            LogicalPlan optimized = (LogicalPlan)this.Optimizer().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(query).analyze());
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(query).analyze();
            this.comparePlans(optimized, expected, this.comparePlans$default$3());
        }, new Position("OptimizeCsvExprsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
    }
}

