/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Entry;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.dsl.BeWord;
import org.scalatest.matchers.dsl.ContainWord;
import org.scalatest.matchers.dsl.DefinedWord;
import org.scalatest.matchers.dsl.EmptyWord;
import org.scalatest.matchers.dsl.EndWithWord;
import org.scalatest.matchers.dsl.ExistWord;
import org.scalatest.matchers.dsl.FullyMatchWord;
import org.scalatest.matchers.dsl.HaveWord;
import org.scalatest.matchers.dsl.IncludeWord;
import org.scalatest.matchers.dsl.LengthWord;
import org.scalatest.matchers.dsl.MatchPatternWord;
import org.scalatest.matchers.dsl.MatcherFactory1;
import org.scalatest.matchers.dsl.MatcherWords;
import org.scalatest.matchers.dsl.NoExceptionWord;
import org.scalatest.matchers.dsl.NotWord;
import org.scalatest.matchers.dsl.ReadableWord;
import org.scalatest.matchers.dsl.ResultOfATypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAllElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfAllOfApplication;
import org.scalatest.matchers.dsl.ResultOfAnTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtLeastOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfAtMostOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfDefinedAt;
import org.scalatest.matchers.dsl.ResultOfGreaterThanComparison;
import org.scalatest.matchers.dsl.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfInOrderApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfInOrderOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfLessThanComparison;
import org.scalatest.matchers.dsl.ResultOfLessThanOrEqualToComparison;
import org.scalatest.matchers.dsl.ResultOfMessageWordApplication;
import org.scalatest.matchers.dsl.ResultOfNoElementsOfApplication;
import org.scalatest.matchers.dsl.ResultOfNoneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOfTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfOneElementOfApplication;
import org.scalatest.matchers.dsl.ResultOfOneOfApplication;
import org.scalatest.matchers.dsl.ResultOfOnlyApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.matchers.dsl.ResultOfTheTypeInvocation;
import org.scalatest.matchers.dsl.ResultOfThrownByApplication;
import org.scalatest.matchers.dsl.SizeWord;
import org.scalatest.matchers.dsl.SortedWord;
import org.scalatest.matchers.dsl.StartWithWord;
import org.scalatest.matchers.dsl.WritableWord;
import org.scalatest.matchers.must.Matchers;
import org.scalatest.matchers.must.Matchers$AtLeastCollected$;
import org.scalatest.matchers.must.Matchers$AtMostCollected$;
import org.scalatest.matchers.must.Matchers$BetweenCollected$;
import org.scalatest.matchers.must.Matchers$ExactlyCollected$;
import org.scalatest.matchers.should.Matchers$;
import org.scalatest.verbs.CompileWord;
import org.scalatest.verbs.MustVerb;
import org.scalatest.verbs.TypeCheckWord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\u0005\n\u0001YAQa\u000b\u0001\u0005\u00021BQa\f\u0001\u0005\nABQ!\u000f\u0001\u0005\niBQ!\u0015\u0001\u0005\nICQ!\u0019\u0001\u0005\n\tDQa\u001b\u0001\u0005\u00021Dqa\u001e\u0001\u0012\u0002\u0013\u0005\u0001P\u0001\nECR,G+[7f+RLGn]*vSR,'B\u0001\u0006\f\u0003\u0011)H/\u001b7\u000b\u00051i\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00059y\u0011aA:rY*\u0011\u0001#E\u0001\u0006gB\f'o\u001b\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u000192$\n\t\u00031ei\u0011aD\u0005\u00035=\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u000f$\u001b\u0005i\"B\u0001\u0010 \u0003\u0011iWo\u001d;\u000b\u0005\u0001\n\u0013\u0001C7bi\u000eDWM]:\u000b\u0005\t\u001a\u0012!C:dC2\fG/Z:u\u0013\t!SD\u0001\u0005NCR\u001c\u0007.\u001a:t!\t1\u0013&D\u0001(\u0015\tA3\"A\u0003qY\u0006t7/\u0003\u0002+O\tI1+\u0015'IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003%\tQ\u0002Z3gCVdGOW8oK&#W#A\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014\u0001\u0002;j[\u0016T\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029g\t1!l\u001c8f\u0013\u0012\fa\u0001^8ECR,GCA\u001eE!\rat(Q\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1q\n\u001d;j_:\u0004\"\u0001\u0010\"\n\u0005\rk$aA%oi\")Qi\u0001a\u0001\r\u0006\t1\u000f\u0005\u0002H\u001d:\u0011\u0001\n\u0014\t\u0003\u0013vj\u0011A\u0013\u0006\u0003\u0017V\ta\u0001\u0010:p_Rt\u0014BA'>\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055k\u0014a\b9fe6,H/Z,ji\"<\u0006.\u001b;fgB\f7-Z!oI\u000e{g\u000e\u001e:pYR\u00111\u000b\u0018\t\u0004)f3eBA+X\u001d\tIe+C\u0001?\u0013\tAV(A\u0004qC\u000e\\\u0017mZ3\n\u0005i[&aA*fc*\u0011\u0001,\u0010\u0005\u0006;\u0012\u0001\rAX\u0001\u0007m\u0006dW/Z:\u0011\u0007qzf)\u0003\u0002a{\tQAH]3qK\u0006$X\r\u001a \u0002\u0017Q|G+[7fgR\fW\u000e\u001d\u000b\u0004G\u001eL\u0007c\u0001\u001f@IB\u0011A(Z\u0005\u0003Mv\u0012A\u0001T8oO\")\u0001.\u0002a\u0001\r\u0006\u00191\u000f\u001e:\t\u000b),\u0001\u0019A\u0019\u0002\ri|g.Z%e\u0003%!Xm\u001d;UeVt7\rF\u0003naJ$h\u000f\u0005\u0002=]&\u0011q.\u0010\u0002\u0005+:LG\u000fC\u0003r\r\u0001\u0007\u0011)A\u0003mKZ,G\u000eC\u0003t\r\u0001\u0007a)\u0001\u0005fqB,7\r^3e\u0011\u0015)h\u00011\u0001e\u0003\u001dIg\u000e];u)NCqA\u001b\u0004\u0011\u0002\u0003\u0007\u0011'A\nuKN$HK];oG\u0012\"WMZ1vYR$C'F\u0001zU\t\t$pK\u0001|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0001>\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u000bi(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class DateTimeUtilsSuite
extends SparkFunSuite
implements Matchers,
SQLHelper {
    private String sparkHome;
    private Matchers.KeyWord key;
    private Matchers.ValueWord value;
    private Matchers.AWord a;
    private Matchers.AnWord an;
    private Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private Matchers.RegexWord regex;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    private Explicitly.DecidedWord decided;
    private Explicitly.DeterminedWord determined;
    private Explicitly.TheAfterWord after;
    private FullyMatchWord fullyMatch;
    private StartWithWord startWith;
    private EndWithWord endWith;
    private IncludeWord include;
    private HaveWord have;
    private BeWord be;
    private ContainWord contain;
    private NotWord not;
    private LengthWord length;
    private SizeWord size;
    private SortedWord sorted;
    private DefinedWord defined;
    private ExistWord exist;
    private ReadableWord readable;
    private WritableWord writable;
    private EmptyWord empty;
    private CompileWord compile;
    private TypeCheckWord typeCheck;
    private MatchPatternWord matchPattern;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(Iterable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(Iterable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(Iterable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(Iterable<Object> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(Iterable<Object> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(Iterable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(Iterable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(Iterable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, Iterable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> all(MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atLeast(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> every(MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> exactly(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atMost(int num, MAP xs, Collecting<Tuple2<K, V>, Iterable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyMustWrapper<T> convertToAnyMustWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyMustWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringMustWrapper convertToStringMustWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringMustWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public MustVerb.StringMustWrapperForVerb convertToStringMustWrapperForVerb(String o, Position position) {
        return MustVerb.convertToStringMustWrapperForVerb$((MustVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    private String sparkHome$lzycompute() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$AllCollected() {
        return this.org$scalatest$matchers$must$Matchers$$AllCollected;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$EveryCollected() {
        return this.org$scalatest$matchers$must$Matchers$$EveryCollected;
    }

    public Matchers$BetweenCollected$ org$scalatest$matchers$must$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$matchers$must$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$matchers$must$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers.Collected org$scalatest$matchers$must$Matchers$$NoCollected() {
        return this.org$scalatest$matchers$must$Matchers$$NoCollected;
    }

    public Matchers$ExactlyCollected$ org$scalatest$matchers$must$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers.MustMethodHelperClass org$scalatest$matchers$must$Matchers$$MustMethodHelper() {
        return this.org$scalatest$matchers$must$Matchers$$MustMethodHelper;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$matchers$must$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$AllCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$AllCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$EveryCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$EveryCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$NoCollected_$eq(Matchers.Collected x$1) {
        this.org$scalatest$matchers$must$Matchers$$NoCollected = x$1;
    }

    public final void org$scalatest$matchers$must$Matchers$_setter_$org$scalatest$matchers$must$Matchers$$MustMethodHelper_$eq(Matchers.MustMethodHelperClass x$1) {
        this.org$scalatest$matchers$must$Matchers$$MustMethodHelper = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$matchers$dsl$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    private ZoneId defaultZoneId() {
        return ZoneId.systemDefault();
    }

    private Option<Object> toDate(String s) {
        return DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)s));
    }

    private Seq<String> permuteWithWhitespaceAndControl(Seq<String> values) {
        return (Seq)values.flatMap((Function1 & Serializable)input -> new .colon.colon(input, (List)new .colon.colon((Object)"\u0003", (List)new .colon.colon((Object)"\u0003", (List)new .colon.colon((Object)" ", (List)new .colon.colon((Object)" ", (List)Nil$.MODULE$))))).permutations().map((Function1 & Serializable)x$3 -> x$3.mkString()));
    }

    private Option<Object> toTimestamp(String str, ZoneId zoneId) {
        return DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)str), zoneId);
    }

    public void testTrunc(int level, String expected, long inputTS, ZoneId zoneId) {
        long truncated = DateTimeUtils$.MODULE$.truncTimestamp(inputTS, level, zoneId);
        Option<Object> expectedTS = this.toTimestamp(expected, this.defaultZoneId());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)truncated));
        long $org_scalatest_assert_macro_right = BoxesRunTime.unboxToLong((Object)expectedTS.get());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
    }

    public ZoneId testTrunc$default$4() {
        return this.defaultZoneId();
    }

    private final void org$scalatest$matchers$must$Matchers$$BetweenCollected$lzycompute$1() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtLeastCollected$lzycompute$1() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$AtMostCollected$lzycompute$1() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$matchers$must$Matchers$$ExactlyCollected$lzycompute$1() {
        DateTimeUtilsSuite dateTimeUtilsSuite = this;
        synchronized (dateTimeUtilsSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final void checkStringToTimestamp$1(String originalTime, String expectedParsedTime, TimestampFormatter tf$1) {
        Option parsedTimestampOp = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)originalTime), this.defaultZoneId());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(parsedTimestampOp.isDefined(), "parsedTimestampOp.isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"timestamp with nanoseconds was not parsed correctly", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(tf$1.format(BoxesRunTime.unboxToLong((Object)parsedTimestampOp.get())));
        String $org_scalatest_assert_macro_right = expectedParsedTime;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }

    public static final /* synthetic */ Assertion $anonfun$new$3(DateTimeUtilsSuite $this, long t) {
        Timestamp ts = DateTimeUtils$.MODULE$.toJavaTimestamp(t);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(ts)));
        long $org_scalatest_assert_macro_right = t;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts)));
        Timestamp $org_scalatest_assert_macro_right2 = ts;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
    }

    private final void checkFromToJavaDate$1(Date d1) {
        Date d2 = DateTimeUtils$.MODULE$.toJavaDate(DateTimeUtils$.MODULE$.fromJavaDate(d1));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(d2.toString());
        String $org_scalatest_assert_macro_right = d1.toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
    }

    private final void checkStringToTimestamp$2(String str, Option expected, ZoneId zid$1) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toTimestamp(str, zid$1));
        Option $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
    }

    public static final /* synthetic */ void $anonfun$new$15(DateTimeUtilsSuite $this, ZoneId zid$1, String s) {
        int x$25 = 2015;
        int x$26 = 3;
        int x$27 = 18;
        ZoneId x$28 = zid$1;
        byte x$29 = DateTimeTestUtils$.MODULE$.date$default$4();
        byte x$30 = DateTimeTestUtils$.MODULE$.date$default$5();
        byte x$31 = DateTimeTestUtils$.MODULE$.date$default$6();
        int x$32 = DateTimeTestUtils$.MODULE$.date$default$7();
        $this.checkStringToTimestamp$2(s, Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, x$29, x$30, x$31, x$32, x$28))), zid$1);
    }

    public static final /* synthetic */ void $anonfun$new$14(DateTimeUtilsSuite $this, ZoneId zid) {
        int x$1 = 1969;
        int x$2 = 12;
        int x$3 = 31;
        int x$4 = 16;
        ZoneId x$5 = zid;
        byte x$6 = DateTimeTestUtils$.MODULE$.date$default$5();
        byte x$7 = DateTimeTestUtils$.MODULE$.date$default$6();
        int x$8 = DateTimeTestUtils$.MODULE$.date$default$7();
        $this.checkStringToTimestamp$2("1969-12-31 16:00:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1969, (byte)12, (byte)31, (byte)16, x$6, x$7, x$8, x$5))), zid);
        boolean x$9 = true;
        boolean x$10 = true;
        boolean x$11 = true;
        boolean x$12 = false;
        ZoneId x$13 = zid;
        byte x$14 = DateTimeTestUtils$.MODULE$.date$default$5();
        byte x$15 = DateTimeTestUtils$.MODULE$.date$default$6();
        int x$16 = DateTimeTestUtils$.MODULE$.date$default$7();
        $this.checkStringToTimestamp$2("0001", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, x$14, x$15, x$16, x$13))), zid);
        int x$17 = 2015;
        int x$18 = 3;
        boolean x$19 = true;
        ZoneId x$20 = zid;
        byte x$21 = DateTimeTestUtils$.MODULE$.date$default$4();
        byte x$22 = DateTimeTestUtils$.MODULE$.date$default$5();
        byte x$23 = DateTimeTestUtils$.MODULE$.date$default$6();
        int x$24 = DateTimeTestUtils$.MODULE$.date$default$7();
        $this.checkStringToTimestamp$2("2015-03", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)1, x$21, x$22, x$23, x$24, x$20))), zid);
        new .colon.colon((Object)"2015-03-18", (List)new .colon.colon((Object)"2015-03-18 ", (List)new .colon.colon((Object)" 2015-03-18", (List)new .colon.colon((Object)" 2015-03-18 ", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)s -> {
            DateTimeUtilsSuite.$anonfun$new$15($this, zid, s);
            return BoxedUnit.UNIT;
        });
        int x$33 = 2015;
        int x$34 = 3;
        int x$35 = 18;
        int x$36 = 12;
        int x$37 = 3;
        int x$38 = 17;
        ZoneId x$39 = zid;
        int x$40 = DateTimeTestUtils$.MODULE$.date$default$7();
        ObjectRef expected = ObjectRef.create((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$40, x$39))));
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17", (Option)expected.elem, zid);
        ZoneId zoneId = DateTimeUtils$.MODULE$.getZoneId("-13:53");
        int x$41 = 2015;
        int x$42 = 3;
        int x$43 = 18;
        int x$44 = 12;
        int x$45 = 3;
        int x$46 = 17;
        ZoneId x$47 = zoneId;
        int x$48 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$48, x$47)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-13:53", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17GMT-13:53", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-1353", (Option)expected.elem, zid);
        int x$49 = 2015;
        int x$50 = 3;
        int x$51 = 18;
        int x$52 = 12;
        int x$53 = 3;
        int x$54 = 17;
        ZoneId x$55 = DateTimeTestUtils$.MODULE$.UTC();
        int x$56 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$56, x$55)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17Z", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17Z", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17UTC", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("-01:00");
        int x$57 = 2015;
        int x$58 = 3;
        int x$59 = 18;
        int x$60 = 12;
        int x$61 = 3;
        int x$62 = 17;
        ZoneId x$63 = zoneId;
        int x$64 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$64, x$63)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-1:0", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-01:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17GMT-01:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-0100", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        int x$65 = 2015;
        int x$66 = 3;
        int x$67 = 18;
        int x$68 = 12;
        int x$69 = 3;
        int x$70 = 17;
        ZoneId x$71 = zoneId;
        int x$72 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$72, x$71)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17 GMT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17+0730", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:03");
        int x$73 = 2015;
        int x$74 = 3;
        int x$75 = 18;
        int x$76 = 12;
        int x$77 = 3;
        int x$78 = 17;
        ZoneId x$79 = zoneId;
        int x$80 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$80, x$79)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17+07:03", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17GMT+07:03", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17+0703", (Option)expected.elem, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123000, zid)));
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17.123", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123", (Option)expected.elem, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 456000, DateTimeTestUtils$.MODULE$.UTC())));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.456Z", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17.456Z", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18 12:03:17.456 UTC", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("-01:00");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123000, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123-1:0", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123-01:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123 GMT-01:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123-0100", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123000, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123 GMT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+0730", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123000, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123GMT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+0730", (Option)expected.elem, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123121, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123121+7:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123121 GMT+0730", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123120, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.12312+7:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.12312 UT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.12312+0730", (Option)expected.elem, zid);
        int x$81 = 18;
        int x$82 = 12;
        int x$83 = 15;
        ZoneId x$84 = zid;
        int x$85 = DateTimeTestUtils$.MODULE$.time$default$4();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.time((byte)18, (byte)12, (byte)15, x$85, x$84)));
        $this.checkStringToTimestamp$2("18:12:15", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.time((byte)18, (byte)12, (byte)15, 123120, zoneId)));
        $this.checkStringToTimestamp$2("T18:12:15.12312+7:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("T18:12:15.12312 UTC+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("T18:12:15.12312+0730", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("+07:30");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.time((byte)18, (byte)12, (byte)15, 123120, zoneId)));
        $this.checkStringToTimestamp$2("18:12:15.12312+7:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("18:12:15.12312 GMT+07:30", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("18:12:15.12312+0730", (Option)expected.elem, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2011, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, 100000, zid)));
        $this.checkStringToTimestamp$2("2011-05-06 07:08:09.1000", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("238", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18 123142", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T123123", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18X", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015/03/18", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015.03.18", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("20150318", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-031-8", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("015-01-18", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03.17-20:0", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03.17-0:70", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03.17-1:0:0", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("1999 08 01", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("1999-08 01", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("1999 08", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("    ", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("+", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("T", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("12::", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-8:", (Option)None$.MODULE$, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17-8:30:", (Option)None$.MODULE$, zid);
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123456, DateTimeTestUtils$.MODULE$.UTC())));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123456789+0:00", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123456789 UTC+0", (Option)expected.elem, zid);
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123456789GMT+00:00", (Option)expected.elem, zid);
        zoneId = DateTimeUtils$.MODULE$.getZoneId("Europe/Moscow");
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, 123456, zoneId)));
        $this.checkStringToTimestamp$2("2015-03-18T12:03:17.123456 Europe/Moscow", (Option)expected.elem, zid);
        int x$86 = 2015;
        int x$87 = 3;
        int x$88 = 18;
        int x$89 = 12;
        int x$90 = 3;
        int x$91 = 17;
        ZoneId x$92 = zid;
        int x$93 = DateTimeTestUtils$.MODULE$.date$default$7();
        expected.elem = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)12, (byte)3, (byte)17, x$93, x$92)));
        $this.permuteWithWhitespaceAndControl((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2015-03-18 12:03:17", "2015-03-18T12:03:17"})).foreach((Function1 & Serializable)s -> {
            $this.checkStringToTimestamp$2(s, (Option)expected.elem, zid);
            return BoxedUnit.UNIT;
        });
        $this.permuteWithWhitespaceAndControl((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"INVALID_INPUT", "\t", "", "2015-03-18\u000312:03:17", "2015-03-18 12:", "2015-03-18 123"})).foreach((Function1 & Serializable)s -> {
            $this.checkStringToTimestamp$2(s, (Option)None$.MODULE$, zid);
            return BoxedUnit.UNIT;
        });
    }

    private final void checkStringToTimestamp$3(String str, Option expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toTimestamp(str, DateTimeTestUtils$.MODULE$.UTC()));
        Option $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
    }

    public static final /* synthetic */ Assertion $anonfun$new$28(DateTimeUtilsSuite $this, int year) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(DateTimeTestUtils$.MODULE$.days(year, DateTimeTestUtils$.MODULE$.days$default$2(), DateTimeTestUtils$.MODULE$.days$default$3()))));
        int $org_scalatest_assert_macro_right = year;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(DateTimeTestUtils$.MODULE$.days(year, (byte)1, DateTimeTestUtils$.MODULE$.days$default$3()))));
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(DateTimeTestUtils$.MODULE$.days(year, (byte)1, (byte)1))));
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        int date = DateTimeTestUtils$.MODULE$.days(year, (byte)12, (byte)31);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(date)));
        int $org_scalatest_assert_macro_right4 = year;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(date)));
        int $org_scalatest_assert_macro_right5 = 12;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(date)));
        int $org_scalatest_assert_macro_right6 = 31;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
    }

    public static final /* synthetic */ void $anonfun$new$35(DateTimeUtilsSuite $this, ZoneId zid) {
        new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)13, (byte)21, (byte)28, (byte)13, 123456, zid)), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)13, (byte)21, (byte)28, (byte)13, 123456, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)31, (byte)0, (byte)0, (byte)0, 123, zid)), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)2, (byte)28, (byte)0, (byte)0, (byte)0, 123, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2020, (byte)2, (byte)29, (byte)1, (byte)2, (byte)3, 4, zid)), (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)2, (byte)28, (byte)1, (byte)2, (byte)3, 4, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, zid)), (Object)BoxesRunTime.boxToInteger((int)24240), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2021, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1581, (byte)10, (byte)7, (byte)23, (byte)59, (byte)59, 999, zid)), (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1582, (byte)10, (byte)7, (byte)23, (byte)59, (byte)59, 999, zid))), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(9999, (byte)12, (byte)31, (byte)23, (byte)59, (byte)59, 999999, zid)), (Object)BoxesRunTime.boxToInteger((int)-11), (Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)31, (byte)23, (byte)59, (byte)59, 999999, zid))), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                long timestamp = BoxesRunTime.unboxToLong((Object)tuple3._1());
                int months = BoxesRunTime.unboxToInt((Object)tuple3._2());
                long expected = BoxesRunTime.unboxToLong((Object)tuple3._3());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddMonths(timestamp, months, zid)));
                long $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public static final /* synthetic */ Assertion $anonfun$new$42(DateTimeUtilsSuite $this, LongRef date2$1, long date1$1, boolean roundOff) {
        date2$1.elem = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)28, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1$1, date2$1.elem, roundOff, DateTimeTestUtils$.MODULE$.UTC())));
        int $org_scalatest_assert_macro_right = -36;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
        date2$1.elem = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)29, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1$1, date2$1.elem, roundOff, DateTimeTestUtils$.MODULE$.UTC())));
        int $org_scalatest_assert_macro_right2 = -36;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
        date2$1.elem = DateTimeTestUtils$.MODULE$.date(1996, (byte)3, (byte)31, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1$1, date2$1.elem, roundOff, DateTimeTestUtils$.MODULE$.UTC())));
        int $org_scalatest_assert_macro_right3 = 11;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
    }

    private final void test$1(String utc, String tz, String expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(utc)), tz)).toString());
        String $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
    }

    private final void test$2(String utc, String tz, String expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.toUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(utc)), tz)).toString());
        String $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
    }

    public static final /* synthetic */ Object $anonfun$new$66(DateTimeUtilsSuite $this, Set skipped$1, ZoneId zid$5, int d) {
        if (!skipped$1.contains((Object)BoxesRunTime.boxToInteger((int)d))) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.microsToDays(DateTimeUtils$.MODULE$.daysToMicros(d, zid$5), zid$5)));
            int $org_scalatest_assert_macro_right = d;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Round trip of " + d + " did not work in tz " + zid$5.getId()), Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 828));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$63(DateTimeUtilsSuite $this, scala.collection.immutable.Map skipped_days$1, ZoneId zid) {
        Set skipped = (Set)skipped_days$1.getOrElse((Object)zid.getId(), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        Seq testingData = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-20000, 20000})).$plus$plus((IterableOnce)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000).map((Function1)(JFunction1.mcII.sp & Serializable)x$4 -> (int)(package$.MODULE$.random() * (double)40000 - (double)20000)));
        testingData.foreach((Function1 & Serializable)d -> DateTimeUtilsSuite.$anonfun$new$66($this, skipped, zid, BoxesRunTime.unboxToInt((Object)d)));
    }

    public static final /* synthetic */ void $anonfun$new$80(DateTimeUtilsSuite $this, ZoneId zid) {
        scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1000, 2, 28, 1, 2, 3, 456789000), (Object)LocalDateTime.of(1000, 3, 1, 1, 2, 3, 456789000))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.DAYS.toMicros(1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1582, 10, 4, 23, 59, 59, 999999000), (Object)LocalDateTime.of(1582, 10, 15, 23, 59, 59, 999999000))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.DAYS.toMicros(11L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1883, 11, 20, 0, 0, 0, 123456000), (Object)LocalDateTime.of(1883, 11, 10, 0, 0, 0))), (Object)BoxesRunTime.boxToLong((long)(TimeUnit.DAYS.toMicros(-10L) - 123456L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1900, 1, 1, 0, 0, 0, 1000), (Object)LocalDateTime.of(1899, 12, 31, 23, 59, 59, 999999000))), (Object)BoxesRunTime.boxToInteger((int)-2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1945, 11, 18, 0, 30, 30), (Object)LocalDateTime.of(1945, 11, 18, 1, 30, 30))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.HOURS.toMicros(1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1945, 11, 18, 2, 0, 0), (Object)LocalDateTime.of(1945, 11, 18, 1, 0, 0))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.HOURS.toMicros(-1L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(1970, 1, 1, 0, 0, 0), (Object)LocalDateTime.of(1970, 1, 1, 0, 0, 0))), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(2020, 2, 29, 0, 0, 0), (Object)LocalDateTime.of(2021, 3, 1, 0, 0, 0))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.DAYS.toMicros(366L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)LocalDateTime.of(2021, 3, 14, 1, 0, 0), (Object)LocalDateTime.of(2021, 3, 14, 3, 0, 0))), (Object)BoxesRunTime.boxToLong((long)TimeUnit.HOURS.toMicros(2L)))})).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Object expected = tuple2._2();
                if (tuple22 != null) {
                    LocalDateTime start = (LocalDateTime)tuple22._1();
                    LocalDateTime end = (LocalDateTime)tuple22._2();
                    long startMicros = DateTimeTestUtils$.MODULE$.localDateTimeToMicros(start, zid);
                    long endMicros = DateTimeTestUtils$.MODULE$.localDateTimeToMicros(end, zid);
                    long result = DateTimeUtils$.MODULE$.subtractTimestamps(endMicros, startMicros, zid);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)result));
                    Object $org_scalatest_assert_macro_right = expected;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 977));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public DateTimeUtilsSuite() {
        Tolerance.$init$((Tolerance)this);
        MustVerb.$init$((MustVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.test("nanoseconds truncation", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TimestampFormatter tf = TimestampFormatter$.MODULE$.getFractionFormatter(ZoneId.systemDefault());
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.123456789", "2015-01-02 00:00:00.123456", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.100000009", "2015-01-02 00:00:00.1", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.000050000", "2015-01-02 00:00:00.00005", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.12005", "2015-01-02 00:00:00.12005", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.100", "2015-01-02 00:00:00.1", tf);
            this.checkStringToTimestamp$1("2015-01-02 00:00:00.000456789", "2015-01-02 00:00:00.000456", tf);
            this.checkStringToTimestamp$1("1950-01-02 00:00:00.000456789", "1950-01-02 00:00:00.000456", tf);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("timestamp and us", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            now.setNanos(1000);
            long ns = DateTimeUtils$.MODULE$.fromJavaTimestamp(now);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)(ns % 1000000L)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(ns));
            Timestamp $org_scalatest_assert_macro_right2 = now;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            ((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-111111111111L, -1L, 0L, 1L, 111111111111L}))).foreach((Function1 & Serializable)t -> DateTimeUtilsSuite.$anonfun$new$3(this, BoxesRunTime.unboxToLong((Object)t)));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("us and julian day", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(0L));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int d = tuple2._1$mcI$sp();
            long ns = tuple2._2$mcJ$sp();
            Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(d, ns);
            int d2 = sp2._1$mcI$sp();
            long ns2 = sp2._2$mcJ$sp();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)d2));
            int $org_scalatest_assert_macro_right = 2440588;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)ns2));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            long $org_scalatest_assert_macro_left3 = RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(DateTimeUtils$.MODULE$.fromJulianDay(d2, ns2));
            long $org_scalatest_assert_macro_right3 = 0L;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            new .colon.colon((Object)Timestamp.valueOf("2015-06-11 10:10:10.100"), (List)new .colon.colon((Object)Timestamp.valueOf("2015-06-11 20:10:10.100"), (List)new .colon.colon((Object)Timestamp.valueOf("1900-06-11 20:10:10.100"), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)t -> {
                long ns;
                Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(DateTimeUtils$.MODULE$.fromJavaTimestamp(t)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int d = tuple2._1$mcI$sp();
                long ns2 = tuple2._2$mcJ$sp();
                Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(d, ns2);
                int d2 = sp2._1$mcI$sp();
                long $org_scalatest_assert_macro_left = ns = sp2._2$mcJ$sp();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                Timestamp t1 = DateTimeUtils$.MODULE$.toJavaTimestamp(RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(DateTimeUtils$.MODULE$.fromJulianDay(d2, ns)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(t.equals(t1), "t.equals(t1)", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("SPARK-6785: java date conversion before and after epoch", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
            this.checkFromToJavaDate$1(new Date(100L));
            this.checkFromToJavaDate$1(Date.valueOf("1970-01-01"));
            this.checkFromToJavaDate$1(new Date(df1.parse("1970-01-01 00:00:00").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1970-01-01 00:00:00 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1970-01-01 00:00:01").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1970-01-01 00:00:01 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1969-12-31 23:59:59").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1969-12-31 23:59:59 UTC").getTime()));
            this.checkFromToJavaDate$1(Date.valueOf("1969-01-01"));
            this.checkFromToJavaDate$1(new Date(df1.parse("1969-01-01 00:00:00").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1969-01-01 00:00:00 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1969-01-01 00:00:01").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1969-01-01 00:00:01 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1989-11-09 11:59:59").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1989-11-09 19:59:59 UTC").getTime()));
            this.checkFromToJavaDate$1(new Date(df1.parse("1776-07-04 10:30:00").getTime()));
            this.checkFromToJavaDate$1(new Date(df2.parse("1776-07-04 18:30:00 UTC").getTime()));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("SPARK-32559: string to date trim Control Characters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int expected = DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18);
            this.permuteWithWhitespaceAndControl((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"2015-03-18", "2015-03-18T123321", " 2015-03-18 123321", "+2015-03-18"})).foreach((Function1 & Serializable)s -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toDate((String)s).get());
                int $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            });
            this.permuteWithWhitespaceAndControl((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"INVALID_INPUT", " ", "1999-08-", "2015-03-18\u0003123321", "2015-03-18Q123321"})).foreach((Function1 & Serializable)s -> {
                Option<Object> $org_scalatest_assert_macro_left = this.toDate((String)s);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("string to date", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toDate("2015-01-28").get());
            int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2015, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.toDate("2015").get());
            int $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.days(2015, (byte)1, (byte)1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.toDate("0001").get());
            int $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.days(1, (byte)1, (byte)1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.toDate("2015-03").get());
            int $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            new .colon.colon((Object)"2015-03-18", (List)new .colon.colon((Object)"2015-03-18 ", (List)new .colon.colon((Object)" 2015-03-18", (List)new .colon.colon((Object)" 2015-03-18 ", (List)new .colon.colon((Object)"2015-03-18 123142", (List)new .colon.colon((Object)"2015-03-18T123123", (List)new .colon.colon((Object)"2015-03-18T", (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)s -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toDate((String)s).get());
                int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            });
            Option<Object> $org_scalatest_assert_macro_left5 = this.toDate("2015-03-18X");
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            Option<Object> $org_scalatest_assert_macro_left6 = this.toDate("2015/03/18");
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            Option<Object> $org_scalatest_assert_macro_left7 = this.toDate("2015.03.18");
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            Option<Object> $org_scalatest_assert_macro_left8 = this.toDate("20150318");
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            Option<Object> $org_scalatest_assert_macro_left9 = this.toDate("2015-031-8");
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left9, "isEmpty", $org_scalatest_assert_macro_left9.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            Option<Object> $org_scalatest_assert_macro_left10 = this.toDate("015-03-18");
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            Option<Object> $org_scalatest_assert_macro_left11 = this.toDate("015");
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            Option<Object> $org_scalatest_assert_macro_left12 = this.toDate("1999 08 01");
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            Option<Object> $org_scalatest_assert_macro_left13 = this.toDate("1999-08 01");
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left13, "isEmpty", $org_scalatest_assert_macro_left13.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            Option<Object> $org_scalatest_assert_macro_left14 = this.toDate("1999 08");
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left14, "isEmpty", $org_scalatest_assert_macro_left14.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            Option<Object> $org_scalatest_assert_macro_left15 = this.toDate("1999-08-");
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left15, "isEmpty", $org_scalatest_assert_macro_left15.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Option<Object> $org_scalatest_assert_macro_left16 = this.toDate("");
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left16, "isEmpty", $org_scalatest_assert_macro_left16.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            Option<Object> $org_scalatest_assert_macro_left17 = this.toDate("   ");
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left17, "isEmpty", $org_scalatest_assert_macro_left17.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            Option<Object> $org_scalatest_assert_macro_left18 = this.toDate("+");
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left18, "isEmpty", $org_scalatest_assert_macro_left18.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            Option<Object> $org_scalatest_assert_macro_left19 = this.toDate("-");
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left19, "isEmpty", $org_scalatest_assert_macro_left19.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            Option<Object> $org_scalatest_assert_macro_left20 = this.toDate("xxx2015-01-28");
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left20, "isEmpty", $org_scalatest_assert_macro_left20.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Option<Object> $org_scalatest_assert_macro_left21 = this.toDate("--2015-01-28");
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left21, "isEmpty", $org_scalatest_assert_macro_left21.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("SPARK-35780: support full range of date string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.toDate("02015-03-18").get());
            int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.toDate("02015").get());
            int $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.days(2015, (byte)1, (byte)1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.toDate("-02015").get());
            int $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.days(-2015, (byte)1, (byte)1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.toDate("999999-1-28").get());
            int $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.days(999999, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(this.toDate("-999999-1-28").get());
            int $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.days(-999999, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(this.toDate("0001-1-28").get());
            int $org_scalatest_assert_macro_right6 = DateTimeTestUtils$.MODULE$.days(1, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.toDate("5881580-7-11").get());
            int $org_scalatest_assert_macro_right7 = DateTimeTestUtils$.MODULE$.days(5881580, (byte)7, (byte)11);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            Option<Object> $org_scalatest_assert_macro_left8 = this.toDate("5881580-7-12");
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(this.toDate("-5877641-6-23").get());
            int $org_scalatest_assert_macro_right8 = DateTimeTestUtils$.MODULE$.days(-5877641, (byte)6, (byte)23);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            Option<Object> $org_scalatest_assert_macro_left10 = this.toDate("-5877641-6-22");
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            Option<Object> $org_scalatest_assert_macro_left11 = this.toDate("4294967297");
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            Option<Object> $org_scalatest_assert_macro_left12 = this.toDate("2021-4294967297-11");
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("string to timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
            DateTimeUtilsSuite.$anonfun$new$14(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("SPARK-35780: support full range of timestamp string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$94 = -1969;
            int x$95 = 12;
            int x$96 = 31;
            int x$97 = 16;
            ZoneId x$98 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$99 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$100 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$101 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("-1969-12-31 16:00:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(-1969, (byte)12, (byte)31, (byte)16, x$99, x$100, x$101, x$98))));
            int x$102 = 2015;
            int x$103 = 3;
            int x$104 = 18;
            int x$105 = 16;
            ZoneId x$106 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$107 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$108 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$109 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("02015-03-18 16:00:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)16, x$107, x$108, x$109, x$106))));
            boolean x$110 = true;
            boolean x$111 = true;
            boolean x$112 = true;
            boolean x$113 = false;
            ZoneId x$114 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$115 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$116 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$117 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("000001", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, x$115, x$116, x$117, x$114))));
            int x$118 = -1;
            boolean x$119 = true;
            boolean x$120 = true;
            boolean x$121 = false;
            ZoneId x$122 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$123 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$124 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$125 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("-000001", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(-1, (byte)1, (byte)1, (byte)0, x$123, x$124, x$125, x$122))));
            int x$126 = 238;
            boolean x$127 = true;
            boolean x$128 = true;
            boolean x$129 = false;
            ZoneId x$130 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$131 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$132 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$133 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("00238", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(238, (byte)1, (byte)1, (byte)0, x$131, x$132, x$133, x$130))));
            int x$134 = 99999;
            int x$135 = 3;
            boolean x$136 = true;
            int x$137 = 12;
            int x$138 = 3;
            int x$139 = 17;
            ZoneId x$140 = DateTimeTestUtils$.MODULE$.UTC();
            int x$141 = DateTimeTestUtils$.MODULE$.date$default$7();
            this.checkStringToTimestamp$3("99999-03-01T12:03:17", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(99999, (byte)3, (byte)1, (byte)12, (byte)3, (byte)17, x$141, x$140))));
            this.checkStringToTimestamp$3("+12:12:12", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("-12:12:12", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("    ", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("+", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("294247-01-10T04:00:54.775807Z", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(294247, (byte)1, (byte)10, (byte)4, (byte)0, (byte)54, 775807, DateTimeTestUtils$.MODULE$.UTC()))));
            this.checkStringToTimestamp$3("294247-01-10T04:00:54.775808Z", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("-290308-12-21T19:59:05.224192Z", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)DateTimeTestUtils$.MODULE$.date(-290308, (byte)12, (byte)21, (byte)19, (byte)59, (byte)5, 224192, DateTimeTestUtils$.MODULE$.UTC()))));
            this.checkStringToTimestamp$3("-290308-12-21T19:59:05.224191Z", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("4294967297", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-4294967297-11", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("4294967297:30:00", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-11-4294967297T12:30:00", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:4294967297:00", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297.123456", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297+07:30", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297UTC", (Option)None$.MODULE$);
            this.checkStringToTimestamp$3("2021-01-01T12:30:4294967297+4294967297:30", (Option)None$.MODULE$);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        this.test("SPARK-37326: stringToTimestampWithoutTimeZone with allowTimeZone", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.stringToTimestampWithoutTimeZone(UTF8String.fromString((String)"2021-11-22 10:54:27 +08:00"), true);
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.of(2021, 11, 22, 10, 54, 27))));
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            Option $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.stringToTimestampWithoutTimeZone(UTF8String.fromString((String)"2021-11-22 10:54:27 +08:00"), false);
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Option option2 = $org_scalatest_assert_macro_left2;
            None$ none$ = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
        this.test("SPARK-15379: special invalid date string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option<Object> $org_scalatest_assert_macro_left = this.toDate("2015-02-29 00:00:00");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
            Option<Object> $org_scalatest_assert_macro_left2 = this.toDate("2015-04-31 00:00:00");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
            Option<Object> $org_scalatest_assert_macro_left3 = this.toDate("2015-02-29");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
            Option<Object> $org_scalatest_assert_macro_left4 = this.toDate("2015-04-31");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            Option $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-02-29 00:00:00"), this.defaultZoneId());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
            Option $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-31 00:00:00"), this.defaultZoneId());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            Option<Object> $org_scalatest_assert_macro_left7 = this.toTimestamp("2015-02-29", this.defaultZoneId());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
            Option<Object> $org_scalatest_assert_macro_left8 = this.toTimestamp("2015-04-31", this.defaultZoneId());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        this.test("hours", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)13, (byte)2, (byte)11, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right = 13;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right2 = 20;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
            input = DateTimeTestUtils$.MODULE$.date(2015, (byte)12, (byte)8, (byte)2, (byte)7, (byte)9, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right4 = 10;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
            input = DateTimeTestUtils$.MODULE$.date(10, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
        this.test("minutes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)13, (byte)2, (byte)11, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeUtils$.MODULE$.getZoneId("Australia/North"))));
            int $org_scalatest_assert_macro_right3 = 32;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
            input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)8, (byte)2, (byte)7, (byte)9, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right4 = 7;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right5 = 7;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeUtils$.MODULE$.getZoneId("Australia/North"))));
            int $org_scalatest_assert_macro_right6 = 37;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
            input = DateTimeTestUtils$.MODULE$.date(10, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        this.test("seconds", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)18, (byte)13, (byte)2, (byte)11, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right = 11;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right2 = 11;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
            input = DateTimeTestUtils$.MODULE$.date(2015, (byte)3, (byte)8, (byte)2, (byte)7, (byte)9, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right3 = 9;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right4 = 9;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
            input = DateTimeTestUtils$.MODULE$.date(10, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        this.test("hours / minutes / seconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Timestamp.valueOf("2015-06-11 10:12:35.789"), (List)new .colon.colon((Object)Timestamp.valueOf("2015-06-11 20:13:40.789"), (List)new .colon.colon((Object)Timestamp.valueOf("1900-06-11 12:14:50.789"), (List)new .colon.colon((Object)Timestamp.valueOf("1700-02-28 12:14:50.123456"), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)t -> {
            long us = DateTimeUtils$.MODULE$.fromJavaTimestamp(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(us));
            Timestamp $org_scalatest_assert_macro_right = t;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        this.test("get day in year", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18))));
            int $org_scalatest_assert_macro_right = 77;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(DateTimeTestUtils$.MODULE$.days(2012, (byte)3, (byte)18))));
            int $org_scalatest_assert_macro_right2 = 78;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        this.test("day of year calculations for old years", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(DateTimeTestUtils$.MODULE$.days(1582, (byte)3, DateTimeTestUtils$.MODULE$.days$default$3()))));
            int $org_scalatest_assert_macro_right = 60;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1000), 1600).by(10).foreach((Function1 & Serializable)year -> DateTimeUtilsSuite.$anonfun$new$28(this, BoxesRunTime.unboxToInt((Object)year)));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        this.test("get year", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(DateTimeTestUtils$.MODULE$.days(2015, (byte)2, (byte)18))));
            int $org_scalatest_assert_macro_right = 2015;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(DateTimeTestUtils$.MODULE$.days(2012, (byte)2, (byte)18))));
            int $org_scalatest_assert_macro_right2 = 2012;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
        this.test("get quarter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getQuarter(DateTimeTestUtils$.MODULE$.days(2015, (byte)2, (byte)18))));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getQuarter(DateTimeTestUtils$.MODULE$.days(2012, (byte)11, (byte)18))));
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
        this.test("get month", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18))));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(DateTimeTestUtils$.MODULE$.days(2012, (byte)12, (byte)18))));
            int $org_scalatest_assert_macro_right2 = 12;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        this.test("get day of month", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(DateTimeTestUtils$.MODULE$.days(2015, (byte)3, (byte)18))));
            int $org_scalatest_assert_macro_right = 18;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(DateTimeTestUtils$.MODULE$.days(2012, (byte)12, (byte)24))));
            int $org_scalatest_assert_macro_right2 = 24;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
        this.test("date add months", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int input = DateTimeTestUtils$.MODULE$.days(1997, (byte)2, (byte)28);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(input, 36)));
            int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2000, (byte)2, (byte)28);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(input, -13)));
            int $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.days(1996, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
        this.test("SPARK-34739: timestamp add months", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
            DateTimeUtilsSuite.$anonfun$new$35(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        this.test("date add interval with day precision", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int input = DateTimeTestUtils$.MODULE$.days(1997, (byte)2, (byte)28);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddInterval(input, new CalendarInterval(36, 0, 0L))));
            int $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.days(2000, (byte)2, (byte)28);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddInterval(input, new CalendarInterval(36, 47, 0L))));
            int $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.days(2000, (byte)4, (byte)15);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddInterval(input, new CalendarInterval(-13, 0, 0L))));
            int $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.days(1996, (byte)1, (byte)28);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
            this.checkError((SparkThrowable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> DateTimeUtils$.MODULE$.dateAddInterval(input, new CalendarInterval(36, 47, 1L)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543)), "INVALID_INTERVAL_WITH_MICROSECONDS_ADDITION", this.checkError$default$3(), this.checkError$default$4(), this.checkError$default$5(), this.checkError$default$6());
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        this.test("timestamp add interval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long ts1 = DateTimeTestUtils$.MODULE$.date(1997, (byte)2, (byte)28, (byte)10, (byte)30, (byte)0, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            long ts2 = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)28, (byte)10, (byte)30, (byte)0, 123000, DateTimeTestUtils$.MODULE$.date$default$8());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts1, 36, 0, 123000L, this.defaultZoneId())));
            long $org_scalatest_assert_macro_right = ts2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            long ts3 = DateTimeTestUtils$.MODULE$.date(1997, (byte)2, (byte)27, (byte)16, (byte)0, (byte)0, 0, DateTimeTestUtils$.MODULE$.LA());
            long ts4 = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)27, (byte)16, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts5 = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)28, (byte)0, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.UTC());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 36, 0, 123000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right2 = ts4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 36, 0, 123000L, DateTimeTestUtils$.MODULE$.UTC())));
            long $org_scalatest_assert_macro_right3 = ts5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
        this.test("timestamp add days", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long ts1 = DateTimeTestUtils$.MODULE$.date(2019, (byte)3, (byte)9, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts2 = DateTimeTestUtils$.MODULE$.date(2019, (byte)3, (byte)10, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts3 = DateTimeTestUtils$.MODULE$.date(2019, (byte)5, (byte)9, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts4 = DateTimeTestUtils$.MODULE$.date(2019, (byte)5, (byte)10, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts5 = DateTimeTestUtils$.MODULE$.date(2019, (byte)11, (byte)2, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            long ts6 = DateTimeTestUtils$.MODULE$.date(2019, (byte)11, (byte)3, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts1, 0, 0, 82800000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right = ts2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts1, 0, 1, 0L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right2 = ts2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 0, 0, 86400000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right3 = ts4;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 0, 1, 0L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right4 = ts4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts5, 0, 0, 90000000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right5 = ts6;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts5, 0, 1, 0L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right6 = ts6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
        this.test("monthsBetween", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            long date1 = DateTimeTestUtils$.MODULE$.date(1997, (byte)2, (byte)28, (byte)10, (byte)30, (byte)0, DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8());
            LongRef date2 = LongRef.create((long)DateTimeTestUtils$.MODULE$.date(1996, (byte)10, (byte)30, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1, date2.elem, true, DateTimeTestUtils$.MODULE$.UTC())));
            double $org_scalatest_assert_macro_right = 3.94959677;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date1, date2.elem, false, DateTimeTestUtils$.MODULE$.UTC())));
            double $org_scalatest_assert_macro_right2 = 3.9495967741935485;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)roundOff -> DateTimeUtilsSuite.$anonfun$new$42(this, date2, date1, BoxesRunTime.unboxToBoolean((Object)roundOff)));
            int x$142 = 2000;
            int x$143 = 2;
            int x$144 = 28;
            int x$145 = 16;
            ZoneId x$146 = DateTimeTestUtils$.MODULE$.LA();
            byte x$147 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$148 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$149 = DateTimeTestUtils$.MODULE$.date$default$7();
            long date3 = DateTimeTestUtils$.MODULE$.date(2000, (byte)2, (byte)28, (byte)16, x$147, x$148, x$149, x$146);
            int x$150 = 1997;
            int x$151 = 2;
            int x$152 = 28;
            int x$153 = 16;
            ZoneId x$154 = DateTimeTestUtils$.MODULE$.LA();
            byte x$155 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$156 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$157 = DateTimeTestUtils$.MODULE$.date$default$7();
            long date4 = DateTimeTestUtils$.MODULE$.date(1997, (byte)2, (byte)28, (byte)16, x$155, x$156, x$157, x$154);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date3, date4, true, DateTimeTestUtils$.MODULE$.LA())));
            double $org_scalatest_assert_macro_right3 = 36.0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date3, date4, true, DateTimeTestUtils$.MODULE$.UTC())));
            double $org_scalatest_assert_macro_right4 = 35.90322581;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(date3, date4, false, DateTimeTestUtils$.MODULE$.UTC())));
            double $org_scalatest_assert_macro_right5 = 35.903225806451616;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
        this.test("from UTC timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)tz -> {
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(tz, (JFunction0.mcV.sp & Serializable)() -> {
                    $this.test$1("2011-12-25 09:00:00.123456", "UTC", "2011-12-25 09:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", DateTimeTestUtils$.MODULE$.JST().getId(), "2011-12-25 18:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", DateTimeTestUtils$.MODULE$.LA().getId(), "2011-12-25 01:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "Asia/Shanghai", "2011-12-25 17:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "-7", "2011-12-25 02:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "+8:00", "2011-12-25 17:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "+8:00:00", "2011-12-25 17:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "+0800", "2011-12-25 17:00:00.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "-071020", "2011-12-25 01:49:40.123456");
                    $this.test$1("2011-12-25 09:00:00.123456", "-07:10:20", "2011-12-25 01:49:40.123456");
                });
                return BoxedUnit.UNIT;
            });
            DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.LA(), (JFunction0.mcV.sp & Serializable)() -> {
                this.test$1("2016-03-13 09:59:59.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-03-13 01:59:59.0");
                this.test$1("2016-03-13 10:00:00.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-03-13 03:00:00.0");
                this.test$1("2016-11-06 08:59:59.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-11-06 01:59:59.0");
                this.test$1("2016-11-06 09:00:00.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-11-06 01:00:00.0");
                this.test$1("2016-11-06 10:00:00.0", DateTimeTestUtils$.MODULE$.LA().getId(), "2016-11-06 02:00:00.0");
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
        this.test("to UTC timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zid, (JFunction0.mcV.sp & Serializable)() -> {
                    $this.test$2("2011-12-25 09:00:00.123456", "UTC", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 18:00:00.123456", DateTimeTestUtils$.MODULE$.JST().getId(), "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 01:00:00.123456", DateTimeTestUtils$.MODULE$.LA().getId(), "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 17:00:00.123456", "Asia/Shanghai", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 02:00:00.123456", "-7", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 17:00:00.123456", "+8:00", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 17:00:00.123456", "+8:00:00", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 17:00:00.123456", "+0800", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 01:49:40.123456", "-071020", "2011-12-25 09:00:00.123456");
                    $this.test$2("2011-12-25 01:49:40.123456", "-07:10:20", "2011-12-25 09:00:00.123456");
                });
                return BoxedUnit.UNIT;
            });
            DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.LA(), (JFunction0.mcV.sp & Serializable)() -> {
                String tz = DateTimeTestUtils$.MODULE$.LA().getId();
                this.test$2("2016-03-13 01:59:59", tz, "2016-03-13 09:59:59.0");
                this.test$2("2016-03-13 02:00:00", tz, "2016-03-13 10:00:00.0");
                this.test$2("2016-03-13 03:00:00", tz, "2016-03-13 10:00:00.0");
                this.test$2("2016-11-06 00:59:59", tz, "2016-11-06 07:59:59.0");
                this.test$2("2016-11-06 01:00:00", tz, "2016-11-06 09:00:00.0");
                this.test$2("2016-11-06 01:59:59", tz, "2016-11-06 09:59:59.0");
                this.test$2("2016-11-06 02:00:00", tz, "2016-11-06 10:00:00.0");
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        this.test("trailing characters while converting string to timestamp", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option time;
            UTF8String s = UTF8String.fromString((String)"2019-10-31T10:59:23Z:::");
            Option $org_scalatest_assert_macro_left = time = DateTimeUtils$.MODULE$.stringToTimestamp(s, this.defaultZoneId());
            None$ $org_scalatest_assert_macro_right = None$.MODULE$;
            Option option = $org_scalatest_assert_macro_left;
            None$ none$ = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        this.test("SPARK-33404: test truncTimestamp when time zone offset from UTC has a granularity of seconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
            DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zid, (JFunction0.mcV.sp & Serializable)() -> {
                Option inputTS = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"1769-10-17T17:10:02.123456"), $this.defaultZoneId());
                $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MINUTE(), "1769-10-17T17:10:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), "1769-10-17T17:10:02", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MILLISECOND(), "1769-10-17T17:10:02.123", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MICROSECOND(), "1769-10-17T17:10:02.123456", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
            });
            return BoxedUnit.UNIT;
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        this.test("truncTimestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option defaultInputTS = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-05T09:32:05.359123"), this.defaultZoneId());
            Option defaultInputTS1 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-31T20:32:05.359"), this.defaultZoneId());
            Option defaultInputTS2 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-01T02:32:05.359"), this.defaultZoneId());
            Option defaultInputTS3 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-30T02:32:05.359"), this.defaultZoneId());
            Option defaultInputTS4 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-29T02:32:05.359"), this.defaultZoneId());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_YEAR(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), "2015-03-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_DAY(), "2015-03-05T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_HOUR(), "2015-03-05T09:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MINUTE(), "2015-03-05T09:32:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), "2015-03-05T09:32:05", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-02T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS1.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS2.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS3.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-23T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS4.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS1.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-04-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS2.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MICROSECOND(), "2015-03-05T09:32:05.359123", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MILLISECOND(), "2015-03-05T09:32:05.359", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4());
            DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(zid, (JFunction0.mcV.sp & Serializable)() -> {
                    Option inputTS = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-05T09:32:05.359"), $this.defaultZoneId());
                    Option inputTS1 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-31T20:32:05.359"), $this.defaultZoneId());
                    Option inputTS2 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-01T02:32:05.359"), $this.defaultZoneId());
                    Option inputTS3 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-30T02:32:05.359"), $this.defaultZoneId());
                    Option inputTS4 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-29T02:32:05.359"), $this.defaultZoneId());
                    Option inputTS5 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"1999-03-29T01:02:03.456789"), $this.defaultZoneId());
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_YEAR(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), "2015-03-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_DAY(), "2015-03-05T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_HOUR(), "2015-03-05T09:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_MINUTE(), "2015-03-05T09:32:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), "2015-03-05T09:32:05", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-02T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS1.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS2.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS3.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-23T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS4.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS1.get()), zid);
                    $this.testTrunc(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-04-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS2.get()), zid);
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        this.test("SPARK-35664: microseconds to LocalDateTime", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LocalDateTime $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.microsToLocalDateTime(0L);
            LocalDateTime $org_scalatest_assert_macro_right = LocalDateTime.parse("1970-01-01T00:00:00");
            LocalDateTime localDateTime = $org_scalatest_assert_macro_left;
            LocalDateTime localDateTime2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(localDateTime != null ? !((Object)localDateTime).equals(localDateTime2) : localDateTime2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
            LocalDateTime $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.microsToLocalDateTime(100L);
            LocalDateTime $org_scalatest_assert_macro_right2 = LocalDateTime.parse("1970-01-01T00:00:00.0001");
            LocalDateTime localDateTime3 = $org_scalatest_assert_macro_left2;
            LocalDateTime localDateTime4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(localDateTime3 != null ? !((Object)localDateTime3).equals(localDateTime4) : localDateTime4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
            LocalDateTime $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.microsToLocalDateTime(100000000L);
            LocalDateTime $org_scalatest_assert_macro_right3 = LocalDateTime.parse("1970-01-01T00:01:40");
            LocalDateTime localDateTime5 = $org_scalatest_assert_macro_left3;
            LocalDateTime localDateTime6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(localDateTime5 != null ? !((Object)localDateTime5).equals(localDateTime6) : localDateTime6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
            LocalDateTime $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.microsToLocalDateTime(100000000000L);
            LocalDateTime $org_scalatest_assert_macro_right4 = LocalDateTime.parse("1970-01-02T03:46:40");
            LocalDateTime localDateTime7 = $org_scalatest_assert_macro_left4;
            LocalDateTime localDateTime8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(localDateTime7 != null ? !((Object)localDateTime7).equals(localDateTime8) : localDateTime8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
            LocalDateTime $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.microsToLocalDateTime(253402300799999999L);
            LocalDateTime $org_scalatest_assert_macro_right5 = LocalDateTime.parse("9999-12-31T23:59:59.999999");
            LocalDateTime localDateTime9 = $org_scalatest_assert_macro_left5;
            LocalDateTime localDateTime10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(localDateTime9 != null ? !((Object)localDateTime9).equals(localDateTime10) : localDateTime10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
            LocalDateTime $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.microsToLocalDateTime(Long.MIN_VALUE);
            LocalDateTime $org_scalatest_assert_macro_right6 = LocalDateTime.parse("-290308-12-21T19:59:05.224192");
            LocalDateTime localDateTime11 = $org_scalatest_assert_macro_left6;
            LocalDateTime localDateTime12 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(localDateTime11 != null ? !((Object)localDateTime11).equals(localDateTime12) : localDateTime12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
            LocalDateTime $org_scalatest_assert_macro_left7 = DateTimeUtils$.MODULE$.microsToLocalDateTime(Long.MAX_VALUE);
            LocalDateTime $org_scalatest_assert_macro_right7 = LocalDateTime.parse("+294247-01-10T04:00:54.775807");
            LocalDateTime localDateTime13 = $org_scalatest_assert_macro_left7;
            LocalDateTime localDateTime14 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(localDateTime13 != null ? !((Object)localDateTime13).equals(localDateTime14) : localDateTime14 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        this.test("SPARK-35664: LocalDateTime to microseconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("1970-01-01T00:00:00"));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
            long $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("1970-01-01T00:00:00.0001"));
            int $org_scalatest_assert_macro_right2 = 100;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
            long $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("1970-01-01T00:01:40"));
            int $org_scalatest_assert_macro_right3 = 100000000;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
            long $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("1970-01-02T03:46:40"));
            long $org_scalatest_assert_macro_right4 = 100000000000L;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
            long $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("9999-12-31T23:59:59.999999"));
            long $org_scalatest_assert_macro_right5 = 253402300799999999L;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
            long $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse("-1000-12-31T23:59:59.999999"));
            long $org_scalatest_assert_macro_right6 = -93692592000000001L;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
            new .colon.colon((Object)LocalDateTime.MIN, (List)new .colon.colon((Object)LocalDateTime.MAX, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)dt -> {
                String msg;
                String $org_scalatest_assert_macro_left = msg = ((Throwable)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.localDateTimeToMicros(dt), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 791))).getMessage();
                String $org_scalatest_assert_macro_right = "long overflow";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        this.test("daysToMicros and microsToDays", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$158 = 2015;
            int x$159 = 12;
            int x$160 = 31;
            int x$161 = 16;
            ZoneId x$162 = DateTimeTestUtils$.MODULE$.LA();
            byte x$163 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$164 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$165 = DateTimeTestUtils$.MODULE$.date$default$7();
            long input = DateTimeTestUtils$.MODULE$.date(2015, (byte)12, (byte)31, (byte)16, x$163, x$164, x$165, x$162);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.microsToDays(input, DateTimeTestUtils$.MODULE$.LA())));
            int $org_scalatest_assert_macro_right = 16800;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.microsToDays(input, DateTimeTestUtils$.MODULE$.UTC())));
            int $org_scalatest_assert_macro_right2 = 16801;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
            int $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.microsToDays(-86399999L, DateTimeTestUtils$.MODULE$.UTC());
            int $org_scalatest_assert_macro_right3 = -1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
            int x$166 = 2015;
            int x$167 = 12;
            int x$168 = 31;
            ZoneId x$169 = DateTimeTestUtils$.MODULE$.LA();
            byte x$170 = DateTimeTestUtils$.MODULE$.date$default$4();
            byte x$171 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$172 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$173 = DateTimeTestUtils$.MODULE$.date$default$7();
            long expected = DateTimeTestUtils$.MODULE$.date(2015, (byte)12, (byte)31, x$170, x$171, x$172, x$173, x$169);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.daysToMicros(16800, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right4 = expected;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
            int x$174 = 2015;
            int x$175 = 12;
            int x$176 = 31;
            ZoneId x$177 = DateTimeTestUtils$.MODULE$.UTC();
            byte x$178 = DateTimeTestUtils$.MODULE$.date$default$4();
            byte x$179 = DateTimeTestUtils$.MODULE$.date$default$5();
            byte x$180 = DateTimeTestUtils$.MODULE$.date$default$6();
            int x$181 = DateTimeTestUtils$.MODULE$.date$default$7();
            expected = DateTimeTestUtils$.MODULE$.date(2015, (byte)12, (byte)31, x$178, x$179, x$180, x$181, x$177);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.daysToMicros(16800, DateTimeTestUtils$.MODULE$.UTC())));
            long $org_scalatest_assert_macro_right5 = expected;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
            scala.collection.immutable.Map skipped_days = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Kwajalein"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8632, 8633, 8634}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Apia"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{15338}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Enderbury"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9130, 9131}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Fakaofo"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{15338}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Kiritimati"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9130, 9131}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Kanton"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9130, 9131}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Kwajalein"), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8632, 8633, 8634}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DateTimeTestUtils$.MODULE$.MIT().getId()), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{15338})))}));
            DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1 & Serializable)zid -> {
                DateTimeUtilsSuite.$anonfun$new$63(this, skipped_days, zid);
                return BoxedUnit.UNIT;
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 798));
        this.test("microsToMillis", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(-9223372036844776001L)));
            long $org_scalatest_assert_macro_right = -9223372036844777L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(-157700927876544L)));
            long $org_scalatest_assert_macro_right2 = -157700927877L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835));
        this.test("SPARK-29012: special timestamp values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testSpecialDatetimeValues((Function1 & Serializable)zoneId -> {
            long tolerance = TimeUnit.SECONDS.toMicros(30L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialTimestamp("Epoch", zoneId).get());
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 844));
            long now = DateTimeUtils$.MODULE$.instantToMicros(Instant.now());
            Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestamp("NOW", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)now), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialTimestamp("now UTC", zoneId));
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            ZonedDateTime localToday = LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT).atZone((ZoneId)zoneId);
            long yesterday = DateTimeUtils$.MODULE$.instantToMicros(localToday.minusDays(1L).toInstant());
            Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestamp(" Yesterday", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 852), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)yesterday), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
            long today = DateTimeUtils$.MODULE$.instantToMicros(localToday.toInstant());
            Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestamp("Today ", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 854), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)today), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
            long tomorrow = DateTimeUtils$.MODULE$.instantToMicros(localToday.plusDays(1L).toInstant());
            return Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestamp(" tomorrow CET ", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 856), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)tomorrow), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
        this.test("SPARK-35979: special timestamp without time zone values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long tolerance = TimeUnit.SECONDS.toMicros(30L);
            this.testSpecialDatetimeValues((Function1 & Serializable)zoneId -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ("Epoch", zoneId).get());
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
                long now = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.now(zoneId));
                Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ("NOW", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866), Prettifier$.MODULE$.default()).should(this.be().apply(this.convertNumericToPlusOrMinusWrapper((Object)BoxesRunTime.boxToLong((long)now), (Numeric)Numeric.LongIsIntegral$.MODULE$).$plus$minus((Object)BoxesRunTime.boxToLong((long)tolerance))));
                LocalDateTime localToday = LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT);
                long yesterday = DateTimeUtils$.MODULE$.localDateTimeToMicros(localToday.minusDays(1L));
                Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ(" Yesterday", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)yesterday)));
                long today = DateTimeUtils$.MODULE$.localDateTimeToMicros(localToday);
                Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ("Today ", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)today)));
                long tomorrow = DateTimeUtils$.MODULE$.localDateTimeToMicros(localToday.plusDays(1L));
                return Matchers$.MODULE$.convertToAnyShouldWrapper(DateTimeUtils$.MODULE$.convertSpecialTimestampNTZ(" tomorrow ", zoneId).get(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToLong((long)tomorrow)));
            });
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 860));
        this.test("SPARK-28141: special date values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testSpecialDatetimeValues((Function1 & Serializable)zoneId -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("epoch", zoneId).get());
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 879));
            int today = DateTimeUtils$.MODULE$.localDateToDays(LocalDate.now(zoneId));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("YESTERDAY", zoneId).get());
            int $org_scalatest_assert_macro_right2 = today - 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate(" Now ", zoneId).get());
            int $org_scalatest_assert_macro_right3 = today;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 882));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("now UTC", zoneId));
            None$ $org_scalatest_assert_macro_right4 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("today", zoneId).get());
            int $org_scalatest_assert_macro_right5 = today;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 884));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(DateTimeUtils$.MODULE$.convertSpecialDate("tomorrow CET ", zoneId).get());
            int $org_scalatest_assert_macro_right6 = today + 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 885));
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
        this.test("parsing day of week", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.getDayOfWeekFromString(UTF8String.fromString((String)"THU"));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 890));
            int $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.getDayOfWeekFromString(UTF8String.fromString((String)"MONDAY"));
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 891));
            SparkIllegalArgumentException x$182 = (SparkIllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> DateTimeUtils$.MODULE$.getDayOfWeekFromString(UTF8String.fromString((String)"xx")), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893));
            String x$183 = "ILLEGAL_DAY_OF_WEEK";
            scala.collection.immutable.Map x$184 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)"xx")}));
            Option x$185 = this.checkError$default$3();
            boolean x$186 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$187 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$182, "ILLEGAL_DAY_OF_WEEK", x$185, x$184, x$186, x$187);
            SparkIllegalArgumentException x$188 = (SparkIllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> DateTimeUtils$.MODULE$.getDayOfWeekFromString(UTF8String.fromString((String)"\"quote")), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
            String x$189 = "ILLEGAL_DAY_OF_WEEK";
            scala.collection.immutable.Map x$190 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)"\"quote")}));
            Option x$191 = this.checkError$default$3();
            boolean x$192 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$193 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$188, "ILLEGAL_DAY_OF_WEEK", x$191, x$190, x$192, x$193);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
        this.test("SPARK-34761: timestamp add day-time interval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2019, (byte)3, (byte)9, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA()), 86400000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2019, (byte)3, (byte)10, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 908));
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)44, (byte)1, 100000, (ZoneId)zid), 0L, zid)));
                long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)44, (byte)1, 100000, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2021, (byte)1, (byte)19, (byte)0, (byte)0, (byte)0, 0, (ZoneId)zid), -1555200000000L, zid)));
                long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2021, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 919));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)44, (byte)1, 999999, (ZoneId)zid), 600000000L, zid)));
                long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)54, (byte)1, 999999, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 922));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)18, (byte)19, (byte)44, (byte)1, 1, (ZoneId)zid), -86400000001L, zid)));
                long $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.date(2021, (byte)3, (byte)17, (byte)19, (byte)44, (byte)1, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 925));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2019, (byte)5, (byte)9, (byte)12, (byte)0, (byte)0, 123456, (ZoneId)zid), 172800000001L, zid)));
                long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.date(2019, (byte)5, (byte)11, (byte)12, (byte)0, (byte)0, 123457, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 928));
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddDayTime(DateTimeTestUtils$.MODULE$.date(2019, (byte)11, (byte)2, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA()), 86400000000L, DateTimeTestUtils$.MODULE$.LA())));
            long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2019, (byte)11, (byte)3, (byte)12, (byte)0, (byte)0, 123000, DateTimeTestUtils$.MODULE$.LA());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 933));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
        this.test("SPARK-34903: subtract timestamps", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
            DateTimeUtilsSuite.$anonfun$new$80(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 941));
        this.test("SPARK-35679: instantToMicros should be able to return microseconds of Long.MinValue", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(DateTimeUtils$.MODULE$.microsToInstant(Long.MAX_VALUE))));
            long $org_scalatest_assert_macro_right = Long.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 983));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(DateTimeUtils$.MODULE$.microsToInstant(Long.MIN_VALUE))));
            long $org_scalatest_assert_macro_right2 = Long.MIN_VALUE;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 984));
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 982));
        this.test("SPARK-37552: convert a timestamp_ntz from a source time zone to target one", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"1970-01-01T00:00:00", (Object)"UTC")), (Object)new Tuple2((Object)"1969-12-31T16:00:00", (Object)"America/Los_Angeles")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-12-05T22:00:00", (Object)"Europe/Moscow")), (Object)new Tuple2((Object)"2021-12-06T00:00:00", (Object)"Asia/Yekaterinburg")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-12-06T00:01:02.123456", (Object)"Asia/Yekaterinburg")), (Object)new Tuple2((Object)"2021-12-05T20:01:02.123456", (Object)"Europe/Brussels")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T09:00:00", (Object)"Europe/Brussels")), (Object)new Tuple2((Object)"2021-11-07T01:00:00", (Object)"America/Los_Angeles")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T10:00:00", (Object)"Europe/Brussels")), (Object)new Tuple2((Object)"2021-11-07T01:00:00", (Object)"America/Los_Angeles")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T11:00:00", (Object)"Europe/Brussels")), (Object)new Tuple2((Object)"2021-11-07T02:00:00", (Object)"America/Los_Angeles")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T00:30:00", (Object)"America/Los_Angeles")), (Object)new Tuple2((Object)"2021-11-07T08:30:00", (Object)"Europe/Brussels")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T01:30:00", (Object)"America/Los_Angeles")), (Object)new Tuple2((Object)"2021-11-07T09:30:00", (Object)"Europe/Brussels")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"2021-11-07T02:30:00", (Object)"America/Los_Angeles")), (Object)new Tuple2((Object)"2021-11-07T11:30:00", (Object)"Europe/Brussels"))})).foreach((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String inputTs = (String)tuple22._1();
                    String sourceTz = (String)tuple22._2();
                    if (tuple23 != null) {
                        String expectedTs = (String)tuple23._1();
                        String targetTz = (String)tuple23._2();
                        long micros = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse(inputTs));
                        long result = DateTimeUtils$.MODULE$.convertTimestampNtzToAnotherTz(sourceTz, targetTz, micros);
                        long expectedMicros = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.parse(expectedTs));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)expectedMicros));
                        long $org_scalatest_assert_macro_right = result;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("The difference is " + (result - expectedMicros) / 3600000000L + " hours"), Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1006));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
        this.test("SPARK-38195: add a quantity of interval units to a timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("MICROSECOND", 1L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 0, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1013));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("MILLISECOND", -1L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1000, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1015));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("SECOND", 0L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1001, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1001, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1017));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("MINUTE", -90L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)0, (byte)1, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)9, (byte)30, (byte)1, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1019));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("HOUR", 24L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)0, (byte)1, 0, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)15, (byte)11, (byte)0, (byte)1, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1021));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("DAY", 1L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)28, (byte)11, (byte)1, (byte)0, 0, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right6 = DateTimeTestUtils$.MODULE$.date(2022, (byte)3, (byte)1, (byte)11, (byte)1, (byte)0, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1023));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("DAYOFYEAR", 364L, DateTimeTestUtils$.MODULE$.date(2022, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 0, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right7 = DateTimeTestUtils$.MODULE$.date(2022, (byte)12, (byte)31, (byte)0, (byte)0, (byte)0, 0, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("WEEK", 1L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right8 = DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)21, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1027));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("MONTH", 10L, DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right9 = DateTimeTestUtils$.MODULE$.date(2022, (byte)12, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1029));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("QUARTER", 1L, DateTimeTestUtils$.MODULE$.date(1900, (byte)2, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right10 = DateTimeTestUtils$.MODULE$.date(1900, (byte)5, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1031));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("YEAR", 1L, DateTimeTestUtils$.MODULE$.date(9998, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right11 = DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1033));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd("YEAR", -9998L, DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                long $org_scalatest_assert_macro_right12 = DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid);
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1035));
            });
            SparkIllegalArgumentException x$194 = (SparkIllegalArgumentException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.timestampAdd("SECS", 1L, DateTimeTestUtils$.MODULE$.date(1969, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, DateTimeUtils$.MODULE$.getZoneId("UTC")), DateTimeUtils$.MODULE$.getZoneId("UTC")), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1040));
            String x$195 = "INVALID_PARAMETER_VALUE.DATETIME_UNIT";
            scala.collection.immutable.Map x$196 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`TIMESTAMPADD`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`unit`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidValue"), (Object)"'SECS'")}));
            Option x$197 = this.checkError$default$3();
            boolean x$198 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$199 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$194, "INVALID_PARAMETER_VALUE.DATETIME_UNIT", x$197, x$196, x$198, x$199);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1011));
        this.test("SPARK-38284: difference between two timestamps in units", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("MICROSECOND", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 0, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1052));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("MILLISECOND", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1000, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 0, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right2 = -1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1054));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("SECOND", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1001, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)27, (byte)0, 1002, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1056));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("MINUTE", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)0, (byte)1, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)9, (byte)30, (byte)1, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right4 = -90;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1061));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("HOUR", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)0, (byte)1, 0, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)15, (byte)11, (byte)0, (byte)1, 2, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right5 = 24;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1066));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("DAY", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)28, (byte)11, (byte)1, (byte)0, 0, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)3, (byte)1, (byte)11, (byte)1, (byte)0, 0, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1071));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("WEEK", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)21, (byte)11, (byte)42, (byte)59, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right7 = 0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1076));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("MONTH", DateTimeTestUtils$.MODULE$.date(2022, (byte)2, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(2022, (byte)12, (byte)14, (byte)11, (byte)43, (byte)0, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right8 = 10;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1078));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("QUARTER", DateTimeTestUtils$.MODULE$.date(1900, (byte)2, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(1900, (byte)5, (byte)1, (byte)2, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right9 = 1;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1080));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("YEAR", DateTimeTestUtils$.MODULE$.date(9998, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)1, (byte)0, (byte)0, (byte)1, 2, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right10 = 1;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1082));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff("YEAR", DateTimeTestUtils$.MODULE$.date(9999, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), DateTimeTestUtils$.MODULE$.date(1, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, (ZoneId)zid), zid)));
                int $org_scalatest_assert_macro_right11 = -9998;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1087));
            });
            SparkIllegalArgumentException x$200 = (SparkIllegalArgumentException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> DateTimeUtils$.MODULE$.timestampDiff("SECS", DateTimeTestUtils$.MODULE$.date(1969, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, DateTimeUtils$.MODULE$.getZoneId("UTC")), DateTimeTestUtils$.MODULE$.date(2022, (byte)1, (byte)1, (byte)0, (byte)0, (byte)0, 1, DateTimeUtils$.MODULE$.getZoneId("UTC")), DateTimeUtils$.MODULE$.getZoneId("UTC")), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1095));
            String x$201 = "INVALID_PARAMETER_VALUE.DATETIME_UNIT";
            scala.collection.immutable.Map x$202 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`TIMESTAMPDIFF`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`unit`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidValue"), (Object)"'SECS'")}));
            Option x$203 = this.checkError$default$3();
            boolean x$204 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$205 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$200, "INVALID_PARAMETER_VALUE.DATETIME_UNIT", x$203, x$202, x$204, x$205);
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1050));
        Statics.releaseFence();
    }
}

