/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.ArrayDeque;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.resolver.CteRegistry;
import org.apache.spark.sql.catalyst.analysis.resolver.ExplicitlyUnsupportedResolverFeature;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolverGuard;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ViewResolutionContext;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.plans.logical.View$;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005u4AAD\b\u0001=!A\u0001\u0003\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u001d\u0011\u0005A1A\u0005\n\rCaa\u0012\u0001!\u0002\u0013!\u0005b\u0002%\u0001\u0005\u0004%I!\u0013\u0005\u0007-\u0002\u0001\u000b\u0011\u0002&\t\u000f]\u0003!\u0019!C\u00051\"1Q\f\u0001Q\u0001\neCQA\u0018\u0001\u0005\u0002}CQa\u001b\u0001\u0005B1DQa\u001c\u0001\u0005\nADQa\u001e\u0001\u0005\na\u0014ABV5foJ+7o\u001c7wKJT!\u0001E\t\u0002\u0011I,7o\u001c7wKJT!AE\n\u0002\u0011\u0005t\u0017\r\\=tSNT!\u0001F\u000b\u0002\u0011\r\fG/\u00197zgRT!AF\f\u0002\u0007M\fHN\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB!aeJ\u0015*\u001b\u0005y\u0011B\u0001\u0015\u0010\u0005A!&/Z3O_\u0012,'+Z:pYZ,'\u000f\u0005\u0002+_5\t1F\u0003\u0002-[\u00059An\\4jG\u0006d'B\u0001\u0018\u0014\u0003\u0015\u0001H.\u00198t\u0013\t\u00014F\u0001\u0003WS\u0016<\bC\u0001\u00143\u0013\t\u0019tB\u0001\u0005SKN|GN^3s\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u000f\r\fG/\u00197pO*\u0011!(F\u0001\nG>tg.Z2u_JL!\u0001P\u001c\u0003\u001d\r\u000bG/\u00197pO6\u000bg.Y4fe\u00061A(\u001b8jiz\"2a\u0010!B!\t1\u0003\u0001C\u0003\u0011\u0007\u0001\u0007\u0011\u0007C\u00035\u0007\u0001\u0007Q'A\u0006di\u0016\u0014VmZ5tiJLX#\u0001#\u0011\u0005\u0019*\u0015B\u0001$\u0010\u0005-\u0019E/\u001a*fO&\u001cHO]=\u0002\u0019\r$XMU3hSN$(/\u001f\u0011\u0002;M|WO]2f+:\u0014Xm]8mm\u0016$'+\u001a7bi&|gn\u0015;bG.,\u0012A\u0013\t\u0004\u0017B\u0013V\"\u0001'\u000b\u00055s\u0015\u0001B;uS2T\u0011aT\u0001\u0005U\u00064\u0018-\u0003\u0002R\u0019\nQ\u0011I\u001d:bs\u0012+\u0017/^3\u0011\u0005M#V\"A\t\n\u0005U\u000b\"AE+oe\u0016\u001cx\u000e\u001c<fIJ+G.\u0019;j_:\fad]8ve\u000e,WK\u001c:fg>dg/\u001a3SK2\fG/[8o'R\f7m\u001b\u0011\u00025YLWm\u001e*fg>dW\u000f^5p]\u000e{g\u000e^3yiN#\u0018mY6\u0016\u0003e\u00032a\u0013)[!\t13,\u0003\u0002]\u001f\t)b+[3x%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$\u0018a\u0007<jK^\u0014Vm]8mkRLwN\\\"p]R,\u0007\u0010^*uC\u000e\\\u0007%\u0001\u000fxSRD7k\\;sG\u0016,fN]3t_24X\r\u001a*fY\u0006$\u0018n\u001c8\u0015\u0005\u0001LGCA1e!\tQ#-\u0003\u0002dW\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0019)'\u0002\"a\u0001M\u0006!!m\u001c3z!\r\u0001s-Y\u0005\u0003Q\u0006\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\u0006U*\u0001\rAU\u0001\u0013k:\u0014Xm]8mm\u0016$'+\u001a7bi&|g.A\u0004sKN|GN^3\u0015\u0005%j\u0007\"\u00028\f\u0001\u0004I\u0013AD;oe\u0016\u001cx\u000e\u001c<fIZKWm^\u0001\u001ao&$\bNV5foJ+7o\u001c7vi&|gnQ8oi\u0016DH\u000f\u0006\u0002rmR\u0011!/\u001e\t\u0005AM\f',\u0003\u0002uC\t1A+\u001e9mKJBa!\u001a\u0007\u0005\u0002\u00041\u0007\"\u00028\r\u0001\u0004I\u0013AE2iK\u000e\\'+Z:pYZ,'oR;be\u0012$\"!\u001f?\u0011\u0005\u0001R\u0018BA>\"\u0005\u0011)f.\u001b;\t\u000b9l\u0001\u0019A\u0015")
public class ViewResolver
implements TreeNodeResolver<View, View> {
    private final Resolver resolver;
    private final CatalogManager catalogManager;
    private final CteRegistry cteRegistry;
    private final ArrayDeque<UnresolvedRelation> sourceUnresolvedRelationStack;
    private final ArrayDeque<ViewResolutionContext> viewResolutionContextStack;

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private CteRegistry cteRegistry() {
        return this.cteRegistry;
    }

    private ArrayDeque<UnresolvedRelation> sourceUnresolvedRelationStack() {
        return this.sourceUnresolvedRelationStack;
    }

    private ArrayDeque<ViewResolutionContext> viewResolutionContextStack() {
        return this.viewResolutionContextStack;
    }

    public LogicalPlan withSourceUnresolvedRelation(UnresolvedRelation unresolvedRelation, Function0<LogicalPlan> body) {
        LogicalPlan logicalPlan;
        this.sourceUnresolvedRelationStack().push(unresolvedRelation);
        try {
            logicalPlan = (LogicalPlan)body.apply();
        }
        finally {
            this.sourceUnresolvedRelationStack().pop();
        }
        return logicalPlan;
    }

    @Override
    public View resolve(View unresolvedView) {
        this.checkResolverGuard(unresolvedView);
        Tuple2<LogicalPlan, ViewResolutionContext> tuple2 = this.withViewResolutionContext(unresolvedView, (Function0<LogicalPlan>)(Function0 & Serializable)() -> (LogicalPlan)SQLConf$.MODULE$.withExistingConf(View$.MODULE$.effectiveSQLConf(unresolvedView.desc().viewSQLConfigs(), unresolvedView.isTempView()), (Function0 & Serializable)() -> (LogicalPlan)this.cteRegistry().withNewScope(true, true, (Function0 & Serializable)() -> $this.resolver.lookupMetadataAndResolve(unresolvedView.child(), $this.resolver.lookupMetadataAndResolve$default$2()))));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LogicalPlan resolvedChild = (LogicalPlan)tuple2._1();
        ViewResolutionContext usedViewResolutionContext = (ViewResolutionContext)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)resolvedChild, (Object)usedViewResolutionContext);
        LogicalPlan resolvedChild2 = (LogicalPlan)tuple22._1();
        ViewResolutionContext usedViewResolutionContext2 = (ViewResolutionContext)tuple22._2();
        LogicalPlan x$1 = resolvedChild2;
        CatalogTable x$2 = unresolvedView.copy$default$1();
        boolean x$3 = unresolvedView.copy$default$2();
        return unresolvedView.copy(x$2, x$3, x$1);
    }

    private Tuple2<LogicalPlan, ViewResolutionContext> withViewResolutionContext(View unresolvedView, Function0<LogicalPlan> body) {
        Tuple2 tuple2;
        ViewResolutionContext viewResolutionContext;
        if (this.viewResolutionContextStack().isEmpty()) {
            viewResolutionContext = new ViewResolutionContext(1, this.conf().maxNestedViewDepth());
        } else {
            ViewResolutionContext prevContext = this.viewResolutionContextStack().peek();
            viewResolutionContext = prevContext.copy(prevContext.nestedViewDepth() + 1, prevContext.copy$default$2());
        }
        ViewResolutionContext viewResolutionContext2 = viewResolutionContext;
        viewResolutionContext2.validate(unresolvedView);
        this.viewResolutionContextStack().push(viewResolutionContext2);
        try {
            tuple2 = new Tuple2(body.apply(), (Object)viewResolutionContext2);
        }
        finally {
            this.viewResolutionContextStack().pop();
        }
        return tuple2;
    }

    private void checkResolverGuard(View unresolvedView) {
        ResolverGuard resolverGuard = new ResolverGuard(this.catalogManager);
        if (!resolverGuard.apply(unresolvedView)) {
            throw new ExplicitlyUnsupportedResolverFeature("View body is not supported");
        }
    }

    public ViewResolver(Resolver resolver, CatalogManager catalogManager) {
        this.resolver = resolver;
        this.catalogManager = catalogManager;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.cteRegistry = resolver.getCteRegistry();
        this.sourceUnresolvedRelationStack = new ArrayDeque();
        this.viewResolutionContextStack = new ArrayDeque();
    }
}

