/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayCompact$;
import org.apache.spark.sql.catalyst.expressions.ArrayFilter;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.KnownNotContainsNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array) - Removes null values from the array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null));\n       [1,2,3]\n      > SELECT _FUNC_(array(\"a\", \"b\", \"c\"));\n       [\"a\",\"b\",\"c\"]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\u000e\u001d\u0001&B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005U!)q\n\u0001C\u0001!\"A1\u000b\u0001EC\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001!\u0015\r\u0011\"\u0001Z\u0011!i\u0006\u0001#b\u0001\n\u0003q\u0006\u0002\u00032\u0001\u0011\u000b\u0007I\u0011I'\t\u000b\r\u0004A\u0011\t3\t\u000b9\u0004A\u0011I8\t\u000ba\u0004A\u0011K=\t\u000fq\u0004\u0011\u0011!C\u0001{\"Aq\u0010AI\u0001\n\u0003\t\t\u0001C\u0005\u0002\u0018\u0001\t\t\u0011\"\u0011\u0002\u001a!I\u0011\u0011\u0006\u0001\u0002\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003g\u0001\u0011\u0011!C\u0001\u0003kA\u0011\"!\u0011\u0001\u0003\u0003%\t%a\u0011\t\u0013\u0005E\u0003!!A\u0005\u0002\u0005M\u0003\"CA/\u0001\u0005\u0005I\u0011IA0\u0011%\t\u0019\u0007AA\u0001\n\u0003\n)gB\u0005\u0002\nr\t\t\u0011#\u0001\u0002\f\u001aA1\u0004HA\u0001\u0012\u0003\ti\t\u0003\u0004P+\u0011\u0005\u0011Q\u0015\u0005\n\u0003O+\u0012\u0011!C#\u0003SC\u0011\"a+\u0016\u0003\u0003%\t)!,\t\u0013\u0005EV#!A\u0005\u0002\u0006M\u0006\"CA`+\u0005\u0005I\u0011BAa\u00051\t%O]1z\u0007>l\u0007/Y2u\u0015\tib$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0010!\u0003!\u0019\u0017\r^1msN$(BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u00011c\u0002\u0001+]E:$\b\u0011\t\u0003W1j\u0011\u0001H\u0005\u0003[q\u0011!\"\u0012=qe\u0016\u001c8/[8o!\tYs&\u0003\u000219\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\r\u0011TGK\u0007\u0002g)\u0011AGH\u0001\u0006iJ,Wm]\u0005\u0003mM\u0012\u0011\"\u00168befd\u0015n[3\u0011\u0005-B\u0014BA\u001d\u001d\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0003&s!AQ$\u000f\u0005\r3U\"\u0001#\u000b\u0005\u0015C\u0013A\u0002\u001fs_>$h(C\u0001>\u0013\tAE(A\u0004qC\u000e\\\u0017mZ3\n\u0005)[%\u0001D*fe&\fG.\u001b>bE2,'B\u0001%=\u0003\u0015\u0019\u0007.\u001b7e+\u0005Q\u0013AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003#J\u0003\"a\u000b\u0001\t\u000b1\u001b\u0001\u0019\u0001\u0016\u0002\u0013%\u001chj\u001c;Ok2dW#A+\u0011\tm2&FK\u0005\u0003/r\u0012\u0011BR;oGRLwN\\\u0019\u0002\u000514X#\u0001.\u0011\u0005-Z\u0016B\u0001/\u001d\u0005Mq\u0015-\\3e\u0019\u0006l'\rZ1WCJL\u0017M\u00197f\u0003\u0019a\u0017-\u001c2eCV\tq\f\u0005\u0002,A&\u0011\u0011\r\b\u0002\u000f\u0019\u0006l'\rZ1Gk:\u001cG/[8o\u0003-\u0011X\r\u001d7bG\u0016lWM\u001c;\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001f!\r\te\r[\u0005\u0003O.\u00131aU3r!\tIG.D\u0001k\u0015\tY\u0007%A\u0003usB,7/\u0003\u0002nU\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,W#\u00019\u0011\u0005E,hB\u0001:t!\t\u0019E(\u0003\u0002uy\u00051\u0001K]3eK\u001aL!A^<\u0003\rM#(/\u001b8h\u0015\t!H(\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0003#jDQa\u001f\u0006A\u0002)\n\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002R}\"9Aj\u0003I\u0001\u0002\u0004Q\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007Q3AKA\u0003W\t\t9\u0001\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\ty\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00111\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001cA!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00027b]\u001eT!!!\n\u0002\t)\fg/Y\u0005\u0004m\u0006}\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0017!\rY\u0014qF\u0005\u0004\u0003ca$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001c\u0003{\u00012aOA\u001d\u0013\r\tY\u0004\u0010\u0002\u0004\u0003:L\b\"CA \u001f\u0005\u0005\t\u0019AA\u0017\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\t\t\u0007\u0003\u000f\ni%a\u000e\u000e\u0005\u0005%#bAA&y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0013\u0011\n\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002V\u0005m\u0003cA\u001e\u0002X%\u0019\u0011\u0011\f\u001f\u0003\u000f\t{w\u000e\\3b]\"I\u0011qH\t\u0002\u0002\u0003\u0007\u0011qG\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u001c\u0005\u0005\u0004\"CA %\u0005\u0005\t\u0019AA\u0017\u0003\u0019)\u0017/^1mgR!\u0011QKA4\u0011%\tydEA\u0001\u0002\u0004\t9\u0004K\n\u0001\u0003W\n\t(a\u001d\u0002x\u0005e\u0014QPA@\u0003\u0007\u000b)\tE\u0002,\u0003[J1!a\u001c\u001d\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001e\u0002g}3UKT\"`Q\u0005\u0014(/Y=*A5\u0002#+Z7pm\u0016\u001c\bE\\;mY\u00022\u0018\r\\;fg\u00022'o\\7!i\",\u0007%\u0019:sCft\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005m\u0014!a\b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c1\u0002#\u0007\f\u00114Y\u0001rW\u000f\u001c7*SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u00173YMj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bFI1#Y\u0001\u0012#M\t\u0017!E\r\u0014\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\n\n'\u0005\f\u0012cE1\u00123MI/\u000bA\u0001\nQa\u001a:pkB\f#!!!\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003\u000f\u000bQa\r\u00185]A\nA\"\u0011:sCf\u001cu.\u001c9bGR\u0004\"aK\u000b\u0014\u000bU\ty)a'\u0011\r\u0005E\u0015q\u0013\u0016R\u001b\t\t\u0019JC\u0002\u0002\u0016r\nqA];oi&lW-\u0003\u0003\u0002\u001a\u0006M%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u0011QTAR\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0012AA5p\u0013\rQ\u0015q\u0014\u000b\u0003\u0003\u0017\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\tQ!\u00199qYf$2!UAX\u0011\u0015a\u0005\u00041\u0001+\u0003\u001d)h.\u00199qYf$B!!.\u0002<B!1(a.+\u0013\r\tI\f\u0010\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005u\u0016$!AA\u0002E\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\u0019\r\u0005\u0003\u0002\u001e\u0005\u0015\u0017\u0002BAd\u0003?\u0011aa\u00142kK\u000e$\b")
public class ArrayCompact
extends Expression
implements RuntimeReplaceable,
UnaryLike<Expression>,
ImplicitCastInputTypes,
Serializable {
    private Function1<Expression, Expression> isNotNull;
    private NamedLambdaVariable lv;
    private LambdaFunction lambda;
    private Expression replacement;
    private final Expression child;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(ArrayCompact x$0) {
        return ArrayCompact$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ArrayCompact, A> g) {
        return ArrayCompact$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, ArrayCompact> compose(Function1<A$, Expression> g) {
        return ArrayCompact$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    private Function1<Expression, Expression> isNotNull$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.isNotNull = (Function1 & Serializable)x -> new IsNotNull((Expression)x);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.isNotNull;
    }

    public Function1<Expression, Expression> isNotNull() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.isNotNull$lzycompute();
        }
        return this.isNotNull;
    }

    private NamedLambdaVariable lv$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.lv = new NamedLambdaVariable("arg", ((ArrayType)this.child().dataType()).elementType(), true, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.lv;
    }

    public NamedLambdaVariable lv() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.lv$lzycompute();
        }
        return this.lv;
    }

    private LambdaFunction lambda$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.lambda = new LambdaFunction((Expression)this.isNotNull().apply((Object)this.lv()), (Seq<NamedExpression>)new .colon.colon((Object)this.lv(), (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.lambda;
    }

    public LambdaFunction lambda() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.lambda$lzycompute();
        }
        return this.lambda;
    }

    private Expression replacement$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.replacement = new KnownNotContainsNull(new ArrayFilter(this.child(), this.lambda()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public String prettyName() {
        return "array_compact";
    }

    @Override
    public ArrayCompact withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public ArrayCompact copy(Expression child) {
        return new ArrayCompact(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ArrayCompact";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayCompact;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayCompact)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayCompact arrayCompact = (ArrayCompact)x$1;
        Expression expression = this.child();
        Expression expression2 = arrayCompact.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!arrayCompact.canEqual(this)) return false;
        return true;
    }

    public ArrayCompact(Expression child) {
        this.child = child;
        RuntimeReplaceable.$init$(this);
        UnaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

