/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Elt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(n, input1, input2, ...) - Returns the `n`-th input, e.g., returns `input2` when `n` is 2.\n    The function returns NULL if the index exceeds the length of the array\n    and `spark.sql.ansi.enabled` is set to false. If `spark.sql.ansi.enabled` is set to true,\n    it throws ArrayIndexOutOfBoundsException for invalid indices.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 'scala', 'java');\n       scala\n      > SELECT _FUNC_(2, 'a', 1);\n       1\n  ", since="2.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]a\u0001B\u0012%\u0001FB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003T\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u00159\u0006\u0001\"\u0001]\u0011!q\u0006\u0001#b\u0001\n\u0013y\u0006\u0002\u00031\u0001\u0011\u000b\u0007I\u0011B1\t\u000b\u0015\u0004A\u0011\t*\t\u000b\u0019\u0004A\u0011I4\t\u000b9\u0004A\u0011I8\t\u000bY\u0004A\u0011I<\t\u000f\u0005\r\u0001\u0001\"\u0015\u0002\u0006!9\u0011\u0011\u0005\u0001\u0005R\u0005\r\u0002bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\n\u0003\u0003\u0002\u0011\u0011!C\u0001\u0003\u0007B\u0011\"!\u0013\u0001#\u0003%\t!a\u0013\t\u0013\u0005\u0005\u0004!%A\u0005\u0002\u0005\r\u0004\"CA4\u0001\u0005\u0005I\u0011IA5\u0011%\tY\bAA\u0001\n\u0003\ti\bC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0001\u0002\b\"I\u0011Q\u0012\u0001\u0002\u0002\u0013\u0005\u0013q\u0012\u0005\n\u0003;\u0003\u0011\u0011!C\u0001\u0003?C\u0011\"a)\u0001\u0003\u0003%\t%!*\t\u0013\u0005%\u0006!!A\u0005B\u0005-v!CAhI\u0005\u0005\t\u0012AAi\r!\u0019C%!A\t\u0002\u0005M\u0007BB,\u001c\t\u0003\tY\u000fC\u0005\u0002nn\t\t\u0011\"\u0012\u0002p\"I\u0011\u0011_\u000e\u0002\u0002\u0013\u0005\u00151\u001f\u0005\n\u0003s\\\u0012\u0013!C\u0001\u0003GB\u0011\"a?\u001c\u0003\u0003%\t)!@\t\u0013\t-1$%A\u0005\u0002\u0005\r\u0004\"\u0003B\u00077\u0005\u0005I\u0011\u0002B\b\u0005\r)E\u000e\u001e\u0006\u0003K\u0019\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0005K\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M)\u0001A\r\u001c:\u007fA\u00111\u0007N\u0007\u0002I%\u0011Q\u0007\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u001a8\u0013\tADEA\nTkB\u0004xN\u001d;Rk\u0016\u0014\u0018pQ8oi\u0016DH\u000f\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4HA\u0004Qe>$Wo\u0019;\u0011\u0005\u0001CeBA!G\u001d\t\u0011U)D\u0001D\u0015\t!\u0005'\u0001\u0004=e>|GOP\u0005\u0002y%\u0011qiO\u0001\ba\u0006\u001c7.Y4f\u0013\tI%J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Hw\u0005A1\r[5mIJ,g.F\u0001N!\r\u0001eJM\u0005\u0003\u001f*\u00131aU3r\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%A\u0006gC&dwJ\\#se>\u0014X#A*\u0011\u0005i\"\u0016BA+<\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtDcA-[7B\u00111\u0007\u0001\u0005\u0006\u0017\u0016\u0001\r!\u0014\u0005\b#\u0016\u0001\n\u00111\u0001T)\tIV\fC\u0003L\r\u0001\u0007Q*A\u0005j]\u0012,\u00070\u0012=qeV\t!'\u0001\u0006j]B,H/\u0012=qeN,\u0012A\u0019\t\u0004u\r\u0014\u0014B\u00013<\u0005\u0015\t%O]1z\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003!\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u0015\u0002\u000bQL\b/Z:\n\u00055T'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003A\u0004\"!\u001d;\u000e\u0003IT!a\u001d\u0014\u0002\u0011\u0005t\u0017\r\\=tSNL!!\u001e:\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fA!\u001a<bYR\u0011\u0001p\u001f\t\u0003ueL!A_\u001e\u0003\u0007\u0005s\u0017\u0010C\u0004}\u0019A\u0005\t\u0019A?\u0002\u000b%t\u0007/\u001e;\u0011\u0005y|X\"\u0001\u0014\n\u0007\u0005\u0005aEA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9!a\u0005\u0002\u001eA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e\u0011\nqaY8eK\u001e,g.\u0003\u0003\u0002\u0012\u0005-!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005UQ\u00021\u0001\u0002\u0018\u0005\u00191\r\u001e=\u0011\t\u0005%\u0011\u0011D\u0005\u0005\u00037\tYA\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005}Q\u00021\u0001\u0002\b\u0005\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2!WA\u0013\u0011\u001d\t9C\u0004a\u0001\u0003S\t1B\\3x\u0007\"LG\u000e\u001a:f]B!\u0001)a\u000b3\u0013\r\tiC\u0013\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001E5oSR\fV/\u001a:z\u0007>tG/\u001a=u)\t\t\u0019\u0004E\u0003;\u0003k\tI$C\u0002\u00028m\u0012aa\u00149uS>t\u0007\u0003BA\u001e\u0003{i\u0011AK\u0005\u0004\u0003\u007fQ#\u0001D)vKJL8i\u001c8uKb$\u0018\u0001B2paf$R!WA#\u0003\u000fBqa\u0013\t\u0011\u0002\u0003\u0007Q\nC\u0004R!A\u0005\t\u0019A*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\n\u0016\u0004\u001b\u0006=3FAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m3(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0018\u0002V\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\r\u0016\u0004'\u0006=\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002lA!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014\u0001\u00027b]\u001eT!!!\u001e\u0002\t)\fg/Y\u0005\u0005\u0003s\nyG\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u007f\u00022AOAA\u0013\r\t\u0019i\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004q\u0006%\u0005\"CAF+\u0005\u0005\t\u0019AA@\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0013\t\u0006\u0003'\u000bI\n_\u0007\u0003\u0003+S1!a&<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\u000b)J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA*\u0002\"\"A\u00111R\f\u0002\u0002\u0003\u0007\u00010\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA6\u0003OC\u0011\"a#\u0019\u0003\u0003\u0005\r!a \u0002\r\u0015\fX/\u00197t)\r\u0019\u0016Q\u0016\u0005\t\u0003\u0017K\u0012\u0011!a\u0001q\"\u001a\u0002!!-\u00028\u0006e\u0016QXA`\u0003\u0007\f)-!3\u0002LB\u00191'a-\n\u0007\u0005UFEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005m\u0016Aa*\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006F\u001c\u0017!S:\u0004X\u000f^\u0019-A%t\u0007/\u001e;3Y\u0001rcFL\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!A:\u0004W\u0006\u001e5!S:\u0004X\u000f\u001e\u0017!K::g\u0006\f\u0011sKR,(O\\:!A&t\u0007/\u001e;3A\u0002:\b.\u001a8!A:\u0004\u0007%[:!e9R\u0001\u0005\t\u0011!)\",\u0007EZ;oGRLwN\u001c\u0011sKR,(O\\:!\u001dVcE\nI5gAQDW\rI5oI\u0016D\b%\u001a=dK\u0016$7\u000f\t;iK\u0002bWM\\4uQ\u0002zg\r\t;iK\u0002\n'O]1z\u0015\u0001\u0002\u0003\u0005I1oI\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u0002\u001aX\r\u001e\u0011u_\u00022\u0017\r\\:f]\u0001Je\r\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000fI:fi\u0002\"x\u000e\t;sk\u0016d#\u0002\t\u0011!A%$\b\u0005\u001e5s_^\u001c\b%\u0011:sCfLe\u000eZ3y\u001fV$xJ\u001a\"pk:$7/\u0012=dKB$\u0018n\u001c8!M>\u0014\b%\u001b8wC2LG\rI5oI&\u001cWm\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u0003\fAO\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152Y\u0001:3oY1mC\u001eb\u0003e\n6bm\u0006<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011tG\u0006d\u0017M\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153Y\u0001:\u0013m\n\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qY\u0001\u0006e9\u0002d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u001b\fAb\u001d;sS:<wLZ;oGN\f1!\u00127u!\t\u00194dE\u0003\u001c\u0003+\f\t\u000fE\u0004\u0002X\u0006uWjU-\u000e\u0005\u0005e'bAAnw\u00059!/\u001e8uS6,\u0017\u0002BAp\u00033\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t\u0019/!;\u000e\u0005\u0005\u0015(\u0002BAt\u0003g\n!![8\n\u0007%\u000b)\u000f\u0006\u0002\u0002R\u0006AAo\\*ue&tw\r\u0006\u0002\u0002l\u0005)\u0011\r\u001d9msR)\u0011,!>\u0002x\")1J\ba\u0001\u001b\"9\u0011K\bI\u0001\u0002\u0004\u0019\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011q B\u0004!\u0015Q\u0014Q\u0007B\u0001!\u0015Q$1A'T\u0013\r\u0011)a\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t%\u0001%!AA\u0002e\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0003\t\u0005\u0003[\u0012\u0019\"\u0003\u0003\u0003\u0016\u0005=$AB(cU\u0016\u001cG\u000f")
public class Elt
extends Expression
implements SupportQueryContext {
    private Expression indexExpr;
    private Expression[] inputExprs;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private Option<QueryContext> queryContext;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Elt$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Elt x$0) {
        return Elt$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Elt$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Elt> tupled() {
        return Elt$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Elt>> curried() {
        return Elt$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public QueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public Option<QueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<QueryContext> x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private Expression indexExpr$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.indexExpr = (Expression)this.children().head();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.indexExpr;
    }

    private Expression indexExpr() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.indexExpr$lzycompute();
        }
        return this.indexExpr;
    }

    private Expression[] inputExprs$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.inputExprs = (Expression[])((IterableOnceOps)this.children().tail()).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.inputExprs;
    }

    private Expression[] inputExprs() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.inputExprs$lzycompute();
        }
        return this.inputExprs;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return (DataType)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$10 -> x$10.dataType(), ClassTag$.MODULE$.apply(DataType.class)))).getOrElse((Function0 & Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().size() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)new .colon.colon((Object)"> 1", (List)Nil$.MODULE$), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Tuple2 tuple2 = new Tuple2((Object)this.indexExpr().dataType(), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$11 -> x$11.dataType(), ClassTag$.MODULE$.apply(DataType.class)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DataType indexType = (DataType)tuple2._1();
        DataType[] inputTypes = (DataType[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)inputTypes);
        DataType indexType2 = (DataType)tuple22._1();
        DataType[] inputTypes2 = (DataType[])tuple22._2();
        DataType dataType = indexType2;
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr(this.indexExpr())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)indexType2))}))));
        }
        if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])inputTypes2), (Function1 & Serializable)tpe -> BoxesRunTime.boxToBoolean((boolean)Elt.$anonfun$checkInputDataTypes$2(tpe)))) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)(Cast$.MODULE$.ordinalNumber(1) + "...")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)(Cast$.MODULE$.toSQLType((AbstractDataType)StringType$.MODULE$) + " or " + Cast$.MODULE$.toSQLType((AbstractDataType)BinaryType$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)e -> Cast$.MODULE$.toSQLExpr((Expression)e), ClassTag$.MODULE$.apply(String.class))).mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])inputTypes2), (Function1 & Serializable)t -> Cast$.MODULE$.toSQLType((AbstractDataType)t), ClassTag$.MODULE$.apply(String.class))).mkString(","))}))));
        }
        return TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)inputTypes2).toImmutableArraySeq(), this.prettyName());
    }

    @Override
    public Object eval(InternalRow input) {
        Object indexObj = this.indexExpr().eval(input);
        if (indexObj == null) {
            return null;
        }
        int index = BoxesRunTime.unboxToInt((Object)indexObj);
        if (index <= 0 || index > this.inputExprs().length) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.invalidArrayIndexError(index, this.inputExprs().length, this.getContextOrNull());
            }
            return null;
        }
        return this.inputExprs()[index - 1].eval(input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        ExprCode index = this.indexExpr().genCode(ctx);
        ExprCode[] inputs = (ExprCode[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$13 -> x$13.genCode(ctx), ClassTag$.MODULE$.apply(ExprCode.class));
        String indexVal = ctx.freshName("index");
        String indexMatched = ctx.freshName("eltIndexMatched");
        String inputVal = ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), "inputVal", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String[] assignInputValue = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])inputs))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ExprCode eval = (ExprCode)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + indexVal + " == " + (index + 1) + ") {\n         |  " + eval.code() + "\n         |  " + inputVal + " = " + eval.isNull() + " ? null : " + eval.value() + ";\n         |  " + indexMatched + " = true;\n         |  continue;\n         |}\n      "));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class));
        Tuple2 tuple2 = new Tuple2((Object)"int", (Object)indexVal);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)assignInputValue).toImmutableArraySeq(), "eltFunc", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple2), "boolean", (Function1<String, String>)(Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |boolean " + indexMatched + " = false;\n           |do {\n           |  " + body + "\n           |} while (false);\n           |return " + indexMatched + ";\n         ")), (Function1<Seq<String>, String>)(Function1 & Serializable)x$14 -> ((IterableOnceOps)x$14.map((Function1 & Serializable)funcCall -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + indexMatched + " = " + funcCall + ";\n           |if (" + indexMatched + ") {\n           |  continue;\n           |}\n         ")))).mkString());
        if (this.failOnError()) {
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (!" + indexMatched + ") {\n         |  throw QueryExecutionErrors.invalidArrayIndexError(" + index.value() + ", " + this.inputExprs().length + ", " + errorContext + ");\n         |}\n       "));
        } else {
            string = "";
        }
        String indexOutOfBoundBranch = string;
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = ", ";\n         |", " ", " = null;\n         |if (!", ") {\n         |  final int ", " = ", ";\n         |  ", " ", " = false;\n         |  ", " = null;\n         |  do {\n         |    ", "\n         |  } while (false);\n         |  ", "\n         |  ", " = ", ";\n         |  ", " = ", " == null;\n         |}\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{index.code(), ev.isNull(), index.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), index.isNull(), indexVal, index.value(), "boolean", indexMatched, inputVal, codes, indexOutOfBoundBranch, ev.value(), inputVal, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public Elt withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    @Override
    public Option<QueryContext> initQueryContext() {
        if (this.failOnError()) {
            return new Some((Object)this.origin().context());
        }
        return None$.MODULE$;
    }

    public Elt copy(Seq<Expression> children2, boolean failOnError) {
        return new Elt(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Elt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Elt;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Elt)) return false;
        boolean bl = true;
        if (!bl) return false;
        Elt elt = (Elt)x$1;
        if (this.failOnError() != elt.failOnError()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = elt.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!elt.canEqual(this)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(DataType tpe) {
        if (tpe instanceof StringType) return false;
        DataType dataType = tpe;
        BinaryType$ binaryType$ = BinaryType$.MODULE$;
        if (dataType == null) {
            if (binaryType$ == null) return false;
            return true;
        } else if (dataType.equals(binaryType$)) return false;
        return true;
    }

    public Elt(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        SupportQueryContext.$init$(this);
    }

    public Elt(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

