/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.HiveHash$;
import org.apache.spark.sql.catalyst.expressions.HiveHashFunction$;
import org.apache.spark.sql.catalyst.expressions.HiveHasher;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a hash value of the arguments.", since="2.2.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\tEe\u0001\u0002\u0015*\u0001ZB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t1\u0002\u0011\t\u0012)A\u0005%\")\u0011\f\u0001C\u00015\"9Q\f\u0001b\u0001\n\u0003r\u0006BB0\u0001A\u0003%1\bC\u0003a\u0001\u0011\u0005\u0013\rC\u0003i\u0001\u0011\u0005\u0013\u000eC\u0003s\u0001\u0011E\u0013\u000eC\u0003t\u0001\u0011EC\u000fC\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u0013\u0005\u001d\u0002!%A\u0005\u0002\u0005%\u0002bBA \u0001\u0011E\u0013\u0011\t\u0005\b\u0003\u0017\u0002A\u0011KA'\u0011\u001d\t)\u0006\u0001C)\u0003/Bq!a\u0018\u0001\t#\n\t\u0007C\u0004\u0002t\u0001!\t&!\u001e\t\u000f\u0005m\u0004\u0001\"\u0015\u0002~!9\u00111\u0011\u0001\u0005R\u0005\u0015\u0005bBAL\u0001\u0011E\u0013\u0011\u0014\u0005\b\u0003_\u0003A\u0011KAY\u0011\u001d\t)\r\u0001C)\u0003\u000fDq!a8\u0001\t#\n\t\u000fC\u0005\u0002n\u0002\t\t\u0011\"\u0001\u0002p\"I\u00111\u001f\u0001\u0012\u0002\u0013\u0005\u0011Q\u001f\u0005\n\u0003s\u0004\u0011\u0011!C!\u0003wD\u0001Ba\u0003\u0001\u0003\u0003%\tA\u0018\u0005\n\u0005\u001b\u0001\u0011\u0011!C\u0001\u0005\u001fA\u0011B!\u0006\u0001\u0003\u0003%\tEa\u0006\t\u0013\t\u0015\u0002!!A\u0005\u0002\t\u001d\u0002\"\u0003B\u0016\u0001\u0005\u0005I\u0011\tB\u0017\u0011%\u0011\t\u0004AA\u0001\n\u0003\u0012\u0019dB\u0005\u0003R%\n\t\u0011#\u0001\u0003T\u0019A\u0001&KA\u0001\u0012\u0003\u0011)\u0006\u0003\u0004ZE\u0011\u0005!Q\u000e\u0005\n\u0005_\u0012\u0013\u0011!C#\u0005cB\u0011Ba\u001d#\u0003\u0003%\tI!\u001e\t\u0013\te$%!A\u0005\u0002\nm\u0004\"\u0003BDE\u0005\u0005I\u0011\u0002BE\u0005!A\u0015N^3ICND'B\u0001\u0016,\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00051j\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00019\u0014\t\u0012\t\u0004qeZT\"A\u0015\n\u0005iJ#A\u0004%bg\",\u0005\u0010\u001d:fgNLwN\u001c\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0004\u0013:$\bC\u0001\u001fC\u0013\t\u0019UHA\u0004Qe>$Wo\u0019;\u0011\u0005\u0015keB\u0001$L\u001d\t9%*D\u0001I\u0015\tIU'\u0001\u0004=e>|GOP\u0005\u0002}%\u0011A*P\u0001\ba\u0006\u001c7.Y4f\u0013\tquJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002M{\u0005A1\r[5mIJ,g.F\u0001S!\r)5+V\u0005\u0003)>\u00131aU3r!\tAd+\u0003\u0002XS\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002\\9B\u0011\u0001\b\u0001\u0005\u0006!\u000e\u0001\rAU\u0001\u0005g\u0016,G-F\u0001<\u0003\u0015\u0019X-\u001a3!\u0003!!\u0017\r^1UsB,W#\u00012\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015l\u0013!\u0002;za\u0016\u001c\u0018BA4e\u0005!!\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\t!\u000e\u0005\u0002l_:\u0011A.\u001c\t\u0003\u000fvJ!A\\\u001f\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]v\nq\u0002[1tQ\u0016\u00148\t\\1tg:\u000bW.Z\u0001\fG>l\u0007/\u001e;f\u0011\u0006\u001c\b\u000e\u0006\u0003<kj\\\b\"\u0002<\n\u0001\u00049\u0018!\u0002<bYV,\u0007C\u0001\u001fy\u0013\tIXHA\u0002B]fDQ\u0001Y\u0005A\u0002\tDQ!X\u0005A\u0002m\n\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u000by\fI!a\u0005\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A\u0015\u0002\u000f\r|G-Z4f]&!\u0011qAA\u0001\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0006\u0015\u0001\u0007\u0011QB\u0001\u0004GRD\bcA@\u0002\u0010%!\u0011\u0011CA\u0001\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!!\u0006\u000b\u0001\u0004q\u0018AA3w\u0003\u0011)g/\u00197\u0015\u0007m\nY\u0002C\u0005\u0002\u001e-\u0001\n\u00111\u0001\u0002 \u0005)\u0011N\u001c9viB!\u0011\u0011EA\u0012\u001b\u0005Y\u0013bAA\u0013W\tY\u0011J\u001c;fe:\fGNU8x\u00039)g/\u00197%I\u00164\u0017-\u001e7uIE*\"!a\u000b+\t\u0005}\u0011QF\u0016\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011H\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0005M\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qq-\u001a8ICND\u0017J\u001c;\u0015\u000b)\f\u0019%a\u0012\t\r\u0005\u0015S\u00021\u0001k\u0003\u0005I\u0007BBA%\u001b\u0001\u0007!.\u0001\u0004sKN,H\u000e^\u0001\fO\u0016t\u0007*Y:i\u0019>tw\rF\u0003k\u0003\u001f\n\u0019\u0006\u0003\u0004\u0002R9\u0001\rA[\u0001\u0002Y\"1\u0011\u0011\n\bA\u0002)\fAbZ3o\u0011\u0006\u001c\bNQ=uKN$RA[A-\u0003;Ba!a\u0017\u0010\u0001\u0004Q\u0017!\u00012\t\r\u0005%s\u00021\u0001k\u000399WM\u001c%bg\"$UmY5nC2$\u0012B[A2\u0003K\ny'!\u001d\t\u000f\u0005-\u0001\u00031\u0001\u0002\u000e!9\u0011q\r\tA\u0002\u0005%\u0014!\u00013\u0011\u0007\r\fY'C\u0002\u0002n\u0011\u00141\u0002R3dS6\fG\u000eV=qK\"1\u0011Q\u0004\tA\u0002)Da!!\u0013\u0011\u0001\u0004Q\u0017aF4f]\"\u000b7\u000f[\"bY\u0016tG-\u0019:J]R,'O^1m)\u0015Q\u0017qOA=\u0011\u0019\ti\"\u0005a\u0001U\"1\u0011\u0011J\tA\u0002)\f\u0001cZ3o\u0011\u0006\u001c\b\u000eV5nKN$\u0018-\u001c9\u0015\u000b)\fy(!!\t\r\u0005u!\u00031\u0001k\u0011\u0019\tIE\u0005a\u0001U\u0006iq-\u001a8ICND7\u000b\u001e:j]\u001e$\u0012B[AD\u0003\u0013\u000b\u0019*!&\t\u000f\u0005-1\u00031\u0001\u0002\u000e!9\u00111R\nA\u0002\u00055\u0015AC:ue&tw\rV=qKB\u00191-a$\n\u0007\u0005EEM\u0001\u0006TiJLgn\u001a+za\u0016Da!!\b\u0014\u0001\u0004Q\u0007BBA%'\u0001\u0007!.A\bhK:D\u0015m\u001d5G_J\f%O]1z)-Q\u00171TAO\u0003?\u000b\t+!*\t\u000f\u0005-A\u00031\u0001\u0002\u000e!1\u0011Q\u0004\u000bA\u0002)Da!!\u0013\u0015\u0001\u0004Q\u0007BBAR)\u0001\u0007!-A\u0006fY\u0016lWM\u001c;UsB,\u0007bBAT)\u0001\u0007\u0011\u0011V\u0001\rG>tG/Y5og:+H\u000e\u001c\t\u0004y\u0005-\u0016bAAW{\t9!i\\8mK\u0006t\u0017!D4f]\"\u000b7\u000f\u001b$pe6\u000b\u0007\u000fF\u0007k\u0003g\u000b),a.\u0002:\u0006u\u0016\u0011\u0019\u0005\b\u0003\u0017)\u0002\u0019AA\u0007\u0011\u0019\ti\"\u0006a\u0001U\"1\u0011\u0011J\u000bA\u0002)Da!a/\u0016\u0001\u0004\u0011\u0017aB6fsRK\b/\u001a\u0005\u0007\u0003\u007f+\u0002\u0019\u00012\u0002\u0013Y\fG.^3UsB,\u0007bBAb+\u0001\u0007\u0011\u0011V\u0001\u0012m\u0006dW/Z\"p]R\f\u0017N\\:Ok2d\u0017\u0001E4f]\"\u000b7\u000f\u001b$peN#(/^2u)%Q\u0017\u0011ZAf\u0003\u001b\fy\rC\u0004\u0002\fY\u0001\r!!\u0004\t\r\u0005ua\u00031\u0001k\u0011\u0019\tIE\u0006a\u0001U\"9\u0011\u0011\u001b\fA\u0002\u0005M\u0017A\u00024jK2$7\u000fE\u0003=\u0003+\fI.C\u0002\u0002Xv\u0012Q!\u0011:sCf\u00042aYAn\u0013\r\ti\u000e\u001a\u0002\f'R\u0014Xo\u0019;GS\u0016dG-A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u00191,a9\t\u000f\u0005\u0015x\u00031\u0001\u0002h\u0006Ya.Z<DQ&dGM]3o!\u0011)\u0015\u0011^+\n\u0007\u0005-xJ\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsR\u00191,!=\t\u000fAC\u0002\u0013!a\u0001%\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA|U\r\u0011\u0016QF\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\b\u0003BA\u0000\u0005\u0013i!A!\u0001\u000b\t\t\r!QA\u0001\u0005Y\u0006twM\u0003\u0002\u0003\b\u0005!!.\u0019<b\u0013\r\u0001(\u0011A\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r9(\u0011\u0003\u0005\t\u0005'a\u0012\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0007\u0011\u000b\tm!\u0011E<\u000e\u0005\tu!b\u0001B\u0010{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r\"Q\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002*\n%\u0002\u0002\u0003B\n=\u0005\u0005\t\u0019A<\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003{\u0014y\u0003\u0003\u0005\u0003\u0014}\t\t\u00111\u0001<\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0016B\u001b\u0011!\u0011\u0019\u0002IA\u0001\u0002\u00049\bf\u0004\u0001\u0003:\t}\"\u0011\tB#\u0005\u000f\u0012YE!\u0014\u0011\u0007a\u0012Y$C\u0002\u0003>%\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003D\u0005\u0011uLR+O\u0007~CS\r\u001f9sc1\u0002S\r\u001f9se1\u0002cF\f\u0018*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011iCND\u0007E^1mk\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013M]4v[\u0016tGo\u001d\u0018\u0002\u000bMLgnY3\"\u0005\t%\u0013!\u0002\u001a/e9\u0002\u0014!B4s_V\u0004\u0018E\u0001B(\u0003)A\u0017m\u001d5`MVt7m]\u0001\t\u0011&4X\rS1tQB\u0011\u0001HI\n\u0006E\t]#1\r\t\u0007\u00053\u0012yFU.\u000e\u0005\tm#b\u0001B/{\u00059!/\u001e8uS6,\u0017\u0002\u0002B1\u00057\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\u0011)Ga\u001b\u000e\u0005\t\u001d$\u0002\u0002B5\u0005\u000b\t!![8\n\u00079\u00139\u0007\u0006\u0002\u0003T\u0005AAo\\*ue&tw\r\u0006\u0002\u0002~\u0006)\u0011\r\u001d9msR\u00191La\u001e\t\u000bA+\u0003\u0019\u0001*\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0010BB!\u0011a$q\u0010*\n\u0007\t\u0005UH\u0001\u0004PaRLwN\u001c\u0005\t\u0005\u000b3\u0013\u0011!a\u00017\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t-\u0005\u0003BA\u0000\u0005\u001bKAAa$\u0003\u0002\t1qJ\u00196fGR\u0004")
public class HiveHash
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final int seed;

    public static Option<Seq<Expression>> unapply(HiveHash x$0) {
        return HiveHash$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<HiveHash, A> g) {
        return HiveHash$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, HiveHash> compose(Function1<A$, Seq<Expression>> g) {
        return HiveHash$.MODULE$.compose(g);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public int seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "hive-hash";
    }

    @Override
    public String hasherClassName() {
        return HiveHasher.class.getName();
    }

    @Override
    public int computeHash(Object value, DataType dataType, int seed) {
        return (int)HiveHashFunction$.MODULE$.hash(value, dataType, this.seed());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ev.isNull_$eq(FalseLiteral$.MODULE$);
        String childHash = ctx.freshName("childHash");
        Seq childrenHash = (Seq)this.children().map((Function1 & Serializable)child -> {
            ExprCode childGen = child.genCode(ctx);
            String codeToComputeHash = ctx.nullSafeExec(child.nullable(), ExprValue$.MODULE$.exprValueToString(childGen.isNull()), this.computeHash(ExprValue$.MODULE$.exprValueToString(childGen.value()), child.dataType(), childHash, ctx));
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + childGen.code() + "\n         |" + childHash + " = 0;\n         |" + codeToComputeHash + "\n         |" + ev.value() + " = (31 * " + ev.value() + ") + " + childHash + ";\n       "));
        });
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)childrenHash, "computeHash", (Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"int"), (Object)ExprValue$.MODULE$.exprValueToString(ev.value())), (List)Nil$.MODULE$), "int", (Function1<String, String>)(Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |int " + childHash + " = 0;\n           |" + body + "\n           |return " + ev.value() + ";\n         ")), (Function1<Seq<String>, String>)(Function1 & Serializable)x$9 -> ((IterableOnceOps)x$9.map((Function1 & Serializable)funcCall -> ev.value() + " = " + funcCall + ";")).mkString("\n"));
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |", " ", " = 0;\n         |", "\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"int", ev.value(), BoxesRunTime.boxToInteger((int)this.seed()), "int", childHash, codes})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    public int eval(InternalRow input) {
        int hash = this.seed();
        int len = this.children().length();
        for (int i = 0; i < len; ++i) {
            hash = 31 * hash + this.computeHash(((Expression)this.children().apply(i)).eval(input), ((Expression)this.children().apply(i)).dataType(), hash);
        }
        return hash;
    }

    @Override
    public InternalRow eval$default$1() {
        return null;
    }

    @Override
    public String genHashInt(String i, String result) {
        return result + " = " + this.hasherClassName() + ".hashInt(" + i + ");";
    }

    @Override
    public String genHashLong(String l, String result) {
        return result + " = " + this.hasherClassName() + ".hashLong(" + l + ");";
    }

    @Override
    public String genHashBytes(String b, String result) {
        return result + " = " + this.hasherClassName() + ".hashUnsafeBytes(" + b + ", Platform.BYTE_ARRAY_OFFSET, " + b + ".length);";
    }

    @Override
    public String genHashDecimal(CodegenContext ctx, DecimalType d, String input, String result) {
        return "\n      " + result + " = " + StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(HiveHashFunction$.MODULE$.getClass().getName()), "$") + ".normalizeDecimal(\n        " + input + ".toJavaBigDecimal()).hashCode();";
    }

    @Override
    public String genHashCalendarInterval(String input, String result) {
        return "\n      " + result + " = (int)\n        " + StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(HiveHashFunction$.MODULE$.getClass().getName()), "$") + ".hashCalendarInterval(" + input + ");\n     ";
    }

    @Override
    public String genHashTimestamp(String input, String result) {
        return "\n      " + result + " = (int) " + StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(HiveHashFunction$.MODULE$.getClass().getName()), "$") + ".hashTimestamp(" + input + ");\n     ";
    }

    @Override
    public String genHashString(CodegenContext ctx, StringType stringType, String input, String result) {
        if (stringType.supportsBinaryEquality()) {
            String baseObject = input + ".getBaseObject()";
            String baseOffset = input + ".getBaseOffset()";
            String numBytes = input + ".numBytes()";
            return result + " = " + this.hasherClassName() + ".hashUnsafeBytes(" + baseObject + ", " + baseOffset + ", " + numBytes + ");";
        }
        String stringHash = ctx.freshName("stringHash");
        return "\n        long " + stringHash + " = CollationFactory.fetchCollation(" + stringType.collationId() + ")\n          .hashFunction.applyAsLong(" + input + ");\n        " + result + " = " + this.hasherClassName() + ".hashLong(" + stringHash + ");\n      ";
    }

    @Override
    public String genHashForArray(CodegenContext ctx, String input, String result, DataType elementType, boolean containsNull) {
        String index = ctx.freshName("index");
        String childResult = ctx.freshName("childResult");
        return "\n        int " + childResult + " = 0;\n        for (int " + index + " = 0; " + index + " < " + input + ".numElements(); " + index + "++) {\n          " + childResult + " = 0;\n          " + this.nullSafeElementHash(input, index, containsNull, elementType, childResult, ctx) + ";\n          " + result + " = (31 * " + result + ") + " + childResult + ";\n        }\n      ";
    }

    @Override
    public String genHashForMap(CodegenContext ctx, String input, String result, DataType keyType, DataType valueType, boolean valueContainsNull) {
        String index = ctx.freshName("index");
        String keys = ctx.freshName("keys");
        String values = ctx.freshName("values");
        String keyResult = ctx.freshName("keyResult");
        String valueResult = ctx.freshName("valueResult");
        return "\n        final ArrayData " + keys + " = " + input + ".keyArray();\n        final ArrayData " + values + " = " + input + ".valueArray();\n        int " + keyResult + " = 0;\n        int " + valueResult + " = 0;\n        for (int " + index + " = 0; " + index + " < " + input + ".numElements(); " + index + "++) {\n          " + keyResult + " = 0;\n          " + this.nullSafeElementHash(keys, index, false, keyType, keyResult, ctx) + "\n          " + valueResult + " = 0;\n          " + this.nullSafeElementHash(values, index, valueContainsNull, valueType, valueResult, ctx) + "\n          " + result + " += " + keyResult + " ^ " + valueResult + ";\n        }\n      ";
    }

    @Override
    public String genHashForStruct(CodegenContext ctx, String input, String result, StructField[] fields) {
        String tmpInput = ctx.freshName("input");
        String childResult = ctx.freshName("childResult");
        String[] fieldsHash = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])fields))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                int index = tuple2._2$mcI$sp();
                String computeFieldHash = this.nullSafeElementHash(tmpInput, Integer.toString(index), field.nullable(), field.dataType(), childResult, ctx);
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + childResult + " = 0;\n         |" + computeFieldHash + "\n         |" + result + " = (31 * " + result + ") + " + childResult + ";\n       "));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class));
        String code = ctx.splitExpressions((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)fieldsHash).toImmutableArraySeq(), "computeHashForStruct", (Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"InternalRow"), (Object)tmpInput), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"int"), (Object)result), (List)Nil$.MODULE$)), "int", (Function1<String, String>)(Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |int " + childResult + " = 0;\n           |" + body + "\n           |return " + result + ";\n           ")), (Function1<Seq<String>, String>)(Function1 & Serializable)x$10 -> ((IterableOnceOps)x$10.map((Function1 & Serializable)funcCall -> result + " = " + funcCall + ";")).mkString("\n"));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |final InternalRow " + tmpInput + " = " + input + ";\n       |int " + childResult + " = 0;\n       |" + code + "\n     "));
    }

    @Override
    public HiveHash withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public HiveHash copy(Seq<Expression> children2) {
        return new HiveHash(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "HiveHash";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HiveHash;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HiveHash)) return false;
        boolean bl = true;
        if (!bl) return false;
        HiveHash hiveHash = (HiveHash)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = hiveHash.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!hiveHash.canEqual(this)) return false;
        return true;
    }

    public HiveHash(Seq<Expression> children2) {
        this.children = children2;
        this.seed = 0;
    }
}

