/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005%3QAB\u0004\u0002\u0002QAQa\u0007\u0001\u0005\u0002qAQa\b\u0001\u0007\u0012\u0001BQa\u000b\u0001\u0007\u00121BQ\u0001\r\u0001\u0007\u0012EBQ!\u000f\u0001\u0005\u0002i\u0012q#\u00138uKJ\u0004(/\u001a;fI\"\u000b7\u000f\u001b$v]\u000e$\u0018n\u001c8\u000b\u0005!I\u0011aC3yaJ,7o]5p]NT!AC\u0006\u0002\u0011\r\fG/\u00197zgRT!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\tq!A\u0004iCND\u0017J\u001c;\u0015\u0007\u0005\"\u0013\u0006\u0005\u0002\u0017E%\u00111e\u0006\u0002\u0005\u0019>tw\rC\u0003&\u0005\u0001\u0007a%A\u0001j!\t1r%\u0003\u0002)/\t\u0019\u0011J\u001c;\t\u000b)\u0012\u0001\u0019A\u0011\u0002\tM,W\rZ\u0001\tQ\u0006\u001c\b\u000eT8oOR\u0019\u0011%L\u0018\t\u000b9\u001a\u0001\u0019A\u0011\u0002\u00031DQAK\u0002A\u0002\u0005\nq\u0002[1tQVs7/\u00194f\u0005f$Xm\u001d\u000b\u0006CI\"d\u0007\u000f\u0005\u0006g\u0011\u0001\r!F\u0001\u0005E\u0006\u001cX\rC\u00036\t\u0001\u0007\u0011%\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0006o\u0011\u0001\rAJ\u0001\u0007Y\u0016tw\r\u001e5\t\u000b)\"\u0001\u0019A\u0011\u0002\t!\f7\u000f\u001b\u000b\u0005Cm\u0002\u0005\nC\u0003=\u000b\u0001\u0007Q(A\u0003wC2,X\r\u0005\u0002\u0017}%\u0011qh\u0006\u0002\u0004\u0003:L\b\"B!\u0006\u0001\u0004\u0011\u0015\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015[\u0011!\u0002;za\u0016\u001c\u0018BA$E\u0005!!\u0015\r^1UsB,\u0007\"\u0002\u0016\u0006\u0001\u0004\t\u0003")
public abstract class InterpretedHashFunction {
    public abstract long hashInt(int var1, long var2);

    public abstract long hashLong(long var1, long var3);

    public abstract long hashUnsafeBytes(Object var1, long var2, int var4, long var5);

    public long hash(Object value, DataType dataType, long seed) {
        boolean bl = false;
        float f = 0.0f;
        boolean bl2 = false;
        double d = 0.0;
        Object object = value;
        if (object == null) {
            return seed;
        }
        if (object instanceof Boolean) {
            boolean bl3 = BoxesRunTime.unboxToBoolean((Object)object);
            return this.hashInt(bl3 ? 1 : 0, seed);
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return this.hashInt(by, seed);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return this.hashInt(s, seed);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return this.hashInt(n, seed);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return this.hashLong(l, seed);
        }
        if (object instanceof Float) {
            bl = true;
            f = BoxesRunTime.unboxToFloat((Object)object);
            if (f == -0.0f) {
                return this.hashInt(0, seed);
            }
        }
        if (bl) {
            return this.hashInt(Float.floatToIntBits(f), seed);
        }
        if (object instanceof Double) {
            bl2 = true;
            d = BoxesRunTime.unboxToDouble((Object)object);
            if (d == -0.0) {
                return this.hashLong(0L, seed);
            }
        }
        if (bl2) {
            return this.hashLong(Double.doubleToLongBits(d), seed);
        }
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            int precision = ((DecimalType)dataType).precision();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                return this.hashLong(decimal.toUnscaledLong(), seed);
            }
            byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
            return this.hashUnsafeBytes(bytes, Platform.BYTE_ARRAY_OFFSET, bytes.length, seed);
        }
        if (object instanceof CalendarInterval) {
            CalendarInterval calendarInterval = (CalendarInterval)object;
            return this.hashInt(calendarInterval.months, this.hashInt(calendarInterval.days, this.hashLong(calendarInterval.microseconds, seed)));
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return this.hashUnsafeBytes(byArray, Platform.BYTE_ARRAY_OFFSET, byArray.length, seed);
        }
        if (object instanceof UTF8String) {
            UTF8String uTF8String = (UTF8String)object;
            StringType st = (StringType)dataType;
            if (st.supportsBinaryEquality()) {
                return this.hashUnsafeBytes(uTF8String.getBaseObject(), uTF8String.getBaseOffset(), uTF8String.numBytes(), seed);
            }
            long stringHash = CollationFactory.fetchCollation((int)st.collationId()).hashFunction.applyAsLong(uTF8String);
            return this.hashLong(stringHash, seed);
        }
        if (object instanceof ArrayData) {
            DataType dataType2;
            ArrayData arrayData = (ArrayData)object;
            DataType dataType3 = dataType;
            if (dataType3 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = ((ArrayType)userDefinedType.sqlType()).elementType();
            } else if (dataType3 instanceof ArrayType) {
                DataType et;
                ArrayType arrayType = (ArrayType)dataType3;
                dataType2 = et = arrayType.elementType();
            } else {
                throw new MatchError((Object)dataType3);
            }
            DataType elementType = dataType2;
            long result = seed;
            for (int i = 0; i < arrayData.numElements(); ++i) {
                result = this.hash(arrayData.get(i, elementType), elementType, result);
            }
            return result;
        }
        if (object instanceof MapData) {
            Tuple2 tuple2;
            MapData mapData = (MapData)object;
            DataType dataType4 = dataType;
            if (dataType4 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType4;
                MapType mapType = (MapType)userDefinedType.sqlType();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapType.keyType()), (Object)mapType.valueType());
            } else if (dataType4 instanceof MapType) {
                MapType mapType = (MapType)dataType4;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)kt), (Object)vt);
            } else {
                throw new MatchError((Object)dataType4);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            DataType kt = (DataType)tuple22._1();
            DataType vt = (DataType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)kt, (Object)vt);
            DataType kt2 = (DataType)tuple23._1();
            DataType vt2 = (DataType)tuple23._2();
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            long result = seed;
            for (int i = 0; i < mapData.numElements(); ++i) {
                result = this.hash(keys.get(i, kt2), kt2, result);
                result = this.hash(values.get(i, vt2), vt2, result);
            }
            return result;
        }
        if (object instanceof InternalRow) {
            DataType[] dataTypeArray;
            InternalRow internalRow = (InternalRow)object;
            DataType dataType5 = dataType;
            if (dataType5 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType5;
                dataTypeArray = (DataType[])((IterableOnceOps)((StructType)userDefinedType.sqlType()).map((Function1 & Serializable)x$7 -> x$7.dataType())).toArray(ClassTag$.MODULE$.apply(DataType.class));
            } else if (dataType5 instanceof StructType) {
                StructType structType = (StructType)dataType5;
                StructField[] fields = structType.fields();
                dataTypeArray = (DataType[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$8 -> x$8.dataType(), ClassTag$.MODULE$.apply(DataType.class));
            } else {
                throw new MatchError((Object)dataType5);
            }
            DataType[] types = dataTypeArray;
            long result = seed;
            int len = internalRow.numFields();
            for (int i = 0; i < len; ++i) {
                result = this.hash(internalRow.get(i, types[i]), types[i], result);
            }
            return result;
        }
        throw new MatchError(object);
    }
}

