/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BaseOrdering;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.InterpretedOrdering$;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsFirst$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005i4Aa\u0003\u0007\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u00031\u0001\u0011\u0005\u0011\u0007\u0003\u00055\u0001!\u0015\r\u0011\"\u00036\u0011\u0015\u0001\u0004\u0001\"\u0001D\u0011\u0015Y\u0005\u0001\"\u0011M\u000f\u0015IF\u0002#\u0001[\r\u0015YA\u0002#\u0001\\\u0011\u0015\u0001t\u0001\"\u0001h\u0011\u0015Aw\u0001\"\u0001j\u0011\u001d\u0011x!!A\u0005\nM\u00141#\u00138uKJ\u0004(/\u001a;fI>\u0013H-\u001a:j]\u001eT!!\u0004\b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u001fA\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u00031I!!\b\u0007\u0003\u0019\t\u000b7/Z(sI\u0016\u0014\u0018N\\4\u0002\u0011=\u0014H-\u001a:j]\u001e\u00042\u0001\t\u0016.\u001d\t\tsE\u0004\u0002#K5\t1E\u0003\u0002%1\u00051AH]8pizJ\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q%\nq\u0001]1dW\u0006<WMC\u0001'\u0013\tYCFA\u0002TKFT!\u0001K\u0015\u0011\u0005mq\u0013BA\u0018\r\u0005%\u0019vN\u001d;Pe\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0003eM\u0002\"a\u0007\u0001\t\u000by\u0011\u0001\u0019A\u0010\u0002#AD\u0017p]5dC2$\u0015\r^1UsB,7/F\u00017!\r9D(P\u0007\u0002q)\u0011\u0011HO\u0001\nS6lW\u000f^1cY\u0016T!aO\u0015\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002,qA\u0011a(Q\u0007\u0002\u007f)\u0011\u0001ID\u0001\u0006if\u0004Xm]\u0005\u0003\u0005~\u0012\u0001\u0003\u00155zg&\u001c\u0017\r\u001c#bi\u0006$\u0016\u0010]3\u0015\u0007I\"U\tC\u0003\u001f\t\u0001\u0007q\u0004C\u0003G\t\u0001\u0007q)A\u0006j]B,HoU2iK6\f\u0007c\u0001\u0011+\u0011B\u00111$S\u0005\u0003\u00152\u0011\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u000f\r|W\u000e]1sKR\u0019Q*U,\u0011\u00059{U\"A\u0015\n\u0005AK#aA%oi\")!+\u0002a\u0001'\u0006\t\u0011\r\u0005\u0002U+6\ta\"\u0003\u0002W\u001d\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015AV\u00011\u0001T\u0003\u0005\u0011\u0017aE%oi\u0016\u0014\bO]3uK\u0012|%\u000fZ3sS:<\u0007CA\u000e\b'\r9Al\u0018\t\u0003\u001dvK!AX\u0015\u0003\r\u0005s\u0017PU3g!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0002j_*\tA-\u0001\u0003kCZ\f\u0017B\u00014b\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005Q\u0016!\u00034peN\u001b\u0007.Z7b)\t\u0011$\u000eC\u0003l\u0013\u0001\u0007A.A\u0005eCR\fG+\u001f9fgB\u0019\u0001EK7\u0011\u00059\u0004X\"A8\u000b\u0005\u0001\u0003\u0012BA9p\u0005!!\u0015\r^1UsB,\u0017\u0001D<sSR,'+\u001a9mC\u000e,G#\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0005]\u001c\u0017\u0001\u00027b]\u001eL!!\u001f<\u0003\r=\u0013'.Z2u\u0001")
public class InterpretedOrdering
extends BaseOrdering {
    private Seq<PhysicalDataType> physicalDataTypes;
    private final Seq<SortOrder> ordering;
    private volatile boolean bitmap$0;

    public static InterpretedOrdering forSchema(Seq<DataType> dataTypes) {
        return InterpretedOrdering$.MODULE$.forSchema(dataTypes);
    }

    private Seq<PhysicalDataType> physicalDataTypes$lzycompute() {
        InterpretedOrdering interpretedOrdering = this;
        synchronized (interpretedOrdering) {
            if (!this.bitmap$0) {
                this.physicalDataTypes = (Seq)this.ordering.map((Function1 & Serializable)order -> {
                    DataType dataType;
                    DataType dataType2 = order.dataType();
                    if (dataType2 instanceof UserDefinedType) {
                        UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                        dataType = userDefinedType.sqlType();
                    } else {
                        dataType = order.dataType();
                    }
                    DataType dt = dataType;
                    return PhysicalDataType$.MODULE$.apply(dt);
                });
                this.bitmap$0 = true;
            }
        }
        return this.physicalDataTypes;
    }

    private Seq<PhysicalDataType> physicalDataTypes() {
        if (!this.bitmap$0) {
            return this.physicalDataTypes$lzycompute();
        }
        return this.physicalDataTypes;
    }

    @Override
    public int compare(InternalRow a, InternalRow b) {
        int size = this.ordering.size();
        for (int i = 0; i < size; ++i) {
            int n;
            SortOrder order = (SortOrder)this.ordering.apply(i);
            Object left = order.child().eval(a);
            Object right = order.child().eval(b);
            if (left == null && right == null) continue;
            if (left == null) {
                NullOrdering nullOrdering = order.nullOrdering();
                NullsFirst$ nullsFirst$ = NullsFirst$.MODULE$;
                if (!(nullOrdering != null ? !nullOrdering.equals(nullsFirst$) : nullsFirst$ != null)) {
                    return -1;
                }
                return 1;
            }
            if (right == null) {
                NullOrdering nullOrdering = order.nullOrdering();
                NullsFirst$ nullsFirst$ = NullsFirst$.MODULE$;
                if (!(nullOrdering != null ? !nullOrdering.equals(nullsFirst$) : nullsFirst$ != null)) {
                    return 1;
                }
                return -1;
            }
            Ordering<Object> orderingFunc = ((PhysicalDataType)this.physicalDataTypes().apply(i)).ordering();
            DataType dataType = order.dataType();
            SortDirection sortDirection = order.direction();
            Ascending$ ascending$ = Ascending$.MODULE$;
            if (!(sortDirection != null ? !sortDirection.equals(ascending$) : ascending$ != null)) {
                n = orderingFunc.compare(left, right);
            } else {
                SortDirection sortDirection2 = order.direction();
                Descending$ descending$ = Descending$.MODULE$;
                if (!(sortDirection2 != null ? !sortDirection2.equals(descending$) : descending$ != null)) {
                    n = -orderingFunc.compare(left, right);
                } else {
                    throw new MatchError((Object)dataType);
                }
            }
            int comparison = n;
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public InterpretedOrdering(Seq<SortOrder> ordering) {
        this.ordering = ordering;
    }

    public InterpretedOrdering(Seq<SortOrder> ordering, Seq<Attribute> inputSchema) {
        this(BindReferences$.MODULE$.bindReferences(ordering, package$.MODULE$.AttributeSeq(inputSchema)));
    }
}

