/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.IsNaN$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns true if `expr` is NaN, or false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double));\n       true\n  ", since="1.5.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\")!\n\u0001C\u0001\u0017\")a\n\u0001C!\u001f\")\u0011\f\u0001C!5\")a\f\u0001C!?\")\u0011\u000e\u0001C!U\")\u0001\u0010\u0001C)s\"9A\u0010AA\u0001\n\u0003i\b\u0002C@\u0001#\u0003%\t!!\u0001\t\u0013\u0005]\u0001!!A\u0005B\u0005e\u0001\"CA\u0016\u0001\u0005\u0005I\u0011AA\u0017\u0011%\t)\u0004AA\u0001\n\u0003\t9\u0004C\u0005\u0002>\u0001\t\t\u0011\"\u0011\u0002@!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003'\u0002\u0011\u0011!C!\u0003+B\u0011\"!\u0017\u0001\u0003\u0003%\t%a\u0017\b\u0013\u0005}$$!A\t\u0002\u0005\u0005e\u0001C\r\u001b\u0003\u0003E\t!a!\t\r)\u001bB\u0011AAN\u0011%\tijEA\u0001\n\u000b\ny\nC\u0005\u0002\"N\t\t\u0011\"!\u0002$\"I\u0011qU\n\u0002\u0002\u0013\u0005\u0015\u0011\u0016\u0005\n\u0003k\u001b\u0012\u0011!C\u0005\u0003o\u0013Q!S:OC:S!a\u0007\u000f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003;y\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003?\u0001\n1a]9m\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0007\u0001!bsF\r\u001d\u0011\u0005%RS\"\u0001\u000e\n\u0005-R\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005%j\u0013B\u0001\u0018\u001b\u0005%\u0001&/\u001a3jG\u0006$X\r\u0005\u0002*a%\u0011\u0011G\u0007\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t9\u0001K]8ek\u000e$\bCA\u001dB\u001d\tQtH\u0004\u0002<}5\tAH\u0003\u0002>M\u00051AH]8pizJ\u0011!N\u0005\u0003\u0001R\nq\u0001]1dW\u0006<W-\u0003\u0002C\u0007\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001\tN\u0001\u0006G\"LG\u000eZ\u000b\u0002\rB\u0011\u0011fR\u0005\u0003\u0011j\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"\u0001T'\u0011\u0005%\u0002\u0001\"\u0002#\u0004\u0001\u00041\u0015AC5oaV$H+\u001f9fgV\t\u0001\u000bE\u0002:#NK!AU\"\u0003\u0007M+\u0017\u000f\u0005\u0002U/6\tQK\u0003\u0002W=\u0005)A/\u001f9fg&\u0011\u0001,\u0016\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u00027B\u00111\u0007X\u0005\u0003;R\u0012qAQ8pY\u0016\fg.\u0001\u0003fm\u0006dGC\u00011d!\t\u0019\u0014-\u0003\u0002ci\t\u0019\u0011I\\=\t\u000f\u00114\u0001\u0013!a\u0001K\u0006)\u0011N\u001c9viB\u0011amZ\u0007\u00029%\u0011\u0001\u000e\b\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u00191.\u001d<\u0011\u00051|W\"A7\u000b\u00059T\u0012aB2pI\u0016<WM\\\u0005\u0003a6\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006e\u001e\u0001\ra]\u0001\u0004GRD\bC\u00017u\u0013\t)XN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000b]<\u0001\u0019A6\u0002\u0005\u00154\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000e\u0006\u0002Mu\")1\u0010\u0003a\u0001\r\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHC\u0001'\u007f\u0011\u001d!\u0015\u0002%AA\u0002\u0019\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0004)\u001aa)!\u0002,\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00055\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\tYAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tA\u0001\\1oO*\u0011\u0011QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005}!AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00020A\u00191'!\r\n\u0007\u0005MBGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002a\u0003sA\u0011\"a\u000f\u000e\u0003\u0003\u0005\r!a\f\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0005E\u0003\u0002D\u0005%\u0003-\u0004\u0002\u0002F)\u0019\u0011q\t\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\u0005\u0015#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aWA)\u0011!\tYdDA\u0001\u0002\u0004\u0001\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0007\u0002X!I\u00111\b\t\u0002\u0002\u0003\u0007\u0011qF\u0001\u0007KF,\u0018\r\\:\u0015\u0007m\u000bi\u0006\u0003\u0005\u0002<E\t\t\u00111\u0001aQM\u0001\u0011\u0011MA4\u0003S\ni'a\u001c\u0002t\u0005U\u0014\u0011PA>!\rI\u00131M\u0005\u0004\u0003KR\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003W\n\u0011i\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011ueV,\u0007%\u001b4!A\u0016D\bO\u001d1!SN\u0004c*\u0019(-A=\u0014\bEZ1mg\u0016\u0004s\u000e\u001e5fe^L7/\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u001d\u0002\u0017*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3-Y:uQ\u001dr\u0015MT\u0014!CN\u0004Cm\\;cY\u0016L\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005]\u0014!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAA?\u0003=\u0001(/\u001a3jG\u0006$Xm\u00184v]\u000e\u001c\u0018!B%t\u001d\u0006t\u0005CA\u0015\u0014'\u0015\u0019\u0012QQAI!\u0019\t9)!$G\u00196\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017#\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u001f\u000bIIA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000b\u0019#\u0001\u0002j_&\u0019!)!&\u0015\u0005\u0005\u0005\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0011!B1qa2LHc\u0001'\u0002&\")AI\u0006a\u0001\r\u00069QO\\1qa2LH\u0003BAV\u0003c\u0003BaMAW\r&\u0019\u0011q\u0016\u001b\u0003\r=\u0003H/[8o\u0011!\t\u0019lFA\u0001\u0002\u0004a\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0018\t\u0005\u0003;\tY,\u0003\u0003\u0002>\u0006}!AB(cU\u0016\u001cG\u000f")
public class IsNaN
extends UnaryExpression
implements Predicate,
ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(IsNaN x$0) {
        return IsNaN$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<IsNaN, A> g) {
        return IsNaN$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, IsNaN> compose(Function1<A$, Expression> g) {
        return IsNaN$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            return BoxesRunTime.boxToBoolean((boolean)false);
        }
        DataType dataType = this.child().dataType();
        if (DoubleType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToBoolean((boolean)Double.isNaN(BoxesRunTime.unboxToDouble((Object)value)));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToBoolean((boolean)Float.isNaN(BoxesRunTime.unboxToFloat((Object)value)));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval = this.child().genCode(ctx);
        DataType dataType = this.child().dataType();
        if (DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType)) {
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          ", " ", " = ", ";\n          ", " = !", " && Double.isNaN(", ");"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.value(), eval.isNull(), eval.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public IsNaN withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public IsNaN copy(Expression child) {
        return new IsNaN(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "IsNaN";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IsNaN;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IsNaN)) return false;
        boolean bl = true;
        if (!bl) return false;
        IsNaN isNaN = (IsNaN)x$1;
        Expression expression = this.child();
        Expression expression2 = isNaN.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!isNaN.canEqual(this)) return false;
        return true;
    }

    public IsNaN(Expression child) {
        this.child = child;
        Predicate.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

