/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.StructsToJson$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.json.StructsToJsonEvaluator;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a JSON string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       {\"a\":1,\"b\":2}\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"26/08/2015\"}\n      > SELECT _FUNC_(array(named_struct('a', 1, 'b', 2)));\n       [{\"a\":1,\"b\":2}]\n      > SELECT _FUNC_(map('a', named_struct('b', 1)));\n       {\"a\":{\"b\":1}}\n      > SELECT _FUNC_(map(named_struct('a', 1),named_struct('b', 2)));\n       {\"[1]\":{\"b\":2}}\n      > SELECT _FUNC_(map('a', 1));\n       {\"a\":1}\n      > SELECT _FUNC_(array(map('a', 1)));\n       [{\"a\":1}]\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\t5e\u0001B\u0015+\u0001^B\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\t[\u0002\u0011\t\u0012)A\u0005E\"Aa\u000e\u0001BK\u0002\u0013\u0005q\u000e\u0003\u0005t\u0001\tE\t\u0015!\u0003q\u0011!!\bA!f\u0001\n\u0003)\b\u0002C=\u0001\u0005#\u0005\u000b\u0011\u0002<\t\u000bi\u0004A\u0011A>\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u00111\u0002\u0001\u0005B\u00055\u0001B\u0002>\u0001\t\u0003\ty\u0004\u0003\u0004{\u0001\u0011\u0005\u0011Q\t\u0005\u0007u\u0002!\t!!\u0013\t\u0015\u0005=\u0003\u0001#b\u0001\n\u0013\t\t\u0006C\u0004\u0002h\u0001!\t%!\u001b\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z!9\u0011Q\u0010\u0001\u0005B\u0005}\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003\u001b\u0003A\u0011KAH\u0011)\t)\n\u0001EC\u0002\u0013%\u0011q\u0013\u0005\u0007\u0003O\u0003A\u0011I8\t\u0013\u0005%\u0006!!A\u0005\u0002\u0005-\u0006\"CAZ\u0001E\u0005I\u0011AA[\u0011%\tY\rAI\u0001\n\u0003\ti\rC\u0005\u0002R\u0002\t\n\u0011\"\u0001\u0002T\"I\u0011q\u001b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\n\u0003S\u0004\u0011\u0011!C\u0001\u0003WD\u0011\"a=\u0001\u0003\u0003%\t!!>\t\u0013\t\u0005\u0001!!A\u0005B\t\r\u0001\"\u0003B\t\u0001\u0005\u0005I\u0011\u0001B\n\u0011%\u00119\u0002AA\u0001\n\u0003\u0012I\u0002C\u0005\u0003\u001e\u0001\t\t\u0011\"\u0011\u0003 \u001dI!1\t\u0016\u0002\u0002#\u0005!Q\t\u0004\tS)\n\t\u0011#\u0001\u0003H!1!0\tC\u0001\u0005?B\u0011B!\u0019\"\u0003\u0003%)Ea\u0019\t\u0013\t\u0015\u0014%!A\u0005\u0002\n\u001d\u0004\"\u0003B8CE\u0005I\u0011AAj\u0011%\u0011\t(IA\u0001\n\u0003\u0013\u0019\bC\u0005\u0003\u0002\u0006\n\n\u0011\"\u0001\u0002T\"I!1Q\u0011\u0002\u0002\u0013%!Q\u0011\u0002\u000e'R\u0014Xo\u0019;t)>T5o\u001c8\u000b\u0005-b\u0013aC3yaJ,7o]5p]NT!!\f\u0018\u0002\u0011\r\fG/\u00197zgRT!a\f\u0019\u0002\u0007M\fHN\u0003\u00022e\u0005)1\u000f]1sW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019\u0012\u0002\u0001\u001d=\u007f\t+\u0005J\u0014+\u0011\u0005eRT\"\u0001\u0016\n\u0005mR#aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ej\u0014B\u0001 +\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005e\u0002\u0015BA!+\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003s\rK!\u0001\u0012\u0016\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007CA\u001dG\u0013\t9%F\u0001\u0011EK\u001a\fW\u000f\u001c;TiJLgn\u001a)s_\u0012,8-\u001b8h\u000bb\u0004(/Z:tS>t\u0007CA%M\u001b\u0005Q%BA&/\u0003\u0019)'O]8sg&\u0011QJ\u0013\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011qJU\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n9\u0001K]8ek\u000e$\bCA+^\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Zm\u00051AH]8pizJ\u0011!U\u0005\u00039B\u000bq\u0001]1dW\u0006<W-\u0003\u0002_?\na1+\u001a:jC2L'0\u00192mK*\u0011A\fU\u0001\b_B$\u0018n\u001c8t+\u0005\u0011\u0007\u0003B2hU*t!\u0001Z3\u0011\u0005]\u0003\u0016B\u00014Q\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0004\u001b\u0006\u0004(B\u00014Q!\t\u00197.\u0003\u0002mS\n11\u000b\u001e:j]\u001e\f\u0001b\u001c9uS>t7\u000fI\u0001\u0006G\"LG\u000eZ\u000b\u0002aB\u0011\u0011(]\u0005\u0003e*\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005QA/[7f5>tW-\u00133\u0016\u0003Y\u00042aT<k\u0013\tA\bK\u0001\u0004PaRLwN\\\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005yvtx\u0010\u0005\u0002:\u0001!)\u0001m\u0002a\u0001E\")an\u0002a\u0001a\"9Ao\u0002I\u0001\u0002\u00041\u0018\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005\u0015\u0001cA(\u0002\b%\u0019\u0011\u0011\u0002)\u0003\u000f\t{w\u000e\\3b]\u0006!bn\u001c3f!\u0006$H/\u001a:og&sG/\u001a:oC2$\"!a\u0004\u0011\u000bU\u000b\t\"!\u0006\n\u0007\u0005MqLA\u0002TKF\u0004B!a\u0006\u0002:9!\u0011\u0011DA\u001a\u001d\u0011\tY\"a\f\u000f\t\u0005u\u0011Q\u0006\b\u0005\u0003?\tYC\u0004\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003Oq1aVA\u0013\u0013\u0005)\u0014BA\u001a5\u0013\t\t$'\u0003\u00020a%\u0011QFL\u0005\u0004\u0003ca\u0013!\u0002;sK\u0016\u001c\u0018\u0002BA\u001b\u0003o\t1\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u0011\u0011\u0007\u0017\n\t\u0005m\u0012Q\b\u0002\f)J,W\rU1ui\u0016\u0014hN\u0003\u0003\u00026\u0005]B#\u0002?\u0002B\u0005\r\u0003\"\u00021\u000b\u0001\u0004\u0011\u0007\"\u00028\u000b\u0001\u0004\u0001Hc\u0001?\u0002H!)an\u0003a\u0001aR)A0a\u0013\u0002N!)a\u000e\u0004a\u0001a\")\u0001\r\u0004a\u0001a\u0006Y\u0011N\u001c9viN\u001b\u0007.Z7b+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005mSBAA,\u0015\r\tIFL\u0001\u0006if\u0004Xm]\u0005\u0005\u0003;\n9F\u0001\u0005ECR\fG+\u001f9fQ\ri\u0011\u0011\r\t\u0004\u001f\u0006\r\u0014bAA3!\nIAO]1og&,g\u000e^\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003W\u0002B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003cb\u0013\u0001C1oC2L8/[:\n\t\u0005U\u0014q\u000e\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006aq/\u001b;i)&lWMW8oKR\u0019!)a\u001f\t\u000bQ|\u0001\u0019\u00016\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002\u0002B)Q+!\u0005\u0002\u0004B!\u0011QKAC\u0013\u0011\t9)a\u0016\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\t!.\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004y\u0006E\u0005BBAJ%\u0001\u0007\u0001/\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003%)g/\u00197vCR|'/\u0006\u0002\u0002\u001aB!\u00111TAQ\u001b\t\tiJC\u0002\u0002 *\nAA[:p]&!\u00111UAO\u0005Y\u0019FO];diN$vNS:p]\u00163\u0018\r\\;bi>\u0014\bfA\n\u0002b\u0005Y!/\u001a9mC\u000e,W.\u001a8u\u0003\u0011\u0019w\u000e]=\u0015\u000fq\fi+a,\u00022\"9\u0001-\u0006I\u0001\u0002\u0004\u0011\u0007b\u00028\u0016!\u0003\u0005\r\u0001\u001d\u0005\biV\u0001\n\u00111\u0001w\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a.+\u0007\t\fIl\u000b\u0002\u0002<B!\u0011QXAd\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017!C;oG\",7m[3e\u0015\r\t)\rU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAe\u0003\u007f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a4+\u0007A\fI,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U'f\u0001<\u0002:\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a7\u0011\t\u0005u\u0017q]\u0007\u0003\u0003?TA!!9\u0002d\u0006!A.\u00198h\u0015\t\t)/\u0001\u0003kCZ\f\u0017b\u00017\u0002`\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u001e\t\u0004\u001f\u0006=\u0018bAAy!\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011q_A\u007f!\ry\u0015\u0011`\u0005\u0004\u0003w\u0004&aA!os\"I\u0011q`\u000e\u0002\u0002\u0003\u0007\u0011Q^\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0015\u0001C\u0002B\u0004\u0005\u001b\t90\u0004\u0002\u0003\n)\u0019!1\u0002)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0010\t%!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0002\u0003\u0016!I\u0011q`\u000f\u0002\u0002\u0003\u0007\u0011q_\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\\\nm\u0001\"CA\u0000=\u0005\u0005\t\u0019AAw\u0003\u0019)\u0017/^1mgR!\u0011Q\u0001B\u0011\u0011%\typHA\u0001\u0002\u0004\t9\u0010K\n\u0001\u0005K\u0011YC!\f\u00032\tM\"q\u0007B\u001d\u0005{\u0011y\u0004E\u0002:\u0005OI1A!\u000b+\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\f\u0002\u0013~3UKT\"`Q\u0015D\bO].-A=\u0004H/[8ogvK\u0003%\f\u0011SKR,(O\\:!C\u0002R5k\u0014(!gR\u0014\u0018N\\4!o&$\b\u000eI1!O&4XM\u001c\u0011tiJ,8\r\u001e\u0011wC2,X-\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011)$\u0001Cb\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"r\u0017-\\3e?N$(/^2uQ\u001d\nw\u0005\f\u00112Y\u0001:#m\n\u0017!e%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014\u0007\f\u0012cEi\u0012TP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015oC6,GmX:ueV\u001cG\u000fK\u0014uS6,w\u0005\f\u0011u_~#\u0018.\\3ti\u0006l\u0007\u000fK\u00143aE*T\u0006\r\u001d.eY:C\u0006I\u0014zsfLX&T'.I\u0012<\u0013&\u000b\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uS6,'E\u000f\u00123m=\u0002\u0004h\f\u001a1cU\u0012SP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010\u000b8b[\u0016$wl\u001d;sk\u000e$\bfJ1(Y\u0001\nD\u0006I\u0014cO1\u0002#'K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6PI1#uEb#E\u0019\u0012;eul&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\":\u0013m\n\u0017!]\u0006lW\rZ0tiJ,8\r\u001e\u0015(E\u001eb\u0003%M\u0015*SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#um\u0014#M\t\u001e2{vT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\\1qQ9\fW.\u001a3`gR\u0014Xo\u0019;)O\u0005<C\u0006I\u0019*Y9\fW.\u001a3`gR\u0014Xo\u0019;)O\t<C\u0006\t\u001a*S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012\\cu\u0013#h\u001f\u0012cEi\u0012T0 \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[\u0006\u0004\bfJ1(Y\u0001\n\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'EO\u0019~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQ5\f\u0007\u000fK\u0014bO1\u0002\u0013'K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6PI1#uEjXL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011Y$\u0001\u0006kg>twLZ;oGN\fQa]5oG\u0016\f#A!\u0011\u0002\u000bIr#G\f\u0019\u0002\u001bM#(/^2ugR{'j]8o!\tI\u0014eE\u0003\"\u0005\u0013\u0012)\u0006\u0005\u0005\u0003L\tE#\r\u001d<}\u001b\t\u0011iEC\u0002\u0003PA\u000bqA];oi&lW-\u0003\u0003\u0003T\t5#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!!q\u000bB/\u001b\t\u0011IF\u0003\u0003\u0003\\\u0005\r\u0018AA5p\u0013\rq&\u0011\f\u000b\u0003\u0005\u000b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\fQ!\u00199qYf$r\u0001 B5\u0005W\u0012i\u0007C\u0003aI\u0001\u0007!\rC\u0003oI\u0001\u0007\u0001\u000fC\u0004uIA\u0005\t\u0019\u0001<\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003v\tu\u0004\u0003B(x\u0005o\u0002ba\u0014B=EB4\u0018b\u0001B>!\n1A+\u001e9mKNB\u0001Ba '\u0003\u0003\u0005\r\u0001`\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\bB!\u0011Q\u001cBE\u0013\u0011\u0011Y)a8\u0003\r=\u0013'.Z2u\u0001")
public class StructsToJson
extends UnaryExpression
implements RuntimeReplaceable,
ExpectsInputTypes,
TimeZoneAwareExpression,
DefaultStringProducingExpression,
QueryErrorsBase,
Serializable {
    private transient DataType inputSchema;
    private transient StructsToJsonEvaluator evaluator;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToJson$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToJson x$0) {
        return StructsToJson$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return StructsToJson$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToJson> tupled() {
        return StructsToJson$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToJson>>> curried() {
        return StructsToJson$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression canonicalized$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)Nil$.MODULE$);
    }

    private DataType inputSchema$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.inputSchema = this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.inputSchema;
    }

    private DataType inputSchema() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.inputSchema$lzycompute();
        }
        return this.inputSchema;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.inputSchema();
        if (dataType instanceof StructType ? true : (dataType instanceof MapType ? true : (dataType instanceof ArrayType ? true : dataType instanceof VariantType))) {
            return JacksonUtils$.MODULE$.verifyType(this.prettyName(), dataType);
        }
        return new TypeCheckResult.DataTypeMismatch("INVALID_JSON_SCHEMA", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)this.child().dataType()))}))));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, StructType$.MODULE$}));
        return Nil$.MODULE$.$colon$colon((Object)typeCollection);
    }

    @Override
    public String prettyName() {
        return "to_json";
    }

    @Override
    public StructsToJson withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    private StructsToJsonEvaluator evaluator$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.evaluator = new StructsToJsonEvaluator(this.options(), this.inputSchema(), this.timeZoneId());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.evaluator;
    }

    private StructsToJsonEvaluator evaluator() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.evaluator$lzycompute();
        }
        return this.evaluator;
    }

    @Override
    public Expression replacement() {
        return new Invoke(Literal$.MODULE$.create(this.evaluator(), (DataType)new ObjectType(StructsToJsonEvaluator.class)), "evaluate", this.dataType(), (Seq<Expression>)new .colon.colon((Object)this.child(), (List)Nil$.MODULE$), (Seq<AbstractDataType>)new .colon.colon((Object)this.child().dataType(), (List)Nil$.MODULE$), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public StructsToJson copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToJson(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToJson";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.options();
            }
            case 1: {
                return this.child();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToJson;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "options";
            }
            case 1: {
                return "child";
            }
            case 2: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToJson structsToJson = (StructsToJson)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToJson.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToJson.canEqual(this)) return false;
        return true;
    }

    public StructsToJson(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        Statics.releaseFence();
    }

    public StructsToJson(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

