/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantBuilder;
import org.apache.spark.types.variant.VariantSizeLimitException;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class VariantExpressionEvalUtils$ {
    public static final VariantExpressionEvalUtils$ MODULE$ = new VariantExpressionEvalUtils$();

    public VariantVal parseJson(UTF8String input, boolean allowDuplicateKeys, boolean failOnError) {
        VariantVal variantVal;
        try {
            Variant v = VariantBuilder.parseJson((String)input.toString(), (boolean)allowDuplicateKeys);
            variantVal = new VariantVal(v.getValue(), v.getMetadata());
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 instanceof VariantSizeLimitException) {
                variantVal = VariantExpressionEvalUtils$.parseJsonFailure$1(QueryExecutionErrors$.MODULE$.variantSizeLimitError(0x8000000, "parse_json"), failOnError);
            }
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                variantVal = VariantExpressionEvalUtils$.parseJsonFailure$1(QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInRecordParsingError(input.toString(), throwable2), failOnError);
            }
            throw throwable;
        }
        return variantVal;
    }

    public boolean parseJson$default$2() {
        return false;
    }

    public boolean parseJson$default$3() {
        return true;
    }

    public boolean isVariantNull(VariantVal input) {
        if (input == null) {
            return false;
        }
        byte[] variantValue = input.getValue();
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(variantValue))) {
            throw QueryExecutionErrors$.MODULE$.malformedVariant();
        }
        return variantValue[0] == 0;
    }

    public VariantVal castToVariant(Object input, DataType dataType) {
        VariantBuilder builder = new VariantBuilder(false);
        this.buildVariant(builder, input, dataType);
        Variant v = builder.result();
        return new VariantVal(v.getValue(), v.getMetadata());
    }

    public boolean typeContainsVariant(DataType dt) {
        while (true) {
            DataType dataType;
            if ((dataType = dt) instanceof VariantType) {
                return true;
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)VariantExpressionEvalUtils$.MODULE$.typeContainsVariant(f.dataType())));
            }
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                dt = arrayType.elementType();
                continue;
            }
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            dt = mapType.valueType();
        }
        return false;
    }

    private void buildVariant(VariantBuilder builder, Object input, DataType dataType) {
        if (input == null) {
            builder.appendNull();
            return;
        }
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            builder.appendBoolean(BoxesRunTime.unboxToBoolean((Object)input));
            return;
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            builder.appendLong((long)BoxesRunTime.unboxToByte((Object)input));
            return;
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            builder.appendLong((long)BoxesRunTime.unboxToShort((Object)input));
            return;
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            builder.appendLong((long)BoxesRunTime.unboxToInt((Object)input));
            return;
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            builder.appendLong(BoxesRunTime.unboxToLong((Object)input));
            return;
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            builder.appendFloat(BoxesRunTime.unboxToFloat((Object)input));
            return;
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            builder.appendDouble(BoxesRunTime.unboxToDouble((Object)input));
            return;
        }
        if (dataType2 instanceof DecimalType) {
            builder.appendDecimal(((Decimal)input).toJavaBigDecimal());
            return;
        }
        if (dataType2 instanceof StringType) {
            builder.appendString(((UTF8String)input).toString());
            return;
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            builder.appendBinary((byte[])input);
            return;
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            builder.appendDate(BoxesRunTime.unboxToInt((Object)input));
            return;
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            builder.appendTimestamp(BoxesRunTime.unboxToLong((Object)input));
            return;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType2)) {
            builder.appendTimestampNtz(BoxesRunTime.unboxToLong((Object)input));
            return;
        }
        if (VariantType$.MODULE$.equals(dataType2)) {
            VariantVal v = (VariantVal)input;
            builder.appendVariant(new Variant(v.getValue(), v.getMetadata()));
            return;
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            ArrayData data = (ArrayData)input;
            int start = builder.getWritePos();
            ArrayList offsets = new ArrayList(data.numElements());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), data.numElements()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                offsets.add(Predef$.MODULE$.int2Integer(builder.getWritePos() - start));
                Object element = data.isNullAt(i) ? null : data.get(i, elementType);
                MODULE$.buildVariant(builder, element, elementType);
            });
            builder.finishWritingArray(start, offsets);
            return;
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType valueType = mapType.valueType();
            if (mapType.keyType() instanceof StringType) {
                MapData data = (MapData)input;
                ArrayData keys = data.keyArray();
                ArrayData values = data.valueArray();
                int start = builder.getWritePos();
                ArrayList fields = new ArrayList(data.numElements());
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), data.numElements()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    String key = keys.getUTF8String(i).toString();
                    int id = builder.addKey(key);
                    fields.add(new VariantBuilder.FieldEntry(key, id, builder.getWritePos() - start));
                    Object value = values.isNullAt(i) ? null : values.get(i, valueType);
                    MODULE$.buildVariant(builder, value, valueType);
                });
                builder.finishWritingObject(start, fields);
                return;
            }
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] structFields = structType.fields();
            InternalRow data = (InternalRow)input;
            int start = builder.getWritePos();
            ArrayList fields = new ArrayList(structFields.length);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), structFields.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                String key = structFields[i].name();
                int id = builder.addKey(key);
                fields.add(new VariantBuilder.FieldEntry(key, id, builder.getWritePos() - start));
                Object value = data.isNullAt(i) ? null : data.get(i, structFields[i].dataType());
                MODULE$.buildVariant(builder, value, structFields[i].dataType());
            });
            builder.finishWritingObject(start, fields);
            return;
        }
        throw new MatchError((Object)dataType2);
    }

    private static final VariantVal parseJsonFailure$1(Throwable exception, boolean failOnError$1) {
        if (failOnError$1) {
            throw exception;
        }
        return null;
    }

    private VariantExpressionEvalUtils$() {
    }
}

