/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\teb\u0001\u0002\u0012$\u0001AB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006\u001d\u0002!\ta\u0014\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u00199\u0007\u0001)A\u0005)\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007B\u00029\u0001A\u0003%!\u000eC\u0004r\u0001\t\u0007I\u0011B5\t\rI\u0004\u0001\u0015!\u0003k\u0011\u001d\u0019\bA1A\u0005\nQDa\u0001\u001f\u0001!\u0002\u0013)\bbB=\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B;\t\u000fm\u0004!\u0019!C\u0005i\"1A\u0010\u0001Q\u0001\nUDq! \u0001C\u0002\u0013%A\u000f\u0003\u0004\u007f\u0001\u0001\u0006I!\u001e\u0005\u0007\u007f\u0002!I!!\u0001\t\u000f\u00055\u0002\u0001\"\u0001\u00020!I\u00111\u0011\u0001\u0012\u0002\u0013\u0005\u0011Q\u0011\u0005\b\u0003?\u0003A\u0011AAQ\u0011!\ti\u000b\u0001C\u0001K\u0005=vaBA]G!\u0005\u00111\u0018\u0004\u0007E\rB\t!!0\t\r9;B\u0011AAe\u0011%\tYm\u0006b\u0001\n\u0003\ti\r\u0003\u0005\u0002V^\u0001\u000b\u0011BAh\u0011\u001d\t\u0019p\u0006C\u0001\u0003kDqA!\u0001\u0018\t\u0003\u0011\u0019\u0001C\u0004\u0003\u0014]!\tA!\u0006\t\u0011\tuq\u0003)A\u0005\u0003wDqAa\b\u0018\t\u0003\u0011\t\u0003C\u0005\u00030]\t\n\u0011\"\u0001\u00032!I!QG\f\u0002\u0002\u0013%!q\u0007\u0002\u0010\u0015N|g.\u00138gKJ\u001c6\r[3nC*\u0011A%J\u0001\u0005UN|gN\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001c]\u001a\u0005C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g\r\u0005\u00029\u0001:\u0011\u0011H\u0010\b\u0003uuj\u0011a\u000f\u0006\u0003y=\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0005}\u001a\u0014a\u00029bG.\fw-Z\u0005\u0003\u0003\n\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aP\u001a\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019K\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005!+%a\u0002'pO\u001eLgnZ\u0001\b_B$\u0018n\u001c8t!\tYE*D\u0001$\u0013\ti5EA\u0006K'>su\n\u001d;j_:\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002Q#B\u00111\n\u0001\u0005\u0006\u0013\n\u0001\rAS\u0001\u000eI\u0016\u001c\u0017.\\1m!\u0006\u00148/\u001a:\u0016\u0003Q\u0003BAM+X?&\u0011ak\r\u0002\n\rVt7\r^5p]F\u0002\"\u0001\u0017/\u000f\u0005eS\u0006C\u0001\u001e4\u0013\tY6'\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013aa\u0015;sS:<'BA.4!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003nCRD'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014!BQ5h\t\u0016\u001c\u0017.\\1m\u00039!WmY5nC2\u0004\u0016M]:fe\u0002\n!\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;feV\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002nK\u0005!Q\u000f^5m\u0013\tyGN\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\u0018a\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\u0004\u0013!\u0006;j[\u0016\u001cH/Y7q\u001dRSfi\u001c:nCR$XM]\u0001\u0017i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3sA\u0005\u0011\u0012n\u001a8pe\u0016\u001cuN\u001d:vaR4\u0015\u000e\\3t+\u0005)\bC\u0001\u001aw\u0013\t98GA\u0004C_>dW-\u00198\u0002'%<gn\u001c:f\u0007>\u0014(/\u001e9u\r&dWm\u001d\u0011\u0002%%<gn\u001c:f\u001b&\u001c8/\u001b8h\r&dWm]\u0001\u0014S\u001etwN]3NSN\u001c\u0018N\\4GS2,7\u000fI\u0001\rSN$UMZ1vYRtEKW\u0001\u000eSN$UMZ1vYRtEK\u0017\u0011\u0002\u00151,w-Y2z\u001b>$W-A\u0006mK\u001e\f7-_'pI\u0016\u0004\u0013a\u00075b]\u0012dWMS:p]\u0016\u0013(o\u001c:t\u0005f\u0004\u0016M]:f\u001b>$W\r\u0006\u0005\u0002\u0004\u0005U\u0011qDA\u0012!\u0015\u0011\u0014QAA\u0005\u0013\r\t9a\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004(\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019\"!\u0004\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002\u0018E\u0001\r!!\u0007\u0002\u0013A\f'o]3N_\u0012,\u0007cA6\u0002\u001c%\u0019\u0011Q\u00047\u0003\u0013A\u000b'o]3N_\u0012,\u0007BBA\u0011#\u0001\u0007q+A\rd_2,XN\u001c(b[\u0016|emQ8seV\u0004HOU3d_J$\u0007bBA\u0013#\u0001\u0007\u0011qE\u0001\u0002KB\u0019\u0001(!\u000b\n\u0007\u0005-\"IA\u0005UQJ|w/\u00192mK\u0006)\u0011N\u001c4feV!\u0011\u0011GA#)!\tI!a\r\u0002X\u0005}\u0004B\u0002\u0013\u0013\u0001\u0004\t)\u0004\u0005\u0004\u00028\u0005u\u0012\u0011I\u0007\u0003\u0003sQ1!a\u000f*\u0003\r\u0011H\rZ\u0005\u0005\u0003\u007f\tIDA\u0002S\t\u0012\u0003B!a\u0011\u0002F1\u0001AaBA$%\t\u0007\u0011\u0011\n\u0002\u0002)F!\u00111JA)!\r\u0011\u0014QJ\u0005\u0004\u0003\u001f\u001a$a\u0002(pi\"Lgn\u001a\t\u0004e\u0005M\u0013bAA+g\t\u0019\u0011I\\=\t\u000f\u0005e#\u00031\u0001\u0002\\\u0005a1M]3bi\u0016\u0004\u0016M]:feBI!'!\u0018\u0002b\u0005\u0005\u0013\u0011P\u0005\u0004\u0003?\u001a$!\u0003$v]\u000e$\u0018n\u001c83!\u0011\t\u0019'!\u001e\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nAaY8sK*!\u00111NA7\u0003\u001dQ\u0017mY6t_:TA!a\u001c\u0002r\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003g\n1aY8n\u0013\u0011\t9(!\u001a\u0003\u0017)\u001bxN\u001c$bGR|'/\u001f\t\u0005\u0003G\nY(\u0003\u0003\u0002~\u0005\u0015$A\u0003&t_:\u0004\u0016M]:fe\"A\u0011\u0011\u0011\n\u0011\u0002\u0003\u0007Q/\u0001\u0006jgJ+\u0017\r\u001a$jY\u0016\fq\"\u001b8gKJ$C-\u001a4bk2$HeM\u000b\u0005\u0003\u000f\u000bi*\u0006\u0002\u0002\n*\u001aQ/a#,\u0005\u00055\u0005\u0003BAH\u00033k!!!%\u000b\t\u0005M\u0015QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a&4\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\u000b\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$q!a\u0012\u0014\u0005\u0004\tI%\u0001\u0006j]\u001a,'OR5fY\u0012$B!a)\u0002*B!\u00111BAS\u0013\u0011\t9+!\u0004\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!a+\u0015\u0001\u0004\tI(\u0001\u0004qCJ\u001cXM]\u0001\u0011G\u0006twN\\5dC2L'0\u001a+za\u0016$b!!-\u00024\u0006]\u0006#\u0002\u001a\u0002\u0006\u0005\r\u0006bBA[+\u0001\u0007\u00111U\u0001\u0004iB,\u0007\"B%\u0016\u0001\u0004Q\u0015a\u0004&t_:LeNZ3s'\u000eDW-\\1\u0011\u0005-;2\u0003B\f2\u0003\u007f\u0003B!!1\u0002H6\u0011\u00111\u0019\u0006\u0004\u0003\u000b\u001c\u0017AA5p\u0013\r\t\u00151\u0019\u000b\u0003\u0003w\u000bQc\u001d;sk\u000e$h)[3mI\u000e{W\u000e]1sCR|'/\u0006\u0002\u0002PJ1\u0011\u0011[Al\u0003G4a!a5\u001b\u0001\u0005='\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014AF:ueV\u001cGOR5fY\u0012\u001cu.\u001c9be\u0006$xN\u001d\u0011\u0011\t\u0005e\u0017q\\\u0007\u0003\u00037T1!!8d\u0003\u0011a\u0017M\\4\n\t\u0005\u0005\u00181\u001c\u0002\u0007\u001f\nTWm\u0019;\u0011\r\u0005\u0015\u0018\u0011^Aw\u001b\t\t9O\u0003\u0002nG&!\u00111^At\u0005)\u0019u.\u001c9be\u0006$xN\u001d\t\u0005\u0003\u0017\ty/\u0003\u0003\u0002r\u00065!aC*ueV\u001cGOR5fY\u0012\f\u0001\"[:T_J$X\r\u001a\u000b\u0004k\u0006]\bbBA}7\u0001\u0007\u00111`\u0001\u0004CJ\u0014\b#\u0002\u001a\u0002~\u00065\u0018bAA\u0000g\t)\u0011I\u001d:bs\u0006\u0001r/\u001b;i\u0007>\u0014(/\u001e9u\r&,G\u000e\u001a\u000b\u000b\u0003\u0013\u0011)A!\u0003\u0003\u000e\tE\u0001b\u0002B\u00049\u0001\u0007\u0011\u0011B\u0001\u0007gR\u0014Xo\u0019;\t\u000f\t-A\u00041\u0001\u0002$\u0006)q\u000e\u001e5fe\"1!q\u0002\u000fA\u0002]\u000b!dY8mk6tg*Y7f\u001f\u001a\u001cuN\u001d:vaR\u0014VmY8sINDq!a\u0006\u001d\u0001\u0004\tI\"\u0001\nd_6\u0004\u0018\r^5cY\u0016\u0014vn\u001c;UsB,GC\u0002B\f\u00053\u0011Y\u0002E\u00053\u0003;\n\u0019+a)\u0002$\"1!qB\u000fA\u0002]Cq!a\u0006\u001e\u0001\u0004\tI\"A\u000bf[B$\u0018p\u0015;sk\u000e$h)[3mI\u0006\u0013(/Y=\u0002\u001d\r|W\u000e]1uS\ndW\rV=qKRA\u00111\u0015B\u0012\u0005O\u0011Y\u0003C\u0004\u0003&}\u0001\r!a)\u0002\u0005Q\f\u0004b\u0002B\u0015?\u0001\u0007\u00111U\u0001\u0003iJB\u0011B!\f !\u0003\u0005\r!a)\u0002\u001f\u0011,g-Y;mi\u0012\u000bG/\u0019+za\u0016\f\u0001dY8na\u0006$\u0018N\u00197f)f\u0004X\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019D\u000b\u0003\u0002$\u0006-\u0015\u0001D<sSR,'+\u001a9mC\u000e,GCAAl\u0001")
public class JsonInferSchema
implements Serializable,
Logging {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final boolean ignoreCorruptFiles;
    private final boolean ignoreMissingFiles;
    private final boolean isDefaultNTZ;
    private final boolean legacyMode;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static DataType compatibleType$default$3() {
        return JsonInferSchema$.MODULE$.compatibleType$default$3();
    }

    public static DataType compatibleType(DataType t1, DataType t2, DataType defaultDataType) {
        return JsonInferSchema$.MODULE$.compatibleType(t1, t2, defaultDataType);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecords, parseMode);
    }

    public static StructType withCorruptField(StructType struct, DataType other, String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(struct, other, columnNameOfCorruptRecords, parseMode);
    }

    public static boolean isSorted(StructField[] arr) {
        return JsonInferSchema$.MODULE$.isSorted(arr);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private boolean ignoreCorruptFiles() {
        return this.ignoreCorruptFiles;
    }

    private boolean ignoreMissingFiles() {
        return this.ignoreMissingFiles;
    }

    private boolean isDefaultNTZ() {
        return this.isDefaultNTZ;
    }

    private boolean legacyMode() {
        return this.legacyMode;
    }

    private Option<StructType> handleJsonErrorsByParseMode(ParseMode parseMode, String columnNameOfCorruptRecord, Throwable e) {
        ParseMode parseMode2 = parseMode;
        if (PermissiveMode$.MODULE$.equals(parseMode2)) {
            return new Some((Object)new StructType((StructField[])((Object[])new StructField[]{new StructField(columnNameOfCorruptRecord, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        }
        if (DropMalformedMode$.MODULE$.equals(parseMode2)) {
            return None$.MODULE$;
        }
        if (FailFastMode$.MODULE$.equals(parseMode2)) {
            throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(e, columnNameOfCorruptRecord);
        }
        throw new MatchError((Object)parseMode2);
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser, boolean isReadFile) {
        ParseMode parseMode = this.options.parseMode();
        String columnNameOfCorruptRecord = this.options.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable)iter -> {
            JsonFactory factory = $this.options.buildJsonFactory();
            return iter.flatMap((Function1 & Serializable)row -> {
                Option<StructType> option;
                try {
                    option = (Option<StructType>)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    });
                }
                catch (Throwable throwable) {
                    boolean bl = false;
                    FileNotFoundException fileNotFoundException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof RuntimeException) {
                        RuntimeException runtimeException = (RuntimeException)throwable2;
                        if (!isReadFile) {
                            option = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, runtimeException);
                        }
                    }
                    if (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException) {
                        option = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, throwable2);
                    }
                    if (throwable2 instanceof CharConversionException) {
                        CharConversionException charConversionException = (CharConversionException)throwable2;
                        if ($this.options.encoding().isEmpty()) {
                            String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n                |Specifying encoding as an input option explicitly might help to resolve the issue.\n                |")) + charConversionException.getMessage();
                            CharConversionException wrappedCharException = new CharConversionException(msg);
                            wrappedCharException.initCause(charConversionException);
                            option = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, wrappedCharException);
                        }
                    }
                    if (throwable2 instanceof FileNotFoundException) {
                        bl = true;
                        fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.ignoreMissingFiles()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped missing file", (Throwable)fileNotFoundException);
                            option = new Option<StructType>((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
                        }
                    }
                    if (bl && !this.ignoreMissingFiles()) {
                        throw fileNotFoundException;
                    }
                    if ((throwable2 instanceof IOException ? true : throwable2 instanceof RuntimeException) && this.ignoreCorruptFiles()) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Skipped the rest of the content in the corrupted file", throwable2);
                        option = new Some((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
                    }
                    throw throwable;
                }
                return option;
            }).reduceOption(typeMerger).iterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        Function1 & Serializable foldPartition = (Function1 & Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$), typeMerger);
        Function2 & Serializable mergeResult = (Function2 & Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options)).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$10(x$1))).getOrElse((Function0 & Serializable)() -> StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public <T> boolean infer$default$3() {
        return false;
    }

    public DataType inferField(JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        if (jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2)) {
            return NullType$.MODULE$;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            return this.inferField(parser);
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                return NullType$.MODULE$;
            }
        }
        if (bl) {
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            if (this.options.prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined()) {
                return (DataType)this.decimalTry$1(decimalTry$lzy, field).get();
            }
            if (this.options.inferTimestamp()) {
                if (this.isDefaultNTZ() && this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined()) {
                    return TimestampNTZType$.MODULE$;
                }
                if (this.timestampFormatter().parseOptional(field).isDefined()) {
                    return TimestampType$.MODULE$;
                }
                if (this.legacyMode()) {
                    UTF8String utf8Value = UTF8String.fromString((String)field);
                    if (SparkDateTimeUtils$.MODULE$.stringToTimestampWithoutTimeZone(utf8Value, false).isDefined()) {
                        return TimestampType$.MODULE$;
                    }
                    return StringType$.MODULE$;
                }
                return StringType$.MODULE$;
            }
            return StringType$.MODULE$;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                builder.$plus$eq((Object)new StructField(parser.currentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
            StructField[] fields = (StructField[])builder.result();
            Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
            return new StructType(fields);
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            NullType$ elementType = NullType$.MODULE$;
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                elementType = JsonInferSchema$.MODULE$.compatibleType((DataType)elementType, this.inferField(parser), JsonInferSchema$.MODULE$.compatibleType$default$3());
            }
            return ArrayType$.MODULE$.apply((DataType)elementType);
        }
        if ((JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if ((JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2)) {
            JsonParser.NumberType numberType = parser.getNumberType();
            if (JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType)) {
                return LongType$.MODULE$;
            }
            if (JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType)) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if ((JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) && this.options.prefersDecimal()) {
                BigDecimal v = parser.getDecimalValue();
                if (Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION()) {
                    return new DecimalType(Math.max(v.precision(), v.scale()), v.scale());
                }
                return DoubleType$.MODULE$;
            }
            if (JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType)) {
                return DoubleType$.MODULE$;
            }
            throw new MatchError((Object)numberType);
        }
        if (JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2)) {
            return BooleanType$.MODULE$;
        }
        throw QueryExecutionErrors$.MODULE$.malformedJSONError();
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable)t -> arrayType.copy(t, arrayType.copy$default$2()));
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            StructField[] canonicalFields = (StructField[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.name()))))), (Function1 & Serializable)f -> this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            }), ClassTag$.MODULE$.apply(StructField.class));
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])canonicalFields))) {
                return None$.MODULE$;
            }
            return new Some((Object)new StructType(canonicalFields));
        }
        if (NullType$.MODULE$.equals(dataType)) {
            if (options.dropFieldIfAllNull()) {
                return None$.MODULE$;
            }
            return new Some((Object)StringType$.MODULE$);
        }
        return new Some((Object)dataType);
    }

    public static final /* synthetic */ boolean $anonfun$infer$10(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        if (decimalTry$lzy$1.initialized()) {
            return (Option)decimalTry$lzy$1.value();
        }
        return this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        Logging.$init$((Logging)this);
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        this.ignoreCorruptFiles = options.ignoreCorruptFiles();
        this.ignoreMissingFiles = options.ignoreMissingFiles();
        AtomicType atomicType = SQLConf$.MODULE$.get().timestampType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        this.isDefaultNTZ = !(atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null);
        Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        this.legacyMode = !(value != null ? !value.equals(value2) : value2 != null);
    }
}

