/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.resolver.LimitExpressionResolver;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005%2A\u0001B\u0003\u0001)!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003B\u0002\u0015\u0001A\u0003%QE\u0001\u000fMS6LG/\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<feN+\u0018\u000e^3\u000b\u0005\u00199\u0011\u0001\u0003:fg>dg/\u001a:\u000b\u0005!I\u0011\u0001C1oC2L8/[:\u000b\u0005)Y\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00051i\u0011aA:rY*\u0011abD\u0001\u0006gB\f'o\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)\u0012\u0004\u0005\u0002\u0017/5\tQ\"\u0003\u0002\u0019\u001b\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AG\u000f\u000e\u0003mQ!\u0001H\u0006\u0002\r\u0015\u0014(o\u001c:t\u0013\tq2DA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\tQ!A\fmS6LG/\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<feV\tQ\u0005\u0005\u0002#M%\u0011q%\u0002\u0002\u0018\u0019&l\u0017\u000e^#yaJ,7o]5p]J+7o\u001c7wKJ\f\u0001\u0004\\5nSR,\u0005\u0010\u001d:fgNLwN\u001c*fg>dg/\u001a:!\u0001")
public class LimitExpressionResolverSuite
extends SparkFunSuite
implements QueryErrorsBase {
    private final LimitExpressionResolver limitExpressionResolver;

    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$((QueryErrorsBase)this, (String)conf);
    }

    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (Expression)e);
    }

    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$((QueryErrorsBase)this, (int)i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    private LimitExpressionResolver limitExpressionResolver() {
        return this.limitExpressionResolver;
    }

    public LimitExpressionResolverSuite() {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$((QueryErrorsBase)this);
        this.limitExpressionResolver = new LimitExpressionResolver();
        this.test("Basic LIMIT without errors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Literal expr = new Literal((Object)BoxesRunTime.boxToInteger((int)42), (DataType)IntegerType$.MODULE$);
            Expression $org_scalatest_assert_macro_left = this.limitExpressionResolver().resolve((Expression)expr);
            Literal $org_scalatest_assert_macro_right = expr;
            Expression expression = $org_scalatest_assert_macro_left;
            Literal literal = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        }, new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("Unfoldable LIMIT", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "foo";
            IntegerType$ x$2 = IntegerType$.MODULE$;
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("foo", (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6("foo", (DataType)x$2, x$3, x$4);
            AttributeReference col = new AttributeReference("foo", (DataType)x$2, x$3, x$4, x$5, x$6);
            AnalysisException x$7 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> this.limitExpressionResolver().resolve((Expression)col), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38))));
            String x$8 = "INVALID_LIMIT_LIKE_EXPRESSION.IS_UNFOLDABLE";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"limit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr((Expression)col))}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "INVALID_LIMIT_LIKE_EXPRESSION.IS_UNFOLDABLE", x$10, x$9, x$11, x$12);
        }, new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("LIMIT with non-integer", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Literal anyNonInteger = Literal$.MODULE$.apply((Object)"42");
            AnalysisException x$13 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> this.limitExpressionResolver().resolve((Expression)anyNonInteger), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49))));
            String x$14 = "INVALID_LIMIT_LIKE_EXPRESSION.DATA_TYPE";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"limit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr((Expression)anyNonInteger)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)anyNonInteger.dataType()))}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "INVALID_LIMIT_LIKE_EXPRESSION.DATA_TYPE", x$16, x$15, x$17, x$18);
        }, new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("LIMIT with null", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Cast expr = new Cast((Expression)Literal$.MODULE$.apply(null), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            AnalysisException x$19 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> this.limitExpressionResolver().resolve((Expression)expr), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64))));
            String x$20 = "INVALID_LIMIT_LIKE_EXPRESSION.IS_NULL";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"limit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr((Expression)expr))}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "INVALID_LIMIT_LIKE_EXPRESSION.IS_NULL", x$22, x$21, x$23, x$24);
        }, new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("LIMIT with negative integer", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Literal expr = new Literal((Object)BoxesRunTime.boxToInteger((int)-1), (DataType)IntegerType$.MODULE$);
            AnalysisException x$25 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> this.limitExpressionResolver().resolve((Expression)expr), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78))));
            String x$26 = "INVALID_LIMIT_LIKE_EXPRESSION.IS_NEGATIVE";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"limit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr((Expression)expr)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)-1), (DataType)IntegerType$.MODULE$))}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, "INVALID_LIMIT_LIKE_EXPRESSION.IS_NEGATIVE", x$28, x$27, x$29, x$30);
        }, new Position("LimitExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
    }
}

