/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateArray$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.ArrayImplicits$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u001d4A!\u0002\u0004\u0001+!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0005?!9q\nAI\u0001\n\u0013\u0001\u0006\"B/\u0001\t\u0013q&\u0001J!qaJ|\u0007pQ8v]R$\u0015n\u001d;j]\u000e$hi\u001c:J]R,'O^1mgN+\u0018\u000e^3\u000b\u0005\u001dA\u0011!C1hOJ,w-\u0019;f\u0015\tI!\"A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0006\r\u0003!\u0019\u0017\r^1msN$(BA\u0007\u000f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\u0002$D\u0001\u000f\u0013\tIbBA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u0003\u0019\tqb\u0019:fCR,Wi\u001d;j[\u0006$xN]\u000b\u0003Ae\"B!\t\u001bC\u0015B)!%J\u0014+]5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004UkBdWm\r\t\u0003;!J!!\u000b\u0004\u0003?\u0005\u0003\bO]8y\u0007>,h\u000e\u001e#jgRLgn\u0019;G_JLe\u000e^3sm\u0006d7\u000f\u0005\u0002,Y5\t!\"\u0003\u0002.\u0015\tY\u0011J\u001c;fe:\fGNU8x!\r\u0011s&M\u0005\u0003a\r\u0012Q!\u0011:sCf\u0004\"A\t\u001a\n\u0005M\u001a#\u0001\u0002'p]\u001eDQ!\u000e\u0002A\u0002Y\n\u0011\"\u001a8ea>Lg\u000e^:\u0011\u0007\tzs\u0007\u0005\u00029s1\u0001A!\u0002\u001e\u0003\u0005\u0004Y$!\u0001+\u0012\u0005qz\u0004C\u0001\u0012>\u0013\tq4EA\u0004O_RD\u0017N\\4\u0011\u0005\t\u0002\u0015BA!$\u0005\r\te.\u001f\u0005\u0006\u0007\n\u0001\r\u0001R\u0001\u0003IR\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0007\u0002\u000bQL\b/Z:\n\u0005%3%\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f-\u0013\u0001\u0013!a\u0001\u0019\u0006\u0019!o\u001d3\u0011\u0005\tj\u0015B\u0001($\u0005\u0019!u.\u001e2mK\u0006I2M]3bi\u0016,5\u000f^5nCR|'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tF,F\u0001SU\ta5kK\u0001U!\t)&,D\u0001W\u0015\t9\u0006,A\u0005v]\u000eDWmY6fI*\u0011\u0011lI\u0001\u000bC:tw\u000e^1uS>t\u0017BA.W\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006u\r\u0011\raO\u0001\nG\",7m\u001b(E-N$Ba\u00182eMB\u0011!\u0005Y\u0005\u0003C\u000e\u0012A!\u00168ji\")1\r\u0002a\u0001]\u0005!a\u000e\u001a<t\u0011\u0015)G\u00011\u0001/\u00031)\u0007\u0010]3di\u0016$g\n\u001a<t\u0011\u0015YE\u00011\u0001M\u0001")
public class ApproxCountDistinctForIntervalsSuite
extends SparkFunSuite {
    private <T> Tuple3<ApproxCountDistinctForIntervals, InternalRow, long[]> createEstimator(Object endpoints, DataType dt, double rsd) {
        SpecificInternalRow input = new SpecificInternalRow((Seq)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
        ApproxCountDistinctForIntervals aggFunc = new ApproxCountDistinctForIntervals((Expression)new BoundReference(0, dt, true), (Expression)CreateArray$.MODULE$.apply((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(endpoints), (Function1 & Serializable)x$4 -> Literal$.MODULE$.apply(x$4), ClassTag$.MODULE$.apply(Literal.class))).toImmutableArraySeq()), rsd, ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5());
        return new Tuple3((Object)aggFunc, (Object)input, (Object)aggFunc.createAggregationBuffer());
    }

    private <T> double createEstimator$default$3() {
        return 0.05;
    }

    private void checkNDVs(long[] ndvs, long[] expectedNdvs, double rsd) {
        long[] $org_scalatest_assert_macro_left = ndvs;
        int $org_scalatest_assert_macro_right = expectedNdvs.length;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.longArrayOps(ndvs)).foreach((Function1 & Serializable)i -> ApproxCountDistinctForIntervalsSuite.$anonfun$checkNDVs$1(ndvs, expectedNdvs, rsd, BoxesRunTime.unboxToInt((Object)i)));
    }

    private static final void checkHllppIndex$1(double[] endpoints, double value, int expectedIntervalIndex) {
        ApproxCountDistinctForIntervals aggFunc = new ApproxCountDistinctForIntervals((Expression)new BoundReference(0, (DataType)DoubleType$.MODULE$, true), (Expression)CreateArray$.MODULE$.apply((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(endpoints), (Function1 & Serializable)x$6 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$6))), ClassTag$.MODULE$.apply(Literal.class))).toImmutableArraySeq()), ApproxCountDistinctForIntervals$.MODULE$.apply$default$3(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5());
        int $org_scalatest_assert_macro_left = aggFunc.findHllppIndex(value);
        int $org_scalatest_assert_macro_right = expectedIntervalIndex;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
    }

    public static final /* synthetic */ long[] $anonfun$new$13(InternalRow partialInput$1, ApproxCountDistinctForIntervals partialAggFunc$1, long[] partialBuffer$1, double x) {
        partialInput$1.setDouble(0, x);
        return partialAggFunc$1.update(partialBuffer$1, partialInput$1);
    }

    public static final /* synthetic */ void $anonfun$new$21(ApproxCountDistinctForIntervalsSuite $this, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            AtomicType dataType;
            Seq records = (Seq)tuple3._1();
            Object endpoints = tuple3._2();
            Tuple3<ApproxCountDistinctForIntervals, InternalRow, long[]> tuple32 = $this.createEstimator(endpoints, (DataType)(dataType = (AtomicType)tuple3._3()), $this.createEstimator$default$3());
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            ApproxCountDistinctForIntervals aggFunc = (ApproxCountDistinctForIntervals)tuple32._1();
            InternalRow input = (InternalRow)tuple32._2();
            long[] buffer = (long[])tuple32._3();
            Tuple3 tuple33 = new Tuple3((Object)aggFunc, (Object)input, (Object)buffer);
            ApproxCountDistinctForIntervals aggFunc2 = (ApproxCountDistinctForIntervals)tuple33._1();
            InternalRow input2 = (InternalRow)tuple33._2();
            long[] buffer2 = (long[])tuple33._3();
            records.foreach((Function1 & Serializable)r -> {
                Object object;
                Object object2 = r;
                if (object2 instanceof Date) {
                    Date date = (Date)object2;
                    object = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date));
                } else if (object2 instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)object2;
                    object = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp));
                } else if (object2 instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)object2;
                    object = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime));
                } else {
                    object = r;
                }
                Integer value = object;
                input2.update(0, (Object)value);
                return aggFunc2.update(buffer2, input2);
            });
            $this.checkNDVs(((ArrayData)aggFunc2.eval(buffer2)).toLongArray(), new long[]{3L, 2L, 1L, 1L, 1L}, aggFunc2.relativeSD());
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ Object $anonfun$checkNDVs$1(long[] ndvs$1, long[] expectedNdvs$1, double rsd$1, int i) {
        long ndv = ndvs$1[i];
        long expectedNdv = expectedNdvs$1[i];
        if (expectedNdv == 0L) {
            long $org_scalatest_assert_macro_left = ndv;
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }
        if (expectedNdv > 0L) {
            double error;
            long $org_scalatest_assert_macro_left = ndv;
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            double $org_scalatest_assert_macro_left2 = error = scala.math.package$.MODULE$.abs((double)ndv / (double)expectedNdv - 1.0);
            double $org_scalatest_assert_macro_right2 = rsd$1 * 3.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Error should be within 3 std. errors.", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        }
        return BoxedUnit.UNIT;
    }

    public ApproxCountDistinctForIntervalsSuite() {
        this.test("fails analysis if parameters are invalid", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            .colon.colon wrongColumnTypes = new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$), (List)new .colon.colon((Object)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$), (List)new .colon.colon((Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("s", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))))));
            wrongColumnTypes.foreach((Function1 & Serializable)dataType -> {
                String x$12 = "a";
                DataType x$2 = dataType;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("a", x$2, x$3, x$4);
                Seq x$6 = AttributeReference$.MODULE$.apply$default$6("a", x$2, x$3, x$4);
                ApproxCountDistinctForIntervals wrongColumn = new ApproxCountDistinctForIntervals((Expression)new AttributeReference("a", x$2, x$3, x$4, x$5, x$6), (Expression)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 10})).map((Function1 & Serializable)x$1 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$1))))), ApproxCountDistinctForIntervals$.MODULE$.apply$default$3(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5());
                TypeCheckResult $org_scalatest_assert_macro_left = wrongColumn.checkInputDataTypes();
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"(\"NUMERIC\" or \"TIMESTAMP\" or \"DATE\" or \"TIMESTAMP_NTZ\" or \"INTERVAL YEAR TO MONTH\" or \"INTERVAL DAY TO SECOND\")"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"a\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)dataType))})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            });
            String x$7 = "a";
            DoubleType$ x$8 = DoubleType$.MODULE$;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$8, x$9, x$10);
            ApproxCountDistinctForIntervals wrongEndpoints = new ApproxCountDistinctForIntervals((Expression)new AttributeReference("a", (DataType)x$8, x$9, x$10, x$11, x$12), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), ApproxCountDistinctForIntervals$.MODULE$.apply$default$3(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5());
            TypeCheckResult $org_scalatest_assert_macro_left = wrongEndpoints.checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"ARRAY\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"0.5\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"DOUBLE\"")})));
            TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            String x$13 = "a";
            DoubleType$ x$14 = DoubleType$.MODULE$;
            boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$17 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$14, x$15, x$16);
            Seq x$18 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$14, x$15, x$16);
            String x$19 = "b";
            DoubleType$ x$20 = DoubleType$.MODULE$;
            boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$23 = AttributeReference$.MODULE$.apply$default$5("b", (DataType)x$20, x$21, x$22);
            Seq x$24 = AttributeReference$.MODULE$.apply$default$6("b", (DataType)x$20, x$21, x$22);
            wrongEndpoints = new ApproxCountDistinctForIntervals((Expression)new AttributeReference("a", (DataType)x$14, x$15, x$16, x$17, x$18), (Expression)CreateArray$.MODULE$.apply((Seq)new .colon.colon((Object)new AttributeReference("b", (DataType)x$20, x$21, x$22, x$23, x$24), (List)Nil$.MODULE$)), ApproxCountDistinctForIntervals$.MODULE$.apply$default$3(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5());
            TypeCheckResult $org_scalatest_assert_macro_left2 = wrongEndpoints.checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right2 = new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"`endpointsExpression`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"ARRAY<DOUBLE>\"")})));
            TypeCheckResult typeCheckResult2 = $org_scalatest_assert_macro_left2;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(typeCheckResult2 != null ? !typeCheckResult2.equals(dataTypeMismatch2) : dataTypeMismatch2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            String x$25 = "a";
            DoubleType$ x$26 = DoubleType$.MODULE$;
            boolean x$27 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$28 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$29 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$26, x$27, x$28);
            Seq x$30 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$26, x$27, x$28);
            wrongEndpoints = new ApproxCountDistinctForIntervals((Expression)new AttributeReference("a", (DataType)x$26, x$27, x$28, x$29, x$30), (Expression)CreateArray$.MODULE$.apply((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(new long[]{10L}), (Function1 & Serializable)x$2 -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$2))), ClassTag$.MODULE$.apply(Literal.class))).toImmutableArraySeq()), ApproxCountDistinctForIntervals$.MODULE$.apply$default$3(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5());
            TypeCheckResult $org_scalatest_assert_macro_left3 = wrongEndpoints.checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right3 = new TypeCheckResult.DataTypeMismatch("WRONG_NUM_ENDPOINTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNumber"), (Object)"1")})));
            TypeCheckResult typeCheckResult3 = $org_scalatest_assert_macro_left3;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(typeCheckResult3 != null ? !typeCheckResult3.equals(dataTypeMismatch3) : dataTypeMismatch3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            String x$31 = "a";
            DoubleType$ x$32 = DoubleType$.MODULE$;
            boolean x$33 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$34 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$35 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$32, x$33, x$34);
            Seq x$36 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$32, x$33, x$34);
            wrongEndpoints = new ApproxCountDistinctForIntervals((Expression)new AttributeReference("a", (DataType)x$32, x$33, x$34, x$35, x$36), (Expression)CreateArray$.MODULE$.apply((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"foobar"}), (Function1 & Serializable)x$3 -> Literal$.MODULE$.apply(x$3), ClassTag$.MODULE$.apply(Literal.class))).toImmutableArraySeq()), ApproxCountDistinctForIntervals$.MODULE$.apply$default$3(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5());
            TypeCheckResult $org_scalatest_assert_macro_left4 = wrongEndpoints.checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right4 = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Cast$.MODULE$.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"ARRAY OF (\"NUMERIC\" or \"DATE\" or \"TIMESTAMP\" or \"TIMESTAMP_NTZ\" or \"ANSI INTERVAL\")"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"array(foobar)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"ARRAY<STRING>\"")})));
            TypeCheckResult typeCheckResult4 = $org_scalatest_assert_macro_left4;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(typeCheckResult4 != null ? !typeCheckResult4.equals(dataTypeMismatch4) : dataTypeMismatch4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("merging ApproxCountDistinctForIntervals instances", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            int i;
            Tuple3<ApproxCountDistinctForIntervals, InternalRow, long[]> tuple3 = this.createEstimator(new int[]{0, 10, 2000, 345678, 1000000}, (DataType)IntegerType$.MODULE$, this.createEstimator$default$3());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            ApproxCountDistinctForIntervals aggFunc = (ApproxCountDistinctForIntervals)tuple3._1();
            InternalRow input = (InternalRow)tuple3._2();
            long[] buffer1a = (long[])tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)aggFunc, (Object)input, (Object)buffer1a);
            ApproxCountDistinctForIntervals aggFunc2 = (ApproxCountDistinctForIntervals)tuple32._1();
            InternalRow input2 = (InternalRow)tuple32._2();
            long[] buffer1a2 = (long[])tuple32._3();
            long[] buffer1b = aggFunc2.createAggregationBuffer();
            long[] buffer2 = aggFunc2.createAggregationBuffer();
            for (i = 0; i < 500000; ++i) {
                input2.setInt(0, i);
                aggFunc2.update(buffer1a2, input2);
            }
            for (i = 500000; i < 1000000; ++i) {
                input2.setInt(0, i);
                aggFunc2.update(buffer1b, input2);
            }
            aggFunc2.merge(buffer1a2, buffer1b);
            for (i = 999999; i >= 0; --i) {
                input2.setInt(0, i);
                aggFunc2.update(buffer2, input2);
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapLongArray(buffer2).sameElements((IterableOnce)Predef$.MODULE$.wrapLongArray(buffer1a2)), "scala.Predef.wrapLongArray(buffer2).sameElements[Long](scala.Predef.wrapLongArray(buffer1a))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Buffers should be equal", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        }, new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("test findHllppIndex(value) for values in the range", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            double[] endpoints = new double[]{0.0, 3.0, 6.0, 10.0};
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(endpoints, 0.0, 0);
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(endpoints, 3.0, 0);
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(endpoints, 6.0, 1);
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(endpoints, 10.0, 2);
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(endpoints, 2.0, 0);
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(endpoints, 4.0, 1);
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(endpoints, 8.0, 2);
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(new double[]{7.0, 7.0, 7.0, 9.0}, 7.0, 0);
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(new double[]{3.0, 5.0, 7.0, 7.0, 7.0}, 7.0, 1);
            ApproxCountDistinctForIntervalsSuite.checkHllppIndex$1(new double[]{1.0, 3.0, 5.0, 7.0, 7.0, 9.0}, 7.0, 2);
        }, new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.test("round trip serialization", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Tuple3<ApproxCountDistinctForIntervals, InternalRow, long[]> tuple3 = this.createEstimator(new int[]{1, 2}, (DataType)DoubleType$.MODULE$, this.createEstimator$default$3());
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            ApproxCountDistinctForIntervals aggFunc = (ApproxCountDistinctForIntervals)tuple3._1();
            ApproxCountDistinctForIntervals aggFunc2 = aggFunc;
            long[] longArray = (long[])new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)100L)).toArray((ClassTag)ClassTag$.MODULE$.Long());
            long[] roundtrip = aggFunc2.deserialize(aggFunc2.serialize(longArray));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.wrapLongArray(roundtrip).sameElements((IterableOnce)Predef$.MODULE$.wrapLongArray(longArray)), "scala.Predef.wrapLongArray(roundtrip).sameElements[Long](scala.Predef.wrapLongArray(longArray))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("basic operations: update, merge, eval...", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            double[] endpoints = new double[]{0.0, 0.33, 0.6, 0.6, 0.6, 1.0};
            Seq data = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.6, 0.3, 1.0, 0.6, 0.5, 0.6, 0.33}));
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.01, 0.05, 0.1})).foreach((Function1)(JFunction1.mcVD.sp & Serializable)relativeSD -> {
                Tuple3<ApproxCountDistinctForIntervals, InternalRow, long[]> tuple3 = this.createEstimator(endpoints, (DataType)DoubleType$.MODULE$, relativeSD);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                ApproxCountDistinctForIntervals aggFunc = (ApproxCountDistinctForIntervals)tuple3._1();
                InternalRow input = (InternalRow)tuple3._2();
                long[] buffer = (long[])tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)aggFunc, (Object)input, (Object)buffer);
                ApproxCountDistinctForIntervals aggFunc2 = (ApproxCountDistinctForIntervals)tuple32._1();
                InternalRow input2 = (InternalRow)tuple32._2();
                long[] buffer2 = (long[])tuple32._3();
                data.grouped(4).foreach((Function1 & Serializable)group -> {
                    Tuple3<ApproxCountDistinctForIntervals, InternalRow, long[]> tuple3 = this.createEstimator(endpoints, (DataType)DoubleType$.MODULE$, relativeSD);
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    ApproxCountDistinctForIntervals partialAggFunc = (ApproxCountDistinctForIntervals)tuple3._1();
                    InternalRow partialInput = (InternalRow)tuple3._2();
                    long[] partialBuffer = (long[])tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)partialAggFunc, (Object)partialInput, (Object)partialBuffer);
                    ApproxCountDistinctForIntervals partialAggFunc2 = (ApproxCountDistinctForIntervals)tuple32._1();
                    InternalRow partialInput2 = (InternalRow)tuple32._2();
                    long[] partialBuffer2 = (long[])tuple32._3();
                    group.foreach((Function1 & Serializable)x -> ApproxCountDistinctForIntervalsSuite.$anonfun$new$13(partialInput2, partialAggFunc2, partialBuffer2, BoxesRunTime.unboxToDouble((Object)x)));
                    return aggFunc2.merge(buffer2, partialBuffer2);
                });
                this.checkNDVs(aggFunc2.hllppResults(buffer2), new long[]{3L, 2L, 0L, 0L, 1L}, relativeSD);
                input2.setDouble(0, 2.0);
                aggFunc2.update(buffer2, input2);
                this.checkNDVs(aggFunc2.hllppResults(buffer2), new long[]{3L, 2L, 0L, 0L, 1L}, relativeSD);
                this.checkNDVs(((ArrayData)aggFunc2.eval(buffer2)).toLongArray(), new long[]{3L, 2L, 1L, 1L, 1L}, relativeSD);
            });
        }, new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("test for different input types: numeric/date/timestamp", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int[] intEndpoints = new int[]{0, 33, 60, 60, 60, 100};
            Seq intRecords = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 60, 30, 100, 60, 50, 60, 33}));
            .colon.colon inputs = new .colon.colon((Object)new Tuple3((Object)intRecords, (Object)intEndpoints, (Object)IntegerType$.MODULE$), (List)new .colon.colon((Object)new Tuple3(intRecords.map((Function1 & Serializable)days -> DateTimeUtils$.MODULE$.toJavaDate(BoxesRunTime.unboxToInt((Object)days))), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(intEndpoints), (Function1 & Serializable)days -> DateTimeUtils$.MODULE$.toJavaDate(BoxesRunTime.unboxToInt((Object)days)), ClassTag$.MODULE$.apply(Date.class)), (Object)DateType$.MODULE$), (List)new .colon.colon((Object)new Tuple3(intRecords.map((Function1 & Serializable)x$9 -> DateTimeUtils$.MODULE$.toJavaTimestamp((long)BoxesRunTime.unboxToInt((Object)x$9))), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(intEndpoints), (Function1 & Serializable)x$10 -> DateTimeUtils$.MODULE$.toJavaTimestamp((long)BoxesRunTime.unboxToInt((Object)x$10)), ClassTag$.MODULE$.apply(Timestamp.class)), (Object)TimestampType$.MODULE$), (List)new .colon.colon((Object)new Tuple3(intRecords.map((Function1 & Serializable)x$11 -> DateTimeUtils$.MODULE$.microsToLocalDateTime((long)BoxesRunTime.unboxToInt((Object)x$11))), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(intEndpoints), (Function1 & Serializable)x$12 -> DateTimeUtils$.MODULE$.microsToLocalDateTime((long)BoxesRunTime.unboxToInt((Object)x$12)), ClassTag$.MODULE$.apply(LocalDateTime.class)), (Object)TimestampNTZType$.MODULE$), (List)Nil$.MODULE$))));
            inputs.foreach((Function1 & Serializable)x0$1 -> {
                ApproxCountDistinctForIntervalsSuite.$anonfun$new$21(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }, new Position("ApproxCountDistinctForIntervalsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }
}

