/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.CompoundBody;
import org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement;
import org.apache.spark.sql.catalyst.plans.logical.CreateVariable;
import org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler;
import org.apache.spark.sql.catalyst.plans.logical.ForStatement;
import org.apache.spark.sql.catalyst.plans.logical.IfElseStatement;
import org.apache.spark.sql.catalyst.plans.logical.IterateStatement;
import org.apache.spark.sql.catalyst.plans.logical.LeaveStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.LoopStatement;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.RepeatStatement;
import org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement;
import org.apache.spark.sql.catalyst.plans.logical.SetVariable;
import org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement;
import org.apache.spark.sql.catalyst.plans.logical.SingleStatement;
import org.apache.spark.sql.catalyst.plans.logical.WhileStatement;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.exceptions.SqlScriptingException;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i2A!\u0002\u0004\u0001'!)a\u0004\u0001C\u0001?!)!\u0005\u0001C)G!)!\u0006\u0001C)G!)1\u0006\u0001C\u0001Y\t92+\u001d7TGJL\u0007\u000f^5oOB\u000b'o]3s'VLG/\u001a\u0006\u0003\u000f!\ta\u0001]1sg\u0016\u0014(BA\u0005\u000b\u0003!\u0019\u0017\r^1msN$(BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\tQa\u001d9be.T!a\u0004\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0012aA8sO\u000e\u00011c\u0001\u0001\u00151A\u0011QCF\u0007\u0002\u0019%\u0011q\u0003\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mA\u0011!\u00029mC:\u001c\u0018BA\u000f\u001b\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002\r\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t!QK\\5u\u0003!\tg\r^3s\u00032d\u0017AF2mK\u0006tW\u000f]*uCR,W.\u001a8u'R\u0014\u0018N\\4\u0015\u00055B\u0004C\u0001\u00186\u001d\ty3\u0007\u0005\u00021M5\t\u0011G\u0003\u00023%\u00051AH]8pizJ!\u0001\u000e\u0014\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003i\u0019BQ!\u000f\u0003A\u00025\nAb\u001d;bi\u0016lWM\u001c;TiJ\u0004")
public class SqlScriptingParserSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        SqlScriptingParserSuite sqlScriptingParserSuite = this;
        synchronized (sqlScriptingParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public void beforeAll() {
        super.beforeAll();
        this.conf().setConfString(SQLConf$.MODULE$.SQL_SCRIPTING_ENABLED().key(), "true");
    }

    public void afterAll() {
        this.conf().unsetConf(SQLConf$.MODULE$.SQL_SCRIPTING_ENABLED().key());
        super.afterAll();
    }

    public String cleanupStatementString(String statementStr) {
        return statementStr.replace("\n", "").replace("BEGIN", "").replace("END", "").trim();
    }

    public static final /* synthetic */ boolean $anonfun$new$7(CompoundPlanStatement x$1) {
        return x$1 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$17(CompoundPlanStatement x$2) {
        return x$2 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$26(CompoundPlanStatement x$3) {
        return x$3 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$28(CompoundPlanStatement x$4) {
        return x$4 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$47(CompoundPlanStatement x$5) {
        return x$5 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$49(CompoundPlanStatement x$6) {
        return x$6 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$51(CompoundPlanStatement x$7) {
        return x$7 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$52(CompoundPlanStatement x$8) {
        return ((SingleStatement)x$8).parsedPlan() instanceof CreateVariable;
    }

    public static final /* synthetic */ boolean $anonfun$new$154(CompoundPlanStatement x$9) {
        return x$9 instanceof ForStatement;
    }

    public SqlScriptingParserSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.test("single select", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan statement;
            String sqlScriptText = "SELECT 1;";
            LogicalPlan $org_scalatest_assert_macro_left = statement = CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left instanceof CompoundBody, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("multi select without ; - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = "SELECT 1 SELECT 1";
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "SELECT";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("multi select with ; - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = "SELECT 1; SELECT 1;";
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "SELECT";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("multi select", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = "BEGIN SELECT 1;SELECT 2; END";
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$7(x$1))), "tree.collection.forall(((x$1: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$1.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sqlScriptText.split(";")), (Function1 & Serializable)statementStr -> this.cleanupStatementString((String)statementStr), ClassTag$.MODULE$.apply(String.class))), (IterableOnce)tree.collection())), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String statementText;
                    String expected = (String)tuple2._1();
                    CompoundPlanStatement statement = (CompoundPlanStatement)tuple2._2();
                    SingleStatement sparkStatement = (SingleStatement)statement;
                    String $org_scalatest_assert_macro_left = statementText = sparkStatement.getText();
                    String $org_scalatest_assert_macro_right = expected;
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("empty singleCompoundStatement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("empty beginEndCompoundBlock", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | BEGIN\n        | END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            CompoundBody innerBody = (CompoundBody)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = innerBody.collection();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("multiple ; in row - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;;\n        |  SELECT 2;\n        |END"));
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "at or near ';'";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("without ; in last statement - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  SELECT 2\n        |END"));
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "at or near end of input";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("multi statement", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  SELECT 2;\n        |  INSERT INTO A VALUES (a, b, 3);\n        |  SELECT a, b, c FROM T;\n        |  SELECT * FROM T;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$17(x$2))), "tree.collection.forall(((x$2: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$2.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sqlScriptText.split(";")), (Function1 & Serializable)statementStr -> this.cleanupStatementString((String)statementStr), ClassTag$.MODULE$.apply(String.class))), (IterableOnce)tree.collection())), (Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String statementText;
                    String expected = (String)tuple2._1();
                    CompoundPlanStatement statement = (CompoundPlanStatement)tuple2._2();
                    SingleStatement sparkStatement = (SingleStatement)statement;
                    String $org_scalatest_assert_macro_left = statementText = sparkStatement.getText();
                    String $org_scalatest_assert_macro_right = expected;
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("nested begin end", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  BEGIN\n        |  SELECT 1;\n        |  END;\n        |  BEGIN\n        |    BEGIN\n        |      SELECT 2;\n        |      SELECT 3;\n        |    END;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            CompoundBody body1 = (CompoundBody)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = body1.collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            String $org_scalatest_assert_macro_left4 = ((SingleStatement)body1.collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            CompoundBody body2 = (CompoundBody)tree.collection().apply(1);
            Seq $org_scalatest_assert_macro_left5 = body2.collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)body2.collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            CompoundBody nestedBody = (CompoundBody)body2.collection().head();
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)nestedBody.collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 2";
            String string3 = $org_scalatest_assert_macro_left7;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)nestedBody.collection().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 3";
            String string5 = $org_scalatest_assert_macro_left8;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("not atomic body", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            LogicalPlan tree;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN NOT ATOMIC\n        |  SELECT 1;\n        |END"));
            LogicalPlan $org_scalatest_assert_macro_left = tree = CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left instanceof CompoundBody, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("nested not atomic body", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN NOT ATOMIC\n        |  BEGIN NOT ATOMIC\n        |    SELECT 1;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            CompoundPlanStatement $org_scalatest_assert_macro_left = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left instanceof CompoundBody, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("top level compound: labels not allowed", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |lbl: BEGIN\n        |  SELECT 1;\n        |END"));
            ParseException x$1 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            String x$2 = "PARSE_SYNTAX_ERROR";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'lbl'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "PARSE_SYNTAX_ERROR", x$4, x$3, x$5, x$6);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("compound: beginLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$26(x$3))), "tree.collection.forall(((x$3: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$3.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            Option $org_scalatest_assert_macro_left3 = tree.label();
            String $org_scalatest_assert_macro_right3 = "lbl";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("compound: beginLabel + endLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END lbl;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$28(x$4))), "tree.collection.forall(((x$4: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$4.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            Option $org_scalatest_assert_macro_left3 = tree.label();
            String $org_scalatest_assert_macro_right3 = "lbl";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        this.test("compound: beginLabel + endLabel - case sensitivity check", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END LbL;\n        |END"));
            return CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("compound: beginLabel + endLabel with different values", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl_begin: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END lbl_end;\n        |END"));
            SqlScriptingException x$7 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            String x$8 = "LABELS_MISMATCH";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"beginLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl_begin")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl_end"))}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "LABELS_MISMATCH", x$10, x$9, x$11, x$12);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("compound: forbidden label - system", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  system: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$13 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            String x$14 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("system"))}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$16, x$15, x$17, x$18);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        this.test("compound: forbidden label - starting with sys", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  sysXYZ: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$19 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            String x$20 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("sysxyz"))}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$22, x$21, x$23, x$24);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        this.test("compound: forbidden label - session", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  session: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$25 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            String x$26 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("session"))}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$28, x$27, x$29, x$30);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        this.test("compound: forbidden label - builtin", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  builtin: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$31 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            String x$32 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("builtin"))}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$34, x$33, x$35, x$36);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        this.test("compound: forbidden label - system - case insensitive", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SySTeM: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$37 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            String x$38 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("system"))}));
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$42 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$37, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$40, x$39, x$41, x$42);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        this.test("compound: forbidden label - session - case insensitive", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SEsSiON: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            SqlScriptingException x$43 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
            String x$44 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
            Map x$45 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("session"))}));
            Option x$46 = this.checkError$default$3();
            boolean x$47 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$48 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$43, "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", x$46, x$45, x$47, x$48);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        this.test("compound: endLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END lbl;\n        |END"));
            SqlScriptingException x$49 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
            String x$50 = "END_LABEL_WITHOUT_BEGIN_LABEL";
            Map x$51 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$52 = this.checkError$default$3();
            boolean x$53 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$54 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$49, "END_LABEL_WITHOUT_BEGIN_LABEL", x$52, x$51, x$53, x$54);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 9;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
        this.test("compound: beginLabel + endLabel with different casing", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  LBL: BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END lbl;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$47(x$5))), "tree.collection.forall(((x$5: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$5.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
            Option $org_scalatest_assert_macro_left3 = tree.label();
            String $org_scalatest_assert_macro_right3 = "lbl";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
        this.test("compound: no labels provided, random label should be generated", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  BEGIN\n        |    SELECT 1;\n        |    SELECT 2;\n        |    INSERT INTO A VALUES (a, b, 3);\n        |    SELECT a, b, c FROM T;\n        |    SELECT * FROM T;\n        |  END;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$49(x$6))), "tree.collection.forall(((x$6: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$6.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
            Option $org_scalatest_assert_macro_left3 = tree.label();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "nonEmpty", $org_scalatest_assert_macro_left3.nonEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        this.test("declare at the beginning", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE testVariable1 VARCHAR(50);\n        |  DECLARE testVariable2 INTEGER;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 513));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$51(x$7))), "tree.collection.forall(((x$7: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$7.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$52(x$8))), "tree.collection.forall(((x$8: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$8.asInstanceOf[org.apache.spark.sql.catalyst.plans.logical.SingleStatement].parsedPlan.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.CreateVariable]))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        this.test("declare after beginning", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  DECLARE testVariable INTEGER;\n        |END"));
            SqlScriptingException x$55 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            String x$56 = "INVALID_VARIABLE_DECLARATION.ONLY_AT_BEGINNING";
            Map x$57 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varName"), (Object)"`testVariable`")}));
            Option x$58 = this.checkError$default$3();
            boolean x$59 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$60 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$55, "INVALID_VARIABLE_DECLARATION.ONLY_AT_BEGINNING", x$58, x$57, x$59, x$60);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        this.test("declare variable in wrong scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   DECLARE testVariable INTEGER;\n        | END IF;\n        |END"));
            SqlScriptingException x$61 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
            String x$62 = "INVALID_VARIABLE_DECLARATION.NOT_ALLOWED_IN_SCOPE";
            Map x$63 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varName"), (Object)"`testVariable`")}));
            Option x$64 = this.checkError$default$3();
            boolean x$65 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$66 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$61, "INVALID_VARIABLE_DECLARATION.NOT_ALLOWED_IN_SCOPE", x$64, x$63, x$65, x$66);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
        this.test("SET statement test", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE totalInsCnt = 0;\n        |  SET totalInsCnt = (SELECT x FROM y WHERE id = 1);\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left2 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
            CompoundPlanStatement $org_scalatest_assert_macro_left3 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
        this.test("SET statement test - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE totalInsCnt = 0;\n        |  SET totalInsCnt = (SELECT x FROMERROR y WHERE id = 1);\n        |END"));
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getCondition());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        this.test("if", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   SELECT 42;\n        | END IF;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
            String $org_scalatest_assert_macro_left5 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right3 = "1=1";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581));
        this.test("if with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | IF 1 = 1 THEN\n        | END IF;\n        |END\n      "));
            ParseException x$67 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
            String x$68 = "PARSE_SYNTAX_ERROR";
            Map x$69 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'IF'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$70 = this.checkError$default$3();
            boolean x$71 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$72 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$67, "PARSE_SYNTAX_ERROR", x$70, x$69, x$71, x$72);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        this.test("if else", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSE\n        |  SELECT 2;\n        |END IF;\n        |END\n        "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
            SingleStatement $org_scalatest_assert_macro_left5 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
            Seq $org_scalatest_assert_macro_left7 = ((CompoundBody)ifStmt.conditionalBodies().head()).collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            Seq $org_scalatest_assert_macro_left10 = ((CompoundBody)ifStmt.elseBody().get()).collection();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 2";
            String string5 = $org_scalatest_assert_macro_left12;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
        this.test("if elseif", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSEIF 2 = 2 THEN\n        |  SELECT 2;\n        |ELSE\n        |  SELECT 3;\n        |END IF;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
            SingleStatement $org_scalatest_assert_macro_left5 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
            SingleStatement $org_scalatest_assert_macro_left9 = (SingleStatement)ifStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)ifStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "2 = 2";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 3";
            String string9 = $org_scalatest_assert_macro_left14;
            String string10 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right8, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        this.test("if multi elseif", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSEIF 2 = 2 THEN\n        |  SELECT 2;\n        |ELSEIF 3 = 3 THEN\n        |  SELECT 3;\n        |END IF;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
            Option $org_scalatest_assert_macro_left5 = ifStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "2 = 2";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left13;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
            SingleStatement $org_scalatest_assert_macro_left14 = (SingleStatement)ifStmt.conditions().apply(2);
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)ifStmt.conditions().apply(2)).getText();
            String $org_scalatest_assert_macro_right8 = "3 = 3";
            String string9 = $org_scalatest_assert_macro_left15;
            String string10 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(2)).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(2)).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 3";
            String string11 = $org_scalatest_assert_macro_left17;
            String string12 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right9, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
        this.test("if - multi elseif - else nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSEIF 2 = 2 THEN\n        |  SELECT 2;\n        |ELSE\n        |  IF 3 = 3 THEN\n        |    SELECT 3;\n        |  ELSEIF 4 = 4 THEN\n        |    SELECT 4;\n        |  ELSE\n        |    IF 5 = 5 THEN\n        |      SELECT 5;\n        |    ELSE\n        |      SELECT 6;\n        |    END IF;\n        |  END IF;\n        |END IF;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 753));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
            Option $org_scalatest_assert_macro_left5 = ifStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "2 = 2";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left13;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left14 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
            IfElseStatement nestedIf_1 = (IfElseStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Seq $org_scalatest_assert_macro_left15 = nestedIf_1.conditions();
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left15, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
            Seq $org_scalatest_assert_macro_left16 = nestedIf_1.conditionalBodies();
            int $org_scalatest_assert_macro_right9 = 2;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left16, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left16.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
            Option $org_scalatest_assert_macro_left17 = nestedIf_1.elseBody();
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left17, "nonEmpty", $org_scalatest_assert_macro_left17.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
            SingleStatement $org_scalatest_assert_macro_left18 = (SingleStatement)nestedIf_1.conditions().head();
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left18, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left18 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
            String $org_scalatest_assert_macro_left19 = ((SingleStatement)nestedIf_1.conditions().head()).getText();
            String $org_scalatest_assert_macro_right10 = "3 = 3";
            String string9 = $org_scalatest_assert_macro_left19;
            String string10 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "==", (Object)$org_scalatest_assert_macro_right10, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
            CompoundPlanStatement $org_scalatest_assert_macro_left20 = (CompoundPlanStatement)((CompoundBody)nestedIf_1.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left20, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left20 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
            String $org_scalatest_assert_macro_left21 = ((SingleStatement)((CompoundBody)nestedIf_1.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right11 = "SELECT 3";
            String string11 = $org_scalatest_assert_macro_left21;
            String string12 = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "==", (Object)$org_scalatest_assert_macro_right11, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 787));
            SingleStatement $org_scalatest_assert_macro_left22 = (SingleStatement)nestedIf_1.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left22, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left22 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
            String $org_scalatest_assert_macro_left23 = ((SingleStatement)nestedIf_1.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right12 = "4 = 4";
            String string13 = $org_scalatest_assert_macro_left23;
            String string14 = $org_scalatest_assert_macro_right12;
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "==", (Object)$org_scalatest_assert_macro_right12, !(string13 != null ? !string13.equals(string14) : string14 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 791));
            CompoundPlanStatement $org_scalatest_assert_macro_left24 = (CompoundPlanStatement)((CompoundBody)nestedIf_1.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left24, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left24 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793));
            String $org_scalatest_assert_macro_left25 = ((SingleStatement)((CompoundBody)nestedIf_1.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right13 = "SELECT 4";
            String string15 = $org_scalatest_assert_macro_left25;
            String string16 = $org_scalatest_assert_macro_right13;
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "==", (Object)$org_scalatest_assert_macro_right13, !(string15 != null ? !string15.equals(string16) : string16 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
            CompoundPlanStatement $org_scalatest_assert_macro_left26 = (CompoundPlanStatement)((CompoundBody)nestedIf_1.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left26, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left26 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
            IfElseStatement nestedIf_2 = (IfElseStatement)((CompoundBody)nestedIf_1.elseBody().get()).collection().head();
            Seq $org_scalatest_assert_macro_left27 = nestedIf_2.conditions();
            int $org_scalatest_assert_macro_right14 = 1;
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left27, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left27.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
            Seq $org_scalatest_assert_macro_left28 = nestedIf_2.conditionalBodies();
            int $org_scalatest_assert_macro_right15 = 1;
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left28, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left28.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
            Option $org_scalatest_assert_macro_left29 = nestedIf_2.elseBody();
            Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left29, "nonEmpty", $org_scalatest_assert_macro_left29.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
            String $org_scalatest_assert_macro_left30 = ((SingleStatement)((CompoundBody)nestedIf_2.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right16 = "SELECT 5";
            String string17 = $org_scalatest_assert_macro_left30;
            String string18 = $org_scalatest_assert_macro_right16;
            Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left30, "==", (Object)$org_scalatest_assert_macro_right16, !(string17 != null ? !string17.equals(string18) : string18 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
            String $org_scalatest_assert_macro_left31 = ((SingleStatement)((CompoundBody)nestedIf_2.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right17 = "SELECT 6";
            String string19 = $org_scalatest_assert_macro_left31;
            String string20 = $org_scalatest_assert_macro_right17;
            Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left31, "==", (Object)$org_scalatest_assert_macro_right17, !(string19 != null ? !string19.equals(string20) : string20 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
        this.test("if nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   IF 2=1 THEN\n        |     SELECT 41;\n        |   ELSE\n        |     SELECT 42;\n        |   END IF;\n        | END IF;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 826));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
            Option $org_scalatest_assert_macro_left5 = ifStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 833));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1=1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left8 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
            IfElseStatement nestedIfStmt = (IfElseStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Seq $org_scalatest_assert_macro_left9 = nestedIfStmt.conditions();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
            Seq $org_scalatest_assert_macro_left10 = nestedIfStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(nestedIfStmt.elseBody().isDefined(), "nestedIfStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 841));
            SingleStatement $org_scalatest_assert_macro_left11 = (SingleStatement)nestedIfStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)nestedIfStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right7 = "2=1";
            String string3 = $org_scalatest_assert_macro_left12;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 844));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)nestedIfStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)nestedIfStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 41";
            String string5 = $org_scalatest_assert_macro_left14;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            CompoundPlanStatement $org_scalatest_assert_macro_left15 = (CompoundPlanStatement)((CompoundBody)nestedIfStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left15, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left15 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850));
            String $org_scalatest_assert_macro_left16 = ((SingleStatement)((CompoundBody)nestedIfStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 42";
            String string7 = $org_scalatest_assert_macro_left16;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.test("while", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1 = 1 DO\n        |  SELECT 1;\n        |END WHILE lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 868));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 874));
            Option $org_scalatest_assert_macro_left9 = whileStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left9.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 876));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 855));
        this.test("while with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | WHILE 1 = 1 DO\n        | END WHILE;\n        |END\n      "));
            ParseException x$73 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 887));
            String x$74 = "PARSE_SYNTAX_ERROR";
            Map x$75 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'WHILE'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$76 = this.checkError$default$3();
            boolean x$77 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$78 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$73, "PARSE_SYNTAX_ERROR", x$76, x$75, x$77, x$78);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 879));
        this.test("while with complex condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |CREATE TABLE t (a INT, b STRING, c DOUBLE) USING parquet;\n        |WHILE (SELECT COUNT(*) < 2 FROM t) DO\n        |  SELECT 42;\n        |END WHILE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
            WhileStatement whileStmt = (WhileStatement)tree.collection().apply(1);
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 909));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "(SELECT COUNT(*) < 2 FROM t)";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 910));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 913));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 42";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 915));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 894));
        this.test("while with if else block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1 = 1 DO\n        |  IF 1 = 1 THEN\n        |    SELECT 1;\n        |  ELSE\n        |    SELECT 2;\n        |  END IF;\n        |END WHILE lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 931));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 932));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 936));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 939));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left7 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 940));
            IfElseStatement ifStmt = (IfElseStatement)whileStmt.body().collection().head();
            Seq $org_scalatest_assert_macro_left8 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 943));
            Seq $org_scalatest_assert_macro_left9 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 944));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 945));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 947));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right6 = "1 = 1";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 948));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 950));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 951));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 954));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left15;
            String string8 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 955));
            Option $org_scalatest_assert_macro_left16 = whileStmt.label();
            String $org_scalatest_assert_macro_right9 = "lbl";
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left16.contains((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 958));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 918));
        this.test("nested while", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1 = 1 DO\n        |  WHILE 2 = 2 DO\n        |    SELECT 42;\n        |  END WHILE;\n        |END WHILE lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 972));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 973));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 976));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 977));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 979));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 980));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left7 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 981));
            WhileStatement nestedWhileStmt = (WhileStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 984));
            String $org_scalatest_assert_macro_left9 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 985));
            CompoundBody $org_scalatest_assert_macro_left10 = nestedWhileStmt.body();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left10 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
            Seq $org_scalatest_assert_macro_left11 = nestedWhileStmt.body().collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left11, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 988));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 989));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 42";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 990));
            Option $org_scalatest_assert_macro_left14 = whileStmt.label();
            String $org_scalatest_assert_macro_right7 = "lbl";
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left14.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 993));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 961));
        this.test("leave compound block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  END;\n        |END"));
            CompoundBody rootTree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = rootTree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1006));
            CompoundBody tree = (CompoundBody)rootTree.collection().head();
            Seq $org_scalatest_assert_macro_left2 = tree.collection();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1009));
            CompoundPlanStatement $org_scalatest_assert_macro_left3 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
            CompoundPlanStatement $org_scalatest_assert_macro_left4 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left4 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1011));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 996));
        this.test("leave while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1024));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1028));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1029));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1031));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1032));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1034));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1035));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)whileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left9 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1037));
            String $org_scalatest_assert_macro_left10 = ((LeaveStatement)whileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1038));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1014));
        this.test("leave repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  UNTIL 1 = 2\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1052));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1053));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1056));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 2";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1057));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1059));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1060));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1062));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1063));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)repeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left9 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1065));
            String $org_scalatest_assert_macro_left10 = ((LeaveStatement)repeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1066));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1041));
        this.test("iterate compound block - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  END;\n        |END"));
            SqlScriptingException x$79 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1079));
            String x$80 = "INVALID_LABEL_USAGE.ITERATE_IN_COMPOUND";
            Map x$81 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"LBL")}));
            Option x$82 = this.checkError$default$3();
            boolean x$83 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$84 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$79, "INVALID_LABEL_USAGE.ITERATE_IN_COMPOUND", x$82, x$81, x$83, x$84);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1069));
        this.test("iterate while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1096));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1097));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1100));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1101));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1103));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1104));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1106));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1107));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)whileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left9 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1109));
            String $org_scalatest_assert_macro_left10 = ((IterateStatement)whileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1110));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1086));
        this.test("iterate repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  UNTIL 1 = 2\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1124));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1125));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1128));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 2";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1129));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1131));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1132));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1134));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1135));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)repeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left9 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1137));
            String $org_scalatest_assert_macro_left10 = ((IterateStatement)repeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1138));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1113));
        this.test("leave with wrong label - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    LEAVE randomlbl;\n        |  END;\n        |END"));
            SqlScriptingException x$85 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1151));
            String x$86 = "INVALID_LABEL_USAGE.DOES_NOT_EXIST";
            Map x$87 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"RANDOMLBL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statementType"), (Object)"LEAVE")}));
            Option x$88 = this.checkError$default$3();
            boolean x$89 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$90 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$85, "INVALID_LABEL_USAGE.DOES_NOT_EXIST", x$88, x$87, x$89, x$90);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1141));
        this.test("iterate with wrong label - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |    ITERATE randomlbl;\n        |  END;\n        |END"));
            SqlScriptingException x$91 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1168));
            String x$92 = "INVALID_LABEL_USAGE.DOES_NOT_EXIST";
            Map x$93 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"RANDOMLBL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statementType"), (Object)"ITERATE")}));
            Option x$94 = this.checkError$default$3();
            boolean x$95 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$96 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$91, "INVALID_LABEL_USAGE.DOES_NOT_EXIST", x$94, x$93, x$95, x$96);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1158));
        this.test("leave outer loop from nested while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    lbl2: WHILE 2 = 2 DO\n        |      SELECT 1;\n        |      LEAVE lbl;\n        |    END WHILE;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1187));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1188));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1191));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1192));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1194));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1195));
            WhileStatement nestedWhileStmt = (WhileStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1198));
            String $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1199));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1201));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1202));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedWhileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left11 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1204));
            String $org_scalatest_assert_macro_left12 = ((LeaveStatement)nestedWhileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1205));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1175));
        this.test("leave outer loop from nested repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    lbl2: REPEAT\n        |      SELECT 1;\n        |      LEAVE lbl;\n        |    UNTIL 2 = 2\n        |    END REPEAT;\n        |  UNTIL 1 = 1\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1222));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1223));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1226));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1227));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1229));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1230));
            RepeatStatement nestedRepeatStmt = (RepeatStatement)repeatStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedRepeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1233));
            String $org_scalatest_assert_macro_left8 = nestedRepeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1234));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1236));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedRepeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1237));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left11 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1240));
            String $org_scalatest_assert_macro_left12 = ((LeaveStatement)nestedRepeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1241));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1208));
        this.test("iterate outer loop from nested while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    lbl2: WHILE 2 = 2 DO\n        |      SELECT 1;\n        |      ITERATE lbl;\n        |    END WHILE;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1256));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1257));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1260));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1261));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1263));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1264));
            WhileStatement nestedWhileStmt = (WhileStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1267));
            String $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1268));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1270));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1271));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedWhileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left11 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1273));
            String $org_scalatest_assert_macro_left12 = ((IterateStatement)nestedWhileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1274));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1244));
        this.test("iterate outer loop from nested repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    lbl2: REPEAT\n        |      SELECT 1;\n        |      ITERATE lbl;\n        |    UNTIL 2 = 2\n        |    END REPEAT;\n        |  UNTIL 1 = 1\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1291));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1292));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1295));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1296));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1298));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1299));
            RepeatStatement nestedRepeatStmt = (RepeatStatement)repeatStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedRepeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1302));
            String $org_scalatest_assert_macro_left8 = nestedRepeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1303));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1305));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedRepeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1306));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left11 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1309));
            String $org_scalatest_assert_macro_left12 = ((IterateStatement)nestedRepeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1310));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1277));
        this.test("repeat", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: REPEAT\n        |  SELECT 1;\n        | UNTIL 1 = 1\n        |END REPEAT lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1323));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1324));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1327));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1328));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1330));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1331));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1332));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1333));
            Option $org_scalatest_assert_macro_left9 = repeatStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left9.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1335));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1313));
        this.test("repeat with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | REPEAT UNTIL 1 = 1\n        | END REPEAT;\n        |END\n      "));
            ParseException x$97 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1346));
            String x$98 = "PARSE_SYNTAX_ERROR";
            Map x$99 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'1'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$100 = this.checkError$default$3();
            boolean x$101 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$102 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$97, "PARSE_SYNTAX_ERROR", x$100, x$99, x$101, x$102);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1338));
        this.test("repeat with complex condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |CREATE TABLE t (a INT, b STRING, c DOUBLE) USING parquet;\n        |REPEAT\n        | SELECT 42;\n        |UNTIL\n        | (SELECT COUNT(*) < 2 FROM t)\n        |END REPEAT;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1367));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1368));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().apply(1);
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1371));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "(SELECT COUNT(*) < 2 FROM t)";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1372));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1374));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1375));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1376));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 42";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1377));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1353));
        this.test("repeat with if else block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: REPEAT\n        |  IF 1 = 1 THEN\n        |    SELECT 1;\n        |  ELSE\n        |    SELECT 2;\n        |  END IF;\n        |UNTIL\n        |  1 = 1\n        |END REPEAT lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1395));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1396));
            RepeatStatement whileStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1399));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1400));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1403));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left7 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1404));
            IfElseStatement ifStmt = (IfElseStatement)whileStmt.body().collection().head();
            Seq $org_scalatest_assert_macro_left8 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1407));
            Seq $org_scalatest_assert_macro_left9 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1408));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1409));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1411));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right6 = "1 = 1";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1412));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1414));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1415));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1418));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left15;
            String string8 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1419));
            Option $org_scalatest_assert_macro_left16 = whileStmt.label();
            String $org_scalatest_assert_macro_right9 = "lbl";
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left16.contains((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1422));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1380));
        this.test("nested repeat", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: REPEAT\n        |  REPEAT\n        |    SELECT 42;\n        |  UNTIL\n        |    2 = 2\n        |  END REPEAT;\n        |UNTIL\n        |   1 = 1\n        |END REPEAT lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1440));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1441));
            RepeatStatement whileStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1444));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1445));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1447));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1448));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left7 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1449));
            RepeatStatement nestedWhileStmt = (RepeatStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1452));
            String $org_scalatest_assert_macro_left9 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1453));
            CompoundBody $org_scalatest_assert_macro_left10 = nestedWhileStmt.body();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left10 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1455));
            Seq $org_scalatest_assert_macro_left11 = nestedWhileStmt.body().collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left11, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1456));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1457));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 42";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1458));
            Option $org_scalatest_assert_macro_left14 = whileStmt.label();
            String $org_scalatest_assert_macro_right7 = "lbl";
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left14.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1461));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1425));
        this.test("searched case statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 = 1 THEN\n        |     SELECT 42;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1475));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left2 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1476));
            SearchedCaseStatement caseStmt = (SearchedCaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1478));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1479));
            String $org_scalatest_assert_macro_left5 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right3 = "1 = 1";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1480));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1464));
        this.test("searched case statement with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | CASE\n        |  WHEN 1 = 1 THEN\n        | END CASE;\n        |END\n      "));
            ParseException x$103 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1492));
            String x$104 = "PARSE_SYNTAX_ERROR";
            Map x$105 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'CASE'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$106 = this.checkError$default$3();
            boolean x$107 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$108 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$103, "PARSE_SYNTAX_ERROR", x$106, x$105, x$107, x$108);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1483));
        this.test("searched case statement - multi when", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 IN (1,2,3) THEN\n        |     SELECT 1;\n        |   WHEN (SELECT * FROM t) THEN\n        |     SELECT * FROM b;\n        |   WHEN 1 = 1 THEN\n        |     SELECT 42;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1515));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left2 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1516));
            SearchedCaseStatement caseStmt = (SearchedCaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1519));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1520));
            Option $org_scalatest_assert_macro_left5 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1521));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1523));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 IN (1,2,3)";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1524));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1526));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1527));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)caseStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1530));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)caseStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "(SELECT * FROM t)";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1531));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1533));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT * FROM b";
            String string7 = $org_scalatest_assert_macro_left13;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1534));
            SingleStatement $org_scalatest_assert_macro_left14 = (SingleStatement)caseStmt.conditions().apply(2);
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1537));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)caseStmt.conditions().apply(2)).getText();
            String $org_scalatest_assert_macro_right8 = "1 = 1";
            String string9 = $org_scalatest_assert_macro_left15;
            String string10 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1538));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1540));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 42";
            String string11 = $org_scalatest_assert_macro_left17;
            String string12 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right9, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1541));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1499));
        this.test("searched case statement with else", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 = 1 THEN\n        |     SELECT 42;\n        |   ELSE\n        |     SELECT 43;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1558));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left2 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1559));
            SearchedCaseStatement caseStmt = (SearchedCaseStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(caseStmt.elseBody().isDefined(), "caseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1561));
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1562));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1563));
            String $org_scalatest_assert_macro_left5 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right3 = "1 = 1";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1564));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1566));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 43";
            String string3 = $org_scalatest_assert_macro_left7;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1567));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1545));
        this.test("searched case statement nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 = 1 THEN\n        |     CASE\n        |       WHEN 2 = 1 THEN\n        |         SELECT 41;\n        |       ELSE\n        |         SELECT 42;\n        |     END CASE;\n        |  END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1587));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left2 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1588));
            SearchedCaseStatement caseStmt = (SearchedCaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1591));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1592));
            Option $org_scalatest_assert_macro_left5 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1593));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1595));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1596));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SearchedCaseStatement", $org_scalatest_assert_macro_left8 instanceof SearchedCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1598));
            SearchedCaseStatement nestedCaseStmt = (SearchedCaseStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Seq $org_scalatest_assert_macro_left9 = nestedCaseStmt.conditions();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1602));
            Seq $org_scalatest_assert_macro_left10 = nestedCaseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1603));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(nestedCaseStmt.elseBody().isDefined(), "nestedCaseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1604));
            SingleStatement $org_scalatest_assert_macro_left11 = (SingleStatement)nestedCaseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1606));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)nestedCaseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right7 = "2 = 1";
            String string3 = $org_scalatest_assert_macro_left12;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1607));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1609));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 41";
            String string5 = $org_scalatest_assert_macro_left14;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1610));
            CompoundPlanStatement $org_scalatest_assert_macro_left15 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left15, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left15 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1613));
            String $org_scalatest_assert_macro_left16 = ((SingleStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 42";
            String string7 = $org_scalatest_assert_macro_left16;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1614));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1571));
        this.test("simple case statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE 1\n        |   WHEN 1 THEN\n        |     SELECT 1;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1629));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left2 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1630));
            SimpleCaseStatement caseStmt = (SimpleCaseStatement)tree.collection().head();
            Expression $org_scalatest_assert_macro_left3 = caseStmt.caseVariableExpression();
            Literal $org_scalatest_assert_macro_right2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression = $org_scalatest_assert_macro_left3;
            Literal literal = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1632));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1633));
            Expression $org_scalatest_assert_macro_left5 = (Expression)caseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression2 = $org_scalatest_assert_macro_left5;
            Literal literal2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(expression2 != null ? !expression2.equals(literal2) : literal2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1634));
            Seq $org_scalatest_assert_macro_left6 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1636));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1637));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1618));
        this.test("simple case statement with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | CASE 1\n        |  WHEN 1 THEN\n        | END CASE;\n        |END\n      "));
            ParseException x$109 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1650));
            String x$110 = "PARSE_SYNTAX_ERROR";
            Map x$111 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'CASE'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$112 = this.checkError$default$3();
            boolean x$113 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$114 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$109, "PARSE_SYNTAX_ERROR", x$112, x$111, x$113, x$114);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1641));
        this.test("simple case statement - multi when", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE 1\n        |   WHEN 1 THEN\n        |     SELECT 1;\n        |   WHEN (SELECT 2) THEN\n        |     SELECT * FROM b;\n        |   WHEN 3 IN (1,2,3) THEN\n        |     SELECT 42;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1673));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left2 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1674));
            SimpleCaseStatement caseStmt = (SimpleCaseStatement)tree.collection().head();
            Expression $org_scalatest_assert_macro_left3 = caseStmt.caseVariableExpression();
            Literal $org_scalatest_assert_macro_right2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression = $org_scalatest_assert_macro_left3;
            Literal literal = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1677));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1678));
            Seq $org_scalatest_assert_macro_left5 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1679));
            Option $org_scalatest_assert_macro_left6 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1680));
            Expression $org_scalatest_assert_macro_left7 = (Expression)caseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right5 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression2 = $org_scalatest_assert_macro_left7;
            Literal literal2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(expression2 != null ? !expression2.equals(literal2) : literal2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1682));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1684));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left9;
            String string2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1685));
            Expression $org_scalatest_assert_macro_left10 = (Expression)caseStmt.conditionExpressions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.expressions.ScalarSubquery", $org_scalatest_assert_macro_left10 instanceof ScalarSubquery, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1688));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1690));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT * FROM b";
            String string3 = $org_scalatest_assert_macro_left12;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1691));
            Expression $org_scalatest_assert_macro_left13 = (Expression)caseStmt.conditionExpressions().apply(2);
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.expressions.In", $org_scalatest_assert_macro_left13 instanceof In, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1694));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1696));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 42";
            String string5 = $org_scalatest_assert_macro_left15;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1697));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1657));
        this.test("simple case statement with else", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE 1\n        |   WHEN 1 THEN\n        |     SELECT 42;\n        |   ELSE\n        |     SELECT 43;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1714));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left2 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1715));
            SimpleCaseStatement caseStmt = (SimpleCaseStatement)tree.collection().head();
            Expression $org_scalatest_assert_macro_left3 = caseStmt.caseVariableExpression();
            Literal $org_scalatest_assert_macro_right2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression = $org_scalatest_assert_macro_left3;
            Literal literal = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1718));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(caseStmt.elseBody().isDefined(), "caseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1719));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1720));
            Expression $org_scalatest_assert_macro_left5 = (Expression)caseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression2 = $org_scalatest_assert_macro_left5;
            Literal literal2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(expression2 != null ? !expression2.equals(literal2) : literal2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1721));
            Seq $org_scalatest_assert_macro_left6 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1723));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 42";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1724));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1727));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 43";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1728));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1701));
        this.test("simple case statement nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE (SELECT 1)\n        |   WHEN 1 THEN\n        |     CASE 2\n        |       WHEN 2 THEN\n        |         SELECT 41;\n        |       ELSE\n        |         SELECT 42;\n        |     END CASE;\n        |  END CASE;\n        |END\n        |"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1748));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left2 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1749));
            SimpleCaseStatement caseStmt = (SimpleCaseStatement)tree.collection().head();
            Expression $org_scalatest_assert_macro_left3 = caseStmt.caseVariableExpression();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.expressions.ScalarSubquery", $org_scalatest_assert_macro_left3 instanceof ScalarSubquery, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1753));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1754));
            Seq $org_scalatest_assert_macro_left5 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1755));
            Option $org_scalatest_assert_macro_left6 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1756));
            Expression $org_scalatest_assert_macro_left7 = (Expression)caseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Expression expression = $org_scalatest_assert_macro_left7;
            Literal literal = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1758));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SimpleCaseStatement", $org_scalatest_assert_macro_left8 instanceof SimpleCaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1760));
            SimpleCaseStatement nestedCaseStmt = (SimpleCaseStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Expression $org_scalatest_assert_macro_left9 = nestedCaseStmt.caseVariableExpression();
            Literal $org_scalatest_assert_macro_right5 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            Expression expression2 = $org_scalatest_assert_macro_left9;
            Literal literal2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(expression2 != null ? !expression2.equals(literal2) : literal2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1764));
            Seq $org_scalatest_assert_macro_left10 = nestedCaseStmt.conditionExpressions();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1765));
            Seq $org_scalatest_assert_macro_left11 = nestedCaseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left11, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1766));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(nestedCaseStmt.elseBody().isDefined(), "nestedCaseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1767));
            Expression $org_scalatest_assert_macro_left12 = (Expression)nestedCaseStmt.conditionExpressions().head();
            Literal $org_scalatest_assert_macro_right8 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            Expression expression3 = $org_scalatest_assert_macro_left12;
            Literal literal3 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right8, !(expression3 != null ? !expression3.equals(literal3) : literal3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1769));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1771));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 41";
            String string = $org_scalatest_assert_macro_left14;
            String string2 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right9, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1772));
            CompoundPlanStatement $org_scalatest_assert_macro_left15 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left15, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left15 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1775));
            String $org_scalatest_assert_macro_left16 = ((SingleStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right10 = "SELECT 42";
            String string3 = $org_scalatest_assert_macro_left16;
            String string4 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "==", (Object)$org_scalatest_assert_macro_right10, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1776));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1732));
        this.test("loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: LOOP\n        |  SELECT 1;\n        |  SELECT 2;\n        |END LOOP lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1790));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1791));
            LoopStatement whileStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1795));
            Seq $org_scalatest_assert_macro_left4 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1796));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1797));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1798));
            Option $org_scalatest_assert_macro_left7 = whileStmt.label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left7.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1800));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1780));
        this.test("loop with empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        | LOOP\n        | END LOOP;\n        |END\n      "));
            ParseException x$115 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1811));
            String x$116 = "PARSE_SYNTAX_ERROR";
            Map x$117 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'LOOP'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$118 = this.checkError$default$3();
            boolean x$119 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$120 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$115, "PARSE_SYNTAX_ERROR", x$118, x$117, x$119, x$120);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1803));
        this.test("loop with if else block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: LOOP\n        | IF 1 = 1 THEN\n        |   SELECT 1;\n        | ELSE\n        |   SELECT 2;\n        | END IF;\n        |END LOOP lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1832));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1833));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1837));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1838));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)loopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IfElseStatement", $org_scalatest_assert_macro_left5 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1839));
            IfElseStatement ifStmt = (IfElseStatement)loopStmt.body().collection().head();
            Seq $org_scalatest_assert_macro_left6 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1842));
            Seq $org_scalatest_assert_macro_left7 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1843));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1844));
            SingleStatement $org_scalatest_assert_macro_left8 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1846));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right5 = "1 = 1";
            String string = $org_scalatest_assert_macro_left9;
            String string2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1847));
            CompoundPlanStatement $org_scalatest_assert_macro_left10 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1849));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1850));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1853));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1854));
            Option $org_scalatest_assert_macro_left14 = loopStmt.label();
            String $org_scalatest_assert_macro_right8 = "lbl";
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left14.contains((Object)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1857));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1818));
        this.test("nested loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: LOOP\n        |  LOOP\n        |    SELECT 42;\n        |  END LOOP;\n        |END LOOP lbl;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1871));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1872));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1876));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1877));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)loopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left5 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1878));
            LoopStatement nestedLoopStmt = (LoopStatement)loopStmt.body().collection().head();
            CompoundBody $org_scalatest_assert_macro_left6 = nestedLoopStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1881));
            Seq $org_scalatest_assert_macro_left7 = nestedLoopStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1882));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)nestedLoopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1883));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)nestedLoopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 42";
            String string = $org_scalatest_assert_macro_left9;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1884));
            Option $org_scalatest_assert_macro_left10 = loopStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left10.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1887));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1860));
        this.test("leave loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: LOOP\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  END LOOP;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1900));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1901));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1905));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1906));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)loopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1908));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)loopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1909));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)loopStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left7 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1911));
            String $org_scalatest_assert_macro_left8 = ((LeaveStatement)loopStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1912));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1890));
        this.test("iterate loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: LOOP\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  END LOOP;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1925));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1926));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1930));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1931));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)loopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1933));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)loopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1934));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)loopStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left7 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1936));
            String $org_scalatest_assert_macro_left8 = ((IterateStatement)loopStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1937));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1915));
        this.test("leave outer loop from nested loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: LOOP\n        |    lbl2: LOOP\n        |      SELECT 1;\n        |      LEAVE lbl;\n        |    END LOOP;\n        |  END LOOP;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1952));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1953));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1957));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1958));
            LoopStatement nestedLoopStmt = (LoopStatement)loopStmt.body().collection().head();
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)nestedLoopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1962));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)nestedLoopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1963));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)nestedLoopStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LeaveStatement", $org_scalatest_assert_macro_left7 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1966));
            String $org_scalatest_assert_macro_left8 = ((LeaveStatement)nestedLoopStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1967));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1940));
        this.test("iterate outer loop from nested loop statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: LOOP\n        |    lbl2: LOOP\n        |      SELECT 1;\n        |      ITERATE lbl;\n        |    END LOOP;\n        |  END LOOP;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1982));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left2 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1983));
            LoopStatement loopStmt = (LoopStatement)tree.collection().head();
            CompoundBody $org_scalatest_assert_macro_left3 = loopStmt.body();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left3 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1987));
            Seq $org_scalatest_assert_macro_left4 = loopStmt.body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1988));
            LoopStatement nestedLoopStmt = (LoopStatement)loopStmt.body().collection().head();
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)nestedLoopStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1992));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)nestedLoopStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1993));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)nestedLoopStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.IterateStatement", $org_scalatest_assert_macro_left7 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1996));
            String $org_scalatest_assert_macro_left8 = ((IterateStatement)nestedLoopStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1997));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1970));
        this.test("unique label names: nested begin-end blocks", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END;\n        |END\n      "));
            SqlScriptingException x$121 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2010));
            String x$122 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$123 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$124 = this.checkError$default$3();
            boolean x$125 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$126 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$121, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$124, x$123, x$125, x$126);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2000));
        this.test("unique label names: nested begin-end blocks - case sensitivity check 1", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |LbL: BEGIN\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END;\n        |END\n      "));
            SqlScriptingException x$127 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2029));
            String x$128 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$129 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$130 = this.checkError$default$3();
            boolean x$131 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$132 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$127, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$130, x$129, x$131, x$132);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2019));
        this.test("unique label names: nested begin-end blocks - case sensitivity check 2", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  LbL: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END;\n        |END\n      "));
            SqlScriptingException x$133 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2048));
            String x$134 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$135 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$136 = this.checkError$default$3();
            boolean x$137 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$138 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$133, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$136, x$135, x$137, x$138);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2038));
        this.test("unique label names: nested begin-end blocks with same prefix", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl_1: BEGIN\n        |  lbl_11: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2068));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2069));
            CompoundBody body_1 = (CompoundBody)tree.collection().head();
            String $org_scalatest_assert_macro_left3 = (String)body_1.label().get();
            String $org_scalatest_assert_macro_right2 = "lbl_1";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2071));
            Seq $org_scalatest_assert_macro_left4 = body_1.collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2072));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)body_1.collection().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2073));
            CompoundBody body_11 = (CompoundBody)body_1.collection().head();
            String $org_scalatest_assert_macro_left6 = (String)body_11.label().get();
            String $org_scalatest_assert_macro_right4 = "lbl_11";
            String string3 = $org_scalatest_assert_macro_left6;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2075));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2057));
        this.test("unique label names: multi-level nested begin-end blocks", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl_1: BEGIN\n        |  lbl_2: BEGIN\n        |    lbl_1: BEGIN\n        |      SELECT 1;\n        |    END;\n        |  END;\n        |END;\n        |END\n      "));
            SqlScriptingException x$139 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2090));
            String x$140 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$141 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl_1"))}));
            Option x$142 = this.checkError$default$3();
            boolean x$143 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$144 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$139, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$142, x$141, x$143, x$144);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2078));
        this.test("unique label names: while loop in begin-end block", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  lbl: WHILE 1=1 DO\n        |    SELECT 1;\n        |  END WHILE;\n        |END;\n        |END\n      "));
            SqlScriptingException x$145 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2109));
            String x$146 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$147 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$148 = this.checkError$default$3();
            boolean x$149 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$150 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$145, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$148, x$147, x$149, x$150);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2099));
        this.test("unique label names: begin-end block in while loop", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1=1 DO\n        |  lbl: BEGIN\n        |    SELECT 1;\n        |  END;\n        |END WHILE;\n        |END\n      "));
            SqlScriptingException x$151 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2128));
            String x$152 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$153 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$154 = this.checkError$default$3();
            boolean x$155 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$156 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$151, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$154, x$153, x$155, x$156);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2118));
        this.test("unique label names: nested while loops", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |w_loop: WHILE 1=1 DO\n        |  w_loop: WHILE 2=2 DO\n        |    SELECT 1;\n        |  END WHILE;\n        |END WHILE;\n        |END\n      "));
            SqlScriptingException x$157 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2147));
            String x$158 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$159 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("w_loop"))}));
            Option x$160 = this.checkError$default$3();
            boolean x$161 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$162 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$157, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$160, x$159, x$161, x$162);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2137));
        this.test("unique label names: nested repeat loops", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |r_loop: REPEAT\n        |  r_loop: REPEAT\n        |    SELECT 1;\n        |  UNTIL 1 = 1\n        |  END REPEAT;\n        |UNTIL 1 = 1\n        |END REPEAT;\n        |END\n      "));
            SqlScriptingException x$163 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2168));
            String x$164 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$165 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("r_loop"))}));
            Option x$166 = this.checkError$default$3();
            boolean x$167 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$168 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$163, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$166, x$165, x$167, x$168);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2156));
        this.test("unique label names: nested loop loops", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |l_loop: LOOP\n        |  l_loop: LOOP\n        |    SELECT 1;\n        |  END LOOP;\n        |END LOOP;\n        |END\n      "));
            SqlScriptingException x$169 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2187));
            String x$170 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$171 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("l_loop"))}));
            Option x$172 = this.checkError$default$3();
            boolean x$173 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$174 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$169, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$172, x$171, x$173, x$174);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2177));
        this.test("unique label names: nested for loops", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |f_loop: FOR x AS SELECT 1 DO\n        |  f_loop: FOR y AS SELECT 2 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END FOR;\n        |END\n      "));
            SqlScriptingException x$175 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2206));
            String x$176 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$177 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId("f_loop"))}));
            Option x$178 = this.checkError$default$3();
            boolean x$179 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$180 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$175, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$178, x$177, x$179, x$180);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2196));
        this.test("unique label names: begin-end block on the same level", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  SELECT 1;\n        |END;\n        |lbl: BEGIN\n        |  SELECT 2;\n        |END;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2227));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2228));
            String $org_scalatest_assert_macro_left3 = (String)((CompoundBody)tree.collection().head()).label().get();
            String $org_scalatest_assert_macro_right2 = "lbl";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2229));
            CompoundPlanStatement $org_scalatest_assert_macro_left4 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left4 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2230));
            String $org_scalatest_assert_macro_left5 = (String)((CompoundBody)tree.collection().apply(1)).label().get();
            String $org_scalatest_assert_macro_right3 = "lbl";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2231));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2215));
        this.test("unique label names: begin-end block and loops on the same level", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: BEGIN\n        |  SELECT 1;\n        |END;\n        |lbl: WHILE 1=1 DO\n        |  SELECT 2;\n        |END WHILE;\n        |lbl: LOOP\n        |  SELECT 3;\n        |END LOOP;\n        |lbl: REPEAT\n        |  SELECT 4;\n        |UNTIL 1=1\n        |END REPEAT;\n        |lbl: FOR x AS SELECT 1 DO\n        |  SELECT 5;\n        |END FOR;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2256));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2257));
            String $org_scalatest_assert_macro_left3 = (String)((CompoundBody)tree.collection().head()).label().get();
            String $org_scalatest_assert_macro_right2 = "lbl";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2258));
            CompoundPlanStatement $org_scalatest_assert_macro_left4 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left4 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2259));
            String $org_scalatest_assert_macro_left5 = (String)((WhileStatement)tree.collection().apply(1)).label().get();
            String $org_scalatest_assert_macro_right3 = "lbl";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2260));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)tree.collection().apply(2);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left6 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2261));
            String $org_scalatest_assert_macro_left7 = (String)((LoopStatement)tree.collection().apply(2)).label().get();
            String $org_scalatest_assert_macro_right4 = "lbl";
            String string5 = $org_scalatest_assert_macro_left7;
            String string6 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2262));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)tree.collection().apply(3);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left8 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2263));
            String $org_scalatest_assert_macro_left9 = (String)((RepeatStatement)tree.collection().apply(3)).label().get();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string7 = $org_scalatest_assert_macro_left9;
            String string8 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2264));
            CompoundPlanStatement $org_scalatest_assert_macro_left10 = (CompoundPlanStatement)tree.collection().apply(4);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left10 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2265));
            String $org_scalatest_assert_macro_left11 = (String)((ForStatement)tree.collection().apply(4)).label().get();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string9 = $org_scalatest_assert_macro_left11;
            String string10 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2266));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2234));
        this.test("qualified label name: label cannot be qualified", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  part1.part2: BEGIN\n        |  END;\n        |END"));
            SqlScriptingException x$181 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2277));
            String x$182 = "INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME";
            Map x$183 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"PART1.PART2")}));
            Option x$184 = this.checkError$default$3();
            boolean x$185 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$186 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$181, "INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME", x$184, x$183, x$185, x$186);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2269));
        this.test("qualified label name: label cannot be qualified + end label", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  part1.part2: BEGIN\n        |  END part1.part2;\n        |END"));
            SqlScriptingException x$187 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2292));
            String x$188 = "INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME";
            Map x$189 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"PART1.PART2")}));
            Option x$190 = this.checkError$default$3();
            boolean x$191 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$192 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$187, "INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME", x$190, x$189, x$191, x$192);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2284));
        this.test("unique label names: nested labeled scope statements", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl_0: BEGIN\n        |  lbl_1: WHILE 1=1 DO\n        |    lbl_2: LOOP\n        |      lbl_3: REPEAT\n        |        lbl_4: FOR x AS SELECT 1 DO\n        |          SELECT 4;\n        |        END FOR;\n        |      UNTIL 1=1\n        |      END REPEAT;\n        |    END LOOP;\n        |  END WHILE;\n        |END;\n        |END\n      "));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2317));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2318));
            CompoundBody body = (CompoundBody)tree.collection().head();
            String $org_scalatest_assert_macro_left3 = (String)body.label().get();
            String $org_scalatest_assert_macro_right2 = "lbl_0";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2321));
            CompoundPlanStatement $org_scalatest_assert_macro_left4 = (CompoundPlanStatement)body.collection().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.WhileStatement", $org_scalatest_assert_macro_left4 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2322));
            WhileStatement whileStatement = (WhileStatement)body.collection().head();
            String $org_scalatest_assert_macro_left5 = (String)whileStatement.label().get();
            String $org_scalatest_assert_macro_right3 = "lbl_1";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2325));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)whileStatement.body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.LoopStatement", $org_scalatest_assert_macro_left6 instanceof LoopStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2326));
            LoopStatement loopStatement = (LoopStatement)whileStatement.body().collection().head();
            String $org_scalatest_assert_macro_left7 = (String)loopStatement.label().get();
            String $org_scalatest_assert_macro_right4 = "lbl_2";
            String string5 = $org_scalatest_assert_macro_left7;
            String string6 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2329));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)loopStatement.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.RepeatStatement", $org_scalatest_assert_macro_left8 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2330));
            RepeatStatement repeatStatement = (RepeatStatement)loopStatement.body().collection().head();
            String $org_scalatest_assert_macro_left9 = (String)repeatStatement.label().get();
            String $org_scalatest_assert_macro_right5 = "lbl_3";
            String string7 = $org_scalatest_assert_macro_left9;
            String string8 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2333));
            ForStatement forStatement = (ForStatement)repeatStatement.body().collection().head();
            String $org_scalatest_assert_macro_left10 = (String)forStatement.label().get();
            String $org_scalatest_assert_macro_right6 = "lbl_4";
            String string9 = $org_scalatest_assert_macro_left10;
            String string10 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right6, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2336));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2299));
        this.test("for variable not the same as labels in scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  L1: BEGIN\n        |    L2: BEGIN\n        |      L3: FOR L4 AS SELECT 1 DO\n        |        SELECT 1;\n        |        FOR L5 AS SELECT 3 DO\n        |          BEGIN\n        |            SELECT L4;\n        |          END;\n        |         SELECT 4;\n        |        END FOR;\n        |      END FOR L3;\n        |    END L2;\n        |    L4: BEGIN\n        |      SELECT 3;\n        |    END L4;\n        |  END L1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2362));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2363));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2339));
        this.test("for variable name is the same as a label in scope - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  L1: BEGIN\n        |    L2: BEGIN\n        |      L3: FOR L2 AS SELECT 1 DO\n        |        SELECT 1;\n        |        SELECT 2;\n        |      END FOR L3;\n        |    END L2;\n        |    L4: BEGIN\n        |      SELECT 3;\n        |    END L4;\n        |  END L1;\n        |END"));
            SqlScriptingException x$193 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2384));
            String x$194 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$195 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"`l2`")}));
            Option x$196 = this.checkError$default$3();
            boolean x$197 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$198 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$193, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$196, x$195, x$197, x$198);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2366));
        this.test("for variable name is the same as the label of the for loop - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  L1: FOR L1 AS SELECT 1 DO\n        |    SELECT 2;\n        |  END FOR L1;\n        |END"));
            SqlScriptingException x$199 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2401));
            String x$200 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$201 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"`l1`")}));
            Option x$202 = this.checkError$default$3();
            boolean x$203 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$204 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$199, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$202, x$201, x$203, x$204);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2391));
        this.test("label name is the same as the for loop variable name - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR L1 AS SELECT 1 DO\n        |    L1: BEGIN\n        |      SELECT 2;\n        |    END L1;\n        |  END FOR;\n        |END"));
            SqlScriptingException x$205 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2420));
            String x$206 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$207 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"`l1`")}));
            Option x$208 = this.checkError$default$3();
            boolean x$209 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$210 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$205, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$208, x$207, x$209, x$210);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2408));
        this.test("nested for loop variable names are the same - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR L1 AS SELECT 1 DO\n        |    FOR L1 AS SELECT 2 DO\n        |     SELECT 3;\n        |    END FOR;\n        |  END FOR;\n        |END"));
            SqlScriptingException x$211 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2439));
            String x$212 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
            Map x$213 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)"`l1`")}));
            Option x$214 = this.checkError$default$3();
            boolean x$215 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$216 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$211, "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", x$214, x$213, x$215, x$216);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2427));
        this.test("for loop variable names are the same but for loops are not nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR L1 AS SELECT 1 DO\n        |    SELECT 2;\n        |  END FOR;\n        |  FOR L1 AS SELECT 3 DO\n        |    SELECT 4;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2459));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$154(x$9))), "tree.collection.forall(((x$9: org.apache.spark.sql.catalyst.plans.logical.CompoundPlanStatement) => x$9.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.ForStatement]))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2460));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2446));
        this.test("for statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR x AS SELECT 5 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2472));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2473));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2476));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 5";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2477));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            String $org_scalatest_assert_macro_right3 = "x";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2478));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2480));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2481));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2482));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2483));
            Option $org_scalatest_assert_macro_left10 = forStmt.label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left10.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2485));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2463));
        this.test("for statement - empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR x AS SELECT 5 DO\n        |  END FOR;\n        |END"));
            ParseException x$217 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2496));
            String x$218 = "PARSE_SYNTAX_ERROR";
            Map x$219 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'FOR'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$220 = this.checkError$default$3();
            boolean x$221 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$222 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$217, "PARSE_SYNTAX_ERROR", x$220, x$219, x$221, x$222);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2488));
        this.test("for statement - no label", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR x AS SELECT 5 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2512));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2513));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2516));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 5";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2517));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            String $org_scalatest_assert_macro_right3 = "x";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2518));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2520));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2521));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2522));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2523));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(forStmt.label().isDefined(), "forStmt.label.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2526));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2503));
        this.test("for statement - with complex subquery", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR x AS SELECT c1, c2 FROM t WHERE c2 = 5 GROUP BY c1 ORDER BY c1 DO\n        |    SELECT x.c1;\n        |    SELECT x.c2;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2539));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2540));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2543));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT c1, c2 FROM t WHERE c2 = 5 GROUP BY c1 ORDER BY c1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2544));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            String $org_scalatest_assert_macro_right3 = "x";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2545));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2547));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2548));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2549));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT x.c1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2550));
            CompoundPlanStatement $org_scalatest_assert_macro_left10 = (CompoundPlanStatement)forStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2551));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)forStmt.body().collection().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT x.c2";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2552));
            Option $org_scalatest_assert_macro_left12 = forStmt.label();
            String $org_scalatest_assert_macro_right7 = "lbl";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left12.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2554));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2529));
        this.test("for statement - nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl1: FOR i AS SELECT 1 DO\n        |    lbl2: FOR j AS SELECT 2 DO\n        |      SELECT i + j;\n        |    END FOR lbl2;\n        |  END FOR lbl1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2568));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2569));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2572));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2573));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            String $org_scalatest_assert_macro_right3 = "i";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2574));
            Option $org_scalatest_assert_macro_left6 = forStmt.label();
            String $org_scalatest_assert_macro_right4 = "lbl1";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2575));
            CompoundBody $org_scalatest_assert_macro_left7 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left7 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2577));
            Seq $org_scalatest_assert_macro_left8 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2578));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left9 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2579));
            ForStatement nestedForStmt = (ForStatement)forStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left10 = nestedForStmt.query();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2582));
            String $org_scalatest_assert_macro_left11 = nestedForStmt.query().getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 2";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2583));
            Option $org_scalatest_assert_macro_left12 = nestedForStmt.variableName();
            String $org_scalatest_assert_macro_right7 = "j";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left12.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2584));
            Option $org_scalatest_assert_macro_left13 = nestedForStmt.label();
            String $org_scalatest_assert_macro_right8 = "lbl2";
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left13.contains((Object)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2585));
            CompoundBody $org_scalatest_assert_macro_left14 = nestedForStmt.body();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left14 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2587));
            Seq $org_scalatest_assert_macro_left15 = nestedForStmt.body().collection();
            int $org_scalatest_assert_macro_right9 = 1;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left15, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2588));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)nestedForStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2589));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)nestedForStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right10 = "SELECT i + j";
            String string5 = $org_scalatest_assert_macro_left17;
            String string6 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right10, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2590));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2557));
        this.test("for statement - no variable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR SELECT 5 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2603));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2604));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2607));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 5";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2608));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2609));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2611));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2612));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2613));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2614));
            Option $org_scalatest_assert_macro_left10 = forStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left10.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2616));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2594));
        this.test("for statement - no variable - empty body", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR SELECT 5 DO\n        |  END FOR;\n        |END"));
            ParseException x$223 = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2627));
            String x$224 = "PARSE_SYNTAX_ERROR";
            Map x$225 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'FOR'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$226 = this.checkError$default$3();
            boolean x$227 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$228 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$223, "PARSE_SYNTAX_ERROR", x$226, x$225, x$227, x$228);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2619));
        this.test("for statement - no variable - no label", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  FOR SELECT 5 DO\n        |    SELECT 1;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2643));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2644));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2647));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 5";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2648));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2649));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2651));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2652));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2653));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2654));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(forStmt.label().isDefined(), "forStmt.label.isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2657));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2634));
        this.test("for statement - no variable - with complex subquery", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: FOR SELECT c1, c2 FROM t WHERE c2 = 5 GROUP BY c1 ORDER BY c1 DO\n        |    SELECT 1;\n        |    SELECT 2;\n        |  END FOR;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2670));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2671));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2674));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT c1, c2 FROM t WHERE c2 = 5 GROUP BY c1 ORDER BY c1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2675));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2676));
            CompoundBody $org_scalatest_assert_macro_left6 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2678));
            Seq $org_scalatest_assert_macro_left7 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2679));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2680));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)forStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2681));
            CompoundPlanStatement $org_scalatest_assert_macro_left10 = (CompoundPlanStatement)forStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2682));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)forStmt.body().collection().apply(1)).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 2";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2683));
            Option $org_scalatest_assert_macro_left12 = forStmt.label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left12.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2685));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2660));
        this.test("for statement - no variable - nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl1: FOR SELECT 1 DO\n        |    lbl2: FOR SELECT 2 DO\n        |      SELECT 3;\n        |    END FOR lbl2;\n        |  END FOR lbl1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2699));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left2 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2700));
            ForStatement forStmt = (ForStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = forStmt.query();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2703));
            String $org_scalatest_assert_macro_left4 = forStmt.query().getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2704));
            Option $org_scalatest_assert_macro_left5 = forStmt.variableName();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2705));
            Option $org_scalatest_assert_macro_left6 = forStmt.label();
            String $org_scalatest_assert_macro_right3 = "lbl1";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2706));
            CompoundBody $org_scalatest_assert_macro_left7 = forStmt.body();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left7 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2708));
            Seq $org_scalatest_assert_macro_left8 = forStmt.body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2709));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)forStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ForStatement", $org_scalatest_assert_macro_left9 instanceof ForStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2710));
            ForStatement nestedForStmt = (ForStatement)forStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left10 = nestedForStmt.query();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2713));
            String $org_scalatest_assert_macro_left11 = nestedForStmt.query().getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 2";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2714));
            Option $org_scalatest_assert_macro_left12 = nestedForStmt.variableName();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2715));
            Option $org_scalatest_assert_macro_left13 = nestedForStmt.label();
            String $org_scalatest_assert_macro_right6 = "lbl2";
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left13.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2716));
            CompoundBody $org_scalatest_assert_macro_left14 = nestedForStmt.body();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.CompoundBody", $org_scalatest_assert_macro_left14 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2718));
            Seq $org_scalatest_assert_macro_left15 = nestedForStmt.body().collection();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left15, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2719));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)nestedForStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2720));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)nestedForStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 3";
            String string5 = $org_scalatest_assert_macro_left17;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2721));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2688));
        this.test("declare condition: custom sqlstate", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE test CONDITION FOR SQLSTATE '12000';\n        |  SELECT 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = tree.conditions();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2733));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((String)tree.conditions().apply((Object)"TEST")).equals("12000"), "tree.conditions.apply(\"TEST\").equals(\"12000\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2734));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2725));
        this.test("declare condition: default sqlstate", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE test CONDITION;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = tree.conditions();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2744));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((String)tree.conditions().apply((Object)"TEST")).equals("45000"), "tree.conditions.apply(\"TEST\").equals(\"45000\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2745));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2737));
        this.test("declare condition in wrong place", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  DECLARE test_condition CONDITION FOR SQLSTATE '12345';\n        |END"));
            SqlScriptingException x$229 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2755));
            String x$230 = "INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT";
            Map x$231 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)"`TEST_CONDITION`")}));
            Option x$232 = this.checkError$default$3();
            boolean x$233 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$234 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$229, "INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT", x$232, x$231, x$233, x$234);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2762));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2748));
        this.test("declare condition in wrong scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12345';\n        | END IF;\n        |END"));
            SqlScriptingException x$235 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2773));
            String x$236 = "INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT";
            Map x$237 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)DataTypeErrors$.MODULE$.toSQLId("TEST_CONDITION"))}));
            Option x$238 = this.checkError$default$3();
            boolean x$239 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$240 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$235, "INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT", x$238, x$237, x$239, x$240);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2780));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2765));
        this.test("declare qualified condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST.CONDITION CONDITION FOR SQLSTATE '12345';\n        |END"));
            SqlScriptingException x$241 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2789));
            String x$242 = "INVALID_ERROR_CONDITION_DECLARATION.QUALIFIED_CONDITION_NAME";
            Map x$243 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)"TEST.CONDITION")}));
            Option x$244 = this.checkError$default$3();
            boolean x$245 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$246 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$241, "INVALID_ERROR_CONDITION_DECLARATION.QUALIFIED_CONDITION_NAME", x$244, x$243, x$245, x$246);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2796));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2783));
        this.test("declare condition with special characters", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE `test-condition` CONDITION FOR SQLSTATE '12345';\n        |END"));
            SqlScriptingException x$247 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2805));
            String x$248 = "INVALID_ERROR_CONDITION_DECLARATION.SPECIAL_CHARACTER_FOUND";
            Map x$249 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)DataTypeErrors$.MODULE$.toSQLId("test-condition"))}));
            Option x$250 = this.checkError$default$3();
            boolean x$251 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$252 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$247, "INVALID_ERROR_CONDITION_DECLARATION.SPECIAL_CHARACTER_FOUND", x$250, x$249, x$251, x$252);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2812));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2799));
        this.test("declare duplicate condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12000';\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '13000';\n        |  SELECT 1;\n        |END"));
            SqlScriptingException x$253 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2823));
            String x$254 = "DUPLICATE_CONDITION_IN_SCOPE";
            Map x$255 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)DataTypeErrors$.MODULE$.toSQLId("TEST_CONDITION"))}));
            Option x$256 = this.checkError$default$3();
            boolean x$257 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$258 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$253, "DUPLICATE_CONDITION_IN_SCOPE", x$256, x$255, x$257, x$258);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2830));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2815));
        this.test("declare duplicate condition nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12000';\n        |  BEGIN\n        |    IF (1 = 1) THEN\n        |      BEGIN\n        |        DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '13000';\n        |      END;\n        |    END IF;\n        |  END;\n        |  SELECT 1;\n        |END"));
            SqlScriptingException x$259 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2847));
            String x$260 = "DUPLICATE_CONDITION_IN_SCOPE";
            Map x$261 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)DataTypeErrors$.MODULE$.toSQLId("TEST_CONDITION"))}));
            Option x$262 = this.checkError$default$3();
            boolean x$263 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$264 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$259, "DUPLICATE_CONDITION_IN_SCOPE", x$262, x$261, x$263, x$264);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2854));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2833));
        this.test("continue handler not supported", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE CONTINUE HANDLER FOR SQLSTATE '22012'\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$265 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2871));
            String x$266 = "UNSUPPORTED_FEATURE.CONTINUE_EXCEPTION_HANDLER";
            Map x$267 = Predef$.MODULE$.Map().empty();
            Option x$268 = this.checkError$default$3();
            boolean x$269 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$270 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$265, "UNSUPPORTED_FEATURE.CONTINUE_EXCEPTION_HANDLER", x$268, x$267, x$269, x$270);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2857));
        this.test("declare handler for qualified condition name that is not supported", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE EXIT HANDLER FOR qualified.condition.name\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$271 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2892));
            String x$272 = "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND";
            Map x$273 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)"QUALIFIED.CONDITION.NAME")}));
            Option x$274 = this.checkError$default$3();
            boolean x$275 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$276 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$271, "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND", x$274, x$273, x$275, x$276);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2878));
        this.test("declare handler for undefined condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR undefined_condition BEGIN SELECT 1; END;\n        |  SELECT 1;\n        |END"));
            SqlScriptingException x$277 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2906));
            String x$278 = "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND";
            Map x$279 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)"UNDEFINED_CONDITION")}));
            Option x$280 = this.checkError$default$3();
            boolean x$281 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$282 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$277, "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND", x$280, x$279, x$281, x$282);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2913));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2899));
        this.test("declare handler in wrong place", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO BEGIN SELECT 1; END;\n        |END"));
            SqlScriptingException x$283 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2923));
            String x$284 = "INVALID_HANDLER_DECLARATION.WRONG_PLACE_OF_DECLARATION";
            Map x$285 = Predef$.MODULE$.Map().empty();
            Option x$286 = this.checkError$default$3();
            boolean x$287 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$288 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$283, "INVALID_HANDLER_DECLARATION.WRONG_PLACE_OF_DECLARATION", x$286, x$285, x$287, x$288);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2930));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2916));
        this.test("duplicate condition in handler declaration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE DUPLICATE_CONDITION CONDITION FOR SQLSTATE '12345';\n        |  DECLARE EXIT HANDLER FOR duplicate_condition, duplicate_condition\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$289 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2948));
            String x$290 = "INVALID_HANDLER_DECLARATION.DUPLICATE_CONDITION_IN_HANDLER_DECLARATION";
            Map x$291 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)"DUPLICATE_CONDITION")}));
            Option x$292 = this.checkError$default$3();
            boolean x$293 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$294 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$289, "INVALID_HANDLER_DECLARATION.DUPLICATE_CONDITION_IN_HANDLER_DECLARATION", x$292, x$291, x$293, x$294);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2933));
        this.test("duplicate sqlState in handler declaration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE EXIT HANDLER FOR SQLSTATE '12345', SQLSTATE '12345'\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$295 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2969));
            String x$296 = "INVALID_HANDLER_DECLARATION.DUPLICATE_SQLSTATE_IN_HANDLER_DECLARATION";
            Map x$297 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlState"), (Object)"12345")}));
            Option x$298 = this.checkError$default$3();
            boolean x$299 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$300 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$295, "INVALID_HANDLER_DECLARATION.DUPLICATE_SQLSTATE_IN_HANDLER_DECLARATION", x$298, x$297, x$299, x$300);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2955));
        this.test("invalid condition combination in handler declaration", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE OR REPLACE flag INT = -1;\n        |  DECLARE EXIT HANDLER FOR SQLEXCEPTION, SQLSTATE '12345'\n        |  BEGIN\n        |    SET flag = 1;\n        |  END;\n        |  SELECT 1/0;\n        |  SELECT flag;\n        |END\n        |"));
            SqlScriptingException x$301 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sqlScript), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2990));
            String x$302 = "INVALID_HANDLER_DECLARATION.INVALID_CONDITION_COMBINATION";
            Map x$303 = Predef$.MODULE$.Map().empty();
            Option x$304 = this.checkError$default$3();
            boolean x$305 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$306 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$301, "INVALID_HANDLER_DECLARATION.INVALID_CONDITION_COMBINATION", x$304, x$303, x$305, x$306);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2976));
        this.test("declare handler with compound body", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO BEGIN SELECT 1; END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3004));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3005));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3006));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3007));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3008));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3009));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left7 instanceof Project, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3010));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2997));
        this.test("declare handler single statement with END", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO SELECT 1 END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3023));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3024));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3025));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3026));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3027));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3028));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left7 instanceof Project, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3029));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3016));
        this.test("declare handler single statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO SELECT 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3040));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3041));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3042));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3043));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3044));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3045));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left7 instanceof Project, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3046));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3033));
        this.test("declare handler set statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3057));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3058));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3059));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "DIVIDE_BY_ZERO";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3060));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3061));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3062));
            LogicalPlan $org_scalatest_assert_macro_left7 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SetVariable", $org_scalatest_assert_macro_left7 instanceof SetVariable, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3063));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3050));
        this.test("declare handler with multiple conditions/sqlstates", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION_1 CONDITION FOR SQLSTATE '12345';\n        |  DECLARE TEST_CONDITION_2 CONDITION FOR SQLSTATE '54321';\n        |  DECLARE EXIT HANDLER FOR SQLSTATE '22012', TEST_CONDITION_1, test_condition_2\n        |    SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3077));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3078));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3079));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "TEST_CONDITION_1";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3080));
            Set $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right4 = "TEST_CONDITION_2";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3081));
            Set $org_scalatest_assert_macro_left6 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3082));
            Set $org_scalatest_assert_macro_left7 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            String $org_scalatest_assert_macro_right6 = "22012";
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3083));
            Seq $org_scalatest_assert_macro_left8 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3084));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3085));
            LogicalPlan $org_scalatest_assert_macro_left10 = ((SingleStatement)((ExceptionHandler)tree.handlers().head()).body().collection().head()).parsedPlan();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.SetVariable", $org_scalatest_assert_macro_left10 instanceof SetVariable, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3086));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3067));
        this.test("declare handler for SQLEXCEPTION", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR SQLEXCEPTION SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3097));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3098));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3099));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3100));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlException(), "tree.handlers.head.exceptionHandlerTriggers.sqlException", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3101));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().notFound(), "tree.handlers.head.exceptionHandlerTriggers.notFound", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3102));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3103));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3090));
        this.test("declare handler for NOT FOUND", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE EXIT HANDLER FOR NOT FOUND SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3113));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3114));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3115));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3116));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlException(), "tree.handlers.head.exceptionHandlerTriggers.sqlException", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3117));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().notFound(), "tree.handlers.head.exceptionHandlerTriggers.notFound", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3118));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3119));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3106));
        this.test("declare handler with condition and sqlstate with same value", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE K2000 CONDITION FOR SQLSTATE '12345';\n        |  DECLARE EXIT HANDLER FOR K2000, SQLSTATE VALUE 'K2000' SET test_var = 1;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3130));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)tree.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3131));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3132));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "K2000";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3133));
            Set $org_scalatest_assert_macro_left5 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3134));
            Set $org_scalatest_assert_macro_left6 = ((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlStates();
            String $org_scalatest_assert_macro_right5 = "K2000";
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3135));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().sqlException(), "tree.handlers.head.exceptionHandlerTriggers.sqlException", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3136));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((ExceptionHandler)tree.handlers().head()).exceptionHandlerTriggers().notFound(), "tree.handlers.head.exceptionHandlerTriggers.notFound", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3137));
            Seq $org_scalatest_assert_macro_left7 = ((ExceptionHandler)tree.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3138));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3122));
        this.test("declare handler for condition in parent scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12345';\n        |  BEGIN\n        |    DECLARE EXIT HANDLER FOR TEST_CONDITION SET test_var = 1;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            CompoundBody handlerBody = (CompoundBody)tree.collection().head();
            Seq $org_scalatest_assert_macro_left = handlerBody.handlers();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3152));
            ExceptionHandler $org_scalatest_assert_macro_left2 = (ExceptionHandler)handlerBody.handlers().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.ExceptionHandler", $org_scalatest_assert_macro_left2 instanceof ExceptionHandler, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3153));
            Set $org_scalatest_assert_macro_left3 = ((ExceptionHandler)handlerBody.handlers().head()).exceptionHandlerTriggers().conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3154));
            Set $org_scalatest_assert_macro_left4 = ((ExceptionHandler)handlerBody.handlers().head()).exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right3 = "TEST_CONDITION";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3155));
            Seq $org_scalatest_assert_macro_left5 = ((ExceptionHandler)handlerBody.handlers().head()).body().collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3156));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3141));
        this.test("declare nested handler for condition in parent scope of parent handler", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE TEST_CONDITION CONDITION FOR SQLSTATE '12345';\n        |  BEGIN\n        |    DECLARE EXIT HANDLER FOR DIVIDE_BY_ZERO\n        |      BEGIN\n        |        DECLARE EXIT HANDLER FOR TEST_CONDITION SET test_var = 1;\n        |      END;\n        |  END;\n        |END"));
            CompoundBody tree = (CompoundBody)CatalystSqlParser$.MODULE$.parsePlan(sqlScriptText);
            ExceptionHandler handlerBody = (ExceptionHandler)((ExceptionHandler)((CompoundBody)tree.collection().head()).handlers().head()).body().handlers().head();
            Set $org_scalatest_assert_macro_left = handlerBody.exceptionHandlerTriggers().conditions();
            String $org_scalatest_assert_macro_right = "TEST_CONDITION";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3176));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 3159));
    }
}

