/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition$;
import org.apache.spark.sql.catalyst.plans.logical.DefaultValueExpression;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumnsUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005E3AAD\b\u00015!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u0019\u0001A\u0003%Q\u0006C\u00042\u0001\t\u0007I\u0011\u0002\u001a\t\rm\u0002\u0001\u0015!\u00034\u0011\u001da\u0004A1A\u0005\nIBa!\u0010\u0001!\u0002\u0013\u0019\u0004b\u0002 \u0001\u0005\u0004%Ia\u0010\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002!\t\u000f5\u0003!\u0019!C\u0005Y!1a\n\u0001Q\u0001\n5Bqa\u0014\u0001C\u0002\u0013%A\u0006\u0003\u0004Q\u0001\u0001\u0006I!\f\u0002\u0010'R\u0014Xo\u0019;UsB,7+^5uK*\u0011\u0001#E\u0001\u0006if\u0004Xm\u001d\u0006\u0003%M\t1a]9m\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0004\u0001my\u0002C\u0001\u000f\u001e\u001b\u0005\u0019\u0012B\u0001\u0010\u0014\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0006a2\fgn\u001d\u0006\u0003IE\t\u0001bY1uC2L8\u000f^\u0005\u0003M\u0005\u0012\u0011bU)M\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005y\u0011!A:\u0016\u00035\u0002\"A\u000b\u0018\n\u0005=z!AC*ueV\u001cG\u000fV=qK\u0006\u00111\u000fI\u0001\u0012+:K5i\u0014#F?\u000e{E\nT!U\u0013>sU#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00027b]\u001eT\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\t11\u000b\u001e:j]\u001e\f!#\u0016(J\u0007>#UiX\"P\u00192\u000bE+S(OA\u0005!R\u000b\u0016$9?2\u001b\u0015iU#`\u0007>cE*\u0011+J\u001f:\u000bQ#\u0016+Gq}c5)Q*F?\u000e{E\nT!U\u0013>s\u0005%\u0001\u0004nCB\u0004XM]\u000b\u0002\u0001B\u0011\u0011IS\u0007\u0002\u0005*\u00111\tR\u0001\tI\u0006$\u0018MY5oI*\u0011QIR\u0001\bU\u0006\u001c7n]8o\u0015\t9\u0005*A\u0005gCN$XM\u001d=nY*\t\u0011*A\u0002d_6L!a\u0013\"\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u000f5\f\u0007\u000f]3sA\u0005aa.Z:uK\u0012\u001cFO];di\u0006ia.Z:uK\u0012\u001cFO];di\u0002\nQc\u001d;sk\u000e$x+\u001b;i\u000b6\u0004H/_*ue&tw-\u0001\ftiJ,8\r^,ji\",U\u000e\u001d;z'R\u0014\u0018N\\4!\u0001")
public class StructTypeSuite
extends SparkFunSuite
implements SQLHelper {
    private final StructType s;
    private final String UNICODE_COLLATION;
    private final String UTF8_LCASE_COLLATION;
    private final ObjectMapper mapper;
    private final StructType nestedStruct;
    private final StructType structWithEmptyString;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        StructTypeSuite structTypeSuite = this;
        synchronized (structTypeSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private StructType s() {
        return this.s;
    }

    private String UNICODE_COLLATION() {
        return this.UNICODE_COLLATION;
    }

    private String UTF8_LCASE_COLLATION() {
        return this.UTF8_LCASE_COLLATION;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private StructType nestedStruct() {
        return this.nestedStruct;
    }

    private StructType structWithEmptyString() {
        return this.structWithEmptyString;
    }

    private final void checkIntervalDDL$1(byte start, byte end, Function1 fieldToString) {
        String startUnit = (String)fieldToString.apply((Object)BoxesRunTime.boxToByte((byte)start));
        String endUnit = (String)fieldToString.apply((Object)BoxesRunTime.boxToByte((byte)end));
        if (start < end) {
            StructType$.MODULE$.fromDDL("x INTERVAL " + startUnit + " TO " + endUnit);
            return;
        }
        this.intercept((Function0 & Serializable)() -> StructType$.MODULE$.fromDDL("x INTERVAL " + startUnit + " TO " + endUnit), ClassTag$.MODULE$.apply(ParseException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
    }

    public static final /* synthetic */ void $anonfun$new$38(StructTypeSuite $this, byte start) {
        YearMonthIntervalType$.MODULE$.yearMonthFields().foreach((Function1 & Serializable)end -> {
            $this.checkIntervalDDL$1(start, BoxesRunTime.unboxToByte((Object)end), (Function1 & Serializable)field -> YearMonthIntervalType$.MODULE$.fieldToString(BoxesRunTime.unboxToByte((Object)field)));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$41(StructTypeSuite $this, byte start) {
        DayTimeIntervalType$.MODULE$.dayTimeFields().foreach((Function1 & Serializable)end -> {
            $this.checkIntervalDDL$1(start, BoxesRunTime.unboxToByte((Object)end), (Function1 & Serializable)field -> DayTimeIntervalType$.MODULE$.fieldToString(BoxesRunTime.unboxToByte((Object)field)));
            return BoxedUnit.UNIT;
        });
    }

    private static final void check$1(Seq field, Option expect, StructType input$1) {
        Option res;
        Seq x$1 = field;
        Function2 x$2 = package$.MODULE$.caseInsensitiveResolution();
        boolean x$3 = input$1.findNestedField$default$2();
        Origin x$4 = input$1.findNestedField$default$4();
        Option $org_scalatest_assert_macro_left = res = input$1.findNestedField(x$1, x$3, x$2, x$4);
        Option $org_scalatest_assert_macro_right = expect;
        Option option = $org_scalatest_assert_macro_left;
        Option option2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
    }

    private static final void caseSensitiveCheck$1(Seq field, Option expect, StructType input$1) {
        Option res;
        Seq x$1 = field;
        Function2 x$2 = package$.MODULE$.caseSensitiveResolution();
        boolean x$3 = input$1.findNestedField$default$2();
        Origin x$4 = input$1.findNestedField$default$4();
        Option $org_scalatest_assert_macro_left = res = input$1.findNestedField(x$1, x$3, x$2, x$4);
        Option $org_scalatest_assert_macro_right = expect;
        Option option = $org_scalatest_assert_macro_left;
        Option option2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
    }

    private static final void checkCollection$1(Seq field, Option expect, StructType input$1) {
        Option res;
        Option $org_scalatest_assert_macro_left = res = input$1.findNestedField(field, true, package$.MODULE$.caseInsensitiveResolution(), input$1.findNestedField$default$4());
        Option $org_scalatest_assert_macro_right = expect;
        Option option = $org_scalatest_assert_macro_left;
        Option option2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
    }

    private static final void validateConvertedDefaults$1(String colName, DataType dataType, String defaultSQL, String expectedExists) {
        String existsSQL;
        Expression existsDefault = ResolveDefaultColumns$.MODULE$.analyze(colName, dataType, defaultSQL, "");
        ColumnDefinition col = new ColumnDefinition(colName, dataType, true, (Option)None$.MODULE$, (Option)new Some((Object)new DefaultValueExpression(existsDefault, defaultSQL)), ColumnDefinition$.MODULE$.apply$default$6(), ColumnDefinition$.MODULE$.apply$default$7(), ColumnDefinition$.MODULE$.apply$default$8());
        StructField structField = col.toV1Column();
        String $org_scalatest_assert_macro_left = structField.metadata().getString(ResolveDefaultColumnsUtils$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
        String $org_scalatest_assert_macro_right = defaultSQL;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 818));
        String $org_scalatest_assert_macro_left2 = existsSQL = structField.metadata().getString(ResolveDefaultColumnsUtils$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
        String $org_scalatest_assert_macro_right2 = expectedExists;
        String string3 = $org_scalatest_assert_macro_left2;
        String string4 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Literal$.MODULE$.fromSQL(existsSQL).resolved(), "org.apache.spark.sql.catalyst.expressions.Literal.fromSQL(existsSQL).resolved", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
    }

    public StructTypeSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.s = StructType$.MODULE$.fromDDL("a INT, b STRING");
        this.UNICODE_COLLATION = "UNICODE";
        this.UTF8_LCASE_COLLATION = "UTF8_LCASE";
        this.mapper = new ObjectMapper();
        this.test("lookup a single missing field should output existing fields", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> this.s().apply("c"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50))));
            String x$2 = "FIELD_NOT_FOUND";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`c`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"`a`, `b`")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "FIELD_NOT_FOUND", x$4, x$3, x$5, x$6);
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("lookup a set of missing fields should output existing fields", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkIllegalArgumentException x$7 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> this.s().apply((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"}))), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57))));
            String x$8 = "NONEXISTENT_FIELD_NAME_IN_LIST";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nonExistFields"), (Object)"`c`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldNames"), (Object)"`a`, `b`")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "NONEXISTENT_FIELD_NAME_IN_LIST", x$10, x$9, x$11, x$12);
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("lookup fieldIndex for missing field should output existing fields", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkIllegalArgumentException x$13 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> this.s().fieldIndex("c"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64))));
            String x$14 = "FIELD_NOT_FOUND";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`c`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"`a`, `b`")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "FIELD_NOT_FOUND", x$16, x$15, x$17, x$18);
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("SPARK-24849: toDDL - simple struct", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "a INT";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("SPARK-24849: round trip toDDL - fromDDL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("b", (DataType)StringType$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(struct.toDDL()));
            StructType $org_scalatest_assert_macro_right = struct;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("SPARK-24849: round trip fromDDL - toDDL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String struct = "a MAP<INT, STRING>,b INT";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(struct).toDDL());
            String $org_scalatest_assert_macro_right = struct;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("SPARK-24849: toDDL must take into account case of fields.", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = new StructType().add("metaData", (DataType)new StructType().add("eventId", (DataType)StringType$.MODULE$));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "metaData STRUCT<eventId: STRING>";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("SPARK-24849: toDDL should output field's comment", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("Field's comment"), (List)Nil$.MODULE$));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "b BOOLEAN COMMENT 'Field\\'s comment'";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.nestedStruct = new StructType().add(new StructField("a", (DataType)new StructType().add(new StructField("b", (DataType)new StructType().add(new StructField("c", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("Deep Nested comment")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("Nested comment")), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("comment"));
        this.test("SPARK-33846: toDDL should output nested field's comment", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String ddl = "a STRUCT<b: STRUCT<c: STRING COMMENT 'Deep Nested comment'> COMMENT 'Nested comment'> COMMENT 'comment'";
            String $org_scalatest_assert_macro_left = this.nestedStruct().toDDL();
            String $org_scalatest_assert_macro_right = ddl;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("SPARK-33846: fromDDL should parse nested field's comment", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String ddl = "`a` STRUCT<`b`: STRUCT<`c`: STRING COMMENT 'Deep Nested comment'> COMMENT 'Nested comment'> COMMENT 'comment'";
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(ddl);
            StructType $org_scalatest_assert_macro_right = this.nestedStruct();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("SPARK-33846: round trip toDDL -> fromDDL - nested struct", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(this.nestedStruct().toDDL());
            StructType $org_scalatest_assert_macro_right = this.nestedStruct();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("SPARK-35706: make the ':' in STRUCT data type definition optional", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String ddl = "`a` STRUCT<`b` STRUCT<`c` STRING COMMENT 'Deep Nested comment'> COMMENT 'Nested comment'> COMMENT 'comment'";
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(ddl);
            StructType $org_scalatest_assert_macro_right = this.nestedStruct();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.structWithEmptyString = new StructType().add(new StructField("a b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("comment"));
        this.test("SPARK-33846: empty string in a column's name should be respected by toDDL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String ddl = "`a b` STRING COMMENT 'comment'";
            String $org_scalatest_assert_macro_left = this.structWithEmptyString().toDDL();
            String $org_scalatest_assert_macro_right = ddl;
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("SPARK-33846: empty string in a column's name should be respected by fromDDL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String ddl = "`a b` STRING COMMENT 'comment'";
            StructType $org_scalatest_assert_macro_left = StructType$.MODULE$.fromDDL(ddl);
            StructType $org_scalatest_assert_macro_right = this.structWithEmptyString();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("Print up to the given level", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType schema = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            int $org_scalatest_assert_macro_left = 5;
            int $org_scalatest_assert_macro_right = schema.treeString(2).split("\n").length;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            int $org_scalatest_assert_macro_left2 = 3;
            int $org_scalatest_assert_macro_right2 = schema.treeString(1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            int $org_scalatest_assert_macro_left3 = 7;
            int $org_scalatest_assert_macro_right3 = schema.treeString().split("\n").length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            int $org_scalatest_assert_macro_left4 = 7;
            int $org_scalatest_assert_macro_right4 = schema.treeString(0).split("\n").length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            int $org_scalatest_assert_macro_left5 = 7;
            int $org_scalatest_assert_macro_right5 = schema.treeString(-1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            StructType schema2 = StructType$.MODULE$.fromDDL("c1 INT, c2 ARRAY<STRUCT<c3: INT>>, c4 STRUCT<c5: INT, c6: ARRAY<ARRAY<INT>>>");
            int $org_scalatest_assert_macro_left6 = 4;
            int $org_scalatest_assert_macro_right6 = schema2.treeString(1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            int $org_scalatest_assert_macro_left7 = 7;
            int $org_scalatest_assert_macro_right7 = schema2.treeString(2).split("\n").length;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            int $org_scalatest_assert_macro_left8 = 9;
            int $org_scalatest_assert_macro_right8 = schema2.treeString(3).split("\n").length;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            int $org_scalatest_assert_macro_left9 = 10;
            int $org_scalatest_assert_macro_right9 = schema2.treeString(4).split("\n").length;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            int $org_scalatest_assert_macro_left10 = 10;
            int $org_scalatest_assert_macro_right10 = schema2.treeString(0).split("\n").length;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            StructType schema3 = StructType$.MODULE$.fromDDL("c1 MAP<INT, STRUCT<c2: MAP<INT, INT>>>, c3 STRUCT<c4: MAP<INT, MAP<INT, INT>>>");
            int $org_scalatest_assert_macro_left11 = 3;
            int $org_scalatest_assert_macro_right11 = schema3.treeString(1).split("\n").length;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 == $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            int $org_scalatest_assert_macro_left12 = 6;
            int $org_scalatest_assert_macro_right12 = schema3.treeString(2).split("\n").length;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left12), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 == $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            int $org_scalatest_assert_macro_left13 = 9;
            int $org_scalatest_assert_macro_right13 = schema3.treeString(3).split("\n").length;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left13), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13 == $org_scalatest_assert_macro_right13, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            int $org_scalatest_assert_macro_left14 = 13;
            int $org_scalatest_assert_macro_right14 = schema3.treeString(4).split("\n").length;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            int $org_scalatest_assert_macro_left15 = 13;
            int $org_scalatest_assert_macro_right15 = schema3.treeString(0).split("\n").length;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15 == $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("interval keyword in schema string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String interval = "a INTERVAL";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(interval).toDDL());
            String $org_scalatest_assert_macro_right = interval;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("find missing (nested) fields", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType schema = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            Function2 resolver = SQLConf$.MODULE$.get().resolver();
            StructType source1 = StructType$.MODULE$.fromDDL("c1 INT");
            StructType missing1 = StructType$.MODULE$.fromDDL("c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source1, schema, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing1))), "StructType.findMissingFields(source1, schema, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing1)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            StructType source2 = StructType$.MODULE$.fromDDL("c1 INT, c3 STRING");
            StructType missing2 = StructType$.MODULE$.fromDDL("c2 STRUCT<c3: INT, c4: STRUCT<c5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source2, schema, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing2))), "StructType.findMissingFields(source2, schema, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing2)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            StructType source3 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT>");
            StructType missing3 = StructType$.MODULE$.fromDDL("c2 STRUCT<c4: STRUCT<c5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source3, schema, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing3))), "StructType.findMissingFields(source3, schema, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing3)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            StructType source4 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, c4: STRUCT<c6: INT>>");
            StructType missing4 = StructType$.MODULE$.fromDDL("c2 STRUCT<c4: STRUCT<c5: INT>>");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source4, schema, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing4))), "StructType.findMissingFields(source4, schema, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing4)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("find missing (nested) fields: array and map", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Function2 resolver = SQLConf$.MODULE$.get().resolver();
            StructType schemaWithArray = StructType$.MODULE$.fromDDL("c1 INT, c2 ARRAY<STRUCT<c3: INT, c4: LONG>>");
            StructType source5 = StructType$.MODULE$.fromDDL("c1 INT");
            StructType missing5 = StructType$.MODULE$.fromDDL("c2 ARRAY<STRUCT<c3: INT, c4: LONG>>");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source5, schemaWithArray, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing5))), "StructType.findMissingFields(source5, schemaWithArray, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing5)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            StructType schemaWithMap1 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRUCT<c3: INT, c4: LONG>, STRING>, c3 LONG");
            StructType source6 = StructType$.MODULE$.fromDDL("c1 INT, c3 LONG");
            StructType missing6 = StructType$.MODULE$.fromDDL("c2 MAP<STRUCT<c3: INT, c4: LONG>, STRING>");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source6, schemaWithMap1, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing6))), "StructType.findMissingFields(source6, schemaWithMap1, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing6)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            StructType schemaWithMap2 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRING, STRUCT<c3: INT, c4: LONG>>, c3 STRING");
            StructType source7 = StructType$.MODULE$.fromDDL("c1 INT, c3 STRING");
            StructType missing7 = StructType$.MODULE$.fromDDL("c2 MAP<STRING, STRUCT<c3: INT, c4: LONG>>");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source7, schemaWithMap2, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing7))), "StructType.findMissingFields(source7, schemaWithMap2, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing7)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            StructType source8 = StructType$.MODULE$.fromDDL("c1 INT, c2 ARRAY<STRUCT<c3: INT>>");
            Option $org_scalatest_assert_macro_left = StructType$.MODULE$.findMissingFields(source8, schemaWithArray, resolver);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            StructType source9 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRUCT<c3: INT>, STRING>, c3 LONG");
            Option $org_scalatest_assert_macro_left2 = StructType$.MODULE$.findMissingFields(source9, schemaWithMap1, resolver);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
            StructType source10 = StructType$.MODULE$.fromDDL("c1 INT, c2 MAP<STRING, STRUCT<c3: INT>>, c3 STRING");
            Option $org_scalatest_assert_macro_left3 = StructType$.MODULE$.findMissingFields(source10, schemaWithMap2, resolver);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        this.test("find missing (nested) fields: case sensitive cases", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0 & Serializable)() -> {
            StructType schema = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, C4: STRUCT<C5: INT, c6: INT>>");
            Function2 resolver = SQLConf$.MODULE$.get().resolver();
            StructType source1 = StructType$.MODULE$.fromDDL("c1 INT, C2 LONG");
            StructType missing1 = StructType$.MODULE$.fromDDL("c2 STRUCT<c3: INT, C4: STRUCT<C5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source1, schema, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing1))), "StructType.findMissingFields(source1, schema, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing1)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            StructType source2 = StructType$.MODULE$.fromDDL("c2 LONG");
            StructType missing2 = StructType$.MODULE$.fromDDL("c1 INT");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source2, schema, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing2))), "StructType.findMissingFields(source2, schema, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing2)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            StructType source3 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, C4: STRUCT<c5: INT>>");
            StructType missing3 = StructType$.MODULE$.fromDDL("c2 STRUCT<C4: STRUCT<C5: INT, c6: INT>>");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source3, schema, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing3))), "StructType.findMissingFields(source3, schema, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing3)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            StructType source4 = StructType$.MODULE$.fromDDL("c1 INT, c2 STRUCT<c3: INT, C4: STRUCT<C5: Int>>");
            StructType missing4 = StructType$.MODULE$.fromDDL("c2 STRUCT<C4: STRUCT<c6: INT>>");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(StructType$.MODULE$.findMissingFields(source4, schema, resolver).exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.sameType((DataType)e, (DataType)missing4))), "StructType.findMissingFields(source4, schema, resolver).exists(((e: org.apache.spark.sql.types.StructType) => org.apache.spark.sql.catalyst.types.DataTypeUtils.sameType(e, missing4)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        }), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        this.test("SPARK-35285: ANSI interval types in schema", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String yearMonthInterval = "ymi INTERVAL YEAR TO MONTH";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(StructType$.MODULE$.fromDDL(yearMonthInterval).toDDL());
            String $org_scalatest_assert_macro_right = yearMonthInterval;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            String dayTimeInterval = "dti INTERVAL DAY TO SECOND";
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(StructType$.MODULE$.fromDDL(dayTimeInterval).toDDL());
            String $org_scalatest_assert_macro_right2 = dayTimeInterval;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.test("SPARK-35774: Prohibit the case start/end are the same with unit-to-unit interval syntax", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            YearMonthIntervalType$.MODULE$.yearMonthFields().foreach((Function1 & Serializable)start -> {
                StructTypeSuite.$anonfun$new$38(this, BoxesRunTime.unboxToByte((Object)start));
                return BoxedUnit.UNIT;
            });
            DayTimeIntervalType$.MODULE$.dayTimeFields().foreach((Function1 & Serializable)start -> {
                StructTypeSuite.$anonfun$new$41(this, BoxesRunTime.unboxToByte((Object)start));
                return BoxedUnit.UNIT;
            });
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        this.test("findNestedField", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException e;
            StructType innerStruct = new StructType().add("s11", "int").add("s12", "int");
            StructType input = new StructType().add("s1", (DataType)innerStruct).add("s2", (DataType)new StructType().add("x", "int").add("X", "int")).add("m1", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$)).add("m2", (DataType)MapType$.MODULE$.apply((DataType)new StructType().add("a", "int"), (DataType)new StructType().add("b", "int"))).add("m3", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)new StructType().add("ma", (DataType)IntegerType$.MODULE$)))).add("a1", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)).add("a2", (DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("c", "int"))).add("a3", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)new StructType().add("d", "int"))));
            StructTypeSuite.check$1((Seq)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$), (Option)None$.MODULE$, input);
            StructTypeSuite.check$1((Seq)new .colon.colon((Object)"S1", (List)Nil$.MODULE$), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Nil$.MODULE$), (Object)new StructField("s1", (DataType)innerStruct, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.caseSensitiveCheck$1((Seq)new .colon.colon((Object)"S1", (List)Nil$.MODULE$), (Option)None$.MODULE$, input);
            StructTypeSuite.check$1((Seq)new .colon.colon((Object)"s1", (List)new .colon.colon((Object)"S12", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"s1", (List)Nil$.MODULE$)), (Object)new StructField("s12", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.caseSensitiveCheck$1((Seq)new .colon.colon((Object)"s1", (List)new .colon.colon((Object)"S12", (List)Nil$.MODULE$)), (Option)None$.MODULE$, input);
            StructTypeSuite.check$1((Seq)new .colon.colon((Object)"S1.non_exist", (List)Nil$.MODULE$), (Option)None$.MODULE$, input);
            AnalysisException x$19 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.check$1((Seq)new .colon.colon((Object)"S1", (List)new .colon.colon((Object)"S12", (List)new .colon.colon((Object)"S123", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342))));
            String x$20 = "INVALID_FIELD_NAME";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`S1`.`S12`.`S123`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`s1`.`s12`")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "INVALID_FIELD_NAME", x$22, x$21, x$23, x$24);
            AnalysisException x$25 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.check$1((Seq)new .colon.colon((Object)"S2", (List)new .colon.colon((Object)"x", (List)Nil$.MODULE$)), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353))));
            String x$26 = "AMBIGUOUS_COLUMN_OR_FIELD";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"`S2`.`x`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)"2")}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, "AMBIGUOUS_COLUMN_OR_FIELD", x$28, x$27, x$29, x$30);
            StructTypeSuite.caseSensitiveCheck$1((Seq)new .colon.colon((Object)"s2", (List)new .colon.colon((Object)"x", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"s2", (List)Nil$.MODULE$)), (Object)new StructField("x", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            AnalysisException x$31 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.check$1((Seq)new .colon.colon((Object)"m1", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$)), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363))));
            String x$32 = "INVALID_FIELD_NAME";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`m1`.`key`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`m1`")}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, "INVALID_FIELD_NAME", x$34, x$33, x$35, x$36);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"m1", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"m1", (List)Nil$.MODULE$)), (Object)new StructField("key", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M1", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"m1", (List)Nil$.MODULE$)), (Object)new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            AnalysisException x$37 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M1", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374))));
            String x$38 = "INVALID_FIELD_NAME";
            Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`M1`.`key`.`name`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`m1`.`key`")}));
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$42 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$37, "INVALID_FIELD_NAME", x$40, x$39, x$41, x$42);
            AnalysisException x$43 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M1", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383))));
            String x$44 = "INVALID_FIELD_NAME";
            Map x$45 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`M1`.`value`.`name`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`m1`.`value`")}));
            Option x$46 = this.checkError$default$3();
            boolean x$47 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$48 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$43, "INVALID_FIELD_NAME", x$46, x$45, x$47, x$48);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$))), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"m2", (List)new .colon.colon((Object)"key", (List)Nil$.MODULE$))), (Object)new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"m2", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$))), (Object)new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input);
            AnalysisException x$49 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"m2", (List)new .colon.colon((Object)"key", (List)new .colon.colon((Object)"A", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$)))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400))));
            String x$50 = "INVALID_FIELD_NAME";
            Map x$51 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`m2`.`key`.`A`.`name`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`m2`.`key`.`a`")}));
            Option x$52 = this.checkError$default$3();
            boolean x$53 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$54 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$49, "INVALID_FIELD_NAME", x$52, x$51, x$53, x$54);
            AnalysisException x$55 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M2", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$)))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409))));
            String x$56 = "INVALID_FIELD_NAME";
            Map x$57 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`M2`.`value`.`b`.`name`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`m2`.`value`.`b`")}));
            Option x$58 = this.checkError$default$3();
            boolean x$59 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$60 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$55, "INVALID_FIELD_NAME", x$58, x$57, x$59, x$60);
            AnalysisException x$61 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.check$1((Seq)new .colon.colon((Object)"A1", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$)), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419))));
            String x$62 = "INVALID_FIELD_NAME";
            Map x$63 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`A1`.`element`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`a1`")}));
            Option x$64 = this.checkError$default$3();
            boolean x$65 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$66 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$61, "INVALID_FIELD_NAME", x$64, x$63, x$65, x$66);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A1", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$)), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"a1", (List)Nil$.MODULE$)), (Object)new StructField("element", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            AnalysisException x$67 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A1", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429))));
            String x$68 = "INVALID_FIELD_NAME";
            Map x$69 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`A1`.`element`.`name`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`a1`.`element`")}));
            Option x$70 = this.checkError$default$3();
            boolean x$71 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$72 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$67, "INVALID_FIELD_NAME", x$70, x$69, x$71, x$72);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A2", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"C", (List)Nil$.MODULE$))), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"a2", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$))), (Object)new StructField("c", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A2", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$))), (Option)None$.MODULE$, input);
            AnalysisException x$73 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"a2", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"C", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$)))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443))));
            String x$74 = "INVALID_FIELD_NAME";
            Map x$75 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`a2`.`element`.`C`.`name`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`a2`.`element`.`c`")}));
            Option x$76 = this.checkError$default$3();
            boolean x$77 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$78 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$73, "INVALID_FIELD_NAME", x$76, x$75, x$77, x$78);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M3", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"MA", (List)Nil$.MODULE$)))), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"m3", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"value", (List)Nil$.MODULE$)))), (Object)new StructField("ma", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M3", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$)))), (Option)None$.MODULE$, input);
            AnalysisException x$79 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"M3", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"value", (List)new .colon.colon((Object)"MA", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457))));
            String x$80 = "INVALID_FIELD_NAME";
            Map x$81 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`M3`.`value`.`value`.`MA`.`name`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`m3`.`value`.`value`.`ma`")}));
            Option x$82 = this.checkError$default$3();
            boolean x$83 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$84 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$79, "INVALID_FIELD_NAME", x$82, x$81, x$83, x$84);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A3", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"D", (List)Nil$.MODULE$)))), (Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new .colon.colon((Object)"a3", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"element", (List)Nil$.MODULE$)))), (Object)new StructField("d", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))), input);
            StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A3", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"non_exist", (List)Nil$.MODULE$)))), (Option)None$.MODULE$, input);
            AnalysisException x$85 = e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> StructTypeSuite.checkCollection$1((Seq)new .colon.colon((Object)"A3", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"element", (List)new .colon.colon((Object)"D", (List)new .colon.colon((Object)"name", (List)Nil$.MODULE$))))), (Option)None$.MODULE$, input), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471))));
            String x$86 = "INVALID_FIELD_NAME";
            Map x$87 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`A3`.`element`.`element`.`D`.`name`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)"`a3`.`element`.`element`.`d`")}));
            Option x$88 = this.checkError$default$3();
            boolean x$89 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$90 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$85, "INVALID_FIELD_NAME", x$88, x$87, x$89, x$90);
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
        this.test("SPARK-36807: Merge ANSI interval types to a tightest common type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()))), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH()))), (Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH()), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH()))), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()), (Object)YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()))), (Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()), (Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()))), (Object)new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()))), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()))), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()), (Object)DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE()), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()))})).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                AnsiIntervalType expected = (AnsiIntervalType)tuple2._2();
                if (tuple22 != null) {
                    AnsiIntervalType i1 = (AnsiIntervalType)tuple22._1();
                    AnsiIntervalType i2 = (AnsiIntervalType)tuple22._2();
                    StructType st1 = new StructType().add("interval", (DataType)i1);
                    StructType st2 = new StructType().add("interval", (DataType)i2);
                    StructType expectedStruct = new StructType().add("interval", (DataType)expected);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(st1.merge(st2, st1.merge$default$2()));
                    StructType $org_scalatest_assert_macro_right = expectedStruct;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(st2.merge(st1, st2.merge$default$2()));
                    StructType $org_scalatest_assert_macro_right2 = expectedStruct;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        this.test("SPARK-37076: Implement StructType.toString explicitly for Scala 2.13", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType struct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(struct.toString());
            String $org_scalatest_assert_macro_right = "StructType(StructField(a,IntegerType,true))";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        this.test("SPARK-37191: Merge DecimalType", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType qual$1 = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)");
            StructType x$91 = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)");
            boolean x$92 = qual$1.merge$default$2();
            StructType source1 = qual$1.merge(x$91, x$92);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(source1);
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
            StructType qual$2 = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)");
            StructType x$93 = StructType$.MODULE$.fromDDL("c1 DECIMAL(17, 2)");
            boolean x$94 = qual$2.merge$default$2();
            StructType source2 = qual$2.merge(x$93, x$94);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(source2);
            StructType $org_scalatest_assert_macro_right2 = StructType$.MODULE$.fromDDL("c1 DECIMAL(17, 2)");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            StructType qual$3 = StructType$.MODULE$.fromDDL("c1 DECIMAL(17, 2)");
            StructType x$95 = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)");
            boolean x$96 = qual$3.merge$default$2();
            StructType source3 = qual$3.merge(x$95, x$96);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(source3);
            StructType $org_scalatest_assert_macro_right3 = StructType$.MODULE$.fromDDL("c1 DECIMAL(17, 2)");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
            SparkException x$99 = (SparkException)this.intercept((Function0 & Serializable)() -> {
                StructType qual$4 = StructType$.MODULE$.fromDDL("c1 DECIMAL(10, 5)");
                StructType x$97 = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)");
                boolean x$98 = qual$4.merge$default$2();
                return qual$4.merge(x$97, x$98);
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
            String x$100 = "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE";
            Map x$101 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"DECIMAL(10,5)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"DECIMAL(12,2)\"")}));
            Option x$102 = this.checkError$default$3();
            boolean x$103 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$104 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$99, "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE", x$102, x$101, x$103, x$104);
            SparkException x$107 = (SparkException)this.intercept((Function0 & Serializable)() -> {
                StructType qual$5 = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 5)");
                StructType x$105 = StructType$.MODULE$.fromDDL("c1 DECIMAL(12, 2)");
                boolean x$106 = qual$5.merge$default$2();
                return qual$5.merge(x$105, x$106);
            }, ClassTag$.MODULE$.apply(SparkException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            String x$108 = "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE";
            Map x$109 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)"\"DECIMAL(12,5)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)"\"DECIMAL(12,2)\"")}));
            Option x$110 = this.checkError$default$3();
            boolean x$111 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$112 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$107, "CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE", x$110, x$109, x$111, x$112);
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
        this.test("SPARK-39143: Test parsing default column values out of struct types", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructType source1 = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)LongType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "CAST(42 AS BIGINT)").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "CAST(42 AS BIGINT)").build()), new StructField("c2", (DataType)StringType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "'abc'").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "'abc'").build()), new StructField("c3", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
            Object[] $org_scalatest_assert_macro_left = ResolveDefaultColumns$.MODULE$.existenceDefaultValues(source1);
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
            Object $org_scalatest_assert_macro_left2 = ResolveDefaultColumns$.MODULE$.existenceDefaultValues(source1)[0];
            int $org_scalatest_assert_macro_right2 = 42;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
            Object $org_scalatest_assert_macro_left3 = ResolveDefaultColumns$.MODULE$.existenceDefaultValues(source1)[1];
            UTF8String $org_scalatest_assert_macro_right3 = UTF8String.fromString((String)"abc");
            Object object = $org_scalatest_assert_macro_left3;
            UTF8String uTF8String = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(object != null ? !object.equals(uTF8String) : uTF8String != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
            Object $org_scalatest_assert_macro_left4 = ResolveDefaultColumns$.MODULE$.existenceDefaultValues(source1)[2];
            Object $org_scalatest_assert_macro_right4 = null;
            Object object2 = $org_scalatest_assert_macro_left4;
            Object var15_14 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", null, !(object2 != null ? !object2.equals(var15_14) : var15_14 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
            StructType source2 = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "1 + 1").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "1 + 1").build())}));
            Object[] $org_scalatest_assert_macro_left5 = ResolveDefaultColumns$.MODULE$.existenceDefaultValues(source2);
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
            Object $org_scalatest_assert_macro_left6 = ResolveDefaultColumns$.MODULE$.existenceDefaultValues(source2)[0];
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left6, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
            StructType source3 = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "invalid").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "invalid").build())}));
            AnalysisException x$113 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> ResolveDefaultColumns$.MODULE$.existenceDefaultValues(source3), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583))));
            String x$114 = "INVALID_DEFAULT_VALUE.UNRESOLVED_EXPRESSION";
            Map x$115 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`c1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)"invalid")}));
            Option x$116 = this.checkError$default$3();
            boolean x$117 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$118 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$113, "INVALID_DEFAULT_VALUE.UNRESOLVED_EXPRESSION", x$116, x$115, x$117, x$118);
            StructType source4 = new StructType((StructField[])((Object[])new StructField[]{new StructField("c1", (DataType)IntegerType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "(SELECT 'abc' FROM missingtable)").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "(SELECT 'abc' FROM missingtable)").build())}));
            AnalysisException x$119 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> ResolveDefaultColumns$.MODULE$.existenceDefaultValues(source4), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603))));
            String x$120 = "INVALID_DEFAULT_VALUE.SUBQUERY_EXPRESSION";
            Map x$121 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)"`c1`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)"(SELECT 'abc' FROM missingtable)")}));
            Option x$122 = this.checkError$default$3();
            boolean x$123 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$124 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$119, "INVALID_DEFAULT_VALUE.SUBQUERY_EXPRESSION", x$122, x$121, x$123, x$124);
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
        this.test("SPARK-46629: Test STRUCT DDL with NOT NULL round trip", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType struct = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("b", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()).withComment("struct comment"), (List)Nil$.MODULE$)), false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()).withComment("nullable comment"), (List)Nil$.MODULE$))));
            String $org_scalatest_assert_macro_left = struct.toDDL();
            String $org_scalatest_assert_macro_right = "b STRUCT<c: STRING NOT NULL COMMENT 'struct comment'> NOT NULL,b STRING NOT NULL,c STRING COMMENT 'nullable comment'";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(StructType$.MODULE$.fromDDL(struct.toDDL()));
            StructType $org_scalatest_assert_macro_right2 = struct;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
        this.test("simple struct with collations to json", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("c1", (DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType simpleStruct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            String expectedJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"struct\",\n         |  \"fields\": [\n         |    {\n         |      \"name\": \"c1\",\n         |      \"type\": \"string\",\n         |      \"nullable\": true,\n         |      \"metadata\": {\n         |        \"" + DataType$.MODULE$.COLLATIONS_METADATA_KEY() + "\": {\n         |          \"c1\": \"icu." + this.UNICODE_COLLATION() + "\"\n         |        }\n         |      }\n         |    }\n         |  ]\n         |}\n         |"));
            JsonNode $org_scalatest_assert_macro_left = this.mapper().readTree(simpleStruct.json());
            JsonNode $org_scalatest_assert_macro_right = this.mapper().readTree(expectedJson);
            JsonNode jsonNode = $org_scalatest_assert_macro_left;
            JsonNode jsonNode2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        this.test("nested struct with collations to json", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("c1", (DataType)StringType$.MODULE$.apply(this.UTF8_LCASE_COLLATION()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("nested", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType nestedStruct = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2));
            String expectedJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"struct\",\n         |  \"fields\": [\n         |    {\n         |      \"name\": \"nested\",\n         |      \"type\": {\n         |        \"type\": \"struct\",\n         |        \"fields\": [\n         |          {\n         |            \"name\": \"c1\",\n         |            \"type\": \"string\",\n         |            \"nullable\": true,\n         |            \"metadata\": {\n         |              \"" + DataType$.MODULE$.COLLATIONS_METADATA_KEY() + "\": {\n         |                \"c1\": \"spark." + this.UTF8_LCASE_COLLATION() + "\"\n         |              }\n         |            }\n         |          }\n         |        ]\n         |      },\n         |      \"nullable\": true,\n         |      \"metadata\": {}\n         |    }\n         |  ]\n         |}\n         |"));
            JsonNode $org_scalatest_assert_macro_left = this.mapper().readTree(nestedStruct.json());
            JsonNode $org_scalatest_assert_macro_right = this.mapper().readTree(expectedJson);
            JsonNode jsonNode = $org_scalatest_assert_macro_left;
            JsonNode jsonNode2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
        this.test("array with collations in schema to json", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("arrayField", (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION())), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType arrayInSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            String expectedJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"struct\",\n         |  \"fields\": [\n         |    {\n         |      \"name\": \"arrayField\",\n         |      \"type\": {\n         |        \"type\": \"array\",\n         |        \"elementType\": \"string\",\n         |        \"containsNull\": true\n         |      },\n         |      \"nullable\": true,\n         |      \"metadata\": {\n         |        \"" + DataType$.MODULE$.COLLATIONS_METADATA_KEY() + "\": {\n         |          \"arrayField.element\": \"icu." + this.UNICODE_COLLATION() + "\"\n         |        }\n         |      }\n         |    }\n         |  ]\n         |}\n         |"));
            JsonNode $org_scalatest_assert_macro_left = this.mapper().readTree(arrayInSchema.json());
            JsonNode $org_scalatest_assert_macro_right = this.mapper().readTree(expectedJson);
            JsonNode jsonNode = $org_scalatest_assert_macro_left;
            JsonNode jsonNode2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
        this.test("map with collations in schema to json", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("mapField", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION()), (DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION())), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType arrayInSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            String expectedJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"struct\",\n         |  \"fields\": [\n         |    {\n         |      \"name\": \"mapField\",\n         |      \"type\": {\n         |        \"type\": \"map\",\n         |        \"keyType\": \"string\",\n         |        \"valueType\": \"string\",\n         |        \"valueContainsNull\": true\n         |      },\n         |      \"nullable\": true,\n         |      \"metadata\": {\n         |        \"" + DataType$.MODULE$.COLLATIONS_METADATA_KEY() + "\": {\n         |          \"mapField.key\": \"icu." + this.UNICODE_COLLATION() + "\",\n         |          \"mapField.value\": \"icu." + this.UNICODE_COLLATION() + "\"\n         |        }\n         |      }\n         |    }\n         |  ]\n         |}\n         |"));
            JsonNode $org_scalatest_assert_macro_left = this.mapper().readTree(arrayInSchema.json());
            JsonNode $org_scalatest_assert_macro_right = this.mapper().readTree(expectedJson);
            JsonNode jsonNode = $org_scalatest_assert_macro_left;
            JsonNode jsonNode2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
        this.test("nested array with collations in map to json", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("column", (DataType)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION()), (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$.apply(this.UNICODE_COLLATION())))))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType mapWithNestedArray = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            String expectedJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |{\n         |  \"type\": \"struct\",\n         |  \"fields\": [\n         |    {\n         |      \"name\": \"column\",\n         |      \"type\": {\n         |        \"type\": \"array\",\n         |        \"elementType\": {\n         |          \"type\": \"map\",\n         |          \"keyType\": \"string\",\n         |          \"valueType\": {\n         |            \"type\": \"array\",\n         |            \"elementType\": {\n         |              \"type\": \"array\",\n         |              \"elementType\": {\n         |                \"type\": \"array\",\n         |                \"elementType\": \"string\",\n         |                \"containsNull\": true\n         |              },\n         |              \"containsNull\": true\n         |            },\n         |            \"containsNull\": true\n         |          },\n         |          \"valueContainsNull\": true\n         |        },\n         |        \"containsNull\": true\n         |      },\n         |      \"nullable\": true,\n         |      \"metadata\": {\n         |        \"" + DataType$.MODULE$.COLLATIONS_METADATA_KEY() + "\": {\n         |          \"column.element.key\": \"icu." + this.UNICODE_COLLATION() + "\",\n         |          \"column.element.value.element.element.element\": \"icu." + this.UNICODE_COLLATION() + "\"\n         |        }\n         |      }\n         |    }\n         |  ]\n         |}\n         |"));
            JsonNode $org_scalatest_assert_macro_left = this.mapper().readTree(mapWithNestedArray.json());
            JsonNode $org_scalatest_assert_macro_right = this.mapper().readTree(expectedJson);
            JsonNode jsonNode = $org_scalatest_assert_macro_left;
            JsonNode jsonNode2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        this.test("SPARK-51208: ColumnDefinition.toV1Column should preserve EXISTS_DEFAULT resolution", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            StructTypeSuite.validateConvertedDefaults$1("c1", (DataType)StringType$.MODULE$, "current_catalog()", "'spark_catalog'");
            StructTypeSuite.validateConvertedDefaults$1("c2", (DataType)VariantType$.MODULE$, "parse_json('1')", "PARSE_JSON('1')");
            StructTypeSuite.validateConvertedDefaults$1("c3", (DataType)VariantType$.MODULE$, "parse_json('{\"k\": \"v\"}')", "PARSE_JSON('{\"k\":\"v\"}')");
            StructTypeSuite.validateConvertedDefaults$1("c4", (DataType)VariantType$.MODULE$, "parse_json(null)", "CAST(NULL AS VARIANT)");
            StructTypeSuite.validateConvertedDefaults$1("c5", (DataType)IntegerType$.MODULE$, "1 + 1", "2");
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
        this.test("SPARK-51119: Add fallback to process unresolved EXISTS_DEFAULT", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType source = new StructType((StructField[])((Object[])new StructField[]{new StructField("c0", (DataType)VariantType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "parse_json(null)").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "parse_json(null)").build()), new StructField("c1", (DataType)StringType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "current_catalog()").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "current_catalog()").build()), new StructField("c2", (DataType)StringType$.MODULE$, true, new MetadataBuilder().putString(ResolveDefaultColumns$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), "CAST(CURRENT_TIMESTAMP AS BIGINT)").putString(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY(), "CAST(CURRENT_TIMESTAMP AS BIGINT)").build())}));
            Object[] res = ResolveDefaultColumns$.MODULE$.existenceDefaultValues(source);
            Object $org_scalatest_assert_macro_left = res[0];
            Object $org_scalatest_assert_macro_right = null;
            Object object = $org_scalatest_assert_macro_left;
            Object var5_4 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var5_4) : var5_4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
            Object $org_scalatest_assert_macro_left2 = res[1];
            UTF8String $org_scalatest_assert_macro_right2 = UTF8String.fromString((String)"spark_catalog");
            Object object2 = $org_scalatest_assert_macro_left2;
            UTF8String uTF8String = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(object2 != null ? !object2.equals(uTF8String) : uTF8String != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
            UTF8String.LongWrapper res2Wrapper = new UTF8String.LongWrapper();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((UTF8String)res[2]).toLong(res2Wrapper), "res.apply(2).asInstanceOf[org.apache.spark.unsafe.types.UTF8String].toLong(res2Wrapper)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
            long $org_scalatest_assert_macro_left3 = res2Wrapper.value;
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
        }, new Position("StructTypeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
    }
}

