/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.ExtendedAnalysisException;
import org.apache.spark.sql.catalyst.analysis.StreamingJoinHelper$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestampLike;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GroupingSets;
import org.apache.spark.sql.catalyst.expressions.LocalTimestamp;
import org.apache.spark.sql.catalyst.expressions.MonotonicallyIncreasingID;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.InnerLike;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.NaturalJoin;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.UsingJoin;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate$;
import org.apache.spark.sql.catalyst.plans.logical.CoGroup;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Deduplicate;
import org.apache.spark.sql.catalyst.plans.logical.DeduplicateWithinWatermark;
import org.apache.spark.sql.catalyst.plans.logical.DeserializeToObject;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeTimeout$;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark$;
import org.apache.spark.sql.catalyst.plans.logical.Except;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInPandasWithState;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsWithState;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoDir;
import org.apache.spark.sql.catalyst.plans.logical.Intersect;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MapElements;
import org.apache.spark.sql.catalyst.plans.logical.MapPartitions;
import org.apache.spark.sql.catalyst.plans.logical.Offset;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.ReturnAnswer;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.SerializeFromObject;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.plans.logical.TransformWithState;
import org.apache.spark.sql.catalyst.plans.logical.TransformWithStateInPandas;
import org.apache.spark.sql.catalyst.plans.logical.TypedFilter;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.OutputMode;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class UnsupportedOperationChecker$
implements Logging {
    public static final UnsupportedOperationChecker$ MODULE$ = new UnsupportedOperationChecker$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void checkForBatch(LogicalPlan plan2) {
        plan2.foreachUp((Function1 & Serializable)x0$1 -> {
            UnsupportedOperationChecker$.$anonfun$checkForBatch$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private boolean hasEventTimeCol(Expression exp) {
        return exp.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$hasEventTimeCol$1(x0$1)));
    }

    private boolean ifCannotBeFollowedByStatefulOperation(LogicalPlan p, OutputMode outputMode) {
        Distinct distinct;
        Aggregate aggregate;
        LogicalPlan logicalPlan = p;
        if (logicalPlan instanceof FlatMapGroupsWithState) {
            FlatMapGroupsWithState flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan;
            GroupStateTimeout timeout = flatMapGroupsWithState.timeout();
            if (flatMapGroupsWithState.isStreaming()) {
                GroupStateTimeout groupStateTimeout = timeout;
                GroupStateTimeout groupStateTimeout2 = GroupStateTimeout.EventTimeTimeout();
                if (!(groupStateTimeout != null ? !groupStateTimeout.equals(groupStateTimeout2) : groupStateTimeout2 != null)) {
                    return true;
                }
            }
        }
        if (logicalPlan instanceof FlatMapGroupsInPandasWithState) {
            FlatMapGroupsInPandasWithState flatMapGroupsInPandasWithState = (FlatMapGroupsInPandasWithState)logicalPlan;
            GroupStateTimeout timeout = flatMapGroupsInPandasWithState.timeout();
            if (flatMapGroupsInPandasWithState.isStreaming()) {
                GroupStateTimeout groupStateTimeout = timeout;
                GroupStateTimeout groupStateTimeout3 = GroupStateTimeout.EventTimeTimeout();
                if (!(groupStateTimeout != null ? !groupStateTimeout.equals(groupStateTimeout3) : groupStateTimeout3 != null)) {
                    return true;
                }
            }
        }
        if (logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming()) {
            OutputMode outputMode2 = outputMode;
            InternalOutputModes.Append$ append$ = InternalOutputModes.Append$.MODULE$;
            if (outputMode2 == null ? append$ != null : !outputMode2.equals(append$)) {
                return true;
            }
        }
        if (logicalPlan instanceof Distinct && (distinct = (Distinct)logicalPlan).child() != null && distinct.isStreaming()) {
            OutputMode outputMode3 = outputMode;
            InternalOutputModes.Append$ append$ = InternalOutputModes.Append$.MODULE$;
            if (outputMode3 == null ? append$ != null : !outputMode3.equals(append$)) {
                return true;
            }
        }
        return false;
    }

    private boolean isStatefulOperation(LogicalPlan p) {
        TransformWithStateInPandas transformWithStateInPandas;
        TransformWithState transformWithState;
        DeduplicateWithinWatermark deduplicateWithinWatermark;
        Deduplicate deduplicate2;
        FlatMapGroupsInPandasWithState flatMapGroupsInPandasWithState;
        FlatMapGroupsWithState flatMapGroupsWithState;
        Distinct distinct;
        Aggregate aggregate;
        LogicalPlan logicalPlan = p;
        if (logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming()) {
            return true;
        }
        if (logicalPlan instanceof Distinct && (distinct = (Distinct)logicalPlan).child() != null && distinct.isStreaming()) {
            return true;
        }
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            if (left.isStreaming() && right.isStreaming()) {
                return true;
            }
        }
        if (logicalPlan instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan).isStreaming()) {
            return true;
        }
        if (logicalPlan instanceof FlatMapGroupsInPandasWithState && (flatMapGroupsInPandasWithState = (FlatMapGroupsInPandasWithState)logicalPlan).isStreaming()) {
            return true;
        }
        if (logicalPlan instanceof Deduplicate && (deduplicate2 = (Deduplicate)logicalPlan).isStreaming() && deduplicate2.keys().exists((Function1 & Serializable)exp -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.MODULE$.hasEventTimeCol(exp)))) {
            return true;
        }
        if (logicalPlan instanceof DeduplicateWithinWatermark && (deduplicateWithinWatermark = (DeduplicateWithinWatermark)logicalPlan).isStreaming()) {
            return true;
        }
        if (logicalPlan instanceof TransformWithState && (transformWithState = (TransformWithState)logicalPlan).isStreaming()) {
            return true;
        }
        return logicalPlan instanceof TransformWithStateInPandas && (transformWithStateInPandas = (TransformWithStateInPandas)logicalPlan).isStreaming();
    }

    public void checkStreamingQueryGlobalWatermarkLimit(LogicalPlan plan2, OutputMode outputMode) {
        boolean failWhenDetected = SQLConf$.MODULE$.get().statefulOperatorCorrectnessCheckEnabled();
        try {
            plan2.foreach((Function1 & Serializable)subPlan -> {
                UnsupportedOperationChecker$.$anonfun$checkStreamingQueryGlobalWatermarkLimit$1(outputMode, plan2, subPlan);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AnalysisException) {
                AnalysisException analysisException = (AnalysisException)throwable2;
                if (!failWhenDetected) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ";\\n", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ANALYSIS_ERROR$.MODULE$, (Object)analysisException.message()), new MDC((LogKey)LogKeys.QUERY_PLAN$.MODULE$, (Object)plan2)}))), (Throwable)analysisException);
                }
            }
            throw throwable;
        }
    }

    private Option<String> checkAvroSupportForStatefulOperator(LogicalPlan p) {
        DeduplicateWithinWatermark deduplicateWithinWatermark;
        Deduplicate deduplicate2;
        FlatMapGroupsInPandasWithState flatMapGroupsInPandasWithState;
        FlatMapGroupsWithState flatMapGroupsWithState;
        Distinct distinct;
        Aggregate aggregate;
        LogicalPlan logicalPlan = p;
        if (logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming()) {
            return new Some((Object)"aggregation");
        }
        if (logicalPlan instanceof Distinct && (distinct = (Distinct)logicalPlan).child() != null && distinct.isStreaming()) {
            return new Some((Object)"distinct");
        }
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            if (left.isStreaming() && right.isStreaming()) {
                return new Some((Object)"join");
            }
        }
        if (logicalPlan instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan).isStreaming()) {
            return new Some((Object)"flatMapGroupsWithState");
        }
        if (logicalPlan instanceof FlatMapGroupsInPandasWithState && (flatMapGroupsInPandasWithState = (FlatMapGroupsInPandasWithState)logicalPlan).isStreaming()) {
            return new Some((Object)"applyInPandasWithState");
        }
        if (logicalPlan instanceof Deduplicate && (deduplicate2 = (Deduplicate)logicalPlan).isStreaming()) {
            return new Some((Object)"dropDuplicates");
        }
        if (logicalPlan instanceof DeduplicateWithinWatermark && (deduplicateWithinWatermark = (DeduplicateWithinWatermark)logicalPlan).isStreaming()) {
            return new Some((Object)"dropDuplicatesWithinWatermark");
        }
        return None$.MODULE$;
    }

    public void checkSupportedStoreEncodingFormats(LogicalPlan plan2) {
        String storeEncodingFormat = SQLConf$.MODULE$.get().stateStoreEncodingFormat();
        String string = storeEncodingFormat.toLowerCase(Locale.ROOT);
        String string2 = "avro";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            plan2.foreach((Function1 & Serializable)subPlan -> {
                UnsupportedOperationChecker$.$anonfun$checkSupportedStoreEncodingFormats$1(plan2, subPlan);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void checkForStreaming(LogicalPlan plan2, OutputMode outputMode) {
        Seq applyInPandasWithStates;
        if (!plan2.isStreaming()) {
            throw this.throwError("Queries without streaming sources cannot be executed with writeStream.start()", plan2);
        }
        Seq mapGroupsWithStates = plan2.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FlatMapGroupsWithState flatMapGroupsWithState;
                A1 A1 = x1;
                if (A1 instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)A1).isStreaming() && flatMapGroupsWithState.isMapGroupsWithState()) {
                    return (B1)flatMapGroupsWithState;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                FlatMapGroupsWithState flatMapGroupsWithState;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan).isStreaming() && flatMapGroupsWithState.isMapGroupsWithState();
            }
        });
        if (mapGroupsWithStates.size() >= 2) {
            throw this.throwError("Multiple mapGroupsWithStates are not supported on a streaming DataFrames/Datasets", plan2);
        }
        Seq flatMapGroupsWithStates = plan2.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                FlatMapGroupsWithState flatMapGroupsWithState;
                A1 A1 = x2;
                if (A1 instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)A1).isStreaming() && !flatMapGroupsWithState.isMapGroupsWithState()) {
                    return (B1)flatMapGroupsWithState;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(LogicalPlan x2) {
                FlatMapGroupsWithState flatMapGroupsWithState;
                LogicalPlan logicalPlan = x2;
                return logicalPlan instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan).isStreaming() && !flatMapGroupsWithState.isMapGroupsWithState();
            }
        });
        if (mapGroupsWithStates.nonEmpty() && flatMapGroupsWithStates.nonEmpty()) {
            throw this.throwError("Mixing mapGroupsWithStates and flatMapGroupsWithStates are not supported on a streaming DataFrames/Datasets", plan2);
        }
        if (flatMapGroupsWithStates.size() >= 2) {
            OutputMode outputMode2 = outputMode;
            InternalOutputModes.Append$ append$ = InternalOutputModes.Append$.MODULE$;
            if ((outputMode2 != null ? !outputMode2.equals(append$) : append$ != null) || flatMapGroupsWithStates.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkForStreaming$1(x$2)))) {
                throw this.throwError("Multiple flatMapGroupsWithStates are not supported when they are not all in append mode or the output mode is not append on a streaming DataFrames/Datasets", plan2);
            }
        }
        if ((applyInPandasWithStates = plan2.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                FlatMapGroupsInPandasWithState flatMapGroupsInPandasWithState;
                A1 A1 = x3;
                if (A1 instanceof FlatMapGroupsInPandasWithState && (flatMapGroupsInPandasWithState = (FlatMapGroupsInPandasWithState)A1).isStreaming()) {
                    return (B1)flatMapGroupsInPandasWithState;
                }
                return (B1)function1.apply(x3);
            }

            public final boolean isDefinedAt(LogicalPlan x3) {
                FlatMapGroupsInPandasWithState flatMapGroupsInPandasWithState;
                LogicalPlan logicalPlan = x3;
                return logicalPlan instanceof FlatMapGroupsInPandasWithState && (flatMapGroupsInPandasWithState = (FlatMapGroupsInPandasWithState)logicalPlan).isStreaming();
            }
        })).size() > 1) {
            throw this.throwError("Multiple applyInPandasWithStates are not supported on a streaming DataFrames/Datasets", plan2);
        }
        this.checkSupportedStoreEncodingFormats(plan2);
        Seq aggregates = UnsupportedOperationChecker$.collectStreamingAggregates$1(plan2);
        OutputMode outputMode3 = outputMode;
        if (InternalOutputModes.Append$.MODULE$.equals(outputMode3) && aggregates.nonEmpty()) {
            Aggregate aggregate = (Aggregate)aggregates.head();
            Seq watermarkAttributes = (Seq)aggregate.groupingExpressions().collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    Attribute attribute;
                    A1 A1 = x4;
                    if (A1 instanceof Attribute && (attribute = (Attribute)A1).metadata().contains(EventTimeWatermark$.MODULE$.delayKey())) {
                        return (B1)attribute;
                    }
                    return (B1)function1.apply(x4);
                }

                public final boolean isDefinedAt(Expression x4) {
                    Attribute attribute;
                    Expression expression = x4;
                    return expression instanceof Attribute && (attribute = (Attribute)expression).metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
                }
            });
            if (watermarkAttributes.isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.unsupportedOutputModeForStreamingOperationError(outputMode, "streaming aggregations without watermark");
            }
        } else if (InternalOutputModes.Update$.MODULE$.equals(outputMode3) && aggregates.nonEmpty()) {
            Aggregate aggregate = (Aggregate)aggregates.head();
            boolean existingSessionWindow = aggregate.groupingExpressions().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkForStreaming$2(x0$1)));
            if (existingSessionWindow) {
                throw QueryCompilationErrors$.MODULE$.unsupportedOutputModeForStreamingOperationError(outputMode, "session window streaming aggregations");
            }
        } else if (InternalOutputModes.Complete$.MODULE$.equals(outputMode3) && aggregates.isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.unsupportedOutputModeForStreamingOperationError(outputMode, "no streaming aggregations");
        }
        plan2.foreachUp((Function1 & Serializable)subPlan -> {
            UnsupportedOperationChecker$.$anonfun$checkForStreaming$5(this, plan2, outputMode, subPlan);
            return BoxedUnit.UNIT;
        });
        this.checkStreamingQueryGlobalWatermarkLimit(plan2, outputMode);
    }

    public void checkForContinuous(LogicalPlan plan2, OutputMode outputMode) {
        this.checkForStreaming(plan2, outputMode);
        plan2.foreachUp((Function1 & Serializable)subPlan -> {
            UnsupportedOperationChecker$.$anonfun$checkForContinuous$1(subPlan);
            return BoxedUnit.UNIT;
        });
    }

    private void throwErrorIf(boolean condition, String msg, LogicalPlan operator) {
        if (condition) {
            throw this.throwError(msg, operator);
        }
    }

    private Nothing$ throwError(String msg, LogicalPlan operator) {
        throw new ExtendedAnalysisException(new AnalysisException("_LEGACY_ERROR_TEMP_3102", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)msg)}))), operator);
    }

    private void checkForStreamStreamJoinWatermark(Join join) {
        boolean bl;
        boolean watermarkInJoinKeys = StreamingJoinHelper$.MODULE$.isWatermarkInJoinKeys(join);
        JoinType joinType = join.joinType();
        if (LeftOuter$.MODULE$.equals(joinType) ? true : LeftSemi$.MODULE$.equals(joinType)) {
            bl = StreamingJoinHelper$.MODULE$.getStateValueWatermark(join.left().outputSet(), join.right().outputSet(), join.condition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000000L))).isDefined();
        } else if (RightOuter$.MODULE$.equals(joinType)) {
            bl = StreamingJoinHelper$.MODULE$.getStateValueWatermark(join.right().outputSet(), join.left().outputSet(), join.condition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000000L))).isDefined();
        } else if (FullOuter$.MODULE$.equals(joinType)) {
            bl = new .colon.colon((Object)new Tuple2((Object)join.left().outputSet(), (Object)join.right().outputSet()), (List)new .colon.colon((Object)new Tuple2((Object)join.right().outputSet(), (Object)join.left().outputSet()), (List)Nil$.MODULE$)).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkForStreamStreamJoinWatermark$1(join, x0$1)));
        } else {
            throw this.throwError("Join type " + join.joinType() + " is not supported with streaming DataFrame/Dataset", join);
        }
        boolean hasValidWatermarkRange = bl;
        if (!watermarkInJoinKeys && !hasValidWatermarkRange) {
            throw this.throwError("Stream-stream " + join.joinType() + " join between two streaming DataFrame/Datasets is not supported without a watermark in the join keys, or a watermark on the nullable side and an appropriate range condition", join);
        }
    }

    public static final /* synthetic */ void $anonfun$checkForBatch$1(LogicalPlan x0$1) {
        LogicalPlan logicalPlan = x0$1;
        if (logicalPlan.isStreaming()) {
            throw MODULE$.throwError("Queries with streaming sources must be executed with writeStream.start()", logicalPlan);
        }
        if (logicalPlan instanceof DeduplicateWithinWatermark) {
            DeduplicateWithinWatermark deduplicateWithinWatermark = (DeduplicateWithinWatermark)logicalPlan;
            throw MODULE$.throwError("dropDuplicatesWithinWatermark is not supported with batch DataFrames/DataSets", deduplicateWithinWatermark);
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasEventTimeCol$1(Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            return attributeReference.metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkStreamingQueryGlobalWatermarkLimit$2(LogicalPlan subPlan$1, OutputMode outputMode$1, LogicalPlan p) {
        return p != subPlan$1 && MODULE$.ifCannotBeFollowedByStatefulOperation(p, outputMode$1);
    }

    public static final /* synthetic */ void $anonfun$checkStreamingQueryGlobalWatermarkLimit$1(OutputMode outputMode$1, LogicalPlan plan$1, LogicalPlan subPlan) {
        if (MODULE$.isStatefulOperation(subPlan)) {
            subPlan.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkStreamingQueryGlobalWatermarkLimit$2(subPlan, outputMode$1, p))).foreach((Function1 & Serializable)x$1 -> {
                String errorMsg = "Detected pattern of possible 'correctness' issue due to global watermark. The query contains stateful operation which can emit rows older than the current watermark plus allowed late record delay, which are \"late rows\" in downstream stateful operations and these rows can be discarded. Please refer the programming guide doc for more details. If you understand the possible risk of correctness issue and still need to run the query, you can disable this check by setting the config `spark.sql.streaming.statefulOperator.checkCorrectness.enabled` to false.";
                return MODULE$.throwError(errorMsg, plan$1);
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkSupportedStoreEncodingFormats$1(LogicalPlan plan$2, LogicalPlan subPlan) {
        Option<String> operatorOpt = MODULE$.checkAvroSupportForStatefulOperator(subPlan);
        if (operatorOpt.isDefined()) {
            String errorMsg = "State store encoding format as avro is not supported for operator=" + operatorOpt.get() + " used within the query";
            throw MODULE$.throwError(errorMsg, plan$2);
        }
    }

    private static final Seq collectStreamingAggregates$1(LogicalPlan subplan) {
        return subplan.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Distinct distinct;
                LogicalPlan c;
                Aggregate aggregate;
                A1 A1 = x1;
                if (A1 instanceof Aggregate && (aggregate = (Aggregate)A1).isStreaming()) {
                    return (B1)aggregate;
                }
                if (A1 instanceof Distinct && (c = (distinct = (Distinct)A1).child()) != null) {
                    LogicalPlan logicalPlan = c;
                    if (distinct.isStreaming()) {
                        return (B1)new Aggregate(logicalPlan.output(), logicalPlan.output(), logicalPlan, Aggregate$.MODULE$.apply$default$4());
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Distinct distinct;
                LogicalPlan c;
                Aggregate aggregate;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming()) {
                    return true;
                }
                return logicalPlan instanceof Distinct && (c = (distinct = (Distinct)logicalPlan).child()) != null && distinct.isStreaming();
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkForStreaming$1(FlatMapGroupsWithState x$2) {
        OutputMode outputMode = x$2.outputMode();
        InternalOutputModes.Append$ append$ = InternalOutputModes.Append$.MODULE$;
        return outputMode == null ? append$ != null : !outputMode.equals(append$);
    }

    public static final /* synthetic */ boolean $anonfun$checkForStreaming$2(Expression x0$1) {
        AttributeReference attributeReference;
        Expression expression = x0$1;
        return expression instanceof AttributeReference && (attributeReference = (AttributeReference)expression).metadata().contains(SessionWindow$.MODULE$.marker()) && attributeReference.metadata().getBoolean(SessionWindow$.MODULE$.marker());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean containsCompleteData$1(LogicalPlan subplan, OutputMode outputMode$2) {
        Seq aggs = subplan.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Aggregate aggregate;
                A1 A1 = x1;
                if (A1 instanceof Aggregate && (aggregate = (Aggregate)A1).isStreaming()) {
                    return (B1)aggregate;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Aggregate aggregate;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming();
            }
        });
        if (!subplan.isStreaming()) return true;
        if (!aggs.nonEmpty()) return false;
        OutputMode outputMode = outputMode$2;
        InternalOutputModes.Complete$ complete$ = InternalOutputModes.Complete$.MODULE$;
        if (outputMode != null) {
            if (!outputMode.equals(complete$)) return false;
            return true;
        }
        if (complete$ == null) return true;
        return false;
    }

    private final void checkUnsupportedExpressions$1(LogicalPlan operator) {
        Seq unsupportedExprs = (Seq)((SeqOps)operator.expressions().flatMap((Function1 & Serializable)x$3 -> x$3.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MonotonicallyIncreasingID) {
                    MonotonicallyIncreasingID monotonicallyIncreasingID = (MonotonicallyIncreasingID)A1;
                    return (B1)monotonicallyIncreasingID;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof MonotonicallyIncreasingID;
            }
        }))).distinct();
        if (unsupportedExprs.nonEmpty()) {
            throw this.throwError("Expression(s): " + ((IterableOnceOps)unsupportedExprs.map((Function1 & Serializable)x$4 -> x$4.sql())).mkString(", ") + " is not supported with streaming DataFrames/Datasets", operator);
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkForStreaming$7(Expression x$5) {
        return x$5 instanceof GroupingSets;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$checkForStreaming$5(UnsupportedOperationChecker$ $this, LogicalPlan plan$3, OutputMode outputMode$2, LogicalPlan subPlan) {
        LogicalPlan logicalPlan = subPlan;
        if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            Seq<Expression> groupingExpressions = aggregate.groupingExpressions();
            Seq<NamedExpression> aggregateExpressions = aggregate.aggregateExpressions();
            LogicalPlan child = aggregate.child();
            Seq distinctAggExprs = (Seq)aggregateExpressions.flatMap((Function1 & Serializable)expr -> ((TreeNode)((Object)expr)).collect(new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    AggregateExpression aggregateExpression;
                    A1 A1 = x5;
                    if (A1 instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)A1).isDistinct()) {
                        return (B1)aggregateExpression;
                    }
                    return (B1)function1.apply(x5);
                }

                public final boolean isDefinedAt(Expression x5) {
                    AggregateExpression aggregateExpression;
                    Expression expression = x5;
                    return expression instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)expression).isDistinct();
                }
            }));
            boolean haveGroupingSets = groupingExpressions.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkForStreaming$7(x$5)));
            MODULE$.throwErrorIf(child.isStreaming() && distinctAggExprs.nonEmpty(), "Distinct aggregations are not supported on streaming DataFrames/Datasets. Consider using approx_count_distinct() instead.", subPlan);
            MODULE$.throwErrorIf(child.isStreaming() && haveGroupingSets, "Grouping Sets is not supported on streaming DataFrames/Datasets", subPlan);
        } else {
            DeduplicateWithinWatermark deduplicateWithinWatermark;
            FlatMapGroupsInPandasWithState flatMapGroupsInPandasWithState;
            FlatMapGroupsWithState flatMapGroupsWithState;
            if (logicalPlan instanceof Command) {
                throw MODULE$.throwError("Commands like CreateTable*, AlterTable*, Show* are not supported with streaming DataFrames/Datasets", subPlan);
            }
            if (logicalPlan instanceof InsertIntoDir) {
                throw MODULE$.throwError("InsertIntoDir is not supported with streaming DataFrames/Datasets", subPlan);
            }
            if (logicalPlan instanceof FlatMapGroupsWithState && (flatMapGroupsWithState = (FlatMapGroupsWithState)logicalPlan).isStreaming()) {
                Seq aggsInQuery = UnsupportedOperationChecker$.collectStreamingAggregates$1(plan$3);
                if (flatMapGroupsWithState.initialState().isStreaming()) {
                    throw MODULE$.throwError("Non-streaming DataFrame/Dataset is not supported as the initial state in [flatMap|map]GroupsWithState operation on a streaming DataFrame/Dataset", subPlan);
                }
                if (flatMapGroupsWithState.isMapGroupsWithState()) {
                    OutputMode outputMode = outputMode$2;
                    InternalOutputModes.Update$ update$ = InternalOutputModes.Update$.MODULE$;
                    if (outputMode == null ? update$ != null : !outputMode.equals(update$)) {
                        throw MODULE$.throwError("mapGroupsWithState is not supported with " + outputMode$2 + " output mode on a streaming DataFrame/Dataset", subPlan);
                    }
                } else if (aggsInQuery.isEmpty()) {
                    OutputMode outputMode = flatMapGroupsWithState.outputMode();
                    if (InternalOutputModes.Update$.MODULE$.equals(outputMode)) {
                        OutputMode outputMode2 = outputMode$2;
                        InternalOutputModes.Update$ update$ = InternalOutputModes.Update$.MODULE$;
                        if (outputMode2 == null ? update$ != null : !outputMode2.equals(update$)) {
                            throw MODULE$.throwError("flatMapGroupsWithState in update mode is not supported with " + outputMode$2 + " output mode on a streaming DataFrame/Dataset", subPlan);
                        }
                    }
                    if (InternalOutputModes.Append$.MODULE$.equals(outputMode)) {
                        OutputMode outputMode3 = outputMode$2;
                        InternalOutputModes.Append$ append$ = InternalOutputModes.Append$.MODULE$;
                        if (outputMode3 == null ? append$ != null : !outputMode3.equals(append$)) {
                            throw MODULE$.throwError("flatMapGroupsWithState in append mode is not supported with " + outputMode$2 + " output mode on a streaming DataFrame/Dataset", subPlan);
                        }
                    }
                } else {
                    OutputMode outputMode = flatMapGroupsWithState.outputMode();
                    InternalOutputModes.Update$ update$ = InternalOutputModes.Update$.MODULE$;
                    if (!(outputMode != null ? !outputMode.equals(update$) : update$ != null)) {
                        throw MODULE$.throwError("flatMapGroupsWithState in update mode is not supported with aggregation on a streaming DataFrame/Dataset", subPlan);
                    }
                }
                GroupStateTimeout groupStateTimeout = flatMapGroupsWithState.timeout();
                EventTimeTimeout$ eventTimeTimeout$ = EventTimeTimeout$.MODULE$;
                if (!(groupStateTimeout != null ? !groupStateTimeout.equals(eventTimeTimeout$) : eventTimeTimeout$ != null)) {
                    Seq watermarkAttributes = (Seq)flatMapGroupsWithState.child().output().collect((PartialFunction)new Serializable(){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                            A1 A1;
                            A1 A12 = x6;
                            if (A12 != null && (A1 = A12).metadata().contains(EventTimeWatermark$.MODULE$.delayKey())) {
                                return (B1)A1;
                            }
                            return (B1)function1.apply(x6);
                        }

                        public final boolean isDefinedAt(Attribute x6) {
                            Attribute attribute;
                            Attribute attribute2 = x6;
                            return attribute2 != null && (attribute = attribute2).metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
                        }
                    });
                    if (watermarkAttributes.isEmpty()) {
                        throw MODULE$.throwError("Watermark must be specified in the query using '[Dataset/DataFrame].withWatermark()' for using event-time timeout in a [map|flatMap]GroupsWithState. Event-time timeout not supported without watermark.", plan$3);
                    }
                }
            } else if (logicalPlan instanceof FlatMapGroupsInPandasWithState && (flatMapGroupsInPandasWithState = (FlatMapGroupsInPandasWithState)logicalPlan).isStreaming()) {
                Seq aggsInQuery = UnsupportedOperationChecker$.collectStreamingAggregates$1(plan$3);
                if (aggsInQuery.isEmpty()) {
                    OutputMode outputMode = flatMapGroupsInPandasWithState.outputMode();
                    if (InternalOutputModes.Update$.MODULE$.equals(outputMode)) {
                        OutputMode outputMode4 = outputMode$2;
                        InternalOutputModes.Update$ update$ = InternalOutputModes.Update$.MODULE$;
                        if (outputMode4 == null ? update$ != null : !outputMode4.equals(update$)) {
                            throw MODULE$.throwError("applyInPandasWithState in update mode is not supported with " + outputMode$2 + " output mode on a streaming DataFrame/Dataset", subPlan);
                        }
                    }
                    if (InternalOutputModes.Append$.MODULE$.equals(outputMode)) {
                        OutputMode outputMode5 = outputMode$2;
                        InternalOutputModes.Append$ append$ = InternalOutputModes.Append$.MODULE$;
                        if (outputMode5 == null ? append$ != null : !outputMode5.equals(append$)) {
                            throw MODULE$.throwError("applyInPandasWithState in append mode is not supported with " + outputMode$2 + " output mode on a streaming DataFrame/Dataset", subPlan);
                        }
                    }
                } else {
                    OutputMode outputMode = flatMapGroupsInPandasWithState.outputMode();
                    InternalOutputModes.Update$ update$ = InternalOutputModes.Update$.MODULE$;
                    if (!(outputMode != null ? !outputMode.equals(update$) : update$ != null)) {
                        throw MODULE$.throwError("applyInPandasWithState in update mode is not supported with aggregation on a streaming DataFrame/Dataset", subPlan);
                    }
                    if (UnsupportedOperationChecker$.collectStreamingAggregates$1(flatMapGroupsInPandasWithState).nonEmpty()) {
                        throw MODULE$.throwError("applyInPandasWithState in append mode is not supported after aggregation on a streaming DataFrame/Dataset", subPlan);
                    }
                }
                GroupStateTimeout groupStateTimeout = flatMapGroupsInPandasWithState.timeout();
                EventTimeTimeout$ eventTimeTimeout$ = EventTimeTimeout$.MODULE$;
                if (!(groupStateTimeout != null ? !groupStateTimeout.equals(eventTimeTimeout$) : eventTimeTimeout$ != null)) {
                    Seq watermarkAttributes = (Seq)flatMapGroupsInPandasWithState.child().output().collect((PartialFunction)new Serializable(){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                            A1 A1;
                            A1 A12 = x7;
                            if (A12 != null && (A1 = A12).metadata().contains(EventTimeWatermark$.MODULE$.delayKey())) {
                                return (B1)A1;
                            }
                            return (B1)function1.apply(x7);
                        }

                        public final boolean isDefinedAt(Attribute x7) {
                            Attribute attribute;
                            Attribute attribute2 = x7;
                            return attribute2 != null && (attribute = attribute2).metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
                        }
                    });
                    if (watermarkAttributes.isEmpty()) {
                        throw MODULE$.throwError("Watermark must be specified in the query using '[Dataset/DataFrame].withWatermark()' for using event-time timeout in a applyInPandasWithState. Event-time timeout not supported without watermark.", plan$3);
                    }
                }
            } else if (logicalPlan instanceof Join) {
                JoinType joinType;
                Join join = (Join)logicalPlan;
                LogicalPlan left = join.left();
                LogicalPlan right = join.right();
                JoinType joinType2 = join.joinType();
                if (left.isStreaming() && right.isStreaming()) {
                    OutputMode outputMode = outputMode$2;
                    InternalOutputModes.Append$ append$ = InternalOutputModes.Append$.MODULE$;
                    if (outputMode == null ? append$ != null : !outputMode.equals(append$)) {
                        throw MODULE$.throwError("Join between two streaming DataFrames/Datasets is not supported in " + outputMode$2 + " output mode, only in Append output mode", subPlan);
                    }
                }
                if ((joinType = joinType2) instanceof InnerLike) {
                } else if (FullOuter$.MODULE$.equals(joinType)) {
                    if (left.isStreaming() && !right.isStreaming()) {
                        throw MODULE$.throwError("FullOuter joins with streaming DataFrames/Datasets on the left and a static DataFrame/Dataset on the right is not supported", subPlan);
                    }
                    if (!left.isStreaming() && right.isStreaming()) {
                        throw MODULE$.throwError("FullOuter joins with streaming DataFrames/Datasets on the right and a static DataFrame/Dataset on the left is not supported", subPlan);
                    }
                    if (left.isStreaming() && right.isStreaming()) {
                        MODULE$.checkForStreamStreamJoinWatermark(join);
                    }
                } else if (LeftAnti$.MODULE$.equals(joinType)) {
                    if (right.isStreaming()) {
                        throw MODULE$.throwError(LeftAnti$.MODULE$ + " joins with a streaming DataFrame/Dataset on the right are not supported", subPlan);
                    }
                } else if (LeftOuter$.MODULE$.equals(joinType) ? true : LeftSemi$.MODULE$.equals(joinType)) {
                    if (!left.isStreaming() && right.isStreaming()) {
                        throw MODULE$.throwError(joinType2 + " join with a streaming DataFrame/Dataset on the right and a static DataFrame/Dataset on the left is not supported", subPlan);
                    }
                    if (left.isStreaming() && right.isStreaming()) {
                        MODULE$.checkForStreamStreamJoinWatermark(join);
                    }
                } else if (RightOuter$.MODULE$.equals(joinType)) {
                    if (left.isStreaming() && !right.isStreaming()) {
                        throw MODULE$.throwError("RightOuter join with a streaming DataFrame/Dataset on the left and a static DataFrame/DataSet on the right not supported", subPlan);
                    }
                    if (left.isStreaming() && right.isStreaming()) {
                        MODULE$.checkForStreamStreamJoinWatermark(join);
                    }
                } else if (!(joinType instanceof NaturalJoin ? true : joinType instanceof UsingJoin)) throw MODULE$.throwError("Join type " + joinType2 + " is not supported with streaming DataFrame/Dataset", subPlan);
            } else if (logicalPlan instanceof DeduplicateWithinWatermark && (deduplicateWithinWatermark = (DeduplicateWithinWatermark)logicalPlan).isStreaming()) {
                Seq watermarkAttributes = (Seq)deduplicateWithinWatermark.child().output().collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Attribute, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                        A1 A1;
                        A1 A12 = x8;
                        if (A12 != null && (A1 = A12).metadata().contains(EventTimeWatermark$.MODULE$.delayKey())) {
                            return (B1)A1;
                        }
                        return (B1)function1.apply(x8);
                    }

                    public final boolean isDefinedAt(Attribute x8) {
                        Attribute attribute;
                        Attribute attribute2 = x8;
                        return attribute2 != null && (attribute = attribute2).metadata().contains(EventTimeWatermark$.MODULE$.delayKey());
                    }
                });
                if (watermarkAttributes.isEmpty()) {
                    throw MODULE$.throwError("dropDuplicatesWithinWatermark is not supported on streaming DataFrames/DataSets without watermark", plan$3);
                }
            } else {
                ReturnAnswer returnAnswer;
                LogicalPlan child;
                Sample sample;
                LogicalPlan child2;
                Except except;
                LogicalPlan right;
                Union union;
                CoGroup coGroup;
                if (logicalPlan instanceof CoGroup && (coGroup = (CoGroup)logicalPlan).children().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isStreaming()))) {
                    throw MODULE$.throwError("CoGrouping with a streaming DataFrame/Dataset is not supported", subPlan);
                }
                if (logicalPlan instanceof Union && ((SeqOps)((SeqOps)(union = (Union)logicalPlan).children().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isStreaming()))).distinct()).size() == 2) {
                    throw MODULE$.throwError("Union between streaming and batch DataFrames/Datasets is not supported", subPlan);
                }
                if (logicalPlan instanceof Except && (right = (except = (Except)logicalPlan).right()).isStreaming()) {
                    throw MODULE$.throwError("Except on a streaming DataFrame/Dataset on the right is not supported", subPlan);
                }
                if (logicalPlan instanceof Intersect) {
                    Intersect intersect = (Intersect)logicalPlan;
                    LogicalPlan left = intersect.left();
                    LogicalPlan right2 = intersect.right();
                    if (left.isStreaming() || right2.isStreaming()) {
                        throw MODULE$.throwError("Intersect of streaming DataFrames/Datasets is not supported", subPlan);
                    }
                }
                if ((logicalPlan instanceof GlobalLimit ? true : logicalPlan instanceof LocalLimit) && subPlan.children().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isStreaming()))) {
                    OutputMode outputMode = outputMode$2;
                    InternalOutputModes.Update$ update$ = InternalOutputModes.Update$.MODULE$;
                    if (!(outputMode != null ? !outputMode.equals(update$) : update$ != null)) {
                        throw MODULE$.throwError("Limits are not supported on streaming DataFrames/Datasets in Update output mode", subPlan);
                    }
                }
                if (logicalPlan instanceof Offset) {
                    throw MODULE$.throwError("Offset is not supported on streaming DataFrames/Datasets", subPlan);
                }
                if (logicalPlan instanceof Sort && !UnsupportedOperationChecker$.containsCompleteData$1(subPlan, outputMode$2)) {
                    throw MODULE$.throwError("Sorting is not supported on streaming DataFrames/Datasets, unless it is on aggregated DataFrame/Dataset in Complete output mode", subPlan);
                }
                if (logicalPlan instanceof Sample && (child2 = (sample = (Sample)logicalPlan).child()).isStreaming()) {
                    throw MODULE$.throwError("Sampling is not supported on streaming DataFrames/Datasets", subPlan);
                }
                if (logicalPlan instanceof Window) {
                    Window window = (Window)logicalPlan;
                    Seq<NamedExpression> windowExpression = window.windowExpressions();
                    LogicalPlan child3 = window.child();
                    if (child3.isStreaming()) {
                        Tuple3 tuple3 = ((IterableOps)windowExpression.flatMap((Function1 & Serializable)e -> ((TreeNode)((Object)e)).collect(new Serializable((NamedExpression)e){
                            private static final long serialVersionUID = 0L;
                            private final NamedExpression e$1;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                                A1 A1 = x9;
                                if (A1 instanceof WindowExpression) {
                                    WindowExpression windowExpression = (WindowExpression)A1;
                                    return (B1)new Tuple3((Object)windowExpression.windowFunction().toString(), (Object)this.e$1.toAttribute().sql(), (Object)windowExpression.windowSpec().sql());
                                }
                                return (B1)function1.apply(x9);
                            }

                            public final boolean isDefinedAt(Expression x9) {
                                Expression expression = x9;
                                return expression instanceof WindowExpression;
                            }
                            {
                                this.e$1 = e$1;
                            }
                        }))).unzip3(Predef$.MODULE$.$conforms());
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        Seq windowFuncList = (Seq)tuple3._1();
                        Seq columnNameList = (Seq)tuple3._2();
                        Seq windowSpecList = (Seq)tuple3._3();
                        Tuple3 tuple32 = new Tuple3((Object)windowFuncList, (Object)columnNameList, (Object)windowSpecList);
                        Seq windowFuncList2 = (Seq)tuple32._1();
                        Seq columnNameList2 = (Seq)tuple32._2();
                        Seq windowSpecList2 = (Seq)tuple32._3();
                        throw QueryExecutionErrors$.MODULE$.nonTimeWindowNotSupportedInStreamingError((Seq<String>)windowFuncList2, (Seq<String>)columnNameList2, (Seq<String>)windowSpecList2, subPlan.origin());
                    }
                }
                if (logicalPlan instanceof ReturnAnswer && (child = (returnAnswer = (ReturnAnswer)logicalPlan).child()).isStreaming()) {
                    throw MODULE$.throwError("Cannot return immediate result on streaming DataFrames/Dataset. Queries with streaming DataFrames/Datasets must be executed with writeStream.start().", subPlan);
                }
            }
        }
        $this.checkUnsupportedExpressions$1(subPlan);
    }

    public static final /* synthetic */ boolean $anonfun$checkForContinuous$3(Expression x0$1) {
        Expression expression = x0$1;
        return expression instanceof CurrentTimestampLike ? true : (expression instanceof CurrentDate ? true : expression instanceof LocalTimestamp);
    }

    public static final /* synthetic */ void $anonfun$checkForContinuous$2(LogicalPlan subPlan$2, Expression e) {
        if (e.collectLeaves().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UnsupportedOperationChecker$.$anonfun$checkForContinuous$3(x0$1)))) {
            throw MODULE$.throwError("Continuous processing does not support current time operations.", subPlan$2);
        }
    }

    public static final /* synthetic */ void $anonfun$checkForContinuous$1(LogicalPlan subPlan) {
        View view;
        LogicalPlan logicalPlan = subPlan;
        if (logicalPlan instanceof Project ? true : (logicalPlan instanceof Filter ? true : (logicalPlan instanceof MapElements ? true : (logicalPlan instanceof MapPartitions ? true : (logicalPlan instanceof DeserializeToObject ? true : (logicalPlan instanceof SerializeFromObject ? true : (logicalPlan instanceof SubqueryAlias ? true : logicalPlan instanceof TypedFilter))))))) {
        } else if (logicalPlan instanceof View && (view = (View)logicalPlan).isTempViewStoringAnalyzedPlan()) {
        } else {
            String string = logicalPlan.nodeName();
            String string2 = "StreamingRelationV2";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
            } else {
                throw MODULE$.throwError("Continuous processing does not support " + logicalPlan.nodeName() + " operations.", subPlan);
            }
        }
        subPlan.expressions().foreach((Function1 & Serializable)e -> {
            UnsupportedOperationChecker$.$anonfun$checkForContinuous$2(subPlan, e);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkForStreamStreamJoinWatermark$1(Join join$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            AttributeSet attributesToFindStateWatermarkFor = (AttributeSet)tuple2._1();
            AttributeSet attributesWithEventWatermark = (AttributeSet)tuple2._2();
            return StreamingJoinHelper$.MODULE$.getStateValueWatermark(attributesToFindStateWatermarkFor, attributesWithEventWatermark, join$1.condition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1000000L))).isDefined();
        }
        throw new MatchError((Object)tuple2);
    }

    private UnsupportedOperationChecker$() {
    }
}

