/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeDate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(year, month, day) - Create date from year, month and day fields. If the configuration `spark.sql.ansi.enabled` is false, the function returns NULL on invalid inputs. Otherwise, it will throw an error instead.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2013, 7, 15);\n       2013-07-15\n      > SELECT _FUNC_(2019, 7, NULL);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001B\u0016-\u0001fB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011!Y\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B+\t\u0011u\u0003!Q3A\u0005\u0002yC\u0001B\u0019\u0001\u0003\u0012\u0003\u0006Ia\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006U\u0002!\tE\u0018\u0005\u0006G\u0002!\ta\u001b\u0005\u0006_\u0002!\t\u0005\u0016\u0005\u0006a\u0002!\t\u0005\u0016\u0005\u0006c\u0002!\t\u0005\u0016\u0005\u0006e\u0002!\te\u001d\u0005\u0006{\u0002!\tE \u0005\u0007\u0003\u000b\u0001A\u0011\t0\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0005\b\u0003\u0013\u0002A\u0011KA&\u0011%\tI\u0006AA\u0001\n\u0003\tY\u0006C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002h!I\u0011Q\u0010\u0001\u0012\u0002\u0013\u0005\u0011q\r\u0005\n\u0003\u007f\u0002\u0011\u0013!C\u0001\u0003OB\u0011\"!!\u0001#\u0003%\t!a!\t\u0013\u0005\u001d\u0005!!A\u0005B\u0005%\u0005\"CAM\u0001\u0005\u0005I\u0011AAN\u0011%\t\u0019\u000bAA\u0001\n\u0003\t)\u000bC\u0005\u0002,\u0002\t\t\u0011\"\u0011\u0002.\"I\u00111\u0018\u0001\u0002\u0002\u0013\u0005\u0011Q\u0018\u0005\n\u0003\u0003\u0004\u0011\u0011!C!\u0003\u0007D\u0011\"a2\u0001\u0003\u0003%\t%!3\b\u0013\u0005MH&!A\t\u0002\u0005Uh\u0001C\u0016-\u0003\u0003E\t!a>\t\r\r\u001cC\u0011\u0001B\b\u0011%\u0011\tbIA\u0001\n\u000b\u0012\u0019\u0002C\u0005\u0003\u0016\r\n\t\u0011\"!\u0003\u0018!I!\u0011E\u0012\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u0005G\u0019\u0013\u0011!CA\u0005KA\u0011Ba\u000e$#\u0003%\t!a!\t\u0013\te2%!A\u0005\n\tm\"\u0001C'bW\u0016$\u0015\r^3\u000b\u00055r\u0013aC3yaJ,7o]5p]NT!a\f\u0019\u0002\u0011\r\fG/\u00197zgRT!!\r\u001a\u0002\u0007M\fHN\u0003\u00024i\u0005)1\u000f]1sW*\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u001e?\u0003\u001e\u0003\"a\u000f\u001f\u000e\u00031J!!\u0010\u0017\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002<\u007f%\u0011\u0001\t\f\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n9\u0001K]8ek\u000e$\bC\u0001%Q\u001d\tIeJ\u0004\u0002K\u001b6\t1J\u0003\u0002Mq\u00051AH]8pizJ\u0011\u0001R\u0005\u0003\u001f\u000e\u000bq\u0001]1dW\u0006<W-\u0003\u0002R%\na1+\u001a:jC2L'0\u00192mK*\u0011qjQ\u0001\u0005s\u0016\f'/F\u0001V!\tYd+\u0003\u0002XY\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000be,\u0017M\u001d\u0011\u0002\u000b5|g\u000e\u001e5\u0002\r5|g\u000e\u001e5!\u0003\r!\u0017-_\u0001\u0005I\u0006L\b%A\u0006gC&dwJ\\#se>\u0014X#A0\u0011\u0005\t\u0003\u0017BA1D\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtD#B3gO\"L\u0007CA\u001e\u0001\u0011\u0015\u0019\u0016\u00021\u0001V\u0011\u0015I\u0016\u00021\u0001V\u0011\u0015Y\u0016\u00021\u0001V\u0011\u001di\u0016\u0002%AA\u0002}\u000baB\\;mY&sGo\u001c7fe\u0006tG\u000f\u0006\u0003fY6t\u0007\"B*\f\u0001\u0004)\u0006\"B-\f\u0001\u0004)\u0006\"B.\f\u0001\u0004)\u0016!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u001e\t\u0004\u0011V<\u0018B\u0001<S\u0005\r\u0019V-\u001d\t\u0003qnl\u0011!\u001f\u0006\u0003uB\nQ\u0001^=qKNL!\u0001`=\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003}\u00042\u0001_A\u0001\u0013\r\t\u0019!\u001f\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u0002\f\u0005E\u00111CA\u000b!\r\u0011\u0015QB\u0005\u0004\u0003\u001f\u0019%aA!os\"11K\u0005a\u0001\u0003\u0017Aa!\u0017\nA\u0002\u0005-\u0001BB.\u0013\u0001\u0004\tY!A\u0005e_\u001e+gnQ8eKR1\u00111DA\u0014\u0003c\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003Ca\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003K\tyB\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tIc\u0005a\u0001\u0003W\t1a\u0019;y!\u0011\ti\"!\f\n\t\u0005=\u0012q\u0004\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\u0019d\u0005a\u0001\u00037\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002:A!\u00111HA\"\u001d\u0011\ti$a\u0010\u0011\u0005)\u001b\u0015bAA!\u0007\u00061\u0001K]3eK\u001aLA!!\u0012\u0002H\t11\u000b\u001e:j]\u001eT1!!\u0011D\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0004f\u0003\u001b\n\t&!\u0016\t\r\u0005=S\u00031\u0001V\u0003!qWm\u001e$jeN$\bBBA*+\u0001\u0007Q+A\u0005oK^\u001cVmY8oI\"1\u0011qK\u000bA\u0002U\u000b\u0001B\\3x)\"L'\u000fZ\u0001\u0005G>\u0004\u0018\u0010F\u0005f\u0003;\ny&!\u0019\u0002d!91K\u0006I\u0001\u0002\u0004)\u0006bB-\u0017!\u0003\u0005\r!\u0016\u0005\b7Z\u0001\n\u00111\u0001V\u0011\u001dif\u0003%AA\u0002}\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002j)\u001aQ+a\u001b,\u0005\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001eD\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\n\tHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0011\u0016\u0004?\u0006-\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\fB!\u0011QRAL\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015\u0001\u00027b]\u001eT!!!&\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\ny)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u001eB\u0019!)a(\n\u0007\u0005\u00056IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\f\u0005\u001d\u0006\"CAU;\u0005\u0005\t\u0019AAO\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0016\t\u0007\u0003c\u000b9,a\u0003\u000e\u0005\u0005M&bAA[\u0007\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00161\u0017\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002`\u0003\u007fC\u0011\"!+ \u0003\u0003\u0005\r!a\u0003\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0017\u000b)\rC\u0005\u0002*\u0002\n\t\u00111\u0001\u0002\u001e\u00061Q-];bYN$2aXAf\u0011%\tI+IA\u0001\u0002\u0004\tY\u0001K\f\u0001\u0003\u001f\f).a6\u0002\\\u0006u\u0017\u0011]Ar\u0003O\fI/!<\u0002pB\u00191(!5\n\u0007\u0005MGFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005e\u0017!a,`\rVs5i\u0018\u0015zK\u0006\u0014H\u0006I7p]RDG\u0006\t3bs&\u0002S\u0006I\"sK\u0006$X\r\t3bi\u0016\u0004cM]8nAe,\u0017M\u001d\u0017![>tG\u000f\u001b\u0011b]\u0012\u0004C-Y=!M&,G\u000eZ:/A%3\u0007\u0005\u001e5fA\r|gNZ5hkJ\fG/[8oA\u0001\u001c\b/\u0019:l]M\fHNL1og&tSM\\1cY\u0016$\u0007\rI5tA\u0019\fGn]3-AQDW\r\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9+F\n\u0014\u0011p]\u0002JgN^1mS\u0012\u0004\u0013N\u001c9viNt\u0003e\u0014;iKJ<\u0018n]3-A%$\be^5mY\u0002\"\bN]8xA\u0005t\u0007%\u001a:s_J\u0004\u0013N\\:uK\u0006$g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011q\\\u0001\u0002(*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%_3be\u0002j\u0003\u0005\u001e5fAe,\u0017M\u001d\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007%\r\u0011u_\u0002J\u0014(O\u001d\u000bA\u0001\u0002\u0003\u0005\t\u0011+A5|g\u000e\u001e5![\u0001\"\b.\u001a\u0011n_:$\b.L8g[e,\u0017M\u001d\u0011u_\u0002\u0012X\r\u001d:fg\u0016tG\u000f\f\u0011ge>l\u0007%\r\u0011)\u0015\u0006tW/\u0019:zS\u0001\"x\u000eI\u00193A!\"UmY3nE\u0016\u0014\u0018F\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011eCf\u0004S\u0006\t;iK\u0002\"\u0017-_\u0017pM6jwN\u001c;iAQ|\u0007E]3qe\u0016\u001cXM\u001c;-A\u0019\u0014x.\u001c\u00112AQ|\u0007eM\u0019\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003K\f\u0011P\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aE\u001aD\u0006I\u001c-AE*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\u001aT\u0006M\u001c.cUR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002s\u0007\f\u0011O+2c\u0015f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005-\u0018A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003c\fQa\r\u00181]A\n\u0001\"T1lK\u0012\u000bG/\u001a\t\u0003w\r\u001aRaIA}\u0005\u000b\u0001\u0012\"a?\u0003\u0002U+VkX3\u000e\u0005\u0005u(bAA\u0000\u0007\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u0002\u0003{\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\u00119A!\u0004\u000e\u0005\t%!\u0002\u0002B\u0006\u0003'\u000b!![8\n\u0007E\u0013I\u0001\u0006\u0002\u0002v\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\f\u0006)\u0011\r\u001d9msRIQM!\u0007\u0003\u001c\tu!q\u0004\u0005\u0006'\u001a\u0002\r!\u0016\u0005\u00063\u001a\u0002\r!\u0016\u0005\u00067\u001a\u0002\r!\u0016\u0005\b;\u001a\u0002\n\u00111\u0001`\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005O\u0011\u0019\u0004E\u0003C\u0005S\u0011i#C\u0002\u0003,\r\u0013aa\u00149uS>t\u0007c\u0002\"\u00030U+VkX\u0005\u0004\u0005c\u0019%A\u0002+va2,G\u0007\u0003\u0005\u00036!\n\t\u00111\u0001f\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tu\u0002\u0003BAG\u0005\u007fIAA!\u0011\u0002\u0010\n1qJ\u00196fGR\u0004")
public class MakeDate
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return MakeDate$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(MakeDate x$0) {
        return MakeDate$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return MakeDate$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, MakeDate> tupled() {
        return MakeDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, MakeDate>>>> curried() {
        return MakeDate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression first() {
        return this.year();
    }

    @Override
    public Expression second() {
        return this.month();
    }

    @Override
    public Expression third() {
        return this.day();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        if (this.failOnError()) {
            return this.children().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.nullable()));
        }
        return true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day) {
        Integer n;
        try {
            LocalDate ld = LocalDate.of(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day));
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(ld));
        }
        catch (DateTimeException e) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.ansiDateTimeArgumentOutOfRange(e);
            }
            n = null;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String failOnErrorBranch = this.failOnError() ? "throw QueryExecutionErrors.ansiDateTimeArgumentOutOfRange(e);" : ev.isNull() + " = true;";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(year, month, day) -> "\n      try {\n        " + ev.value() + " = " + dtu + ".localDateToDays(java.time.LocalDate.of(" + year + ", " + month + ", " + day + "));\n      } catch (java.time.DateTimeException e) {\n        " + failOnErrorBranch + "\n      }");
    }

    @Override
    public String prettyName() {
        return "make_date";
    }

    @Override
    public MakeDate withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public MakeDate copy(Expression year, Expression month, Expression day, boolean failOnError) {
        return new MakeDate(year, month, day, failOnError);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeDate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.year();
            }
            case 1: {
                return this.month();
            }
            case 2: {
                return this.day();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeDate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "year";
            }
            case 1: {
                return "month";
            }
            case 2: {
                return "day";
            }
            case 3: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeDate makeDate = (MakeDate)x$1;
        if (this.failOnError() != makeDate.failOnError()) return false;
        Expression expression = this.year();
        Expression expression2 = makeDate.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeDate.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeDate.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!makeDate.canEqual(this)) return false;
        return true;
    }

    public MakeDate(Expression year, Expression month, Expression day, boolean failOnError) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public MakeDate(Expression year, Expression month, Expression day) {
        this(year, month, day, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

