/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FoldableUnevaluable;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.TimeWindow$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(time_column, window_duration[, slide_duration[, start_time]]) - Bucketize rows into one or more time windows given a timestamp specifying column.\n      Window starts are inclusive but the window ends are exclusive, e.g. 12:05 will be in the window [12:05,12:10) but not in [12:00,12:05).\n      Windows can support microsecond precision. Windows in the order of months are not supported.\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#window-operations-on-event-time\">'Window Operations on Event Time'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * time_column - The column or the expression to use as the timestamp for windowing by time. The time column must be of TimestampType.\n      * window_duration - A string specifying the width of the window represented as \"interval value\".\n        (See <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#interval-literal\">Interval Literal</a> for more details.)\n        Note that the duration is a fixed length of time, and does not vary over time according to a calendar.\n      * slide_duration - A string specifying the sliding interval of the window represented as \"interval value\".\n        A new window will be generated every `slide_duration`. Must be less than or equal to the `window_duration`.\n        This duration is likewise absolute, and does not vary according to a calendar.\n      * start_time - The offset with respect to 1970-01-01 00:00:00 UTC with which to start window intervals.\n        For example, in order to have hourly tumbling windows that start 15 minutes past the hour,\n        e.g. 12:15-13:15, 13:15-14:15... provide `start_time` as `15 minutes`.\n  ", examples="\n    Examples:\n      > SELECT a, window.start, window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:06:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '5 minutes') ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t2\n        A1\t2021-01-01 00:05:00\t2021-01-01 00:10:00\t1\n        A2\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t1\n      > SELECT a, window.start, window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:06:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '10 minutes', '5 minutes') ORDER BY a, start;\n        A1\t2020-12-31 23:55:00\t2021-01-01 00:05:00\t2\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:10:00\t3\n        A1\t2021-01-01 00:05:00\t2021-01-01 00:15:00\t1\n        A2\t2020-12-31 23:55:00\t2021-01-01 00:05:00\t1\n        A2\t2021-01-01 00:00:00\t2021-01-01 00:10:00\t1\n  ", group="datetime_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0005\tee\u0001\u0002\u00180\u0001rB\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tO\u0002\u0011\t\u0012)A\u0005I\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\tE\t\u0015!\u0003k\u0011!q\u0007A!f\u0001\n\u0003I\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00026\t\u0011A\u0004!Q3A\u0005\u0002%D\u0001\"\u001d\u0001\u0003\u0012\u0003\u0006IA\u001b\u0005\u0006e\u0002!\ta\u001d\u0005\u0006e\u0002!\t!\u001f\u0005\u0006e\u0002!\tA \u0005\u0007e\u0002!\t!!\u0002\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!1\u00111\u0004\u0001\u0005B\rDq!!\b\u0001\t\u0003\ny\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!I\u0011Q\t\u0001C\u0002\u0013\u0015\u0013q\t\u0005\t\u0003k\u0002\u0001\u0015!\u0004\u0002J!Q\u0011q\u000f\u0001\t\u0006\u0004%\t%!\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011\u0011\u0013\u0001\u0005R\u0005M\u0005\"CAM\u0001\u0005\u0005I\u0011AAN\u0011%\t)\u000bAI\u0001\n\u0003\t9\u000bC\u0005\u0002>\u0002\t\n\u0011\"\u0001\u0002@\"I\u00111\u0019\u0001\u0012\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003\u000b\u0004\u0011\u0013!C\u0001\u0003\u007fC\u0011\"a2\u0001\u0003\u0003%\t%!3\t\u0013\u0005e\u0007!!A\u0005\u0002\u0005m\u0007\"CAr\u0001\u0005\u0005I\u0011AAs\u0011%\t\t\u0010AA\u0001\n\u0003\n\u0019\u0010C\u0005\u0003\u0002\u0001\t\t\u0011\"\u0001\u0003\u0004!I!q\u0001\u0001\u0002\u0002\u0013\u0005#\u0011\u0002\u0005\n\u0005\u001b\u0001\u0011\u0011!C!\u0005\u001f9qA!\u000f0\u0011\u0003\u0011YD\u0002\u0004/_!\u0005!Q\b\u0005\u0007e\u0012\"\tAa\u0014\t\u0013\tECE1A\u0005\u0002\u0005%\u0007\u0002\u0003B*I\u0001\u0006I!a3\t\u000f\tUC\u0005\"\u0001\u0003X!9!Q\f\u0013\u0005\u0002\t}\u0003b\u0002B3I\u0011\u0005!q\r\u0005\n\u0005K\"\u0013\u0011!CA\u0005cB\u0011Ba\u001f%\u0003\u0003%\tI! \t\u0013\t=E%!A\u0005\n\tE%A\u0003+j[\u0016<\u0016N\u001c3po*\u0011\u0001'M\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00023g\u0005A1-\u0019;bYf\u001cHO\u0003\u00025k\u0005\u00191/\u001d7\u000b\u0005Y:\u0014!B:qCJ\\'B\u0001\u001d:\u0003\u0019\t\u0007/Y2iK*\t!(A\u0002pe\u001e\u001c\u0001a\u0005\u0005\u0001{\u0005#uI\u0013)W!\tqt(D\u00010\u0013\t\u0001uFA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tq$)\u0003\u0002D_\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002?\u000b&\u0011ai\f\u0002\f+:,g/\u00197vC\ndW\r\u0005\u0002?\u0011&\u0011\u0011j\f\u0002\u0011\u001d>t7+\u0015'FqB\u0014Xm]:j_:\u0004\"a\u0013(\u000e\u00031S!!T\u001a\u0002\r\u0015\u0014(o\u001c:t\u0013\tyEJA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f!\t\tF+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0005\u001d\u0001&o\u001c3vGR\u0004\"aV0\u000f\u0005akfBA-]\u001b\u0005Q&BA.<\u0003\u0019a$o\\8u}%\t1+\u0003\u0002_%\u00069\u0001/Y2lC\u001e,\u0017B\u00011b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tq&+\u0001\u0006uS6,7i\u001c7v[:,\u0012\u0001\u001a\t\u0003}\u0015L!AZ\u0018\u0003\u0015\u0015C\bO]3tg&|g.A\u0006uS6,7i\u001c7v[:\u0004\u0013AD<j]\u0012|w\u000fR;sCRLwN\\\u000b\u0002UB\u0011\u0011k[\u0005\u0003YJ\u0013A\u0001T8oO\u0006yq/\u001b8e_^$UO]1uS>t\u0007%A\u0007tY&$W\rR;sCRLwN\\\u0001\u000fg2LG-\u001a#ve\u0006$\u0018n\u001c8!\u0003%\u0019H/\u0019:u)&lW-\u0001\u0006ti\u0006\u0014H\u000fV5nK\u0002\na\u0001P5oSRtD#\u0002;vm^D\bC\u0001 \u0001\u0011\u0015\u0011\u0017\u00021\u0001e\u0011\u0015A\u0017\u00021\u0001k\u0011\u0015q\u0017\u00021\u0001k\u0011\u0015\u0001\u0018\u00021\u0001k)\u0015!(p\u001f?~\u0011\u0015\u0011'\u00021\u0001e\u0011\u0015A'\u00021\u0001e\u0011\u0015q'\u00021\u0001e\u0011\u0015\u0001(\u00021\u0001e)\u0019!x0!\u0001\u0002\u0004!)!m\u0003a\u0001I\")\u0001n\u0003a\u0001I\")an\u0003a\u0001IR)A/a\u0002\u0002\n!)!\r\u0004a\u0001I\")\u0001\u000e\u0004a\u0001I\u0006)\u0012N\u001c9viRK\b/Z(o)&lWmQ8mk6tWCAA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000bg\u0005)A/\u001f9fg&!\u0011\u0011DA\n\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\u0003dQ&dG-\u0001\u0006j]B,H\u000fV=qKN,\"!!\t\u0011\u000b]\u000b\u0019#a\u0004\n\u0007\u0005\u0015\u0012MA\u0002TKF\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003W\u0001B!!\u0005\u0002.%!\u0011qFA\n\u0005!!\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011Q\u0007\t\u0005\u0003o\tyD\u0004\u0003\u0002:\u0005m\u0002CA-S\u0013\r\tiDU\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00131\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\"+\u0001\u0007o_\u0012,\u0007+\u0019;uKJt7/\u0006\u0002\u0002JA)q+a\t\u0002LA!\u0011QJA8\u001d\u0011\ty%!\u001b\u000f\t\u0005E\u0013Q\r\b\u0005\u0003'\n\u0019G\u0004\u0003\u0002V\u0005\u0005d\u0002BA,\u0003?rA!!\u0017\u0002^9\u0019\u0011,a\u0017\n\u0003iJ!\u0001O\u001d\n\u0005Y:\u0014B\u0001\u001b6\u0013\t\u00114'C\u0002\u0002hE\nQ\u0001\u001e:fKNLA!a\u001b\u0002n\u0005YAK]3f!\u0006$H/\u001a:o\u0015\r\t9'M\u0005\u0005\u0003c\n\u0019HA\u0006Ue\u0016,\u0007+\u0019;uKJt'\u0002BA6\u0003[\nQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013\u0001\u0003:fg>dg/\u001a3\u0016\u0005\u0005m\u0004cA)\u0002~%\u0019\u0011q\u0010*\u0003\u000f\t{w\u000e\\3b]\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000bi)\u0004\u0002\u0002\n*\u0019\u00111R\u0019\u0002\u0011\u0005t\u0017\r\\=tSNLA!a$\u0002\n\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004i\u0006U\u0005BBAL-\u0001\u0007A-\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0013Q\fi*a(\u0002\"\u0006\r\u0006b\u00022\u0018!\u0003\u0005\r\u0001\u001a\u0005\bQ^\u0001\n\u00111\u0001k\u0011\u001dqw\u0003%AA\u0002)Dq\u0001]\f\u0011\u0002\u0003\u0007!.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%&f\u00013\u0002,.\u0012\u0011Q\u0016\t\u0005\u0003_\u000bI,\u0004\u0002\u00022*!\u00111WA[\u0003%)hn\u00195fG.,GMC\u0002\u00028J\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY,!-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005'f\u00016\u0002,\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0007\u0003BAg\u0003/l!!a4\u000b\t\u0005E\u00171[\u0001\u0005Y\u0006twM\u0003\u0002\u0002V\u0006!!.\u0019<b\u0013\u0011\t\t%a4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005u\u0007cA)\u0002`&\u0019\u0011\u0011\u001d*\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0018Q\u001e\t\u0004#\u0006%\u0018bAAv%\n\u0019\u0011I\\=\t\u0013\u0005=h$!AA\u0002\u0005u\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002vB1\u0011q_A\u007f\u0003Ol!!!?\u000b\u0007\u0005m(+\u0001\u0006d_2dWm\u0019;j_:LA!a@\u0002z\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tYH!\u0002\t\u0013\u0005=\b%!AA\u0002\u0005\u001d\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a3\u0003\f!I\u0011q^\u0011\u0002\u0002\u0003\u0007\u0011Q\\\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m$\u0011\u0003\u0005\n\u0003_\u0014\u0013\u0011!a\u0001\u0003ODs\u0003\u0001B\u000b\u00057\u0011iB!\t\u0003$\t\u001d\"\u0011\u0006B\u0017\u0005_\u0011\u0019D!\u000e\u0011\u0007y\u00129\"C\u0002\u0003\u001a=\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003 \u0005)YA\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0018.\\3`G>dW/\u001c8-A]Lg\u000eZ8x?\u0012,(/\u0019;j_:\\F\u0006I:mS\u0012,w\fZ;sCRLwN\\.-AM$\u0018M\u001d;`i&lW-X/*A5\u0002#)^2lKRL'0\u001a\u0011s_^\u001c\b%\u001b8u_\u0002zg.\u001a\u0011pe\u0002jwN]3!i&lW\rI<j]\u0012|wo\u001d\u0011hSZ,g\u000eI1!i&lWm\u001d;b[B\u00043\u000f]3dS\u001aL\u0018N\\4!G>dW/\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!/&tGm\\<!gR\f'\u000f^:!CJ,\u0007%\u001b8dYV\u001c\u0018N^3!EV$\b\u0005\u001e5fA]Lg\u000eZ8xA\u0015tGm\u001d\u0011be\u0016\u0004S\r_2mkNLg/\u001a\u0017!K::g\u0006I\u00193uA*\u0004e^5mY\u0002\u0012W\rI5oAQDW\rI<j]\u0012|w\u000fI.2ei\u0002T\u0007L\u00193uE\u0002\u0014\u0006\t2vi\u0002rw\u000e\u001e\u0011j]\u0002Z\u0016G\r\u001e1a1\n$G\u000f\u00196S9R\u0001\u0005\t\u0011!A\u0001:\u0016N\u001c3poN\u00043-\u00198!gV\u0004\bo\u001c:uA5L7M]8tK\u000e|g\u000e\u001a\u0011qe\u0016\u001c\u0017n]5p]:\u0002s+\u001b8e_^\u001c\b%\u001b8!i\",\u0007e\u001c:eKJ\u0004sN\u001a\u0011n_:$\bn\u001d\u0011be\u0016\u0004cn\u001c;!gV\u0004\bo\u001c:uK\u0012t#\u0002\t\u0011!A\u0001\u00023+Z3!y\u0005\u0004\u0003N]3g{\tBG\u000f\u001e9tu=z3\u000f]1sW:\n\u0007/Y2iK:z'oZ\u0018e_\u000e\u001cx\u0006\\1uKN$xf\u001d;sk\u000e$XO]3e[M$(/Z1nS:<W\u0006\u001d:pOJ\fW.\\5oO6:W/\u001b3f]!$X\u000e\\\u0012xS:$wn^\u0017pa\u0016\u0014\u0018\r^5p]NlsN\\\u0017fm\u0016tG/\f;j[\u0016\u0014chJ,j]\u0012|w\u000fI(qKJ\fG/[8og\u0002zg\u000eI#wK:$\b\u0005V5nK\u001ebt&\u0019 !S:\u00043\u000b\u001e:vGR,(/\u001a3!'R\u0014X-Y7j]\u001e\u0004s-^5eK\u0002\"wn\u0019\u0011g_J\u0004C-\u001a;bS2,G\rI3ya2\fg.\u0019;j_:\u0004\u0013M\u001c3!Kb\fW\u000e\u001d7fg:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#A!\n\u0002\u0011oS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t;j[\u0016|6m\u001c7v[:\u0004S\u0006\t+iK\u0002\u001aw\u000e\\;n]\u0002z'\u000f\t;iK\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011u_\u0002*8/\u001a\u0011bg\u0002\"\b.\u001a\u0011uS6,7\u000f^1na\u00022wN\u001d\u0011xS:$wn^5oO\u0002\u0012\u0017\u0010\t;j[\u0016t\u0003\u0005\u00165fAQLW.\u001a\u0011d_2,XN\u001c\u0011nkN$\bEY3!_\u001a\u0004C+[7fgR\fW\u000e\u001d+za\u0016t#\u0002\t\u0011!A\u0001\u0002#\u0006I<j]\u0012|wo\u00183ve\u0006$\u0018n\u001c8![\u0001\n\u0005e\u001d;sS:<\u0007e\u001d9fG&4\u00170\u001b8hAQDW\rI<jIRD\u0007e\u001c4!i\",\u0007e^5oI><\bE]3qe\u0016\u001cXM\u001c;fI\u0002\n7\u000f\t\u0012j]R,'O^1mAY\fG.^3#])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003fU3fAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:rY6\u0012XMZ\u0017mSR,'/\u00197t]!$X\u000e\\\u0012j]R,'O^1m[1LG/\u001a:bY\nr\u0014J\u001c;feZ\fG\u000e\t'ji\u0016\u0014\u0018\r\u001c\u001f0Cz\u0002cm\u001c:![>\u0014X\r\t3fi\u0006LGn\u001d\u0018*\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001ru\u000e^3!i\"\fG\u000f\t;iK\u0002\"WO]1uS>t\u0007%[:!C\u00022\u0017\u000e_3eA1,gn\u001a;iA=4\u0007\u0005^5nK2\u0002\u0013M\u001c3!I>,7\u000f\t8pi\u00022\u0018M]=!_Z,'\u000f\t;j[\u0016\u0004\u0013mY2pe\u0012Lgn\u001a\u0011u_\u0002\n\u0007eY1mK:$\u0017M\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AMd\u0017\u000eZ3`IV\u0014\u0018\r^5p]\u0002j\u0003%\u0011\u0011tiJLgn\u001a\u0011ta\u0016\u001c\u0017NZ=j]\u001e\u0004C\u000f[3!g2LG-\u001b8hA%tG/\u001a:wC2\u0004sN\u001a\u0011uQ\u0016\u0004s/\u001b8e_^\u0004#/\u001a9sKN,g\u000e^3eA\u0005\u001c\bEI5oi\u0016\u0014h/\u00197!m\u0006dW/\u001a\u0012/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n\u0005E\\3xA]Lg\u000eZ8xA]LG\u000e\u001c\u0011cK\u0002:WM\\3sCR,G\rI3wKJL\b\u0005Y:mS\u0012,w\fZ;sCRLwN\u001c1/A5+8\u000f\u001e\u0011cK\u0002bWm]:!i\"\fg\u000eI8sA\u0015\fX/\u00197!i>\u0004C\u000f[3!A^Lg\u000eZ8x?\u0012,(/\u0019;j_:\u0004gF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011UQ&\u001c\b\u0005Z;sCRLwN\u001c\u0011jg\u0002b\u0017n[3xSN,\u0007%\u00192t_2,H/\u001a\u0017!C:$\u0007\u0005Z8fg\u0002rw\u000e\u001e\u0011wCJL\b%Y2d_J$\u0017N\\4!i>\u0004\u0013\rI2bY\u0016tG-\u0019:/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aH/\u0019:u?RLW.\u001a\u0011.AQCW\rI8gMN,G\u000fI<ji\"\u0004#/Z:qK\u000e$\b\u0005^8!ce:\u0004'\f\u00192[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0011V)\u000e\u0003s/\u001b;iA]D\u0017n\u00195!i>\u00043\u000f^1si\u0002:\u0018N\u001c3po\u0002Jg\u000e^3sm\u0006d7O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\r>\u0014\b%\u001a=b[BdW\r\f\u0011j]\u0002z'\u000fZ3sAQ|\u0007\u0005[1wK\u0002Bw.\u001e:ms\u0002\"X/\u001c2mS:<\u0007e^5oI><8\u000f\t;iCR\u00043\u000f^1si\u0002\nT\u0007I7j]V$Xm\u001d\u0011qCN$\b\u0005\u001e5fA!|WO\u001d\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0015tsM\f\u00112ei\nT'L\u00194uE*D\u0006I\u00194uE*T&\r\u001b;cUrcF\f\u0011qe>4\u0018\u000eZ3!AN$\u0018M\u001d;`i&lW\r\u0019\u0011bg\u0002\u0002\u0017'\u000e\u0011nS:,H/Z:a])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011Y#ADT\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\nG\u0006I<j]\u0012|wOL:uCJ$H\u0006I<j]\u0012|wOL3oI2\u00023m\\;oi\"R\u0013\u0006I1tA\rtG\u000f\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u0019;aA:\u0013\u0006\f\u0011)O\u0005\u000bt\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aQR4\u0007M\u0014*Y\u0001Bs%Q\u0019(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004G\u000e\u001e1a\u001dJC\u0006\t\u0015(\u0003J:C\u0006I\u00143aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ci\u0002\u0004gJ\u0015!\u0003N\u0003C/\u00192)C2\u0002#-\u000b\u0011H%>+\u0006\u000b\t2zA\u0005d\u0003e\u0018$V\u001d\u000e{\u0006F\u0019\u0017!OU\u0002S.\u001b8vi\u0016\u001cx%\u000b\u0011P%\u0012+%\u000b\t\"ZA\u0005d\u0003e\u001d;beR\\$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!2\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aUR\u0004\u0007M\u00053\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n\u0015'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00196uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$(\r\u0019;aAJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Be%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA*$\b\r\u0019\nc)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013\r\f\u0011xS:$wn\u001e\u0018ti\u0006\u0014H\u000f\f\u0011xS:$wn\u001e\u0018f]\u0012d\u0003eY8v]RD#&\u000b\u0011bg\u0002\u001ag\u000e\u001e\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\"$h\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001c;aA:\u0013\u0006\f\u0011)O\u0005\u0013t\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aER\u0004\u0007M\u0014*A\u0005\u001b\u0006\u0005^1cQ\u0005d\u0003EY\u0015!\u000fJ{U\u000b\u0015\u0011cs\u0002\nG\u0006I0G+:\u001bu\f\u000b2-A\u001d\n\u0004\u0007I7j]V$Xm]\u0014-A\u001d*\u0004%\\5okR,7oJ\u0015!\u001fJ#UI\u0015\u0011C3\u0002\nG\u0006I:uCJ$8H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0004G\r\u0019.cIj3'\r\u00113gi*TG\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA*$\b\r\u0019\ne)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004GO\u00191uA\u0002\u0014b\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\u000e\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\nTG\u000f\u00191\u0013ER\u0001\u0005\t\u0011!A\u0001\u0002\u0003%\u0011\u001a\neA\u0012\u0004'L\u00193[M\n\u0004EM\u001a;kUR\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ki\u0002\u0004'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u0013\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u0019;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0014\u0007\r\u001e1a%\t$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tE\u0012A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005o\tQA\r\u00181]A\n!\u0002V5nK^Kg\u000eZ8x!\tqDeE\u0003%\u0005\u007f\u0011)\u0005E\u0002R\u0005\u0003J1Aa\u0011S\u0005\u0019\te.\u001f*fMB!!q\tB'\u001b\t\u0011IE\u0003\u0003\u0003L\u0005M\u0017AA5p\u0013\r\u0001'\u0011\n\u000b\u0003\u0005w\ta!\\1sW\u0016\u0014\u0018aB7be.,'\u000fI\u0001\u001aO\u0016$\u0018J\u001c;feZ\fG.\u00138NS\u000e\u0014xnU3d_:$7\u000fF\u0002k\u00053BqAa\u0017)\u0001\u0004\t)$\u0001\u0005j]R,'O^1m\u0003=\u0001\u0018M]:f\u000bb\u0004(/Z:tS>tGc\u00016\u0003b!1!1M\u0015A\u0002\u0011\fA!\u001a=qe\u0006)\u0011\r\u001d9msRIAO!\u001b\u0003l\t5$q\u000e\u0005\u0006E*\u0002\r\u0001\u001a\u0005\u0007Q*\u0002\r!!\u000e\t\r9T\u0003\u0019AA\u001b\u0011\u0019\u0001(\u00061\u0001\u00026QIAOa\u001d\u0003v\t]$\u0011\u0010\u0005\u0006E.\u0002\r\u0001\u001a\u0005\u0006Q.\u0002\rA\u001b\u0005\u0006].\u0002\rA\u001b\u0005\u0006a.\u0002\rA[\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yHa#\u0011\u000bE\u0013\tI!\"\n\u0007\t\r%K\u0001\u0004PaRLwN\u001c\t\b#\n\u001dEM\u001b6k\u0013\r\u0011II\u0015\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\t5E&!AA\u0002Q\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\u0019\n\u0005\u0003\u0002N\nU\u0015\u0002\u0002BL\u0003\u001f\u0014aa\u00142kK\u000e$\b")
public class TimeWindow
extends UnaryExpression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
QueryErrorsBase,
Serializable {
    private boolean resolved;
    private final Expression timeColumn;
    private final long windowDuration;
    private final long slideDuration;
    private final long startTime;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<Expression, Object, Object, Object>> unapply(TimeWindow x$0) {
        return TimeWindow$.MODULE$.unapply(x$0);
    }

    public static long parseExpression(Expression expr) {
        return TimeWindow$.MODULE$.parseExpression(expr);
    }

    public static long getIntervalInMicroSeconds(String interval) {
        return TimeWindow$.MODULE$.getIntervalInMicroSeconds(interval);
    }

    public static String marker() {
        return TimeWindow$.MODULE$.marker();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return FoldableUnevaluable.eval$(this, input);
    }

    @Override
    public InternalRow eval$default$1() {
        return FoldableUnevaluable.eval$default$1$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return FoldableUnevaluable.doGenCode$(this, ctx, ev);
    }

    public Expression timeColumn() {
        return this.timeColumn;
    }

    public long windowDuration() {
        return this.windowDuration;
    }

    public long slideDuration() {
        return this.slideDuration;
    }

    public long startTime() {
        return this.startTime;
    }

    private AbstractDataType inputTypeOnTimeColumn() {
        return TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyTimestampType$.MODULE$, new StructType().add(new StructField("start", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), new StructType().add(new StructField("start", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", (DataType)TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))}));
    }

    @Override
    public Expression child() {
        return this.timeColumn();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)this.inputTypeOnTimeColumn(), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return new StructType().add(new StructField("start", this.child().dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", this.child().dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    @Override
    public String prettyName() {
        return "window";
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean resolved$lzycompute() {
        TimeWindow timeWindow = this;
        synchronized (timeWindow) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult dataTypeCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (dataTypeCheck.isSuccess()) {
            if (this.windowDuration() <= 0L) {
                return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.toSQLId("window_duration")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)("(0, " + Long.MAX_VALUE + "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)this.toSQLValue(BoxesRunTime.boxToLong((long)this.windowDuration()), (DataType)LongType$.MODULE$))}))));
            }
            if (this.slideDuration() <= 0L) {
                return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.toSQLId("slide_duration")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)("(0, " + Long.MAX_VALUE + "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)this.toSQLValue(BoxesRunTime.boxToLong((long)this.slideDuration()), (DataType)LongType$.MODULE$))}))));
            }
            if (this.slideDuration() > this.windowDuration()) {
                return new TypeCheckResult.DataTypeMismatch("PARAMETER_CONSTRAINT_VIOLATION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftExprName"), (Object)this.toSQLId("slide_duration")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftExprValue"), (Object)this.toSQLValue(BoxesRunTime.boxToLong((long)this.slideDuration()), (DataType)LongType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"constraint"), (Object)"<="), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightExprName"), (Object)this.toSQLId("window_duration")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightExprValue"), (Object)this.toSQLValue(BoxesRunTime.boxToLong((long)this.windowDuration()), (DataType)LongType$.MODULE$))}))));
            }
            if (RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(this.startTime())) >= this.slideDuration()) {
                return new TypeCheckResult.DataTypeMismatch("PARAMETER_CONSTRAINT_VIOLATION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftExprName"), (Object)this.toSQLId("abs(start_time)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftExprValue"), (Object)this.toSQLValue(BoxesRunTime.boxToLong((long)RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(this.startTime()))), (DataType)LongType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"constraint"), (Object)"<"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightExprName"), (Object)this.toSQLId("slide_duration")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightExprValue"), (Object)this.toSQLValue(BoxesRunTime.boxToLong((long)this.slideDuration()), (DataType)LongType$.MODULE$))}))));
            }
        }
        return dataTypeCheck;
    }

    @Override
    public TimeWindow withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public TimeWindow copy(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        return new TimeWindow(timeColumn, windowDuration, slideDuration, startTime);
    }

    public Expression copy$default$1() {
        return this.timeColumn();
    }

    public long copy$default$2() {
        return this.windowDuration();
    }

    public long copy$default$3() {
        return this.slideDuration();
    }

    public long copy$default$4() {
        return this.startTime();
    }

    @Override
    public String productPrefix() {
        return "TimeWindow";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.timeColumn();
            }
            case 1: {
                return BoxesRunTime.boxToLong((long)this.windowDuration());
            }
            case 2: {
                return BoxesRunTime.boxToLong((long)this.slideDuration());
            }
            case 3: {
                return BoxesRunTime.boxToLong((long)this.startTime());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimeWindow;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "timeColumn";
            }
            case 1: {
                return "windowDuration";
            }
            case 2: {
                return "slideDuration";
            }
            case 3: {
                return "startTime";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimeWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimeWindow timeWindow = (TimeWindow)x$1;
        if (this.windowDuration() != timeWindow.windowDuration()) return false;
        if (this.slideDuration() != timeWindow.slideDuration()) return false;
        if (this.startTime() != timeWindow.startTime()) return false;
        Expression expression = this.timeColumn();
        Expression expression2 = timeWindow.timeColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!timeWindow.canEqual(this)) return false;
        return true;
    }

    public TimeWindow(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        this.timeColumn = timeColumn;
        this.windowDuration = windowDuration;
        this.slideDuration = slideDuration;
        this.startTime = startTime;
        ExpectsInputTypes.$init$(this);
        FoldableUnevaluable.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.TIME_WINDOW(), (List)Nil$.MODULE$);
    }

    public TimeWindow(Expression timeColumn, Expression windowDuration, Expression slideDuration, Expression startTime) {
        this(timeColumn, TimeWindow$.MODULE$.parseExpression(windowDuration), TimeWindow$.MODULE$.parseExpression(slideDuration), TimeWindow$.MODULE$.parseExpression(startTime));
    }

    public TimeWindow(Expression timeColumn, Expression windowDuration, Expression slideDuration) {
        this(timeColumn, TimeWindow$.MODULE$.parseExpression(windowDuration), TimeWindow$.MODULE$.parseExpression(slideDuration), 0L);
    }

    public TimeWindow(Expression timeColumn, Expression windowDuration) {
        this(timeColumn, windowDuration, windowDuration);
    }
}

