/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import javax.xml.validation.Schema;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.XmlToStructs$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.xml.StaxXmlParser;
import org.apache.spark.sql.catalyst.xml.ValidatorUtil$;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import org.apache.spark.sql.catalyst.xml.XmlOptions$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(xmlStr, schema[, options]) - Returns a struct value with the given `xmlStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('<p><a>1</a><b>0.8</b></p>', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('<p><time>26/08/2015</time></p>', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n      > SELECT _FUNC_('<p><teacher>Alice</teacher><student><name>Bob</name><rank>1</rank></student><student><name>Charlie</name><rank>2</rank></student></p>', 'STRUCT<teacher: STRING, student: ARRAY<STRUCT<name: STRING, rank: INT>>>');\n       {\"teacher\":\"Alice\",\"student\":[{\"name\":\"Bob\",\"rank\":1},{\"name\":\"Charlie\",\"rank\":2}]}\n  ", group="xml_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0005\tMf\u0001B\u00193\u0001~B\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tU\u0002\u0011\t\u0012)A\u0005I\"A1\u000e\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005y\u0001\tE\t\u0015!\u0003n\u0011!I\bA!f\u0001\n\u0003Q\b\u0002\u0003@\u0001\u0005#\u0005\u000b\u0011B>\t\u0013}\u0004!Q3A\u0005\u0002\u0005\u0005\u0001BCA\u0005\u0001\tE\t\u0015!\u0003\u0002\u0004!9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u0006\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\tY\u0003\u0001C!\u0003GA\u0001\"!\f\u0001\u0005\u0004%Ia\u0019\u0005\b\u0003_\u0001\u0001\u0015!\u0003e\u0011\u001d\tY\u0001\u0001C\u0001\u0003cAq!a\u0003\u0001\t\u0003\t9\u0004\u0003\u0006\u0002@\u0001A)\u0019!C\u0005\u0003\u0003B\u0011\"a\u0018\u0001\u0005\u0004%I!!\u0019\t\u000f\u0005\r\u0004\u0001)A\u0005k\"Q\u0011Q\r\u0001\t\u0006\u0004%I!a\u001a\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003+\u0003A\u0011KAL\u0011\u001d\t\u0019\f\u0001C!\u0003kCq!a1\u0001\t\u0003\n\t\u0007C\u0004\u0002F\u0002!\t\"a2\t\u0013\u00055\u0007!!A\u0005\u0002\u0005=\u0007\"CAm\u0001E\u0005I\u0011AAn\u0011%\t\t\u0010AI\u0001\n\u0003\t\u0019\u0010C\u0005\u0002x\u0002\t\n\u0011\"\u0001\u0002z\"I\u0011Q \u0001\u0012\u0002\u0013\u0005\u0011q \u0005\n\u0005\u0007\u0001\u0011\u0011!C!\u0005\u000bA\u0011B!\u0006\u0001\u0003\u0003%\tAa\u0006\t\u0013\t}\u0001!!A\u0005\u0002\t\u0005\u0002\"\u0003B\u0014\u0001\u0005\u0005I\u0011\tB\u0015\u0011%\u0011)\u0004AA\u0001\n\u0003\u00119\u0004C\u0005\u0003<\u0001\t\t\u0011\"\u0011\u0003>!I!\u0011\t\u0001\u0002\u0002\u0013\u0005#1I\u0004\n\u0005O\u0012\u0014\u0011!E\u0001\u0005S2\u0001\"\r\u001a\u0002\u0002#\u0005!1\u000e\u0005\b\u0003\u0017IC\u0011\u0001BB\u0011%\u0011))KA\u0001\n\u000b\u00129\tC\u0005\u0003\n&\n\t\u0011\"!\u0003\f\"I!QS\u0015\u0012\u0002\u0013\u0005\u0011q \u0005\n\u0005/K\u0013\u0011!CA\u00053C\u0011Ba**#\u0003%\t!a@\t\u0013\t%\u0016&!A\u0005\n\t-&\u0001\u0004-nYR{7\u000b\u001e:vGR\u001c(BA\u001a5\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005U2\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005]B\u0014aA:rY*\u0011\u0011HO\u0001\u0006gB\f'o\u001b\u0006\u0003wq\na!\u00199bG\",'\"A\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\u0001Ei\u0012&Q-B\u0011\u0011IQ\u0007\u0002e%\u00111I\r\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011)R\u0005\u0003\rJ\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u0005C\u0015BA%3\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bZ\na!\u001a:s_J\u001c\u0018BA(M\u0005=\tV/\u001a:z\u000bJ\u0014xN]:CCN,\u0007CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&a\u0002)s_\u0012,8\r\u001e\t\u0003/~s!\u0001W/\u000f\u0005ecV\"\u0001.\u000b\u0005ms\u0014A\u0002\u001fs_>$h(C\u0001T\u0013\tq&+A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\f'\u0001D*fe&\fG.\u001b>bE2,'B\u00010S\u0003\u0019\u00198\r[3nCV\tA\r\u0005\u0002fQ6\taM\u0003\u0002hm\u0005)A/\u001f9fg&\u0011\u0011N\u001a\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aB:dQ\u0016l\u0017\rI\u0001\b_B$\u0018n\u001c8t+\u0005i\u0007\u0003\u00028skVt!a\u001c9\u0011\u0005e\u0013\u0016BA9S\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0004\u001b\u0006\u0004(BA9S!\tqg/\u0003\u0002xi\n11\u000b\u001e:j]\u001e\f\u0001b\u001c9uS>t7\u000fI\u0001\u0006G\"LG\u000eZ\u000b\u0002wB\u0011\u0011\t`\u0005\u0003{J\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005QA/[7f5>tW-\u00133\u0016\u0005\u0005\r\u0001\u0003B)\u0002\u0006UL1!a\u0002S\u0005\u0019y\u0005\u000f^5p]\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}QQ\u0011qBA\t\u0003'\t)\"a\u0006\u0011\u0005\u0005\u0003\u0001\"\u00022\n\u0001\u0004!\u0007\"B6\n\u0001\u0004i\u0007\"B=\n\u0001\u0004Y\b\u0002C@\n!\u0003\u0005\r!a\u0001\u0015\u0011\u0005=\u00111DA\u000f\u0003?AQ!\u001f\u0006A\u0002mDQA\u0019\u0006A\u0002mDQa\u001b\u0006A\u00025\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003K\u00012!UA\u0014\u0013\r\tIC\u0015\u0002\b\u0005>|G.Z1o\u00039qW\u000f\u001c7J]R|G.\u001a:b]R\faB\\;mY\u0006\u0014G.Z*dQ\u0016l\u0017-A\bok2d\u0017M\u00197f'\u000eDW-\\1!)\u0019\ty!a\r\u00026!)\u0011p\u0004a\u0001w\")!m\u0004a\u0001wRA\u0011qBA\u001d\u0003w\ti\u0004C\u0003z!\u0001\u00071\u0010C\u0003c!\u0001\u00071\u0010C\u0003l!\u0001\u000710A\u0005d_:4XM\u001d;feV\u0011\u00111\t\t\b#\u0006\u0015\u0013\u0011JA(\u0013\r\t9E\u0015\u0002\n\rVt7\r^5p]F\u0002RaVA&\u0003\u001fJ1!!\u0014b\u0005!IE/\u001a:bi>\u0014\b\u0003BA)\u0003'j\u0011\u0001N\u0005\u0004\u0003+\"$aC%oi\u0016\u0014h.\u00197S_^D3!EA-!\r\t\u00161L\u0005\u0004\u0003;\u0012&!\u0003;sC:\u001c\u0018.\u001a8u\u0003Mq\u0017-\\3PM\u000e{'O];qiJ+7m\u001c:e+\u0005)\u0018\u0001\u00068b[\u0016|emQ8seV\u0004HOU3d_J$\u0007%\u0001\u0004qCJ\u001cXM]\u000b\u0003\u0003S\u0002R!a\u001b\u0002rUl!!!\u001c\u000b\u0007\u0005=D'\u0001\u0003vi&d\u0017\u0002BA:\u0003[\u0012\u0011CR1jYV\u0014XmU1gKB\u000b'o]3sQ\r!\u0012\u0011L\u0001\tI\u0006$\u0018\rV=qKV\u0011\u00111\u0010\t\u0004K\u0006u\u0014bAA@M\nAA)\u0019;b)f\u0004X-\u0001\u0007xSRDG+[7f5>tW\rF\u0002E\u0003\u000bCQa \fA\u0002U\fAB\\;mYN\u000bg-Z#wC2$B!a#\u0002\u0012B\u0019\u0011+!$\n\u0007\u0005=%KA\u0002B]fDq!a%\u0018\u0001\u0004\tY)A\u0002y[2\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005e\u0015QUAX!\u0011\tY*!)\u000e\u0005\u0005u%bAAPe\u000591m\u001c3fO\u0016t\u0017\u0002BAR\u0003;\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003OC\u0002\u0019AAU\u0003\r\u0019G\u000f\u001f\t\u0005\u00037\u000bY+\u0003\u0003\u0002.\u0006u%AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003cC\u0002\u0019AAM\u0003\t)g/\u0001\u0006j]B,H\u000fV=qKN,\"!a.\u0011\u000b]\u000bI,!0\n\u0007\u0005m\u0016MA\u0002TKF\u00042!ZA`\u0013\r\t\tM\u001a\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR!\u0011qBAe\u0011\u0019\tYm\u0007a\u0001w\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHCCA\b\u0003#\f\u0019.!6\u0002X\"9!\r\bI\u0001\u0002\u0004!\u0007bB6\u001d!\u0003\u0005\r!\u001c\u0005\bsr\u0001\n\u00111\u0001|\u0011!yH\u0004%AA\u0002\u0005\r\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003;T3\u0001ZApW\t\t\t\u000f\u0005\u0003\u0002d\u00065XBAAs\u0015\u0011\t9/!;\u0002\u0013Ut7\r[3dW\u0016$'bAAv%\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0018Q\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003kT3!\\Ap\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a?+\u0007m\fy.\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0005!\u0006BA\u0002\u0003?\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0004!\u0011\u0011IAa\u0005\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\tA\u0001\\1oO*\u0011!\u0011C\u0001\u0005U\u00064\u0018-C\u0002x\u0005\u0017\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u0007\u0011\u0007E\u0013Y\"C\u0002\u0003\u001eI\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a#\u0003$!I!QE\u0012\u0002\u0002\u0003\u0007!\u0011D\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t-\u0002C\u0002B\u0017\u0005g\tY)\u0004\u0002\u00030)\u0019!\u0011\u0007*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\t=\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0015\"\u0011\b\u0005\n\u0005K)\u0013\u0011!a\u0001\u0003\u0017\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!q\u0001B \u0011%\u0011)CJA\u0001\u0002\u0004\u0011I\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003K\u0011)\u0005C\u0005\u0003&\u001d\n\t\u00111\u0001\u0002\f\"\u001a\u0002A!\u0013\u0003P\tE#Q\u000bB,\u00057\u0012iF!\u0019\u0003dA\u0019\u0011Ia\u0013\n\u0007\t5#GA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tM\u0013\u0001Y0G+:\u001bu\f\u000b=nYN#(\u000f\f\u0011tG\",W.Y.-A=\u0004H/[8ogvK\u0003%\f\u0011SKR,(O\\:!C\u0002\u001aHO];di\u00022\u0018\r\\;fA]LG\u000f\u001b\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002\u00070\u001c7TiJ\u0004\u0007%\u00198eA\u0001\u001c8\r[3nC\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\te\u0013\u0001b&\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001db\u0004O\u0010\u001fb}Ebt&\u0019 =Ez\u0002d\u0006\u000f\u001f0Ezbt\u0006\u001d (Y\u0001:\u0013\rI%O)2\u0002#\r\t#P+\ncUiJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e2Y\t\u0012'E\u000f\u0019/quT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001fq}q\"\u0018.\\3?eYz\u0003\u0007O\u00183aE*Dh\f;j[\u0016tDh\f9?O1\u0002s\u0005^5nK\u0002\"\u0016.\\3ti\u0006l\u0007o\n\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uS6,'E\u000f\u001a1cUj\u0003\u0007O\u00173m\u0001\u0002\u0004G\u000f\u00191uA\u0002TP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(yAtD\b^3bG\",'OP!mS\u000e,Gh\f;fC\u000eDWM\u001d =gR,H-\u001a8u}qr\u0017-\\3?\u0005>\u0014Gh\f8b[\u0016tDH]1oWz\nDh\f:b].tDhL:uk\u0012,g\u000e\u001e =gR,H-\u001a8u}qr\u0017-\\3?\u0007\"\f'\u000f\\5fy=r\u0017-\\3?yI\fgn\u001b 3y=\u0012\u0018M\\6?y=\u001aH/\u001e3f]RtDh\f9?O1\u0002se\u0015+S+\u000e#F\b^3bG\",'O\u000f\u0011T)JKej\u0012\u0017!gR,H-\u001a8uu\u0001\n%KU!ZyM#&+V\"Uy9\fW.\u001a\u001e!'R\u0013\u0016JT$-AI\fgn\u001b\u001e!\u0013:#fH\u0010 (SmR\u0001\u0005\t\u0011!A\u0001\u00023P\t;fC\u000eDWM\u001d\u0012;E\u0005c\u0017nY3#Y\t\u001aH/\u001e3f]R\u0014#hW>#]\u0006lWM\t\u001e#\u0005>\u0014'\u0005\f\u0012sC:\\'EO\u0019~Ym\u0014c.Y7fEi\u00123\t[1sY&,'\u0005\f\u0012sC:\\'E\u000f\u001a~;vT\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005?\n\u0011\u0002_7m?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t\u0015\u0014!\u0002\u001b/a9\u0002\u0014\u0001\u0004-nYR{7\u000b\u001e:vGR\u001c\bCA!*'\u0015I#Q\u000eB=!-\u0011yG!\u001ee[n\f\u0019!a\u0004\u000e\u0005\tE$b\u0001B:%\u00069!/\u001e8uS6,\u0017\u0002\u0002B<\u0005c\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\u0011YH!!\u000e\u0005\tu$\u0002\u0002B@\u0005\u001f\t!![8\n\u0007\u0001\u0014i\b\u0006\u0002\u0003j\u0005AAo\\*ue&tw\r\u0006\u0002\u0003\b\u0005)\u0011\r\u001d9msRQ\u0011q\u0002BG\u0005\u001f\u0013\tJa%\t\u000b\td\u0003\u0019\u00013\t\u000b-d\u0003\u0019A7\t\u000bed\u0003\u0019A>\t\u0011}d\u0003\u0013!a\u0001\u0003\u0007\tq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YJa)\u0011\u000bE\u000b)A!(\u0011\u0011E\u0013y\nZ7|\u0003\u0007I1A!)S\u0005\u0019!V\u000f\u001d7fi!I!Q\u0015\u0018\u0002\u0002\u0003\u0007\u0011qB\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003.B!!\u0011\u0002BX\u0013\u0011\u0011\tLa\u0003\u0003\r=\u0013'.Z2u\u0001")
public class XmlToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
ExpectsInputTypes,
QueryErrorsBase,
Serializable {
    private transient Function1<Iterator<InternalRow>, InternalRow> converter;
    private transient FailureSafeParser<String> parser;
    private final StructType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final StructType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return XmlToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<StructType, Map<String, String>, Expression, Option<String>>> unapply(XmlToStructs x$0) {
        return XmlToStructs$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return XmlToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<StructType, Map<String, String>, Expression, Option<String>>, XmlToStructs> tupled() {
        return XmlToStructs$.MODULE$.tupled();
    }

    public static Function1<StructType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, XmlToStructs>>>> curried() {
        return XmlToStructs$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private StructType nullableSchema() {
        return this.nullableSchema;
    }

    private Function1<Iterator<InternalRow>, InternalRow> converter$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.converter = (Function1 & Serializable)rows -> {
                    if (rows.hasNext()) {
                        return (InternalRow)rows.next();
                    }
                    return null;
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    private Function1<Iterator<InternalRow>, InternalRow> converter() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    private String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<String> parser$lzycompute() {
        XmlToStructs xmlToStructs = this;
        synchronized (xmlToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                ParseMode mode;
                XmlOptions parsedOptions = new XmlOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord(), XmlOptions$.MODULE$.$lessinit$greater$default$4());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_xml", mode);
                    }
                }
                ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                StaxXmlParser rawParser = new StaxXmlParser(this.schema(), parsedOptions);
                Option xsdSchema = Option$.MODULE$.apply((Object)parsedOptions.rowValidationXSDPath()).map((Function1 & Serializable)path -> ValidatorUtil$.MODULE$.getSchema((String)path));
                this.parser = new FailureSafeParser((Function1 & Serializable)input -> Option$.MODULE$.option2Iterable(rawParser.doParseColumn((String)input, mode, (Option<Schema>)xsdSchema)), mode, this.nullableSchema(), parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    private FailureSafeParser<String> parser() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object xml) {
        return this.converter().apply(this.parser().parse(((UTF8String)xml).toString()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String expr = ctx.addReferenceObj("this", this, ctx.addReferenceObj$default$3());
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)input -> "(InternalRow) " + expr + ".nullSafeEval(" + input + ")");
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringTypeWithCollation stringTypeWithCollation = StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)stringTypeWithCollation);
    }

    @Override
    public String prettyName() {
        return "from_xml";
    }

    @Override
    public XmlToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        StructType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public XmlToStructs copy(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new XmlToStructs(schema, options, child, timeZoneId);
    }

    public StructType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "XmlToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.schema();
            }
            case 1: {
                return this.options();
            }
            case 2: {
                return this.child();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XmlToStructs;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "schema";
            }
            case 1: {
                return "options";
            }
            case 2: {
                return "child";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XmlToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        XmlToStructs xmlToStructs = (XmlToStructs)x$1;
        StructType structType = this.schema();
        StructType structType2 = xmlToStructs.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = xmlToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = xmlToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = xmlToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!xmlToStructs.canEqual(this)) return false;
        return true;
    }

    public XmlToStructs(StructType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
        Statics.releaseFence();
    }

    public XmlToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public XmlToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public XmlToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalSchemaExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

