/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.resolver.LimitLikeExpressionValidator;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Offset;
import org.apache.spark.sql.catalyst.plans.logical.Tail;
import org.apache.spark.sql.catalyst.plans.logical.UnaryNode;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005y3AAB\u0004\u0001-!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00131\u0003B\u0002\u0016\u0001A\u0003%q\u0005C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\t\ru\u0003\u0001\u0015!\u0003.\u0005\u0005b\u0015.\\5u\u0019&\\W-\u0012=qe\u0016\u001c8/[8o-\u0006d\u0017\u000eZ1u_J\u001cV/\u001b;f\u0015\tA\u0011\"\u0001\u0005sKN|GN^3s\u0015\tQ1\"\u0001\u0005b]\u0006d\u0017p]5t\u0015\taQ\"\u0001\u0005dCR\fG._:u\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001qc\u0007\t\u00031ei\u0011aD\u0005\u00035=\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u000e\u0003\u0019)'O]8sg&\u0011\u0001%\b\u0002\u0010#V,'/_#se>\u00148OQ1tK\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011aB\u0001\u001dY&l\u0017\u000e\u001e'jW\u0016,\u0005\u0010\u001d:fgNLwN\u001c,bY&$\u0017\r^8s+\u00059\u0003C\u0001\u0013)\u0013\tIsA\u0001\u000fMS6LG\u000fT5lK\u0016C\bO]3tg&|gNV1mS\u0012\fGo\u001c:\u0002;1LW.\u001b;MS.,W\t\u001f9sKN\u001c\u0018n\u001c8WC2LG-\u0019;pe\u0002\n\u0011\u0002^3ti\u000e\u000b7/Z:\u0016\u00035\u00022AL\u001b8\u001b\u0005y#B\u0001\u00192\u0003%IW.\\;uC\ndWM\u0003\u00023g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003Q\nQa]2bY\u0006L!AN\u0018\u0003\u0007M+\u0017\u000fE\u00039sm:v+D\u00014\u0013\tQ4G\u0001\u0004UkBdWm\r\t\u0005qqrD)\u0003\u0002>g\tIa)\u001e8di&|g.\r\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003.\t1\"\u001a=qe\u0016\u001c8/[8og&\u00111\t\u0011\u0002\u000b\u000bb\u0004(/Z:tS>t'cA#L\u001f\u001a!a\t\u0001\u0001E\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0015\tA\u0015*A\u0004m_\u001eL7-\u00197\u000b\u0005)[\u0011!\u00029mC:\u001c\bC\u0001'N\u001b\u00059\u0015B\u0001(H\u0005%)f.\u0019:z\u001d>$W\r\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006\u0011\u0011n\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016K\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002Y76\t\u0011L\u0003\u0002['\u0006!A.\u00198h\u0013\ta\u0016L\u0001\u0004TiJLgnZ\u0001\u000bi\u0016\u001cHoQ1tKN\u0004\u0003")
public class LimitLikeExpressionValidatorSuite
extends SparkFunSuite
implements QueryErrorsBase {
    private final LimitLikeExpressionValidator limitLikeExpressionValidator;
    private final Seq<Tuple3<Function1<Expression, UnaryNode>, String, String>> testCases;

    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$((QueryErrorsBase)this, (String)conf);
    }

    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (Expression)e);
    }

    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$((QueryErrorsBase)this, (int)i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    private LimitLikeExpressionValidator limitLikeExpressionValidator() {
        return this.limitLikeExpressionValidator;
    }

    private Seq<Tuple3<Function1<Expression, UnaryNode>, String, String>> testCases() {
        return this.testCases;
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Tuple3 check$ifrefutable$1) {
        Tuple3 tuple3 = check$ifrefutable$1;
        return tuple3 != null;
    }

    public static final /* synthetic */ void $anonfun$new$2(LimitLikeExpressionValidatorSuite $this, Tuple3 x$5) {
        Tuple3 tuple3 = x$5;
        if (tuple3 != null) {
            Function1 planBuilder = (Function1)tuple3._1();
            String name = (String)tuple3._2();
            String simpleName = (String)tuple3._3();
            $this.test("Basic " + name + " without errors", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Literal expr = new Literal((Object)BoxesRunTime.boxToInteger((int)42), (DataType)IntegerType$.MODULE$);
                UnaryNode plan = (UnaryNode)planBuilder.apply((Object)expr);
                Expression $org_scalatest_assert_macro_left = $this.limitLikeExpressionValidator().validateLimitLikeExpr((Expression)expr, (LogicalPlan)plan);
                Literal $org_scalatest_assert_macro_right = expr;
                Expression expression = $org_scalatest_assert_macro_left;
                Literal literal = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(expression != null ? !expression.equals(literal) : literal != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            }, new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            $this.test("Unfoldable " + name, (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String x$1 = "foo";
                IntegerType$ x$2 = IntegerType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("foo", (DataType)x$2, x$3, x$4);
                Seq x$6 = AttributeReference$.MODULE$.apply$default$6("foo", (DataType)x$2, x$3, x$4);
                AttributeReference col = new AttributeReference("foo", (DataType)x$2, x$3, x$4, x$5, x$6);
                UnaryNode plan = (UnaryNode)planBuilder.apply((Object)col);
                AnalysisException x$7 = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable)() -> $this.limitLikeExpressionValidator().validateLimitLikeExpr((Expression)col, (LogicalPlan)plan), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48))));
                String x$8 = "INVALID_LIMIT_LIKE_EXPRESSION.IS_UNFOLDABLE";
                Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)simpleName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)$this.toSQLExpr((Expression)col))}));
                Option x$10 = $this.checkError$default$3();
                boolean x$11 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$12 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$7, "INVALID_LIMIT_LIKE_EXPRESSION.IS_UNFOLDABLE", x$10, x$9, x$11, x$12);
            }, new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            $this.test(name + " with non-integer", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Literal anyNonInteger = Literal$.MODULE$.apply((Object)"42");
                UnaryNode plan = (UnaryNode)planBuilder.apply((Object)anyNonInteger);
                AnalysisException x$13 = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable)() -> $this.limitLikeExpressionValidator().validateLimitLikeExpr((Expression)anyNonInteger, (LogicalPlan)plan), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60))));
                String x$14 = "INVALID_LIMIT_LIKE_EXPRESSION.DATA_TYPE";
                Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)simpleName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)$this.toSQLExpr((Expression)anyNonInteger)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)$this.toSQLType((AbstractDataType)anyNonInteger.dataType()))}));
                Option x$16 = $this.checkError$default$3();
                boolean x$17 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$18 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$13, "INVALID_LIMIT_LIKE_EXPRESSION.DATA_TYPE", x$16, x$15, x$17, x$18);
            }, new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            $this.test(name + " with null", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Cast expr = new Cast((Expression)Literal$.MODULE$.apply(null), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                UnaryNode plan = (UnaryNode)planBuilder.apply((Object)expr);
                AnalysisException x$19 = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable)() -> $this.limitLikeExpressionValidator().validateLimitLikeExpr((Expression)expr, (LogicalPlan)plan), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76))));
                String x$20 = "INVALID_LIMIT_LIKE_EXPRESSION.IS_NULL";
                Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)simpleName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)$this.toSQLExpr((Expression)expr))}));
                Option x$22 = $this.checkError$default$3();
                boolean x$23 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$24 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$19, "INVALID_LIMIT_LIKE_EXPRESSION.IS_NULL", x$22, x$21, x$23, x$24);
            }, new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            $this.test(name + " with negative integer", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Literal expr = new Literal((Object)BoxesRunTime.boxToInteger((int)-1), (DataType)IntegerType$.MODULE$);
                UnaryNode plan = (UnaryNode)planBuilder.apply((Object)expr);
                AnalysisException x$25 = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable)() -> $this.limitLikeExpressionValidator().validateLimitLikeExpr((Expression)expr, (LogicalPlan)plan), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88))));
                String x$26 = "INVALID_LIMIT_LIKE_EXPRESSION.IS_NEGATIVE";
                Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)simpleName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)$this.toSQLExpr((Expression)expr)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)$this.toSQLValue(BoxesRunTime.boxToInteger((int)-1), (DataType)IntegerType$.MODULE$))}));
                Option x$28 = $this.checkError$default$3();
                boolean x$29 = $this.checkError$default$5();
                SparkFunSuite.ExpectedContext[] x$30 = $this.checkError$default$6();
                $this.checkError((SparkThrowable)x$25, "INVALID_LIMIT_LIKE_EXPRESSION.IS_NEGATIVE", x$28, x$27, x$29, x$30);
            }, new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public LimitLikeExpressionValidatorSuite() {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$((QueryErrorsBase)this);
        this.limitLikeExpressionValidator = new LimitLikeExpressionValidator();
        this.testCases = new .colon.colon((Object)new Tuple3((Function1 & Serializable)x$1 -> new LocalLimit(x$1, null), (Object)"localLimit", (Object)"limit"), (List)new .colon.colon((Object)new Tuple3((Function1 & Serializable)x$2 -> new GlobalLimit(x$2, null), (Object)"globalLimit", (Object)"limit"), (List)new .colon.colon((Object)new Tuple3((Function1 & Serializable)x$3 -> new Offset(x$3, null), (Object)"offset", (Object)"offset"), (List)new .colon.colon((Object)new Tuple3((Function1 & Serializable)x$4 -> new Tail(x$4, null), (Object)"tail", (Object)"tail"), (List)Nil$.MODULE$))));
        this.testCases().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LimitLikeExpressionValidatorSuite.$anonfun$new$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$5 -> {
            LimitLikeExpressionValidatorSuite.$anonfun$new$2(this, x$5);
            return BoxedUnit.UNIT;
        });
        this.test("LIMIT with OFFSET sum exceeds max int", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Literal expr = new Literal((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), (DataType)IntegerType$.MODULE$);
            LocalLimit plan = new LocalLimit((Expression)expr, (LogicalPlan)new Offset((Expression)expr, null));
            AnalysisException x$31 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> this.limitLikeExpressionValidator().validateLimitLikeExpr((Expression)expr, (LogicalPlan)plan), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102))));
            String x$32 = "SUM_OF_LIMIT_AND_OFFSET_EXCEEDS_MAX_INT";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)Integer.toString(Integer.MAX_VALUE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offset"), (Object)Integer.toString(Integer.MAX_VALUE))}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, "SUM_OF_LIMIT_AND_OFFSET_EXCEEDS_MAX_INT", x$34, x$33, x$35, x$36);
        }, new Position("LimitLikeExpressionValidatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
    }
}

