/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.analysis.FunctionResolution;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversalStack;
import org.apache.spark.sql.catalyst.analysis.resolver.PlanLogger;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatestplus.mockito.MockitoSugar$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\r4Aa\u0005\u000b\u0001G!)\u0001\u0006\u0001C\u0001S\u0019!A\u0006\u0001\u0001.\u0011!\t$A!A!\u0002\u0013\u0011\u0004\u0002\u0003\u001e\u0003\u0005\u0003\u0005\u000b\u0011B\u001e\t\u000b!\u0012A\u0011A!\t\u000b\u0019\u0013A\u0011I$\t\u000f)\u0003!\u0019!C\u0005\u0017\"1q\n\u0001Q\u0001\n1Cq\u0001\u0015\u0001C\u0002\u0013%1\n\u0003\u0004R\u0001\u0001\u0006I\u0001\u0014\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u00199\u0006\u0001)A\u0005)\"9\u0001\f\u0001b\u0001\n\u0013\u0019\u0006BB-\u0001A\u0003%A\u000bC\u0004[\u0001\t\u0007I\u0011B.\t\rq\u0003\u0001\u0015!\u0003C\u0011\u001di\u0006A1A\u0005\nyCaA\u0019\u0001!\u0002\u0013y&\u0001\n+j[\u0016TxN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<feN+\u0018\u000e^3\u000b\u0005U1\u0012\u0001\u0003:fg>dg/\u001a:\u000b\u0005]A\u0012\u0001C1oC2L8/[:\u000b\u0005eQ\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005ma\u0012aA:rY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013'\u001b\u0005a\u0012BA\u0014\u001d\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012A\u000b\t\u0003W\u0001i\u0011\u0001\u0006\u0002\u001c\u0011\u0006\u0014HmQ8eK\u0012,\u0005\u0010\u001d:fgNLwN\u001c*fg>dg/\u001a:\u0014\u0005\tq\u0003CA\u00160\u0013\t\u0001DC\u0001\nFqB\u0014Xm]:j_:\u0014Vm]8mm\u0016\u0014\u0018AD2bi\u0006dwnZ'b]\u0006<WM\u001d\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nqaY1uC2|wM\u0003\u000285\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003sQ\u0012abQ1uC2|w-T1oC\u001e,'/\u0001\nsKN|GN^3e\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001f@\u001b\u0005i$B\u0001 \u0019\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005\u0001k$AC#yaJ,7o]5p]R\u0019!\tR#\u0011\u0005\r\u0013Q\"\u0001\u0001\t\u000bE*\u0001\u0019\u0001\u001a\t\u000bi*\u0001\u0019A\u001e\u0002\u000fI,7o\u001c7wKR\u00111\b\u0013\u0005\u0006\u0013\u001a\u0001\raO\u0001\u000bKb\u0004(/Z:tS>t\u0017aD;oe\u0016\u001cx\u000e\u001c<fI\u000eC\u0017\u000e\u001c3\u0016\u00031\u0003\"\u0001P'\n\u00059k$AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016\f\u0001#\u001e8sKN|GN^3e\u0007\"LG\u000e\u001a\u0011\u0002\u001bI,7o\u001c7wK\u0012\u001c\u0005.\u001b7e\u00039\u0011Xm]8mm\u0016$7\t[5mI\u0002\nabY1ti\u0016C\bO]3tg&|g.F\u0001U!\taT+\u0003\u0002W{\t!1)Y:u\u0003=\u0019\u0017m\u001d;FqB\u0014Xm]:j_:\u0004\u0013a\u00038fgR,GmQ1tiN\fAB\\3ti\u0016$7)Y:ug\u0002\n!#\u001a=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<feV\t!)A\nfqB\u0014Xm]:j_:\u0014Vm]8mm\u0016\u0014\b%A\u0010uS6,'p\u001c8f\u0003^\f'/Z#yaJ,7o]5p]J+7o\u001c7wKJ,\u0012a\u0018\t\u0003W\u0001L!!\u0019\u000b\u0003?QKW.\u001a>p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t'+Z:pYZ,'/\u0001\u0011uS6,'p\u001c8f\u0003^\f'/Z#yaJ,7o]5p]J+7o\u001c7wKJ\u0004\u0003")
public class TimezoneAwareExpressionResolverSuite
extends SparkFunSuite {
    private final AttributeReference unresolvedChild;
    private final AttributeReference resolvedChild;
    private final Cast castExpression;
    private final Cast nestedCasts;
    private final HardCodedExpressionResolver expressionResolver;
    private final TimezoneAwareExpressionResolver timezoneAwareExpressionResolver;

    private AttributeReference unresolvedChild() {
        return this.unresolvedChild;
    }

    private AttributeReference resolvedChild() {
        return this.resolvedChild;
    }

    private Cast castExpression() {
        return this.castExpression;
    }

    private Cast nestedCasts() {
        return this.nestedCasts;
    }

    private HardCodedExpressionResolver expressionResolver() {
        return this.expressionResolver;
    }

    private TimezoneAwareExpressionResolver timezoneAwareExpressionResolver() {
        return this.timezoneAwareExpressionResolver;
    }

    public TimezoneAwareExpressionResolverSuite() {
        String x$1 = "unresolvedChild";
        StringType$ x$2 = StringType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("unresolvedChild", (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6("unresolvedChild", (DataType)x$2, x$3, x$4);
        this.unresolvedChild = new AttributeReference("unresolvedChild", (DataType)x$2, x$3, x$4, x$5, x$6);
        String x$7 = "resolvedChild";
        IntegerType$ x$8 = IntegerType$.MODULE$;
        boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5("resolvedChild", (DataType)x$8, x$9, x$10);
        Seq x$12 = AttributeReference$.MODULE$.apply$default$6("resolvedChild", (DataType)x$8, x$9, x$10);
        this.resolvedChild = new AttributeReference("resolvedChild", (DataType)x$8, x$9, x$10, x$11, x$12);
        this.castExpression = new Cast((Expression)this.unresolvedChild(), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        this.nestedCasts = new Cast((Expression)new Cast((Expression)new Cast((Expression)this.unresolvedChild(), (DataType)IntegerType$.MODULE$, (Option)new Some((Object)"UTC"), Cast$.MODULE$.apply$default$4()), (DataType)IntegerType$.MODULE$, (Option)None$.MODULE$, Cast$.MODULE$.apply$default$4()), (DataType)IntegerType$.MODULE$, (Option)None$.MODULE$, Cast$.MODULE$.apply$default$4());
        this.expressionResolver = new HardCodedExpressionResolver(this, (CatalogManager)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(CatalogManager.class)), (Expression)this.resolvedChild());
        this.timezoneAwareExpressionResolver = new TimezoneAwareExpressionResolver((ExpressionResolver)this.expressionResolver());
        this.test("TimeZoneAwareExpression resolution", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression $org_scalatest_assert_macro_left = (Expression)this.castExpression().children().head();
            AttributeReference $org_scalatest_assert_macro_right = this.unresolvedChild();
            Expression expression = $org_scalatest_assert_macro_left;
            AttributeReference attributeReference = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(expression != null ? !expression.equals(attributeReference) : attributeReference != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            Option $org_scalatest_assert_macro_left2 = this.castExpression().timeZoneId();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            Option $org_scalatest_assert_macro_left3 = this.castExpression().getTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            this.castExpression().setTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST(), (Object)BoxedUnit.UNIT);
            ExpressionTreeTraversalStack qual$1 = this.expressionResolver().getExpressionTreeTraversals();
            OneRowRelation x$13 = new OneRowRelation();
            Option x$14 = qual$1.withNewTraversal$default$2();
            boolean x$15 = qual$1.withNewTraversal$default$3();
            boolean x$16 = qual$1.withNewTraversal$default$4();
            Function0 & Serializable x$17 = (Function0 & Serializable)() -> (TimeZoneAwareExpression)this.timezoneAwareExpressionResolver().resolve((TimeZoneAwareExpression)this.castExpression());
            TimeZoneAwareExpression resolvedExpression = (TimeZoneAwareExpression)qual$1.withNewTraversal((LogicalPlan)x$13, x$14, x$15, x$16, (Function0)x$17);
            Expression $org_scalatest_assert_macro_left4 = (Expression)((TreeNode)resolvedExpression).children().head();
            AttributeReference $org_scalatest_assert_macro_right2 = this.resolvedChild();
            Expression expression2 = $org_scalatest_assert_macro_left4;
            AttributeReference attributeReference2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(expression2 != null ? !expression2.equals(attributeReference2) : attributeReference2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            Option $org_scalatest_assert_macro_left5 = resolvedExpression.timeZoneId();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Option $org_scalatest_assert_macro_left6 = ((TreeNode)resolvedExpression).getTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "nonEmpty", $org_scalatest_assert_macro_left6.nonEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("Timezone is applied recursively", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression expressionWithTimezone = TimezoneAwareExpressionResolver$.MODULE$.resolveTimezone((Expression)this.nestedCasts(), "UTC");
            String $org_scalatest_assert_macro_left = (String)((Cast)expressionWithTimezone).timeZoneId().get();
            String $org_scalatest_assert_macro_right = "UTC";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            String $org_scalatest_assert_macro_left2 = (String)((Cast)((Cast)expressionWithTimezone).child()).timeZoneId().get();
            String $org_scalatest_assert_macro_right2 = "UTC";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("TimezoneAwareExpressionResolverSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    public class HardCodedExpressionResolver
    extends ExpressionResolver {
        private final Expression resolvedExpression;
        public final /* synthetic */ TimezoneAwareExpressionResolverSuite $outer;

        public Expression resolve(Expression expression) {
            return this.resolvedExpression;
        }

        public /* synthetic */ TimezoneAwareExpressionResolverSuite org$apache$spark$sql$catalyst$analysis$resolver$TimezoneAwareExpressionResolverSuite$HardCodedExpressionResolver$$$outer() {
            return this.$outer;
        }

        public HardCodedExpressionResolver(TimezoneAwareExpressionResolverSuite $outer, CatalogManager catalogManager, Expression resolvedExpression) {
            this.resolvedExpression = resolvedExpression;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(new Resolver(catalogManager, Resolver$.MODULE$.$lessinit$greater$default$2(), Resolver$.MODULE$.$lessinit$greater$default$3(), Resolver$.MODULE$.$lessinit$greater$default$4()), new FunctionResolution(catalogManager, Resolver$.MODULE$.createRelationResolution(catalogManager)), new PlanLogger());
        }
    }
}

