/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogTestUtils;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005)3QAB\u0004\u0002\u0002QAQ!\u0007\u0001\u0005\u0002iAq!\b\u0001C\u0002\u001bEa\u0004C\u0003#\u0001\u0011E1\u0005C\u0003+\u0001\u0011\u00053\u0005C\u0003,\u0001\u0011%AF\u0001\u000bFqR,'O\\1m\u0007\u0006$\u0018\r\\8h'VLG/\u001a\u0006\u0003\u0011%\tqaY1uC2|wM\u0003\u0002\u000b\u0017\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001+A\u0011acF\u0007\u0002\u001b%\u0011\u0001$\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u00059\u0011!B;uS2\u001cX#A\u0010\u0011\u0005q\u0001\u0013BA\u0011\b\u0005A\u0019\u0015\r^1m_\u001e$Vm\u001d;Vi&d7/\u0001\u0006sKN,Go\u0015;bi\u0016$\u0012\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0005+:LG/A\u0005bMR,'/R1dQ\u00061Q\r_5tiN$2!\f\u0019;!\t)c&\u0003\u00020M\t9!i\\8mK\u0006t\u0007\"B\u0019\u0006\u0001\u0004\u0011\u0014aA;sSB\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0004]\u0016$(\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u00121!\u0016*J\u0011\u0015YT\u00011\u0001=\u0003!\u0019\u0007.\u001b7ee\u0016t\u0007cA\u0013>\u007f%\u0011aH\n\u0002\u000byI,\u0007/Z1uK\u0012t\u0004C\u0001!H\u001d\t\tU\t\u0005\u0002CM5\t1I\u0003\u0002E'\u00051AH]8pizJ!A\u0012\u0014\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\r\u001a\u0002")
public abstract class ExternalCatalogSuite
extends SparkFunSuite {
    public abstract CatalogTestUtils utils();

    public void resetState() {
    }

    public void afterEach() {
        try {
            this.resetState();
        }
        finally {
            BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
        }
    }

    private boolean exists(URI uri, Seq<String> children) {
        Path base = new Path(uri);
        Path finalPath = (Path)children.foldLeft((Object)base, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Path parent = (Path)tuple2._1();
                String child = (String)tuple2._2();
                return new Path(parent, child);
            }
            throw new MatchError((Object)tuple2);
        });
        return base.getFileSystem(new Configuration()).exists(finalPath);
    }

    public static final /* synthetic */ boolean $anonfun$new$65(CatalogStatistics x$5) {
        return BoxesRunTime.equalsNumObject((Number)x$5.sizeInBytes(), (Object)BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ boolean $anonfun$new$67(CatalogStatistics x$6) {
        return BoxesRunTime.equalsNumObject((Number)x$6.sizeInBytes(), (Object)BoxesRunTime.boxToInteger((int)1));
    }

    private final void checkAnswer$1(CatalogTable table, Seq filters, Set expected, ExternalCatalog catalog$12, String tz$1) {
        this.assertResult(expected.map((Function1 & Serializable)x$11 -> x$11.spec()), ((IterableOnceOps)catalog$12.listPartitionsByFilter(table.database(), table.identifier().identifier(), filters, tz$1).map((Function1 & Serializable)x$12 -> x$12.spec())).toSet(), Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
    }

    public ExternalCatalogSuite() {
        this.test("basic create and list databases", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newEmptyCatalog();
            catalog.createDatabase(this.utils().newDb("default"), true);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("default"), "catalog.databaseExists(\"default\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            catalog.createDatabase(this.utils().newDb("testing"), false);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            catalog.createDatabase(this.utils().newDb("testing2"), false);
            Set $org_scalatest_assert_macro_left2 = catalog.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing", "testing2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("does_not_exist"), "catalog.databaseExists(\"does_not_exist\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("get database when a database exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CatalogDatabase db1 = this.utils().newBasicCatalog().getDatabase("db1");
            String $org_scalatest_assert_macro_left = db1.name();
            String $org_scalatest_assert_macro_right = "db1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            String $org_scalatest_assert_macro_left2 = db1.description();
            String $org_scalatest_assert_macro_right2 = "db1";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("get database should throw exception when the database does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> this.utils().newBasicCatalog().getDatabase("db_that_does_not_exist"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84)))), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("list databases without pattern", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1", "db2", "db3"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("list databases with pattern", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listDatabases("db").toSet();
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            Set $org_scalatest_assert_macro_left2 = catalog.listDatabases("db*").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"db1", "db2", "db3"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            Set $org_scalatest_assert_macro_left3 = catalog.listDatabases("*1").toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"db1"}));
            Set set5 = $org_scalatest_assert_macro_left3;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            Set $org_scalatest_assert_macro_left4 = catalog.listDatabases("db2").toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"db2"}));
            Set set7 = $org_scalatest_assert_macro_left4;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("drop database", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            catalog.dropDatabase("db1", false, false);
            Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db2", "db3"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("drop database when the database is not empty", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog1 = this.utils().newBasicCatalog();
            catalog1.dropTable("db2", "tbl1", false, false);
            catalog1.dropTable("db2", "tbl2", false, false);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog1.dropDatabase("db2", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            this.resetState();
            ExternalCatalog catalog2 = this.utils().newBasicCatalog();
            catalog2.dropFunction("db2", "func1");
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog2.dropDatabase("db2", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            this.resetState();
            ExternalCatalog catalog3 = this.utils().newBasicCatalog();
            catalog3.dropDatabase("db2", false, true);
            Set $org_scalatest_assert_macro_left = catalog3.listDatabases().toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1", "db3"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("drop database when the database does not exist", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropDatabase("db_that_does_not_exist", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            catalog.dropDatabase("db_that_does_not_exist", true, false);
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("alter database", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogDatabase db1 = catalog.getDatabase("db1");
            Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"good"), (Object)"true")}));
            String x$2 = db1.copy$default$1();
            String x$3 = db1.copy$default$2();
            URI x$4 = db1.copy$default$3();
            catalog.alterDatabase(db1.copy(x$2, x$3, x$4, x$1));
            CatalogDatabase newDb1 = catalog.getDatabase("db1");
            Map $org_scalatest_assert_macro_left = (Map)db1.properties().$minus$minus((IterableOnce)new .colon.colon((Object)"owner", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            Map $org_scalatest_assert_macro_left2 = (Map)newDb1.properties().$minus$minus((IterableOnce)new .colon.colon((Object)"owner", (List)Nil$.MODULE$));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            Option $org_scalatest_assert_macro_left3 = newDb1.properties().get((Object)"k");
            Some $org_scalatest_assert_macro_right2 = new Some((Object)"v3");
            Option option = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            Option $org_scalatest_assert_macro_left4 = newDb1.properties().get((Object)"good");
            Some $org_scalatest_assert_macro_right3 = new Some((Object)"true");
            Option option2 = $org_scalatest_assert_macro_left4;
            Some some2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("alter database should throw exception when the database does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.utils().newBasicCatalog().alterDatabase(this.utils().newDb("does_not_exist")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153)))), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("the table type of an external table should be EXTERNAL_TABLE", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable qual$1 = this.utils().newTable("external_table1", "db2");
            CatalogTableType x$5 = CatalogTableType$.MODULE$.EXTERNAL();
            TableIdentifier x$6 = qual$1.copy$default$1();
            CatalogStorageFormat x$7 = qual$1.copy$default$3();
            StructType x$8 = qual$1.copy$default$4();
            Option x$9 = qual$1.copy$default$5();
            Seq x$10 = qual$1.copy$default$6();
            Option x$11 = qual$1.copy$default$7();
            String x$12 = qual$1.copy$default$8();
            long x$13 = qual$1.copy$default$9();
            long x$14 = qual$1.copy$default$10();
            String x$15 = qual$1.copy$default$11();
            Map x$16 = qual$1.copy$default$12();
            Option x$17 = qual$1.copy$default$13();
            Option x$18 = qual$1.copy$default$14();
            Option x$19 = qual$1.copy$default$15();
            Option x$20 = qual$1.copy$default$16();
            Seq x$21 = qual$1.copy$default$17();
            boolean x$22 = qual$1.copy$default$18();
            boolean x$23 = qual$1.copy$default$19();
            Map x$24 = qual$1.copy$default$20();
            Option x$25 = qual$1.copy$default$21();
            CatalogTable table = qual$1.copy(x$6, x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25);
            catalog.createTable(table, false);
            CatalogTable actual = catalog.getTable("db2", "external_table1");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual.tableType());
            CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.EXTERNAL();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("create table when the table already exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            CatalogTable table = this.utils().newTable("tbl1", "db2");
            return (TableAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createTable(table, false), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("drop table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            catalog.dropTable("db2", "tbl1", false, false);
            Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("drop table when database/table does not exist", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropTable("unknown_db", "unknown_table", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropTable("unknown_db", "unknown_table", true, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropTable("db2", "unknown_table", false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            catalog.dropTable("db2", "unknown_table", true, false);
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("rename table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            catalog.renameTable("db2", "tbl1", "tblone");
            Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tblone", "tbl2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("rename table when database/table does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameTable("unknown_db", "unknown_table", "unknown_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameTable("db2", "unknown_table", "unknown_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.test("rename table when destination table already exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameTable("db2", "tbl1", "tbl2"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("alter table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable tbl1 = catalog.getTable("db2", "tbl1");
            Map x$26 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"toh"), (Object)"frem")}));
            TableIdentifier x$27 = tbl1.copy$default$1();
            CatalogTableType x$28 = tbl1.copy$default$2();
            CatalogStorageFormat x$29 = tbl1.copy$default$3();
            StructType x$30 = tbl1.copy$default$4();
            Option x$31 = tbl1.copy$default$5();
            Seq x$32 = tbl1.copy$default$6();
            Option x$33 = tbl1.copy$default$7();
            String x$34 = tbl1.copy$default$8();
            long x$35 = tbl1.copy$default$9();
            long x$36 = tbl1.copy$default$10();
            String x$37 = tbl1.copy$default$11();
            Option x$38 = tbl1.copy$default$13();
            Option x$39 = tbl1.copy$default$14();
            Option x$40 = tbl1.copy$default$15();
            Option x$41 = tbl1.copy$default$16();
            Seq x$42 = tbl1.copy$default$17();
            boolean x$43 = tbl1.copy$default$18();
            boolean x$44 = tbl1.copy$default$19();
            Map x$45 = tbl1.copy$default$20();
            Option x$46 = tbl1.copy$default$21();
            catalog.alterTable(tbl1.copy(x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$26, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46));
            CatalogTable newTbl1 = catalog.getTable("db2", "tbl1");
            Map $org_scalatest_assert_macro_left = tbl1.properties();
            String $org_scalatest_assert_macro_right = "toh";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            Map $org_scalatest_assert_macro_left2 = newTbl1.properties();
            int $org_scalatest_assert_macro_right2 = tbl1.properties().size() + 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            Option $org_scalatest_assert_macro_left3 = newTbl1.properties().get((Object)"toh");
            Some $org_scalatest_assert_macro_right3 = new Some((Object)"frem");
            Option option = $org_scalatest_assert_macro_left3;
            Some some = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("alter table when database/table does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.alterTable(this.utils().newTable("tbl1", "unknown_db")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.alterTable(this.utils().newTable("unknown_table", "db2")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("alter table schema", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            StructType newSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("col1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("new_field_2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            catalog.alterTableSchema("db2", "tbl1", newSchema);
            CatalogTable newTbl1 = catalog.getTable("db2", "tbl1");
            StructType $org_scalatest_assert_macro_left = newTbl1.dataSchema();
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)newSchema.take(2));
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            StructType $org_scalatest_assert_macro_left2 = newTbl1.schema();
            StructType $org_scalatest_assert_macro_right2 = newSchema;
            StructType structType3 = $org_scalatest_assert_macro_left2;
            StructType structType4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("alter table stats", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option oldTableStats;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Option $org_scalatest_assert_macro_left = oldTableStats = catalog.getTable("db2", "tbl1").stats();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            CatalogStatistics newStats = new CatalogStatistics(BigInt$.MODULE$.int2bigInt(1), CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3());
            catalog.alterTableStats("db2", "tbl1", (Option)new Some((Object)newStats));
            Option newTableStats = catalog.getTable("db2", "tbl1").stats();
            CatalogStatistics $org_scalatest_assert_macro_left2 = (CatalogStatistics)newTableStats.get();
            CatalogStatistics $org_scalatest_assert_macro_right = newStats;
            CatalogStatistics catalogStatistics = $org_scalatest_assert_macro_left2;
            CatalogStatistics catalogStatistics2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(catalogStatistics != null ? !catalogStatistics.equals(catalogStatistics2) : catalogStatistics2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("get table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String $org_scalatest_assert_macro_left = this.utils().newBasicCatalog().getTable("db2", "tbl1").identifier().table();
            String $org_scalatest_assert_macro_right = "tbl1";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        this.test("get table when database/table does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0 & Serializable)() -> catalog.getTable("unknown_db", "unknown_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.getTable("db2", "unknown_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("get tables by name", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Seq tables = catalog.getTablesByName("db2", (Seq)new .colon.colon((Object)"tbl1", (List)new .colon.colon((Object)"tbl2", (List)Nil$.MODULE$)));
            Seq $org_scalatest_assert_macro_left = (Seq)((SeqOps)tables.map((Function1 & Serializable)x$1 -> x$1.identifier().table())).sorted((Ordering)Ordering.String$.MODULE$);
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"tbl1", (List)new .colon.colon((Object)"tbl2", (List)Nil$.MODULE$));
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            catalog.renameTable("db2", "tbl1", "tblone");
            Seq tables2 = catalog.getTablesByName("db2", (Seq)new .colon.colon((Object)"tbl2", (List)new .colon.colon((Object)"tblone", (List)Nil$.MODULE$)));
            Seq $org_scalatest_assert_macro_left2 = (Seq)((SeqOps)tables2.map((Function1 & Serializable)x$2 -> x$2.identifier().table())).sorted((Ordering)Ordering.String$.MODULE$);
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"tbl2", (List)new .colon.colon((Object)"tblone", (List)Nil$.MODULE$));
            Seq seq2 = $org_scalatest_assert_macro_left2;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        this.test("get tables by name when some tables do not exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = (Seq)this.utils().newBasicCatalog().getTablesByName("db2", (Seq)new .colon.colon((Object)"tbl1", (List)new .colon.colon((Object)"tblnotexist", (List)Nil$.MODULE$))).map((Function1 & Serializable)x$3 -> x$3.identifier().table());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"tbl1", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        this.test("get tables by name when contains invalid name", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String name = "\u7816";
            Seq $org_scalatest_assert_macro_left = (Seq)this.utils().newBasicCatalog().getTablesByName("db2", (Seq)new .colon.colon((Object)"tbl1", (List)new .colon.colon((Object)name, (List)Nil$.MODULE$))).map((Function1 & Serializable)x$4 -> x$4.identifier().table());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"tbl1", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("get tables by name when empty table list", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq $org_scalatest_assert_macro_left = this.utils().newBasicCatalog().getTablesByName("db2", (Seq)package$.MODULE$.Seq().empty());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("list tables without pattern", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0 & Serializable)() -> catalog.listTables("unknown_db"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            Set $org_scalatest_assert_macro_left = catalog.listTables("db1").toSet();
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        this.test("list tables with pattern", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0 & Serializable)() -> catalog.listTables("unknown_db", "*"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
            Set $org_scalatest_assert_macro_left = catalog.listTables("db1", "*").toSet();
            Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2", "*").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            Set $org_scalatest_assert_macro_left3 = catalog.listTables("db2", "tbl*").toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
            Set set5 = $org_scalatest_assert_macro_left3;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            Set $org_scalatest_assert_macro_left4 = catalog.listTables("db2", "*1").toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"}));
            Set set7 = $org_scalatest_assert_macro_left4;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        this.test("column names should be case-preserving and column nullability should be retained", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable tbl = new CatalogTable(TableIdentifier$.MODULE$.apply("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), this.utils().storageFormat(), new StructType().add("HelLo", "int", false).add("WoRLd", "int", true), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"WoRLd", (List)Nil$.MODULE$), (Option)new Some((Object)new BucketSpec(4, (Seq)new .colon.colon((Object)"HelLo", (List)Nil$.MODULE$), (Seq)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20(), CatalogTable$.MODULE$.apply$default$21());
            catalog.createTable(tbl, false);
            CatalogTable readBack = catalog.getTable("db1", "tbl");
            StructType $org_scalatest_assert_macro_left = readBack.schema();
            StructType $org_scalatest_assert_macro_right = tbl.schema();
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
            Seq $org_scalatest_assert_macro_left2 = readBack.partitionColumnNames();
            Seq $org_scalatest_assert_macro_right2 = tbl.partitionColumnNames();
            Seq seq = $org_scalatest_assert_macro_left2;
            Seq seq2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            Option $org_scalatest_assert_macro_left3 = readBack.bucketSpec();
            Option $org_scalatest_assert_macro_right3 = tbl.bucketSpec();
            Option option = $org_scalatest_assert_macro_left3;
            Option option2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        this.test("basic create and list partitions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newEmptyCatalog();
            catalog.createDatabase(this.utils().newDb("mydb"), false);
            catalog.createTable(this.utils().newTable("tbl", "mydb"), false);
            catalog.createPartitions("mydb", "tbl", (Seq)new .colon.colon((Object)this.utils().part1(), (List)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$)), false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.utils().catalogPartitionsEqual(catalog, "mydb", "tbl", (Seq<CatalogTablePartition>)new .colon.colon((Object)this.utils().part1(), (List)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"mydb\", \"tbl\", scala.`package`.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        this.test("create partitions when database/table does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createPartitions("does_not_exist", "tbl1", (Seq)Nil$.MODULE$, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createPartitions("db2", "does_not_exist", (Seq)Nil$.MODULE$, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
        this.test("create partitions that already exist", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$), false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            catalog.createPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$), true);
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("create partitions without location", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(TableIdentifier$.MODULE$.apply("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20(), CatalogTable$.MODULE$.apply$default$21());
            catalog.createTable(table, false);
            CatalogTablePartition partition = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partition, (List)Nil$.MODULE$), false);
            URI partitionLocation = catalog.getPartition("db1", "tbl", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")}))).location();
            Path tableLocation = new Path(catalog.getTable("db1", "tbl").location());
            Path defaultPartitionLocation = new Path(new Path(tableLocation, "partCol1=1"), "partCol2=2");
            Path $org_scalatest_assert_macro_left = new Path(partitionLocation);
            Path $org_scalatest_assert_macro_right = defaultPartitionLocation;
            Path path = $org_scalatest_assert_macro_left;
            Path path2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(path != null ? !path.equals(path2) : path2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("create/drop partitions in managed tables with location", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(TableIdentifier$.MODULE$.apply("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20(), CatalogTable$.MODULE$.apply$default$21());
            catalog.createTable(table, false);
            URI newLocationPart1 = this.utils().newUriForPartition((Seq<String>)new .colon.colon((Object)"p1=1", (List)new .colon.colon((Object)"p2=2", (List)Nil$.MODULE$)));
            URI newLocationPart2 = this.utils().newUriForPartition((Seq<String>)new .colon.colon((Object)"p1=3", (List)new .colon.colon((Object)"p2=4", (List)Nil$.MODULE$)));
            CatalogTablePartition partition1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.utils().storageFormat().copy((Option)new Some((Object)newLocationPart1), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition partition2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"4")})), this.utils().storageFormat().copy((Option)new Some((Object)newLocationPart2), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart1, (Seq<String>)Nil$.MODULE$), "ExternalCatalogSuite.this.exists(newLocationPart1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart2, (Seq<String>)Nil$.MODULE$), "ExternalCatalogSuite.this.exists(newLocationPart2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partition1, (List)Nil$.MODULE$), false);
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partition2, (List)Nil$.MODULE$), false);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart1, (Seq<String>)Nil$.MODULE$), "ExternalCatalogSuite.this.exists(newLocationPart1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart2, (Seq<String>)Nil$.MODULE$), "ExternalCatalogSuite.this.exists(newLocationPart2)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
            catalog.dropPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partition1.spec(), (List)Nil$.MODULE$), false, false, false);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart1, (Seq<String>)Nil$.MODULE$), "ExternalCatalogSuite.this.exists(newLocationPart1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
            catalog.dropTable("db1", "tbl", false, false);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(newLocationPart2, (Seq<String>)Nil$.MODULE$), "ExternalCatalogSuite.this.exists(newLocationPart2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.test("list partition names", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq partitionNames;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTablePartition newPart = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%=")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)newPart, (List)Nil$.MODULE$), false);
            Seq $org_scalatest_assert_macro_left = partitionNames = catalog.listPartitionNames("db2", "tbl2", catalog.listPartitionNames$default$3());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a=1/b=%25%3D", (List)new .colon.colon((Object)"a=1/b=2", (List)new .colon.colon((Object)"a=3/b=4", (List)Nil$.MODULE$)));
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
        this.test("list partition names with partial partition spec", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq partitionNames3;
            Seq partitionNames2;
            Seq partitionNames1;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTablePartition newPart = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%=")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)newPart, (List)Nil$.MODULE$), false);
            Seq $org_scalatest_assert_macro_left = partitionNames1 = catalog.listPartitionNames("db2", "tbl2", (Option)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1")}))));
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a=1/b=%25%3D", (List)new .colon.colon((Object)"a=1/b=2", (List)Nil$.MODULE$));
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
            Seq $org_scalatest_assert_macro_left2 = partitionNames2 = catalog.listPartitionNames("db2", "tbl2", (Option)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%=")}))));
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"a=1/b=%25%3D", (List)Nil$.MODULE$);
            Seq seq2 = $org_scalatest_assert_macro_left2;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
            Seq $org_scalatest_assert_macro_left3 = partitionNames3 = catalog.listPartitionNames("db2", "tbl2", (Option)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%25%3D")}))));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
        this.test("list partitions with partial partition spec", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq parts;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Seq $org_scalatest_assert_macro_left = parts = catalog.listPartitions("db2", "tbl2", (Option)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1")}))));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            Map $org_scalatest_assert_macro_left2 = ((CatalogTablePartition)parts.head()).spec();
            Map $org_scalatest_assert_macro_right2 = this.utils().part1().spec();
            Map map = $org_scalatest_assert_macro_left2;
            Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
            Seq $org_scalatest_assert_macro_left3 = catalog.listPartitions("db2", "tbl2", (Option)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"unknown"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"1")}))));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
            Seq $org_scalatest_assert_macro_left4 = catalog.listPartitions("db2", "tbl2", (Option)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"unknown")}))));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        this.test("SPARK-45054: list partitions should restore stats", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq parts;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Some stats = new Some((Object)new CatalogStatistics(BigInt$.MODULE$.int2bigInt(1), CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3()));
            Map x$47 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"2")}));
            CatalogStorageFormat x$48 = this.utils().storageFormat();
            Some x$49 = stats;
            Map x$50 = CatalogTablePartition$.MODULE$.apply$default$3();
            long x$51 = CatalogTablePartition$.MODULE$.apply$default$4();
            long x$52 = CatalogTablePartition$.MODULE$.apply$default$5();
            CatalogTablePartition newPart = new CatalogTablePartition(x$47, x$48, x$50, x$51, x$52, (Option)x$49);
            catalog.alterPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)newPart, (List)Nil$.MODULE$));
            Seq $org_scalatest_assert_macro_left = parts = catalog.listPartitions("db2", "tbl2", (Option)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1")}))));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
            CatalogTablePartition part = (CatalogTablePartition)parts.head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(part.stats().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ExternalCatalogSuite.$anonfun$new$65(x$5))), "part.stats.exists(((x$5: org.apache.spark.sql.catalyst.catalog.CatalogStatistics) => x$5.sizeInBytes.==(1)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        this.test("SPARK-45054: list partitions by filter should restore stats", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq parts;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Some stats = new Some((Object)new CatalogStatistics(BigInt$.MODULE$.int2bigInt(1), CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3()));
            Map x$53 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"2")}));
            CatalogStorageFormat x$54 = this.utils().storageFormat();
            Some x$55 = stats;
            Map x$56 = CatalogTablePartition$.MODULE$.apply$default$3();
            long x$57 = CatalogTablePartition$.MODULE$.apply$default$4();
            long x$58 = CatalogTablePartition$.MODULE$.apply$default$5();
            CatalogTablePartition newPart = new CatalogTablePartition(x$53, x$54, x$56, x$57, x$58, (Option)x$55);
            catalog.alterPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)newPart, (List)Nil$.MODULE$));
            String tz = TimeZone.getDefault().getID();
            Seq $org_scalatest_assert_macro_left = parts = catalog.listPartitionsByFilter("db2", "tbl2", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)Nil$.MODULE$), tz);
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
            CatalogTablePartition part = (CatalogTablePartition)parts.head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(part.stats().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ExternalCatalogSuite.$anonfun$new$67(x$6))), "part.stats.exists(((x$6: org.apache.spark.sql.catalyst.catalog.CatalogStatistics) => x$6.sizeInBytes.==(1)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
        this.test("SPARK-21457: list partitions with special chars", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Seq $org_scalatest_assert_macro_left = catalog.listPartitions("db2", "tbl1", catalog.listPartitions$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
            CatalogTablePartition part1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"i+j")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition part2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"i.j")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db2", "tbl1", (Seq)new .colon.colon((Object)part1, (List)new .colon.colon((Object)part2, (List)Nil$.MODULE$)), false);
            Seq $org_scalatest_assert_macro_left2 = (Seq)catalog.listPartitions("db2", "tbl1", (Option)new Some((Object)part1.spec())).map((Function1 & Serializable)x$7 -> x$7.spec());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)part1.spec(), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left2;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
            Seq $org_scalatest_assert_macro_left3 = (Seq)catalog.listPartitions("db2", "tbl1", (Option)new Some((Object)part2.spec())).map((Function1 & Serializable)x$8 -> x$8.spec());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)part2.spec(), (List)Nil$.MODULE$);
            Seq seq2 = $org_scalatest_assert_macro_left3;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
        this.test("SPARK-38120: list partitions with special chars and mixed case column name", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(TableIdentifier$.MODULE$.apply("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.EXTERNAL(), this.utils().storageFormat().copy((Option)new Some((Object)Utils$.MODULE$.createTempDir().toURI()), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6()), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20(), CatalogTable$.MODULE$.apply$default$21());
            catalog.createTable(table, false);
            CatalogTablePartition part1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"i+j")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition part2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"i.j")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)part1, (List)new .colon.colon((Object)part2, (List)Nil$.MODULE$)), false);
            Seq $org_scalatest_assert_macro_left = (Seq)catalog.listPartitions("db1", "tbl", (Option)new Some((Object)part1.spec())).map((Function1 & Serializable)x$9 -> x$9.spec());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)part1.spec(), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
            Seq $org_scalatest_assert_macro_left2 = (Seq)catalog.listPartitions("db1", "tbl", (Option)new Some((Object)part2.spec())).map((Function1 & Serializable)x$10 -> x$10.spec());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)part2.spec(), (List)Nil$.MODULE$);
            Seq seq2 = $org_scalatest_assert_macro_left2;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        this.test("list partitions by filter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String tz = TimeZone.getDefault().getID();
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable tbl2 = catalog.getTable("db2", "tbl2");
            this.checkAnswer$1(tbl2, (Seq)package$.MODULE$.Seq().empty(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1(), this.utils().part2()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2)), (List)Nil$.MODULE$), Predef$.MODULE$.Set().empty(), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)new In(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()).$times((Expression)package.expressions$.MODULE$.intToLiteral(10)), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(30), (List)Nil$.MODULE$)), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part2()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)new Not((Expression)new In((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int(), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.intToLiteral(4), (List)Nil$.MODULE$))), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1(), this.utils().part2()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("2")), (List)Nil$.MODULE$)), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("2"))), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1()})), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("x")), (List)Nil$.MODULE$)), Predef$.MODULE$.Set().empty(), catalog, tz);
            this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("x"))), (List)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.utils().part1()})), catalog, tz);
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> {
                BoxedUnit boxedUnit;
                try {
                    this.checkAnswer$1(tbl2, (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(0))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)).int()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(0))), (List)Nil$.MODULE$), Predef$.MODULE$.Set().empty(), catalog, tz);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    RuntimeException runtimeException;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof RuntimeException && (runtimeException = (RuntimeException)throwable2).getMessage().contains("MetaException")) {
                        throw new AnalysisException("_LEGACY_ERROR_TEMP_2193", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hiveMetastorePartitionPruningFallbackOnException"), (Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FALLBACK_ON_EXCEPTION().key())})));
                    }
                    throw throwable;
                }
                return boxedUnit;
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        this.test("drop partitions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)new .colon.colon((Object)this.utils().part1(), (List)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", scala.`package`.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
            catalog.dropPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), false, false, false);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$)), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", scala.`package`.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            this.resetState();
            ExternalCatalog catalog2 = this.utils().newBasicCatalog();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.utils().catalogPartitionsEqual(catalog2, "db2", "tbl2", (Seq<CatalogTablePartition>)new .colon.colon((Object)this.utils().part1(), (List)new .colon.colon((Object)this.utils().part2(), (List)Nil$.MODULE$))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog2, \"db2\", \"tbl2\", scala.`package`.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
            catalog2.dropPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), false, false, false);
            Seq $org_scalatest_assert_macro_left = catalog2.listPartitions("db2", "tbl2", catalog2.listPartitions$default$3());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        this.test("drop partitions when database/table does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropPartitions("does_not_exist", "tbl1", (Seq)Nil$.MODULE$, false, false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropPartitions("db2", "does_not_exist", (Seq)Nil$.MODULE$, false, false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        this.test("drop partitions that do not exist", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part3().spec(), (List)Nil$.MODULE$), false, false, false), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
            catalog.dropPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part3().spec(), (List)Nil$.MODULE$), true, false, false);
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
        this.test("get partition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Map $org_scalatest_assert_macro_left = catalog.getPartition("db2", "tbl2", this.utils().part1().spec()).spec();
            Map $org_scalatest_assert_macro_right = this.utils().part1().spec();
            Map map = $org_scalatest_assert_macro_left;
            Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
            Map $org_scalatest_assert_macro_left2 = catalog.getPartition("db2", "tbl2", this.utils().part2().spec()).spec();
            Map $org_scalatest_assert_macro_right2 = this.utils().part2().spec();
            Map map3 = $org_scalatest_assert_macro_left2;
            Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.getPartition("db2", "tbl1", this.utils().part3().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
        this.test("get partition when database/table does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0 & Serializable)() -> catalog.getPartition("does_not_exist", "tbl1", this.utils().part1().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.getPartition("db2", "does_not_exist", this.utils().part1().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
        this.test("rename partitions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTablePartition newPart1 = this.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"101")})), this.utils().part1().copy$default$2(), this.utils().part1().copy$default$3(), this.utils().part1().copy$default$4(), this.utils().part1().copy$default$5(), this.utils().part1().copy$default$6());
            CatalogTablePartition newPart2 = this.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"201")})), this.utils().part2().copy$default$2(), this.utils().part2().copy$default$3(), this.utils().part2().copy$default$4(), this.utils().part2().copy$default$5(), this.utils().part2().copy$default$6());
            .colon.colon newSpecs = new .colon.colon((Object)newPart1.spec(), (List)new .colon.colon((Object)newPart2.spec(), (List)Nil$.MODULE$));
            catalog.renamePartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), (Seq)newSpecs);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart1.spec()).spec());
            Map $org_scalatest_assert_macro_right = newPart1.spec();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 649));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart2.spec()).spec());
            Map $org_scalatest_assert_macro_right2 = newPart2.spec();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
            this.intercept((Function0 & Serializable)() -> catalog.getPartition("db2", "tbl2", this.utils().part1().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.getPartition("db2", "tbl2", this.utils().part2().spec()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
        this.test("rename partitions should update the location for managed table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(TableIdentifier$.MODULE$.apply("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20(), CatalogTable$.MODULE$.apply$default$21());
            catalog.createTable(table, false);
            Path tableLocation = new Path(catalog.getTable("db1", "tbl").location());
            CatalogTablePartition mixedCasePart1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition mixedCasePart2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"4")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)mixedCasePart1, (List)Nil$.MODULE$), false);
            Path $org_scalatest_assert_macro_left = new Path(catalog.getPartition("db1", "tbl", mixedCasePart1.spec()).location());
            Path $org_scalatest_assert_macro_right = new Path(new Path(tableLocation, "partCol1=1"), "partCol2=2");
            Path path = $org_scalatest_assert_macro_left;
            Path path2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(path != null ? !path.equals(path2) : path2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
            catalog.renamePartitions("db1", "tbl", (Seq)new .colon.colon((Object)mixedCasePart1.spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)mixedCasePart2.spec(), (List)Nil$.MODULE$));
            Path $org_scalatest_assert_macro_left2 = new Path(catalog.getPartition("db1", "tbl", mixedCasePart2.spec()).location());
            Path $org_scalatest_assert_macro_right2 = new Path(new Path(tableLocation, "partCol1=3"), "partCol2=4");
            Path path3 = $org_scalatest_assert_macro_left2;
            Path path4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(path3 != null ? !path3.equals(path4) : path4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
            URI existingPartLoc = catalog.getPartition("db2", "tbl2", this.utils().part1().spec()).location();
            catalog.renamePartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.utils().part3().spec(), (List)Nil$.MODULE$));
            Path $org_scalatest_assert_macro_left3 = new Path(catalog.getPartition("db2", "tbl2", this.utils().part3().spec()).location());
            Path $org_scalatest_assert_macro_right3 = new Path(existingPartLoc);
            Path path5 = $org_scalatest_assert_macro_left3;
            Path path6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(path5 != null ? !path5.equals(path6) : path6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
        this.test("rename partitions when database/table does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renamePartitions("does_not_exist", "tbl1", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renamePartitions("db2", "does_not_exist", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
        this.test("rename partitions when the new partition already exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renamePartitions("db2", "tbl2", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.utils().part2().spec(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
        this.test("alter partitions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object object;
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            try {
                URI newLocation = this.utils().newUriForDatabase();
                String newSerde = "com.sparkbricks.text.EasySerde";
                Map newSerdeProps = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark"), (Object)"bricks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compressed"), (Object)"false")}));
                CatalogTablePartition oldPart1 = catalog.getPartition("db2", "tbl2", this.utils().part1().spec());
                CatalogTablePartition oldPart2 = catalog.getPartition("db2", "tbl2", this.utils().part2().spec());
                CatalogStorageFormat x$59 = this.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6());
                Map x$60 = oldPart1.copy$default$1();
                Map x$61 = oldPart1.copy$default$3();
                long x$62 = oldPart1.copy$default$4();
                long x$63 = oldPart1.copy$default$5();
                Option x$64 = oldPart1.copy$default$6();
                CatalogStorageFormat x$65 = this.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.utils().storageFormat().copy$default$2(), this.utils().storageFormat().copy$default$3(), this.utils().storageFormat().copy$default$4(), this.utils().storageFormat().copy$default$5(), this.utils().storageFormat().copy$default$6());
                Map x$66 = oldPart2.copy$default$1();
                Map x$67 = oldPart2.copy$default$3();
                long x$68 = oldPart2.copy$default$4();
                long x$69 = oldPart2.copy$default$5();
                Option x$70 = oldPart2.copy$default$6();
                catalog.alterPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)oldPart1.copy(x$60, x$59, x$61, x$62, x$63, x$64), (List)new .colon.colon((Object)oldPart2.copy(x$66, x$65, x$67, x$68, x$69, x$70), (List)Nil$.MODULE$)));
                CatalogTablePartition newPart1 = catalog.getPartition("db2", "tbl2", this.utils().part1().spec());
                CatalogTablePartition newPart2 = catalog.getPartition("db2", "tbl2", this.utils().part2().spec());
                Option $org_scalatest_assert_macro_left = newPart1.storage().locationUri();
                Some $org_scalatest_assert_macro_right = new Some((Object)newLocation);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
                Option $org_scalatest_assert_macro_left2 = newPart2.storage().locationUri();
                Some $org_scalatest_assert_macro_right2 = new Some((Object)newLocation);
                Option option2 = $org_scalatest_assert_macro_left2;
                Some some2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
                Option $org_scalatest_assert_macro_left3 = oldPart1.storage().locationUri();
                Some $org_scalatest_assert_macro_right3 = new Some((Object)newLocation);
                Option option3 = $org_scalatest_assert_macro_left3;
                Some some3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", (Object)$org_scalatest_assert_macro_right3, option3 == null ? some3 != null : !option3.equals(some3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
                Option $org_scalatest_assert_macro_left4 = oldPart2.storage().locationUri();
                Some $org_scalatest_assert_macro_right4 = new Some((Object)newLocation);
                Option option4 = $org_scalatest_assert_macro_left4;
                Some some4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", (Object)$org_scalatest_assert_macro_right4, option4 == null ? some4 != null : !option4.equals(some4), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
                Some x$71 = new Some((Object)newSerde);
                Option x$72 = this.utils().storageFormat().copy$default$1();
                Option x$73 = this.utils().storageFormat().copy$default$2();
                Option x$74 = this.utils().storageFormat().copy$default$3();
                boolean x$75 = this.utils().storageFormat().copy$default$5();
                Map x$76 = this.utils().storageFormat().copy$default$6();
                CatalogStorageFormat x$77 = this.utils().storageFormat().copy(x$72, x$73, x$74, (Option)x$71, x$75, x$76);
                Map x$78 = oldPart1.copy$default$1();
                Map x$79 = oldPart1.copy$default$3();
                long x$80 = oldPart1.copy$default$4();
                long x$81 = oldPart1.copy$default$5();
                Option x$82 = oldPart1.copy$default$6();
                Map x$83 = newSerdeProps;
                Option x$84 = this.utils().storageFormat().copy$default$1();
                Option x$85 = this.utils().storageFormat().copy$default$2();
                Option x$86 = this.utils().storageFormat().copy$default$3();
                Option x$87 = this.utils().storageFormat().copy$default$4();
                boolean x$88 = this.utils().storageFormat().copy$default$5();
                CatalogStorageFormat x$89 = this.utils().storageFormat().copy(x$84, x$85, x$86, x$87, x$88, x$83);
                Map x$90 = oldPart2.copy$default$1();
                Map x$91 = oldPart2.copy$default$3();
                long x$92 = oldPart2.copy$default$4();
                long x$93 = oldPart2.copy$default$5();
                Option x$94 = oldPart2.copy$default$6();
                catalog.alterPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)oldPart1.copy(x$78, x$77, x$79, x$80, x$81, x$82), (List)new .colon.colon((Object)oldPart2.copy(x$90, x$89, x$91, x$92, x$93, x$94), (List)Nil$.MODULE$)));
                CatalogTablePartition newPart1b = catalog.getPartition("db2", "tbl2", this.utils().part1().spec());
                CatalogTablePartition newPart2b = catalog.getPartition("db2", "tbl2", this.utils().part2().spec());
                Option $org_scalatest_assert_macro_left5 = newPart1b.storage().serde();
                Some $org_scalatest_assert_macro_right5 = new Some((Object)newSerde);
                Option option5 = $org_scalatest_assert_macro_left5;
                Some some5 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option5 != null ? !option5.equals(some5) : some5 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
                Map $org_scalatest_assert_macro_left6 = newPart2b.storage().properties();
                Map $org_scalatest_assert_macro_right6 = newSerdeProps;
                Map map = $org_scalatest_assert_macro_left6;
                Map map2 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
                CatalogTablePartition badPart1 = this.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"v1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"v2")})), this.utils().part1().copy$default$2(), this.utils().part1().copy$default$3(), this.utils().part1().copy$default$4(), this.utils().part1().copy$default$5(), this.utils().part1().copy$default$6());
                CatalogTablePartition badPart2 = this.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"v4")})), this.utils().part2().copy$default$2(), this.utils().part2().copy$default$3(), this.utils().part2().copy$default$4(), this.utils().part2().copy$default$5(), this.utils().part2().copy$default$6());
                object = this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.alterPartitions("db2", "tbl2", (Seq)new .colon.colon((Object)badPart1, (List)new .colon.colon((Object)badPart2, (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
            }
            finally {
                catalog.setCurrentDatabase("default");
            }
            return object;
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
        this.test("alter partitions when database/table does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.alterPartitions("does_not_exist", "tbl1", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 753));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.alterPartitions("db2", "does_not_exist", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756))));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
        this.test("basic create and list functions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newEmptyCatalog();
            catalog.createDatabase(this.utils().newDb("mydb"), false);
            catalog.createFunction("mydb", this.utils().newFunc("myfunc", this.utils().newFunc$default$2()));
            Set $org_scalatest_assert_macro_left = catalog.listFunctions("mydb", "*").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"myfunc"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        this.test("create function when database does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchDatabaseException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createFunction("does_not_exist", this.utils().newFunc()), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
        this.test("create function that already exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (FunctionAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createFunction("db2", this.utils().newFunc("func1", this.utils().newFunc$default$2())), ClassTag$.MODULE$.apply(FunctionAlreadyExistsException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 781));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        this.test("drop function", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"func1"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
            catalog.dropFunction("db2", "func1");
            Seq $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "*");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
        this.test("drop function when database does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchDatabaseException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropFunction("does_not_exist", "something"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793));
        this.test("drop function that does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchFunctionException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.dropFunction("db2", "does_not_exist"), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
        this.test("get function", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogFunction $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1");
            CatalogFunction $org_scalatest_assert_macro_right = new CatalogFunction(FunctionIdentifier$.MODULE$.apply("func1", (Option)new Some((Object)"db2")), this.utils().funcClass(), (Seq)package$.MODULE$.Seq().empty());
            CatalogFunction catalogFunction = $org_scalatest_assert_macro_left;
            CatalogFunction catalogFunction2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogFunction != null ? !catalogFunction.equals(catalogFunction2) : catalogFunction2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 809));
            return (NoSuchFunctionException)this.intercept((Function0 & Serializable)() -> catalog.getFunction("db2", "does_not_exist"), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
        this.test("get function when database does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchDatabaseException)this.intercept((Function0 & Serializable)() -> catalog.getFunction("does_not_exist", "func1"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
        this.test("rename function", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            String newName = "funcky";
            String $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1").className();
            String $org_scalatest_assert_macro_right = this.utils().funcClass();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 827));
            catalog.renameFunction("db2", "func1", newName);
            this.intercept((Function0 & Serializable)() -> catalog.getFunction("db2", "func1"), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
            String $org_scalatest_assert_macro_left2 = catalog.getFunction("db2", newName).identifier().funcName();
            String $org_scalatest_assert_macro_right2 = newName;
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
            String $org_scalatest_assert_macro_left3 = catalog.getFunction("db2", newName).className();
            String $org_scalatest_assert_macro_right3 = this.utils().funcClass();
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
            return (NoSuchFunctionException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameFunction("db2", "does_not_exist", "me"), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
        this.test("rename function when database does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            return (NoSuchDatabaseException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameFunction("does_not_exist", "func1", "func5"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835));
        this.test("rename function when new function already exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            catalog.createFunction("db2", this.utils().newFunc("func2", (Option<String>)new Some((Object)"db2")));
            return (FunctionAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameFunction("db2", "func1", "func2"), ClassTag$.MODULE$.apply(FunctionAlreadyExistsException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
        this.test("alter function", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            String $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1").className();
            String $org_scalatest_assert_macro_right = this.utils().funcClass();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 852));
            CatalogFunction qual$2 = catalog.getFunction("db2", "func1");
            String x$95 = this.utils().newFuncClass();
            FunctionIdentifier x$96 = qual$2.copy$default$1();
            Seq x$97 = qual$2.copy$default$3();
            CatalogFunction myNewFunc = qual$2.copy(x$96, x$95, x$97);
            catalog.alterFunction("db2", myNewFunc);
            String $org_scalatest_assert_macro_left2 = catalog.getFunction("db2", "func1").className();
            String $org_scalatest_assert_macro_right2 = this.utils().newFuncClass();
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 855));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850));
        this.test("list functions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            catalog.createFunction("db2", this.utils().newFunc("func2", this.utils().newFunc$default$2()));
            catalog.createFunction("db2", this.utils().newFunc("not_me", this.utils().newFunc$default$2()));
            Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2", "not_me"}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
            Set $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "func*").toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2"}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 863));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 858));
        this.test("create/drop database should create/delete the directory", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogDatabase db = this.utils().newDb("mydb");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Nil$.MODULE$), "ExternalCatalogSuite.this.exists(db.locationUri)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881));
            catalog.createDatabase(db, false);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Nil$.MODULE$), "ExternalCatalogSuite.this.exists(db.locationUri)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
            catalog.dropDatabase("mydb", false, false);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)Nil$.MODULE$), "ExternalCatalogSuite.this.exists(db.locationUri)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 886));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
        this.test("create/drop/rename table should create/delete/rename the directory", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogDatabase db = catalog.getDatabase("db1");
            CatalogTable table = new CatalogTable(TableIdentifier$.MODULE$.apply("my_table", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("a", "int").add("b", "string"), (Option)new Some((Object)this.utils().defaultProvider()), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20(), CatalogTable$.MODULE$.apply$default$21());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"my_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"my_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
            catalog.createTable(table, false);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"my_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"my_table\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
            catalog.renameTable("db1", "my_table", "your_table");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"my_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"my_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 904));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"your_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"your_table\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
            catalog.dropTable("db1", "your_table", false, false);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"your_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"your_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 908));
            CatalogTable externalTable = new CatalogTable(TableIdentifier$.MODULE$.apply("external_table", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.EXTERNAL(), new CatalogStorageFormat((Option)new Some((Object)Utils$.MODULE$.createTempDir().toURI()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), new StructType().add("a", "int").add("b", "string"), (Option)new Some((Object)this.utils().defaultProvider()), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20(), CatalogTable$.MODULE$.apply$default$21());
            catalog.createTable(externalTable, false);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(db.locationUri(), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"external_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"external_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 920));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
        this.test("create/drop/rename partitions should create/delete/rename the directory", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            CatalogTable table = new CatalogTable(TableIdentifier$.MODULE$.apply("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.utils().defaultProvider()), (Seq)new .colon.colon((Object)"partCol1", (List)new .colon.colon((Object)"partCol2", (List)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20(), CatalogTable$.MODULE$.apply$default$21());
            catalog.createTable(table, false);
            URI tableLocation = catalog.getTable("db1", "tbl").location();
            CatalogTablePartition part1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition part2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"4")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            CatalogTablePartition part3 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"6")})), this.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)part1, (List)new .colon.colon((Object)part2, (List)Nil$.MODULE$)), false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=1", "partCol2=2"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=1\", \"partCol2=2\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 945));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=3", "partCol2=4"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=3\", \"partCol2=4\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 946));
            catalog.renamePartitions("db1", "tbl", (Seq)new .colon.colon((Object)part1.spec(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)part3.spec(), (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=1", "partCol2=2"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=1\", \"partCol2=2\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 949));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=5", "partCol2=6"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=5\", \"partCol2=6\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 950));
            catalog.dropPartitions("db1", "tbl", (Seq)new .colon.colon((Object)part2.spec(), (List)new .colon.colon((Object)part3.spec(), (List)Nil$.MODULE$)), false, false, false);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=3", "partCol2=4"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=3\", \"partCol2=4\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 954));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.exists(tableLocation, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=5", "partCol2=6"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=5\", \"partCol2=6\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 955));
            File tempPath = Utils$.MODULE$.createTempDir();
            CatalogTablePartition partWithExistingDir = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"7"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"8")})), new CatalogStorageFormat((Option)new Some((Object)tempPath.toURI()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partWithExistingDir, (List)Nil$.MODULE$), false);
            tempPath.delete();
            CatalogTablePartition partWithNonExistingDir = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"9"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"10")})), new CatalogStorageFormat((Option)new Some((Object)tempPath.toURI()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            catalog.createPartitions("db1", "tbl", (Seq)new .colon.colon((Object)partWithNonExistingDir, (List)Nil$.MODULE$), false);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(tempPath.exists(), "tempPath.exists()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 974));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
        this.test("drop partition from external table should not delete the directory", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            catalog.createPartitions("db2", "tbl1", (Seq)new .colon.colon((Object)this.utils().part1(), (List)Nil$.MODULE$), false);
            Path partPath = new Path(catalog.getPartition("db2", "tbl1", this.utils().part1().spec()).location());
            FileSystem fs = partPath.getFileSystem(new Configuration());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(fs.exists(partPath), "fs.exists(partPath)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 983));
            catalog.dropPartitions("db2", "tbl1", (Seq)new .colon.colon((Object)this.utils().part1().spec(), (List)Nil$.MODULE$), false, false, false);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(fs.exists(partPath), "fs.exists(partPath)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 977));
        this.test("SPARK-52683: support alterTableSchema partitioned columns", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ExternalCatalog catalog = this.utils().newBasicCatalog();
            StructType schema = new StructType().add("a", (DataType)IntegerType$.MODULE$).add("b", (DataType)IntegerType$.MODULE$).add("c", (DataType)StringType$.MODULE$);
            TableIdentifier x$98 = TableIdentifier$.MODULE$.apply("t", (Option)new Some((Object)"db1"));
            CatalogTableType x$99 = CatalogTableType$.MODULE$.MANAGED();
            CatalogStorageFormat x$100 = this.utils().storageFormat();
            StructType x$101 = schema;
            .colon.colon x$102 = new .colon.colon((Object)"c", (List)Nil$.MODULE$);
            Some x$103 = new Some((Object)"hive");
            Option x$104 = CatalogTable$.MODULE$.apply$default$7();
            String x$105 = CatalogTable$.MODULE$.apply$default$8();
            long x$106 = CatalogTable$.MODULE$.apply$default$9();
            long x$107 = CatalogTable$.MODULE$.apply$default$10();
            String x$108 = CatalogTable$.MODULE$.apply$default$11();
            Map x$109 = CatalogTable$.MODULE$.apply$default$12();
            Option x$110 = CatalogTable$.MODULE$.apply$default$13();
            Option x$111 = CatalogTable$.MODULE$.apply$default$14();
            Option x$112 = CatalogTable$.MODULE$.apply$default$15();
            Option x$113 = CatalogTable$.MODULE$.apply$default$16();
            Seq x$114 = CatalogTable$.MODULE$.apply$default$17();
            boolean x$115 = CatalogTable$.MODULE$.apply$default$18();
            boolean x$116 = CatalogTable$.MODULE$.apply$default$19();
            Map x$117 = CatalogTable$.MODULE$.apply$default$20();
            Option x$118 = CatalogTable$.MODULE$.apply$default$21();
            CatalogTable table = new CatalogTable(x$98, x$99, x$100, x$101, (Option)x$103, (Seq)x$102, x$104, x$105, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$117, x$118);
            catalog.createTable(table, false);
            StructType newSchema = new StructType().add("b", (DataType)LongType$.MODULE$).add("a", (DataType)IntegerType$.MODULE$).add("c", (DataType)StringType$.MODULE$);
            catalog.alterTableSchema("db1", "t", newSchema);
            StructType $org_scalatest_assert_macro_left = catalog.getTable("db1", "t").schema();
            StructType $org_scalatest_assert_macro_right = newSchema;
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1012));
            Seq $org_scalatest_assert_macro_left2 = catalog.getTable("db1", "t").partitionColumnNames();
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"c", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left2;
            .colon.colon colon2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1013));
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 990));
    }
}

