/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.csv.UnivocityParserSuite$NameId$2$;
import org.apache.spark.sql.catalyst.csv.UnivocityParserSuite$StringBasedUDT$2$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Q2Aa\u0001\u0003\u0001#!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0005C\t!RK\\5w_\u000eLG/\u001f)beN,'oU;ji\u0016T!!\u0002\u0004\u0002\u0007\r\u001chO\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9\"$D\u0001\u0019\u0015\tIb!A\u0003qY\u0006t7/\u0003\u0002\u001c1\tI1+\u0015'IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003\u0011\t!\"Y:tKJ$h*\u001e7m)\t\u0011C\u0006\u0005\u0002$S9\u0011AeJ\u0007\u0002K)\u0011aED\u0001\ng\u000e\fG.\u0019;fgRL!\u0001K\u0013\u0002\u000fA\f7m[1hK&\u0011!f\u000b\u0002\n\u0003N\u001cXM\u001d;j_:T!\u0001K\u0013\t\u000b5\u0012\u0001\u0019\u0001\u0018\u0002\u0003Y\u0004\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u00121!\u00118z\u0001")
public class UnivocityParserSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        UnivocityParserSuite univocityParserSuite = this;
        synchronized (univocityParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private Assertion assertNull(Object v) {
        Object $org_scalatest_assert_macro_left = v;
        Object $org_scalatest_assert_macro_right = null;
        Object object = $org_scalatest_assert_macro_left;
        Object var5_4 = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var5_4) : var5_4 != null), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }

    public static final /* synthetic */ Assertion $anonfun$new$8(boolean b) {
        CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)"null")})), false, "UTC");
        UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
        Function1 converter = parser.makeConverter("_1", (DataType)StringType$.MODULE$, b);
        Object $org_scalatest_assert_macro_left = converter.apply((Object)"");
        UTF8String $org_scalatest_assert_macro_right = UTF8String.fromString((String)"");
        Object object = $org_scalatest_assert_macro_left;
        UTF8String uTF8String = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(object != null ? !object.equals(uTF8String) : uTF8String != null), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    private final void checkDecimalParsing$1(String langTag) {
        BigDecimal decimalVal = new BigDecimal("1000.001");
        DecimalType decimalType = new DecimalType(10, 5);
        Decimal expected = Decimal$.MODULE$.apply(decimalVal, decimalType.precision(), decimalType.scale());
        DecimalFormat df = new DecimalFormat("", new DecimalFormatSymbols(Locale.forLanguageTag(langTag)));
        String input = df.format(expected.toBigDecimal());
        CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"locale"), (Object)langTag)})), false, "UTC");
        UnivocityParser parser = new UnivocityParser(new StructType().add("d", (DataType)decimalType), options);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(parser.makeConverter("_1", (DataType)decimalType, parser.makeConverter$default$3()).apply((Object)input));
        Decimal $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
    }

    private final /* synthetic */ UnivocityParserSuite$NameId$2$ NameId$lzycompute$1(LazyRef NameId$module$1) {
        UnivocityParserSuite$NameId$2$ univocityParserSuite$NameId$2$;
        LazyRef lazyRef = NameId$module$1;
        synchronized (lazyRef) {
            univocityParserSuite$NameId$2$ = NameId$module$1.initialized() ? (UnivocityParserSuite$NameId$2$)NameId$module$1.value() : (UnivocityParserSuite$NameId$2$)NameId$module$1.initialize((Object)new UnivocityParserSuite$NameId$2$(this));
        }
        return univocityParserSuite$NameId$2$;
    }

    private final UnivocityParserSuite$NameId$2$ NameId$3(LazyRef NameId$module$1) {
        if (NameId$module$1.initialized()) {
            return (UnivocityParserSuite$NameId$2$)NameId$module$1.value();
        }
        return this.NameId$lzycompute$1(NameId$module$1);
    }

    private final /* synthetic */ UnivocityParserSuite$StringBasedUDT$2$ StringBasedUDT$lzycompute$1(LazyRef StringBasedUDT$module$1) {
        UnivocityParserSuite$StringBasedUDT$2$ univocityParserSuite$StringBasedUDT$2$;
        LazyRef lazyRef = StringBasedUDT$module$1;
        synchronized (lazyRef) {
            univocityParserSuite$StringBasedUDT$2$ = StringBasedUDT$module$1.initialized() ? (UnivocityParserSuite$StringBasedUDT$2$)((Object)StringBasedUDT$module$1.value()) : (UnivocityParserSuite$StringBasedUDT$2$)((Object)StringBasedUDT$module$1.initialize((Object)new UnivocityParserSuite$StringBasedUDT$2$(this)));
        }
        return univocityParserSuite$StringBasedUDT$2$;
    }

    private final UnivocityParserSuite$StringBasedUDT$2$ StringBasedUDT$3(LazyRef StringBasedUDT$module$1) {
        if (StringBasedUDT$module$1.initialized()) {
            return (UnivocityParserSuite$StringBasedUDT$2$)((Object)StringBasedUDT$module$1.value());
        }
        return this.StringBasedUDT$lzycompute$1(StringBasedUDT$module$1);
    }

    public static final /* synthetic */ Assertion $anonfun$new$24(UnivocityParserSuite $this, StructType dataSchema$1, StructType requiredSchema$1, Seq filters$1, String input$2, Option expected$1, boolean columnPruning) {
        CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), columnPruning, "UTC");
        UnivocityParser parser = new UnivocityParser(dataSchema$1, requiredSchema$1, options, filters$1);
        Option actual = (Option)parser.parse().apply((Object)input$2);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(actual);
        Option $org_scalatest_assert_macro_right = expected$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
    }

    private final void check$1(String input, StructType dataSchema, StructType requiredSchema, Seq filters, Option expected) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)columnPruning -> UnivocityParserSuite.$anonfun$new$24(this, dataSchema, requiredSchema, filters, input, expected, BoxesRunTime.unboxToBoolean((Object)columnPruning)));
    }

    private static final String check$default$1$1() {
        return "1,a";
    }

    private static final StructType check$default$2$1() {
        return StructType$.MODULE$.fromDDL("i INTEGER, s STRING");
    }

    private static final StructType check$default$3$1() {
        return StructType$.MODULE$.fromDDL("i INTEGER");
    }

    private final BadRecordException checkBadRecord$1(String input, StructType dataSchema, StructType requiredSchema, Map options) {
        CSVOptions csvOptions = new CSVOptions(options, false, "UTC");
        UnivocityParser parser = new UnivocityParser(dataSchema, requiredSchema, csvOptions, (Seq)Nil$.MODULE$);
        return (BadRecordException)this.intercept((Function0 & Serializable)() -> (Option)parser.parse().apply((Object)input), ClassTag$.MODULE$.apply(BadRecordException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
    }

    private static final String checkBadRecord$default$1$1() {
        return "1,a";
    }

    private static final StructType checkBadRecord$default$2$1() {
        return StructType$.MODULE$.fromDDL("i INTEGER, s STRING, d DOUBLE");
    }

    private static final StructType checkBadRecord$default$3$1() {
        return StructType$.MODULE$.fromDDL("i INTEGER, s STRING");
    }

    private static final Map checkBadRecord$default$4$1() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"PERMISSIVE")}));
    }

    private static final void check$2(UnivocityParser parser) {
        Object $org_scalatest_assert_macro_left = parser.makeConverter("t", (DataType)TimestampType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12 12:3:45");
        long $org_scalatest_assert_macro_right = DateTimeTestUtils$.MODULE$.date(2020, (byte)1, (byte)12, (byte)12, (byte)3, (byte)45, 0, DateTimeTestUtils$.MODULE$.date$default$8());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        Object $org_scalatest_assert_macro_left2 = parser.makeConverter("t", (DataType)DateType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12");
        int $org_scalatest_assert_macro_right2 = DateTimeTestUtils$.MODULE$.days(2020, (byte)1, (byte)12);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        Object $org_scalatest_assert_macro_left3 = parser.makeConverter("t", (DataType)TimestampType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12 12:3:45.1");
        long $org_scalatest_assert_macro_right3 = DateTimeTestUtils$.MODULE$.date(2020, (byte)1, (byte)12, (byte)12, (byte)3, (byte)45, 100000, DateTimeTestUtils$.MODULE$.date$default$8());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        Object $org_scalatest_assert_macro_left4 = parser.makeConverter("t", (DataType)TimestampType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12 12:3:45.1234");
        long $org_scalatest_assert_macro_right4 = DateTimeTestUtils$.MODULE$.date(2020, (byte)1, (byte)12, (byte)12, (byte)3, (byte)45, 123400, DateTimeTestUtils$.MODULE$.date$default$8());
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left4, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        Object $org_scalatest_assert_macro_left5 = parser.makeConverter("t", (DataType)DateType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12T");
        int $org_scalatest_assert_macro_right5 = DateTimeTestUtils$.MODULE$.days(2020, (byte)1, (byte)12);
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left5, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        Object $org_scalatest_assert_macro_left6 = parser.makeConverter("t", (DataType)DateType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12Txyz");
        int $org_scalatest_assert_macro_right6 = DateTimeTestUtils$.MODULE$.days(2020, (byte)1, (byte)12);
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left6, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        Object $org_scalatest_assert_macro_left7 = parser.makeConverter("t", (DataType)DateType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12 ");
        int $org_scalatest_assert_macro_right7 = DateTimeTestUtils$.MODULE$.days(2020, (byte)1, (byte)12);
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left7, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left7, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
        Object $org_scalatest_assert_macro_left8 = parser.makeConverter("t", (DataType)DateType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12 xyz");
        int $org_scalatest_assert_macro_right8 = DateTimeTestUtils$.MODULE$.days(2020, (byte)1, (byte)12);
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left8, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left8, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        Object $org_scalatest_assert_macro_left9 = parser.makeConverter("t", (DataType)TimestampType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12 12:3:45GMT");
        long $org_scalatest_assert_macro_right9 = DateTimeTestUtils$.MODULE$.date(2020, (byte)1, (byte)12, (byte)12, (byte)3, (byte)45, 0, DateTimeTestUtils$.MODULE$.date$default$8());
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left9, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left9, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
        Object $org_scalatest_assert_macro_left10 = parser.makeConverter("t", (DataType)TimestampType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"GMT2020-1-12 12:3:45");
        long $org_scalatest_assert_macro_right10 = DateTimeTestUtils$.MODULE$.date(2020, (byte)1, (byte)12, (byte)12, (byte)3, (byte)45, 0, DateTimeTestUtils$.MODULE$.date$default$8());
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left10, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left10, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        Object $org_scalatest_assert_macro_left11 = parser.makeConverter("t", (DataType)DateType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"2020-1-12GMT");
        int $org_scalatest_assert_macro_right11 = DateTimeTestUtils$.MODULE$.days(2020, (byte)1, (byte)12);
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left11, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left11, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        Object $org_scalatest_assert_macro_left12 = parser.makeConverter("t", (DataType)DateType$.MODULE$, parser.makeConverter$default$3()).apply((Object)"GMT2020-1-12");
        int $org_scalatest_assert_macro_right12 = DateTimeTestUtils$.MODULE$.days(2020, (byte)1, (byte)12);
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left12, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left12, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
    }

    private static final CSVOptions optionsWithPattern$1(boolean enableFallback) {
        return new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"invalid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"invalid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"enableDateTimeParsingFallback"), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)enableFallback)))})), false, "UTC");
    }

    public UnivocityParserSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.test("Can parse decimal type values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon stringValues = new .colon.colon((Object)"10.05", (List)new .colon.colon((Object)"1,000.01", (List)new .colon.colon((Object)"158,058,049.001", (List)Nil$.MODULE$)));
            Seq decimalValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{10.05, 1000.01, 1.58058049001E8}));
            DecimalType decimalType = new DecimalType();
            ((IterableOnceOps)stringValues.zip((IterableOnce)decimalValues)).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String strVal = (String)tuple2._1();
                    double decimalVal = tuple2._2$mcD$sp();
                    BigDecimal decimalValue = new BigDecimal(Double.toString(decimalVal));
                    CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
                    UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(parser.makeConverter("_1", (DataType)decimalType, parser.makeConverter$default$3()).apply((Object)strVal));
                    Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(decimalValue, decimalType.precision(), decimalType.scale());
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("Nullable types are handled", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq types = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, BooleanType$.MODULE$, DecimalType$.MODULE$.DoubleDecimal(), TimestampType$.MODULE$, DateType$.MODULE$, StringType$.MODULE$}));
            types.foreach((Function1 & Serializable)t -> {
                CSVOptions nullValueOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)"-")})), false, "UTC");
                UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), nullValueOptions);
                Function1 converter = parser.makeConverter("_1", (DataType)t, true);
                this.assertNull(converter.apply((Object)"-"));
                this.assertNull(converter.apply(null));
                CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
                parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
                return this.assertNull(parser.makeConverter("_1", (DataType)t, true).apply((Object)""));
            });
            types.foreach((Function1 & Serializable)t -> {
                String message;
                CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)"-")})), false, "UTC");
                UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
                Function1 converter = parser.makeConverter("_1", (DataType)t, false);
                String $org_scalatest_assert_macro_left = message = ((Throwable)this.intercept((Function0 & Serializable)() -> converter.apply((Object)"-"), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78))).getMessage();
                String $org_scalatest_assert_macro_right = "null value found but field _1 is not nullable.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                String $org_scalatest_assert_macro_left2 = message = ((Throwable)this.intercept((Function0 & Serializable)() -> converter.apply(null), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82))).getMessage();
                String $org_scalatest_assert_macro_right2 = "null value found but field _1 is not nullable.";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            });
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)b -> UnivocityParserSuite.$anonfun$new$8(BoxesRunTime.unboxToBoolean((Object)b)));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("Throws exception for empty string with non null type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
            RuntimeException exception = (RuntimeException)this.intercept((Function0 & Serializable)() -> parser.makeConverter("_1", (DataType)IntegerType$.MODULE$, false).apply((Object)""), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "null value found but field _1 is not nullable.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("Types are cast correctly", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object castedDate;
            Object castedTimestamp;
            UnivocityParser parser;
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            UnivocityParser qual$1 = parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
            String x$1 = "_1";
            ByteType$ x$2 = ByteType$.MODULE$;
            boolean x$3 = qual$1.makeConverter$default$3();
            Object $org_scalatest_assert_macro_left = qual$1.makeConverter("_1", (DataType)x$2, x$3).apply((Object)"10");
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            UnivocityParser qual$2 = parser;
            String x$4 = "_1";
            ShortType$ x$5 = ShortType$.MODULE$;
            boolean x$6 = qual$2.makeConverter$default$3();
            Object $org_scalatest_assert_macro_left2 = qual$2.makeConverter("_1", (DataType)x$5, x$6).apply((Object)"10");
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left2, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            UnivocityParser qual$3 = parser;
            String x$7 = "_1";
            IntegerType$ x$8 = IntegerType$.MODULE$;
            boolean x$9 = qual$3.makeConverter$default$3();
            Object $org_scalatest_assert_macro_left3 = qual$3.makeConverter("_1", (DataType)x$8, x$9).apply((Object)"10");
            int $org_scalatest_assert_macro_right3 = 10;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left3, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            UnivocityParser qual$4 = parser;
            String x$10 = "_1";
            LongType$ x$11 = LongType$.MODULE$;
            boolean x$12 = qual$4.makeConverter$default$3();
            Object $org_scalatest_assert_macro_left4 = qual$4.makeConverter("_1", (DataType)x$11, x$12).apply((Object)"10");
            int $org_scalatest_assert_macro_right4 = 10;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left4, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            UnivocityParser qual$5 = parser;
            String x$13 = "_1";
            FloatType$ x$14 = FloatType$.MODULE$;
            boolean x$15 = qual$5.makeConverter$default$3();
            Object $org_scalatest_assert_macro_left5 = qual$5.makeConverter("_1", (DataType)x$14, x$15).apply((Object)"1.00");
            double $org_scalatest_assert_macro_right5 = 1.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left5, (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            UnivocityParser qual$6 = parser;
            String x$16 = "_1";
            DoubleType$ x$17 = DoubleType$.MODULE$;
            boolean x$18 = qual$6.makeConverter$default$3();
            Object $org_scalatest_assert_macro_left6 = qual$6.makeConverter("_1", (DataType)x$17, x$18).apply((Object)"1.00");
            double $org_scalatest_assert_macro_right6 = 1.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left6, (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            UnivocityParser qual$7 = parser;
            String x$19 = "_1";
            BooleanType$ x$20 = BooleanType$.MODULE$;
            boolean x$21 = qual$7.makeConverter$default$3();
            Object $org_scalatest_assert_macro_left7 = qual$7.makeConverter("_1", (DataType)x$20, x$21).apply((Object)"true");
            boolean $org_scalatest_assert_macro_right7 = true;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left7, "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left7, (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            CSVOptions timestampsOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"dd/MM/yyyy HH:mm")})), false, "UTC");
            parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), timestampsOptions);
            String customTimestamp = "31/01/2015 00:00";
            FastDateFormat format = FastDateFormat.getInstance((String)((String)timestampsOptions.timestampFormatInRead().get()), (TimeZone)TimeZone.getTimeZone(timestampsOptions.zoneId()), (Locale)timestampsOptions.locale());
            long expectedTime = format.parse(customTimestamp).getTime();
            Object $org_scalatest_assert_macro_left8 = castedTimestamp = parser.makeConverter("_1", (DataType)TimestampType$.MODULE$, true).apply((Object)customTimestamp);
            long $org_scalatest_assert_macro_right8 = expectedTime * 1000L;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left8, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left8, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            String customDate = "31/01/2015";
            CSVOptions dateOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"dd/MM/yyyy")})), false, "UTC");
            parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), dateOptions);
            format = FastDateFormat.getInstance((String)((String)dateOptions.dateFormatInRead().get()), (TimeZone)TimeZone.getTimeZone(dateOptions.zoneId()), (Locale)dateOptions.locale());
            long expectedDate = DateTimeUtils$.MODULE$.millisToMicros(format.parse(customDate).getTime());
            Object $org_scalatest_assert_macro_left9 = castedDate = parser.makeConverter("_1", (DataType)DateType$.MODULE$, true).apply((Object)customDate);
            int $org_scalatest_assert_macro_right9 = DateTimeUtils$.MODULE$.microsToDays(expectedDate, DateTimeTestUtils$.MODULE$.UTC());
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left9, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left9, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            String timestamp = "2015-01-01 00:00:00";
            timestampsOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampFormat"), (Object)"yyyy-MM-dd HH:mm:ss"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dateFormat"), (Object)"yyyy-MM-dd")})), false, "UTC");
            parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), timestampsOptions);
            long expected = 1420070400000000L;
            UnivocityParser qual$8 = parser;
            String x$22 = "_1";
            TimestampType$ x$23 = TimestampType$.MODULE$;
            boolean x$24 = qual$8.makeConverter$default$3();
            Object $org_scalatest_assert_macro_left10 = qual$8.makeConverter("_1", (DataType)x$23, x$24).apply((Object)timestamp);
            long $org_scalatest_assert_macro_right10 = expected;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left10, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left10, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            UnivocityParser qual$9 = parser;
            String x$25 = "_1";
            DateType$ x$26 = DateType$.MODULE$;
            boolean x$27 = qual$9.makeConverter$default$3();
            Object $org_scalatest_assert_macro_left11 = qual$9.makeConverter("_1", (DataType)x$26, x$27).apply((Object)"2015-01-01");
            long $org_scalatest_assert_macro_right11 = expected / 86400000000L;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left11, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left11, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("Throws exception for casting an invalid string to Float and Double Types", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
            .colon.colon types = new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)Nil$.MODULE$));
            .colon.colon input = new .colon.colon((Object)"10u000", (List)new .colon.colon((Object)"abc", (List)new .colon.colon((Object)"1 2/3", (List)Nil$.MODULE$)));
            types.foreach(arg_0 -> UnivocityParserSuite.$anonfun$new$13$adapted(this, (Seq)input, parser, arg_0));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("Float NaN values are parsed correctly", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            float floatVal;
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nanValue"), (Object)"nn")})), false, "UTC");
            UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
            float $org_scalatest_assert_macro_left = floatVal = BoxesRunTime.unboxToFloat((Object)parser.makeConverter("_1", (DataType)FloatType$.MODULE$, true).apply((Object)"nn"));
            float $org_scalatest_assert_macro_right = floatVal;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "!=", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left != $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("Double NaN values are parsed correctly", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nanValue"), (Object)"-")})), false, "UTC");
            UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
            double doubleVal = BoxesRunTime.unboxToDouble((Object)parser.makeConverter("_1", (DataType)DoubleType$.MODULE$, true).apply((Object)"-"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Double.isNaN(doubleVal), "scala.Predef.double2Double(doubleVal).isNaN()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("Float infinite values can be parsed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            float floatVal2;
            float floatVal1;
            CSVOptions negativeInfOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"negativeInf"), (Object)"max")})), false, "UTC");
            UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), negativeInfOptions);
            float $org_scalatest_assert_macro_left = floatVal1 = BoxesRunTime.unboxToFloat((Object)parser.makeConverter("_1", (DataType)FloatType$.MODULE$, true).apply((Object)"max"));
            float $org_scalatest_assert_macro_right = Float.NEGATIVE_INFINITY;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            CSVOptions positiveInfOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"positiveInf"), (Object)"max")})), false, "UTC");
            parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), positiveInfOptions);
            float $org_scalatest_assert_macro_left2 = floatVal2 = BoxesRunTime.unboxToFloat((Object)parser.makeConverter("_1", (DataType)FloatType$.MODULE$, true).apply((Object)"max"));
            float $org_scalatest_assert_macro_right2 = Float.POSITIVE_INFINITY;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.test("Double infinite values can be parsed", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            double doubleVal2;
            double doubleVal1;
            CSVOptions negativeInfOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"negativeInf"), (Object)"max")})), false, "UTC");
            UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), negativeInfOptions);
            double $org_scalatest_assert_macro_left = doubleVal1 = BoxesRunTime.unboxToDouble((Object)parser.makeConverter("_1", (DataType)DoubleType$.MODULE$, true).apply((Object)"max"));
            double $org_scalatest_assert_macro_right = Double.NEGATIVE_INFINITY;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            CSVOptions positiveInfOptions = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"positiveInf"), (Object)"max")})), false, "UTC");
            parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), positiveInfOptions);
            double $org_scalatest_assert_macro_left2 = doubleVal2 = BoxesRunTime.unboxToDouble((Object)parser.makeConverter("_1", (DataType)DoubleType$.MODULE$, true).apply((Object)"max"));
            double $org_scalatest_assert_macro_right2 = Double.POSITIVE_INFINITY;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("parse decimals using locale", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"en-US", (List)new .colon.colon((Object)"ko-KR", (List)new .colon.colon((Object)"ru-RU", (List)new .colon.colon((Object)"de-DE", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)langTag -> {
            this.checkDecimalParsing$1(langTag);
            return BoxedUnit.UNIT;
        }), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("SPARK-27591 UserDefinedType can be read", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object convertedValue;
            LazyRef NameId$module = new LazyRef();
            LazyRef StringBasedUDT$module = new LazyRef();
            String input = "name\t42";
            UTF8String expected = UTF8String.fromString((String)input);
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            UnivocityParser parser = new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options);
            Object $org_scalatest_assert_macro_left = convertedValue = parser.makeConverter("_1", (DataType)this.StringBasedUDT$3(StringBasedUDT$module), false).apply((Object)input);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.unsafe.types.UTF8String", $org_scalatest_assert_macro_left instanceof UTF8String, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            Object $org_scalatest_assert_macro_left2 = convertedValue;
            UTF8String $org_scalatest_assert_macro_right = expected;
            Object object = $org_scalatest_assert_macro_left2;
            UTF8String uTF8String = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(object != null ? !object.equals(uTF8String) : uTF8String != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        this.test("skipping rows using pushdown filters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq x$28 = (Seq)Nil$.MODULE$;
            Some x$29 = new Some((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            String x$30 = UnivocityParserSuite.check$default$1$1();
            StructType x$31 = UnivocityParserSuite.check$default$2$1();
            StructType x$32 = UnivocityParserSuite.check$default$3$1();
            this.check$1(x$30, x$31, x$32, x$28, (Option)x$29);
            .colon.colon x$33 = new .colon.colon((Object)new EqualTo("i", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$);
            Some x$34 = new Some((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            String x$35 = UnivocityParserSuite.check$default$1$1();
            StructType x$36 = UnivocityParserSuite.check$default$2$1();
            StructType x$37 = UnivocityParserSuite.check$default$3$1();
            this.check$1(x$35, x$36, x$37, (Seq)x$33, (Option)x$34);
            .colon.colon x$38 = new .colon.colon((Object)new EqualTo("i", (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$);
            None$ x$39 = None$.MODULE$;
            String x$40 = UnivocityParserSuite.check$default$1$1();
            StructType x$41 = UnivocityParserSuite.check$default$2$1();
            StructType x$42 = UnivocityParserSuite.check$default$3$1();
            this.check$1(x$40, x$41, x$42, (Seq)x$38, (Option)x$39);
            StructType x$43 = StructType$.MODULE$.fromDDL("s STRING");
            .colon.colon x$44 = new .colon.colon((Object)new StringStartsWith("s", "b"), (List)Nil$.MODULE$);
            None$ x$45 = None$.MODULE$;
            String x$46 = UnivocityParserSuite.check$default$1$1();
            StructType x$47 = UnivocityParserSuite.check$default$2$1();
            this.check$1(x$46, x$47, x$43, (Seq)x$44, (Option)x$45);
            StructType x$48 = StructType$.MODULE$.fromDDL("i INTEGER, s STRING");
            .colon.colon x$49 = new .colon.colon((Object)new StringStartsWith("s", "a"), (List)Nil$.MODULE$);
            Some x$50 = new Some((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"a")})));
            String x$51 = UnivocityParserSuite.check$default$1$1();
            StructType x$52 = UnivocityParserSuite.check$default$2$1();
            this.check$1(x$51, x$52, x$48, (Seq)x$49, (Option)x$50);
            this.check$1("1,a,3.14", StructType$.MODULE$.fromDDL("i INTEGER, s STRING, d DOUBLE"), StructType$.MODULE$.fromDDL("i INTEGER, d DOUBLE"), (Seq)new .colon.colon((Object)new EqualTo("d", (Object)BoxesRunTime.boxToDouble((double)3.14)), (List)Nil$.MODULE$), (Option)new Some((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)3.14)}))));
            SparkIllegalArgumentException x$58 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                .colon.colon x$53 = new .colon.colon((Object)new EqualTo("invalid attr", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$);
                None$ x$54 = None$.MODULE$;
                String x$55 = UnivocityParserSuite.check$default$1$1();
                StructType x$56 = UnivocityParserSuite.check$default$2$1();
                StructType x$57 = UnivocityParserSuite.check$default$3$1();
                this.check$1(x$55, x$56, x$57, (Seq)x$53, (Option)x$54);
            }, ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308))));
            String x$59 = "FIELD_NOT_FOUND";
            Map x$60 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`invalid attr`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"`i`")}));
            Option x$61 = this.checkError$default$3();
            boolean x$62 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$63 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$58, "FIELD_NOT_FOUND", x$61, x$60, x$62, x$63);
            SparkIllegalArgumentException x$69 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                StructType x$64 = new StructType();
                StructType x$65 = new StructType();
                .colon.colon x$66 = new .colon.colon((Object)new EqualTo("i", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$);
                Some x$67 = new Some((Object)InternalRow$.MODULE$.empty());
                String x$68 = UnivocityParserSuite.check$default$1$1();
                this.check$1(x$68, x$64, x$65, (Seq)x$66, (Option)x$67);
            }, ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315))));
            String x$70 = "FIELD_NOT_FOUND";
            Map x$71 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`i`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"")}));
            Option x$72 = this.checkError$default$3();
            boolean x$73 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$74 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$69, "FIELD_NOT_FOUND", x$72, x$71, x$73, x$74);
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("Bad records test in permissive mode", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.checkBadRecord$1("1.5,a,10.3", UnivocityParserSuite.checkBadRecord$default$2$1(), UnivocityParserSuite.checkBadRecord$default$3$1(), UnivocityParserSuite.checkBadRecord$default$4$1());
            return this.checkBadRecord$1("2", UnivocityParserSuite.checkBadRecord$default$2$1(), UnivocityParserSuite.checkBadRecord$default$3$1(), UnivocityParserSuite.checkBadRecord$default$4$1());
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        this.test("Array index out of bounds when parsing CSV with more columns than expected", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String input = "1,string,3.14,5,7";
            StructType dataSchema = StructType$.MODULE$.fromDDL("i INTEGER, a STRING");
            StructType requiredSchema = StructType$.MODULE$.fromDDL("i INTEGER, a STRING");
            CSVOptions options = new CSVOptions((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxColumns"), (Object)"2")})), false, "UTC");
            Seq filters = (Seq)Nil$.MODULE$;
            UnivocityParser parser = new UnivocityParser(dataSchema, requiredSchema, options, filters);
            SparkRuntimeException x$75 = (SparkRuntimeException)this.intercept((Function0 & Serializable)() -> (Option)parser.parse().apply((Object)input), ClassTag$.MODULE$.apply(SparkRuntimeException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            String x$76 = "MALFORMED_CSV_RECORD";
            Map x$77 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"badRecord"), (Object)"1,string,3.14,5,7")}));
            Option x$78 = this.checkError$default$3();
            boolean x$79 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$80 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$75, "MALFORMED_CSV_RECORD", x$78, x$77, x$79, x$80);
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        this.test("SPARK-30960: parse date/timestamp string with legacy format", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            CSVOptions options = new CSVOptions(Predef$.MODULE$.Map().empty(), false, "UTC");
            UnivocityParserSuite.check$2(new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), options));
            UnivocityParserSuite.check$2(new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), UnivocityParserSuite.optionsWithPattern$1(true)));
            SparkIllegalArgumentException x$81 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> UnivocityParserSuite.check$2(new UnivocityParser(StructType$.MODULE$.apply((Seq)package$.MODULE$.Seq().empty()), UnivocityParserSuite.optionsWithPattern$1(false))), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409))));
            String x$82 = "INVALID_DATETIME_PATTERN.ILLEGAL_CHARACTER";
            Map x$83 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"n"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), (Object)"invalid")}));
            Option x$84 = this.checkError$default$3();
            boolean x$85 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$86 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$81, "INVALID_DATETIME_PATTERN.ILLEGAL_CHARACTER", x$84, x$83, x$85, x$86);
        }, new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
    }

    public static final /* synthetic */ Object $anonfun$new$13$adapted(UnivocityParserSuite $this, Seq input$1, UnivocityParser parser$2, FractionalType dt) {
        input$1.foreach((Function1 & Serializable)v -> {
            String message;
            String $org_scalatest_assert_macro_left = message = ((Throwable)$this.intercept((Function0 & Serializable)() -> parser$2.makeConverter("_1", (DataType)dt, parser$2.makeConverter$default$3()).apply(v), ClassTag$.MODULE$.apply(NumberFormatException.class), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162))).getMessage();
            String $org_scalatest_assert_macro_right = v;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnivocityParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        });
        return BoxedUnit.UNIT;
    }
}

