/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkArithmeticException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.CastSuiteBase;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0007\u000f\u0001mAQA\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005B)BQ!\u000e\u0001\u0005\u0012YBQa\u000f\u0001\u0005\nqBQ\u0001\u0011\u0001\u0005\n\u0005CQA\u0013\u0001\u0005\n-CQ!\u0014\u0001\u0005\n9Cqa\u0019\u0001\u0012\u0002\u0013%A\rC\u0003N\u0001\u0011%q\u000eC\u0003x\u0001\u0011E\u0001\u0010\u0003\u0004\u0000\u0001\u0011E\u0011\u0011\u0001\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0005M\u0019\u0015m\u001d;XSRD\u0017I\\:j\u001f:\u001cV/\u001b;f\u0015\ty\u0001#A\u0006fqB\u0014Xm]:j_:\u001c(BA\t\u0013\u0003!\u0019\u0017\r^1msN$(BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\tQa\u001d9be.T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dAA\u0011QDH\u0007\u0002\u001d%\u0011qD\u0004\u0002\u000e\u0007\u0006\u001cHoU;ji\u0016\u0014\u0015m]3\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\u0012\u0012AB3se>\u00148/\u0003\u0002&E\ty\u0011+^3ss\u0016\u0013(o\u001c:t\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011Q\u0004A\u0001\tKZ\fG.T8eKV\t1\u0006\u0005\u0002-_9\u0011Q$L\u0005\u0003]9\t\u0001\"\u0012<bY6{G-Z\u0005\u0003aE\u0012QAV1mk\u0016L!AM\u001a\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0006\u0002i\u0005)1oY1mC\u0006Y3\r[3dW&sg/\u00197jI\u000e\u000b7\u000f\u001e$s_6tU/\\3sS\u000e$\u0016\u0010]3U_\nKg.\u0019:z)f\u0004X\rF\u00018!\tA\u0014(D\u00014\u0013\tQ4G\u0001\u0003V]&$\u0018!C5t)JL8)Y:u+\u0005i\u0004C\u0001\u001d?\u0013\ty4GA\u0004C_>dW-\u00198\u0002!Q,7\u000f^%oi6\u000b\u00070\u00118e\u001b&tGCA\u001cC\u0011\u0015\u0019U\u00011\u0001E\u0003\t!G\u000f\u0005\u0002F\u00116\taI\u0003\u0002H%\u0005)A/\u001f9fg&\u0011\u0011J\u0012\u0002\t\t\u0006$\u0018\rV=qK\u0006\tB/Z:u\u0019>tw-T1y\u0003:$W*\u001b8\u0015\u0005]b\u0005\"B\"\u0007\u0001\u0004!\u0015AC2bgR,%O]'tOR!qJW0b!\t\u0001vK\u0004\u0002R+B\u0011!kM\u0007\u0002'*\u0011AKG\u0001\u0007yI|w\u000e\u001e \n\u0005Y\u001b\u0014A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV\u001a\t\u000bm;\u0001\u0019\u0001/\u0002\u0003Y\u0004\"\u0001O/\n\u0005y\u001b$aA!os\")\u0001m\u0002a\u0001\t\u0006\u0011Ao\u001c\u0005\bE\u001e\u0001\n\u00111\u0001E\u0003\u00111'o\\7\u0002)\r\f7\u000f^#se6\u001bx\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005)'F\u0001#gW\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003%)hn\u00195fG.,GM\u0003\u0002mg\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00059L'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKR!q\n];w\u0011\u0015\t\u0018\u00021\u0001s\u0003\u0005a\u0007CA\u000ft\u0013\t!hBA\u0004MSR,'/\u00197\t\u000b\u0001L\u0001\u0019\u0001#\t\u000b\tL\u0001\u0019\u0001#\u0002/\rDWmY6DCN$Hk\u001c(v[\u0016\u0014\u0018nY#se>\u0014H#B\u001czunl\b\"B9\u000b\u0001\u0004\u0011\b\"\u00021\u000b\u0001\u0004!\u0005\"\u0002?\u000b\u0001\u0004!\u0015AG3ya\u0016\u001cG/\u001a3ECR\fG+\u001f9f\u0013:,%O]8s\u001bN<\u0007\"\u0002@\u000b\u0001\u0004a\u0016!\u0004;ss\u000e\u000b7\u000f\u001e*fgVdG/A\fdQ\u0016\u001c7nQ1tiR{'i\\8mK\u0006tWI\u001d:peR9q'a\u0001\u0002\u0006\u0005\u001d\u0001\"B9\f\u0001\u0004\u0011\b\"\u00021\f\u0001\u0004!\u0005\"\u0002@\f\u0001\u0004a\u0016AE2bgR|e/\u001a:gY><XI\u001d:Ng\u001e$raTA\u0007\u0003\u001f\t\t\u0002C\u0003\\\u0019\u0001\u0007A\fC\u0003c\u0019\u0001\u0007A\tC\u0003a\u0019\u0001\u0007A\t")
public class CastWithAnsiOnSuite
extends CastSuiteBase
implements QueryErrorsBase {
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$((QueryErrorsBase)this, (String)conf);
    }

    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (Expression)e);
    }

    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$((QueryErrorsBase)this, (int)i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public Enumeration.Value evalMode() {
        return EvalMode$.MODULE$.ANSI();
    }

    public void checkInvalidCastFromNumericTypeToBinaryType() {
        Map configParams = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configVal"), (Object)this.toSQLValue("false", (DataType)StringType$.MODULE$))}));
        this.checkNumericTypeCast$1(BoxesRunTime.boxToByte((byte)((byte)1)), (DataType)ByteType$.MODULE$, (DataType)BinaryType$.MODULE$, "CAST_WITH_CONF_SUGGESTION", configParams);
        this.checkNumericTypeCast$1(BoxesRunTime.boxToShort((short)((short)1)), (DataType)ShortType$.MODULE$, (DataType)BinaryType$.MODULE$, "CAST_WITH_CONF_SUGGESTION", configParams);
        this.checkNumericTypeCast$1(BoxesRunTime.boxToInteger((int)1), (DataType)IntegerType$.MODULE$, (DataType)BinaryType$.MODULE$, "CAST_WITH_CONF_SUGGESTION", configParams);
        this.checkNumericTypeCast$1(BoxesRunTime.boxToLong((long)1L), (DataType)LongType$.MODULE$, (DataType)BinaryType$.MODULE$, "CAST_WITH_CONF_SUGGESTION", configParams);
        this.checkNumericTypeCast$1(BoxesRunTime.boxToFloat((float)1.0f), (DataType)FloatType$.MODULE$, (DataType)BinaryType$.MODULE$, "CAST_WITHOUT_SUGGESTION", CastWithAnsiOnSuite.checkNumericTypeCast$default$5$1());
        this.checkNumericTypeCast$1(BoxesRunTime.boxToDouble((double)1.0), (DataType)DoubleType$.MODULE$, (DataType)BinaryType$.MODULE$, "CAST_WITHOUT_SUGGESTION", CastWithAnsiOnSuite.checkNumericTypeCast$default$5$1());
    }

    private boolean isTryCast() {
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.TRY();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private void testIntMaxAndMin(DataType dt) {
        .colon.colon $org_scalatest_assert_macro_left = new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)ByteType$.MODULE$, (List)Nil$.MODULE$)));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0x80000000L, -2147483649L})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)value -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Decimal$.MODULE$.apply(Long.toString(value)), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)((float)value * 1.5f)), (DataType)FloatType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), dt, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        });
    }

    private void testLongMaxAndMin(DataType dt) {
        .colon.colon $org_scalatest_assert_macro_left = new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
        DataType $org_scalatest_assert_macro_right = dt;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        new .colon.colon((Object)Decimal$.MODULE$.apply(Long.MAX_VALUE).$plus(Decimal$.MODULE$.apply(1)), (List)new .colon.colon((Object)Decimal$.MODULE$.apply(Long.MIN_VALUE).$minus(Decimal$.MODULE$.apply(1)), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)value -> {
            CastWithAnsiOnSuite.$anonfun$testLongMaxAndMin$1(this, dt, value);
            return BoxedUnit.UNIT;
        });
    }

    private String castErrMsg(Object v, DataType to, DataType from) {
        return "The value " + this.toSQLValue(v, from) + " of the type " + this.toSQLType((AbstractDataType)from) + " cannot be cast to " + this.toSQLType((AbstractDataType)to) + " because it is malformed.";
    }

    private String castErrMsg(Literal l, DataType to, DataType from) {
        return "The value " + this.toSQLValue(l.eval(l.eval$default$1()), from) + " of the type " + this.toSQLType((AbstractDataType)from) + " cannot be cast to " + this.toSQLType((AbstractDataType)to) + " because it is malformed.";
    }

    private DataType castErrMsg$default$3() {
        return StringType$.MODULE$;
    }

    public void checkCastToNumericError(Literal l, DataType to, DataType expectedDataTypeInErrorMsg, Object tryCastResult) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(l, to, this.cast$default$3()), this.castErrMsg("true", expectedDataTypeInErrorMsg, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    public void checkCastToBooleanError(Literal l, DataType to, Object tryCastResult) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(l, to, this.cast$default$3()), "cannot be cast to \"BOOLEAN\"", ClassTag$.MODULE$.apply(SparkRuntimeException.class));
    }

    private String castOverflowErrMsg(Object v, DataType from, DataType to) {
        return "The value " + this.toSQLValue(v, from) + " of the type " + this.toSQLType((AbstractDataType)from) + " cannot be cast to " + this.toSQLType((AbstractDataType)to) + " due to an overflow.";
    }

    private final void checkNumericTypeCast$1(Object testValue, DataType srcType, DataType to, String expectedErrorClass, Map extraParams) {
        TypeCheckResult.DataTypeMismatch expectedError = this.createCastMismatch(srcType, to, expectedErrorClass, (Map<String, String>)extraParams);
        TypeCheckResult $org_scalatest_assert_macro_left = this.cast(testValue, to, this.cast$default$3()).checkInputDataTypes();
        TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = expectedError;
        TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
        TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    private static final Map checkNumericTypeCast$default$5$1() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ void $anonfun$testLongMaxAndMin$1(CastWithAnsiOnSuite $this, DataType dt$2, Decimal value) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(value, dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(BoxesRunTime.boxToFloat((float)value.$times(Decimal$.MODULE$.apply(1.1)).toFloat()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(BoxesRunTime.boxToDouble((double)value.$times(Decimal$.MODULE$.apply(1.1)).toDouble()), dt$2, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
    }

    public static final /* synthetic */ void $anonfun$new$6(CastWithAnsiOnSuite $this, byte value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(BoxesRunTime.boxToByte((byte)value), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(Byte.toString(value), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(Decimal$.MODULE$.apply(Byte.toString(value)), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToByte((byte)value), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$17(CastWithAnsiOnSuite $this, short value) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(BoxesRunTime.boxToShort((short)value), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(Short.toString(value), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(Decimal$.MODULE$.apply(Short.toString(value)), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, $this.cast$default$3()), BoxesRunTime.boxToShort((short)value), $this.checkEvaluation$default$3());
    }

    private final void check$1(String value, DataType dataType) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(value, dataType, this.cast$default$3()), this.castErrMsg(value, dataType, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
    }

    public static final /* synthetic */ void $anonfun$new$53(CastWithAnsiOnSuite $this, IntegralType dataType) {
        $this.check$1("string", (DataType)dataType);
        $this.check$1("123-string", (DataType)dataType);
        $this.check$1("2020-07-19", (DataType)dataType);
        $this.check$1("1.23", (DataType)dataType);
    }

    public static final /* synthetic */ void $anonfun$new$54(CastWithAnsiOnSuite $this, FractionalType dataType) {
        $this.check$1("string", (DataType)dataType);
        $this.check$1("123.000.00", (DataType)dataType);
        $this.check$1("abc.com", (DataType)dataType);
    }

    private final void checkCastToTimestampError$1(Literal l, DataType to) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(l, to, this.cast$default$3()), "cannot be cast to \"TIMESTAMP\" because it is malformed", ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ Cast $anonfun$new$86(CastWithAnsiOnSuite $this, Literal array$1, DataType to$4) {
        return $this.cast(array$1, to$4, $this.cast$default$3());
    }

    public static final /* synthetic */ Cast $anonfun$new$87(CastWithAnsiOnSuite $this, Literal overflowArray$1, DataType to$4) {
        return $this.cast(overflowArray$1, to$4, $this.cast$default$3());
    }

    public static final /* synthetic */ Cast $anonfun$new$88(CastWithAnsiOnSuite $this, Literal overflowArray$1, DataType to$4) {
        return $this.cast(overflowArray$1, to$4, $this.cast$default$3());
    }

    public static final /* synthetic */ Cast $anonfun$new$94(CastWithAnsiOnSuite $this, Literal map$1, DataType to$5) {
        return $this.cast(map$1, to$5, $this.cast$default$3());
    }

    public static final /* synthetic */ Cast $anonfun$new$100(CastWithAnsiOnSuite $this, Literal struct$1, DataType to$6) {
        return $this.cast(struct$1, to$6, $this.cast$default$3());
    }

    private final void checkCastWithParseError$1(String str, ZoneId zid$1) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)str), (DataType)TimestampType$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)zid$1.getId())), this.castErrMsg(str, (DataType)TimestampType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ void $anonfun$new$106(CastWithAnsiOnSuite $this, ZoneId zid) {
        $this.checkCastWithParseError$1("123", zid);
        $this.checkCastWithParseError$1("2015-03-18 123142", zid);
        $this.checkCastWithParseError$1("2015-03-18T123123", zid);
        $this.checkCastWithParseError$1("2015-03-18X", zid);
        $this.checkCastWithParseError$1("2015/03/18", zid);
        $this.checkCastWithParseError$1("2015.03.18", zid);
        $this.checkCastWithParseError$1("20150318", zid);
        $this.checkCastWithParseError$1("2015-031-8", zid);
        $this.checkCastWithParseError$1("2015-03-18T12:03:17-0:70", zid);
        $this.checkCastWithParseError$1("abdef", zid);
    }

    private final void checkCastWithParseError$2(String str, ZoneId zid$2) {
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)str), (DataType)DateType$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)zid$2.getId())), this.castErrMsg(str, (DataType)DateType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
    }

    public static final /* synthetic */ void $anonfun$new$109(CastWithAnsiOnSuite $this, ZoneId zid) {
        $this.checkCastWithParseError$2("2015-13-18", zid);
        $this.checkCastWithParseError$2("2015-03-128", zid);
        $this.checkCastWithParseError$2("2015/03/18", zid);
        $this.checkCastWithParseError$2("2015.03.18", zid);
        $this.checkCastWithParseError$2("20150318", zid);
        $this.checkCastWithParseError$2("2015-031-8", zid);
        $this.checkCastWithParseError$2("2015-03-18ABC", zid);
        $this.checkCastWithParseError$2("abdef", zid);
    }

    public static final /* synthetic */ void $anonfun$new$125(CastWithAnsiOnSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Literal timeValue = (Literal)tuple2._1();
            IntegralType targetType = (IntegralType)tuple2._2();
            $this.checkErrorInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(timeValue, (DataType)targetType, $this.cast$default$3()), "CAST_OVERFLOW", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)("TIME '" + timeValue.toString() + "'")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)("\"" + timeValue.dataType().sql() + "\"")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)("\"" + targetType.sql() + "\"")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)"\"spark.sql.ansi.enabled\"")}))), ClassTag$.MODULE$.apply(SparkArithmeticException.class));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public CastWithAnsiOnSuite() {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$((QueryErrorsBase)this);
        this.test("ANSI mode: Throw exception on casting out-of-range value to byte type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testIntMaxAndMin((DataType)ByteType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{128, -129})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ByteType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{127, (byte)0, -128})).foreach((Function1 & Serializable)value -> {
                CastWithAnsiOnSuite.$anonfun$new$6(this, BoxesRunTime.unboxToByte((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("ANSI mode: Throw exception on casting out-of-range value to short type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testIntMaxAndMin((DataType)ShortType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{32768, -32769})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)value -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToFloat((float)value), (DataType)FloatType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)value), (DataType)DoubleType$.MODULE$), (DataType)ShortType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
            });
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapShortArray(new short[]{Short.MAX_VALUE, (short)0, Short.MIN_VALUE})).foreach((Function1 & Serializable)value -> {
                CastWithAnsiOnSuite.$anonfun$new$17(this, BoxesRunTime.unboxToShort((Object)value));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("ANSI mode: Throw exception on casting out-of-range value to int type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testIntMaxAndMin((DataType)IntegerType$.MODULE$);
            this.testLongMaxAndMin((DataType)IntegerType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{Integer.MAX_VALUE, 0, Integer.MIN_VALUE})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToInteger((int)value), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Integer.toString(value), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Decimal$.MODULE$.apply(Integer.toString(value)), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(new Literal((Object)BoxesRunTime.boxToDouble((double)((double)value * 1.0)), (DataType)DoubleType$.MODULE$), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)2.1474836479E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-2.1474836489E9), (DataType)IntegerType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("ANSI mode: Throw exception on casting out-of-range value to long type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testLongMaxAndMin((DataType)LongType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{Long.MAX_VALUE, 0L, Long.MIN_VALUE})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)value -> {
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToLong((long)value), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Long.toString(value), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
                this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Decimal$.MODULE$.apply(Long.toString(value)), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)value), this.checkEvaluation$default$3());
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToFloat((float)-9.223372E18f), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(BoxesRunTime.boxToDouble((double)-9.223372036854776E18), (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), this.checkEvaluation$default$3());
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("ANSI mode: Throw exception on casting out-of-range value to decimal type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)"134.12"), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)134.12)), (DataType)new DecimalType(3, 2), this.cast$default$3()), "cannot be represented", ClassTag$.MODULE$.apply(ArithmeticException.class));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("ANSI mode: disallow type conversions between Numeric types and Date type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkInvalidCastFromNumericTypeToDateType();
            this.verifyCastFailure(this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (DataType)DateType$.MODULE$, this.cast$default$3()), new TypeCheckResult.DataTypeMismatch("CAST_WITH_FUNC_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BIGINT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"DATE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionNames"), (Object)"`DATE_FROM_UNIX_DATE`")}))));
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable)numericType -> {
                this.withClue("numericType = " + numericType.sql(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.verifyCastFailure(this.cast(dateLiteral, (DataType)numericType, this.cast$default$3()), new TypeCheckResult.DataTypeMismatch("CAST_WITH_FUNC_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"DATE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)("\"" + numericType.sql() + "\"")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionNames"), (Object)"`UNIX_DATE`")})))));
                return BoxedUnit.UNIT;
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("ANSI mode: disallow type conversions between Numeric types and Binary type", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkInvalidCastFromNumericTypeToBinaryType();
            Literal binaryLiteral = new Literal((Object)new byte[(byte)1], (DataType)BinaryType$.MODULE$);
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable)numericType -> {
                TypeCheckResult $org_scalatest_assert_macro_left = this.cast(binaryLiteral, (DataType)numericType, this.cast$default$3()).checkInputDataTypes();
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BINARY\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType((AbstractDataType)numericType))})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("ANSI mode: disallow variant cast to non-nullable types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            VariantVal variantVal = new VariantVal(new byte[]{12, 3}, new byte[]{1, 0, 0});
            ArrayType sourceArrayType = new ArrayType((DataType)VariantType$.MODULE$, false);
            ArrayType targetArrayType = new ArrayType((DataType)StringType$.MODULE$, false);
            Literal variantArray = Literal$.MODULE$.create((Object)new .colon.colon((Object)variantVal, (List)Nil$.MODULE$), (DataType)sourceArrayType);
            TypeCheckResult $org_scalatest_assert_macro_left = this.cast(variantArray, (DataType)targetArrayType, this.cast$default$3()).checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)this.toSQLType((AbstractDataType)sourceArrayType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType((AbstractDataType)targetArrayType))})));
            TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            ArrayType targetArrayType2 = new ArrayType((DataType)StringType$.MODULE$, true);
            TypeCheckResult $org_scalatest_assert_macro_left2 = this.cast(variantArray, (DataType)targetArrayType2, this.cast$default$3()).checkInputDataTypes();
            TypeCheckResult.TypeCheckSuccess$ $org_scalatest_assert_macro_right2 = TypeCheckResult.TypeCheckSuccess$.MODULE$;
            TypeCheckResult typeCheckResult2 = $org_scalatest_assert_macro_left2;
            TypeCheckResult.TypeCheckSuccess$ typeCheckSuccess$ = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(typeCheckResult2 != null ? !typeCheckResult2.equals(typeCheckSuccess$) : typeCheckSuccess$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            StructType sourceStructType = new StructType((StructField[])((Object[])new StructField[]{new StructField("v", (DataType)VariantType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
            StructType targetStructType = new StructType((StructField[])((Object[])new StructField[]{new StructField("v", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
            Literal variantStruct = Literal$.MODULE$.create((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{variantVal})), (DataType)sourceStructType);
            TypeCheckResult $org_scalatest_assert_macro_left3 = this.cast(variantStruct, (DataType)targetStructType, this.cast$default$3()).checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right3 = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)this.toSQLType((AbstractDataType)sourceStructType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType((AbstractDataType)targetStructType))})));
            TypeCheckResult typeCheckResult3 = $org_scalatest_assert_macro_left3;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(typeCheckResult3 != null ? !typeCheckResult3.equals(dataTypeMismatch2) : dataTypeMismatch2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
            StructType targetStructType2 = new StructType((StructField[])((Object[])new StructField[]{new StructField("v", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}));
            TypeCheckResult $org_scalatest_assert_macro_left4 = this.cast(variantStruct, (DataType)targetStructType2, this.cast$default$3()).checkInputDataTypes();
            TypeCheckResult.TypeCheckSuccess$ $org_scalatest_assert_macro_right4 = TypeCheckResult.TypeCheckSuccess$.MODULE$;
            TypeCheckResult typeCheckResult4 = $org_scalatest_assert_macro_left4;
            TypeCheckResult.TypeCheckSuccess$ typeCheckSuccess$2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(typeCheckResult4 != null ? !typeCheckResult4.equals(typeCheckSuccess$2) : typeCheckSuccess$2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            MapType sourceMapType = new MapType((DataType)StringType$.MODULE$, (DataType)VariantType$.MODULE$, false);
            MapType targetMapType = new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false);
            Literal variantMap = Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)variantVal)})), (DataType)sourceMapType);
            TypeCheckResult $org_scalatest_assert_macro_left5 = this.cast(variantMap, (DataType)targetMapType, this.cast$default$3()).checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right5 = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)this.toSQLType((AbstractDataType)sourceMapType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType((AbstractDataType)targetMapType))})));
            TypeCheckResult typeCheckResult5 = $org_scalatest_assert_macro_left5;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch3 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(typeCheckResult5 != null ? !typeCheckResult5.equals(dataTypeMismatch3) : dataTypeMismatch3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            MapType targetMapType2 = new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true);
            TypeCheckResult $org_scalatest_assert_macro_left6 = this.cast(variantMap, (DataType)targetMapType2, this.cast$default$3()).checkInputDataTypes();
            TypeCheckResult.TypeCheckSuccess$ $org_scalatest_assert_macro_right6 = TypeCheckResult.TypeCheckSuccess$.MODULE$;
            TypeCheckResult typeCheckResult6 = $org_scalatest_assert_macro_left6;
            TypeCheckResult.TypeCheckSuccess$ typeCheckSuccess$3 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(typeCheckResult6 != null ? !typeCheckResult6.equals(typeCheckSuccess$3) : typeCheckSuccess$3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("ANSI mode: disallow type conversions between Datatime types and Boolean types", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Literal timestampLiteral = new Literal((Object)BoxesRunTime.boxToLong((long)1L), (DataType)TimestampType$.MODULE$);
            TypeCheckResult checkResult1 = this.cast(timestampLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes();
            Enumeration.Value value = this.evalMode();
            Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult1;
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITH_CONF_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"TIMESTAMP\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configVal"), (Object)"'false'")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            } else {
                Enumeration.Value value4 = EvalMode$.MODULE$.TRY();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    TypeCheckResult $org_scalatest_assert_macro_left = checkResult1;
                    TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"TIMESTAMP\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"BOOLEAN\"")})));
                    TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
                }
            }
            Literal dateLiteral = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)DateType$.MODULE$);
            TypeCheckResult checkResult2 = this.cast(dateLiteral, (DataType)BooleanType$.MODULE$, this.cast$default$3()).checkInputDataTypes();
            Enumeration.Value value6 = this.evalMode();
            Enumeration.Value value7 = EvalMode$.MODULE$.ANSI();
            Enumeration.Value value8 = value6;
            if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult2;
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITH_CONF_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"DATE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configVal"), (Object)"'false'")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            } else {
                Enumeration.Value value9 = EvalMode$.MODULE$.TRY();
                Enumeration.Value value10 = value6;
                if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                    TypeCheckResult $org_scalatest_assert_macro_left = checkResult2;
                    TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"DATE\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"BOOLEAN\"")})));
                    TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
                }
            }
            Literal booleanLiteral = new Literal((Object)BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$);
            TypeCheckResult checkResult3 = this.cast(booleanLiteral, (DataType)TimestampType$.MODULE$, this.cast$default$3()).checkInputDataTypes();
            Enumeration.Value value11 = this.evalMode();
            Enumeration.Value value12 = EvalMode$.MODULE$.ANSI();
            Enumeration.Value value13 = value11;
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult3;
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITH_CONF_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"TIMESTAMP\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configVal"), (Object)"'false'")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            } else {
                Enumeration.Value value14 = EvalMode$.MODULE$.TRY();
                Enumeration.Value value15 = value11;
                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                    TypeCheckResult $org_scalatest_assert_macro_left = checkResult3;
                    TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"TIMESTAMP\"")})));
                    TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                    TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
                }
            }
            TypeCheckResult checkResult4 = this.cast(booleanLiteral, (DataType)DateType$.MODULE$, this.cast$default$3()).checkInputDataTypes();
            Enumeration.Value value16 = this.evalMode();
            Enumeration.Value value17 = EvalMode$.MODULE$.ANSI();
            Enumeration.Value value18 = value16;
            if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult4;
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"DATE\"")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            }
            Enumeration.Value value19 = EvalMode$.MODULE$.TRY();
            Enumeration.Value value20 = value16;
            if (!(value19 != null ? !value19.equals(value20) : value20 != null)) {
                TypeCheckResult $org_scalatest_assert_macro_left = checkResult4;
                TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("CAST_WITHOUT_SUGGESTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcType"), (Object)"\"BOOLEAN\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"DATE\"")})));
                TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
                TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            }
            return BoxedUnit.UNIT;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("cast from invalid string to numeric should throw NumberFormatException", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)dataType -> {
                CastWithAnsiOnSuite.$anonfun$new$53(this, dataType);
                return BoxedUnit.UNIT;
            });
            new .colon.colon((Object)DoubleType$.MODULE$, (List)new .colon.colon((Object)FloatType$.MODULE$, (List)new .colon.colon((Object)DecimalType$.MODULE$.USER_DEFAULT(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)dataType -> {
                CastWithAnsiOnSuite.$anonfun$new$54(this, dataType);
                return BoxedUnit.UNIT;
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("cast from invalid string array to numeric array should throw NumberFormatException", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Literal array = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)new .colon.colon(null, (List)Nil$.MODULE$)))), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)ByteType$.MODULE$, true), (DataType)ByteType$.MODULE$, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)123)), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)ShortType$.MODULE$, true), (DataType)ShortType$.MODULE$, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)123)), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), (DataType)IntegerType$.MODULE$, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)123), null, null, null})));
            this.checkCastToNumericError(array, (DataType)new ArrayType((DataType)LongType$.MODULE$, true), (DataType)LongType$.MODULE$, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)123L), null, null, null})));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
        this.test("Fast fail for cast string type to decimal type in ansi mode", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("12345678901234567890123456789012345678"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("123456789012345678901234567890123456789", (DataType)new DecimalType(38, 0), this.cast$default$3()), "NUMERIC_OUT_OF_SUPPORTED_RANGE", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("12345678901234567890123456789012345678", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("0.00000000000000000000000000000000000000000001", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("0.00000000000000000000000000000000000001", (DataType)new DecimalType(38, 18), this.cast$default$3()), Decimal$.MODULE$.apply("0E-18"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("6E-120", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("0"), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 0), this.cast$default$3()), Decimal$.MODULE$.apply("60000000000000000000000000000000000000"), this.checkEvaluation$default$3());
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("6E+38", (DataType)new DecimalType(38, 0), this.cast$default$3()), "NUMERIC_OUT_OF_SUPPORTED_RANGE", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("6E+37", (DataType)new DecimalType(38, 1), this.cast$default$3()), "cannot be represented as Decimal(38, 1)", ClassTag$.MODULE$.apply(ArithmeticException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast("abcd", (DataType)new DecimalType(38, 1), this.cast$default$3()), this.castErrMsg("abcd", (DataType)new DecimalType(38, 1), this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        this.test("ANSI mode: cast string to boolean with parse error", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkCastToBooleanError(Literal$.MODULE$.apply((Object)"abc"), (DataType)BooleanType$.MODULE$, null);
            this.checkCastToBooleanError(Literal$.MODULE$.apply((Object)""), (DataType)BooleanType$.MODULE$, null);
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
        this.test("cast from timestamp II", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.NaN)), (DataType)TimestampType$.MODULE$);
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)), (DataType)TimestampType$.MODULE$);
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.NaN)), (DataType)TimestampType$.MODULE$);
            this.checkCastToTimestampError$1(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)), (DataType)TimestampType$.MODULE$);
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{-9.223372036854776E18, 9.223372036854776E18, -9.223372036854776E18, 9.223372036854776E18})).foreach((Function1)(JFunction1.mcVD.sp & Serializable)v -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)v)), (DataType)TimestampType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(SparkArithmeticException.class)));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        this.test("cast a timestamp before the epoch 1970-01-01 00:00:00Z II", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable)() -> {
            Timestamp negativeTs = Timestamp.valueOf("1900-05-05 18:34:56.1");
            long $org_scalatest_assert_macro_left = negativeTs.getTime();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
            new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)dt -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(negativeTs$1, (DataType)dt, $this.cast$default$3()), this.castOverflowErrMsg(negativeTs, (DataType)TimestampType$.MODULE$, (DataType)dt), ClassTag$.MODULE$.apply(SparkArithmeticException.class));
                return BoxedUnit.UNIT;
            });
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
        this.test("cast a timestamp before the epoch 1970-01-01 00:00:00Z", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.UTC(), (JFunction0.mcV.sp & Serializable)() -> {
            Timestamp negativeTs = Timestamp.valueOf("1900-05-05 18:34:56.1");
            long $org_scalatest_assert_macro_left = negativeTs.getTime();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
            new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)dt -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(negativeTs$2, (DataType)dt, $this.cast$default$3()), this.castOverflowErrMsg(negativeTs, (DataType)TimestampType$.MODULE$, (DataType)dt), ClassTag$.MODULE$.apply(SparkArithmeticException.class));
                return BoxedUnit.UNIT;
            });
            long expectedSecs = Math.floorDiv(negativeTs.getTime(), 1000L);
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(negativeTs, (DataType)LongType$.MODULE$, this.cast$default$3()), BoxesRunTime.boxToLong((long)expectedSecs), this.checkEvaluation$default$3());
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        this.test("cast from array II", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Literal array = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)new .colon.colon(null, (List)Nil$.MODULE$)))), (DataType)new ArrayType((DataType)StringType$.MODULE$, true));
            Literal array_notNull = Literal$.MODULE$.create((Object)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)Nil$.MODULE$))), (DataType)new ArrayType((DataType)StringType$.MODULE$, false));
            ArrayType to = new ArrayType((DataType)BooleanType$.MODULE$, true);
            Cast ret = this.cast(array, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            this.checkCastToBooleanError(array, (DataType)to, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})));
            ArrayType to2 = new ArrayType((DataType)BooleanType$.MODULE$, true);
            Cast ret2 = this.cast(array_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            this.checkCastToBooleanError(array_notNull, (DataType)to2, package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})));
            Enumeration.Value value = this.evalMode();
            Enumeration.Value value2 = EvalMode$.MODULE$.TRY();
            Cast ret3 = this.cast(array_notNull, (DataType)new ArrayType((DataType)BooleanType$.MODULE$, !(value != null ? !value.equals(value2) : value2 != null)), this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret3, "cannot be cast to \"BOOLEAN\"", ClassTag$.MODULE$.apply(SparkRuntimeException.class));
                return BoxedUnit.UNIT;
            }
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> ret3, new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)}, this.checkEvaluation$default$3());
            return BoxedUnit.UNIT;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
        this.test("cast from array III", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ArrayType from = new ArrayType((DataType)DoubleType$.MODULE$, false);
            Literal array = Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})), (DataType)from);
            ArrayType to = new ArrayType((DataType)IntegerType$.MODULE$, this.isTryCast());
            Object answer = Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (DataType)to).value();
            this.checkEvaluation((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$86(this, array, (DataType)to)), answer, this.checkEvaluation$default$3());
            Literal overflowArray = Literal$.MODULE$.create((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{2.147483648E9})), (DataType)from);
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$87(this, overflowArray, (DataType)to)), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                return BoxedUnit.UNIT;
            }
            this.checkEvaluation((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$88(this, overflowArray, (DataType)to)), Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}), ClassTag$.MODULE$.Null()), this.checkEvaluation$default$3());
            return BoxedUnit.UNIT;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 549));
        this.test("cast from map II", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Literal map = Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true));
            Literal map_notNull = Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f")})), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false));
            this.checkNullCast((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$), (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$));
            MapType to = new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
            Cast ret = this.cast(map, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
            this.checkCastToBooleanError(map, (DataType)to, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), null)})));
            MapType to2 = new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, true);
            Cast ret2 = this.cast(map_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
            this.checkCastToBooleanError(map_notNull, (DataType)to2, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToBoolean((boolean)false))})));
            Cast ret3 = this.cast(map, (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret3, this.castErrMsg("a", (DataType)IntegerType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
                v0 = BoxedUnit.UNIT;
            } else {
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                v0 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
            }
            Cast ret4 = this.cast(map_notNull, (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, false), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ret4.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret4, this.castErrMsg("123", (DataType)BooleanType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(SparkRuntimeException.class));
                v1 = BoxedUnit.UNIT;
            } else {
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret4.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                v1 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
            }
            Cast ret5 = this.cast(map_notNull, (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(ret5.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret5, this.castErrMsg("a", (DataType)IntegerType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
                return BoxedUnit.UNIT;
            }
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret5.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
        this.test("cast from map III", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MapType from = new MapType((DataType)DoubleType$.MODULE$, (DataType)DoubleType$.MODULE$, false);
            Literal map = Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToDouble((double)2.0))})), (DataType)from);
            MapType to = new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
            Object answer = Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), (DataType)to).value();
            if (!this.isTryCast()) {
                this.checkEvaluation((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$94(this, map, (DataType)to)), answer, this.checkEvaluation$default$3());
                new .colon.colon((Object)Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)2.147483648E9)), (Object)BoxesRunTime.boxToDouble((double)2.0))})), (DataType)from), (List)new .colon.colon((Object)Literal$.MODULE$.create(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToDouble((double)-2.147483649E9))})), (DataType)from), (List)Nil$.MODULE$)).foreach(arg_0 -> CastWithAnsiOnSuite.$anonfun$new$95$adapted(this, (DataType)to, arg_0));
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
        this.test("cast from struct II", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.checkNullCast((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
            Literal struct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f"), null})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))));
            Literal struct_notNull = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"123"), UTF8String.fromString((String)"true"), UTF8String.fromString((String)"f")})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            StructType to = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            Cast ret = this.cast(struct, (DataType)to, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
            this.checkCastToBooleanError(struct, (DataType)to, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), null})));
            StructType to2 = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
            Cast ret2 = this.cast(struct_notNull, (DataType)to2, this.cast$default$3());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret2.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            this.checkCastToBooleanError(struct_notNull, (DataType)to2, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false)})));
            Cast ret3 = this.cast(struct_notNull, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret3, this.castErrMsg("123", (DataType)BooleanType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(SparkRuntimeException.class));
                return BoxedUnit.UNIT;
            }
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret3.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
        this.test("cast from struct III", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructType from = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            Literal struct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0)})), (DataType)from);
            StructType to = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, this.isTryCast(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            Object answer = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (DataType)to).value();
            this.checkEvaluation((Function0<Expression>)((Function0 & Serializable)() -> CastWithAnsiOnSuite.$anonfun$new$100(this, struct, (DataType)to)), answer, this.checkEvaluation$default$3());
            Literal overflowStruct = Literal$.MODULE$.create((Object)InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)2.147483648E9)})), (DataType)from);
            Cast ret = this.cast(overflowStruct, (DataType)to, this.cast$default$3());
            if (!this.isTryCast()) {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret, "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
                return BoxedUnit.UNIT;
            }
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> ret, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})), this.checkEvaluation$default$3());
            return BoxedUnit.UNIT;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
        this.test("complex casting", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Literal complex = Literal$.MODULE$.create((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)"123", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"f", (List)Nil$.MODULE$))), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"123"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)"f")})), Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}))})), (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("m", (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("s", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("i", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
            Cast ret = this.cast(complex, (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("m", (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("s", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("l", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), this.cast$default$3());
            if (!this.isTryCast()) {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ret, this.castErrMsg("true", (DataType)IntegerType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(NumberFormatException.class));
                return BoxedUnit.UNIT;
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ret.resolved(), "ret.resolved", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        this.test("ANSI mode: cast string to timestamp with parse error", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
            CastWithAnsiOnSuite.$anonfun$new$106(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
        this.test("ANSI mode: cast string to date with parse error", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> DateTimeTestUtils$.MODULE$.outstandingZoneIds().foreach((Function1 & Serializable)zid -> {
            CastWithAnsiOnSuite.$anonfun$new$109(this, zid);
            return BoxedUnit.UNIT;
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        this.test("SPARK-26218: Fix the corner case of codegen when casting float to Integer", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> this.cast(this.cast(Literal$.MODULE$.apply((Object)"2147483648"), (DataType)FloatType$.MODULE$, this.cast$default$3()), (DataType)IntegerType$.MODULE$, this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class)), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 798));
        this.test("SPARK-35720: cast invalid string input to timestamp without time zone", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"00:00:00", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"a2021-06-17", (List)new .colon.colon((Object)"2021-06-17abc", (List)new .colon.colon((Object)"2021-06-17 00:00:00ABC", (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)invalidInput -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(invalidInput, (DataType)TimestampNTZType$.MODULE$, $this.cast$default$3()), this.castErrMsg(invalidInput, (DataType)TimestampNTZType$.MODULE$, this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
            return BoxedUnit.UNIT;
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        this.test("SPARK-39749: cast Decimal to string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Literal input = Literal$.MODULE$.create((Object)Decimal$.MODULE$.apply(1.23E-7), (DataType)new DecimalType(9, 9));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(input, (DataType)StringType$.MODULE$, this.cast$default$3()), "0.000000123", this.checkEvaluation$default$3());
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
        this.test("cast invalid string input to time", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"a", (List)new .colon.colon((Object)"123", (List)new .colon.colon((Object)"00:00:00ABC", (List)new .colon.colon((Object)"24:00:00", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)invalidInput -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(invalidInput, (DataType)TimeType$.MODULE$.apply(), $this.cast$default$3()), this.castErrMsg(invalidInput, (DataType)TimeType$.MODULE$.apply(), this.castErrMsg$default$3()), ClassTag$.MODULE$.apply(DateTimeException.class));
            return BoxedUnit.UNIT;
        }), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 821));
        this.test("SPARK-52620: cast time to decimal with insufficient precision (ANSI on)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Literal largeTime = Literal$.MODULE$.create((Object)LocalTime.of(23, 59, 59, 123456000), (DataType)new TimeType(6));
            if (!this.isTryCast()) {
                SparkArithmeticException x$2 = (SparkArithmeticException)this.intercept((Function0 & Serializable)() -> {
                    Cast qual$1 = this.cast(largeTime, (DataType)new DecimalType(2, 0), this.cast$default$3());
                    InternalRow x$1 = qual$1.eval$default$1();
                    return qual$1.eval(x$1);
                }, ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
                String x$3 = "NUMERIC_VALUE_OUT_OF_RANGE.WITH_SUGGESTION";
                Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"86399.123456000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\"")}));
                SparkFunSuite.ExpectedContext[] x$5 = (SparkFunSuite.ExpectedContext[])((Object[])new SparkFunSuite.ExpectedContext[]{this.ExpectedContext().apply("", -1, -1)});
                Option x$6 = this.checkError$default$3();
                boolean x$7 = this.checkError$default$5();
                this.checkError((SparkThrowable)x$2, "NUMERIC_VALUE_OUT_OF_RANGE.WITH_SUGGESTION", x$6, x$4, x$7, x$5);
                return BoxedUnit.UNIT;
            }
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> this.cast(largeTime, (DataType)new DecimalType(2, 0), this.cast$default$3()), null, this.checkEvaluation$default$3());
            return BoxedUnit.UNIT;
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
        this.test("SPARK-52619: cast time to integral types with overflow with ansi on", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Literal largeTime6 = Literal$.MODULE$.create((Object)LocalTime.of(23, 59, 59, 123456000), (DataType)new TimeType(6));
            Literal largeTime4 = Literal$.MODULE$.create((Object)LocalTime.of(23, 59, 59, 678900000), (DataType)new TimeType(4));
            new .colon.colon((Object)new Tuple2((Object)largeTime6, (Object)ShortType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)largeTime6, (Object)ByteType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)largeTime4, (Object)ShortType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)largeTime4, (Object)ByteType$.MODULE$), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)x0$1 -> {
                CastWithAnsiOnSuite.$anonfun$new$125(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }, new Position("CastWithAnsiOnSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 854));
    }

    public static final /* synthetic */ Object $anonfun$new$95$adapted(CastWithAnsiOnSuite $this, DataType to$5, Literal overflowMap) {
        $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> $this.cast(overflowMap, to$5, $this.cast$default$3()), "overflow", ClassTag$.MODULE$.apply(ArithmeticException.class));
        return BoxedUnit.UNIT;
    }
}

