/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.DivideDTInterval;
import org.apache.spark.sql.catalyst.expressions.DivideInterval;
import org.apache.spark.sql.catalyst.expressions.DivideInterval$;
import org.apache.spark.sql.catalyst.expressions.DivideYMInterval;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.ExtractANSIIntervalDays;
import org.apache.spark.sql.catalyst.expressions.ExtractANSIIntervalHours;
import org.apache.spark.sql.catalyst.expressions.ExtractANSIIntervalMinutes;
import org.apache.spark.sql.catalyst.expressions.ExtractANSIIntervalMonths;
import org.apache.spark.sql.catalyst.expressions.ExtractANSIIntervalSeconds;
import org.apache.spark.sql.catalyst.expressions.ExtractANSIIntervalYears;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalDays;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalHours;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalMinutes;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalMonths;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalSeconds;
import org.apache.spark.sql.catalyst.expressions.ExtractIntervalYears;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeDTInterval;
import org.apache.spark.sql.catalyst.expressions.MakeInterval;
import org.apache.spark.sql.catalyst.expressions.MakeInterval$;
import org.apache.spark.sql.catalyst.expressions.MakeYMInterval;
import org.apache.spark.sql.catalyst.expressions.MultiplyDTInterval;
import org.apache.spark.sql.catalyst.expressions.MultiplyInterval;
import org.apache.spark.sql.catalyst.expressions.MultiplyInterval$;
import org.apache.spark.sql.catalyst.expressions.MultiplyYMInterval;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Shrink;
import org.scalacheck.Test;
import org.scalactic.Prettifier;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.enablers.WheneverAsserting;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatest.prop.Whenever;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckDrivenPropertyChecks;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r3AAB\u0004\u0001)!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C\u0002C!)\u0011\b\u0001C\u0002u!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002\"\u0001A\u0003%AF\u0001\rJ]R,'O^1m\u000bb\u0004(/Z:tS>t7oU;ji\u0016T!\u0001C\u0005\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0015-\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0004\u0001UI\u0002C\u0001\f\u0018\u001b\u0005i\u0011B\u0001\r\u000e\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011!dG\u0007\u0002\u000f%\u0011Ad\u0002\u0002\u0015\u000bb\u0004(/Z:tS>tWI^1m\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u000e\u0001\u0003=\u0019HO]5oOR{W\u000b\u0016$9'R\u0014HC\u0001\u0012+!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003usB,7O\u0003\u0002(\u001b\u00051QO\\:bM\u0016L!!\u000b\u0013\u0003\u0015U#f\tO*ue&tw\rC\u0003,\u0005\u0001\u0007A&A\u0002tiJ\u0004\"!\f\u001c\u000f\u00059\"\u0004CA\u00183\u001b\u0005\u0001$BA\u0019\u0014\u0003\u0019a$o\\8u})\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)$'\u0001\u0005j]R,'O^1m)\tYd\b\u0005\u0002\u001by%\u0011Qh\u0002\u0002\b\u0019&$XM]1m\u0011\u0015y4\u00011\u0001-\u0003\u0005\u0019\u0018!\u00047be\u001e,\u0017J\u001c;feZ\fG.F\u0001-\u00039a\u0017M]4f\u0013:$XM\u001d<bY\u0002\u0002")
public class IntervalExpressionsSuite
extends SparkFunSuite
implements ExpressionEvalHelper {
    private final String largeInterval;
    private String sparkHome;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;
    private Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private volatile boolean bitmap$0;

    @Override
    public InternalRow create_row(Seq<Object> values) {
        return ExpressionEvalHelper.create_row$(this, values);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Tuple2<?, ?>> entries) {
        return ExpressionEvalHelper.create_map$(this, entries);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Object> keys, Seq<Object> values) {
        return ExpressionEvalHelper.create_map$(this, keys, values);
    }

    @Override
    public Expression replace(Expression expr) {
        return ExpressionEvalHelper.replace$(this, expr);
    }

    @Override
    public void checkEvaluation(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluation$default$3() {
        return ExpressionEvalHelper.checkEvaluation$default$3$(this);
    }

    @Override
    public boolean checkResult(Object result, Object expected, Expression expression) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, expression);
    }

    @Override
    public boolean checkResult(Object result, Object expected, DataType exprDataType, boolean exprNullable) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, exprDataType, exprNullable);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, String condition, Map<String, String> parameters, ClassTag<T> evidence$1) {
        ExpressionEvalHelper.checkErrorInExpression$((ExpressionEvalHelper)this, expression, condition, parameters, evidence$1);
    }

    @Override
    public <T extends SparkThrowable> Map<String, String> checkErrorInExpression$default$3() {
        return ExpressionEvalHelper.checkErrorInExpression$default$3$(this);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, InternalRow inputRow, String condition, ClassTag<T> evidence$2) {
        ExpressionEvalHelper.checkErrorInExpression$((ExpressionEvalHelper)this, expression, inputRow, condition, evidence$2);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, InternalRow inputRow, String condition, Map<String, String> parameters, ClassTag<T> evidence$3) {
        ExpressionEvalHelper.checkErrorInExpression$(this, expression, inputRow, condition, parameters, evidence$3);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, String expectedErrMsg, ClassTag<T> evidence$4) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, expectedErrMsg, evidence$4);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, InternalRow inputRow, String expectedErrMsg, ClassTag<T> evidence$5) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, inputRow, expectedErrMsg, evidence$5);
    }

    @Override
    public Object evaluateWithoutCodegen(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithoutCodegen$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithoutCodegen$default$2() {
        return ExpressionEvalHelper.evaluateWithoutCodegen$default$2$(this);
    }

    @Override
    public void checkEvaluationWithoutCodegen(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithoutCodegen$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithoutCodegen$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithoutCodegen$default$3$(this);
    }

    @Override
    public void checkEvaluationWithMutableProjection(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithMutableProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithMutableProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithMutableProjection$default$3$(this);
    }

    @Override
    public Object evaluateWithMutableProjection(Function0<Expression> expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithMutableProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithMutableProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithMutableProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithUnsafeProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithUnsafeProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$default$3$(this);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithOptimization(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithOptimization$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithOptimization$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithOptimization$default$3$(this);
    }

    @Override
    public void checkDoubleEvaluation(Function0<Expression> expression, TripleEqualsSupport.Spread<Object> expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkDoubleEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkDoubleEvaluation$default$3() {
        return ExpressionEvalHelper.checkDoubleEvaluation$default$3$(this);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function3<Expression, Expression, Expression, Expression> c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType1, dataType2, dataType3);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Seq<Expression>, Expression> c, DataType dataType, int minNumElements) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType, minNumElements);
    }

    @Override
    public int checkConsistencyBetweenInterpretedAndCodegen$default$3() {
        return ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$default$3$(this);
    }

    @Override
    public void cmpInterpretWithCodegen(InternalRow inputRow, Expression expr, boolean exceptionAllowed) {
        ExpressionEvalHelper.cmpInterpretWithCodegen$(this, inputRow, expr, exceptionAllowed);
    }

    @Override
    public boolean cmpInterpretWithCodegen$default$3() {
        return ExpressionEvalHelper.cmpInterpretWithCodegen$default$3$(this);
    }

    @Override
    public void testBothCodegenAndInterpreted(String name, Function0<BoxedUnit> f) {
        ExpressionEvalHelper.testBothCodegenAndInterpreted$(this, name, f);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Iterable<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public ScalaCheckDrivenPropertyChecks.ConfiguredPropertyCheck forAll(Seq<Configuration.PropertyCheckConfigParam> configParams) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, configParams);
    }

    public <A, ASSERTION> Object forAll(Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(String nameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Gen<A> genA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(String nameA, String nameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(String nameA, String nameB, String nameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, String nameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, (String)nameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Gen<F> genF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, genF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Tuple2<Gen<F>, String> genAndNameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, genAndNameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Test.Parameters getScalaCheckParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return ScalaCheckConfiguration.getScalaCheckParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public Configuration.Parameter getParameter(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return Configuration.getParameter$((Configuration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public <T> Object whenever(boolean condition, Function0<T> fun, WheneverAsserting<T> wa) {
        return Whenever.whenever$((Whenever)this, (boolean)condition, fun, wa);
    }

    private String sparkHome$lzycompute() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
        this.generatorDrivenConfig = x$1;
    }

    public UTF8String stringToUTF8Str(String str) {
        return UTF8String.fromString((String)str);
    }

    public Literal interval(String s) {
        return Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval(this.stringToUTF8Str("interval " + s)));
    }

    private String largeInterval() {
        return this.largeInterval;
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
        }
    }

    private final void MinSize$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
        }
    }

    private final void SizeRange$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
        }
    }

    private final void Workers$lzycompute$1() {
        IntervalExpressionsSuite intervalExpressionsSuite = this;
        synchronized (intervalExpressionsSuite) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
        }
    }

    public static final /* synthetic */ String $anonfun$new$56(boolean x$1) {
        return Boolean.toString(x$1);
    }

    private final void check$1(String interval, double num, String expected, Option isAnsi) {
        CalendarInterval expectedRes = IntervalUtils$.MODULE$.safeStringToInterval(this.stringToUTF8Str(expected));
        .colon.colon configs = isAnsi.isEmpty() ? new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$)) : Option$.MODULE$.option2Iterable(isAnsi.map((Function1 & Serializable)x$1 -> IntervalExpressionsSuite.$anonfun$new$56(BoxesRunTime.unboxToBoolean((Object)x$1)))).toSeq();
        configs.foreach((Function1 & Serializable)v -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)v)}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                MultiplyInterval expr = new MultiplyInterval((Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval($this.stringToUTF8Str(interval$1))), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)num$1)), MultiplyInterval$.MODULE$.apply$default$3());
                if (expectedRes$1 == null) {
                    $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> expr, expected$1, ClassTag$.MODULE$.apply(ArithmeticException.class));
                    return;
                }
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> expr, expectedRes$1, $this.checkEvaluation$default$3());
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Option check$default$4$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$new$62(boolean x$2) {
        return Boolean.toString(x$2);
    }

    private final void check$2(String interval, double num, String expected, Option isAnsi) {
        CalendarInterval expectedRes = IntervalUtils$.MODULE$.safeStringToInterval(this.stringToUTF8Str(expected));
        .colon.colon configs = isAnsi.isEmpty() ? new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$)) : Option$.MODULE$.option2Iterable(isAnsi.map((Function1 & Serializable)x$2 -> IntervalExpressionsSuite.$anonfun$new$62(BoxesRunTime.unboxToBoolean((Object)x$2)))).toSeq();
        configs.foreach((Function1 & Serializable)v -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)v)}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                DivideInterval expr = new DivideInterval((Expression)Literal$.MODULE$.apply((Object)IntervalUtils$.MODULE$.stringToInterval($this.stringToUTF8Str(interval$2))), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)num$2)), DivideInterval$.MODULE$.apply$default$3());
                if (expected$2 != null && expectedRes$2 == null) {
                    $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> expr, expected$2, ClassTag$.MODULE$.apply(ArithmeticException.class));
                    return;
                }
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> expr, expectedRes$2, $this.checkEvaluation$default$3());
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Option check$default$4$2() {
        return None$.MODULE$;
    }

    private final void check$3(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, int micros) {
        long secFrac = DateTimeTestUtils$.MODULE$.secFrac(seconds, millis, micros);
        MakeInterval intervalExpr = new MakeInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)years)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)months)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)weeks)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)days)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hours)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)minutes)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(secFrac, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), MakeInterval$.MODULE$.apply$default$8());
        int totalMonths = years * 12 + months;
        int totalDays = weeks * 7 + days;
        long totalMicros = secFrac + (long)minutes * 60000000L + (long)hours * 3600000000L;
        CalendarInterval expected = new CalendarInterval(totalMonths, totalDays, totalMicros);
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> intervalExpr, expected, this.checkEvaluation$default$3());
    }

    private static final int check$default$1$1() {
        return 0;
    }

    private static final int check$default$2$1() {
        return 0;
    }

    private static final int check$default$3$1() {
        return 0;
    }

    private static final int check$default$4$3() {
        return 0;
    }

    private static final int check$default$5$1() {
        return 0;
    }

    private static final int check$default$6$1() {
        return 0;
    }

    private static final int check$default$7$1() {
        return 0;
    }

    private static final int check$default$8$1() {
        return 0;
    }

    private static final int check$default$9$1() {
        return 0;
    }

    private final void check$4(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, int micros) {
        long secFrac = DateTimeTestUtils$.MODULE$.secFrac(seconds, millis, micros);
        MakeInterval intervalExpr = new MakeInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)years)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)months)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)weeks)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)days)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hours)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)minutes)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(secFrac, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), MakeInterval$.MODULE$.apply$default$8());
        int totalMonths = years * 12 + months;
        int totalDays = weeks * 7 + days;
        long totalMicros = secFrac + (long)minutes * 60000000L + (long)hours * 3600000000L;
        CalendarInterval expected = new CalendarInterval(totalMonths, totalDays, totalMicros);
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> intervalExpr, expected, this.checkEvaluation$default$3());
    }

    private static final int check$default$1$2() {
        return 0;
    }

    private static final int check$default$2$2() {
        return 0;
    }

    private static final int check$default$3$2() {
        return 0;
    }

    private static final int check$default$4$4() {
        return 0;
    }

    private static final int check$default$5$2() {
        return 0;
    }

    private static final int check$default$6$2() {
        return 0;
    }

    private static final int check$default$7$2() {
        return 0;
    }

    private static final int check$default$8$2() {
        return 0;
    }

    private static final int check$default$9$2() {
        return 0;
    }

    private final void checkException$1(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, int micros) {
        long secFrac = DateTimeTestUtils$.MODULE$.secFrac(seconds, millis, micros);
        MakeInterval intervalExpr = new MakeInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)years)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)months)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)weeks)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)days)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hours)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)minutes)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(secFrac, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), MakeInterval$.MODULE$.apply$default$8());
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> intervalExpr, package$.MODULE$.EmptyRow(), "ARITHMETIC_OVERFLOW", ClassTag$.MODULE$.apply(ArithmeticException.class));
    }

    private static final int checkException$default$1$1() {
        return 0;
    }

    private static final int checkException$default$2$1() {
        return 0;
    }

    private static final int checkException$default$3$1() {
        return 0;
    }

    private static final int checkException$default$4$1() {
        return 0;
    }

    private static final int checkException$default$5$1() {
        return 0;
    }

    private static final int checkException$default$6$1() {
        return 0;
    }

    private static final int checkException$default$7$1() {
        return 0;
    }

    private static final int checkException$default$8$1() {
        return 0;
    }

    private static final int checkException$default$9$1() {
        return 0;
    }

    private final void check$5(int days, int hours, int minutes, int seconds, int millis, int micros) {
        long secFrac = DateTimeTestUtils$.MODULE$.secFrac(seconds, millis, micros);
        MakeDTInterval durationExpr = new MakeDTInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)days)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hours)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)minutes)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(secFrac, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
        long expected = secFrac + (long)minutes * 60000000L + (long)hours * 3600000000L + (long)days * 86400000000L;
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> durationExpr, BoxesRunTime.boxToLong((long)expected), this.checkEvaluation$default$3());
    }

    private static final int check$default$1$3() {
        return 0;
    }

    private static final int check$default$2$3() {
        return 0;
    }

    private static final int check$default$3$3() {
        return 0;
    }

    private static final int check$default$4$5() {
        return 0;
    }

    private static final int check$default$5$3() {
        return 0;
    }

    private static final int check$default$6$3() {
        return 0;
    }

    private final void checkException$2(int days, int hours, int minutes, int seconds, int millis, int micros) {
        long secFrac = DateTimeTestUtils$.MODULE$.secFrac(seconds, millis, micros);
        MakeDTInterval durationExpr = new MakeDTInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)days)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hours)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)minutes)), (Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply(secFrac, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
        this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> durationExpr, "INTERVAL_ARITHMETIC_OVERFLOW.WITHOUT_SUGGESTION", ClassTag$.MODULE$.apply(ArithmeticException.class));
    }

    private static final int checkException$default$1$2() {
        return 0;
    }

    private static final int checkException$default$2$2() {
        return 0;
    }

    private static final int checkException$default$3$2() {
        return 0;
    }

    private static final int checkException$default$4$2() {
        return 0;
    }

    private static final int checkException$default$5$2() {
        return 0;
    }

    private static final int checkException$default$6$2() {
        return 0;
    }

    public static final /* synthetic */ void $anonfun$new$77(IntervalExpressionsSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Period expected = (Period)tuple2._2();
            if (tuple22 != null) {
                Period period = (Period)tuple22._1();
                Object num = tuple22._2();
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MultiplyYMInterval((Expression)Literal$.MODULE$.apply((Object)period), (Expression)Literal$.MODULE$.apply(num)), expected, $this.checkEvaluation$default$3());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$79(IntervalExpressionsSuite $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            String expectedErrMsg = (String)tuple2._2();
            if (tuple22 != null) {
                Period period = (Period)tuple22._1();
                Object num = tuple22._2();
                $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> new MultiplyYMInterval((Expression)Literal$.MODULE$.apply((Object)period), (Expression)Literal$.MODULE$.apply(num)), expectedErrMsg, ClassTag$.MODULE$.apply(ArithmeticException.class));
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$81(IntervalExpressionsSuite $this, NumericType numType) {
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)it -> {
            $this.checkConsistencyBetweenInterpretedAndCodegenAllowingException((Function2<Expression, Expression, Expression>)(Function2 & Serializable)(interval, num) -> new MultiplyYMInterval(interval, num), (DataType)it, (DataType)numType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$85(IntervalExpressionsSuite $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Duration expected = (Duration)tuple2._2();
            if (tuple22 != null) {
                Duration duration = (Duration)tuple22._1();
                Object num = tuple22._2();
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MultiplyDTInterval((Expression)Literal$.MODULE$.apply((Object)duration), (Expression)Literal$.MODULE$.apply(num)), expected, $this.checkEvaluation$default$3());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$87(IntervalExpressionsSuite $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            String expectedErrMsg = (String)tuple2._2();
            if (tuple22 != null) {
                Duration duration = (Duration)tuple22._1();
                Object num = tuple22._2();
                $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> new MultiplyDTInterval((Expression)Literal$.MODULE$.apply((Object)duration), (Expression)Literal$.MODULE$.apply(num)), expectedErrMsg, ClassTag$.MODULE$.apply(ArithmeticException.class));
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$89(IntervalExpressionsSuite $this, NumericType numType) {
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)it -> {
            $this.checkConsistencyBetweenInterpretedAndCodegenAllowingException((Function2<Expression, Expression, Expression>)(Function2 & Serializable)(interval, num) -> new MultiplyDTInterval(interval, num), (DataType)it, (DataType)numType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$93(IntervalExpressionsSuite $this, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Period expected = (Period)tuple2._2();
            if (tuple22 != null) {
                Period period = (Period)tuple22._1();
                Object num = tuple22._2();
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new DivideYMInterval((Expression)Literal$.MODULE$.apply((Object)period), (Expression)Literal$.MODULE$.apply(num)), expected, $this.checkEvaluation$default$3());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$95(IntervalExpressionsSuite $this, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            String expectedErrMsg = (String)tuple2._2();
            if (tuple22 != null) {
                Period period = (Period)tuple22._1();
                Object num = tuple22._2();
                $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> new DivideYMInterval((Expression)Literal$.MODULE$.apply((Object)period), (Expression)Literal$.MODULE$.apply(num)), expectedErrMsg, ClassTag$.MODULE$.apply(ArithmeticException.class));
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$97(IntervalExpressionsSuite $this, NumericType numType) {
        DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)it -> {
            $this.checkConsistencyBetweenInterpretedAndCodegenAllowingException((Function2<Expression, Expression, Expression>)(Function2 & Serializable)(interval, num) -> new DivideYMInterval(interval, num), (DataType)it, (DataType)numType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$101(IntervalExpressionsSuite $this, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            Duration expected = (Duration)tuple2._2();
            if (tuple22 != null) {
                Duration period = (Duration)tuple22._1();
                Object num = tuple22._2();
                $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new DivideDTInterval((Expression)Literal$.MODULE$.apply((Object)period), (Expression)Literal$.MODULE$.apply(num)), expected, $this.checkEvaluation$default$3());
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$103(IntervalExpressionsSuite $this, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            String expectedErrMsg = (String)tuple2._2();
            if (tuple22 != null) {
                Duration period = (Duration)tuple22._1();
                Object num = tuple22._2();
                $this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> new DivideDTInterval((Expression)Literal$.MODULE$.apply((Object)period), (Expression)Literal$.MODULE$.apply(num)), expectedErrMsg, ClassTag$.MODULE$.apply(ArithmeticException.class));
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$105(IntervalExpressionsSuite $this, NumericType numType) {
        DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)it -> {
            $this.checkConsistencyBetweenInterpretedAndCodegenAllowingException((Function2<Expression, Expression, Expression>)(Function2 & Serializable)(interval, num) -> new DivideDTInterval(interval, num), (DataType)it, (DataType)numType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$109(IntervalExpressionsSuite $this, Period p) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalYears((Expression)Literal$.MODULE$.apply((Object)p)), BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.getYears((int)p.toTotalMonths())), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalMonths((Expression)Literal$.MODULE$.apply((Object)p)), BoxesRunTime.boxToByte((byte)IntervalUtils$.MODULE$.getMonths((int)p.toTotalMonths())), $this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$115(IntervalExpressionsSuite $this, Duration d) {
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalDays((Expression)Literal$.MODULE$.apply((Object)d)), BoxesRunTime.boxToInteger((int)((int)d.toDays())), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalHours((Expression)Literal$.MODULE$.apply((Object)d)), BoxesRunTime.boxToByte((byte)((byte)(d.toHours() % 24L))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalMinutes((Expression)Literal$.MODULE$.apply((Object)d)), BoxesRunTime.boxToByte((byte)((byte)(d.toMinutes() % 60L))), $this.checkEvaluation$default$3());
        $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalSeconds((Expression)Literal$.MODULE$.apply((Object)d)), IntervalUtils$.MODULE$.getSeconds(IntervalUtils$.MODULE$.durationToMicros(d)), $this.checkEvaluation$default$3());
    }

    private final void checkImplicitEvaluation$1(Expression expr, Object value) {
        Expression resolvedExpr = (Expression)TypeCoercion$.MODULE$.ImplicitTypeCasts().transform().apply((Object)expr);
        this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> resolvedExpr, value, this.checkEvaluation$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$137(IntervalExpressionsSuite $this, Duration duration$3, Object num$11, Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 != null) {
            DayTimeIntervalType dt = (DayTimeIntervalType)tuple2._1();
            Duration result = (Duration)tuple2._2();
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new DivideDTInterval((Expression)Literal$.MODULE$.create((Object)duration$3, (DataType)dt), (Expression)Literal$.MODULE$.apply(num$11)), result, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$139(IntervalExpressionsSuite $this, Duration duration$3, Object num$11, Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 != null) {
            DayTimeIntervalType dt = (DayTimeIntervalType)tuple2._1();
            Duration result = (Duration)tuple2._2();
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MultiplyDTInterval((Expression)Literal$.MODULE$.create((Object)duration$3, (DataType)dt), (Expression)Literal$.MODULE$.apply(num$11)), result, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$136(IntervalExpressionsSuite $this, Tuple3 x0$9) {
        Tuple3 tuple3 = x0$9;
        if (tuple3 != null) {
            Tuple2 tuple2 = (Tuple2)tuple3._1();
            Duration[] divideExpected = (Duration[])tuple3._2();
            Duration[] multiplyExpected = (Duration[])tuple3._3();
            if (tuple2 != null) {
                Duration duration = (Duration)tuple2._1();
                Object num = tuple2._2();
                ((IterableOnceOps)DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])divideExpected))).foreach((Function1 & Serializable)x0$10 -> {
                    IntervalExpressionsSuite.$anonfun$new$137($this, duration, num, x0$10);
                    return BoxedUnit.UNIT;
                });
                ((IterableOnceOps)DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])multiplyExpected))).foreach((Function1 & Serializable)x0$11 -> {
                    IntervalExpressionsSuite.$anonfun$new$139($this, duration, num, x0$11);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$new$143(IntervalExpressionsSuite $this, Period period$7, Object num$12, Tuple2 x0$13) {
        Tuple2 tuple2 = x0$13;
        if (tuple2 != null) {
            YearMonthIntervalType dt = (YearMonthIntervalType)tuple2._1();
            Period result = (Period)tuple2._2();
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new DivideYMInterval((Expression)Literal$.MODULE$.create((Object)period$7, (DataType)dt), (Expression)Literal$.MODULE$.apply(num$12)), result, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$145(IntervalExpressionsSuite $this, Period period$7, Object num$12, Tuple2 x0$14) {
        Tuple2 tuple2 = x0$14;
        if (tuple2 != null) {
            YearMonthIntervalType dt = (YearMonthIntervalType)tuple2._1();
            Period result = (Period)tuple2._2();
            $this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MultiplyYMInterval((Expression)Literal$.MODULE$.create((Object)period$7, (DataType)dt), (Expression)Literal$.MODULE$.apply(num$12)), result, $this.checkEvaluation$default$3());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$142(IntervalExpressionsSuite $this, Tuple3 x0$12) {
        Tuple3 tuple3 = x0$12;
        if (tuple3 != null) {
            Tuple2 tuple2 = (Tuple2)tuple3._1();
            Period[] divideExpected = (Period[])tuple3._2();
            Period[] multiplyExpected = (Period[])tuple3._3();
            if (tuple2 != null) {
                Period period = (Period)tuple2._1();
                Object num = tuple2._2();
                ((IterableOnceOps)DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])divideExpected))).foreach((Function1 & Serializable)x0$13 -> {
                    IntervalExpressionsSuite.$anonfun$new$143($this, period, num, x0$13);
                    return BoxedUnit.UNIT;
                });
                ((IterableOnceOps)DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])multiplyExpected))).foreach((Function1 & Serializable)x0$14 -> {
                    IntervalExpressionsSuite.$anonfun$new$145($this, period, num, x0$14);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        throw new MatchError((Object)tuple3);
    }

    public IntervalExpressionsSuite() {
        Whenever.$init$((Whenever)this);
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        ScalaCheckDrivenPropertyChecks.$init$((ScalaCheckDrivenPropertyChecks)this);
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        PlanTestBase.$init$(this);
        ExpressionEvalHelper.$init$(this);
        this.test("years", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalYears((Expression)this.interval("0 years")), BoxesRunTime.boxToInteger((int)0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalYears((Expression)this.interval("9999 years")), BoxesRunTime.boxToInteger((int)9999), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalYears((Expression)this.interval("1000 years")), BoxesRunTime.boxToInteger((int)1000), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalYears((Expression)this.interval("-2000 years")), BoxesRunTime.boxToInteger((int)-2000), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalYears((Expression)this.interval("9 years 400 days")), BoxesRunTime.boxToInteger((int)9), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalYears((Expression)this.interval("9 years 12 months")), BoxesRunTime.boxToInteger((int)10), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalYears((Expression)this.interval("10 years -1 months")), BoxesRunTime.boxToInteger((int)9), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("months", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMonths((Expression)this.interval("0 year")), BoxesRunTime.boxToByte((byte)((byte)0)), this.checkEvaluation$default$3());
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(-24), 24).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)m -> this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMonths((Expression)this.interval(m + " months")), BoxesRunTime.boxToByte((byte)((byte)(m % 12))), this.checkEvaluation$default$3()));
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMonths((Expression)this.interval("1 year 10 months")), BoxesRunTime.boxToByte((byte)((byte)10)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMonths((Expression)this.interval("-2 year -10 months")), BoxesRunTime.boxToByte((byte)((byte)-10)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMonths((Expression)this.interval("9999 years")), BoxesRunTime.boxToByte((byte)((byte)0)), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.largeInterval = "9999 years 11 months 31 days 11 hours 59 minutes 59 seconds 999 milliseconds 999 microseconds";
        this.test("days", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalDays((Expression)this.interval("0 days")), BoxesRunTime.boxToInteger((int)0), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalDays((Expression)this.interval("1 days 100 seconds")), BoxesRunTime.boxToInteger((int)1), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalDays((Expression)this.interval("-1 days -100 seconds")), BoxesRunTime.boxToInteger((int)-1), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalDays((Expression)this.interval("-365 days")), BoxesRunTime.boxToInteger((int)-365), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalDays((Expression)this.interval("365 days")), BoxesRunTime.boxToInteger((int)365), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalDays((Expression)this.interval("100 year 10 months 5 days")), BoxesRunTime.boxToInteger((int)5), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalDays((Expression)this.interval(this.largeInterval())), BoxesRunTime.boxToInteger((int)31), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalDays((Expression)this.interval("25 hours")), BoxesRunTime.boxToInteger((int)1), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("hours", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalHours((Expression)this.interval("0 hours")), BoxesRunTime.boxToByte((byte)((byte)0)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalHours((Expression)this.interval("1 hour")), BoxesRunTime.boxToByte((byte)((byte)1)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalHours((Expression)this.interval("-1 hour")), BoxesRunTime.boxToByte((byte)((byte)-1)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalHours((Expression)this.interval("23 hours")), BoxesRunTime.boxToByte((byte)((byte)23)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalHours((Expression)this.interval("-23 hours")), BoxesRunTime.boxToByte((byte)((byte)-23)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalHours((Expression)this.interval("100 year 10 months 10 days 10 hours")), BoxesRunTime.boxToByte((byte)((byte)10)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalHours((Expression)this.interval("10 hours 100 minutes")), BoxesRunTime.boxToByte((byte)((byte)11)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalHours((Expression)this.interval(this.largeInterval())), BoxesRunTime.boxToByte((byte)((byte)11)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalHours((Expression)this.interval("25 hours")), BoxesRunTime.boxToByte((byte)((byte)1)), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("minutes", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("0 minute")), BoxesRunTime.boxToByte((byte)((byte)0)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("1 minute")), BoxesRunTime.boxToByte((byte)((byte)1)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("-1 minute")), BoxesRunTime.boxToByte((byte)((byte)-1)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("59 minute")), BoxesRunTime.boxToByte((byte)((byte)59)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("-59 minute")), BoxesRunTime.boxToByte((byte)((byte)-59)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval("100 year 10 months 10 minutes")), BoxesRunTime.boxToByte((byte)((byte)10)), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalMinutes((Expression)this.interval(this.largeInterval())), BoxesRunTime.boxToByte((byte)((byte)59)), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("seconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("0 second")), Decimal$.MODULE$.apply(0L, 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("1 second")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(1.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("-1 second")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(-1.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("1 minute 59 second")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(59.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("-59 minutes -59 seconds")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(-59.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("100 year 10 months 10 seconds")), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(10.0), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval(this.largeInterval())), Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(59.999999), 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("10 seconds 1 milliseconds 1 microseconds")), Decimal$.MODULE$.apply(10001001L, 8, 6), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractIntervalSeconds((Expression)this.interval("61 seconds 1 microseconds")), Decimal$.MODULE$.apply(1000001L, 8, 6), this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("cast large seconds to decimal", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new Cast((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)Decimal$.MODULE$.apply("9223372036854.775807")), (DataType)new DayTimeIntervalType(3, 3), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), (DataType)new DecimalType(19, 6), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), Decimal$.MODULE$.apply("9223372036854.775807"), this.checkEvaluation$default$3()), new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("multiply", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$1("0 seconds", 10.0, "0 seconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("10 hours", 0.0, "0 hours", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("12 months 1 microseconds", 2.0, "2 years 2 microseconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("-5 year 3 seconds", 3.0, "-15 years 9 seconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("1 year 1 second", 0.5, "6 months 500 milliseconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("-100 years -1 millisecond", 0.5, "-50 years -500 microseconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("2 months 4 seconds", -0.5, "-1 months -2 seconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("1 month 2 microseconds", 1.5, "1 months 3 microseconds", IntervalExpressionsSuite.check$default$4$1());
            this.check$1("2 months", 2.147483647E9, "integer overflow", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.check$1("2 months", 2.147483647E9, Integer.MAX_VALUE + " months", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("divide", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$2("0 seconds", 10.0, "0 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("12 months 3 milliseconds", 2.0, "6 months 0.0015 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("-5 year 3 seconds", 3.0, "-1 years -8 months 1 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("6 years -7 seconds", 3.0, "2 years -2.333333 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("2 years -8 seconds", 0.5, "4 years -16 seconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("-1 month 2 microseconds", -0.25, "4 months -8 microseconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("1 month 3 microsecond", 1.5, "2 microseconds", IntervalExpressionsSuite.check$default$4$2());
            this.check$2("1 second", 0.0, "Division by zero", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.check$2("1 second", 0.0, null, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
            this.check$2(Integer.MAX_VALUE + " months", 0.9, "integer overflow", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.check$2(Integer.MAX_VALUE + " months", 0.9, Integer.MAX_VALUE + " months", (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("make interval", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            boolean x$1 = false;
            boolean x$2 = false;
            boolean x$3 = false;
            int x$4 = IntervalExpressionsSuite.check$default$1$1();
            int x$5 = IntervalExpressionsSuite.check$default$3$1();
            int x$6 = IntervalExpressionsSuite.check$default$5$1();
            int x$7 = IntervalExpressionsSuite.check$default$6$1();
            int x$8 = IntervalExpressionsSuite.check$default$7$1();
            int x$9 = IntervalExpressionsSuite.check$default$8$1();
            this.check$3(x$4, 0, x$5, 0, x$6, x$7, x$8, x$9, 0);
            this.check$3(-123, IntervalExpressionsSuite.check$default$2$1(), IntervalExpressionsSuite.check$default$3$1(), IntervalExpressionsSuite.check$default$4$3(), IntervalExpressionsSuite.check$default$5$1(), IntervalExpressionsSuite.check$default$6$1(), IntervalExpressionsSuite.check$default$7$1(), IntervalExpressionsSuite.check$default$8$1(), IntervalExpressionsSuite.check$default$9$1());
            int x$10 = 123;
            int x$11 = IntervalExpressionsSuite.check$default$1$1();
            int x$12 = IntervalExpressionsSuite.check$default$2$1();
            int x$13 = IntervalExpressionsSuite.check$default$4$3();
            int x$14 = IntervalExpressionsSuite.check$default$5$1();
            int x$15 = IntervalExpressionsSuite.check$default$6$1();
            int x$16 = IntervalExpressionsSuite.check$default$7$1();
            int x$17 = IntervalExpressionsSuite.check$default$8$1();
            int x$18 = IntervalExpressionsSuite.check$default$9$1();
            this.check$3(x$11, x$12, 123, x$13, x$14, x$15, x$16, x$17, x$18);
            int x$19 = -123;
            int x$20 = IntervalExpressionsSuite.check$default$1$1();
            int x$21 = IntervalExpressionsSuite.check$default$2$1();
            int x$22 = IntervalExpressionsSuite.check$default$3$1();
            int x$23 = IntervalExpressionsSuite.check$default$4$3();
            int x$24 = IntervalExpressionsSuite.check$default$5$1();
            int x$25 = IntervalExpressionsSuite.check$default$6$1();
            int x$26 = IntervalExpressionsSuite.check$default$7$1();
            int x$27 = IntervalExpressionsSuite.check$default$9$1();
            this.check$3(x$20, x$21, x$22, x$23, x$24, x$25, x$26, -123, x$27);
            this.check$3(9999, 11, 0, 31, 23, 59, 59, 999, 999);
            int x$28 = 10000;
            int x$29 = -1;
            int x$30 = IntervalExpressionsSuite.check$default$2$1();
            int x$31 = IntervalExpressionsSuite.check$default$3$1();
            int x$32 = IntervalExpressionsSuite.check$default$4$3();
            int x$33 = IntervalExpressionsSuite.check$default$5$1();
            int x$34 = IntervalExpressionsSuite.check$default$6$1();
            int x$35 = IntervalExpressionsSuite.check$default$7$1();
            int x$36 = IntervalExpressionsSuite.check$default$8$1();
            this.check$3(10000, x$30, x$31, x$32, x$33, x$34, x$35, x$36, -1);
            this.check$3(-9999, -11, 0, -31, -23, -59, -59, -999, -999);
            int x$37 = -10000;
            boolean x$38 = true;
            int x$39 = IntervalExpressionsSuite.check$default$2$1();
            int x$40 = IntervalExpressionsSuite.check$default$3$1();
            int x$41 = IntervalExpressionsSuite.check$default$4$3();
            int x$42 = IntervalExpressionsSuite.check$default$5$1();
            int x$43 = IntervalExpressionsSuite.check$default$6$1();
            int x$44 = IntervalExpressionsSuite.check$default$7$1();
            int x$45 = IntervalExpressionsSuite.check$default$8$1();
            this.check$3(-10000, x$39, x$40, x$41, x$42, x$43, x$44, x$45, 1);
            int x$46 = Integer.MAX_VALUE;
            int x$47 = Integer.MAX_VALUE;
            int x$48 = Integer.MAX_VALUE;
            int x$49 = Integer.MAX_VALUE;
            int x$50 = Integer.MAX_VALUE;
            int x$51 = IntervalExpressionsSuite.check$default$1$1();
            int x$52 = IntervalExpressionsSuite.check$default$2$1();
            int x$53 = IntervalExpressionsSuite.check$default$3$1();
            int x$54 = IntervalExpressionsSuite.check$default$4$3();
            this.check$3(x$51, x$52, x$53, x$54, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("ANSI mode: make interval", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            boolean x$55 = false;
            boolean x$56 = false;
            boolean x$57 = false;
            int x$58 = IntervalExpressionsSuite.check$default$1$2();
            int x$59 = IntervalExpressionsSuite.check$default$3$2();
            int x$60 = IntervalExpressionsSuite.check$default$5$2();
            int x$61 = IntervalExpressionsSuite.check$default$6$2();
            int x$62 = IntervalExpressionsSuite.check$default$7$2();
            int x$63 = IntervalExpressionsSuite.check$default$8$2();
            this.check$4(x$58, 0, x$59, 0, x$60, x$61, x$62, x$63, 0);
            this.check$4(-123, IntervalExpressionsSuite.check$default$2$2(), IntervalExpressionsSuite.check$default$3$2(), IntervalExpressionsSuite.check$default$4$4(), IntervalExpressionsSuite.check$default$5$2(), IntervalExpressionsSuite.check$default$6$2(), IntervalExpressionsSuite.check$default$7$2(), IntervalExpressionsSuite.check$default$8$2(), IntervalExpressionsSuite.check$default$9$2());
            int x$64 = 123;
            int x$65 = IntervalExpressionsSuite.check$default$1$2();
            int x$66 = IntervalExpressionsSuite.check$default$2$2();
            int x$67 = IntervalExpressionsSuite.check$default$4$4();
            int x$68 = IntervalExpressionsSuite.check$default$5$2();
            int x$69 = IntervalExpressionsSuite.check$default$6$2();
            int x$70 = IntervalExpressionsSuite.check$default$7$2();
            int x$71 = IntervalExpressionsSuite.check$default$8$2();
            int x$72 = IntervalExpressionsSuite.check$default$9$2();
            this.check$4(x$65, x$66, 123, x$67, x$68, x$69, x$70, x$71, x$72);
            int x$73 = -123;
            int x$74 = IntervalExpressionsSuite.check$default$1$2();
            int x$75 = IntervalExpressionsSuite.check$default$2$2();
            int x$76 = IntervalExpressionsSuite.check$default$3$2();
            int x$77 = IntervalExpressionsSuite.check$default$4$4();
            int x$78 = IntervalExpressionsSuite.check$default$5$2();
            int x$79 = IntervalExpressionsSuite.check$default$6$2();
            int x$80 = IntervalExpressionsSuite.check$default$7$2();
            int x$81 = IntervalExpressionsSuite.check$default$9$2();
            this.check$4(x$74, x$75, x$76, x$77, x$78, x$79, x$80, -123, x$81);
            this.check$4(9999, 11, 0, 31, 23, 59, 59, 999, 999);
            int x$82 = 10000;
            int x$83 = -1;
            int x$84 = IntervalExpressionsSuite.check$default$2$2();
            int x$85 = IntervalExpressionsSuite.check$default$3$2();
            int x$86 = IntervalExpressionsSuite.check$default$4$4();
            int x$87 = IntervalExpressionsSuite.check$default$5$2();
            int x$88 = IntervalExpressionsSuite.check$default$6$2();
            int x$89 = IntervalExpressionsSuite.check$default$7$2();
            int x$90 = IntervalExpressionsSuite.check$default$8$2();
            this.check$4(10000, x$84, x$85, x$86, x$87, x$88, x$89, x$90, -1);
            this.check$4(-9999, -11, 0, -31, -23, -59, -59, -999, -999);
            int x$91 = -10000;
            boolean x$92 = true;
            int x$93 = IntervalExpressionsSuite.check$default$2$2();
            int x$94 = IntervalExpressionsSuite.check$default$3$2();
            int x$95 = IntervalExpressionsSuite.check$default$4$4();
            int x$96 = IntervalExpressionsSuite.check$default$5$2();
            int x$97 = IntervalExpressionsSuite.check$default$6$2();
            int x$98 = IntervalExpressionsSuite.check$default$7$2();
            int x$99 = IntervalExpressionsSuite.check$default$8$2();
            this.check$4(-10000, x$93, x$94, x$95, x$96, x$97, x$98, x$99, 1);
            int x$100 = Integer.MAX_VALUE;
            int x$101 = Integer.MAX_VALUE;
            int x$102 = Integer.MAX_VALUE;
            int x$103 = Integer.MAX_VALUE;
            int x$104 = Integer.MAX_VALUE;
            int x$105 = IntervalExpressionsSuite.check$default$1$2();
            int x$106 = IntervalExpressionsSuite.check$default$2$2();
            int x$107 = IntervalExpressionsSuite.check$default$3$2();
            int x$108 = IntervalExpressionsSuite.check$default$4$4();
            this.check$4(x$105, x$106, x$107, x$108, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.checkException$1(Integer.MAX_VALUE, IntervalExpressionsSuite.checkException$default$2$1(), IntervalExpressionsSuite.checkException$default$3$1(), IntervalExpressionsSuite.checkException$default$4$1(), IntervalExpressionsSuite.checkException$default$5$1(), IntervalExpressionsSuite.checkException$default$6$1(), IntervalExpressionsSuite.checkException$default$7$1(), IntervalExpressionsSuite.checkException$default$8$1(), IntervalExpressionsSuite.checkException$default$9$1());
            int x$109 = Integer.MAX_VALUE;
            int x$110 = IntervalExpressionsSuite.checkException$default$1$1();
            int x$111 = IntervalExpressionsSuite.checkException$default$2$1();
            int x$112 = IntervalExpressionsSuite.checkException$default$4$1();
            int x$113 = IntervalExpressionsSuite.checkException$default$5$1();
            int x$114 = IntervalExpressionsSuite.checkException$default$6$1();
            int x$115 = IntervalExpressionsSuite.checkException$default$7$1();
            int x$116 = IntervalExpressionsSuite.checkException$default$8$1();
            int x$117 = IntervalExpressionsSuite.checkException$default$9$1();
            this.checkException$1(x$110, x$111, Integer.MAX_VALUE, x$112, x$113, x$114, x$115, x$116, x$117);
        }), new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("SPARK-35130: make day time interval", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$118 = -123;
            int x$119 = IntervalExpressionsSuite.check$default$1$3();
            int x$120 = IntervalExpressionsSuite.check$default$2$3();
            int x$121 = IntervalExpressionsSuite.check$default$3$3();
            int x$122 = IntervalExpressionsSuite.check$default$4$5();
            int x$123 = IntervalExpressionsSuite.check$default$6$3();
            this.check$5(x$119, x$120, x$121, x$122, -123, x$123);
            this.check$5(31, 23, 59, 59, 999, 999);
            this.check$5(31, 123, 159, 159, 1999, 1999);
            int x$124 = 10000;
            int x$125 = -1;
            int x$126 = IntervalExpressionsSuite.check$default$2$3();
            int x$127 = IntervalExpressionsSuite.check$default$3$3();
            int x$128 = IntervalExpressionsSuite.check$default$4$5();
            int x$129 = IntervalExpressionsSuite.check$default$5$3();
            this.check$5(10000, x$126, x$127, x$128, x$129, -1);
            this.check$5(-31, -23, -59, -59, -999, -999);
            int x$130 = -10000;
            boolean x$131 = true;
            int x$132 = IntervalExpressionsSuite.check$default$2$3();
            int x$133 = IntervalExpressionsSuite.check$default$3$3();
            int x$134 = IntervalExpressionsSuite.check$default$4$5();
            int x$135 = IntervalExpressionsSuite.check$default$5$3();
            this.check$5(-10000, x$132, x$133, x$134, x$135, 1);
            int x$136 = Integer.MAX_VALUE;
            int x$137 = Integer.MAX_VALUE;
            int x$138 = Integer.MAX_VALUE;
            int x$139 = Integer.MAX_VALUE;
            int x$140 = Integer.MAX_VALUE;
            int x$141 = IntervalExpressionsSuite.check$default$1$3();
            this.check$5(x$141, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.checkException$2(Integer.MAX_VALUE, IntervalExpressionsSuite.checkException$default$2$2(), IntervalExpressionsSuite.checkException$default$3$2(), IntervalExpressionsSuite.checkException$default$4$2(), IntervalExpressionsSuite.checkException$default$5$2(), IntervalExpressionsSuite.checkException$default$6$2());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
        this.test("SPARK-34824: multiply year-month interval by numeric", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(-123), (Object)new Literal(null, (DataType)DecimalType$.MODULE$.USER_DEFAULT()))), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(0), (Object)BoxesRunTime.boxToInteger((int)10))), (Object)Period.ofMonths(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(10), (Object)BoxesRunTime.boxToLong((long)0L))), (Object)Period.ofMonths(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(100), (Object)BoxesRunTime.boxToByte((byte)((byte)-1)))), (Object)Period.ofYears(-100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(12), (Object)BoxesRunTime.boxToFloat((float)0.3f))), (Object)Period.ofMonths(4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(-1000), (Object)BoxesRunTime.boxToDouble((double)0.3))), (Object)Period.ofYears(-300)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(9999), (Object)BoxesRunTime.boxToDouble((double)1.0E-4))), (Object)Period.ofYears(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(9999), (Object)scala.package$.MODULE$.BigDecimal().apply(1.0E-4))), (Object)Period.ofYears(1))})).foreach((Function1 & Serializable)x0$1 -> {
                IntervalExpressionsSuite.$anonfun$new$77(this, x0$1);
                return BoxedUnit.UNIT;
            });
            new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(2), (Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE))), (Object)"overflow"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(Integer.MIN_VALUE), (Object)BoxesRunTime.boxToDouble((double)10.0))), (Object)"out of range"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(-100), (Object)BoxesRunTime.boxToFloat((float)Float.NaN))), (Object)"input is infinite or NaN"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(200), (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)"input is infinite or NaN"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(-200), (Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY))), (Object)"input is infinite or NaN"), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)x0$2 -> {
                IntervalExpressionsSuite.$anonfun$new$79(this, x0$2);
                return BoxedUnit.UNIT;
            });
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable)numType -> {
                IntervalExpressionsSuite.$anonfun$new$81(this, numType);
                return BoxedUnit.UNIT;
            });
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.test("SPARK-34850: multiply day-time interval by numeric", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofHours(-123L), (Object)new Literal(null, (DataType)DecimalType$.MODULE$.USER_DEFAULT()))), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofMinutes(0L), (Object)BoxesRunTime.boxToInteger((int)10))), (Object)Duration.ofMinutes(0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofSeconds(10L), (Object)BoxesRunTime.boxToLong((long)0L))), (Object)Duration.ofSeconds(0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofMillis(100L), (Object)BoxesRunTime.boxToByte((byte)((byte)-1)))), (Object)Duration.ofMillis(-100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(12L), (Object)BoxesRunTime.boxToDouble((double)0.3))), (Object)Duration.ofDays(12L).multipliedBy(3L).dividedBy(10L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.of(-1000L, ChronoUnit.MICROS), (Object)BoxesRunTime.boxToFloat((float)0.3f))), (Object)Duration.of(-300L, ChronoUnit.MICROS)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(9999L), (Object)BoxesRunTime.boxToDouble((double)1.0E-4))), (Object)Duration.ofDays(9999L).dividedBy(10000L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(9999L), (Object)scala.package$.MODULE$.BigDecimal().apply(1.0E-4))), (Object)Duration.ofDays(9999L).dividedBy(10000L))})).foreach((Function1 & Serializable)x0$3 -> {
                IntervalExpressionsSuite.$anonfun$new$85(this, x0$3);
                return BoxedUnit.UNIT;
            });
            new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(-100L), (Object)BoxesRunTime.boxToFloat((float)Float.NaN))), (Object)"input is infinite or NaN"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(2L), (Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE))), (Object)"overflow"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofHours(Integer.MIN_VALUE), (Object)BoxesRunTime.boxToShort((short)Short.MIN_VALUE))), (Object)"overflow"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(10L), (Object)scala.package$.MODULE$.BigDecimal().apply(Long.MIN_VALUE))), (Object)"Overflow"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(200L), (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)"input is infinite or NaN"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(-200L), (Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY))), (Object)"input is infinite or NaN"), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)x0$4 -> {
                IntervalExpressionsSuite.$anonfun$new$87(this, x0$4);
                return BoxedUnit.UNIT;
            });
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable)numType -> {
                IntervalExpressionsSuite.$anonfun$new$89(this, numType);
                return BoxedUnit.UNIT;
            });
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("SPARK-34868: divide year-month interval by numeric", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(-123), (Object)new Literal(null, (DataType)DecimalType$.MODULE$.USER_DEFAULT()))), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(0), (Object)BoxesRunTime.boxToInteger((int)10))), (Object)Period.ofMonths(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(200), (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)Period.ofMonths(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(-200), (Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY))), (Object)Period.ofMonths(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(100), (Object)BoxesRunTime.boxToByte((byte)((byte)-1)))), (Object)Period.ofYears(-100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(1), (Object)BoxesRunTime.boxToShort((short)((short)2)))), (Object)Period.ofMonths(6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(-1), (Object)BoxesRunTime.boxToInteger((int)-3))), (Object)Period.ofMonths(4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(-1000), (Object)BoxesRunTime.boxToFloat((float)0.5f))), (Object)Period.ofMonths(-2000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofYears(1000), (Object)BoxesRunTime.boxToDouble((double)100.0))), (Object)Period.ofYears(10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(2), (Object)scala.package$.MODULE$.BigDecimal().apply(0.1))), (Object)Period.ofMonths(20))})).foreach((Function1 & Serializable)x0$5 -> {
                IntervalExpressionsSuite.$anonfun$new$93(this, x0$5);
                return BoxedUnit.UNIT;
            });
            new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(1), (Object)BoxesRunTime.boxToInteger((int)0))), (Object)"Division by zero"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(Integer.MIN_VALUE), (Object)BoxesRunTime.boxToDouble((double)0.0))), (Object)"Division by zero"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Period.ofMonths(-100), (Object)BoxesRunTime.boxToFloat((float)Float.NaN))), (Object)"input is infinite or NaN"), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)x0$6 -> {
                IntervalExpressionsSuite.$anonfun$new$95(this, x0$6);
                return BoxedUnit.UNIT;
            });
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable)numType -> {
                IntervalExpressionsSuite.$anonfun$new$97(this, numType);
                return BoxedUnit.UNIT;
            });
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("SPARK-34875: divide day-time interval by numeric", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(-123L), (Object)new Literal(null, (DataType)DecimalType$.MODULE$.USER_DEFAULT()))), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ZERO, (Object)BoxesRunTime.boxToInteger((int)10))), (Object)Duration.ZERO), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofMillis(200L), (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)Duration.ZERO), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofSeconds(-200L), (Object)BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY))), (Object)Duration.ZERO), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofMinutes(100L), (Object)BoxesRunTime.boxToByte((byte)((byte)-1)))), (Object)Duration.ofMinutes(-100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofHours(1L), (Object)BoxesRunTime.boxToShort((short)((short)2)))), (Object)Duration.ofMinutes(30L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(-1L), (Object)BoxesRunTime.boxToInteger((int)-3))), (Object)Duration.ofHours(8L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.of(-1000L, ChronoUnit.MICROS), (Object)BoxesRunTime.boxToFloat((float)0.5f))), (Object)Duration.of(-2000L, ChronoUnit.MICROS)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(10080L), (Object)BoxesRunTime.boxToDouble((double)100.0))), (Object)Duration.ofDays(10080L).dividedBy(100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofMillis(2L), (Object)scala.package$.MODULE$.BigDecimal().apply(-0.1))), (Object)Duration.ofMillis(-20L))})).foreach((Function1 & Serializable)x0$7 -> {
                IntervalExpressionsSuite.$anonfun$new$101(this, x0$7);
                return BoxedUnit.UNIT;
            });
            new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofDays(1L), (Object)BoxesRunTime.boxToInteger((int)0))), (Object)"Division by zero"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofMillis(Integer.MIN_VALUE), (Object)BoxesRunTime.boxToDouble((double)0.0))), (Object)"Division by zero"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)Duration.ofSeconds(-100L), (Object)BoxesRunTime.boxToFloat((float)Float.NaN))), (Object)"input is infinite or NaN"), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)x0$8 -> {
                IntervalExpressionsSuite.$anonfun$new$103(this, x0$8);
                return BoxedUnit.UNIT;
            });
            DataTypeTestUtils$.MODULE$.numericTypes().foreach((Function1 & Serializable)numType -> {
                IntervalExpressionsSuite.$anonfun$new$105(this, numType);
                return BoxedUnit.UNIT;
            });
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        this.test("ANSI: extract years and months", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            new .colon.colon((Object)Period.ZERO, (List)new .colon.colon((Object)Period.ofMonths(100), (List)new .colon.colon((Object)Period.ofMonths(-100), (List)new .colon.colon((Object)Period.ofYears(100), (List)new .colon.colon((Object)Period.ofYears(-100), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)p -> {
                IntervalExpressionsSuite.$anonfun$new$109(this, p);
                return BoxedUnit.UNIT;
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalYears((Expression)new Literal(null, (DataType)YearMonthIntervalType$.MODULE$.apply())), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalMonths((Expression)new Literal(null, (DataType)YearMonthIntervalType$.MODULE$.apply())), null, this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
        this.test("ANSI: extract days, hours, minutes and seconds", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            new .colon.colon((Object)Duration.ZERO, (List)new .colon.colon((Object)Duration.ofMillis(86402000L), (List)new .colon.colon((Object)Duration.ofMillis(-86398000L), (List)new .colon.colon((Object)Duration.ofDays(100L), (List)new .colon.colon((Object)Duration.ofDays(-100L), (List)new .colon.colon((Object)Duration.ofHours(-100L), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)d -> {
                IntervalExpressionsSuite.$anonfun$new$115(this, d);
                return BoxedUnit.UNIT;
            });
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalDays((Expression)new Literal(null, (DataType)DayTimeIntervalType$.MODULE$.apply())), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalHours((Expression)new Literal(null, (DataType)DayTimeIntervalType$.MODULE$.apply())), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalMinutes((Expression)new Literal(null, (DataType)DayTimeIntervalType$.MODULE$.apply())), null, this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new ExtractANSIIntervalSeconds((Expression)new Literal(null, (DataType)DayTimeIntervalType$.MODULE$.apply())), null, this.checkEvaluation$default$3());
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
        this.test("SPARK-35129: make_ym_interval", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))), BoxesRunTime.boxToInteger((int)10), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))), BoxesRunTime.boxToInteger((int)22), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))), BoxesRunTime.boxToInteger((int)12), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1))), BoxesRunTime.boxToInteger((int)11), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-2)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1))), BoxesRunTime.boxToInteger((int)-25), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0xAAAAAAA)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7))), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), this.checkEvaluation$default$3());
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-178956970)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-8))), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), this.checkEvaluation$default$3());
            new .colon.colon((Object)new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0xAAAAAAA)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)8))), (List)new .colon.colon((Object)new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-178956970)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-9))), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)ym -> {
                this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> ym, "INTERVAL_ARITHMETIC_OVERFLOW.WITHOUT_SUGGESTION", ClassTag$.MODULE$.apply(ArithmeticException.class));
                return BoxedUnit.UNIT;
            });
            this.checkImplicitEvaluation$1((Expression)new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)-1L))), BoxesRunTime.boxToInteger((int)11));
            this.checkImplicitEvaluation$1((Expression)new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)-1L))), BoxesRunTime.boxToInteger((int)11));
            this.checkImplicitEvaluation$1((Expression)new MakeYMInterval((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.1)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)-1L))), BoxesRunTime.boxToInteger((int)11));
        }, new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        this.test("SPARK-35728: Check multiply/divide of day-time intervals of any fields by numeric", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)new Tuple3((Object)new Tuple2((Object)Duration.ofMinutes(0L), (Object)BoxesRunTime.boxToInteger((int)10)), (Object)new Duration[]{Duration.ofDays(0L), Duration.ofHours(0L), Duration.ofMinutes(0L), Duration.ofSeconds(0L), Duration.ofHours(0L), Duration.ofMinutes(0L), Duration.ofSeconds(0L), Duration.ofMinutes(0L), Duration.ofSeconds(0L), Duration.ofSeconds(0L)}, (Object)new Duration[]{Duration.ofDays(0L), Duration.ofHours(0L), Duration.ofMinutes(0L), Duration.ofSeconds(0L), Duration.ofHours(0L), Duration.ofMinutes(0L), Duration.ofSeconds(0L), Duration.ofMinutes(0L), Duration.ofSeconds(0L), Duration.ofSeconds(0L)}), (List)new .colon.colon((Object)new Tuple3((Object)new Tuple2((Object)Duration.ofSeconds(90061L), (Object)BoxesRunTime.boxToLong((long)1L)), (Object)new Duration[]{Duration.ofSeconds(86400L), Duration.ofSeconds(90000L), Duration.ofSeconds(90060L), Duration.ofSeconds(90061L), Duration.ofSeconds(90000L), Duration.ofSeconds(90060L), Duration.ofSeconds(90061L), Duration.ofSeconds(90060L), Duration.ofSeconds(90061L), Duration.ofSeconds(90061L)}, (Object)new Duration[]{Duration.ofSeconds(86400L), Duration.ofSeconds(90000L), Duration.ofSeconds(90060L), Duration.ofSeconds(90061L), Duration.ofSeconds(90000L), Duration.ofSeconds(90060L), Duration.ofSeconds(90061L), Duration.ofSeconds(90060L), Duration.ofSeconds(90061L), Duration.ofSeconds(90061L)}), (List)new .colon.colon((Object)new Tuple3((Object)new Tuple2((Object)Duration.ofSeconds(90061L), (Object)BoxesRunTime.boxToByte((byte)((byte)-1))), (Object)new Duration[]{Duration.ofSeconds(-86400L), Duration.ofSeconds(-90000L), Duration.ofSeconds(-90060L), Duration.ofSeconds(-90061L), Duration.ofSeconds(-90000L), Duration.ofSeconds(-90060L), Duration.ofSeconds(-90061L), Duration.ofSeconds(-90060L), Duration.ofSeconds(-90061L), Duration.ofSeconds(-90061L)}, (Object)new Duration[]{Duration.ofSeconds(-86400L), Duration.ofSeconds(-90000L), Duration.ofSeconds(-90060L), Duration.ofSeconds(-90061L), Duration.ofSeconds(-90000L), Duration.ofSeconds(-90060L), Duration.ofSeconds(-90061L), Duration.ofSeconds(-90060L), Duration.ofSeconds(-90061L), Duration.ofSeconds(-90061L)}), (List)new .colon.colon((Object)new Tuple3((Object)new Tuple2((Object)Duration.ofSeconds(90061L), (Object)BoxesRunTime.boxToDouble((double)0.3)), (Object)new Duration[]{Duration.ofSeconds(288000L), Duration.ofSeconds(300000L), Duration.ofSeconds(300200L), Duration.ofNanos(300203333333000L), Duration.ofSeconds(300000L), Duration.ofSeconds(300200L), Duration.ofNanos(300203333333000L), Duration.ofSeconds(300200L), Duration.ofNanos(300203333333000L), Duration.ofNanos(300203333333000L)}, (Object)new Duration[]{Duration.ofSeconds(25920L), Duration.ofSeconds(27000L), Duration.ofSeconds(27018L), Duration.ofMillis(27018300L), Duration.ofSeconds(27000L), Duration.ofSeconds(27018L), Duration.ofMillis(27018300L), Duration.ofSeconds(27018L), Duration.ofMillis(27018300L), Duration.ofMillis(27018300L)}), (List)new .colon.colon((Object)new Tuple3((Object)new Tuple2((Object)Duration.of(-1000L, ChronoUnit.MICROS), (Object)BoxesRunTime.boxToFloat((float)0.3f)), (Object)new Duration[]{Duration.ofSeconds(0L), Duration.ofSeconds(0L), Duration.ofSeconds(0L), Duration.ofNanos(-3333000L), Duration.ofSeconds(0L), Duration.ofSeconds(0L), Duration.ofNanos(-3333000L), Duration.ofSeconds(0L), Duration.ofNanos(-3333000L), Duration.ofNanos(-3333000L)}, (Object)new Duration[]{Duration.ofSeconds(0L), Duration.ofSeconds(0L), Duration.ofSeconds(0L), Duration.ofNanos(-300000L), Duration.ofSeconds(0L), Duration.ofSeconds(0L), Duration.ofNanos(-300000L), Duration.ofSeconds(0L), Duration.ofNanos(-300000L), Duration.ofNanos(-300000L)}), (List)new .colon.colon((Object)new Tuple3((Object)new Tuple2((Object)Duration.ofDays(9999L), (Object)BoxesRunTime.boxToDouble((double)1.0E-4)), (Object)new Duration[]{Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L)}, (Object)new Duration[]{Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L)}), (List)new .colon.colon((Object)new Tuple3((Object)new Tuple2((Object)Duration.ofDays(9999L), (Object)scala.package$.MODULE$.BigDecimal().apply(1.0E-4)), (Object)new Duration[]{Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L), Duration.ofSeconds(8639136000000L)}, (Object)new Duration[]{Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L), Duration.ofMillis(86391360L)}), (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)x0$9 -> {
            IntervalExpressionsSuite.$anonfun$new$136(this, x0$9);
            return BoxedUnit.UNIT;
        }), new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
        this.test("SPARK-35778: Check multiply/divide of year-month intervals of any fields by numeric", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)new Tuple2((Object)Period.ofMonths(0), (Object)BoxesRunTime.boxToInteger((int)10)), (Object)new Period[]{Period.ofMonths(0), Period.ofMonths(0), Period.ofMonths(0)}, (Object)new Period[]{Period.ofMonths(0), Period.ofMonths(0), Period.ofMonths(0)}), new Tuple3((Object)new Tuple2((Object)Period.ofMonths(13), (Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Period[]{Period.ofMonths(13), Period.ofMonths(12), Period.ofMonths(13)}, (Object)new Period[]{Period.ofMonths(13), Period.ofMonths(12), Period.ofMonths(13)}), new Tuple3((Object)new Tuple2((Object)Period.ofMonths(-200), (Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Period[]{Period.ofMonths(-200), Period.ofMonths(-192), Period.ofMonths(-200)}, (Object)new Period[]{Period.ofMonths(-200), Period.ofMonths(-192), Period.ofMonths(-200)}), new Tuple3((Object)new Tuple2((Object)Period.ofYears(100), (Object)BoxesRunTime.boxToByte((byte)((byte)-1))), (Object)new Period[]{Period.ofMonths(-1200), Period.ofMonths(-1200), Period.ofMonths(-1200)}, (Object)new Period[]{Period.ofMonths(-1200), Period.ofMonths(-1200), Period.ofMonths(-1200)}), new Tuple3((Object)new Tuple2((Object)Period.ofYears(1), (Object)BoxesRunTime.boxToShort((short)((short)2))), (Object)new Period[]{Period.ofMonths(6), Period.ofMonths(6), Period.ofMonths(6)}, (Object)new Period[]{Period.ofMonths(24), Period.ofMonths(24), Period.ofMonths(24)}), new Tuple3((Object)new Tuple2((Object)Period.ofYears(-1), (Object)BoxesRunTime.boxToInteger((int)-3)), (Object)new Period[]{Period.ofMonths(4), Period.ofMonths(4), Period.ofMonths(4)}, (Object)new Period[]{Period.ofMonths(36), Period.ofMonths(36), Period.ofMonths(36)}), new Tuple3((Object)new Tuple2((Object)Period.ofMonths(-1000), (Object)BoxesRunTime.boxToFloat((float)0.5f)), (Object)new Period[]{Period.ofMonths(-2000), Period.ofMonths(-1992), Period.ofMonths(-2000)}, (Object)new Period[]{Period.ofMonths(-500), Period.ofMonths(-498), Period.ofMonths(-500)}), new Tuple3((Object)new Tuple2((Object)Period.ofYears(1000), (Object)BoxesRunTime.boxToDouble((double)100.0)), (Object)new Period[]{Period.ofYears(10), Period.ofYears(10), Period.ofYears(10)}, (Object)new Period[]{Period.ofMonths(1200000), Period.ofMonths(1200000), Period.ofMonths(1200000)}), new Tuple3((Object)new Tuple2((Object)Period.ofMonths(2), (Object)scala.package$.MODULE$.BigDecimal().apply(0.1)), (Object)new Period[]{Period.ofMonths(20), Period.ofMonths(0), Period.ofMonths(20)}, (Object)new Period[]{Period.ofMonths(0), Period.ofMonths(0), Period.ofMonths(0)})})).foreach((Function1 & Serializable)x0$12 -> {
            IntervalExpressionsSuite.$anonfun$new$142(this, x0$12);
            return BoxedUnit.UNIT;
        }), new Position("IntervalExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
        Statics.releaseFence();
    }
}

