/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HistogramNumeric;
import org.apache.spark.sql.catalyst.expressions.aggregate.NumericHistogramSerializer$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.NumericHistogram;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00114A\u0001C\u0005\u00011!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003BB\u0019\u0001A\u0003%\u0011\u0006C\u00043\u0001\t\u0007I\u0011B\u001a\t\r\t\u0003\u0001\u0015!\u00035\u0011\u0015\u0019\u0005\u0001\"\u0003E\u0011\u0015\t\u0006\u0001\"\u0003S\u0005UA\u0015n\u001d;pOJ\fWNT;nKJL7mU;ji\u0016T!AC\u0006\u0002\u0013\u0005<wM]3hCR,'B\u0001\u0007\u000e\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00059y\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005A\t\u0012aA:rY*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001IR\u0004\u0005\u0002\u001b75\t\u0011#\u0003\u0002\u001d#\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AH\u0011\u000e\u0003}Q!\u0001I\u0007\u0002\u000bAd\u0017M\\:\n\u0005\tz\"!C*R\u0019\"+G\u000e]3s\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\t\u0011\"\u0001\u0004sC:$w.\\\u000b\u0002SA\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0005kRLGNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#A\u0002*b]\u0012|W.A\u0004sC:$w.\u001c\u0011\u0002\t\u0011\fG/Y\u000b\u0002iA\u0019Q\u0007\u0010 \u000e\u0003YR!a\u000e\u001d\u0002\u0013%lW.\u001e;bE2,'BA\u001d;\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000e\u0002\u000b\u0013:$W\r_3e'\u0016\f\bCA A\u001b\u0005Q\u0014BA!;\u0005\rIe\u000e^\u0001\u0006I\u0006$\u0018\rI\u0001\u000eG>l\u0007/\u0019:f\u000bF,\u0018\r\\:\u0015\u0007\u0015Cu\n\u0005\u0002@\r&\u0011qI\u000f\u0002\b\u0005>|G.Z1o\u0011\u0015Ie\u00011\u0001K\u0003\u0011aWM\u001a;\u0011\u0005-kU\"\u0001'\u000b\u00051z\u0011B\u0001(M\u0005AqU/\\3sS\u000eD\u0015n\u001d;pOJ\fW\u000eC\u0003Q\r\u0001\u0007!*A\u0003sS\u001eDG/A\u0006bgN,'\u000f^#rk\u0006dWCA*[)\r!vk\u0019\t\u0003\u007fUK!A\u0016\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0013\u001e\u0001\r\u0001\u0017\t\u00033jc\u0001\u0001B\u0003\\\u000f\t\u0007ALA\u0001U#\ti\u0006\r\u0005\u0002@=&\u0011qL\u000f\u0002\b\u001d>$\b.\u001b8h!\ty\u0014-\u0003\u0002cu\t\u0019\u0011I\\=\t\u000bA;\u0001\u0019\u0001-")
public class HistogramNumericSuite
extends SparkFunSuite
implements SQLHelper {
    private final Random random;
    private final IndexedSeq<Object> data;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        HistogramNumericSuite histogramNumericSuite = this;
        synchronized (histogramNumericSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private Random random() {
        return this.random;
    }

    private IndexedSeq<Object> data() {
        return this.data;
    }

    private boolean compareEquals(NumericHistogram left, NumericHistogram right) {
        return left.getNumBins() == right.getNumBins() && left.getUsedBins() == right.getUsedBins() && RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), left.getUsedBins()).forall((Function1)(JFunction1.mcZI.sp & Serializable)i -> {
            NumericHistogram.Coord leftCoord = left.getBin(i);
            NumericHistogram.Coord rightCoord = right.getBin(i);
            return leftCoord.x == rightCoord.x && leftCoord.y == rightCoord.y;
        });
    }

    private <T> void assertEqual(T left, T right) {
        T $org_scalatest_assert_macro_right;
        T $org_scalatest_assert_macro_left;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals($org_scalatest_assert_macro_left = left, $org_scalatest_assert_macro_right = right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
    }

    public static final /* synthetic */ void $anonfun$new$5(int nBins$1, NumericHistogram buffer$2, Range group) {
        NumericHistogram partialBuffer = new NumericHistogram();
        partialBuffer.allocate(nBins$1);
        group.foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x -> partialBuffer.add((double)x));
        buffer$2.merge(partialBuffer);
    }

    public static final /* synthetic */ Assertion $anonfun$new$4(int valueCount$1, int nBins) {
        double sum;
        NumericHistogram buffer = new NumericHistogram();
        buffer.allocate(nBins);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), valueCount$1).grouped(nBins).foreach((Function1 & Serializable)group -> {
            HistogramNumericSuite.$anonfun$new$5(nBins, buffer, group);
            return BoxedUnit.UNIT;
        });
        double $org_scalatest_assert_macro_left = sum = BoxesRunTime.unboxToDouble((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), buffer.getUsedBins()).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> {
            NumericHistogram.Coord coord = buffer.getBin(i);
            return coord.x * coord.y;
        }).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        int $org_scalatest_assert_macro_right = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), valueCount$1).sum((Numeric)Numeric.IntIsIntegral$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= (double)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
    }

    public static final /* synthetic */ boolean $anonfun$new$17(Tuple3 check$ifrefutable$1) {
        Tuple3 tuple3 = check$ifrefutable$1;
        return tuple3 != null;
    }

    public static final /* synthetic */ void $anonfun$new$20(DoubleRef ys$1, Object row) {
        Object object = row;
        if (object instanceof GenericInternalRow) {
            GenericInternalRow genericInternalRow = (GenericInternalRow)object;
            Object[] $org_scalatest_assert_macro_left = genericInternalRow.values();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            ys$1.elem += BoxesRunTime.unboxToDouble((Object)genericInternalRow.values()[1]);
            return;
        }
        throw new MatchError(object);
    }

    public HistogramNumericSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.random = new Random();
        this.data = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10000).map((Function1)(JFunction1.mcII.sp & Serializable)x$1 -> this.random().nextInt(10000));
        this.test("serialize and de-serialize", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            NumericHistogram emptyBuffer = new NumericHistogram();
            emptyBuffer.allocate(5);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.compareEquals(emptyBuffer, NumericHistogramSerializer$.MODULE$.deserialize(NumericHistogramSerializer$.MODULE$.serialize(emptyBuffer))), "HistogramNumericSuite.this.compareEquals(emptyBuffer, NumericHistogramSerializer.deserialize(NumericHistogramSerializer.serialize(emptyBuffer)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            NumericHistogram buffer = new NumericHistogram();
            buffer.allocate(this.data().size() / 3);
            this.data().foreach((Function1)(JFunction1.mcVI.sp & Serializable)value -> buffer.add((double)value));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.compareEquals(buffer, NumericHistogramSerializer$.MODULE$.deserialize(NumericHistogramSerializer$.MODULE$.serialize(buffer))), "HistogramNumericSuite.this.compareEquals(buffer, NumericHistogramSerializer.deserialize(NumericHistogramSerializer.serialize(buffer)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            HistogramNumeric agg = new HistogramNumeric((Expression)new BoundReference(0, (DataType)DoubleType$.MODULE$, true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer), "HistogramNumericSuite.this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("class NumericHistogram, basic operations", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int valueCount = 5;
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})).foreach((Function1 & Serializable)nBins -> HistogramNumericSuite.$anonfun$new$4(valueCount, BoxesRunTime.unboxToInt((Object)nBins)));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("class HistogramNumeric, sql string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertEqual("histogram_numeric(a, 3)", new HistogramNumeric((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))).sql());
            this.assertEqual("histogram_numeric(DISTINCT a, 3)", new HistogramNumeric((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3))).sql(true));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("class HistogramNumeric, fails analysis if nBins is not a constant", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$1 = "a";
            IntegerType$ x$2 = IntegerType$.MODULE$;
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$2, x$3, x$4);
            AttributeReference attribute = new AttributeReference("a", (DataType)x$2, x$3, x$4, x$5, x$6);
            String x$7 = "b";
            IntegerType$ x$8 = IntegerType$.MODULE$;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$11 = AttributeReference$.MODULE$.apply$default$5("b", (DataType)x$8, x$9, x$10);
            Seq x$12 = AttributeReference$.MODULE$.apply$default$6("b", (DataType)x$8, x$9, x$10);
            HistogramNumeric wrongNB = new HistogramNumeric((Expression)attribute, (Expression)new AttributeReference("b", (DataType)x$8, x$9, x$10, x$11, x$12));
            this.assertEqual(wrongNB.checkInputDataTypes(), new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"`nb`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"INT\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)"\"b\"")}))));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("class HistogramNumeric, fails analysis if nBins is invalid", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$13 = "a";
            IntegerType$ x$14 = IntegerType$.MODULE$;
            boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$17 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$14, x$15, x$16);
            Seq x$18 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$14, x$15, x$16);
            AttributeReference attribute = new AttributeReference("a", (DataType)x$14, x$15, x$16, x$17, x$18);
            HistogramNumeric wrongNB = new HistogramNumeric((Expression)attribute, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)));
            this.assertEqual(wrongNB.checkInputDataTypes(), new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"nb"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)("[2, " + Integer.MAX_VALUE + "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)"1")}))));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("class HistogramNumeric, automatically add type casting for parameters", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            .colon.colon relations = new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).double()})), (List)new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).int()})), (List)new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).timestamp()})), (List)new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).dayTimeInterval()})), (List)new .colon.colon((Object)LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).yearMonthInterval()})), (List)Nil$.MODULE$)))));
            .colon.colon nBinsExpressions = new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)((byte)2))), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)100))), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1000L)), (List)Nil$.MODULE$))));
            relations.foreach(arg_0 -> HistogramNumericSuite.$anonfun$new$12$adapted(this, (Seq)nBinsExpressions, arg_0));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("HistogramNumeric: nulls in nBins expression", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String x$19 = "a";
            DoubleType$ x$20 = DoubleType$.MODULE$;
            boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$23 = AttributeReference$.MODULE$.apply$default$5("a", (DataType)x$20, x$21, x$22);
            Seq x$24 = AttributeReference$.MODULE$.apply$default$6("a", (DataType)x$20, x$21, x$22);
            this.assertEqual(new HistogramNumeric((Expression)new AttributeReference("a", (DataType)x$20, x$21, x$22, x$23, x$24), (Expression)new Literal(null, (DataType)IntegerType$.MODULE$)).checkInputDataTypes(), new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"nb")}))));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("class HistogramNumeric, null handling", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            HistogramNumeric agg = new HistogramNumeric((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)));
            GenericInternalRow buffer = new GenericInternalRow(new Object[1]);
            agg.initialize((InternalRow)buffer);
            Object $org_scalatest_assert_macro_left = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right = null;
            Object object = $org_scalatest_assert_macro_left;
            Object var6_5 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var6_5) : var6_5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
            Object $org_scalatest_assert_macro_left2 = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right2 = null;
            Object object2 = $org_scalatest_assert_macro_left2;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", null, !(object2 != null ? !object2.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
            Object $org_scalatest_assert_macro_left3 = agg.eval((InternalRow)buffer);
            Object $org_scalatest_assert_macro_right3 = null;
            Object object3 = $org_scalatest_assert_macro_left3;
            Object var14_13 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "!=", null, object3 == null ? var14_13 != null : !object3.equals(var14_13), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("class HistogramNumeric, exercise many different numeric input types", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputs = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)Literal$.MODULE$.apply(null), (Object)Literal$.MODULE$.apply(null), (Object)Literal$.MODULE$.apply(null)), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2))), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)2L))), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)0))), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)1))), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)2)))), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.0f)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)1.0f)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)2.0f))), new Tuple3((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)2.0))), new Tuple3((Object)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2017-03-01 00:00:00")), (Object)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2017-03-02 00:00:00")), (Object)Literal$.MODULE$.apply((Object)Timestamp.valueOf("2017-03-03 00:00:00"))), new Tuple3((Object)Literal$.MODULE$.apply((Object)Duration.ofSeconds(1111L)), (Object)Literal$.MODULE$.apply((Object)Duration.ofSeconds(1211L)), (Object)Literal$.MODULE$.apply((Object)Duration.ofSeconds(1311L))), new Tuple3((Object)Literal$.MODULE$.apply((Object)Period.ofMonths(10)), (Object)Literal$.MODULE$.apply((Object)Period.ofMonths(11)), (Object)Literal$.MODULE$.apply((Object)Period.ofMonths(12)))}));
            inputs.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HistogramNumericSuite.$anonfun$new$17(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
                Tuple3 tuple3;
                block5: {
                    DataType lhs;
                    DataType $org_scalatest_assert_macro_left;
                    HistogramNumeric aggPropagateOutputType;
                    Literal right;
                    Literal middle;
                    Literal left;
                    block7: {
                        DataType dataType;
                        block6: {
                            Object object;
                            StructType structType;
                            StructField[] structFieldArray;
                            tuple3 = x$2;
                            if (tuple3 == null) break block5;
                            left = (Literal)tuple3._1();
                            middle = (Literal)tuple3._2();
                            right = (Literal)tuple3._3();
                            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.HISTOGRAM_NUMERIC_PROPAGATE_INPUT_TYPE().key()), (Object)"false")}), (Function0 & Serializable)() -> {
                                block3: {
                                    DataType dataType;
                                    block2: {
                                        String string;
                                        Object object;
                                        StructType structType;
                                        StructField[] structFieldArray;
                                        HistogramNumeric aggDoubleOutputType = new HistogramNumeric((Expression)new BoundReference(0, left.dataType(), true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)));
                                        dataType = aggDoubleOutputType.dataType();
                                        if (!(dataType instanceof ArrayType)) break block2;
                                        ArrayType arrayType = (ArrayType)dataType;
                                        DataType dataType2 = arrayType.elementType();
                                        boolean bl = arrayType.containsNull();
                                        if (!(dataType2 instanceof StructType) || (structFieldArray = (structType = (StructType)dataType2).fields()) == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)structFieldArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) break block2;
                                        StructField structField = (StructField)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                                        StructField structField2 = (StructField)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                                        if (structField == null) break block2;
                                        String string2 = structField.name();
                                        DataType dataType3 = structField.dataType();
                                        if ("x".equals(string2) && DoubleType$.MODULE$.equals(dataType3) && structField2 != null && "y".equals(string = structField2.name()) && bl) break block3;
                                    }
                                    throw new MatchError((Object)dataType);
                                }
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(true, "aggDoubleOutputType.dataType match {\n  case (elementType: org.apache.spark.sql.types.DataType, containsNull: Boolean): org.apache.spark.sql.types.ArrayType((fields: Array[org.apache.spark.sql.types.StructField]): org.apache.spark.sql.types.StructType(scala.Array.unapplySeq[org.apache.spark.sql.types.StructField](<unapply-selector>) <unapply> ((name: String, dataType: org.apache.spark.sql.types.DataType, nullable: Boolean, metadata: org.apache.spark.sql.types.Metadata): org.apache.spark.sql.types.StructField(\"x\", org.apache.spark.sql.types.DoubleType, _, _), (name: String, dataType: org.apache.spark.sql.types.DataType, nullable: Boolean, metadata: org.apache.spark.sql.types.Metadata): org.apache.spark.sql.types.StructField(\"y\", _, _, _))), true) => true\n}", Prettifier$.MODULE$.default());
                                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
                            });
                            aggPropagateOutputType = new HistogramNumeric((Expression)new BoundReference(0, left.dataType(), true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)));
                            $org_scalatest_assert_macro_left = aggPropagateOutputType.left().dataType();
                            dataType = aggPropagateOutputType.dataType();
                            if (!(dataType instanceof ArrayType)) break block6;
                            ArrayType arrayType = (ArrayType)dataType;
                            DataType dataType2 = arrayType.elementType();
                            boolean bl = arrayType.containsNull();
                            if (!(dataType2 instanceof StructType) || (structFieldArray = (structType = (StructType)dataType2).fields()) == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)structFieldArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) break block6;
                            StructField structField = (StructField)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                            StructField structField2 = (StructField)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                            if (structField == null) break block6;
                            String string = structField.name();
                            lhs = structField.dataType();
                            boolean bl2 = structField.nullable();
                            if (!"x".equals(string) || !bl2 || structField2 == null) break block6;
                            String string2 = structField2.name();
                            boolean bl3 = structField2.nullable();
                            if ("y".equals(string2) && bl3 && bl) break block7;
                        }
                        throw new MatchError((Object)dataType);
                    }
                    DataType $org_scalatest_assert_macro_right = lhs;
                    DataType dataType = $org_scalatest_assert_macro_left;
                    DataType dataType3 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dataType3) : dataType3 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
                    GenericInternalRow buffer = new GenericInternalRow(new Object[1]);
                    aggPropagateOutputType.initialize((InternalRow)buffer);
                    aggPropagateOutputType.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{left.value()})));
                    aggPropagateOutputType.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{middle.value()})));
                    aggPropagateOutputType.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{right.value()})));
                    Object result = aggPropagateOutputType.eval((InternalRow)buffer);
                    DataType dataType4 = left.dataType();
                    NullType$ nullType$ = NullType$.MODULE$;
                    if (dataType4 == null ? nullType$ != null : !dataType4.equals(nullType$)) {
                        Object $org_scalatest_assert_macro_left2 = result;
                        Object $org_scalatest_assert_macro_right2 = null;
                        Object object = $org_scalatest_assert_macro_left2;
                        Object var34_30 = null;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "!=", null, object == null ? var34_30 != null : !object.equals(var34_30), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
                        DoubleRef ys = DoubleRef.create((double)0.0);
                        Object object2 = result;
                        if (!(object2 instanceof GenericArrayData)) {
                            throw new MatchError(object2);
                        }
                        GenericArrayData genericArrayData = (GenericArrayData)object2;
                        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps((Object)genericArrayData.array()), (Function1 & Serializable)row -> {
                            HistogramNumericSuite.$anonfun$new$20(ys, row);
                            return BoxedUnit.UNIT;
                        });
                        double $org_scalatest_assert_macro_left3 = ys.elem;
                        int $org_scalatest_assert_macro_right3 = 1;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)tuple3);
            });
        }, new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
    }

    public static final /* synthetic */ Object $anonfun$new$12$adapted(HistogramNumericSuite $this, Seq nBinsExpressions$1, LocalRelation relation) {
        nBinsExpressions$1.foreach((Function1 & Serializable)nBins -> {
            Alias alias;
            Expression agg;
            Expression analyzed;
            Seq $org_scalatest_assert_macro_left = relation.output();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            DataType relationAttributeType = ((Expression)relation.output().apply(0)).dataType();
            HistogramNumeric agg2 = new HistogramNumeric((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (Expression)nBins);
            Expression expression = analyzed = (Expression)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)relation).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{agg2}))).analyze().expressions().head();
            if (expression instanceof Alias && (agg = (alias = (Alias)expression).child()) instanceof HistogramNumeric) {
                HistogramNumeric histogramNumeric = (HistogramNumeric)agg;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(histogramNumeric.resolved(), "agg.resolved", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                DataType $org_scalatest_assert_macro_left2 = histogramNumeric.child().dataType();
                DataType $org_scalatest_assert_macro_right2 = relationAttributeType;
                DataType dataType = $org_scalatest_assert_macro_left2;
                DataType dataType2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
                DataType $org_scalatest_assert_macro_left3 = histogramNumeric.nBins().dataType();
                IntegerType$ $org_scalatest_assert_macro_right3 = IntegerType$.MODULE$;
                DataType dataType3 = $org_scalatest_assert_macro_left3;
                IntegerType$ integerType$ = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
                ArrayType expectedType = ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("x", relationAttributeType, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("y", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
                DataType $org_scalatest_assert_macro_left4 = histogramNumeric.dataType();
                ArrayType $org_scalatest_assert_macro_right4 = expectedType;
                DataType dataType4 = $org_scalatest_assert_macro_left4;
                ArrayType arrayType = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType4 != null ? !dataType4.equals(arrayType) : arrayType != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            }
            throw $this.fail(new Position("HistogramNumericSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        });
        return BoxedUnit.UNIT;
    }
}

